# -*- coding: utf-8 -*-

## This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#-------------------------------------------------------------------------------------------------------------
# BUGG
# A FAIRE
#   Eventuellement : ajouter des options :
#     Gérer les rotations de texte
#     Ombré de rectangle
#     Faire des guides magnétiques
#-------------------------------------------------------------------------------------------------------------

import os
import Image
import random
from math import *
from __builtin__ import hex as hexp
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from GlobalDefines import *
from DefText import *
from DocHelpDlg import *

#---------------------------------------------------------------------------------------------------------------------------------------------------------------
#class use to add interractive resize to QGraphicsRectItem object
#---------------------------------------------------------------------------------------------------------------------------------------------------------------
class QResizeGraphicsRectTextItem(QtGui.QGraphicsRectItem):
  
    def __init__(self,scene,RectItem,ZValue,TypeItem,xmax,ymax,parent=None):
      self.RectItem       = RectItem
      self.TypeItem       = TypeItem
      self.IsCapture      = False
      self.BlockRecursion = False       # Flag to stop recursion during resize

      x,y,w,h=self.CalcPosition(xmax,ymax)

      super(QResizeGraphicsRectTextItem,self).__init__(x,y,w,h,parent) #parent
      self.setPos(x,y)
      Rect=self.mapRectFromScene(QRectF(x,y,w,h))
      self.setRect(Rect)

      #define a pen for the rectangle
      col=QColor(255,0,0)
      pen=QPen(Qt.NoPen)
      self.setPen(pen)
      
      #define Mouse cursor
      if self.TypeItem==0:    self.setCursor(Qt.SizeFDiagCursor)  #Upper-Left corner
      elif self.TypeItem==1:  self.setCursor(Qt.SizeBDiagCursor)  #Upper-Right corner
      elif self.TypeItem==2:  self.setCursor(Qt.SizeBDiagCursor)  #Bottom-Left corner
      elif self.TypeItem==3:  self.setCursor(Qt.SizeFDiagCursor)  #Bottom-Right corner

      #define Flags
      try :
        self.setFlags(QGraphicsItem.ItemIsMovable | QGraphicsItem.ItemIsSelectable | QGraphicsItem.ItemSendsScenePositionChanges | QGraphicsItem.ItemSendsGeometryChanges)
      except :
        self.setFlags(QGraphicsItem.ItemIsMovable | QGraphicsItem.ItemIsSelectable)
      self.setZValue(ZValue)
      self.setData(0,QVariant("ResizeBox"))
      #Add this item to the scene
      scene.addItem(self)

    # Redefine paint to don't allow selection rectangle
    def paint(self,painter,option,widget=0):
      None

    def mousePressEvent(self, event):
      QGraphicsRectItem.mousePressEvent(self,event)
      self.IsCapture = True

    def mouseReleaseEvent(self, event):
      self.IsCapture = False
      QGraphicsRectItem.mouseReleaseEvent(self,event)

    def CalcPosition(self,xmax=-1,ymax=-1):
      ToMove=(xmax==-1 or ymax==-1)
      if ToMove:
        xmax = self.RectItem.scene().sceneRect().width()
        ymax = self.RectItem.scene().sceneRect().height()
      w = 3*(xmax/100)
      h = 3*(ymax/100)
      if self.TypeItem==0:      #Upper-Left corner
        x = self.RectItem.x*xmax
        y = self.RectItem.y*ymax
      elif self.TypeItem==1:    #Upper-Right corner
        x = self.RectItem.x*xmax+xmax*self.RectItem.w
        y = self.RectItem.y*ymax
      elif self.TypeItem==2:    #Bottom-Left corner
        x = self.RectItem.x*xmax
        y = self.RectItem.y*ymax+ymax*self.RectItem.h
      elif self.TypeItem==3:    #Bottom-Right corner
        x = self.RectItem.x*xmax+xmax*self.RectItem.w
        y = self.RectItem.y*ymax+ymax*self.RectItem.h
      x=x-w/2
      y=y-h/2
      if ToMove: 
        self.setPos(x,y)
        Rect=self.mapRectFromScene(QRectF(x,y,w,h))
        self.setRect(Rect)
      return x,y,w,h
      
    #function call each time a rectangle is move
    def itemChange(self, change, value):
      if (change == QtGui.QGraphicsItem.ItemPositionChange) :
        newpos = value.toPyObject()
        if self.IsCapture==True and self.BlockRecursion==False :
          self.BlockRecursion = True
          if self.TypeItem==0:    newpos=self.ResizeUpperLeft(newpos)     #Upper-Left corner
          elif self.TypeItem==1:  newpos=self.ResizeUpperRight(newpos)    #Upper-Right corner
          elif self.TypeItem==2:  newpos=self.ResizeBottomLeft(newpos)    #Bottom-Left corner
          elif self.TypeItem==3:  newpos=self.ResizeBottomRight(newpos)   #Bottom-Right corner
          xmax = self.RectItem.scene().sceneRect().width()
          ymax = self.RectItem.scene().sceneRect().height()
          self.RectItem.setPos(self.RectItem.x*xmax,self.RectItem.y*ymax)

          #move and resize rectangle
          Rect=self.RectItem.mapRectFromScene(QRectF(self.RectItem.x*xmax,self.RectItem.y*ymax,self.RectItem.w*xmax,self.RectItem.h*ymax))
          self.RectItem.setRect(Rect)
          self.RectItem.setupAlign()

          self.RectItem.TextDlg.SetupInterface()
          self.BlockRecursion = False
        return newpos
      else :
        return QtGui.QGraphicsRectItem.itemChange(self, change, value)

    #Resize from Upper-Left corner
    def ResizeUpperLeft(self,newpos) :
      x = newpos.x()
      y = newpos.y()
      #get max width and max height
      xmax = self.RectItem.scene().sceneRect().width()
      ymax = self.RectItem.scene().sceneRect().height()
      #calcul width and height
      w = 3*(xmax/100)
      h = 3*(ymax/100)
      #get value of opposite resize corner
      blockx = self.RectItem.BottomRight.pos().x()-w
      blocky = self.RectItem.BottomRight.pos().y()-h
      #crop rectangle in the image
      if x<-(w/2): x=-w/2
      if x>blockx: x=blockx
      if y < -(h/2): y=-(h/2)
      if y>blocky: y=blocky
      imgw=(self.RectItem.BottomRight.pos().x()-x)
      imgh=(self.RectItem.BottomRight.pos().y()-y)
      #Now, update RectItem
      self.RectItem.w=imgw/xmax
      self.RectItem.h=imgh/ymax
      self.RectItem.x=(x+(w/2))/xmax
      self.RectItem.y=(y+(h/2))/ymax
      #return new value
      newpos.setX(x)
      newpos.setY(y)
      return newpos
      
    #Resize from Upper-Right corner
    def ResizeUpperRight(self,newpos) :
      x = newpos.x()
      y = newpos.y()
      #get max width and max height
      xmax = self.RectItem.scene().sceneRect().width()
      ymax = self.RectItem.scene().sceneRect().height()
      #calcul width and height
      w = 3*(xmax/100)
      h = 3*(ymax/100)
      #get value of opposite resize corner
      blockx = self.RectItem.BottomLeft.pos().x()+w
      blocky = self.RectItem.BottomLeft.pos().y()-h
      #crop rectangle in the image
      if x<blockx: x=blockx
      if x>xmax-(w/2): x=xmax-(w/2)
      if y < -(h/2): y=-(h/2)
      if y>blocky: y=blocky
      imgw=(x-self.RectItem.BottomLeft.pos().x())
      imgh=(self.RectItem.BottomLeft.pos().y()-y)
      #Now, update RectItem
      self.RectItem.w=imgw/xmax
      self.RectItem.h=imgh/ymax
      self.RectItem.y=(y+(h/2))/ymax
      #return new value
      newpos.setX(x)
      newpos.setY(y)
      return newpos
      
    #Resize from Bottom-Left corner
    def ResizeBottomLeft(self,newpos) :
      x = newpos.x()
      y = newpos.y()
      #get max width and max height
      xmax = self.RectItem.scene().sceneRect().width()
      ymax = self.RectItem.scene().sceneRect().height()
      #calcul width and height
      w = 3*(xmax/100)
      h = 3*(ymax/100)
      #get value of opposite resize corner
      blockx = self.RectItem.UpperRight.pos().x()-w
      blocky = self.RectItem.UpperRight.pos().y()+h
      #crop rectangle in the image
      if x<-(w/2): x=-w/2
      if x>blockx: x=blockx
      if y<blocky: y=blocky
      if y>ymax-(h/2): y=ymax-(h/2)
      imgw=(self.RectItem.UpperRight.pos().x()-x)
      imgh=(y-self.RectItem.UpperRight.pos().y())
      #Now, update RectItem
      self.RectItem.w=imgw/xmax
      self.RectItem.h=imgh/ymax
      self.RectItem.x=(x+(w/2))/xmax
      #return new value
      newpos.setX(x)
      newpos.setY(y)
      return newpos
      
    #Resize from Bottom-Right corner
    def ResizeBottomRight(self,newpos) :
      x = newpos.x()
      y = newpos.y()
      #get max width and max height
      xmax = self.RectItem.scene().sceneRect().width()
      ymax = self.RectItem.scene().sceneRect().height()
      #calcul width and height
      w = 3*(xmax/100)
      h = 3*(ymax/100)
      #get value of opposite resize corner
      blockx = self.RectItem.UpperLeft.pos().x()+w
      blocky = self.RectItem.UpperLeft.pos().y()+h
      #crop rectangle in the image
      if x<blockx:      x=blockx
      if x>xmax-(w/2):  x=xmax-(w/2)
      if y<blocky:      y=blocky
      if y>ymax-(h/2):  y=ymax-(h/2)
      imgw=(x-self.RectItem.UpperLeft.pos().x())
      imgh=(y-self.RectItem.UpperLeft.pos().y())
      #Now, update RectItem
      self.RectItem.w=imgw/xmax
      self.RectItem.h=imgh/ymax
      #return new value
      newpos.setX(x)
      newpos.setY(y)
      return newpos

#---------------------------------------------------------------------------------------------------------------------------------------------------------------
#class use to crop rectangle into the image
#---------------------------------------------------------------------------------------------------------------------------------------------------------------
class QGraphicsRectTextItem(QtGui.QGraphicsRectItem):
    x               = 0.25
    y               = 0.25
    w               = 0.5
    h               = 0.5
    FontName        = ""       # font name
    FontSize        = ""       # font size
    FontColor       = 0        # font color
    FontShadowColor = "000000" # font shadow color
    IsBold          = False    # if bold mode
    IsItalic        = False    # if Italic mode
    IsUnderline     = False    # if Underline mode
    HAlign          = 0        # Horizontal alignement : 0=left, 1=center, 2=right, 3=justif
    VAlign          = 0        # Vertical alignement : 0=up, 1=center, 2=bottom
    StyleText       = 0        # Style : 0=normal, 1=outerline, 2=shadow up-left, 3=shadow up-right, 4=shadow bt-left, 5=shadow bt-right
    BackgroundForm  = 0        # Type of the form : 0=None, 1=Rectangle, 2=Ellipse
    BackgroundColor = "afafaf" # Color of the background of the form
    PenSize         = 0        # Width of the pen of the form
    PenColor        = "ffffff" # Color of the pen of the form

    # x,y,w,h are always give in %
    def __init__(self,scene,ZValue,x,y,w,h,xmax,ymax,IsImageWide,TextDlg,parent=None):
      self.x               = x                # X position in %
      self.y               = y                # Y position in %
      self.w               = w                # width in %
      self.h               = h                # height in %
      self.TextDlg         = TextDlg
      self.IsImageWide     = IsImageWide
      self.BlockZoomChange = False            # flag to block zoom changing during change % to pixel
      self.IsCapture       = False
      self.MarginX         = 1                # Margin depend on Pen size and form
      self.MarginY         = 1
      self.ZValue          = ZValue
      #Init item
      super(QGraphicsRectTextItem,self).__init__(self.x*xmax,self.y*ymax,xmax*w,ymax*h,parent)
      self.VideoporamaInstance=TextDlg.VideoporamaInstance
      if TextDlg.TypeText=="Image":
        self.FontName        = self.VideoporamaInstance.TBackGFontName         # font name
        self.FontSize        = self.VideoporamaInstance.TBackGFontSize         # font size
        self.FontColor       = self.VideoporamaInstance.TBackGFontColor        # font color
        self.FontShadowColor = self.VideoporamaInstance.TBackGFontShadowColor  # font shadow color
        self.IsBold          = self.VideoporamaInstance.TBackGIsBold           # if bold mode
        self.IsItalic        = self.VideoporamaInstance.TBackGIsItalic         # if Italic mode
        self.IsUnderline     = self.VideoporamaInstance.TBackGIsUnderline      # if Underline mode
        self.HAlign          = self.VideoporamaInstance.TBackGHAlign           # Horizontal alignement : 0=left, 1=center, 2=right, 3=justif
        self.VAlign          = self.VideoporamaInstance.TBackGVAlign           # Vertical alignement : 0=up, 1=center, 2=bottom
        self.StyleText       = self.VideoporamaInstance.TBackGStyleText        # Style : 0=normal, 1=outerline, 2=shadow up-left, 3=shadow up-right, 4=shadow bt-left, 5=shadow bt-right
        self.BackgroundForm  = self.VideoporamaInstance.TBackGBackgroundForm   # Type of the form : 0=None, 1=Rectangle, 2=Ellipse
        self.BackgroundStyle = self.VideoporamaInstance.TBackGBackgroundStyle  # Type of the background color : 0=Solid, 1=Transparent 90% 2=Transparent 80%..., 10=Transparent
        self.BackgroundColor = self.VideoporamaInstance.TBackGBackgroundColor  # Color of the background of the form
        self.PenSize         = self.VideoporamaInstance.TBackGPenSize          # Width of the pen of the form
        self.PenColor        = self.VideoporamaInstance.TBackGPenColor         # Color of the pen of the form
      elif TextDlg.TypeText=="ZoomPoint":
        self.FontName        = self.VideoporamaInstance.TShotFontName         # font name
        self.FontSize        = self.VideoporamaInstance.TShotFontSize         # font size
        self.FontColor       = self.VideoporamaInstance.TShotFontColor        # font color
        self.FontShadowColor = self.VideoporamaInstance.TShotFontShadowColor  # font shadow color
        self.IsBold          = self.VideoporamaInstance.TShotIsBold           # if bold mode
        self.IsItalic        = self.VideoporamaInstance.TShotIsItalic         # if Italic mode
        self.IsUnderline     = self.VideoporamaInstance.TShotIsUnderline      # if Underline mode
        self.HAlign          = self.VideoporamaInstance.TShotHAlign           # Horizontal alignement : 0=left, 1=center, 2=right, 3=justif
        self.VAlign          = self.VideoporamaInstance.TShotVAlign           # Vertical alignement : 0=up, 1=center, 2=bottom
        self.StyleText       = self.VideoporamaInstance.TShotStyleText        # Style : 0=normal, 1=outerline, 2=shadow up-left, 3=shadow up-right, 4=shadow bt-left, 5=shadow bt-right
        self.BackgroundForm  = self.VideoporamaInstance.TShotBackgroundForm   # Type of the form : 0=None, 1=Rectangle, 2=Ellipse
        self.BackgroundStyle = self.VideoporamaInstance.TShotBackgroundStyle  # Type of the background color : 0=Solid, 1=Transparent 90% 2=Transparent 80%..., 10=Transparent
        self.BackgroundColor = self.VideoporamaInstance.TShotBackgroundColor  # Color of the background of the form
        self.PenSize         = self.VideoporamaInstance.TShotPenSize          # Width of the pen of the form
        self.PenColor        = self.VideoporamaInstance.TShotPenColor         # Color of the pen of the form
      elif TextDlg.TypeText=="Overlaid":
        self.FontName        = self.VideoporamaInstance.TOverlaidFontName         # font name
        self.FontSize        = self.VideoporamaInstance.TOverlaidFontSize         # font size
        self.FontColor       = self.VideoporamaInstance.TOverlaidFontColor        # font color
        self.FontShadowColor = self.VideoporamaInstance.TOverlaidFontShadowColor  # font shadow color
        self.IsBold          = self.VideoporamaInstance.TOverlaidIsBold           # if bold mode
        self.IsItalic        = self.VideoporamaInstance.TOverlaidIsItalic         # if Italic mode
        self.IsUnderline     = self.VideoporamaInstance.TOverlaidIsUnderline      # if Underline mode
        self.HAlign          = self.VideoporamaInstance.TOverlaidHAlign           # Horizontal alignement : 0=left, 1=center, 2=right, 3=justif
        self.VAlign          = self.VideoporamaInstance.TOverlaidVAlign           # Vertical alignement : 0=up, 1=center, 2=bottom
        self.StyleText       = self.VideoporamaInstance.TOverlaidStyleText        # Style : 0=normal, 1=outerline, 2=shadow up-left, 3=shadow up-right, 4=shadow bt-left, 5=shadow bt-right
        self.BackgroundForm  = self.VideoporamaInstance.TOverlaidBackgroundForm   # Type of the form : 0=None, 1=Rectangle, 2=Ellipse
        self.BackgroundStyle = self.VideoporamaInstance.TOverlaidBackgroundStyle  # Type of the background color : 0=Solid, 1=Transparent 90% 2=Transparent 80%..., 10=Transparent
        self.BackgroundColor = self.VideoporamaInstance.TOverlaidBackgroundColor  # Color of the background of the form
        self.PenSize         = self.VideoporamaInstance.TOverlaidPenSize          # Width of the pen of the form
        self.PenColor        = self.VideoporamaInstance.TOverlaidPenColor         # Color of the pen of the form

      self.Text            = ""               # Plain text
      #define Mouse cursor
      self.setCursor(Qt.SizeAllCursor)
      #define a pen for the rectangle
      col=QColor(255,0,0)
      pen=QPen(col)
      pen.setWidth(2)
      self.setPen(pen)
      #define Flags
      try :
        self.setFlags(QGraphicsItem.ItemIsMovable|QGraphicsItem.ItemIsSelectable|QGraphicsItem.ItemClipsChildrenToShape | QGraphicsItem.ItemSendsScenePositionChanges|QGraphicsItem.ItemSendsGeometryChanges)
      except :
        self.setFlags(QGraphicsItem.ItemIsMovable|QGraphicsItem.ItemIsSelectable|QGraphicsItem.ItemClipsChildrenToShape)
      self.setZValue(ZValue)
      #Add a QVariant data
      self.setData(0,QVariant("Texte"))
      #Add this item to the scene
      scene.addItem(self)

    def FirstInit(self,Texte):
      self.Text=Texte
      xmax = self.scene().sceneRect().width()
      ymax = self.scene().sceneRect().height()
      #define position and size
      self.setPos(self.x*xmax,self.y*ymax)
      Rect=self.mapRectFromScene(QRectF(self.x*xmax,self.y*ymax,xmax*self.w,ymax*self.h))
      self.setRect(Rect)
      #create resize box
      self.UpperLeft  =QResizeGraphicsRectTextItem(self.scene(),self,self.ZValue+2,0,xmax,ymax)
      self.UpperRight =QResizeGraphicsRectTextItem(self.scene(),self,self.ZValue+2,1,xmax,ymax)
      self.BottomLeft =QResizeGraphicsRectTextItem(self.scene(),self,self.ZValue+2,2,xmax,ymax)
      self.BottomRight=QResizeGraphicsRectTextItem(self.scene(),self,self.ZValue+2,3,xmax,ymax)
      self.setupAlign()

    def setupAlign(self):
      xmax = self.scene().sceneRect().width()
      ymax = self.scene().sceneRect().height()
      # Calc default margin (depending on pensize)
      self.MarginX=float(self.PenSize)/2+1+1
      self.MarginY=float(self.PenSize)/2+1
      
      if self.BackgroundForm==2: # 2=Ellipse
        RX=float(self.w*xmax/2)
        RY=float(self.h*ymax/2)
        cos45=0.29  #1-cos(radians(45))
        sin45=0.29  #1-sin(radians(45))
        self.MarginX=self.MarginX+(cos45*RX)
        self.MarginY=self.MarginY+(sin45*RY)

    def mousePressEvent(self, event):
      QGraphicsRectItem.mousePressEvent(self,event)
      self.IsCapture = True

    def mouseReleaseEvent(self, event):
      self.IsCapture = False
      QGraphicsRectItem.mouseReleaseEvent(self,event)

    #function call each time a rectangle is move
    def itemChange(self, change, value):
      if (change == QtGui.QGraphicsItem.ItemPositionChange) :
        newpos = value.toPyObject()
        if self.IsCapture==True:
          xmax = self.scene().sceneRect().width()
          ymax = self.scene().sceneRect().height()
          self.x = newpos.x()/xmax
          self.y = newpos.y()/ymax
          #calcul width and height
          w = xmax*self.w
          h = ymax*self.h
          #crop rectangle in the image
          if self.x*xmax < 0: self.x=0
          if self.x*xmax > xmax-w: self.x=(xmax-w)/xmax
          if self.y*ymax < 0: self.y=0
          if self.y*ymax > ymax-h: self.y=(ymax-h)/ymax
          newpos.setX(self.x*xmax)
          newpos.setY(self.y*ymax)
          self.TextDlg.SetupInterface()
        return newpos
      else :
        return QtGui.QGraphicsRectItem.itemChange(self, change, value)        

    def paint(self,painter,option,widget=0):
      #self.TextDlg.ForcePaint()
      None

#---------------------------------------------------------------------------------------------------------------------------------------------------------------
# DefText dialog box
#---------------------------------------------------------------------------------------------------------------------------------------------------------------
class DefTextDlg(QDialog,Ui_DefTextDlg) :
    def __init__(self,timelineImage,itemNum,VideoporamaInstance,Type,parent=None):
      super(DefTextDlg, self).__init__(parent)
      self.setupUi(self)
      self.setModal(True)
      self.VideoporamaInstance=VideoporamaInstance
      self.timelineImage=timelineImage
      self.itemNum        = itemNum
      self.scene          = None
      self.TypeText       = Type
      self.BLOCKCHSIZE    = False         # For no size modification during SetupInterface
      self.NextZValue     = 100            # Next ZValue for next text item
      self.CurrentTextItem= None           # To correctly define interface (use only by GetSelectItem !)

      self.image          = None           # The brackground bitmap
      self.xmax           = 0
      self.ymax           = 0
      
      self.StopMAJSpinbox = False
      self.TextToolboxSize = None

    def FirstInit(self):
      # Load correct image with correct size
      self.PrepareImage()
      # Connect correct OK function depending on text type
      if self.TypeText=="Image":       self.VideoporamaInstance.qtapp.connect(self.Ok,SIGNAL("pressed()"),self.VideoporamaInstance.SEQ_DefTextOk)
      elif self.TypeText=="ZoomPoint": self.VideoporamaInstance.qtapp.connect(self.Ok,SIGNAL("pressed()"),self.VideoporamaInstance.TableZoomPoint_DefZoomPointTextOk)
      elif self.TypeText=="Overlaid":  self.VideoporamaInstance.qtapp.connect(self.Ok,SIGNAL("pressed()"),self.VideoporamaInstance.TAB_Montage_DefTextOk)
      # Preparing QGraphicsScene for interactive user action
      self.scene = QGraphicsScene()
      self.scene.setSceneRect(QRectF(0,0,self.xmax,self.ymax))
      self.SceneBox.setInteractive(True)
      self.SceneBox.setScene(self.scene)
      self.SceneBox.fitInView(QRectF(0,0,self.SceneBox.width(),self.SceneBox.height()),Qt.KeepAspectRatio)
      self.SceneBox.setDragMode(QGraphicsView.ScrollHandDrag)
      # Init check box
      self.textLeft.setCheckable(True)
      self.textCenter.setCheckable(True)
      self.textJustif.setCheckable(True)
      self.textRight.setCheckable(True)
      self.textUp.setCheckable(True)
      self.textVCenter.setCheckable(True)
      self.textBottom.setCheckable(True)
      # Init font
      sizes=QFontDatabase.standardSizes()
      Ssizes=QStringList()
      for size in sizes : Ssizes.append(unicode(size))
      self.fontSize.insertItems(0,Ssizes)
      self.fontSize.setCurrentIndex(6)
      # Init editor
      self.plainTextEdit.setWordWrapMode(QTextOption.NoWrap)
      # Init combo box FontEffect
      self.fontEffectCB.addItem(QIcon("icons/text_normal.png"),             self.VideoporamaInstance.qtapp.translate("DefTextDlg","No effect"))
      self.fontEffectCB.addItem(QIcon("icons/text_outerline.png"),          self.VideoporamaInstance.qtapp.translate("DefTextDlg","Outerline"))
      self.fontEffectCB.addItem(QIcon("icons/text_shadow_up_left.png"),     self.VideoporamaInstance.qtapp.translate("DefTextDlg","Shadow upper left"))
      self.fontEffectCB.addItem(QIcon("icons/text_shadow_up_right.png"),    self.VideoporamaInstance.qtapp.translate("DefTextDlg","Shadow upper right"))
      self.fontEffectCB.addItem(QIcon("icons/text_shadow_bottom_left.png"), self.VideoporamaInstance.qtapp.translate("DefTextDlg","Shadow bottom left"))
      self.fontEffectCB.addItem(QIcon("icons/text_shadow_bottom_right.png"),self.VideoporamaInstance.qtapp.translate("DefTextDlg","Shadow bottom right"))
      # Init combo box Background form
      self.BackgroundFormCB.addItem(QIcon("icons/Frame_TextOnly.png"),      self.VideoporamaInstance.qtapp.translate("DefTextDlg","Text only"))
      self.BackgroundFormCB.addItem(QIcon("icons/Frame_Rectangle.png"),     self.VideoporamaInstance.qtapp.translate("DefTextDlg","Rectangle"))
      self.BackgroundFormCB.addItem(QIcon("icons/Frame_RoundRec.png"),      self.VideoporamaInstance.qtapp.translate("DefTextDlg","Rounded Rectangle"))
      self.BackgroundFormCB.addItem(QIcon("icons/Frame_Buble.png"),         self.VideoporamaInstance.qtapp.translate("DefTextDlg","Buble"))
      self.BackgroundFormCB.addItem(QIcon("icons/Frame_Ellipse.png"),       self.VideoporamaInstance.qtapp.translate("DefTextDlg","Ellipse"))
      # Init combo box Background style
      self.BackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Solid"))
      self.BackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Transparent")+unicode(" 75%"))
      self.BackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Transparent")+unicode(" 50%"))
      self.BackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Transparent")+unicode(" 25%"))
      self.BackgroundStyleCB.addItem(self.VideoporamaInstance.qtapp.translate("DefTextDlg","Transparent"))
      # Init label and Spinbox depending on ConfDisplayUnit
      if self.VideoporamaInstance.ConfDisplayUnit=="0" :
        # Setup label associated with each edit
        self.PosXLabel.setText(self.VideoporamaInstance.qtapp.translate("main","%"))
        self.PosYLabel.setText(self.VideoporamaInstance.qtapp.translate("main","%"))
        self.WidthLabel.setText(self.VideoporamaInstance.qtapp.translate("main","%"))
        self.HeightLabel.setText(self.VideoporamaInstance.qtapp.translate("main","%"))
        #Display unit in %
        self.PosXEd.setDecimals(2)
        self.PosYEd.setDecimals(2)
        self.WidthEd.setDecimals(2)
        self.HeightEd.setDecimals(2)
      else :
        # Setup label associated with each edit
        self.PosXLabel.setText("/"+unicode(int(self.xmax)))
        self.PosYLabel.setText("/"+unicode(int(self.ymax)))
        self.WidthLabel.setText("/"+unicode(int(self.xmax)))
        self.HeightLabel.setText("/"+unicode(int(self.ymax)))
        #Display unit in pixel
        self.PosXEd.setDecimals(0)
        self.PosYEd.setDecimals(0)
        self.WidthEd.setDecimals(0)
        self.HeightEd.setDecimals(0)
      #--------------------------------------------------------------------
      # Set handler
      #--------------------------------------------------------------------
      self.VideoporamaInstance.qtapp.connect(self.scene,SIGNAL("selectionChanged()"),self.SelectionChangeEvent)
      self.VideoporamaInstance.qtapp.connect(self.Cancel,SIGNAL("pressed()"),self.onCancel)
      self.VideoporamaInstance.qtapp.connect(self.addText,SIGNAL("pressed()"),self.AddNewTextToImage)
      self.VideoporamaInstance.qtapp.connect(self.RemoveText,SIGNAL("pressed()"),self.RemoveTextFromImage)
      self.VideoporamaInstance.qtapp.connect(self.fontStyleCB,SIGNAL("currentFontChanged(QFont)"),self.ChangeFont)
      self.VideoporamaInstance.qtapp.connect(self.fontSize,SIGNAL("currentIndexChanged(QString)"),self.ChangeSizeFont)
      self.VideoporamaInstance.qtapp.connect(self.fontColorB,SIGNAL("pressed()"),self.SetTextColor)
      self.VideoporamaInstance.qtapp.connect(self.StyleShadowColorBt,SIGNAL("pressed()"),self.SetFontShadowColor)
      self.VideoporamaInstance.qtapp.connect(self.bold,SIGNAL("released()"),self.SetBold)
      self.VideoporamaInstance.qtapp.connect(self.Italic,SIGNAL("released()"),self.SetItalic)
      self.VideoporamaInstance.qtapp.connect(self.Souligne,SIGNAL("released()"),self.SetUnderline)
      self.VideoporamaInstance.qtapp.connect(self.textLeft,SIGNAL("pressed()"),self.SetTextLeft)
      self.VideoporamaInstance.qtapp.connect(self.textCenter,SIGNAL("pressed()"),self.SetTextCenter)
      self.VideoporamaInstance.qtapp.connect(self.textRight,SIGNAL("pressed()"),self.SetTextRight)
      self.VideoporamaInstance.qtapp.connect(self.textJustif,SIGNAL("pressed()"),self.SetTextJustif)
      self.VideoporamaInstance.qtapp.connect(self.textUp,SIGNAL("pressed()"),self.SetTextUp)
      self.VideoporamaInstance.qtapp.connect(self.textVCenter,SIGNAL("pressed()"),self.SetTextVCenter)
      self.VideoporamaInstance.qtapp.connect(self.textBottom,SIGNAL("pressed()"),self.SetTextBottom)
      self.VideoporamaInstance.qtapp.connect(self.fontEffectCB,SIGNAL("currentIndexChanged(int)"),self.ChangeStyleFont)
      self.VideoporamaInstance.qtapp.connect(self.PosXEd,SIGNAL("valueChanged(double)"),self.ChgPosXValue)
      self.VideoporamaInstance.qtapp.connect(self.PosYEd,SIGNAL("valueChanged(double)"),self.ChgPosYValue)
      self.VideoporamaInstance.qtapp.connect(self.WidthEd,SIGNAL("valueChanged(double)"),self.ChgWidthValue)
      self.VideoporamaInstance.qtapp.connect(self.HeightEd,SIGNAL("valueChanged(double)"),self.ChgHeightValue)
      self.VideoporamaInstance.qtapp.connect(self.BackgroundFormCB,SIGNAL("currentIndexChanged(int)"),self.ChangeBackgroundForm)
      self.VideoporamaInstance.qtapp.connect(self.BackgroundStyleCB,SIGNAL("currentIndexChanged(int)"),self.ChangeBackgroundStyle)
      self.VideoporamaInstance.qtapp.connect(self.BackgroundColorBt,SIGNAL("pressed()"),self.SetBackgroundColor)
      self.VideoporamaInstance.qtapp.connect(self.PenColorBt,SIGNAL("pressed()"),self.SetPenColor)
      self.VideoporamaInstance.qtapp.connect(self.PenSizeEd,SIGNAL("valueChanged(int)"),self.ChgPenSize)
      self.VideoporamaInstance.qtapp.connect(self.plainTextEdit,SIGNAL("textChanged()"),self.plainTextEditChange)
      self.VideoporamaInstance.qtapp.connect(self.HelpBt,SIGNAL("pressed()"),self.onHelp)
      self.SetupInterface()
      #Restore Window Size & Position (if needed)
      if self.VideoporamaInstance.RestoreWindowState=="1" and self.VideoporamaInstance.TextBoxWinRx>0:
        self.move(self.VideoporamaInstance.TextBoxWinRx,self.VideoporamaInstance.TextBoxWinRy)
        self.resize(self.VideoporamaInstance.TextBoxWinRw,self.VideoporamaInstance.TextBoxWinRh)
        if self.VideoporamaInstance.TextBoxIsMaximized!=0: self.showMaximized()

    def onHelp(self):
      self.docw=DocHelp(self.VideoporamaInstance,self.VideoporamaInstance.qtapp.translate("Documentation","en-textbox.html"),self)
      self.docw.show() 

    def SaveWindowPosition(self):
      # Save Windows size/position on exit
      if self.isMaximized():  
        self.VideoporamaInstance.TextBoxIsMaximized=1
      else : 
        self.VideoporamaInstance.TextBoxIsMaximized=0
        if isWindows():
          size=self.frameGeometry()
          self.VideoporamaInstance.TextBoxWinRx = size.x()
          self.VideoporamaInstance.TextBoxWinRy = size.y()
          size=self.geometry()
        else:
          size=self.geometry()
          self.VideoporamaInstance.TextBoxWinRx = size.x()-1 #It's not good but X11 don't give the real information !
          self.VideoporamaInstance.TextBoxWinRy = size.y()-self.VideoporamaInstance.win.menuBar().height()-5 #It's not good but X11 don't give the real information !
        self.VideoporamaInstance.TextBoxWinRw = size.width()
        self.VideoporamaInstance.TextBoxWinRh = size.height()

    def onCancel(self):
      self.close()

    def resizeEvent(self, event) :
      if self.scene==None: return

      self.SceneBox.fitInView(QRectF(0,0,self.SceneBox.width(),self.SceneBox.height()),Qt.KeepAspectRatio)

      # Load image with new size
      self.PrepareImage()

      #Move and resize all text items
      self.scene.setSceneRect(QRectF(0,0,self.xmax,self.ymax))
      for item in self.scene.items() :
        if (item.data(0).toString()) == "Texte" :
          item.xmax=self.xmax
          item.ymax=self.ymax
          item.setPos(item.x*self.xmax,item.y*self.ymax)
          Rect=item.mapRectFromScene(QRectF(item.x*self.xmax,item.y*self.ymax,item.w*self.xmax,item.h*self.ymax))
          item.setRect(Rect)
          #Move Resize Rectangle
          item.UpperLeft.CalcPosition()
          item.UpperRight.CalcPosition()
          item.BottomLeft.CalcPosition()
          item.BottomRight.CalcPosition()

      # Then paint the scene
      self.ForcePaint()

    def PrepareImage(self):
      #Calc display width in system unit
      self.xmax =float(self.SceneBox.width())
      if self.VideoporamaInstance.imgformat==1 :
        self.ymax=(self.xmax/16)*9
      else :
        self.ymax=(self.xmax/4)*3
      if self.ymax>self.SceneBox.height() :
        self.ymax=float(self.SceneBox.height())
        if self.VideoporamaInstance.imgformat==1 :
          self.xmax=(self.ymax/9)*16
        else :
          self.xmax=(self.ymax/3)*4

      # Load correct image depending on text type
      if self.TypeText=="Image":
        self.image,Unused = self.timelineImage.ToRenderImageForDisplay(-1,self.xmax,self.ymax,fx=0,fy=0,fw=0,fh=0,StopAtFullImage=True,DontRenderImageText=True,DontRenderZoomPointText=True)
      elif self.TypeText=="ZoomPoint":
        self.image,Unused = self.timelineImage.ToRenderImageForDisplay(self.itemNum,self.xmax,self.ymax,fx=0,fy=0,fw=0,fh=0,StopAtFullImage=False,DontRenderImageText=False,DontRenderZoomPointText=True)
      elif self.TypeText=="Overlaid":
        self.image,unusexmax,unuseymax=LoadAndPrepareImage("",self.VideoporamaInstance.ConfAutoRotate,self.VideoporamaInstance.ConfBgFile,self.VideoporamaInstance.ConfBgColor,self.VideoporamaInstance.imgformat,1)
        self.image=self.image.scaled(self.xmax,self.ymax,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)

    def ForcePaint(self):
      # Create xml to save items
      xmlText=self.ExportToXML()

      PixImage=QPixmap.fromImage(self.image).copy()
      ApplyTextToQImage(PixImage,xmlText,True)

      # Draw selection rectangle for selected item
      CurrentTextItem  = self.GetSelectItem()
      if CurrentTextItem!=None:
        p=QPainter(PixImage)
        xmax = float(PixImage.width())
        ymax = float(PixImage.height())

        #define a pen for the rectangle
        col=QColor(255,255,255)
        pen=QPen(col)
        pen.setWidth(1)
        pen.setJoinStyle(Qt.RoundJoin)
        pen.setStyle(Qt.DotLine)
        p.setPen(pen)
        p.setCompositionMode(QPainter.RasterOp_SourceXorDestination)
        p.drawRect(QRectF(CurrentTextItem.x*float(xmax),CurrentTextItem.y*float(ymax),CurrentTextItem.w*float(xmax),CurrentTextItem.h*float(ymax)))
        p.setCompositionMode(QPainter.CompositionMode_SourceOver)
        p.end()

      # Remove old image if exist
      for item in self.scene.items() :
        if item.data(0).toString()=="image" :
          self.scene.removeItem(item)

      # Add image to the background of the scene
      im=self.scene.addPixmap(PixImage)
      im.setData(0,QVariant(QString("image")))
      im.setZValue(20)
      im.setPos(0,0)

    def SelectionChangeEvent(self):
      self.SetupInterface()

    def GetSelectItem(self) :
      CurrentTextItem=None
      for item in self.scene.selectedItems() :
        data=item.data(0).toString()
        if data=="Texte" :       CurrentTextItem=item
        elif data=="ResizeBox" : CurrentTextItem=item.RectItem
      return CurrentTextItem

    def SetupInterface(self):
      if self.StopMAJSpinbox: return
      self.StopMAJSpinbox=True
      CurrentTextItem=self.GetSelectItem()
      self.RemoveText.setDisabled(CurrentTextItem==None)
      #Alignment
      self.textLeft.setDisabled(CurrentTextItem==None)
      self.textCenter.setDisabled(CurrentTextItem==None)
      self.textJustif.setDisabled(CurrentTextItem==None)
      self.textRight.setDisabled(CurrentTextItem==None)
      self.textUp.setDisabled(CurrentTextItem==None)
      self.textVCenter.setDisabled(CurrentTextItem==None)
      self.textBottom.setDisabled(CurrentTextItem==None)
      #Style
      self.fontStyleCB.setDisabled(CurrentTextItem==None)
      self.fontSize.setDisabled(CurrentTextItem==None)
      self.fontColorB.setDisabled(CurrentTextItem==None)
      self.bold.setDisabled(CurrentTextItem==None)
      self.Italic.setDisabled(CurrentTextItem==None)
      self.Souligne.setDisabled(CurrentTextItem==None)
      self.fontEffectCB.setDisabled(CurrentTextItem==None)
      #Editor
      self.plainTextEdit.setDisabled(CurrentTextItem==None)
      if CurrentTextItem!=None:
        if self.plainTextEdit.toPlainText()!=CurrentTextItem.Text : self.plainTextEdit.setPlainText(CurrentTextItem.Text)
        #Alignment
        self.textLeft.setChecked(CurrentTextItem.HAlign==0)
        self.textLeft.setDown(CurrentTextItem.HAlign==0)
        self.textCenter.setChecked(CurrentTextItem.HAlign==1)
        self.textCenter.setDown(CurrentTextItem.HAlign==1)
        self.textJustif.setChecked(CurrentTextItem.HAlign==3)
        self.textJustif.setDown(CurrentTextItem.HAlign==3)
        self.textRight.setChecked(CurrentTextItem.HAlign==2)
        self.textRight.setDown(CurrentTextItem.HAlign==2)
        self.textUp.setChecked(CurrentTextItem.VAlign==0)
        self.textUp.setDown(CurrentTextItem.VAlign==0)
        self.textVCenter.setChecked(CurrentTextItem.VAlign==1)
        self.textVCenter.setDown(CurrentTextItem.VAlign==1)
        self.textBottom.setChecked(CurrentTextItem.VAlign==2)
        self.textBottom.setDown(CurrentTextItem.VAlign==2)
        #Style
        self.StyleShadowColorBt.setDisabled(CurrentTextItem.StyleText==0)
        self.fontStyleCB.setCurrentIndex(self.fontStyleCB.findText(QString(CurrentTextItem.FontName)))
        self.BLOCKCHSIZE=True
        self.fontSize.setCurrentIndex(self.fontSize.findText(unicode(CurrentTextItem.FontSize)))
        self.BLOCKCHSIZE=False
        self.fontEffectCB.setCurrentIndex(CurrentTextItem.StyleText)
        self.bold.setChecked(CurrentTextItem.IsBold)
        self.bold.setDown(CurrentTextItem.IsBold)
        self.Italic.setChecked(CurrentTextItem.IsItalic)
        self.Italic.setDown(CurrentTextItem.IsItalic)
        self.Souligne.setChecked(CurrentTextItem.IsUnderline)
        self.Souligne.setDown(CurrentTextItem.IsUnderline)
      else:
        self.plainTextEdit.setPlainText("")
      #Frame options
      self.PosXEd.setDisabled(CurrentTextItem==None)
      self.PosYEd.setDisabled(CurrentTextItem==None)
      self.WidthEd.setDisabled(CurrentTextItem==None)
      self.HeightEd.setDisabled(CurrentTextItem==None)
      self.BackgroundFormCB.setDisabled(CurrentTextItem==None)
      if CurrentTextItem!=None:
        self.BackgroundStyleCB.setDisabled(CurrentTextItem.BackgroundForm==0)
        self.BackgroundColorBt.setDisabled(CurrentTextItem.BackgroundForm==0 or CurrentTextItem.BackgroundStyle==4)
        self.PenSizeEd.setDisabled(CurrentTextItem.BackgroundForm==0)
        self.PenColorBt.setDisabled(CurrentTextItem.BackgroundForm==0 or CurrentTextItem.PenSize==0)
        self.BackgroundFormCB.setCurrentIndex(CurrentTextItem.BackgroundForm)
        self.BackgroundStyleCB.setCurrentIndex(CurrentTextItem.BackgroundStyle)
        self.PenSizeEd.setValue(int(CurrentTextItem.PenSize))
        # Set value for X,Y,W and H
        if self.VideoporamaInstance.ConfDisplayUnit=="0" :
          # Define the value and max value (in %)
          self.PosXEd.setRange(0,99-CurrentTextItem.w*100)
          self.PosXEd.setValue(CurrentTextItem.x*100)
          self.PosXEd.setSingleStep(int(100/20)) 
          self.PosYEd.setRange(0,99-CurrentTextItem.h*100)
          self.PosYEd.setValue(CurrentTextItem.y*100)
          self.PosYEd.setSingleStep(int(100/20)) 
          self.WidthEd.setRange(3,99-CurrentTextItem.x*100)
          self.WidthEd.setValue(CurrentTextItem.w*100)
          self.WidthEd.setSingleStep(int(100/20)) 
          self.HeightEd.setRange(3,99-CurrentTextItem.y*100)
          self.HeightEd.setValue(CurrentTextItem.h*100)
          self.HeightEd.setSingleStep(int(100/20)) 
        else :
          # Define the value and max value (in pixel)
          self.PosXEd.setRange(0,self.xmax-CurrentTextItem.w*self.xmax)
          self.PosXEd.setValue(CurrentTextItem.x*self.xmax)
          self.PosXEd.setSingleStep(int(self.xmax/20))
          self.PosYEd.setRange(0,self.ymax-CurrentTextItem.h*self.ymax)
          self.PosYEd.setValue(CurrentTextItem.y*self.ymax)
          self.PosYEd.setSingleStep(int(self.ymax/20))
          self.WidthEd.setRange(3*(self.xmax/100),self.xmax-CurrentTextItem.x*self.xmax)
          self.WidthEd.setValue(CurrentTextItem.w*self.xmax)
          self.WidthEd.setSingleStep(int(self.xmax/20))
          self.HeightEd.setRange(3*(self.ymax/100),self.ymax-CurrentTextItem.y*self.ymax)
          self.HeightEd.setValue(CurrentTextItem.h*self.ymax)
          self.HeightEd.setSingleStep(int(self.ymax/20))
          # Setup label associated with each edit
          self.PosXLabel.setText(self.VideoporamaInstance.qtapp.translate("main","Pix")+"/"+unicode(int(self.xmax-CurrentTextItem.w*self.xmax)))
          self.PosYLabel.setText(self.VideoporamaInstance.qtapp.translate("main","Pix")+"/"+unicode(int(self.ymax-CurrentTextItem.h*self.ymax)))
          self.WidthLabel.setText(self.VideoporamaInstance.qtapp.translate("main","Pix")+"/"+unicode(int(self.xmax-CurrentTextItem.x*self.xmax)))
          self.HeightLabel.setText(self.VideoporamaInstance.qtapp.translate("main","Pix")+"/"+unicode(int(self.ymax-CurrentTextItem.y*self.ymax)))
      else :
          self.PosXEd.setValue(0)
          self.PosYEd.setValue(0)
          self.WidthEd.setValue(0)
          self.HeightEd.setValue(0)
          self.BackgroundColorBt.setDisabled(True)
          self.BackgroundStyleCB.setDisabled(True)
          self.PenSizeEd.setDisabled(True)
          self.PenColorBt.setDisabled(True)

      #Resize box for all text items
      for item in self.scene.items() :
        if (item.data(0).toString()) == "Texte" :
          CurrentTextItem=item
          #Move Resize Rectangle
          item.UpperLeft.CalcPosition()
          item.UpperRight.CalcPosition()
          item.BottomLeft.CalcPosition()
          item.BottomRight.CalcPosition()

      self.ForcePaint()
      self.StopMAJSpinbox=False

    def AddNewTextToImage(self) :
      self.xmax = self.scene.width()
      self.ymax = self.scene.height()
      text=QGraphicsRectTextItem(self.scene,self.NextZValue,0.50,0.50,0.25,0.25,self.xmax,self.ymax,self.VideoporamaInstance.imgformat==1,self)
      text.FirstInit("Text")
      #5 by 5 step for ZValue
      self.NextZValue+=5
      self.SetupInterface()

    def RemoveTextFromImage(self) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        self.scene.removeItem(CurrentTextItem.UpperLeft)
        self.scene.removeItem(CurrentTextItem.UpperRight)
        self.scene.removeItem(CurrentTextItem.BottomLeft)
        self.scene.removeItem(CurrentTextItem.BottomRight)
        self.scene.removeItem(CurrentTextItem)
        self.SetupInterface()

    def ImportXML(self,xmlPoint):
      if xmlPoint==None: return
      self.xmax = self.scene.width()
      self.ymax = self.scene.height()
      xmlText=xmlPoint.getElementsByTagName(u"Text")
      if xmlText.length>0 :
        xmlText =xmlText[0]
        TextNum =0
        while xmlText.getElementsByTagName(u"Text-"+unicode(TextNum)).length>0 :
          CurXMLText      =xmlText.getElementsByTagName(u"Text-"+unicode(TextNum))[0]
          x               =float(CurXMLText.getAttribute(u"X"))
          y               =float(CurXMLText.getAttribute(u"Y"))
          w               =float(CurXMLText.getAttribute(u"W"))
          h               =float(CurXMLText.getAttribute(u"H"))
          Texte           =FromHTML(CurXMLText.getAttribute(u"Text"))
          text=QGraphicsRectTextItem(self.scene,self.NextZValue,x,y,w,h,self.xmax,self.ymax,self.VideoporamaInstance.imgformat==1,self)
          text.FontName        =GetAttributeXML(CurXMLText,u"FontName",text.FontName)
          text.FontSize        =GetAttributeXMLInt(CurXMLText,u"FontSize",text.FontSize)
          text.FontColor       =GetAttributeXML(CurXMLText,u"FontColor",text.FontColor)
          text.FontShadowColor =GetAttributeXML(CurXMLText,u"FontShadowColor",text.FontShadowColor)
          text.IsBold          =GetAttributeXMLInt(CurXMLText,u"IsBold",0)!=0
          text.IsItalic        =GetAttributeXMLInt(CurXMLText,u"IsItalic",0)!=0
          text.IsUnderline     =GetAttributeXMLInt(CurXMLText,u"IsUnderline",0)!=0
          text.HAlign          =GetAttributeXMLInt(CurXMLText,u"HAlign",text.HAlign)
          text.VAlign          =GetAttributeXMLInt(CurXMLText,u"VAlign",text.VAlign)
          text.StyleText       =GetAttributeXMLInt(CurXMLText,u"StyleText",text.StyleText)
          text.BackgroundForm  =GetAttributeXMLInt(CurXMLText,u"BackgroundForm",text.BackgroundForm)
          text.BackgroundStyle =GetAttributeXMLInt(CurXMLText,u"BackgroundStyle",text.BackgroundStyle)
          text.BackgroundColor =GetAttributeXML(CurXMLText,u"BackgroundColor",text.BackgroundColor)
          text.PenSize         =GetAttributeXMLInt(CurXMLText,u"PenSize",text.PenSize)
          text.PenColor        =GetAttributeXML(CurXMLText,u"PenColor",text.PenColor)
          text.FirstInit(Texte)

          #5 by 5 step for ZValue
          self.NextZValue+=5
          TextNum+=1

    def ExportToXML(self):
      doc=Document()
      xmlRoot=doc.createElement(u"SaveXML")
      doc.appendChild(xmlRoot)
      xmlChild=doc.createElement(u"Text")
      xmlChild.setAttribute(u"Type",unicode(self.TypeText))
      TextNum=0
      for itemText in self.scene.items() :
        if (itemText.data(0).toString()) == "Texte" :
          xmlSubChild=doc.createElement(u"Text-"+unicode(TextNum))
          xmlSubChild.setAttribute(u"X",unicode(itemText.x))
          xmlSubChild.setAttribute(u"Y",unicode(itemText.y))
          xmlSubChild.setAttribute(u"W",unicode(itemText.w))
          xmlSubChild.setAttribute(u"H",unicode(itemText.h))
          xmlSubChild.setAttribute(u"Text",unicode(ToHTML(itemText.Text)))
          xmlSubChild.setAttribute(u"FontName",unicode(itemText.FontName))
          xmlSubChild.setAttribute(u"FontSize",unicode(itemText.FontSize))
          xmlSubChild.setAttribute(u"FontColor",unicode(itemText.FontColor))
          xmlSubChild.setAttribute(u"FontShadowColor",unicode(itemText.FontShadowColor))
          xmlSubChild.setAttribute(u"IsBold",unicode(int(itemText.IsBold)))
          xmlSubChild.setAttribute(u"IsItalic",unicode(int(itemText.IsItalic)))
          xmlSubChild.setAttribute(u"IsUnderline",unicode(int(itemText.IsUnderline)))
          xmlSubChild.setAttribute(u"HAlign",unicode(itemText.HAlign))
          xmlSubChild.setAttribute(u"VAlign",unicode(itemText.VAlign))
          xmlSubChild.setAttribute(u"StyleText",unicode(itemText.StyleText))
          xmlSubChild.setAttribute(u"BackgroundForm",unicode(itemText.BackgroundForm))
          xmlSubChild.setAttribute(u"BackgroundStyle",unicode(itemText.BackgroundStyle))
          xmlSubChild.setAttribute(u"BackgroundColor",unicode(itemText.BackgroundColor))
          xmlSubChild.setAttribute(u"PenSize",unicode(itemText.PenSize))
          xmlSubChild.setAttribute(u"PenColor",unicode(itemText.PenColor))
          TextNum+=1
          xmlChild.appendChild(xmlSubChild)
      xmlRoot.appendChild(xmlChild)
      if TextNum==0: return None
      else: return doc

    def plainTextEditChange(self):
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        CurrentTextItem.Text=self.plainTextEdit.toPlainText()
        self.SetupInterface()
        
    def ChgPosXValue(self,Value):
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        if self.StopMAJSpinbox: return
        if self.VideoporamaInstance.ConfDisplayUnit=="0" : Value=Value/100         # Define value in %
        else :                                             Value=Value/self.xmax   # Define value in Pixel
        CurrentTextItem.x=Value
        CurrentTextItem.setPos(CurrentTextItem.x*self.xmax,CurrentTextItem.y*self.ymax)
        Rect=CurrentTextItem.mapRectFromScene(QRectF(CurrentTextItem.x*self.xmax,CurrentTextItem.y*self.ymax,self.xmax*CurrentTextItem.w,self.ymax*CurrentTextItem.h))
        CurrentTextItem.setRect(Rect)
        self.SetupInterface()

    def ChgPosYValue(self,Value):
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        if self.StopMAJSpinbox: return
        if self.VideoporamaInstance.ConfDisplayUnit=="0" : Value=Value/100         # Define value in %
        else :                                             Value=Value/self.ymax   # Define value in Pixel
        CurrentTextItem.y=Value
        CurrentTextItem.setPos(CurrentTextItem.x*self.xmax,CurrentTextItem.y*self.ymax)
        Rect=CurrentTextItem.mapRectFromScene(QRectF(CurrentTextItem.x*self.xmax,CurrentTextItem.y*self.ymax,self.xmax*CurrentTextItem.w,self.ymax*CurrentTextItem.h))
        CurrentTextItem.setRect(Rect)
        self.SetupInterface()

    def ChgWidthValue(self,Value):
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        if self.StopMAJSpinbox: return
        if self.VideoporamaInstance.ConfDisplayUnit=="0" : Value=Value/100         # Define value in %
        else :                                             Value=Value/self.xmax   # Define value in Pixel
        CurrentTextItem.w=Value
        CurrentTextItem.setPos(CurrentTextItem.x*self.xmax,CurrentTextItem.y*self.ymax)
        Rect=CurrentTextItem.mapRectFromScene(QRectF(CurrentTextItem.x*self.xmax,CurrentTextItem.y*self.ymax,self.xmax*CurrentTextItem.w,self.ymax*CurrentTextItem.h))
        CurrentTextItem.setRect(Rect)
        self.SetupInterface()

    def ChgHeightValue(self,Value):
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        if self.StopMAJSpinbox: return
        if self.VideoporamaInstance.ConfDisplayUnit=="0" : Value=Value/100         # Define value in %
        else :                                             Value=Value/self.ymax   # Define value in Pixel
        CurrentTextItem.h=Value
        CurrentTextItem.setPos(CurrentTextItem.x*self.xmax,CurrentTextItem.y*self.ymax)
        Rect=CurrentTextItem.mapRectFromScene(QRectF(CurrentTextItem.x*self.xmax,CurrentTextItem.y*self.ymax,self.xmax*CurrentTextItem.w,self.ymax*CurrentTextItem.h))
        CurrentTextItem.setRect(Rect)
        self.SetupInterface()

    def ChangeFont(self,font) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        if font.family()!="":
          CurrentTextItem.FontName=font.family()
          self.SetupInterface()

    def ChangeSizeFont(self,size) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        if QString(size)!="" and self.BLOCKCHSIZE==False:
          CurrentTextItem.FontSize=int(size)
          self.SetupInterface()

    def ChangeStyleFont(self,Style) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        CurrentTextItem.StyleText=Style
        self.SetupInterface()

    def ChangeBackgroundForm(self,Style) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        CurrentTextItem.BackgroundForm=Style
        self.SetupInterface()

    def ChangeBackgroundStyle(self,Style) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        CurrentTextItem.BackgroundStyle=Style
        self.SetupInterface()

    def SetItalic(self) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        if CurrentTextItem.IsItalic==True: CurrentTextItem.IsItalic=False
        else: CurrentTextItem.IsItalic=True
        self.SetupInterface()

    def SetBold(self) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        if CurrentTextItem.IsBold==True: CurrentTextItem.IsBold=False
        else: CurrentTextItem.IsBold=True
        self.SetupInterface()

    def SetUnderline(self) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        if CurrentTextItem.IsUnderline==True: CurrentTextItem.IsUnderline=False
        else: CurrentTextItem.IsUnderline=True
        self.SetupInterface()

    def SetTextColor(self) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        color=QColorDialog.getColor(Qt.black,self)
        red=color.red()
        green=color.green()
        blue=color.blue()
        CurrentTextItem.FontColor=colortohex(red*65536+green*256+blue)
        self.SetupInterface()

    def SetFontShadowColor(self) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        color=QColorDialog.getColor(Qt.black,self)
        red=color.red()
        green=color.green()
        blue=color.blue()
        CurrentTextItem.FontShadowColor=colortohex(red*65536+green*256+blue)
        self.SetupInterface()

    def SetBackgroundColor(self) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        color=QColorDialog.getColor(Qt.black,self)
        red=color.red()
        green=color.green()
        blue=color.blue()
        CurrentTextItem.BackgroundColor=colortohex(red*65536+green*256+blue)
        self.SetupInterface()

    def SetPenColor(self) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        color=QColorDialog.getColor(Qt.black,self)
        red=color.red()
        green=color.green()
        blue=color.blue()
        CurrentTextItem.PenColor=colortohex(red*65536+green*256+blue)
        self.SetupInterface()

    def ChgPenSize(self,Value):
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        if self.StopMAJSpinbox: return
        CurrentTextItem.PenSize=Value
        self.SetupInterface()

    def SetTextHAlign(self,HAlign) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        CurrentTextItem.HAlign=HAlign
        self.SetupInterface()
      
    def SetTextLeft(self) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        CurrentTextItem.HAlign=0
        self.SetupInterface()

    def SetTextCenter(self) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        CurrentTextItem.HAlign=1
        self.SetupInterface()

    def SetTextRight(self) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        CurrentTextItem.HAlign=2
        self.SetupInterface()

    def SetTextJustif(self) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        CurrentTextItem.HAlign=3
        self.SetupInterface()
      
    def SetTextUp(self) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        CurrentTextItem.VAlign=0
        self.SetupInterface()

    def SetTextVCenter(self) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        CurrentTextItem.VAlign=1
        self.SetupInterface()

    def SetTextBottom(self) :
      CurrentTextItem=self.GetSelectItem()
      if CurrentTextItem!=None:
        CurrentTextItem.VAlign=2
        self.SetupInterface()
