/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.SyntaxAction;
import jsyntaxpane.util.Configuration;

public class JIndentAction
extends TextAction
implements SyntaxAction {
    public JIndentAction() {
        super("JINDENT");
    }

    public void actionPerformed(ActionEvent e) {
        JTextComponent target = this.getTextComponent(e);
        if (target != null) {
            SyntaxDocument sDoc = ActionUtils.getSyntaxDocument(target);
            int pos = target.getCaretPosition();
            int start = sDoc.getParagraphElement(pos).getStartOffset();
            String line = ActionUtils.getLine(target);
            String lineToPos = line.substring(0, pos - start);
            String prefix = ActionUtils.getIndent(line);
            int tabSize = ActionUtils.getTabSize(target);
            if (lineToPos.trim().endsWith("{")) {
                prefix = prefix + ActionUtils.SPACES.substring(0, tabSize);
            } else {
                String noComment = sDoc.getUncommentedText(start, pos);
                if (noComment.trim().endsWith("{")) {
                    prefix = prefix + ActionUtils.SPACES.substring(0, tabSize);
                }
            }
            target.replaceSelection("\n" + prefix);
        }
    }

    public void config(Configuration config, String prefix, String name) {
    }

    public TextAction getAction(String key) {
        return this;
    }
}

