// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQRDMLSH_4S_TRACE_AARCH64_H_
#define VIXL_SIM_SQRDMLSH_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_sqrdmlsh_4S[] = {
  0x00000000, 0x00000001, 0xffff8008, 0x00000020,
  0x00000000, 0xffffff82, 0x00000002, 0x00000020,
  0xffffff82, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0xffffff82, 0x00000020,
  0x00000000, 0x00000001, 0xffffff82, 0x00000020,
  0x00000000, 0x00000001, 0xffffff82, 0x00000020,
  0x00000000, 0x00000001, 0xffccce02, 0x00000020,
  0x00000000, 0xffffcd34, 0xffaaacad, 0x00000020,
  0xffffcd9a, 0xffffab56, 0xff800302, 0x00000020,
  0xffffac00, 0xffff8101, 0xff800302, 0x00000020,
  0xffff8200, 0xffff8101, 0xff800302, 0x00000020,
  0xffff8200, 0xffff8101, 0x007ffd02, 0x00000020,
  0xffff8200, 0x00007f01, 0x007ffd02, 0x00000020,
  0x00007e00, 0x00007f01, 0x00555357, 0x00000020,
  0x00007e00, 0x000054ac, 0x00333202, 0x00000020,
  0x00005400, 0x000032ce, 0x00000082, 0x00000020,
  0x00003266, 0x00000001, 0x00000082, 0x00000020,
  0x00000000, 0x00000001, 0x00000082, 0x00000020,
  0x00000000, 0x00000001, 0x00000082, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0xffffff81, 0x00000002, 0x00000020,
  0x00000000, 0xffffff81, 0x00000002, 0x00000020,
  0x00000000, 0xffffff81, 0x00000002, 0x0000001f,
  0x00000000, 0xffccce01, 0x00000002, 0x0000001f,
  0xffffcd33, 0xffaaacac, 0x00000002, 0x0000001f,
  0xffffab55, 0xff800301, 0x00000002, 0x0000001f,
  0xffff8100, 0xff800301, 0x00000002, 0x00000021,
  0xffff8100, 0xff800301, 0x00000002, 0x00000021,
  0xffff8100, 0x007ffd01, 0x00000002, 0x00000021,
  0x00007f00, 0x007ffd01, 0x00000002, 0x00000020,
  0x00007f00, 0x00555356, 0x00000002, 0x00000020,
  0x000054ab, 0x00333201, 0x00000002, 0x00000020,
  0x000032cd, 0x00000081, 0x00000002, 0x00000020,
  0x00000000, 0x00000081, 0x00000002, 0x00000020,
  0x00000000, 0x00000081, 0x00000002, 0x00000020,
  0x00000000, 0x00000081, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff80, 0x00000001, 0x00000002, 0x0000001f,
  0xffffff80, 0x00000001, 0x00000002, 0x0000001f,
  0xffffff80, 0x00000001, 0x00000001, 0x0000001e,
  0xffccce00, 0x00000001, 0x00000001, 0x0000001e,
  0xffaaacab, 0x00000001, 0x00000001, 0x0000001e,
  0xff800300, 0x00000001, 0x00000001, 0x00000022,
  0xff800300, 0x00000001, 0x00000003, 0x00000022,
  0xff800300, 0x00000001, 0x00000003, 0x00000021,
  0x007ffd00, 0x00000001, 0x00000003, 0x00000021,
  0x007ffd00, 0x00000001, 0x00000002, 0x00000020,
  0x00555355, 0x00000001, 0x00000002, 0x00000020,
  0x00333200, 0x00000001, 0x00000002, 0x00000020,
  0x00000080, 0x00000001, 0x00000002, 0x00000020,
  0x00000080, 0x00000001, 0x00000002, 0x00000020,
  0x00000080, 0x00000001, 0x00000002, 0x00000020,
  0x00000080, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000013,
  0x00000000, 0x00000001, 0x00000001, 0x0000000b,
  0x00000000, 0x00000001, 0x00000001, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000040,
  0x00000000, 0x00000000, 0x00000004, 0x00000040,
  0x00000000, 0x00000002, 0x00000004, 0x00000035,
  0x00000000, 0x00000002, 0x00000003, 0x0000002d,
  0x00000000, 0x00000002, 0x00000003, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0xffffffee,
  0x00000000, 0x00000001, 0xfffffff5, 0xffffffcd,
  0x00000000, 0x00000000, 0xffffffed, 0xffffffa3,
  0x00000000, 0x00000000, 0xffffffe2, 0xffffffa3,
  0xffffffff, 0xffffffff, 0xffffffe2, 0xffffffa3,
  0xffffffff, 0xffffffff, 0xffffffe2, 0x0000009d,
  0xffffffff, 0xffffffff, 0x00000022, 0x0000009d,
  0xffffffff, 0x00000003, 0x00000022, 0x00000073,
  0x00000001, 0x00000003, 0x00000017, 0x00000052,
  0x00000001, 0x00000002, 0x0000000f, 0x00000020,
  0x00000001, 0x00000002, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0xffffffee,
  0x00000000, 0x00000001, 0xffffffd0, 0xffffffcc,
  0x00000000, 0xfffffff4, 0xffffffaf, 0xffffffa2,
  0xffffffff, 0xffffffec, 0xffffff85, 0xffffffa2,
  0xffffffff, 0xffffffe1, 0xffffff85, 0xffffffa2,
  0xfffffffe, 0xffffffe1, 0xffffff85, 0x0000009e,
  0xfffffffe, 0xffffffe1, 0x0000007f, 0x0000009e,
  0xfffffffe, 0x00000021, 0x0000007f, 0x00000074,
  0x00000002, 0x00000021, 0x00000055, 0x00000052,
  0x00000002, 0x00000016, 0x00000034, 0x00000020,
  0x00000001, 0x0000000e, 0x00000002, 0x00000020,
  0x00000001, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0xffffffed,
  0x00000000, 0x00000001, 0xffffffd0, 0xffffffcb,
  0x00000000, 0xffffffcf, 0xffffffae, 0xffffffa1,
  0xfffffff3, 0xffffffae, 0xffffff84, 0xffffffa1,
  0xffffffeb, 0xffffff84, 0xffffff84, 0xffffffa1,
  0xffffffe0, 0xffffff84, 0xffffff84, 0x0000009f,
  0xffffffe0, 0xffffff84, 0x00000080, 0x0000009f,
  0xffffffe0, 0x0000007e, 0x00000080, 0x00000075,
  0x00000020, 0x0000007e, 0x00000056, 0x00000053,
  0x00000020, 0x00000054, 0x00000034, 0x00000020,
  0x00000015, 0x00000033, 0x00000002, 0x00000020,
  0x0000000d, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0xffffccee,
  0x00000000, 0x00000001, 0xffffffcf, 0xffffaacd,
  0x00000000, 0xffffffcf, 0xffffffad, 0xffff8023,
  0xffffffce, 0xffffffad, 0xffffff83, 0xffff8023,
  0xffffffad, 0xffffff83, 0xffffff83, 0xffff8023,
  0xffffff83, 0xffffff83, 0xffffff83, 0x0000801d,
  0xffffff83, 0xffffff83, 0x00000081, 0x0000801d,
  0xffffff83, 0x0000007f, 0x00000081, 0x00005573,
  0x0000007d, 0x0000007f, 0x00000057, 0x00003352,
  0x0000007d, 0x00000055, 0x00000035, 0x00000020,
  0x00000053, 0x00000033, 0x00000002, 0x00000020,
  0x00000032, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0xffffccee,
  0x00000000, 0x00000001, 0xffffccd0, 0xffffaacc,
  0x00000000, 0xffffffce, 0xffffaaaf, 0xffff8022,
  0xffffffce, 0xffffffac, 0xffff8005, 0xffff8022,
  0xffffffac, 0xffffff82, 0xffff8005, 0xffff8022,
  0xffffff82, 0xffffff82, 0xffff8005, 0x0000801e,
  0xffffff82, 0xffffff82, 0x00007fff, 0x0000801e,
  0xffffff82, 0x00000080, 0x00007fff, 0x00005574,
  0x0000007e, 0x00000080, 0x00005555, 0x00003352,
  0x0000007e, 0x00000056, 0x00003334, 0x00000020,
  0x00000054, 0x00000034, 0x00000002, 0x00000020,
  0x00000032, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0xffffcced,
  0x00000000, 0x00000001, 0xffffccd0, 0xffffaacb,
  0x00000000, 0xffffcccf, 0xffffaaae, 0xffff8021,
  0xffffffcd, 0xffffaaae, 0xffff8004, 0xffff8021,
  0xffffffab, 0xffff8004, 0xffff8004, 0xffff8021,
  0xffffff81, 0xffff8004, 0xffff8004, 0x0000801f,
  0xffffff81, 0xffff8004, 0x00008000, 0x0000801f,
  0xffffff81, 0x00007ffe, 0x00008000, 0x00005575,
  0x0000007f, 0x00007ffe, 0x00005556, 0x00003353,
  0x0000007f, 0x00005554, 0x00003334, 0x00000020,
  0x00000055, 0x00003333, 0x00000002, 0x00000020,
  0x00000033, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x0000001f,
  0x00000000, 0x00000001, 0x00000002, 0x00000013,
  0x00000000, 0x00000001, 0x00000002, 0xffffffee,
  0x00000000, 0x00000001, 0x00000002, 0xffffffee,
  0x00000000, 0x00000001, 0x00000002, 0xffffffed,
  0x00000000, 0x00000001, 0x00000002, 0xffffccee,
  0x00000000, 0x00000001, 0x00000002, 0xffffccee,
  0x00000000, 0x00000001, 0x00000002, 0xffffcced,
  0x00000000, 0x00000001, 0x00000002, 0xeb851ed8,
  0x00000000, 0x00000001, 0xffffcccf, 0xddddddfe,
  0x00000000, 0xffffcccf, 0xffffaaad, 0xccccccee,
  0xffffccce, 0xffffaaad, 0xffff8003, 0xccccccee,
  0xffffaaad, 0xffff8003, 0xffff8003, 0xcccccced,
  0xffff8003, 0xffff8003, 0xffff8003, 0x33333353,
  0xffff8003, 0xffff8003, 0x00008001, 0x33333353,
  0xffff8003, 0x00007fff, 0x00008001, 0x22222242,
  0x00007ffd, 0x00007fff, 0x00005557, 0x147ae168,
  0x00007ffd, 0x00005555, 0x00003335, 0x00003353,
  0x00005553, 0x00003333, 0x00000002, 0x00003353,
  0x00003332, 0x00000001, 0x00000002, 0x00003352,
  0x00000000, 0x00000001, 0x00000002, 0x00003352,
  0x00000000, 0x00000001, 0x00000002, 0x00000053,
  0x00000000, 0x00000001, 0x00000002, 0x00000053,
  0x00000000, 0x00000001, 0x00000002, 0x00000052,
  0x00000000, 0x00000001, 0x00000002, 0x00000052,
  0x00000000, 0x00000001, 0x00000002, 0x0000002d,
  0x00000000, 0x00000001, 0x00000002, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x0000001f,
  0x00000000, 0x00000001, 0x00000002, 0x0000001f,
  0x00000000, 0x00000001, 0x00000001, 0x0000000b,
  0x00000000, 0x00000001, 0xfffffff5, 0xffffffcd,
  0x00000000, 0x00000001, 0xffffffd0, 0xffffffcc,
  0x00000000, 0x00000001, 0xffffffd0, 0xffffffcb,
  0x00000000, 0x00000001, 0xffffffcf, 0xffffaacd,
  0x00000000, 0x00000001, 0xffffccd0, 0xffffaacc,
  0x00000000, 0x00000001, 0xffffccd0, 0xffffaacb,
  0x00000000, 0x00000001, 0xffffcccf, 0xddddddfe,
  0x00000000, 0x00000001, 0xeb851eba, 0xc71c71e8,
  0x00000000, 0xffffccce, 0xdddddde0, 0xaaaaaacd,
  0xffffccce, 0xffffaaac, 0xccccccd0, 0xaaaaaacc,
  0xffffaaac, 0xffff8002, 0xccccccd0, 0xaaaaaacc,
  0xffff8002, 0xffff8002, 0xcccccccf, 0x55555575,
  0xffff8002, 0xffff8002, 0x33333335, 0x55555574,
  0xffff8002, 0x00008000, 0x33333335, 0x38e38e59,
  0x00007ffe, 0x00008000, 0x22222224, 0x22222243,
  0x00007ffe, 0x00005556, 0x147ae14a, 0x00005575,
  0x00005554, 0x00003334, 0x00003335, 0x00005575,
  0x00003332, 0x00000001, 0x00003335, 0x00005574,
  0x00000000, 0x00000001, 0x00003334, 0x00005573,
  0x00000000, 0x00000001, 0x00003334, 0x00000075,
  0x00000000, 0x00000001, 0x00000035, 0x00000075,
  0x00000000, 0x00000001, 0x00000035, 0x00000074,
  0x00000000, 0x00000001, 0x00000034, 0x00000073,
  0x00000000, 0x00000001, 0x00000034, 0x00000035,
  0x00000000, 0x00000001, 0x0000000f, 0x00000022,
  0x00000000, 0x00000001, 0x00000003, 0x00000021,
  0x00000000, 0x00000001, 0x00000003, 0x00000021,
  0x00000000, 0x00000002, 0x00000003, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x0000001f,
  0x00000000, 0x00000001, 0x00000001, 0x0000001e,
  0x00000000, 0x00000001, 0x00000001, 0x00000000,
  0x00000000, 0x00000000, 0xffffffed, 0xffffffa3,
  0x00000000, 0xfffffff4, 0xffffffaf, 0xffffffa2,
  0x00000000, 0xffffffcf, 0xffffffae, 0xffffffa1,
  0x00000000, 0xffffffcf, 0xffffffad, 0xffff8023,
  0x00000000, 0xffffffce, 0xffffaaaf, 0xffff8022,
  0x00000000, 0xffffcccf, 0xffffaaae, 0xffff8021,
  0x00000000, 0xffffcccf, 0xffffaaad, 0xccccccee,
  0x00000000, 0xffffccce, 0xdddddde0, 0xaaaaaacd,
  0x00000000, 0xeb851eb9, 0xc71c71ca, 0x80000026,
  0xffffcccd, 0xdddddddf, 0xaaaaaaaf, 0x80000025,
  0xffffaaab, 0xcccccccf, 0xaaaaaaae, 0x80000024,
  0xffff8001, 0xcccccccf, 0xaaaaaaae, 0x7fffffff,
  0xffff8001, 0xccccccce, 0x55555557, 0x7fffffff,
  0xffff8001, 0x33333334, 0x55555556, 0x55555574,
  0x00007fff, 0x33333334, 0x38e38e3b, 0x33333353,
  0x00007fff, 0x22222223, 0x22222225, 0x00008020,
  0x00005555, 0x147ae149, 0x00005557, 0x0000801f,
  0x00003333, 0x00003334, 0x00005557, 0x0000801e,
  0x00000000, 0x00003334, 0x00005556, 0x0000801d,
  0x00000000, 0x00003333, 0x00005555, 0x000000a0,
  0x00000000, 0x00003333, 0x00000057, 0x0000009f,
  0x00000000, 0x00000034, 0x00000057, 0x0000009e,
  0x00000000, 0x00000034, 0x00000056, 0x0000009d,
  0x00000000, 0x00000033, 0x00000055, 0x00000040,
  0x00000000, 0x00000033, 0x00000017, 0x00000023,
  0x00000000, 0x0000000e, 0x00000004, 0x00000022,
  0x00000000, 0x00000002, 0x00000003, 0x00000021,
  0x00000001, 0x00000002, 0x00000003, 0x00000020,
  0x00000001, 0x00000002, 0x00000002, 0x0000001f,
  0x00000000, 0x00000001, 0x00000001, 0x0000001e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0xffffffe2, 0xffffffa3,
  0xffffffff, 0xffffffec, 0xffffff85, 0xffffffa2,
  0xfffffff3, 0xffffffae, 0xffffff84, 0xffffffa1,
  0xffffffce, 0xffffffad, 0xffffff83, 0xffff8023,
  0xffffffce, 0xffffffac, 0xffff8005, 0xffff8022,
  0xffffffcd, 0xffffaaae, 0xffff8004, 0xffff8021,
  0xffffccce, 0xffffaaad, 0xffff8003, 0xccccccee,
  0xffffccce, 0xffffaaac, 0xccccccd0, 0xaaaaaacc,
  0xffffcccd, 0xdddddddf, 0xaaaaaaaf, 0x80000025,
  0xeb851eb8, 0xc71c71c9, 0x80000008, 0x80000024,
  0xddddddde, 0xaaaaaaae, 0x80000007, 0x80000023,
  0xccccccce, 0xaaaaaaad, 0x80000006, 0x7fffffff,
  0xccccccce, 0xaaaaaaad, 0x7fffffff, 0x7fffffff,
  0xcccccccd, 0x55555556, 0x7ffffffe, 0x55555575,
  0x33333333, 0x55555555, 0x55555556, 0x33333353,
  0x33333333, 0x38e38e3a, 0x33333335, 0x00008020,
  0x22222222, 0x22222224, 0x00008002, 0x0000801f,
  0x147ae148, 0x00005556, 0x00008001, 0x0000801e,
  0x00003333, 0x00005556, 0x00008000, 0x0000801d,
  0x00003333, 0x00005555, 0x00007fff, 0x000000a0,
  0x00003332, 0x00005554, 0x00000082, 0x0000009f,
  0x00003332, 0x00000056, 0x00000081, 0x0000009e,
  0x00000033, 0x00000056, 0x00000080, 0x0000009d,
  0x00000033, 0x00000055, 0x0000007f, 0x00000040,
  0x00000032, 0x00000054, 0x00000022, 0x00000023,
  0x00000032, 0x00000016, 0x00000005, 0x00000022,
  0x0000000d, 0x00000003, 0x00000004, 0x00000021,
  0x00000002, 0x00000003, 0x00000003, 0x00000020,
  0x00000001, 0x00000002, 0x00000002, 0x0000001f,
  0x00000001, 0x00000001, 0x00000001, 0x0000001e,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xffffffe2, 0xffffffa3,
  0xffffffff, 0xffffffe1, 0xffffff85, 0xffffffa2,
  0xffffffeb, 0xffffff84, 0xffffff84, 0xffffffa1,
  0xffffffad, 0xffffff83, 0xffffff83, 0xffff8023,
  0xffffffac, 0xffffff82, 0xffff8005, 0xffff8022,
  0xffffffab, 0xffff8004, 0xffff8004, 0xffff8021,
  0xffffaaad, 0xffff8003, 0xffff8003, 0xcccccced,
  0xffffaaac, 0xffff8002, 0xccccccd0, 0xaaaaaacc,
  0xffffaaab, 0xcccccccf, 0xaaaaaaae, 0x80000024,
  0xddddddde, 0xaaaaaaae, 0x80000007, 0x80000023,
  0xc71c71c8, 0x80000007, 0x80000006, 0x80000022,
  0xaaaaaaad, 0x80000006, 0x80000005, 0x7fffffff,
  0xaaaaaaac, 0x80000005, 0x7fffffff, 0x7fffffff,
  0xaaaaaaac, 0x7ffffffe, 0x7fffffff, 0x55555575,
  0x55555555, 0x7ffffffd, 0x55555557, 0x33333354,
  0x55555554, 0x55555555, 0x33333335, 0x00008020,
  0x38e38e39, 0x33333334, 0x00008002, 0x0000801f,
  0x22222223, 0x00008001, 0x00008001, 0x0000801e,
  0x00005555, 0x00008000, 0x00008000, 0x0000801d,
  0x00005555, 0x00007fff, 0x00007fff, 0x000000a0,
  0x00005554, 0x00007ffe, 0x00000082, 0x0000009f,
  0x00005553, 0x00000081, 0x00000081, 0x0000009e,
  0x00000055, 0x00000080, 0x00000080, 0x0000009d,
  0x00000055, 0x0000007f, 0x0000007f, 0x00000040,
  0x00000054, 0x0000007e, 0x00000022, 0x00000023,
  0x00000053, 0x00000021, 0x00000005, 0x00000022,
  0x00000015, 0x00000004, 0x00000004, 0x00000021,
  0x00000003, 0x00000003, 0x00000003, 0x00000020,
  0x00000002, 0x00000002, 0x00000002, 0x00000021,
  0x00000001, 0x00000001, 0x00000001, 0x00000022,
  0x00000000, 0x00000000, 0x00000000, 0x00000040,
  0xffffffff, 0xffffffff, 0xffffffe2, 0x0000009d,
  0xfffffffe, 0xffffffe1, 0xffffff85, 0x0000009e,
  0xffffffe0, 0xffffff84, 0xffffff84, 0x0000009f,
  0xffffff83, 0xffffff83, 0xffffff83, 0x0000801d,
  0xffffff82, 0xffffff82, 0xffff8005, 0x0000801e,
  0xffffff81, 0xffff8004, 0xffff8004, 0x0000801f,
  0xffff8003, 0xffff8003, 0xffff8003, 0x33333353,
  0xffff8002, 0xffff8002, 0xcccccccf, 0x55555575,
  0xffff8001, 0xcccccccf, 0xaaaaaaae, 0x7fffffff,
  0xccccccce, 0xaaaaaaad, 0x80000006, 0x7fffffff,
  0xaaaaaaad, 0x80000006, 0x80000005, 0x7fffffff,
  0x80000006, 0x80000005, 0x80000004, 0x80000020,
  0x80000005, 0x80000004, 0x7fffffff, 0x80000021,
  0x80000004, 0x7fffffff, 0x7fffffff, 0xaaaaaaca,
  0x7ffffffd, 0x7ffffffe, 0x55555557, 0xccccccec,
  0x7ffffffc, 0x55555556, 0x33333336, 0xffff8020,
  0x55555554, 0x33333334, 0x00008002, 0xffff8021,
  0x33333333, 0x00008001, 0x00008001, 0xffff8022,
  0x00008000, 0x00008000, 0x00008000, 0xffff8023,
  0x00007fff, 0x00007fff, 0x00007fff, 0xffffffa0,
  0x00007ffe, 0x00007ffe, 0x00000082, 0xffffffa1,
  0x00007ffd, 0x00000081, 0x00000081, 0xffffffa2,
  0x00000080, 0x00000080, 0x00000080, 0xffffffa3,
  0x0000007f, 0x0000007f, 0x0000007f, 0x00000000,
  0x0000007e, 0x0000007e, 0x00000022, 0x0000001d,
  0x0000007d, 0x00000021, 0x00000005, 0x0000001e,
  0x00000020, 0x00000004, 0x00000004, 0x0000001f,
  0x00000003, 0x00000003, 0x00000001, 0x00000020,
  0x00000002, 0x00000002, 0x00000002, 0x00000021,
  0x00000001, 0x00000001, 0x00000003, 0x00000022,
  0x00000000, 0x00000000, 0x00000004, 0x00000040,
  0xffffffff, 0xffffffff, 0x00000022, 0x0000009d,
  0xfffffffe, 0xffffffe1, 0x0000007f, 0x0000009e,
  0xffffffe0, 0xffffff84, 0x00000080, 0x0000009f,
  0xffffff83, 0xffffff83, 0x00000081, 0x0000801d,
  0xffffff82, 0xffffff82, 0x00007fff, 0x0000801e,
  0xffffff81, 0xffff8004, 0x00008000, 0x0000801f,
  0xffff8003, 0xffff8003, 0x00008001, 0x33333353,
  0xffff8002, 0xffff8002, 0x33333335, 0x55555574,
  0xffff8001, 0xccccccce, 0x55555557, 0x7fffffff,
  0xccccccce, 0xaaaaaaad, 0x7fffffff, 0x7fffffff,
  0xaaaaaaac, 0x80000005, 0x7fffffff, 0x7fffffff,
  0x80000005, 0x80000004, 0x7fffffff, 0x80000021,
  0x80000004, 0x80000003, 0x80000002, 0x80000022,
  0x80000003, 0x7fffffff, 0x80000003, 0xaaaaaacb,
  0x7ffffffe, 0x7fffffff, 0xaaaaaaac, 0xccccccec,
  0x7ffffffd, 0x55555556, 0xccccccce, 0xffff8020,
  0x55555555, 0x33333335, 0xffff8002, 0xffff8021,
  0x33333333, 0x00008001, 0xffff8003, 0xffff8022,
  0x00008000, 0x00008000, 0xffff8004, 0xffff8023,
  0x00007fff, 0x00007fff, 0xffff8005, 0xffffffa0,
  0x00007ffe, 0x00007ffe, 0xffffff82, 0xffffffa1,
  0x00007ffd, 0x00000081, 0xffffff83, 0xffffffa2,
  0x00000080, 0x00000080, 0xffffff84, 0xffffffa3,
  0x0000007f, 0x0000007f, 0xffffff85, 0x00000000,
  0x0000007e, 0x0000007e, 0xffffffe2, 0x0000001d,
  0x0000007d, 0x00000021, 0xffffffff, 0x0000001e,
  0x00000020, 0x00000004, 0x00000000, 0x0000001f,
  0x00000003, 0xffffffff, 0x00000001, 0x00000020,
  0x00000002, 0x00000000, 0x00000002, 0x00000021,
  0x00000001, 0x00000001, 0x00000003, 0x00000021,
  0x00000000, 0x00000002, 0x00000004, 0x00000035,
  0xffffffff, 0x00000003, 0x00000022, 0x00000073,
  0xfffffffe, 0x00000021, 0x0000007f, 0x00000074,
  0xffffffe0, 0x0000007e, 0x00000080, 0x00000075,
  0xffffff83, 0x0000007f, 0x00000081, 0x00005573,
  0xffffff82, 0x00000080, 0x00007fff, 0x00005574,
  0xffffff81, 0x00007ffe, 0x00008000, 0x00005575,
  0xffff8003, 0x00007fff, 0x00008001, 0x22222242,
  0xffff8002, 0x00008000, 0x33333335, 0x38e38e59,
  0xffff8001, 0x33333334, 0x55555556, 0x55555574,
  0xcccccccd, 0x55555556, 0x7ffffffe, 0x55555575,
  0xaaaaaaac, 0x7ffffffe, 0x7fffffff, 0x55555575,
  0x80000004, 0x7fffffff, 0x7fffffff, 0xaaaaaaca,
  0x80000003, 0x7fffffff, 0x80000003, 0xaaaaaacb,
  0x80000002, 0x80000001, 0x80000004, 0xc71c71e6,
  0x7fffffff, 0x80000002, 0xaaaaaaad, 0xddddddfd,
  0x7ffffffe, 0xaaaaaaab, 0xccccccce, 0xffffaacb,
  0x55555555, 0xcccccccd, 0xffff8002, 0xffffaacb,
  0x33333334, 0xffff8001, 0xffff8003, 0xffffaacc,
  0x00008000, 0xffff8002, 0xffff8004, 0xffffaacd,
  0x00007fff, 0xffff8003, 0xffff8005, 0xffffffcb,
  0x00007ffe, 0xffff8004, 0xffffff82, 0xffffffcb,
  0x00007ffd, 0xffffff81, 0xffffff83, 0xffffffcc,
  0x00000080, 0xffffff82, 0xffffff84, 0xffffffcd,
  0x0000007f, 0xffffff83, 0xffffff85, 0x0000000b,
  0x0000007e, 0xffffff84, 0xffffffe2, 0x0000001e,
  0x0000007d, 0xffffffe1, 0xffffffff, 0x0000001f,
  0x00000020, 0xfffffffe, 0x00000000, 0x0000001f,
  0xfffffffd, 0xffffffff, 0x00000001, 0x00000020,
  0xfffffffe, 0x00000000, 0x00000002, 0x00000020,
  0xffffffff, 0x00000001, 0x00000003, 0x00000021,
  0x00000000, 0x00000002, 0x00000003, 0x0000002d,
  0x00000001, 0x00000003, 0x00000017, 0x00000052,
  0x00000002, 0x00000021, 0x00000055, 0x00000052,
  0x00000020, 0x0000007e, 0x00000056, 0x00000053,
  0x0000007d, 0x0000007f, 0x00000057, 0x00003352,
  0x0000007e, 0x00000080, 0x00005555, 0x00003352,
  0x0000007f, 0x00007ffe, 0x00005556, 0x00003353,
  0x00007ffd, 0x00007fff, 0x00005557, 0x147ae168,
  0x00007ffe, 0x00008000, 0x22222224, 0x22222243,
  0x00007fff, 0x33333334, 0x38e38e3b, 0x33333353,
  0x33333333, 0x55555555, 0x55555556, 0x33333353,
  0x55555555, 0x7ffffffd, 0x55555557, 0x33333354,
  0x7ffffffd, 0x7ffffffe, 0x55555557, 0xccccccec,
  0x7ffffffe, 0x7fffffff, 0xaaaaaaac, 0xccccccec,
  0x7fffffff, 0x80000002, 0xaaaaaaad, 0xddddddfd,
  0x80000000, 0x80000003, 0xc71c71c8, 0xeb851ed8,
  0x80000001, 0xaaaaaaac, 0xdddddddf, 0xffffcced,
  0xaaaaaaaa, 0xcccccccd, 0xffffaaad, 0xffffcced,
  0xcccccccc, 0xffff8001, 0xffffaaad, 0xffffccee,
  0xffff8000, 0xffff8002, 0xffffaaae, 0xffffccee,
  0xffff8001, 0xffff8003, 0xffffaaaf, 0xffffffed,
  0xffff8002, 0xffff8004, 0xffffffad, 0xffffffed,
  0xffff8003, 0xffffff81, 0xffffffad, 0xffffffee,
  0xffffff80, 0xffffff82, 0xffffffae, 0xffffffee,
  0xffffff81, 0xffffff83, 0xffffffaf, 0x00000013,
  0xffffff82, 0xffffff84, 0xffffffed, 0x0000001f,
  0xffffff83, 0xffffffe1, 0x00000000, 0x0000001f,
  0xffffffe0, 0xfffffffe, 0x00000001, 0x00000020,
  0xfffffffd, 0x00000000, 0x00000002, 0x00000020,
  0xfffffffe, 0x00000000, 0x00000002, 0x00000020,
  0xffffffff, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000002, 0x00000003, 0x00000020,
  0x00000001, 0x00000002, 0x0000000f, 0x00000020,
  0x00000002, 0x00000016, 0x00000034, 0x00000020,
  0x00000020, 0x00000054, 0x00000034, 0x00000020,
  0x0000007d, 0x00000055, 0x00000035, 0x00000020,
  0x0000007e, 0x00000056, 0x00003334, 0x00000020,
  0x0000007f, 0x00005554, 0x00003334, 0x00000020,
  0x00007ffd, 0x00005555, 0x00003335, 0x00003353,
  0x00007ffe, 0x00005556, 0x147ae14a, 0x00005575,
  0x00007fff, 0x22222223, 0x22222225, 0x00008020,
  0x33333333, 0x38e38e3a, 0x33333335, 0x00008020,
  0x55555554, 0x55555555, 0x33333335, 0x00008020,
  0x7ffffffc, 0x55555556, 0x33333336, 0xffff8020,
  0x7ffffffd, 0x55555556, 0xccccccce, 0xffff8020,
  0x7ffffffe, 0xaaaaaaab, 0xccccccce, 0xffffaacb,
  0x80000001, 0xaaaaaaac, 0xdddddddf, 0xffffcced,
  0x80000002, 0xc71c71c7, 0xeb851eba, 0x00000020,
  0xaaaaaaab, 0xddddddde, 0xffffcccf, 0x00000020,
  0xcccccccc, 0xffffaaac, 0xffffcccf, 0x00000020,
  0xffff8000, 0xffffaaac, 0xffffccd0, 0x00000020,
  0xffff8001, 0xffffaaad, 0xffffccd0, 0x00000020,
  0xffff8002, 0xffffaaae, 0xffffffcf, 0x00000020,
  0xffff8003, 0xffffffac, 0xffffffcf, 0x00000020,
  0xffffff80, 0xffffffac, 0xffffffd0, 0x00000020,
  0xffffff81, 0xffffffad, 0xffffffd0, 0x00000020,
  0xffffff82, 0xffffffae, 0xfffffff5, 0x00000020,
  0xffffff83, 0xffffffec, 0x00000001, 0x00000020,
  0xffffffe0, 0xffffffff, 0x00000001, 0x00000020,
  0xfffffffe, 0x00000000, 0x00000002, 0x00000020,
  0xffffffff, 0x00000001, 0x00000002, 0x00000020,
  0xffffffff, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000002, 0x00000020,
  0x00000001, 0x0000000e, 0x00000002, 0x00000020,
  0x00000015, 0x00000033, 0x00000002, 0x00000020,
  0x00000053, 0x00000033, 0x00000002, 0x00000020,
  0x00000054, 0x00000034, 0x00000002, 0x00000020,
  0x00000055, 0x00003333, 0x00000002, 0x00000020,
  0x00005553, 0x00003333, 0x00000002, 0x00003353,
  0x00005554, 0x00003334, 0x00003335, 0x00005575,
  0x00005555, 0x147ae149, 0x00005557, 0x0000801f,
  0x22222222, 0x22222224, 0x00008002, 0x0000801f,
  0x38e38e39, 0x33333334, 0x00008002, 0x0000801f,
  0x55555554, 0x33333334, 0x00008002, 0xffff8021,
  0x55555555, 0x33333335, 0xffff8002, 0xffff8021,
  0x55555555, 0xcccccccd, 0xffff8002, 0xffffaacb,
  0xaaaaaaaa, 0xcccccccd, 0xffffaaad, 0xffffcced,
  0xaaaaaaab, 0xddddddde, 0xffffcccf, 0x00000020,
  0xc71c71c6, 0xeb851eb9, 0x00000002, 0x00000020,
  0xdddddddd, 0xffffccce, 0x00000002, 0x00000020,
  0xffffaaab, 0xffffccce, 0x00000002, 0x00000020,
  0xffffaaab, 0xffffcccf, 0x00000002, 0x00000020,
  0xffffaaac, 0xffffcccf, 0x00000002, 0x00000020,
  0xffffaaad, 0xffffffce, 0x00000002, 0x00000020,
  0xffffffab, 0xffffffce, 0x00000002, 0x00000020,
  0xffffffab, 0xffffffcf, 0x00000002, 0x00000020,
  0xffffffac, 0xffffffcf, 0x00000002, 0x00000020,
  0xffffffad, 0xfffffff4, 0x00000002, 0x00000020,
  0xffffffeb, 0x00000000, 0x00000002, 0x00000020,
  0xffffffff, 0x00000001, 0x00000002, 0x00000020,
  0xffffffff, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000001, 0x00000002, 0x00000020,
  0x0000000d, 0x00000001, 0x00000002, 0x00000020,
  0x00000032, 0x00000001, 0x00000002, 0x00000020,
  0x00000032, 0x00000001, 0x00000002, 0x00000020,
  0x00000033, 0x00000001, 0x00000002, 0x00000020,
  0x00003332, 0x00000001, 0x00000002, 0x00003352,
  0x00003332, 0x00000001, 0x00003335, 0x00005574,
  0x00003333, 0x00003334, 0x00005557, 0x0000801e,
  0x147ae148, 0x00005556, 0x00008001, 0x0000801e,
  0x22222223, 0x00008001, 0x00008001, 0x0000801e,
  0x33333333, 0x00008001, 0x00008001, 0xffff8022,
  0x33333333, 0x00008001, 0xffff8003, 0xffff8022,
  0x33333334, 0xffff8001, 0xffff8003, 0xffffaacc,
  0xcccccccc, 0xffff8001, 0xffffaaad, 0xffffccee,
  0xcccccccc, 0xffffaaac, 0xffffcccf, 0x00000020,
  0xdddddddd, 0xffffccce, 0x00000002, 0x00000020,
  0xeb851eb8, 0x00000001, 0x00000002, 0x00000020,
  0xffffcccd, 0x00000001, 0x00000002, 0x00000020,
  0xffffcccd, 0x00000001, 0x00000002, 0x00000020,
  0xffffccce, 0x00000001, 0x00000002, 0x00000020,
  0xffffccce, 0x00000001, 0x00000002, 0x00000020,
  0xffffffcd, 0x00000001, 0x00000002, 0x00000020,
  0xffffffcd, 0x00000001, 0x00000002, 0x00000020,
  0xffffffce, 0x00000001, 0x00000002, 0x00000020,
  0xffffffce, 0x00000001, 0x00000002, 0x00000020,
  0xfffffff3, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00003352,
  0x00000000, 0x00000001, 0x00003334, 0x00005573,
  0x00000000, 0x00003334, 0x00005556, 0x0000801d,
  0x00003333, 0x00005556, 0x00008000, 0x0000801d,
  0x00005555, 0x00008000, 0x00008000, 0x0000801d,
  0x00008000, 0x00008000, 0x00008000, 0xffff8023,
  0x00008000, 0x00008000, 0xffff8004, 0xffff8023,
  0x00008000, 0xffff8002, 0xffff8004, 0xffffaacd,
  0xffff8000, 0xffff8002, 0xffffaaae, 0xffffccee,
  0xffff8000, 0xffffaaac, 0xffffccd0, 0x00000020,
  0xffffaaab, 0xffffccce, 0x00000002, 0x00000020,
  0xffffcccd, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000053,
  0x00000000, 0x00000001, 0x00003334, 0x00000075,
  0x00000000, 0x00003333, 0x00005555, 0x000000a0,
  0x00003333, 0x00005555, 0x00007fff, 0x000000a0,
  0x00005555, 0x00007fff, 0x00007fff, 0x000000a0,
  0x00007fff, 0x00007fff, 0x00007fff, 0xffffffa0,
  0x00007fff, 0x00007fff, 0xffff8005, 0xffffffa0,
  0x00007fff, 0xffff8003, 0xffff8005, 0xffffffcb,
  0xffff8001, 0xffff8003, 0xffffaaaf, 0xffffffed,
  0xffff8001, 0xffffaaad, 0xffffccd0, 0x00000020,
  0xffffaaab, 0xffffcccf, 0x00000002, 0x00000020,
  0xffffcccd, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000053,
  0x00000000, 0x00000001, 0x00000035, 0x00000075,
  0x00000000, 0x00003333, 0x00000057, 0x0000009f,
  0x00003332, 0x00005554, 0x00000082, 0x0000009f,
  0x00005554, 0x00007ffe, 0x00000082, 0x0000009f,
  0x00007ffe, 0x00007ffe, 0x00000082, 0xffffffa1,
  0x00007ffe, 0x00007ffe, 0xffffff82, 0xffffffa1,
  0x00007ffe, 0xffff8004, 0xffffff82, 0xffffffcb,
  0xffff8002, 0xffff8004, 0xffffffad, 0xffffffed,
  0xffff8002, 0xffffaaae, 0xffffffcf, 0x00000020,
  0xffffaaac, 0xffffcccf, 0x00000002, 0x00000020,
  0xffffccce, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000052,
  0x00000000, 0x00000001, 0x00000035, 0x00000074,
  0x00000000, 0x00000034, 0x00000057, 0x0000009e,
  0x00003332, 0x00000056, 0x00000081, 0x0000009e,
  0x00005553, 0x00000081, 0x00000081, 0x0000009e,
  0x00007ffd, 0x00000081, 0x00000081, 0xffffffa2,
  0x00007ffd, 0x00000081, 0xffffff83, 0xffffffa2,
  0x00007ffd, 0xffffff81, 0xffffff83, 0xffffffcc,
  0xffff8003, 0xffffff81, 0xffffffad, 0xffffffee,
  0xffff8003, 0xffffffac, 0xffffffcf, 0x00000020,
  0xffffaaad, 0xffffffce, 0x00000002, 0x00000020,
  0xffffccce, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000052,
  0x00000000, 0x00000001, 0x00000034, 0x00000073,
  0x00000000, 0x00000034, 0x00000056, 0x0000009d,
  0x00000033, 0x00000056, 0x00000080, 0x0000009d,
  0x00000055, 0x00000080, 0x00000080, 0x0000009d,
  0x00000080, 0x00000080, 0x00000080, 0xffffffa3,
  0x00000080, 0x00000080, 0xffffff84, 0xffffffa3,
  0x00000080, 0xffffff82, 0xffffff84, 0xffffffcd,
  0xffffff80, 0xffffff82, 0xffffffae, 0xffffffee,
  0xffffff80, 0xffffffac, 0xffffffd0, 0x00000020,
  0xffffffab, 0xffffffce, 0x00000002, 0x00000020,
  0xffffffcd, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x0000002d,
  0x00000000, 0x00000001, 0x00000034, 0x00000035,
  0x00000000, 0x00000033, 0x00000055, 0x00000040,
  0x00000033, 0x00000055, 0x0000007f, 0x00000040,
  0x00000055, 0x0000007f, 0x0000007f, 0x00000040,
  0x0000007f, 0x0000007f, 0x0000007f, 0x00000000,
  0x0000007f, 0x0000007f, 0xffffff85, 0x00000000,
  0x0000007f, 0xffffff83, 0xffffff85, 0x0000000b,
  0xffffff81, 0xffffff83, 0xffffffaf, 0x00000013,
  0xffffff81, 0xffffffad, 0xffffffd0, 0x00000020,
  0xffffffab, 0xffffffcf, 0x00000002, 0x00000020,
  0xffffffcd, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000021,
  0x00000000, 0x00000001, 0x0000000f, 0x00000022,
  0x00000000, 0x00000033, 0x00000017, 0x00000023,
  0x00000032, 0x00000054, 0x00000022, 0x00000023,
  0x00000054, 0x0000007e, 0x00000022, 0x00000023,
  0x0000007e, 0x0000007e, 0x00000022, 0x0000001d,
  0x0000007e, 0x0000007e, 0xffffffe2, 0x0000001d,
  0x0000007e, 0xffffff84, 0xffffffe2, 0x0000001e,
  0xffffff82, 0xffffff84, 0xffffffed, 0x0000001f,
  0xffffff82, 0xffffffae, 0xfffffff5, 0x00000020,
  0xffffffac, 0xffffffcf, 0x00000002, 0x00000020,
  0xffffffce, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000021,
  0x00000000, 0x00000001, 0x00000003, 0x00000021,
  0x00000000, 0x0000000e, 0x00000004, 0x00000022,
  0x00000032, 0x00000016, 0x00000005, 0x00000022,
  0x00000053, 0x00000021, 0x00000005, 0x00000022,
  0x0000007d, 0x00000021, 0x00000005, 0x0000001e,
  0x0000007d, 0x00000021, 0xffffffff, 0x0000001e,
  0x0000007d, 0xffffffe1, 0xffffffff, 0x0000001f,
  0xffffff83, 0xffffffe1, 0x00000000, 0x0000001f,
  0xffffff83, 0xffffffec, 0x00000001, 0x00000020,
  0xffffffad, 0xfffffff4, 0x00000002, 0x00000020,
  0xffffffce, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000003, 0x00000021,
  0x00000000, 0x00000002, 0x00000003, 0x00000021,
  0x0000000d, 0x00000003, 0x00000004, 0x00000021,
  0x00000015, 0x00000004, 0x00000004, 0x00000021,
  0x00000020, 0x00000004, 0x00000004, 0x0000001f,
  0x00000020, 0x00000004, 0x00000000, 0x0000001f,
  0x00000020, 0xfffffffe, 0x00000000, 0x0000001f,
  0xffffffe0, 0xfffffffe, 0x00000001, 0x00000020,
  0xffffffe0, 0xffffffff, 0x00000001, 0x00000020,
  0xffffffeb, 0x00000000, 0x00000002, 0x00000020,
  0xfffffff3, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
};
const unsigned kExpectedCount_NEON_sqrdmlsh_4S = 961;

#endif  // VIXL_SIM_SQRDMLSH_4S_TRACE_AARCH64_H_
