/*---------------------------------------------------------------------------*\

    Query model and port information for installed Voicetronix hardware.

         Voicetronix Voice Processing Board (VPB) Software
         Copyright (C) 2003 - 2007 Voicetronix www.voicetronix.com.au
         Originally contributed by Jean-Michel Dault, 20/8/03

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "vpbapi.h"
#include "verbose.h"

int main()
{
	int numboards = vpb_get_num_cards();
	int portcount = 0;

	printf("\nCards detected: %d\n\n", numboards);

	for(int i=0; i < numboards; ++i)
	{
		VPB_CARD_INFO   card_info;
		int             numports  = vpb_get_ports_per_card(i);
		int             h         = vpb_open(i,0);
		VPB_MODEL       card_type = vpb_get_card_type(h);

		vpb_get_card_info(i, &card_info);

		printf("BOARD %d (%d ports)\n", i, numports);
		switch(card_type)
		{
		    case VPB_V4PCI:
		    case VPB_V4LOG:
			printf("MODEL         : %s\n", card_info.model);
			printf("DATE          : %s\n", card_info.date);
			printf("REVISION      : %s\n", card_info.rev);
			printf("SERIAL NUMBER : %s\n", card_info.sn);
			break;

		    case VPB_OPCI:
		    case VPB_OSW:
			printf("MODEL         : %s\n", card_info.model);
			printf("SERIAL NUMBER : %s\n", card_info.sn);
			break;

		    default:
			printf("MODEL         : %s\n", card_info.model);
			break;
		}

		int port_type[numports];

		port_type[0] = vpb_get_port_type(h);
		for( int j = 1; j < numports; ++j ) {
			h = vpb_open(i,j);
			port_type[j] = vpb_get_port_type(h);
			vpb_close(h);
		}

		printf("TRUNK PORTS   : ");
		for(int j = 0; j < numports; ++j)
			if( port_type[j] == VPB_FXO) printf("%d ", portcount + j);
		printf("\n");

		printf("STATION PORTS : ");
		for(int j = 0; j < numports; ++j)
			if( port_type[j] == VPB_FXS) printf("%d ", portcount + j);
		printf("\n\n");

		portcount += numports;
	}
	vpb_close();

	return 0;
}

