/*
 * YICS: Connect a FICS interface to the Yahoo! Chess server.
 * Copyright (C) 2004  Chris Howie
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _CONSOLE_H
#define _CONSOLE_H

#include "types.h"

extern bool prompting;

extern void internal_iprint(const char *, bool);
extern void iprintf(const char *, ...);
extern void sysiprintf(const char *, ...);
extern void prompt(void);
extern bool stdin_ready(void);
extern bool stdin_getchar(char *);
extern void die(char *);
extern void dief(char *, ...);

#define     iprint(text)     internal_iprint(text, false)
#define  sysiprint(text)     internal_iprint(text, true)

#ifdef _YICS_POSIX
extern char *mfgets(char *, int, FILE *);
#else
# define mfgets(s,size,stream) fgets(s,size,stream)
#endif

#endif
