!{\src2tex{textfont=tt}}
!!****f* ABINIT/initpawps1
!! NAME
!! initpawps1
!! 
!! FUNCTION
!! Initialize several quantities concerning orbital basis
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the 
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!! 
!! INPUTS 
!!  pshead
!!    %basis_size= Number of elements for the paw nl basis
!!    %lmn_size= Number of elements for the paw basis
!!    %orbitals(basis_size)= Quantum number l for each basis function
!!    %prj_meshsz=Dimension of radial mesh for spheres inherited from uspp
!!    %rho_meshsz=Mesh size for densities inherited from uspp
!!    %sph_meshsz=Dimension of radial mesh for spheres
!!    %wav_meshsz=Mesh size for partial waves and projectors inherited from uspp
!!
!! OUTPUT
!!  pawdata
!!    %big_meshsz= Max. dimension of radial mesh
!!    %indlmn(6,lmn_size)= Gives l,m,n,ln,lm,s for i=lmn
!!  pshead
!!    %l_size= Max. value of l+1 leading to a non zero Gaunt coeffs
!!    %lmax= Maximum value of l
!!    %lmn2_size= lmn_size*(lmn_size+1)/2
!!    %prj_msz_max= Max. dimension of radial mesh for tproj
!!
!! PARENTS
!!      uspp2abinit
!!
!! SOURCE

 subroutine initpawps1(pawdata,pshead)

 use defs_basis
 use defs_pawps

 implicit none

!Arguments ---------------------------------------------
!These types are defined in defs_pawps
 type(pawdata_type) :: pawdata
 type(pshead_type) :: pshead

!Local variables ---------------------------------------
 integer :: ib,il,ilm,ilmn,iln,nproj

!--------------------------------------------------------

!Maximum value for l quantum number
 pshead%lmax=maxval(pshead%orbitals(1:pshead%basis_size))
 pshead%l_size=2*pshead%lmax+1
 pshead%lmn2_size=pshead%lmn_size*(pshead%lmn_size+1)/2

!Size of maximal mesh
 pshead%prj_msz_max=max(pshead%prj_meshsz*3,pshead%wav_meshsz)
 pawdata%big_meshsz=max(pshead%wav_meshsz,pshead%rho_meshsz,&
&                       pshead%sph_meshsz,pshead%prj_meshsz)

!Initialization of the orbital basis indexes (indlmn)
 ilmn=0;iln=0
 do il=0,pshead%lmax
  nproj=0
  do ib=1,pshead%basis_size
   if (pshead%orbitals(ib)==il) then
    nproj=nproj+1;iln=iln+1
    do ilm=1,2*il+1
     pawdata%indlmn(1,ilmn+ilm)=il
     pawdata%indlmn(2,ilmn+ilm)=ilm-(il+1)
     pawdata%indlmn(3,ilmn+ilm)=nproj
     pawdata%indlmn(4,ilmn+ilm)=il*il+ilm
     pawdata%indlmn(5,ilmn+ilm)=iln
     pawdata%indlmn(6,ilmn+ilm)=1
    enddo
    ilmn=ilmn+2*il+1
   endif
  enddo
 enddo

 end subroutine
!!***
