!{\src2tex{textfont=tt}}
!!****f* ABINIT/susk
!! NAME
!! susk
!!
!! FUNCTION
!! Compute the contribution of one k point to the susceptibility matrix
!! from input wavefunctions, band occupations, and k point wts.
!! Include the usual sum-over-state terms, but also the
!! corrections due to the change of the Fermi level in the metallic
!! case, as well as implicit sum over higher lying conduction
!! states, thanks to the closure relation (referred to as an extrapolation).
!! Compared to the routine suskmm, there is no particular attention
!! to the use of the memory, so the code is simpler.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (XG).
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  bdtot_index=index for the number of the band
!!  cg(2,mcg)=wfs in G space
!!  doccde(mband*nkpt*nsppol)=derivative of occupancies wrt
!!           the energy for each band and k point
!!  eigen(mband*nkpt*nsppol)=array for holding eigenvalues (hartree)
!!  extrap: if==1, the closure relation (an extrapolation) must be used
!!  gbound(2*mgfftdiel+8,2)=G sphere boundary for going from WF sphere to
!!      medium size FFT grid
!!  gbound_diel(2*mgfftdiel+8,2)=G sphere boundary for going from medium size
!!      FFT grid to small sphere.
!!  icg=index for cg
!!  ikpt=number of the k point
!!  isp=number of the current spin
!!  istwfk(nkpt)=input option parameter that describes the storage of wfs
!!  kg_diel(3,npwdiel)=reduced planewave coordinates for the dielectric matrix.
!!  kg_k(3,npw_k)=coordinates of planewaves in basis sphere.
!!  mband=maximum number of bands
!!  mcg=dimension of cg
!!  mgfftdiel=maximum size of 1D FFTs, for the computation of
!!     the dielectric matrix
!!  mkmem=maximum number of k points in core memory
!!  mpi_enreg=informations about MPI parallelization
!!  mpw=maximum allowed value for npw
!!  nband_k=number of bands at this k point for that spin polarization
!!  ndiel4,ndiel5,ndiel6= FFT dimensions, modified to avoid cache trashing
!!  nfftdiel=number of fft grid points for the computation of the diel matrix
!!  ngfftdiel(18)=contain all needed information about 3D FFT, for dielectric matrix,
!!    see ~abinit/doc/input_variables/vargs.htm#ngfft
!!  nkpt=number of k points
!!  npwdiel=third and fifth dimension of the susmat array.
!!  npw_k=number of plane waves at this k point
!!  nspden=number of spin-density components
!!  nspinor=number of spinorial components of the wavefunctions
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  occ(mband*nkpt*nsppol)=
!!          occupation numbers for each band (usually 2.0) at each k point
!!  occopt=option for occupancies
!!  occ_deavg(mband)=factor for extrapolation (occup. divided by an energy gap)
!!  ucvol=unit cell volume (Bohr**3)
!!  wtk(nkpt)=k point weights (they sum to 1.0)
!!
!! OUTPUT
!!  (see side effects)
!!
!! SIDE EFFECTS
!! These quantities are accumulated in this routine:
!!  drhode(2,npwdiel,nsppol)=weighted density, needed to compute the
!!   effect of change of fermi energy
!!  rhoextrap(ndiel4,ndiel5,ndiel6)=density-like array, needed for the
!!   extrapolation procedure.
!!  sumdocc=sum of weighted occupation numbers, needed to compute the
!!   effect of change of fermi energy
!!  susmat(2,npwdiel,nsppol,npwdiel,nsppol)=
!!   the susceptibility (or density-density response) matrix in reciprocal space
!!
!! PARENTS
!!      suscep_stat
!!
!! CHILDREN
!!      fourwf,timab
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine susk(bdtot_index,cg,doccde,drhode,eigen,extrap,gbound,&
&  gbound_diel,icg,ikpt,isp,istwfk,kg_diel,kg_k,&
&  mband,mcg,mgfftdiel,mkmem,mpi_enreg,mpw,&
&  nband_k,ndiel4,ndiel5,ndiel6,nfftdiel,ngfftdiel,nkpt,&
&  npwdiel,npw_k,nspden,nspinor,nsppol,occ,occopt,occ_deavg,rhoextrap,sumdocc,&
&  susmat,ucvol,wtk)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_12ffts
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!This type is defined in defs_mpi
!scalars
 integer,intent(in) :: bdtot_index,extrap,icg,ikpt,isp,mband,mcg,mgfftdiel
 integer,intent(in) :: mkmem,mpw,nband_k,ndiel4,ndiel5,ndiel6,nfftdiel,nkpt
 integer,intent(in) :: npw_k,npwdiel,nspden,nspinor,nsppol,occopt
 real(dp),intent(in) :: ucvol
 real(dp),intent(inout) :: sumdocc
 type(MPI_type),intent(inout) :: mpi_enreg
!arrays
 integer,intent(in) :: gbound(2*mgfftdiel+8,2),gbound_diel(2*mgfftdiel+8,2)
 integer,intent(in) :: istwfk(nkpt),kg_diel(3,npwdiel),kg_k(3,npw_k)
 integer,intent(in) :: ngfftdiel(18)
 real(dp),intent(in) :: cg(2,mcg),doccde(mband*nkpt*nsppol)
 real(dp),intent(in) :: eigen(mband*nkpt*nsppol),occ(mband*nkpt*nsppol)
 real(dp),intent(in) :: occ_deavg(mband),wtk(nkpt)
 real(dp),intent(inout) :: drhode(2,npwdiel,nsppol)
 real(dp),intent(inout) :: rhoextrap(ndiel4,ndiel5,ndiel6)
 real(dp),intent(inout) :: susmat(2,npwdiel,nsppol,npwdiel,nsppol)

!Local variables-------------------------------
! real(dp), allocatable :: cg_disk(:,:)
!scalars
 integer :: i1,i2,i3,iband,ibd1,ibd2,ipw,ipw1,ipw2,isp1,isp2,istwf_k,ndiel1
 integer :: ndiel2,ndiel3,testocc,tim_fourwf
 real(dp) :: ai,ar,eigdiff,norm,normr,occdiff,tolocc,weight,wght1,wght2
 character(len=500) :: message
!arrays
 real(dp) :: tsec(2)
 real(dp),allocatable :: cwavef(:,:),dummy(:,:),rhoaug(:,:,:),wfprod(:,:)
 real(dp),allocatable :: wfraug(:,:,:,:),wfrspa(:,:,:,:,:)

! *************************************************************************

! DEBUG
!write(6,*)' susk : enter '
!if(.true.)stop
! ENDDEBUG

 call timab(87,1,tsec)

 ndiel1=ngfftdiel(1) ; ndiel2=ngfftdiel(2) ; ndiel3=ngfftdiel(3)
 istwf_k=istwfk(1)

 testocc=1
!DEBUG
!write(6,*)' susk : set testocc to 0 '
!testocc=0
!write(6,*)' susk : set extrap to 0 '
!extrap=0
!ENDDEBUG

 allocate(cwavef(2,mpw),dummy(2,1))
 allocate(rhoaug(ndiel4,ndiel5,ndiel6),wfraug(2,ndiel4,ndiel5,ndiel6))
 allocate(wfprod(2,npwdiel),wfrspa(2,ndiel4,ndiel5,ndiel6,mband))

!Loop over bands to fft and store Fourier transform of wavefunction
 do iband=1,nband_k
! Obtain Fourier transform in fft box
  cwavef(:,1:npw_k)=cg(:,1+(iband-1)*npw_k+icg:iband*npw_k+icg)

!DEBUG
!   write(6,*)' susk : will call fourwf for band',iband
!ENDDEBUG

  tim_fourwf=8
  call fourwf(1,rhoaug,cwavef,dummy,wfraug,gbound,gbound,&
&  istwf_k,kg_k,kg_k,mgfftdiel,mpi_enreg,1,ngfftdiel,npw_k,1,ndiel4,ndiel5,ndiel6,&
&  0,tim_fourwf,weight)

  wfrspa(:,:,:,:,iband)=wfraug(:,:,:,:)

  if( (occopt>=3 .and. testocc==1) .or. extrap==1 )then
!  In the case of metallic occupation, or if the extrapolation
!  over higher bands is included, must compute the
!  Fourier transform of the density of each band, then
!  generate the part of the susceptibility matrix due
!  varying occupation numbers.

   weight=-2.0_dp*occ_deavg(iband)*wtk(ikpt)/ucvol
!DEBUG
!  write(6,*)' susk : debug one band contribution '
!  weight=0.0_dp
!  if(iband==1)weight=-2.0_dp*occ_deavg(iband)*wtk(ikpt)/ucvol
!ENDDEBUG
   do i3=1,ndiel3
    do i2=1,ndiel2
     do i1=1,ndiel1
      wfraug(1,i1,i2,i3)=wfraug(1,i1,i2,i3)**2+wfraug(2,i1,i2,i3)**2
      wfraug(2,i1,i2,i3)=0.0_dp
     end do
    end do
!   If extrapolation, accumulate density in real space
    if(extrap==1)then
     do i2=1,ndiel2
      do i1=1,ndiel1
       rhoextrap(i1,i2,i3)=rhoextrap(i1,i2,i3)+weight*wfraug(1,i1,i2,i3)
      end do
     end do
    end if
   end do

!DEBUG
!  if(iband==1)then
!   write(6,*)' wfraug ='
!   do i3=1,ndiel3,4
!    write(6,*)1,1,i3,wfraug(1,1,1,i3)
!   end do
!  end if
!ENDDEBUG

!  Performs the Fourier Transform of the density of the band,
!  and store it in wfprod
   tim_fourwf=9
   call fourwf(1,rhoaug,dummy,wfprod,wfraug,gbound_diel,gbound_diel,&
&   istwf_k,kg_diel,kg_diel,&
&   mgfftdiel,mpi_enreg,1,ngfftdiel,1,npwdiel,ndiel4,ndiel5,ndiel6,3,tim_fourwf,weight)

!  Perform now the summation of terms related to direct change of eigenvalues
!  or extrapolation over higher bands
   wght1=0.0_dp ; wght2=0.0_dp
   if(occopt>=3 .and. testocc==1)then
    wght1=doccde(iband+bdtot_index)*wtk(ikpt)/ucvol
   end if

   if(extrap==1) wght2=2.0_dp*occ_deavg(iband)*wtk(ikpt)/ucvol
!DEBUG
!  write(6,*)' susk : debug '
!  if(extrap==1 .and. iband==1) &
!&    wght2=2.0_dp*occ_deavg(iband)*wtk(ikpt)/ucvol
!ENDDEBUG

   weight=wght1+wght2
   do ipw2=1,npwdiel
!   Only fills lower half of the matrix (here, the susceptibility matrix)
!   Note that wfprod of the first index must behave like a density,
!   so that it is used as generated by fourwf, while wfprod of the
!   second index will be implicitely used to make a scalar product
!   with a potential change, meaning that its complex conjugate must be
!   used. This explains the following signs...
!DEBUG
!    write(6, '(a,i3,2es14.6)' )&
!&     ' ipw,wfprod',ipw2,wfprod(1,ipw2),wfprod(2,ipw2)
!ENDDEBUG
    do ipw1=ipw2,npwdiel
     susmat(1,ipw1,isp,ipw2,isp)=susmat(1,ipw1,isp,ipw2,isp)+&
&     weight*(wfprod(1,ipw1)*wfprod(1,ipw2)+wfprod(2,ipw1)*wfprod(2,ipw2))
     susmat(2,ipw1,isp,ipw2,isp)=susmat(2,ipw1,isp,ipw2,isp)+&
&     weight*(wfprod(2,ipw1)*wfprod(1,ipw2)-wfprod(1,ipw1)*wfprod(2,ipw2))
    end do
   end do

   if( occopt>=3 .and. testocc==1) then
!   Accumulate product of band densities by their doccde, for the
!   computation of the effect of change of Fermi level.
    do ipw=1,npwdiel
     drhode(1,ipw,isp)=drhode(1,ipw,isp)+wfprod(1,ipw)*wght1
     drhode(2,ipw,isp)=drhode(2,ipw,isp)+wfprod(2,ipw)*wght1
    end do
!   Also accumulate weighted sum of doccde
    sumdocc=sumdocc+wght1
   end if

! End condition of metallic occupancies or extrapolation
  end if

!End loop on iband
 end do

 call timab(87,2,tsec)

!DEBUG
!write(6,*)' susk : stop '
!stop
!ENDDEBUG

!--Wavefunctions have been generated in real space--------------------------

 call timab(88,1,tsec)

!Compute product of wavefunctions for different bands
 tolocc=1.0d-3
 if(nband_k>1)then
  do ibd1=1,nband_k-1
   do ibd2=ibd1+1,nband_k
!   If the occupation numbers are sufficiently different, or
!   if extrapolation is used and the corresponding factor is not zero,
!   then there is a contribution
    occdiff=occ(ibd1+bdtot_index)-occ(ibd2+bdtot_index)
    if( abs(occdiff)>tolocc      .or. &
&        ( extrap==1 .and.            &
&             ( abs(occ_deavg(ibd1)) + abs(occ_deavg(ibd2)) ) >tolocc ) &
&        ) then

     eigdiff=eigen(ibd1+bdtot_index)-eigen(ibd2+bdtot_index)
!DEBUG
!    write(6,*)' susk : contribution from bands',ibd1,ibd2
!    write(6,*)'   occ diff =',occdiff
!    write(6,*)'   eig diff =',eigdiff
!ENDDEBUG

!    Store the contribution in wfraug
     do i3=1,ndiel3
      do i2=1,ndiel2
       do i1=1,ndiel1
        wfraug(1,i1,i2,i3)=wfrspa(1,i1,i2,i3,ibd1)*wfrspa(1,i1,i2,i3,ibd2)&
&                         +wfrspa(2,i1,i2,i3,ibd1)*wfrspa(2,i1,i2,i3,ibd2)
        wfraug(2,i1,i2,i3)=wfrspa(2,i1,i2,i3,ibd1)*wfrspa(1,i1,i2,i3,ibd2)&
&                         -wfrspa(1,i1,i2,i3,ibd1)*wfrspa(2,i1,i2,i3,ibd2)
       end do
      end do
     end do

!DEBUG
!    norm=0.0_dp ; normr=0.0_dp
!    do i3=1,ndiel3
!     do i2=1,ndiel2
!      do i1=1,ndiel1
!       norm=norm+wfraug(1,i1,i2,i3)**2+wfraug(2,i1,i2,i3)**2
!       normr=normr+wfraug(1,i1,i2,i3)**2
!      end do
!     end do
!    end do
!    write(6,*)' norm in real space =',norm/dble(nfftdiel)
!    write(6,*)' norm of real part  =',normr/dble(nfftdiel)
!ENDDEBUG

!    Performs the Fourier Transform of the product, and store it in wfprod
     tim_fourwf=9
     call fourwf(1,rhoaug,dummy,wfprod,wfraug,gbound_diel,gbound_diel,&
&     istwf_k,kg_diel,kg_diel,&
&     mgfftdiel,mpi_enreg,1,ngfftdiel,1,npwdiel,ndiel4,ndiel5,ndiel6,3,tim_fourwf,weight)

!    Perform now the summation
     wght1=0.0_dp ; wght2=0.0_dp
     if(abs(occdiff)>tolocc)wght1= occdiff/eigdiff * 2.0_dp*wtk(ikpt)/ucvol
     if(extrap==1)then
      wght2=(occ_deavg(ibd1)+occ_deavg(ibd2)) * 2.0_dp*wtk(ikpt)/ucvol
     end if
     weight=wght1+wght2

!DEBUG
!    write(6,*)' weight =',weight
!    norm=0.0_dp
!    do ipw=1,npwdiel
!     norm=norm+wfprod(1,ipw)**2+wfprod(2,ipw)**2
!    end do
!    write(6,*)' norm in reciprocal space  =',norm
!ENDDEBUG

     do ipw2=1,npwdiel
!     Only fills lower half of the matrix (here, the susceptibility matrix)
!     Note that wfprod of the first index must behave like a density,
!     so that it is used as generated by fourwf, while wfprod of the
!     second index will be implicitely used to make a scalar product
!     with a potential change, meaning that its complex conjugate must be
!     used. This explains the following signs...
      do ipw1=ipw2,npwdiel
       susmat(1,ipw1,isp,ipw2,isp)=susmat(1,ipw1,isp,ipw2,isp)+&
&       weight*(wfprod(1,ipw1)*wfprod(1,ipw2)+wfprod(2,ipw1)*wfprod(2,ipw2))
       susmat(2,ipw1,isp,ipw2,isp)=susmat(2,ipw1,isp,ipw2,isp)+&
&       weight*(wfprod(2,ipw1)*wfprod(1,ipw2)-wfprod(1,ipw1)*wfprod(2,ipw2))
      end do
     end do

!   End condition of different occupation numbers or extrapolation
    end if
!  End internal loop over bands
   end do
! End external loop over bands
  end do
!End condition of having more than one band
 end if

!DEBUG
!write(6,*)' susk : exit , write susmat'
!do ipw1=1,npwdiel
! write(6,*)ipw1,susmat(1,ipw1,1,ipw1,1),susmat(2,ipw1,1,ipw1,1)
!end do
!write(6,*)' susk : end of susmat '
!stop
!ENDDEBUG

 deallocate(cwavef,dummy,rhoaug,wfprod,wfraug,wfrspa)

 call timab(88,2,tsec)

end subroutine susk
!!***
