/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.function.Predicate;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.NestedClassTestDescriptor;
import org.junit.platform.engine.TestDescriptor;

class DiscoveryFilterApplier {
    DiscoveryFilterApplier() {
    }

    void applyClassNamePredicate(Predicate<String> classNamePredicate, TestDescriptor engineDescriptor) {
        TestDescriptor.Visitor filteringVisitor = descriptor -> {
            if (descriptor instanceof ClassTestDescriptor && !this.includeClass((ClassTestDescriptor)descriptor, classNamePredicate)) {
                descriptor.removeFromHierarchy();
            }
        };
        engineDescriptor.accept(filteringVisitor);
    }

    private boolean includeClass(ClassTestDescriptor classTestDescriptor, Predicate<String> classNamePredicate) {
        if (classTestDescriptor instanceof NestedClassTestDescriptor) {
            return true;
        }
        return classNamePredicate.test(classTestDescriptor.getTestClass().getName());
    }
}

