/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.discovery.ElementResolver;
import org.junit.jupiter.engine.discovery.predicates.IsPotentialTestContainer;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

class TestContainerResolver
implements ElementResolver {
    private static final IsPotentialTestContainer isPotentialTestContainer = new IsPotentialTestContainer();
    static final String SEGMENT_TYPE = "class";
    protected final JupiterConfiguration configuration;

    public TestContainerResolver(JupiterConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Set<TestDescriptor> resolveElement(AnnotatedElement element, TestDescriptor parent) {
        if (!(element instanceof Class)) {
            return Collections.emptySet();
        }
        Class clazz = (Class)element;
        if (!this.isPotentialCandidate(clazz)) {
            return Collections.emptySet();
        }
        UniqueId uniqueId = this.createUniqueId(clazz, parent);
        return Collections.singleton(this.resolveClass(clazz, uniqueId));
    }

    @Override
    public Optional<TestDescriptor> resolveUniqueId(UniqueId.Segment segment, TestDescriptor parent) {
        if (!segment.getType().equals(this.getSegmentType())) {
            return Optional.empty();
        }
        if (!this.requiredParentType().isInstance(parent)) {
            return Optional.empty();
        }
        String className = this.getClassName(parent, segment.getValue());
        Optional optionalContainerClass = ReflectionUtils.tryToLoadClass((String)className).toOptional();
        if (!optionalContainerClass.isPresent()) {
            return Optional.empty();
        }
        Class containerClass = (Class)optionalContainerClass.get();
        if (!this.isPotentialCandidate(containerClass)) {
            return Optional.empty();
        }
        UniqueId uniqueId = this.createUniqueId(containerClass, parent);
        return Optional.of(this.resolveClass(containerClass, uniqueId));
    }

    protected Class<? extends TestDescriptor> requiredParentType() {
        return TestDescriptor.class;
    }

    protected String getClassName(TestDescriptor parent, String segmentValue) {
        return segmentValue;
    }

    protected String getSegmentType() {
        return SEGMENT_TYPE;
    }

    protected String getSegmentValue(Class<?> testClass) {
        return testClass.getName();
    }

    protected boolean isPotentialCandidate(Class<?> element) {
        return isPotentialTestContainer.test(element);
    }

    protected UniqueId createUniqueId(Class<?> testClass, TestDescriptor parent) {
        return parent.getUniqueId().append(this.getSegmentType(), this.getSegmentValue(testClass));
    }

    protected TestDescriptor resolveClass(Class<?> testClass, UniqueId uniqueId) {
        return new ClassTestDescriptor(uniqueId, testClass, this.configuration);
    }
}

