/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="1.0")
public final class PackageUtils {
    static final String DEFAULT_PACKAGE_NAME = "";
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");

    private PackageUtils() {
    }

    public static void assertPackageNameIsValid(String packageName) {
        Preconditions.notNull(packageName, "package name must not be null");
        if (packageName.equals(DEFAULT_PACKAGE_NAME)) {
            return;
        }
        Preconditions.notBlank(packageName, "package name must not contain only whitespace");
        boolean allValid = Arrays.stream(DOT_PATTERN.split(packageName, -1)).allMatch(SourceVersion::isName);
        Preconditions.condition(allValid, "invalid part(s) in package name: " + packageName);
    }

    public static Optional<String> getAttribute(Class<?> type, Function<Package, String> function) {
        Preconditions.notNull(type, "type must not be null");
        Preconditions.notNull(function, "function must not be null");
        Package typePackage = type.getPackage();
        if (typePackage != null) {
            return Optional.ofNullable(function.apply(typePackage));
        }
        return Optional.empty();
    }

    public static Optional<String> getAttribute(Class<?> type, String name) {
        Optional<String> optional;
        Preconditions.notNull(type, "type must not be null");
        Preconditions.notBlank(name, "name must not be blank");
        CodeSource codeSource = type.getProtectionDomain().getCodeSource();
        URL jarUrl = codeSource.getLocation();
        JarFile jarFile = new JarFile(new File(jarUrl.toURI()));
        try {
            Manifest manifest = jarFile.getManifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            optional = Optional.ofNullable(mainAttributes.getValue(name));
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        jarFile.close();
        return optional;
    }
}

