===========================
AdapterRemoval - Benchmarks
===========================

Running the 'benchmark.sh' script from the 'benchmarks' folder will execute one
or more sets of analyses, after checking that all required software is
available in the ./bin/ folder.

The following software is expected:

  - AdapterRemoval v1.5.4, located at 'bin/AdapterRemoval-1.5.4'
  - AdapterRemoval v2.1.0, located at 'bin/AdapterRemoval-2.1.0'
    Source: https://github.com/MikkelSchubert/adapterremoval

  - leeHom rev. dfca9e6, located at 'bin/leeHom_patched'
    Source: https://github.com/grenaud/leeHom
    Apply patches/leeHom.patch

  - Skewer v0.1.127, located at 'bin/skewer'
    Source: https://github.com/relipmoc/skewer

  - AlienTrimmer v0.4.0, located at 'bin/AlienTrimmer'
    Source: ftp://ftp.pasteur.fr/pub/GenSoft/projects/AlienTrimmer/
    Note: Compile AlienTrimmer using GCJ!

  - Scythe 0.991, located at 'bin/scythe'
    Source: https://github.com/vsbuffalo/scythe

  - Cutadapt 1.8.3, located at 'bin/cutadapt'
    Source: https://code.google.com/p/cutadapt/

  - FASTQ-MCF v1.1.2, located at 'bin/fastq-mcf'
    Source: https://code.google.com/p/ea-utils/

  - Flexbar v2.5, located at 'bin/flexbar'
    Source: http://sourceforge.net/projects/flexbar/

  - pIRS v1.1.1, located at 'bin/pirs_patched'
    Source: ftp://ftp.genomics.org.cn/pub/pIRS/
    Apply patches/pIRS_111.patch

  - Trimmomatic v0.33, located at 'bin/trimmomatic-0.33.jar'
    Source: http://www.usadellab.org/cms/?page=trimmomatic

  - PEAT rev. 4e9ebf3, located at './bin/PEAT'
    Source: https://github.com/jhhung/PEAT

  - PEAR 0.9.6, located at 'bin/pear_patched'
    Source: http://sco.h-its.org/exelixis/web/software/pear/
    Apply patches/pear.patch

  - Minion (from Kraken), located at 'bin/minion'
    Source: http://www.ebi.ac.uk/research/enright/software/kraken


Additionally, the script expects a Java JRE ('bin/java') and the GNU 'time'
command (located in PATH).

As noted above, patches are supplied for the following programs:

  - leeHom: Disable gzip-compression and mark merged reads with "M_",
    to simplify analysis.
  - PEAR: Marks merged reads with "M_", to simplify processing.
  - pIRS: Adds support for user supplied adapter sequences and barcodes, allow
    zero length inserts.

To process results generated by 'benchmark.sh', use the following scripts:
  - scripts/tabulate.py, call with arguments 'basic' or 'throughput' on the
    tables written to 'results/', for MCC and other statistics, and for data-
    processing throughput, respectively.
