//
// This file is part of the aMule AdunanzA Project (mod of official aMule)
//
// Copyright (c) 2003-2008 aMule AdunanzA Team ( http://www.adunanza.net )
//
// Any parts of this program derived from the xMule, lMule, eMule or aMule project,
// or contributed by third-party developers are copyrighted by their
// respective authors.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
//

#if !defined(_REMOTESETTINGS_H_)
#define _REMOTESETTINGS_H_

#include <exception>                    // per std::exception (Mr Hyde)
#include <vector>                       // per std::vector (Mr Hyde)
#include <algorithm>                    // per std::find_if (Mr Hyde)

#include <wx/config.h>			// to let wxWidgets choose a wxConfig class for your platform
#include <wx/confbase.h>		// base config class
#include <wx/fileconf.h>		// wxFileConfig class
#include <wx/string.h>		        // wxString
// #include <wx/thread.h>		        // wxMutex
#include "Types.h"

#include "KADUSettings.h"

class CMatchBannedModPredicate
{
	private:
		wxString m_modName;

	public:
		CMatchBannedModPredicate(const wxString& k) : m_modName(k) {};
		~CMatchBannedModPredicate() {};

		inline bool operator()(const wxString& toCheck) const
		{
			return (m_modName.Contains(toCheck));
		}
};


class CRemoteSettings {
	// member variables
	
	private:
		static const unsigned char VALIDITY_MASK = 0xA5; // 1010 0101
		unsigned char              m_validity;

		time_t        m_nextUpdate; /*!< time for next RemoteSettings update */
		int           m_failCount;	/*!< failure counter */
		long          m_expireTime;	/*!< expire */
		long          m_recheckTime; 	/*!< time for a new check */


		wxFileConfig* m_pFileConfig;	/*!< wx file config structure used to read/write settings from/to file */
		wxString      m_configDir;	/*!< directory where to store / from where to read config file */

		// wxMutex       m_mutex; // Mr Hyde: per evitare casini di accessi concorrenti
 
	public:
		static const wxString ADUNANZA_CONF; // name of adunanza.conf file

#if 0			
		long          m_kadRepublishTimeK;
		long          m_kadRepublishTimeS;
		long          m_kadRepublishTimeN;

		long          m_kadIndexLifeK; // Mr Hyde per allineamento a eMule 3.15b74
		long          m_kadIndexLifeS; // Mr Hyde per allineamento a eMule 3.15b74

		uint32_t      m_kadTotalStoreKey;   // Mr Hyde: cambiato da long a uint32_t in accordo con kademlia.h
		uint32_t      m_kadTotalStoreSrc;   // Mr Hyde: cambiato da long a uint32_t in accordo con kademlia.h
		uint32_t      m_kadTotalStoreNotes; // Mr Hyde: cambiato da long a uint32_t in accordo con kademlia.h

		long          m_kadTotalSearchFile;

		long          m_kadMaxSrcFile;
		long          m_kadMaxNotFile;

		double        m_kadFreshGuess_Tol;
		double        m_kadFreshGuess_Weight;
		long          m_kadFreshGuess_NoNorm;
		long          m_kadFreshGuess_LowNorm;
#endif
		long          m_maxSrc;
		long          m_maxSrcUdp;
#if 0
		long          m_kadFindValue;
		long          m_kadStore;
		long          m_kadFindNode;

		long          m_kadReaskTime;
		long          km_adPubTime;

		long          m_kadReaskIncs;

		long          m_mVer;

		unsigned char m_kadOpcode;
		unsigned char m_kadZOpcode;
#endif

		CKADUSettings m_KADUSettings;

		// Mr Hyde allineamento a 3.16: per ripartitore di banda
		uint32_t      m_AduValRipBanda_Std;

		wxString      m_UpdateURL;

		std::vector<wxString> m_badMods; // Mr Hyde: lista stringhe per Mod di cui fare il ban

	private:
		inline void setInvalid() {m_validity = 0x0;}
		inline void setValid() {m_validity = CRemoteSettings::VALIDITY_MASK;}

	public:
		CRemoteSettings();
		virtual ~CRemoteSettings();

		void AllocateAdunanzaConf(); // Mr Hyde

		// void ReadSettings(wxConfigBase* pBaseCfg);
		void ReadSettings(const wxConfigBase& baseCfg);
		void SaveSettings();

		void PrintAllValues();

		void SaveToFile();
		void CheckUpdate();
		void FileDownloadedCallback(int result);

		// Mr Hyde
		inline bool isBannedMod(const wxString& modName) const
		{
			return (std::find_if(	m_badMods.begin(),
						m_badMods.end(),
						CMatchBannedModPredicate(modName)) != m_badMods.end());
		}


		inline bool isValid() const {return (m_validity == CRemoteSettings::VALIDITY_MASK);}
/*			
		inline long get_kadRepublishTimeK() const {return m_kadRepublishTimeK;}
		inline long get_kadRepublishTimeS() const {return m_kadRepublishTimeS;}
		inline long get_kadRepublishTimeN() const  {return m_kadRepublishTimeN;}

		inline long get_kadIndexLifeK() const   {return m_kadIndexLifeK;}
		inline long get_kadIndexLifeS() const   {return m_kadIndexLifeS;}

		inline uint32_t get_kadTotalStoreKey() const  {return m_kadTotalStoreKey;}
		inline uint32_t get_kadTotalStoreSrc() const  {return m_kadTotalStoreSrc;}
		inline uint32_t get_kadTotalStoreNotes() const  {return m_kadTotalStoreNotes;}

		inline long get_kadTotalSearchFile() const  {return m_kadTotalSearchFile;}

		inline long get_kadMaxSrcFile() const          { return m_kadMaxSrcFile;}
		inline long get_kadMaxNotFile() const          { return m_kadMaxNotFile;}

		inline double get_kadFreshGuess_Tol()  const       { return m_kadFreshGuess_Tol;}
		inline double get_kadFreshGuess_Weight() const     { return m_kadFreshGuess_Weight;}
		inline long   get_kadFreshGuess_NoNorm() const     { return m_kadFreshGuess_NoNorm;}
		inline long   get_kadFreshGuess_LowNorm() const    { return m_kadFreshGuess_LowNorm;}

		inline long   get_maxSrc() const        { return m_maxSrc;}
		inline long   get_maxSrcUdp() const     { return m_maxSrcUdp;}

		inline long   get_kadFindValue() const   { return m_kadFindValue;}
		inline long   get_kadStore() const       { return m_kadStore;}
		inline long   get_kadFindNode() const    { return m_kadFindNode;}

		inline long   get_kadReaskTime() const    { return m_kadReaskTime;}
		inline long   get_kadPubTime() const      { return m_kadPubTime;}

		inline long   get_kadReaskIncs() const    { return m_kadReaskIncs;}

		inline long   get_mVer() const       { return m_mVer;}

		inline unsigned char get_kadOpcode() const   { return m_kadOpcode;}
		inline unsigned char get_kadZOpcode() const  { return m_kadZOpcode;}
*/
		inline const CKADUSettings& getKADUSettings() const {return m_KADUSettings;}

		// Mr Hyde allineamento a 3.16: per ripartitore di banda
		inline uint32_t get_AduValRipBanda_Std() const  { return m_AduValRipBanda_Std;}

		inline const wxString&  get_UpdateURL() const   { return m_UpdateURL;} 

		inline const std::vector<wxString>& get_badMods() const  { return m_badMods;}


};


#endif // _REMOTESETTINGS_H_

