#!/usr/bin/python
# -*- coding: utf-8 -*-

# This file is a part of Androguard.
#
# This file is generated automatically from the data
# provided by PScout tool [http://pscout.csl.toronto.edu/]
# using script: extract_api_permission_mappings.py
#
# Author: Yury Zhauniarovich
#
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License"

#################################################
### API version: 16 
#################################################


AOSP_PERMISSIONS_BY_METHODS = {
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handlePinMmi-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/VideoCamera;-checkQualityAndStartPreview-()V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/vcard/VCardEntry$BirthdayData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/base/GLTextureTarget;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupEditorFragment;-bindGroupMetaData-(Landroid/database/Cursor;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/SnapshotTab$LoadData;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK', 'com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/webkit/HTML5VideoInline;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/contacts/ProfileProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-drawFrameLocked-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/SoundSettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/widget/LockPatternView;-addCellToPattern-(Lcom/android/internal/widget/LockPatternView$Cell;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/calendar/agenda/AgendaFragment;-handleEvent-(Lcom/android/calendar/CalendarController$EventInfo;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/DataUsageSummary;-updateTabs-()V' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/FaceUnlock;-handleCancel-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/gallery3d/app/CropImage;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/gallery3d/ui/PhotoView;-switchWithCaptureAnimation-(I)Z' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Landroid/nfc/INfcAdapter$Stub;-setNdefPushCallback-(Landroid/nfc/INdefPushCallback;)V' : ['android.permission.NFC'],
	'Lcom/android/soundrecorder/Recorder;-delete-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$WifiStateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/provider/VoicemailContract$Status;-buildSourceUri-(Ljava/lang/String;)Landroid/net/Uri;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/contacts/dialpad/DialpadFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/videoeditor/VideoEditorActivity$23;-onStop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendSubmitPdu-(Lcom/android/internal/telephony/cdma/SmsMessage$SubmitPdu; Landroid/app/PendingIntent; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lorg/apache/http/impl/client/DefaultHttpClient;-<init>-(I)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/TetherSettings;-setUsbTethering-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-updateConnectionState-(Landroid/net/NetworkInfo$DetailedState;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/WifiService$NotificationEnabledSettingObserver;-register-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/SuggestionsAdapter$SlowFilterTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/CropFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/sip/SipEditor;-saveAndRegisterProfile-(Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/settings/bluetooth/DeviceProfilesSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/AccountManagerService;-updateCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/email/activity/MessageListFragment;-onLoadMoreMessages-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/IIccPhoneBook;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/email/GroupMessagingListener;-loadAttachmentStarted-(J J J Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/launcher2/PagedView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/bluetooth/HeadsetProfile;-isPreferred-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/deskclock/SettingsActivity;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/MessageViewFragmentBase;-onOpenAttachment-(Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/net/IConnectivityManager;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-handleAccessibilityEnabledSettingChangedLocked-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/FrameSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-processPendingRadioPowerOffAfterDataOff-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/OtherSettingsPopup;-onSettingChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/webkit/HTML5VideoViewProxy;-setBaseLayer-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag;-ndefWrite-(I Landroid/nfc/NdefMessage;)I' : ['android.permission.NFC'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-getName-(Landroid/bluetooth/BluetoothDevice;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/BackupManagerService;-opComplete-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/accounts/IAccountManager$Stub;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/hardware/ISerialManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SERIAL_PORT'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-getContactCount-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/CallLogAsync$AddCallTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/BluetoothProfileState$StableState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/wifi/WpsDialog;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-cancelBondProcess-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/service/PopImapAuthenticatorService$PopImapAuthenticator;-addAccount-(Landroid/accounts/AccountAuthenticatorResponse; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/os/Bundle;)Landroid/os/Bundle;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/server/BluetoothA2dpService;-onSinkPropertyChanged-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/EmergencyCallHelper;-placeEmergencyCall-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/usb/UsbStorageActivity$8;-run-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Landroid/content/ContentService;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-onWakeKeyWhenKeyguardShowingTq-(I Z)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/emailcommon/service/IPolicyService$Stub$Proxy;-setAccountPolicy-(J Lcom/android/emailcommon/provider/Policy; Ljava/lang/String;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/activities/ContactDetailActivity;-onStart-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableUsbRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/PhoneUtils;-handleHeadsetHook-(Lcom/android/internal/telephony/Phone; Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/interactions/PhoneNumberInteraction;-performAction-(Ljava/lang/String;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/telephony/TelephonyManager;-getDeviceSoftwareVersion-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/RedEyeFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/wm/Session;-add-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/phone/InCallScreen;-onStop-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/MessageViewFragmentBase$LoadAttachmentsTask;-callOnCancelledForTest-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-reRegisterNetwork-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneApp;-updatePhoneState-(Lcom/android/internal/telephony/Phone$State;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/PhotoPage;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MediaPlaybackActivity;-access$800-(Lcom/android/music/MediaPlaybackActivity;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothDeviceProfileState;-handleConnectionOfOtherProfiles-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IConnectivityManager$Stub;-requestNetworkTransitionWakelock-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ToRGBAFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/util/ReverseGeocoder;-computeAddress-(Lcom/android/gallery3d/util/ReverseGeocoder$SetLatLong;)Ljava/lang/String;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/InCallScreen;-access$800-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/PhotoView;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/contacts/VoicemailStatusTable;-insert-(Lcom/android/providers/contacts/VoicemailContentProvider$UriData; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ThrottleService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/PhoneNotifier;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/contacts/group/GroupDetailFragment$3;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/CursorLoader;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/bluetooth/DockService;-access$100-(Lcom/android/settings/bluetooth/DockService; Landroid/os/Message;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videosrc/MediaSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/MailService$1;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/app/IActivityManager;-unbroadcastIntent-(Landroid/app/IApplicationThread; Landroid/content/Intent; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/CallContactActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updatePhones-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/ui/CropView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-copyMessageToIccEf-(I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/providers/settings/SettingsHelper;-setGpsLocation-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetoothHeadset;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onEnableApn-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-agentErrorCleanup-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/email/activity/MessageListFragment$4;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/server/BluetoothService;-getBluetoothState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/Phone;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-addNotificationViews-(Landroid/os/IBinder; Lcom/android/internal/statusbar/StatusBarNotification;)Lcom/android/systemui/statusbar/StatusBarIconView;' : ['android.permission.VIBRATE'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/nfc/tech/MifareClassic;-decrement-(I I)V' : ['android.permission.NFC'],
	'Lcom/android/contacts/ContactsListActivity;-getUriToQuery-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/EasOutboxService;-executePostWithTimeout-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; I)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/util/AccountSelectionUtil;-getSelectAccountDialog-(Landroid/content/Context; I Landroid/content/DialogInterface$OnClickListener; Landroid/content/DialogInterface$OnCancelListener;)Landroid/app/Dialog;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-gotoIdleAndNotifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/DhcpStateMachine$RunningState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-<init>-(Landroid/content/Context; Landroid/os/INetworkManagementService; Landroid/net/INetworkStatsService; Landroid/net/INetworkPolicyManager;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/bluetooth/BluetoothDeviceProfileState;-handleIncomingConnection-(I Z)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$LocalePickerActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-addRfcommServiceRecord-(Ljava/lang/String; Landroid/os/ParcelUuid; I Landroid/os/IBinder;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallbackProxy$2;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothDeviceProfileState;-access$6700-(Landroid/bluetooth/BluetoothDeviceProfileState; I Z)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/WifiStateTracker;-teardown-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/launcher2/WallpaperChooserDialogFragment;-access$000-(Lcom/android/launcher2/WallpaperChooserDialogFragment; I)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wm/WindowManagerService;-moveAppWindowsLocked-(Ljava/util/List; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/base/FrameSource;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-setSystemUiVisibility-(I I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/exchange/EasSyncService;-canProvision-(Lcom/android/exchange/EasSyncService;)Lcom/android/exchange/adapter/ProvisionParser;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/test/FragmentTestActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Landroid/provider/Telephony$Sms$Sent;-addMessage-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/Long;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-addNotification-(Landroid/os/IBinder; Lcom/android/internal/statusbar/StatusBarNotification;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/providers/calendar/CalendarProvider2;-updateInTransaction-(Landroid/net/Uri; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String; Z)I' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/interactions/PhoneNumberInteraction;-access$200-(Landroid/content/Context; Ljava/lang/String; Lcom/android/contacts/interactions/PhoneNumberInteraction$InteractionType; Ljava/lang/String;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/content/IContentService;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/mms/util/DraftCache;-access$000-(Lcom/android/mms/util/DraftCache;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/phone/InCallScreen;-updateManageConferencePanelIfNecessary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/systemui/statusbar/policy/AutoRotateController;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/LocationManagerService;-requestLocationUpdatesPI-(Ljava/lang/String; Landroid/location/Criteria; J F Z Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/AccountFilterActivity;-onResume-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/view/VolumePanel;-onRemoteVolumeChanged-(I I)V' : ['android.permission.VIBRATE'],
	'Landroid/media/IAudioService;-setMode-(I Landroid/os/IBinder;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/NetworkTimeUpdateService;-systemReady-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/PhoneApp;-access$1100-(Lcom/android/phone/PhoneApp;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/VibratorService;-startVibrationLocked-(Lcom/android/server/VibratorService$Vibration;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/net/wifi/WifiManager;-setCountryCode-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/BluetoothAtPhonebook;-handleAccessPermissionResult-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/app/LocalePicker;-updateLocale-(Ljava/util/Locale;)V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_CONFIGURATION'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$AdvancedWifiSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/list/LegacyPhoneNumberListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/activity/setup/AccountSetupNames$2;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/emailcommon/service/IEmailService;-hostChanged-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/Search$SearchParser;-parseResponse-()Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/commands/bmgr/Bmgr;-doListRestoreSets-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothDevicePreference;-onBindView-(Landroid/view/View;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/IWifiManager;-reassociate-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/pm/ShutdownThread;-reboot-(Landroid/content/Context; Ljava/lang/String; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.VIBRATE'],
	'Landroid/net/ConnectivityManager;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/NfcService$TagService;-isNdef-(I)Z' : ['android.permission.NFC'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-access$700-(Lcom/android/server/net/NetworkPolicyManagerService;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/UrlInputView;-onSelect-(Ljava/lang/String; I Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/VibratorService;-onInputDeviceRemoved-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/phone/BluetoothHandsfree$14;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/ActivityManagerNative;-handleApplicationWtf-(Landroid/os/IBinder; Ljava/lang/String; Landroid/app/ApplicationErrorReport$CrashInfo;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/providers/contacts/ProfileProvider;-enforceWritePermission-()V' : ['android.permission.WRITE_PROFILE'],
	'Lcom/android/calendar/month/SimpleDayPickerFragment;-setUpAdapter-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/launcher2/PagedViewWithDraggableItems;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onDataStallAlarm-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/MobileNetworkSettings$MyHandler;-resetNetworkModeToDefault-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-acceptCall-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/OtaUtils;-onOtaCloseFailureNotice-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/InCallScreen;-access$600-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/AudioService;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$3000-(Lcom/android/mms/ui/ComposeMessageActivity; J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/base/NullFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/IWifiManager;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/GlobalActions$SilentModeToggleAction;-onPress-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/SearchActivity;-handleEvent-(Lcom/android/calendar/CalendarController$EventInfo;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/ConnectivityService;-requestNetworkTransitionWakelock-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-stopSample-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/suggestions/SuggestionsView$Listener;-addWordToDictionary-(Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/GoogleAccountLogin;-invalidateTokens-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/phone/DataUsageListener$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/ConnectivityService;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccFileHandler;-loadEFLinearFixedAll-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/model/AccountTypeManagerImpl;-onStatusChanged-(I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cat/RilMessageDecoder$StateStart;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter;-handleCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/AccountServiceProxy$6;-run-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/downloads/DownloadThread;-notifyThroughDatabase-(I Z I Z Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/server/BluetoothPanProfileHandler;-connectPanDevice-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onRadioOffOrNotAvailable-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/data/Contact$ContactsCache;-getContactInfo-(Lcom/android/mms/data/Contact;)Lcom/android/mms/data/Contact;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/music/AudioPreview;-playPauseClicked-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/Camera;-initializeFirstTime-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth$Stub;-cancelBondProcess-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/util/Log$1;-onTerribleFailure-(Ljava/lang/String; Landroid/util/Log$TerribleFailure;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/InputMethodManagerService;-access$300-(Lcom/android/server/InputMethodManagerService;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/SnapshotTab;-<init>-(Lcom/android/browser/WebViewController; J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/media/IRingtonePlayer$Stub;-stopAsync-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/PushReceiver;-access$000-(Landroid/content/Context; Lcom/google/android/mms/pdu/GenericPdu; I)J' : ['android.permission.READ_SMS'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/NfcAdapter;-setBeamPushUrisCallback-(Landroid/nfc/NfcAdapter$CreateBeamUrisCallback; Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Lcom/android/browser/TabControl;-setCurrentTab-(Lcom/android/browser/Tab; Z)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/text/StringSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternView;-handleActionUp-(Landroid/view/MotionEvent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity$BluetoothTransferContentObserver;-onChange-(Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/editor/ContactEditorFragment$PhotoHandler$PhotoEditorListener;-onUseAsPrimaryChosen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/NfcAdapter;-enableForegroundDispatch-(Landroid/app/Activity; Landroid/app/PendingIntent; [Landroid/content/IntentFilter; [[Ljava/lang/String;)V' : ['android.permission.NFC'],
	'Lcom/android/contacts/list/EmailAddressListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/ui/GestureRecognizer$Listener;-onSingleTapUp-(F F)Z' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Landroid/filterpacks/videosrc/MediaSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/PagedViewWithDraggableItems;-beginDragging-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/model/EntityModifier;-parseExtras-(Landroid/content/Context; Lcom/android/contacts/model/AccountType; Lcom/android/contacts/model/EntityDelta; Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/am/ActivityManagerService;-wakingUp-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AllInOneActivity;-onBackPressed-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/bluetooth/IBluetoothHeadset;-isAudioConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/commands/bmgr/Bmgr;-doWipe-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupBrowseListFragment;-access$400-(Lcom/android/contacts/group/GroupBrowseListFragment;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/BluetoothHandsfree$3;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView;-recreateLockScreen-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/ContentService;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/ContactsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/contacts/socialwidget/SocialWidgetProvider$1;-onLoadComplete-(Landroid/content/Loader; Lcom/android/contacts/ContactLoader$Result;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView;-wakeWhenReadyTq-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/net/IThrottleManager$Stub;-getCliffThreshold-(Ljava/lang/String; I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/sip/SipEditor;-access$400-(Lcom/android/phone/sip/SipEditor;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/InLineSettingRestore;-changeIndex-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/ISms$Stub;-getAllMessagesFromIccEf-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPin2ForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/AsyncRunner;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree;-access$6000-(Lcom/android/phone/BluetoothHandsfree;)Landroid/bluetooth/AtCommandResult;' : ['com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/input/InputManagerService;-start-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/UIControllerOnePane;-onActivityStart-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/accounts/IAccountManager$Stub;-getAccounts-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/VibratorService;-access$200-(Lcom/android/server/VibratorService;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$WifiStateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/activity/MessageViewFragment;-onDelete-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/emailcommon/service/ServiceProxy$ProxyRunnable;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-access$1600-(Lcom/android/calendar/agenda/AgendaWindowAdapter; Lcom/android/calendar/agenda/AgendaWindowAdapter$QuerySpec;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/SipCallOptionHandler;-createSipPhoneIfNeeded-(Landroid/net/sip/SipProfile;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.USE_SIP'],
	'Lcom/android/contacts/editor/ContactEditorFragment$JoinSuggestedContactDialogFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifyDataConnection-(Lcom/android/internal/telephony/Phone; Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/Phone$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/Phone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/nxp/NativeNfcManager;-notifyLlcpLinkActivation-(Lcom/android/nfc/nxp/NativeP2pDevice;)V' : ['android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-rejectCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-hangup-(Lcom/android/internal/telephony/Connection;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-killAllBackgroundProcesses-()V' : ['android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/server/sip/SipService$IntervalMeasurementProcess;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/DayView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-<init>-(Landroid/content/Context; Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/Use2GOnlyCheckBoxPreference;-onClick-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/CdmaVoicePrivacyCheckBoxPreference$MyHandler;-handleSetVPResponse-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothAdapter;-createNewRfcommSocketAndRecord-(Ljava/lang/String; Ljava/util/UUID; Z Z)Landroid/bluetooth/BluetoothServerSocket;' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$IncomingA2dp;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/EmailAddressListAdapter;-bindQuickContact-(Lcom/android/contacts/list/ContactListItemView; I Landroid/database/Cursor; I I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/ResizeFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth;-setPin-(Ljava/lang/String; [B)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/WifiService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_MULTICAST_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/detail/ContactDetailLayoutController;-<init>-(Landroid/app/Activity; Landroid/os/Bundle; Landroid/app/FragmentManager; Lcom/android/contacts/widget/TransitionAnimationView; Landroid/view/View; Lcom/android/contacts/detail/ContactDetailFragment$Listener;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE', 'android.permission.NFC'],
	'Lcom/android/calendar/alerts/AlertReceiver;-makeExpandingNotification-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; J J J I Z Z)Lcom/android/calendar/alerts/AlertService$NotificationWrapper;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/policy/impl/KeyguardScreenCallback;-forgotPattern-(Z)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/preference/VolumePreference;-cleanup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/wifi/WifiSettings;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/pm/ShutdownThread;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.VIBRATE'],
	'Lcom/android/contacts/editor/SplitContactConfirmationDialogFragment$Listener;-onSplitContactConfirmed-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/accounts/IAccountManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/server/BluetoothPanProfileHandler;-enableTethering-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/accounts/SyncSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/AccountsChangedReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/Settings$WirelessSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/sip/SipService;-access$1300-(Lcom/android/server/sip/SipService; Landroid/net/sip/SipProfile; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager;-getPackageGids-(Ljava/lang/String;)[I' : ['android.permission.READ_EXTERNAL_STORAGE'],
	'Lcom/android/server/am/ActivityManagerService;-access$200-(Lcom/android/server/am/ActivityManagerService; Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/content/SyncManager;-sendSyncFinishedOrCanceledMessage-(Landroid/content/SyncManager$ActiveSyncContext; Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/INetworkPolicyManager;-getNetworkQuotaInfo-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onTrySetupData-(Lcom/android/internal/telephony/ApnContext;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/KeyguardScreenCallback;-pokeWakelock-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/camera/VideoCamera;-onUserInteraction-()V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/email/service/PolicyService$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-stopDtmf-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserBookmarksPage$OpenAllInTabsTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/wifi/WifiManager$MulticastLock;-release-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/media/IAudioService;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$FullImageJob;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/VideoCamera$MyBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-getContactMethodType-(Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/group/GroupBrowseListFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiStateMachine;-access$8000-(Landroid/net/wifi/WifiStateMachine;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-syncReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/am/ActivityStack;-moveTaskToFrontLocked-(Lcom/android/server/am/TaskRecord; Lcom/android/server/am/ActivityRecord; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/commands/svc/PowerCommand;-run-([Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-access$000-(Lcom/android/mms/transaction/SmsReceiverService; Landroid/content/Intent; I)V' : ['android.permission.SEND_SMS', 'android.permission.READ_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.VIBRATE'],
	'Landroid/net/wifi/IWifiManager;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ShortcutIntentBuilder$ContactLoadingAsyncTask;-loadPhoto-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-disableSingleLocationUpdate-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ThrottleService;-shutdown-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/PhotoView;-buildFallbackEffect-(Lcom/android/gallery3d/ui/GLView; Lcom/android/gallery3d/ui/GLCanvas;)Lcom/android/gallery3d/ui/PhotoFallbackEffect;' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/LocationManagerService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService$AppDeathRecipient;-binderDied-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/ConnectivityService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/LocalBluetoothManager;-getInstance-(Landroid/content/Context;)Lcom/android/settings/bluetooth/LocalBluetoothManager;' : ['android.permission.BLUETOOTH'],
	'Landroid/server/BluetoothA2dpService;-access$100-(Landroid/server/BluetoothA2dpService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothSocket;-<init>-(I I Z Z Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/media/effect/FilterGraphEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/location/ILocationManager$Stub$Proxy;-addGpsStatusListener-(Landroid/location/IGpsStatusListener;)Z' : ['android.permission.ACCESS_FINE_LOCATION'],
	'Lcom/android/internal/telephony/sip/SipPhone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-switchWaitingOrHoldingAndActive-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag$Stub;-close-(I)I' : ['android.permission.NFC'],
	'Lcom/android/emailcommon/service/IEmailService;-stopSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/ContactStatusLoader;-getContactInfo-(Landroid/content/Context; Ljava/lang/String;)Lcom/android/email/activity/ContactStatusLoader$Result;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/deskclock/SetAlarm$6;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/text/StringSource;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothEventLoop;-onDeviceCreated-(Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/PhoneBase;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/Utils;-showError-(Landroid/content/Context; Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/UserDictionary;-loadDictionaryAsync-()V' : ['android.permission.READ_USER_DICTIONARY'],
	'Lcom/android/mms/transaction/SmsReceiverService;-access$200-(Lcom/android/mms/transaction/SmsReceiverService;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/media/MediaRecorder;-setVideoSource-(I)V' : ['android.permission.CAMERA'],
	'Lcom/android/settings/Settings$PrivacySettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/group/GroupEditorFragment;-onAccountChosen-(Lcom/android/contacts/model/AccountWithDataSet; Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/nfc/tech/NdefFormatable;-connect-()V' : ['android.permission.NFC'],
	'Landroid/nfc/Tag;-rediscover-()Landroid/nfc/Tag;' : ['android.permission.NFC'],
	'Lcom/android/server/MountService;-unmountVolume-(Ljava/lang/String; Z Z)V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/providers/contacts/VoicemailPermissions;-packageHasFullAccess-(Ljava/lang/String;)Z' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/filterpacks/videoproc/BackDropperFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$ApplyRoutingTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/PhotoEditorView$1;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/downloads/DownloadThread;-updateDatabaseFromHeaders-(Lcom/android/providers/downloads/DownloadThread$State; Lcom/android/providers/downloads/DownloadThread$InnerState;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/music/MediaPlaybackService$5;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/KeyguardUpdateMonitor;-handleUserChanged-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/bluetooth/BluetoothDeviceProfileState;-sendConnectionAccessIntent-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/data/WorkingMessage;-access$1500-(Lcom/android/mms/data/WorkingMessage; Lcom/android/mms/data/Conversation; Ljava/lang/String;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/CallDetailActivityQueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/PickerActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.CAMERA', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.RECORD_AUDIO', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.NFC'],
	'Lcom/android/mms/ui/AudioAttachmentView;-onPlaybackError-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/CryptKeeper;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity$PersistTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub;-getConnectedInputDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/net/ConnectivityManager;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/connectivity/Vpn$LegacyVpnRunner;-execute-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$5;-onChange-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/LatinKeyboardView;-processMotionEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Lcom/android/server/WifiService;-enforceMulticastChangePermission-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/server/InputMethodManagerService$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-disconnectHeadsetInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPuk2ForApp-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-switchWaitingOrHoldingAndActive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/EffectsRecorder;-startPreview-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/calendar/EventInfoFragment;-showContactInfo-(Lcom/android/calendar/CalendarEventModel$Attendee; Landroid/graphics/Rect;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/ui/PhotoView$1;-onClick-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/Connection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/AttendeesView;-addAttendees-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/IConnectivityManager$Stub;-getNetworkInfo-(I)Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/IConnectivityManager;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/ThrottleManager;-getByteCount-(Ljava/lang/String; I I I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processPlayTone-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/UserHistoryDictionary;-<init>-(Landroid/content/Context; Ljava/lang/String; I Landroid/content/SharedPreferences;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/view/RotationPolicy;-setRotationLockForAccessibility-(Landroid/content/Context; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$BluetoothSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/XLargeUi;-<init>-(Landroid/app/Activity; Lcom/android/browser/UiController;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/phone/BluetoothHandsfree$30;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/common/widget/GroupingListAdapter;-onContentChanged-()V' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/contacts/list/ContactListFilterController;-setContactListFilter-(Lcom/android/contacts/list/ContactListFilter; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth$Stub;-disconnectHeadset-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Tab;-createSubWindow-()Z' : ['android.permission.INTERNET'],
	'Lcom/android/providers/contacts/ContactsProvider2;-insertSettings-(Landroid/net/Uri; Landroid/content/ContentValues;)J' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/vpndialogs/ManageDialog;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/launcher2/SmoothPagedView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$ClassChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-executeNextState-(Lcom/android/server/BackupManagerService$BackupState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-doFinish-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.USE_CREDENTIALS', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/BluetoothDeviceFilter$NapFilter;-matches-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/Phone;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine;-stopTethering-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/TechListChooserActivity;-onStop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/net/wifi/WifiStateMachine$DriverLoadingState$1;-run-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcAdapterExtras;-getCardEmulationRoute-(Ljava/lang/String;)I' : ['android.permission.NFC'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getAuthToken-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Z Landroid/os/Bundle;)V' : ['android.permission.USE_CREDENTIALS'],
	'Landroid/server/BluetoothEventLoop;-onPanDeviceConnectionResult-(Ljava/lang/String; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendEnvelopeWithStatus-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/ActivityState;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/CdmaSubscriptionListPreference;-onDialogClosed-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/IEmailService$Stub$Proxy;-hostChanged-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$23;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/KeyguardUpdateMonitor$InfoCallback;-onUserChanged-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/mms/data/Conversation;-dumpSmsTable-(Landroid/content/Context;)V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/PhoneApp$PhoneAppBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/IccProvider;-loadFromEf-(I)Landroid/database/MatrixCursor;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/launcher2/Workspace$1;-run-()V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/TetherSettings$TetherChangeReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/base/FrameStore;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/location/LocationManager;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/accounts/AccountManager;-addOnAccountsUpdatedListener-(Landroid/accounts/OnAccountsUpdateListener; Landroid/os/Handler; Z)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/SlideshowPage;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/WifiService;-getFrequencyBand-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/PatternUnlockScreen;-<init>-(Landroid/content/Context; Landroid/content/res/Configuration; Lcom/android/internal/widget/LockPatternUtils; Lcom/android/internal/policy/impl/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/KeyguardScreenCallback; I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/am/ActivityManagerService;-killApplicationWithUid-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/IAudioService$Stub;-reloadAudioSettings-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/SendTransaction;-sendPdu-([B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-updateProgressState-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.MOUNT_FORMAT_FILESYSTEMS'],
	'Lcom/android/gallery3d/app/AlbumPage$7;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/effect/effects/SepiaEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/speech/RecognitionService$RecognitionServiceBinder;-cancel-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/phone/BluetoothHandsfree$13;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/Welcome$1;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$2800-(Lcom/android/mms/ui/ComposeMessageActivity; J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-initialize-(Landroid/os/Bundle; J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/transaction/MessagingNotification;-addSmsNotificationInfos-(Landroid/content/Context; Ljava/util/Set;)V' : ['android.permission.READ_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.WRITE_SMS'],
	'Landroid/bluetooth/BluetoothDevice;-createRfcommSocketToServiceRecord-(Ljava/util/UUID;)Landroid/bluetooth/BluetoothSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/CropView$HighlightRectangle;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MediaPlaybackActivity;-access$600-(Lcom/android/music/MediaPlaybackActivity;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Tab$3;-onExceededDatabaseQuota-(Ljava/lang/String; Ljava/lang/String; J J J Landroid/webkit/WebStorage$QuotaUpdater;)V' : ['android.permission.VIBRATE'],
	'Landroid/server/BluetoothService;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/EasSyncService;-validateAccount-(Lcom/android/emailcommon/provider/HostAuth; Landroid/content/Context;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getPanDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/test/FragmentTestActivity;-onStart-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ApplicationSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/spellcheck/DictionaryPool;-take-()Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterfw/core/Filter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/vcard/NotificationImportExportListener;-onImportParsed-(Lcom/android/contacts/vcard/ImportRequest; I Lcom/android/vcard/VCardEntry; I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/UI;-onBackKey-()Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/wifi/WifiManager;-setWifiApConfiguration-(Landroid/net/wifi/WifiConfiguration;)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/gallery3d/ui/PhotoView;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/accounts/SyncSettings;-onPause-()V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/location/GpsLocationProvider;-handleUpdateNetworkState-(I Landroid/net/NetworkInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$RssiMonitoringState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/TetherSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-hideSearchPanel-()V' : ['android.permission.VIBRATE'],
	'Landroid/net/sip/SipAudioCall;-transferToNewSession-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/BluetoothA2dp;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/downloads/DownloadNotification;-notificationForCompletedDownload-(J Ljava/lang/String; I I J)V' : ['android.permission.VIBRATE'],
	'Landroid/net/sip/ISipService;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/nfc/P2pEventManager;-onP2pReceiveComplete-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/list/ContactListFilterControllerImpl;-checkFilterValidity-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-setShuffleMode-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/SearchActivity;-handleIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/downloads/StorageManager;-verifySpaceBeforeWritingToFile-(I Ljava/lang/String; J)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/vcard/VCardEntry$PhotoData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/PhoneUtils;-separateCall-(Lcom/android/internal/telephony/Connection;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/inputmethod/latin/UserDictionary;-<init>-(Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/ContactEntryListFragment;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/data/Conversation$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.READ_SMS'],
	'Lcom/android/contacts/activities/TransactionSafeActivity;-onPrepareOptionsMenu-(Landroid/view/Menu;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/EventInfoFragment;-updateAttendees-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/server/BluetoothService;-removeBondInternal-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider;-updateWidget-(Landroid/content/Context;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/provider/Contacts$Settings;-getSetting-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-supplyPuk-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-copyMessageToIccEf-(I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/emailcommon/service/IAccountService$Stub;-notifyLoginFailed-(J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/ConnectivityService;-getLastTetherError-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/WirelessSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-getContactUriForPhoneNumber-(Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/ShortcutIntentBuilder$PhoneNumberLoadingAsyncTask;-loadPhoto-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/model/AccountTypeManagerImpl;-getUsableInvitableAccountTypes-()Ljava/util/Map;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/Settings$ManageAccountsSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/voicedialer/RecognizerClient;-onMicrophoneStart-(Ljava/io/InputStream;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-access$100-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/contacts/group/SuggestedMemberListAdapter$SuggestedMemberFilter;-performFiltering-(Ljava/lang/CharSequence;)Landroid/widget/Filter$FilterResults;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/activity/UIControllerTwoPane$ActionBarControllerCallback;-onAccountSelected-(J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/WifiService;-getWifiApConfiguration-()Landroid/net/wifi/WifiConfiguration;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/DownloadHandler;-onDownloadStart-(Landroid/app/Activity; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Z)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/gallery3d/app/Gallery;-onCreateOptionsMenu-(Landroid/view/Menu;)Z' : ['android.permission.NFC'],
	'Landroid/app/IBackupAgent$Stub;-doRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasAccountService;-postAutodiscover-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; Z)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/RefreshManager;-refreshMessageList-(J J Z)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/activity/UIControllerBase;-updateMessageOrderManager-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/server/BluetoothAdapterStateMachine$PerProcessState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth$Stub;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/AccessibilityEnableScriptInjectionPreference;-setSystemSetting-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler$PhotoListener;-onPhotoSelected-(Landroid/graphics/Bitmap;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/sip/SipService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-getBatteryUsageHint-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothPbap;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/IPowerManager$Stub$Proxy;-acquireWakeLock-(I Landroid/os/IBinder; Ljava/lang/String; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-getIMSI-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-startDelayedRetry-(Lcom/android/internal/telephony/DataConnection$FailCause; Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/RuimRecords;-fetchRuimRecords-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/UIControllerTwoPane;-updateMessageOrderManager-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/email/activity/setup/MailboxSettings$LoadMailboxTask;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-startWifi-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothDevicePreference;-onClicked-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler;-setNumberOfPairedDevices-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/users/UserSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/CallNotifier;-onCfiChanged-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-handleCallKey-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-open-([J I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/UndoBarView;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onStateResult-(I I Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/data/Contact;-getPhoneUri-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/base/FrameStore;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/Gallery;-startDefaultPage-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/accounts/SyncSettings;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS'],
	'Lcom/android/systemui/power/PowerUI;-playLowBatterySound-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothSettings$1;-updateDeviceName-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/HTML5Audio;-setDataSource-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/Context;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter;-access$2300-(Lcom/android/gallery3d/app/PhotoDataAdapter;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/AccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Z Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/InputMethodManagerService;-buildInputMethodListLocked-(Ljava/util/ArrayList; Ljava/util/HashMap;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/webkit/HTML5VideoViewProxy;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/common/contacts/BaseEmailAddressAdapter$DirectoryPartitionFilter;-performFiltering-(Ljava/lang/CharSequence;)Landroid/widget/Filter$FilterResults;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-restartRadio-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/WifiStateMachine$ConnectModeState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$ManageAccountsSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/MediaPlaybackActivity;-startPlayback-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/calllog/CallLogFragment;-updateOnEntry-()V' : ['android.permission.WRITE_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/IWifiManager$Stub;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/IIccPhoneBook;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/vcard/VCardEntry;-iterateAllData-(Lcom/android/vcard/VCardEntry$EntryElementIterator;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/DataUsageSummary$ConfirmLimitFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/INetworkPolicyManager$Stub$Proxy;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/google/android/mms/util/AbstractCache;-put-(Ljava/lang/Object; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/PhotoPage;-onCommitDeleteImage-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/PhoneApp;-updateWakeState-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/storage/IMountService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.MOUNT_FORMAT_FILESYSTEMS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-handleSmsReceived-(Landroid/content/Intent; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-processNextPostDialChar-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/recent/RecentsPanelView;-handleSwipe-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/TetherSettings;-onStart-()V' : ['android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/MessageCompose$SendOrSaveMessageTask;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/inputmethod/SpellCheckersSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/BackupManagerService$PerformFullRestoreTask;-restoreOneFile-(Ljava/io/InputStream; [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/exchange/ExchangeService;-sendMessageRequest-(Lcom/android/exchange/Request;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/BluetoothHandsfree$21;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothHandsfree$26;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/SearchActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/camera/ActivityBase$MyAppBridge;-access$100-(Lcom/android/camera/ActivityBase$MyAppBridge; I)V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/PhotoView;-access$3600-(Lcom/android/gallery3d/ui/PhotoView; F F)Z' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-setBluetoothStateInt-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker;-onActualStateChange-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-getPackageGids-(Ljava/lang/String;)[I' : ['android.permission.READ_EXTERNAL_STORAGE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/PickerActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/ContentResolver;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/Settings$ManageAccountsSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/commands/monkey/Monkey;-run-([Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/BatteryStatsService;-getStatistics-()[B' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$DeviceInfoSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/telephony/SmsProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/policy/impl/KeyguardStatusViewManager$1;-onUserChanged-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-disconnect-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/music/IMediaPlaybackService;-removeTrack-(J)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/pm/PackageManagerService;-replaceSystemPackageLI-(Landroid/content/pm/PackageParser$Package; Landroid/content/pm/PackageParser$Package; I I Ljava/lang/String; Lcom/android/server/pm/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-acquireWakeLock-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/IConnectivityManager$Stub;-untether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/P2pEventListener;-onP2pSendComplete-()V' : ['android.permission.VIBRATE'],
	'Landroid/provider/Browser;-getVisitedHistory-(Landroid/content/ContentResolver;)[Ljava/lang/String;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/ui/ComposeMessageActivity$17;-run-()V' : ['android.permission.READ_SMS'],
	'Lcom/android/exchange/EasSyncService;-sendHttpClientPost-(Ljava/lang/String; [B)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothAtPhonebook;-getPhonebookResult-(Ljava/lang/String; Z)Lcom/android/phone/BluetoothAtPhonebook$PhonebookResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/phone/Ringer;-stopRing-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/uiautomator/core/UiDevice;-setOrientationRight-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/ITelephony$Stub;-getCellLocation-()Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/WifiManager$WifiLock;-finalize-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/ContactsDictionary;-startDictionaryLoadingTaskLocked-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/activity/MessageListFragment;-access$2200-(Lcom/android/email/activity/MessageListFragment;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/webkit/HTML5VideoFullScreen;-pauseAndDispatch-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WifiSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$StateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-confirmCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Landroid/os/Bundle; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/AlarmClock;-access$100-(Lcom/android/deskclock/AlarmClock; Z Lcom/android/deskclock/Alarm;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$PrivacySettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-disable-(I)V' : ['android.permission.VIBRATE'],
	'Landroid/bluetooth/BluetoothInputDevice;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/NsdService$NsdStateMachine;-<init>-(Lcom/android/server/NsdService; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/LocalePicker;-onLocaleSelected-(Ljava/util/Locale;)V' : ['android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/internal/app/IBatteryStats$Stub;-getAwakeTimePlugged-()J' : ['android.permission.BATTERY_STATS'],
	'Landroid/net/nsd/INsdManager;-setEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/MessageUtils;-handleReadReport-(Landroid/content/Context; Ljava/util/Collection; I Ljava/lang/Runnable;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/commands/am/Am;-runKillAll-()V' : ['android.permission.KILL_BACKGROUND_PROCESSES'],
	'Landroid/net/ConnectivityManager;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/PhoneBase;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-handleShift-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-onOptionalFieldVisibilityChange-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/PhoneUtils;-switchHoldingAndActive-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/spellcheck/AndroidSpellCheckerService;-onSharedPreferenceChanged-(Landroid/content/SharedPreferences; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/location/LocationProviderInterface;-updateLocation-(Landroid/location/Location;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ContactListAdapter;-bindQuickContact-(Lcom/android/contacts/list/ContactListItemView; I Landroid/database/Cursor; I I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/systemui/recent/RecentsVerticalScrollView$3;-onClick-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/internal/telephony/cdma/RuimFileHandler;-loadEFLinearFixedAll-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothNameDialogFragment$3;-onEditorAction-(Landroid/widget/TextView; I Landroid/view/KeyEvent;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-getContactsSize-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetooth$Stub;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/PhoneCallDetailsHelper;-setCallDetailsHeader-(Landroid/widget/TextView; Lcom/android/contacts/PhoneCallDetails;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/RIL;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessagesAdapter$MessagesCursorLoader;-loadInBackground-()Landroid/database/Cursor;' : ['android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/data/MediaSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/ex/variablespeed/SingleThreadedMediaPlayerProxy;-prepare-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/IVibratorService;-vibrate-(J Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/gallery3d/ui/GLView;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/net/DataUsageMeteredSettings;-updateNetworks-(Landroid/content/Context;)V' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/BitmapSource;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/calllog/CallLogQueryHandler;-fetchCalls-(I I Z Z)V' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/provider/Browser;-clearSearches-(Landroid/content/ContentResolver;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/videoproc/BackDropperFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/IVibratorService;-vibratePattern-([J I Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/systemui/statusbar/phone/NavigationBarView;-onInterceptTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/browser/UrlInputView;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-makeStatusBarView-()Landroid/view/View;' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onReplay-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-killAppAtUsersRequest-(Lcom/android/server/am/ProcessRecord; Landroid/app/Dialog;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/nfc/INfcTag;-resetTimeouts-()V' : ['android.permission.NFC'],
	'Lcom/android/email/service/MailService$3;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/ui/ScrollBarView;-renderChild-(Lcom/android/gallery3d/ui/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/gallery3d/app/Gallery;-startGetContent-(Landroid/content/Intent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/DataUsageSummary$UidDetailTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/alerts/AlertService;-rescheduleMissedAlarms-(Landroid/content/ContentResolver; Landroid/content/Context; Landroid/app/AlarmManager;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/inputmethod/UserDictionaryAddWordContents;-apply-(Landroid/content/Context;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/MessagingNotification$3;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Integer;' : ['android.permission.READ_SMS'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-start-()V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/wifi/IWifiManager;-releaseWifiLock-(Landroid/os/IBinder;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/ActionBarController$3;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothA2dp;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-freeStorage-(J Landroid/content/IntentSender;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Landroid/bluetooth/IBluetooth;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Landroid/media/AudioService$SetModeDeathHandler;-binderDied-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityManagerService;-serviceTimeout-(Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-listen-(Ljava/lang/String; Lcom/android/internal/telephony/IPhoneStateListener; I Z)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/detail/ContactDetailTabCarousel;-loadData-(Lcom/android/contacts/ContactLoader$Result;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/SlideViewInterface;-setAudio-(Landroid/net/Uri; Ljava/lang/String; Ljava/util/Map;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/contacts/list/ContactEntryListFragment;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/DataUsageListener;-updatePolicy-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/accounts/AccountManager;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity;-access$000-(Lcom/android/contacts/activities/PhotoSelectionActivity;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/BluetoothHandsfree$13;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/PhoneUi;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-ensurePaired-()Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/SoundSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-notifyAndAcknowledgeLastIncomingSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-reportInetCondition-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper;-access$200-(Lcom/android/wallpaper/walkaround/WalkAroundWallpaper;)V' : ['android.permission.CAMERA'],
	'Lcom/android/nfc/NfcDispatcher;-dispatchTag-(Landroid/nfc/Tag;)Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothHeadset;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/server/BluetoothInputProfileHandler;-connectInputDeviceInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHeadsetService$6;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-pollState-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/app/ManageCachePage;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/Controller;-openTabToHomePage-()Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendShowPinReqToFrontApp-(Ljava/lang/String;)Z' : ['android.permission.GET_TASKS'],
	'Lcom/android/contacts/test/FragmentTestActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/camera/PanoramaActivity;-onThumbnailClicked-(Landroid/view/View;)V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Landroid/view/IWindowManager$Stub;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/policy/impl/KeyguardUpdateMonitor;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/NfcService$NfcAdapterService;-enableNdefPush-()Z' : ['android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/ISyncAdapter;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/accounts/AccountManager;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/nfc/tech/NfcB;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Lcom/android/server/TelephonyRegistry;-broadcastSignalStrengthChanged-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/VideoView;-setVideoURI-(Landroid/net/Uri; Ljava/util/Map;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppNotification;-access$500-(Lcom/android/bluetooth/opp/BluetoothOppNotification;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/gallery3d/ui/PhotoView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/bluetooth/DockService;-getCachedBluetoothDevice-(Landroid/bluetooth/BluetoothDevice;)Lcom/android/settings/bluetooth/CachedBluetoothDevice;' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/TransactionSafeActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/fuelgauge/BatteryHistoryDetail;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/provider/Browser;-deleteHistoryTimeFrame-(Landroid/content/ContentResolver; J J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/exchange/EasAccountService;-runPingLoop-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mms/ui/SlideshowActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/ContactsUtils;-areContactWritableAccountsAvailable-(Landroid/content/Context;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onUpEvent-(I I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetooth;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/util/Recycler;-checkForThreadsOverLimit-(Landroid/content/Context;)Z' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/gsm/SimPhoneBookInterfaceManager;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CallManager;-acceptCall-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarEventModel;-<init>-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback$Stub;-loadAttachmentStatus-(J J I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/CalendarController;-sendEvent-(Ljava/lang/Object; J Landroid/text/format/Time; Landroid/text/format/Time; J I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/InCallScreen;-bailOutAfterErrorDialog-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/provider/Browser;-truncateHistory-(Landroid/content/ContentResolver;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/ConnectivityService;-access$1100-(Lcom/android/server/ConnectivityService; Landroid/net/NetworkInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/os/storage/IMountService$Stub$Proxy;-mountVolume-(Ljava/lang/String;)I' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/settings/DataUsageSummary;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/agenda/AgendaListView$2;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setLine1Number-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/MenuExecutor$MediaOperation;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/BluetoothHandsfree$19;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothHealth;-disconnectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.CAMERA', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.RECORD_AUDIO', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.NFC'],
	'Lcom/android/server/WallpaperManagerService;-setDimensionHints-(I I)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Landroid/bluetooth/IBluetooth$Stub;-allowIncomingProfileConnect-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothA2dp;-isA2dpPlaying-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$Handler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/CameraScreenNail;-directDraw-(Lcom/android/gallery3d/ui/GLCanvas; I I I I)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-sendMeetingResponse-(J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/CryptKeeper;-setAirplaneModeIfNecessary-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/content/IContentService;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker;-setImageViewResources-(Landroid/content/Context; Landroid/widget/RemoteViews;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/UsimPhoneBookManager;-refreshCache-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountServerBaseFragment$4;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$12;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/inputmethodservice/KeyboardView;-onLongPress-(Landroid/inputmethodservice/Keyboard$Key;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/exchange/ExchangeService$1$1;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/agenda/AgendaListView;-initView-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/calendar/agenda/AgendaListView$3;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/nio/charset/Charset; Lcom/google/common/io/OutputSupplier;)V' : ['android.permission.INTERNET'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-startSync-(J Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/nfc/INfcTag;-transceive-(I [B Z)Landroid/nfc/TransceiveResult;' : ['android.permission.NFC'],
	'Landroid/telephony/TelephonyManager;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-finish-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$ErrorState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/calendar/CalendarProvider2;-deleteMatchingColors-(Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.READ_CALENDAR'],
	'Landroid/content/ISyncAdapter$Stub;-startSync-(Landroid/content/ISyncContext; Ljava/lang/String; Landroid/accounts/Account; Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/nfc/INfcTag;-rediscover-(I)Landroid/nfc/Tag;' : ['android.permission.NFC'],
	'Lcom/android/calendar/DayView;-access$4600-(Lcom/android/calendar/DayView; Landroid/view/MotionEvent;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/util/ReverseGeocoder;-lookupAddress-(D D Z)Landroid/location/Address;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/IRingtonePlayer$Stub;-stop-(Landroid/os/IBinder;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$13;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/DeleteEventHelper$5;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/pm/ShutdownThread;-rebootOrShutdown-(Z Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-updateSpnDisplay-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/PhoneFavoriteFragment;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/HTML5VideoView;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/UI;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/media/IAudioService;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-enableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumPage;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/AccessibilitySettings$ToggleAccessibilityServicePreferenceFragment;-onPreferenceToggled-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/EffectsRecorder$4;-onRunnerDone-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/email/activity/setup/AccountSetupIncoming;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/PhoneProxy;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onApnChanged-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/LocationManager;-requestSingleUpdate-(Landroid/location/Criteria; Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/bluetooth/BluetoothNameDialogFragment;-setDeviceName-(Ljava/lang/String;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/RingtoneManager;-getRingtone-(I)Landroid/media/Ringtone;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneFallbackEventHandler;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Landroid/accounts/AccountManager$3;-startTask-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/RuimSmsInterfaceManager;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Landroid/server/BluetoothEventLoop;-onDeviceDisconnectRequested-(Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/voicedialer/VoiceDialerActivity$3;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/BluetoothHandsfree$10;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-changeVolumeBy-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarUtils$TimeZoneUtils;-getTimeZone-(Landroid/content/Context; Ljava/lang/Runnable;)Ljava/lang/String;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/browser/Tab;-<init>-(Lcom/android/browser/WebViewController; Landroid/webkit/WebView; Landroid/os/Bundle;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/base/ObjectSource;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccRecords;-onRecordLoaded-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_CONFIGURATION'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/deviceinfo/UsbSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneBase;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ProviderStatusWatcher$2;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/provider/CalendarContract$CalendarEntity$EntityIteratorImpl;-next-()Ljava/lang/Object;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendPdu-(J [B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/WiredAccessoryObserver;-setDevicesState-(I I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen$14;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-access$1700-(Lcom/android/bluetooth/opp/BluetoothOppService; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/server/BluetoothDeviceProperties;-updateCache-(Ljava/lang/String;)Ljava/util/Map;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/FetchUrlMimeType;-run-()V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/media/AsyncPlayer$Thread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/InputStreamSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityStack;-activityPaused-(Landroid/os/IBinder; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/detail/PhotoSelectionHandler;-getDeltaForAttachingPhotoToContact-()Lcom/android/contacts/model/EntityDeltaList;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/BluetoothHandsfree;-userWantsAudioOn-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/QuickContactDivot;-assignContactFromEmail-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$OnlineState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.INTERNET', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-refreshName-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getTetheredIfacePairs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/ExchangeService$1;-syncMailboxListStatus-(J I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallbackProxy$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthWeekEventsView;-onDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/Settings$TextToSpeechSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/accounts/AccountPreferenceBase;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/CropFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/MailService;-access$000-(Lcom/android/email/service/MailService; Landroid/content/Intent;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/vcard/VCardComposer;-init-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/quicksearchbox/google/AbstractGoogleSource;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/GlobalActions$1;-onToggle-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/WifiService;-disableNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/filterpacks/text/ToUpperCase;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager$SyncHandler;-onBootCompleted-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/event/EditEventHelper;-saveEvent-(Lcom/android/calendar/CalendarEventModel; Lcom/android/calendar/CalendarEventModel; I)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/mms/ui/ManageSimMessages;-deleteFromSim-(Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/server/BluetoothEventLoop;-onHealthDevicePropertyChanged-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/VibratorService$VibrateThread;-<init>-(Lcom/android/server/VibratorService; Lcom/android/server/VibratorService$Vibration;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothA2dpService;-access$000-(Landroid/server/BluetoothA2dpService;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetooth$Stub;-disable-(Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/RotateFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IThrottleManager$Stub$Proxy;-getCliffLevel-(Ljava/lang/String; I)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPukForApp-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/ActionBarController$AccountDropdownPopup$1;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/net/NetworkStatsService;-bootstrapStatsLocked-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/adapter/AbstractSyncParser;-commit-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/InCallScreen;-updateIncomingCallWidgetHint-(I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothHandsfree$27;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/EmailActivity;-onStart-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/IThrottleManager$Stub;-getHelpUri-()Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/activities/ContactSelectionActivity;-onQueryTextChange-(Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/RIL;-acknowledgeLastIncomingCdmaSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-freeStorageAndNotify-(J Landroid/content/pm/IPackageDataObserver;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/browser/WallpaperHandler;-openStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/server/ConnectivityService;-access$1200-(Lcom/android/server/ConnectivityService; I Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/WiredAccessoryObserver;-<init>-(Landroid/content/Context;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager;-<init>-(Landroid/content/Context; Lcom/android/settings/bluetooth/LocalBluetoothAdapter; Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager; Lcom/android/settings/bluetooth/BluetoothEventManager;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/WebIconDatabaseClassic;-retainIconForPageUrl-(Ljava/lang/String;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/media/RingtoneManager;-getRingtone-(Landroid/content/Context; Landroid/net/Uri;)Landroid/media/Ringtone;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/ActivityState;-onStateResult-(I I Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/sip/SipEditor;-unregisterProfile-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardView;-sendAccessibilityEventForUnicodeCharacter-(I I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/AllInOneActivity;-configureActionBar-(I)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/music/MusicUtils;-togglePartyShuffle-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DeviceProfilesSettings;-onDeviceAttributesChanged-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityManagerService;-attachApplicationLocked-(Landroid/app/IApplicationThread; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ChooseLockPassword$ChooseLockPasswordFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmCall;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/PhotoPage$1;-render-(Lcom/android/gallery3d/ui/GLCanvas;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/widget/ChartDataUsageView$DataUsageChartListener;-onWarningChanged-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$DockSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/nfc/INfcTag;-ndefMakeReadOnly-(I)I' : ['android.permission.NFC'],
	'Lcom/android/browser/BrowserWebViewFactory;-createWebView-(Z)Landroid/webkit/WebView;' : ['android.permission.INTERNET'],
	'Landroid/nfc/INfcAdapter;-setForegroundDispatch-(Landroid/app/PendingIntent; [Landroid/content/IntentFilter; Landroid/nfc/TechListParcel;)V' : ['android.permission.NFC'],
	'Landroid/accounts/AccountManagerService;-getAccountsByFeatures-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/data/WorkingMessage;-asyncDeleteDraftSmsMessage-(Lcom/android/mms/data/Conversation;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/app/backup/IBackupManager;-opComplete-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-getSubscriptionInfoAndStartPollingThreads-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Landroid/net/IConnectivityManager;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/nxp/NativeNfcManager;-notifyNdefMessageListeners-(Lcom/android/nfc/nxp/NativeNfcTag;)V' : ['android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/settings/accounts/AccountPreferenceBase;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/service/dreams/IDreamManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-startDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$PanStateChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/musicfx/ActivityMusic;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/commands/monkey/Monkey;-main-([Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getConnectionInfo-()Landroid/net/wifi/WifiInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/PhotoPage$PreparePhotoFallback;-onGLIdle-(Lcom/android/gallery3d/ui/GLCanvas; Z)Z' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/email/Controller$15;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/wifi/WifiSettings;-pauseWifiScan-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/ui/GLView;-renderChild-(Lcom/android/gallery3d/ui/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getVoiceMailNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mms/ui/ComposeMessageActivity$BackgroundQueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-selectDefaultContact-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/IMediaPlaybackService;-openFile-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/SmsManager;-sendDataMessage-(Ljava/lang/String; Ljava/lang/String; S [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Landroid/media/effect/effects/RedEyeEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/list/ContactEntryListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/systemui/screenshot/GlobalScreenshot;-notifyScreenshotError-(Landroid/content/Context; Landroid/app/NotificationManager;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-delete-(Landroid/net/Uri; I J)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$TagService;-formatNdef-(I [B)I' : ['android.permission.NFC'],
	'Lcom/android/settings/Settings$InputMethodAndLanguageSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/support/v4/net/ConnectivityManagerCompat$ConnectivityManagerCompatImpl;-isActiveNetworkMetered-(Landroid/net/ConnectivityManager;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/applications/ApplicationsProvider$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothPbap;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/VideoCamera;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.CAMERA', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.RECORD_AUDIO', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getOutgoingCallerIdDisplay-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarController$EventHandler;-eventsChanged-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/camera/PanoramaActivity;-onPreviewTextureCopied-()V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/list/PhoneNumberListAdapter;-getDataUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub;-createBondOutOfBand-(Ljava/lang/String; [B [B)Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/homepages/HomeProvider;-openFile-(Landroid/net/Uri; Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/vpn2/VpnSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/pm/IPackageManager$Stub;-getPackageSizeInfo-(Ljava/lang/String; Landroid/content/pm/IPackageStatsObserver;)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Landroid/net/wifi/IWifiManager$Stub;-startWifi-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccRecords;-setMsisdnNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$AccessibilitySettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-setDiscoverableTimeout-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/tech/NfcA;-transceive-([B)[B' : ['android.permission.NFC'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-setQueuePosition-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothSettings$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/UIControllerSearchTwoPane;-onRespondedToInvite-(I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/list/ContactPickerFragment;-finish-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/DevelopmentSettings;-access$100-(Lcom/android/settings/DevelopmentSettings;)V' : ['android.permission.READ_EXTERNAL_STORAGE'],
	'Lcom/android/email/Controller$Result;-updateMailboxCallback-(Lcom/android/emailcommon/mail/MessagingException; J J I I Ljava/util/ArrayList;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/provider/CalendarContract$EventsEntity$EntityIteratorImpl;-next-()Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Landroid/server/BluetoothEventLoop;-onNetworkDeviceDisconnected-(Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/OpenDownloadReceiver;-onReceiveAsync-(Landroid/content/Context; J)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/test/mock/MockContentResolver;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/filterpacks/videosrc/CameraSource;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager;-sendCheckAlarmsMessage-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/editor/TextFieldsEditorView;-onFieldChanged-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapObexServer;-pullVcardEntry-([B Lcom/android/bluetooth/pbap/BluetoothPbapObexServer$AppParamValue; Ljavax/obex/Operation; Ljava/lang/String; Ljava/lang/String;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-animateCollapse-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/ui/SlideshowPresenter;-presentSlide-(Lcom/android/mms/ui/SlideViewInterface; Lcom/android/mms/model/SlideModel;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$RunningServicesActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/app/backup/IBackupManager$Stub;-setBackupEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/Tab;-setController-(Lcom/android/browser/WebViewController;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/media/IAudioService$Stub;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/calllog/ClearCallLogDialog$1$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/calendar/event/EditEventView;-updateHomeTime-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$OutgoingHandsfree;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/widget/VideoView$6;-surfaceCreated-(Landroid/view/SurfaceHolder;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/server/BluetoothService;-unregisterAppConfiguration-(Landroid/bluetooth/BluetoothHealthAppConfiguration;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/RuimRecords;-onReady-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/server/InputMethodManagerService$SettingsObserver;-onChange-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/launcher2/WallpaperChooserDialogFragment;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/VideoCamera;-access$1200-(Lcom/android/camera/VideoCamera;)Z' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/CallFeaturesSetting;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/InCallScreen;-delayedCleanupAfterDisconnect-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/event/EditEventFragment;-access$600-(Lcom/android/calendar/event/EditEventFragment; I)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/sip/SipAudioCall;-access$700-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/BrowserWebView;-<init>-(Landroid/content/Context;)V' : ['android.permission.INTERNET'],
	'Lcom/android/phone/InCallScreen;-internalResolveIntent-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/RefreshManager;-refreshMessageList-(J J Z Z)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/emailcommon/service/IEmailService;-loadAttachment-(J Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/INetworkStatsService$Stub$Proxy;-getDataLayerSnapshotForUid-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/EmergencyDialer;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/server/WifiService;-startScan-(Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/email/activity/MessageViewFragment;-onMarkMessageAsRead-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$DataUsageSummaryActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NsdService;-setEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-addAccount-(Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/email/service/EmailServiceUtils;-isServiceAvailable-(Landroid/content/Context; Ljava/lang/String;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkPolicyManagerService$8;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/adapter/AttachmentLoader;-doStatusCallback-(I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/location/GpsLocationProvider;-addListener-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-sendEmptyFlash-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/AccountManager;-updateCredentials-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-setRepeatMode-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/MediaPlayer;-access$300-(Landroid/media/MediaPlayer; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-getBatteryUsageHint-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/downloads/DownloadProvider;-openFile-(Landroid/net/Uri; Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-startDelayedRetry-(Lcom/android/internal/telephony/DataConnection$FailCause; Lcom/android/internal/telephony/ApnContext; I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$NfcAdapterExtrasService;-transceive-(Ljava/lang/String; [B)Landroid/os/Bundle;' : ['android.permission.NFC'],
	'Landroid/filterpacks/base/GLTextureTarget;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onDataStallAlarm-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/SecurityPolicy;-policiesRequired-(J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/transaction/Transaction;-notifyObservers-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_SMS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/gallery3d/app/PhotoPage;-onCreate-(Landroid/os/Bundle; Landroid/os/Bundle;)V' : ['android.permission.NFC'],
	'Lcom/android/server/am/ActivityManagerService;-handleAppCrashLocked-(Lcom/android/server/am/ProcessRecord;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/ISms$Stub;-enableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback$Stub$Proxy;-loadAttachmentStatus-(J J I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/media/MediaScanner$MyMediaScannerClient;-endFile-(Landroid/media/MediaScanner$FileEntry; Z Z Z Z Z)Landroid/net/Uri;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/InputMethodManagerService;-resetSelectedInputMethodAndSubtypeLocked-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/activities/PeopleActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/SuggestionCursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-open-([J I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-notifyNoData-(Lcom/android/internal/telephony/DataConnection$FailCause;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/voicedialer/VoiceContact;-getVoiceContacts-(Landroid/app/Activity;)Ljava/util/List;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ui/PhotoView;-snapToNeighborImage-()Z' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/CallerInfoAsyncQuery;-startQuery-(I Landroid/content/Context; Ljava/lang/String; Lcom/android/internal/telephony/CallerInfoAsyncQuery$OnQueryCompleteListener; Ljava/lang/Object;)Lcom/android/internal/telephony/CallerInfoAsyncQuery;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/downloads/StorageManager;-findSpace-(Ljava/io/File; J I)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-suspendSink-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;-<init>-(Landroid/content/Context; Lcom/android/emailcommon/provider/EmailContent$Attachment; Landroid/widget/ProgressBar;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/list/PhoneNumberListAdapter;-bindQuickContact-(Lcom/android/contacts/list/ContactListItemView; I Landroid/database/Cursor; I I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/soundrecorder/SoundRecorder;-onStop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityManagerService;-shutdown-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-hangupWaitingOrBackground-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AllInOneActivity;-access$700-(Lcom/android/calendar/AllInOneActivity; J)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/email/GroupMessagingListener;-loadAttachmentFailed-(J J J Lcom/android/emailcommon/mail/MessagingException; Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/BluetoothHandsfree$2;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-access$1100-(Lcom/android/server/net/NetworkPolicyManagerService;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/calllog/CallLogAdapter;-startRequestProcessing-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getNetworkPreference-()I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/WebIconDatabaseClassic;-close-()V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/SerialService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SERIAL_PORT'],
	'Lcom/android/server/LocationManagerService;-initialize-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/google/common/io/Files;-getChecksum-(Ljava/io/File; Ljava/util/zip/Checksum;)J' : ['android.permission.INTERNET'],
	'Lcom/android/settings/bluetooth/DockService;-msgTypeDisableBluetooth-(I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/InCallScreen;-requestRemoveProviderInfoWithDelay-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-disconnectPanDevice-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-answerAndEndActive-(Lcom/android/internal/telephony/CallManager; Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/statusbar/policy/NetworkController;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-interceptFallback-(Landroid/view/WindowManagerPolicy$WindowState; Landroid/view/KeyEvent; I)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.CALL_PHONE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-dispatch-(Landroid/content/Intent; Ljava/lang/String; Landroid/content/BroadcastReceiver;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-connectChannelToSink-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller$5;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/accounts/AccountPreferenceBase;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-handleCancel-(Landroid/view/MotionEvent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.USE_CREDENTIALS', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/widget/WaveView;-setGrabbedState-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/gallery3d/app/AlbumPage;-onUpPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/webkit/WebIconDatabaseClassic$EventHandler;-access$500-(Landroid/webkit/WebIconDatabaseClassic$EventHandler; Landroid/os/Message;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/email/MessagingController;-loadAttachment-(J J J J Lcom/android/email/MessagingListener; Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/sip/SipAudioCall$1;-onCallBusy-(Landroid/net/sip/SipSession;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Tab;-putInForeground-()V' : ['android.permission.INTERNET'],
	'Lcom/android/calendar/AllInOneActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/provider/CalendarContract$EventsEntity$EntityIteratorImpl;-getEntityAndIncrementCursor-(Landroid/database/Cursor;)Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/app/DialogPicker;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/OtaUtils;-otaPerformActivation-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/InputMonitor;-notifyANR-(Lcom/android/server/input/InputApplicationHandle; Lcom/android/server/input/InputWindowHandle;)J' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/preference/DisplayOrderPreference;-persistString-(Ljava/lang/String;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/calendar/DayView$CalendarGestureListener;-onScroll-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; F F)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/AdnRecordLoader;-loadAllFromEF-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/PhotoView$FullPicture;-draw-(Lcom/android/gallery3d/ui/GLCanvas; Landroid/graphics/Rect;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/camera/CameraPreference$OnPreferenceChangedListener;-onSharedPreferenceChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/MailboxFinder$FindMailboxTask;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/BluetoothHeadsetService$6;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/IccCard;-handleIccCardStatus-(Lcom/android/internal/telephony/IccCardStatus;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/vcard/VCardParserImpl_V21;-parseItem-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/BluetoothHandsfree;-userWantsAudioOff-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/data/Conversation;-dumpThreadsTable-(Landroid/content/Context;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/contacts/vcard/ImportVCardActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/browser/Tab$3;-onRequestFocus-(Landroid/webkit/WebView;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/accounts/IAccountManager;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/settings/Settings$UserDictionarySettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/accounts/AccountManager$5;-doWork-()V' : ['android.permission.USE_CREDENTIALS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapObexServer;-<init>-(Landroid/os/Handler; Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/net/wifi/WifiStateMachine;-access$7900-(Landroid/net/wifi/WifiStateMachine;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/SecuritySettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/hardware/ISerialManager$Stub;-openSerialPort-(Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.SERIAL_PORT'],
	'Landroid/media/RingtoneManager;-getRingtone-(Landroid/content/Context; Landroid/net/Uri; I)Landroid/media/Ringtone;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CallerInfoCache;-refreshCacheEntry-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-onRegistrationTimeout-(Landroid/net/sip/ISipSession;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$TextToSpeechSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/LegacyPhoneNumberListAdapter;-getPhoneUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/IWifiManager;-releaseMulticastLock-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/bluetooth/IBluetooth;-createBondOutOfBand-(Ljava/lang/String; [B [B)Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/Controller$ControllerService$1;-loadAttachment-(J Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/AllowBindAppWidgetActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-load-()V' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Landroid/server/BluetoothService;-readOutOfBandData-()[B' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/util/StateMachine$SmHandler$QuittingState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/IContentService;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/server/BluetoothService;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/RadioInfo$12;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/email/activity/UIControllerBase;-onActivityStart-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/ContactsDictionary;-reloadDictionaryIfRequired-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter;-isSyncable-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/sip/SipSettings$1;-run-()V' : ['android.permission.USE_SIP'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-bindEditors-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/UIControllerTwoPane;-onActivityCreated-()V' : ['android.permission.NFC'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/InCallScreen;-dontAddVoiceMailNumber-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/calllog/DefaultVoicemailNotifier$NameLookupQuery;-query-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/editor/ContactEditorUtils;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/location/LocationManager;-requestSingleUpdate-(Ljava/lang/String; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/ChangeIccPinScreen$2;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-getTasks-(I I Landroid/app/IThumbnailReceiver;)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Landroid/filterpacks/base/RetargetFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/ObjectSource;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DockService$1;-run-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/UIControllerBase;-onActivityCreated-()V' : ['android.permission.NFC'],
	'Lcom/android/internal/policy/impl/GlobalActions$SinglePressAction;-onLongPress-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.VIBRATE'],
	'Lcom/android/phone/OutgoingCallBroadcaster;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.PROCESS_OUTGOING_CALLS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$DeviceInfoSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/UIControllerSearchTwoPane;-onInstallFragment-(Landroid/app/Fragment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/ui/SurfaceRenderFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$TagService;-ndefMakeReadOnly-(I)I' : ['android.permission.NFC'],
	'Lcom/android/settings/Settings$InputMethodAndLanguageSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/ToRGBAFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/TransactionSafeActivity;-onAttachFragment-(Landroid/app/Fragment;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/ui/SlideshowPresenter;-presentRegionMedia-(Lcom/android/mms/ui/SlideViewInterface; Lcom/android/mms/model/RegionMediaModel; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPuk2-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-selectNetworkManually-(Lcom/android/internal/telephony/OperatorInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumSetPage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/camera/ActivityBase;-onPreviewTextureCopied-()V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/WifiService;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processGetInkey-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IBackupManager$Stub;-opComplete-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/os/PowerManager$WakeLock;-acquire-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-access$800-(Lcom/android/contacts/activities/ConfirmAddDetailActivity; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/DevelopmentSettings;-writeCpuUsageOptions-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/emailcommon/Device;-getConsistentDeviceId-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-processPostDialChar-(C)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/CropView$FaceHighlightView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/net/NetworkPolicyManagerService$4;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/view/IWindowManager;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/media/effect/EffectContext;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-getAccounts-()[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/app/NetInitiatedActivity;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$ApplicationSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/content/IContentService$Stub;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/calendar/CalendarController;-refreshCalendars-()V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/content/ISyncAdapter$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager;-readPairedDevices-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/Controller$LegacyListener;-checkMailFinished-(Landroid/content/Context; J J J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/activity/MessageCompose$SendOrSaveMessageTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-performServiceRestartLocked-(Lcom/android/server/am/ServiceRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/browser/Preloader;-cancelSearchBoxPreload-(Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/email/Controller$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/ui/SurfaceRenderFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/email/service/MailService$5;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setMute-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/DuotoneEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/provider/Contacts$People;-markAsContacted-(Landroid/content/ContentResolver; J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/JoinContactListFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/server/BluetoothAdapterProperties;-getAllProperties-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/RuimPhoneBookInterfaceManager;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/sip/SipSettings;-access$800-(Lcom/android/phone/sip/SipSettings;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/server/BackupManagerService;-setAutoRestore-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/ui/PhotoView$ScreenNailPicture;-draw-(Lcom/android/gallery3d/ui/GLCanvas; Landroid/graphics/Rect;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/providers/downloads/DownloadNotification;-updateNotification-(Ljava/util/Collection;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/group/GroupEditorFragment$2;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/CursorLoader;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-setNetworkSelectionModeManual-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CLEAR_APP_CACHE', 'android.permission.READ_EXTERNAL_STORAGE', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/emailcommon/service/EmailServiceProxy$6;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/music/MusicUtils;-addToCurrentPlaylist-(Landroid/content/Context; [J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-access$1700-(Lcom/android/server/ConnectivityService; I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/UrlInputView;-onEditorAction-(Landroid/widget/TextView; I Landroid/view/KeyEvent;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/data/WorkingMessage;-access$700-(Lcom/android/mms/data/WorkingMessage; Lcom/android/mms/data/Conversation; Landroid/net/Uri; Lcom/google/android/mms/pdu/PduPersister; Lcom/android/mms/model/SlideshowModel; Lcom/google/android/mms/pdu/SendReq;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/browser/UrlInputView$UrlInputListener;-onAction-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/view/IApplicationToken;-windowsVisible-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/calendar/DeleteEventHelper;-deleteRepeatingEvent-(I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/inputmethod/keyboard/MoreKeysKeyboardView$1;-onCodeInput-(I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$OutgoingHandsfree;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/WindowManagerService;-systemReady-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/email/activity/MessageListFragment;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$EasContactsSyncParser;-commandsParser-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/IConnectivityManager;-getActiveNetworkQuotaInfo-()Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipCall;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.USE_SIP'],
	'Lcom/android/server/ConnectivityService;-access$800-(Lcom/android/server/ConnectivityService; Landroid/net/NetworkInfo;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ITelephonyRegistry;-notifyServiceState-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/launcher2/Launcher;-showFirstRunWorkspaceCling-()V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/media/Ringtone;-play-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IThrottleManager;-getResetTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccRecords;-setVoiceCallForwardingFlag-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/util/Recycler;-deleteOldMessagesByThreadId-(Landroid/content/Context; J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-setDataSourceImpl-(Landroid/media/MediaPlayer; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/RestoreSession;-getAvailableRestoreSets-(Landroid/app/backup/RestoreObserver;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothAdapter;-setScanMode-(I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/ConnectivityService;-sendGeneralBroadcast-(Landroid/net/NetworkInfo; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Contacts$People;-addToGroup-(Landroid/content/ContentResolver; J J)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/INetworkPolicyManager$Stub;-getNetworkQuotaInfo-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/base/OutputStreamTarget;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/accounts/IAccountManager;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPinForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothDevice;-cancelBondProcess-()Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/HidProfile;-isPreferred-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/Controller$15;-loadAttachmentStatus-(J J I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/alerts/AlertAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/systemui/recent/RecentTasksLoader$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.GET_TASKS'],
	'Lcom/android/internal/telephony/CommandsInterface;-hangupConnection-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/UIControllerBase;-onBackPressed-(Z)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/INfcTag$Stub;-ndefMakeReadOnly-(I)I' : ['android.permission.NFC'],
	'Lcom/android/gallery3d/data/Clustering;-run-(Lcom/android/gallery3d/data/MediaSet;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/systemui/statusbar/policy/AutoRotateController;-<init>-(Landroid/content/Context; Landroid/widget/CompoundButton; Lcom/android/systemui/statusbar/policy/AutoRotateController$RotationLockCallbacks;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/ObjectSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/DialogPicker;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.CAMERA', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.RECORD_AUDIO', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.NFC'],
	'Landroid/accounts/IAccountManager$Stub;-confirmCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Landroid/os/Bundle; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-notifyApnIdDisconnected-(Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowManagerService;-displayReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/browser/PreloadRequestReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendPhonebookOneVcard-(Ljavax/obex/Operation; I Z Ljava/lang/String; I)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/inputmethod/latin/LatinIME;-pickSuggestionManually-(I Ljava/lang/CharSequence; I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/app/IBatteryStats;-getStatistics-()[B' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Lcom/android/settings/AirplaneModeEnabler;-setAirplaneModeInECM-(Z Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/AudioService$AudioHandler$1;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setPasskey-(Ljava/lang/String; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/browser/SuggestionsAdapter$SuggestCursor;-runQuery-(Ljava/lang/CharSequence;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/EventLoader;-startBackgroundThread-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/RedEyeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/DayView;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/launcher2/Workspace;-startDrag-(Lcom/android/launcher2/CellLayout$CellInfo;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/providers/contacts/GlobalSearchSupport;-handleSearchSuggestionsQuery-(Landroid/database/sqlite/SQLiteDatabase; Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/UiController;-createNewSnapshotTab-(J Z)Lcom/android/browser/SnapshotTab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity$AccountSet;-buildDiff-()Ljava/util/ArrayList;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/gsm/SmsManager;-copyMessageToSim-([B [B I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/phone/CallCard;-updatePhotoForCallState-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-addToBlacklist-(Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Lcom/android/mms/ui/MessageListAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/location/ILocationManager$Stub$Proxy;-setTestProviderLocation-(Ljava/lang/String; Landroid/location/Location;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/telephony/DataConnection;-access$1800-(Lcom/android/internal/telephony/DataConnection; Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-confirmCredentials-(Landroid/accounts/Account; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/providers/downloads/DownloadService;-scanFile-(Lcom/android/providers/downloads/DownloadInfo; Z Z)Z' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/server/ThrottleService$MyHandler;-clearThrottleAndNotification-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/location/GpsLocationProvider;-updateNetworkState-(I Landroid/net/NetworkInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/ContactsContract$SyncState;-get-(Landroid/content/ContentProviderClient; Landroid/accounts/Account;)[B' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/nfc/NfcService$NfcAdapterService;-disableNdefPush-()Z' : ['android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/SMSDispatcher;-processMessagePart-([B Ljava/lang/String; I I I J I Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/Settings$KeyboardLayoutPickerActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/server/BluetoothInputProfileHandler;-connectInputDevice-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothDeviceProfileState;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/InCallScreen$8;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothHeadset;-connectHeadsetInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/Dictionary;-getWords-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/latin/Dictionary$WordCallback; Lcom/android/inputmethod/keyboard/ProximityInfo;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/BrowserSettings;-onSharedPreferenceChanged-(Landroid/content/SharedPreferences; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/TintFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/pm/PackageManagerService$5;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/email/activity/MessageViewFragmentBase$LoadMessageTask;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-hangupAndPowerOff-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$CryptKeeperSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/ActivityManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.REORDER_TASKS', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.RESTART_PACKAGES'],
	'Landroid/media/effect/effects/DuotoneEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/soundrecorder/SoundRecorder;-access$100-(Lcom/android/soundrecorder/SoundRecorder;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-dispatchMediaKeyWithWakeLock-(Landroid/view/KeyEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageViewFragment;-onResume-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/Tab$2;-onPageFinished-(Landroid/webkit/WebView; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-startDisambiguationQuery-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-notifyNoData-(Lcom/android/internal/telephony/DataConnection$FailCause; Lcom/android/internal/telephony/ApnContext;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothService;-dumpInputDeviceProfile-(Ljava/io/PrintWriter;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiManager;-getWifiStateMachineMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/inputmethod/latin/spellcheck/DictionaryPool;-takeOrGetNull-()Lcom/android/inputmethod/latin/spellcheck/DictAndProximity;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/TintFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/SMSDispatcher;-dispatch-(Landroid/content/Intent; Ljava/lang/String; Landroid/content/BroadcastReceiver;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsListActivity;-getContactUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/provider/CalendarContract$EventDays;-query-(Landroid/content/ContentResolver; I I [Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$DeviceFoundHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/AudioService;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/VibratorService;-doVibratorOn-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/providers/calendar/CalendarReceiver$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/bluetooth/BluetoothNameDialogFragment;-access$000-(Lcom/android/settings/bluetooth/BluetoothNameDialogFragment; Ljava/lang/String;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/AccessibilitySettings$SettingsPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/CallerInfoCache;-init-(Landroid/content/Context;)Lcom/android/phone/CallerInfoCache;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageOrderManager$Callback;-onMessageNotFound-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/DeleteEventHelper;-access$900-(Lcom/android/calendar/DeleteEventHelper;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/AccessibilitySettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/pm/PackageManagerService;-scanPackageLI-(Landroid/content/pm/PackageParser$Package; I I J)Landroid/content/pm/PackageParser$Package;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/activities/GroupEditorActivity;-onStart-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/DateTimeSettingsSetupWizard;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.SET_TIME_ZONE'],
	'Landroid/media/IAudioService$Stub;-startBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/calendar/CalendarAlarmManager;-rescheduleMissedAlarms-(Landroid/content/ContentResolver;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/BluetoothHeadsetService;-getSdpRecordsAndConnect-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/IWifiManager$Stub;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/calendar/EmailAddressAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/bluetooth/DockEventReceiver;-finishStartingService-(Landroid/app/Service; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/VideoCamera;-onCreateOptionsMenu-(Landroid/view/Menu;)Z' : ['android.permission.NFC'],
	'Lcom/android/email/Email;-onCreate-()V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/GrainFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$GroupCreatedState;-exit-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-onSystemReady-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/calllog/CallLogFragment;-setMenuVisibility-(Z)V' : ['android.permission.WRITE_CALL_LOG', 'android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/settings/Settings$InputMethodAndSubtypeEnablerActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/mms/ui/SlideViewInterface;-setVideo-(Ljava/lang/String; Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$WifiSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/Settings$DateTimeSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onVoiceCallStarted-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/ContactsDictionary;-isValidWord-(Ljava/lang/CharSequence;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/Controller$15;-broadcastCallback-(Lcom/android/email/Controller$ServiceCallbackWrapper;)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mms/transaction/MessagingNotification;-notifyDownloadFailed-(Landroid/content/Context; J)V' : ['android.permission.VIBRATE', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onSingleTapUp-(I)V' : ['android.permission.VIBRATE'],
	'Landroid/server/BluetoothA2dpService;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/TabControl;-createNewWebView-()Landroid/webkit/WebView;' : ['android.permission.INTERNET'],
	'Lcom/android/gallery3d/app/MovieActivity$1;-access$1200-(Lcom/android/gallery3d/app/MoviePlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree;-connectScoThread-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EmailSyncAdapterService;-performSync-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/camera/ActivityBase$MyAppBridge;-onPreviewTextureCopied-()V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/TetherSettings;-access$300-(Lcom/android/settings/TetherSettings;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar$H$1;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/gallery3d/ui/PhotoView;-access$900-(Lcom/android/gallery3d/ui/PhotoView; I)V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/VideoCamera;-startPreview-()V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/KeyguardScreenCallback;-reportFailedUnlockAttempt-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/mms/data/Conversation;-access$700-(Landroid/content/Context;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/app/NetInitiatedActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/BaseUi;-<init>-(Landroid/app/Activity; Lcom/android/browser/UiController;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/vcard/VCardParser_V30;-parse-(Ljava/io/InputStream; Lcom/android/vcard/VCardInterpreter;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/MessageUtils$3$1;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar$ExpandedDialog;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/inputmethod/latin/LatinIME;-handleBackspace-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter;-fireDataChange-()V' : ['android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/AutoFixFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/inputmethod/SpellCheckersSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/ITelephony;-getCellLocation-()Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/nfc/tech/MifareClassic;-getTimeout-()I' : ['android.permission.NFC'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/SearchActivity$1;-onChange-(Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/NotificationMgr;-updateNotificationsAtStartup-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-saveRingtone-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/support/v4/view/accessibility/AccessibilityNodeProviderCompat;-performAction-(I I Landroid/os/Bundle;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Landroid/content/IContentService$Stub;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/policy/impl/SimUnlockScreen$1$1;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/server/BluetoothEventLoop;-onDeviceFound-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/videosrc/MediaSource;-process-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/Alarms;-deleteAlarm-(Landroid/content/Context; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/InCallScreen;-showPausePromptDialog-(Lcom/android/internal/telephony/Connection; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/contacts/ContactsProvider2;-deleteInTransaction-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/google/common/io/Resources;-readLines-(Ljava/net/URL; Ljava/nio/charset/Charset; Lcom/google/common/io/LineProcessor;)Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Lcom/android/inputmethod/latin/WhitelistDictionary;-startDictionaryLoadingTaskLocked-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ui/MenuExecutor$ConfirmDialogListener;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.VIBRATE'],
	'Landroid/filterfw/core/SyncRunner;-performStep-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/ImageSlicer;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneInterfaceManager;-silenceRingerInternal-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/providers/downloads/SystemFacade;-postNotification-(J Landroid/app/Notification;)V' : ['android.permission.VIBRATE'],
	'Landroid/accounts/IAccountManager$Stub;-updateCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-getTimeout-(I)I' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-hangupAndPowerOff-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupEditorFragment;-setupEditorForAccount-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/PhoneFallbackEventHandler;-handleMediaKeyEvent-(Landroid/view/KeyEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcAdapterExtras$Stub;-transceive-(Ljava/lang/String; [B)Landroid/os/Bundle;' : ['android.permission.NFC'],
	'Lcom/android/contacts/editor/EventFieldEditorView;-notifyEditorListener-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-access$300-(Lcom/android/contacts/editor/ContactEditorFragment; Landroid/content/Context; Lcom/android/contacts/editor/RawContactEditorView;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/PhoneApp;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetooth$Stub;-cancelPairingUserInput-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothHeadset;-stopScoUsingVirtualVoiceCall-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityStack;-moveHomeToFrontFromLaunchLocked-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/test/ModelInterpreter;-<init>-(Ljava/net/InetSocketAddress;)V' : ['android.permission.INTERNET'],
	'Lcom/android/email/mail/store/ServiceStore;-autoDiscover-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/email/activity/MessageViewFragmentBase$Callback;-onMessageNotExists-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterfw/core/FieldPort;-setFieldFrame-(Landroid/filterfw/core/Frame; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/LatinIME;-access$300-(Lcom/android/inputmethod/latin/LatinIME; Landroid/view/inputmethod/EditorInfo; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/BluetoothHeadset;-isDisabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/view/IWindowManager$Stub$Proxy;-dismissKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Landroid/filterpacks/base/CallbackFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/net/NetworkStatsService;-performPoll-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$TetherSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-untether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/videosrc/CameraSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/calendar/alerts/AlertActivity;-onStop-()V' : ['android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/email/activity/setup/MailboxSettings$2;-onSuccess-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiManager;-isWifiApEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/Settings$BluetoothSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/Controller;-updateMailbox-(J J Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mms/ui/ManageSimMessages$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-checkPendingNotification-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/am/ActivityManagerService;-installSystemProviders-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/camera/VideoCamera;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/IBluetoothHeadset;-createIncomingConnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;-<init>-(Landroid/content/Context; Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo; Lcom/android/email/activity/MessageViewFragmentBase$1;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/SingleRunningTask;-runInternal-(Ljava/lang/Object;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter;-setCurrentPhoto-(Lcom/android/gallery3d/data/Path; I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/DreamSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DockService;-handleDocked-(Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$EasContactsSyncParser;-changeParser-(Lcom/android/exchange/adapter/ContactsSyncAdapter$ContactOperations;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/providers/contacts/VoicemailContentProvider;-checkPermissionsAndCreateUriData-(Landroid/net/Uri;)Lcom/android/providers/contacts/VoicemailContentProvider$UriData;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/server/BluetoothEventLoop;-onRequestOobData-(Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/server/BluetoothService;-setBluetoothTethering-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/util/Recycler$MmsRecycler;-deleteOldMessages-(Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/IccRecords;-setVoiceCallForwardingFlag-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventFragment;-onDestroy-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/pm/ShutdownThread$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.VIBRATE'],
	'Lcom/android/phone/sip/SipSharedPreferences;-setReceivingCallsEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-setVoiceCallForwardingFlag-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/policy/LocationController;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/email/service/AttachmentDownloadService$ServiceCallback;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-disableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-notifyEditorListener-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/NsdService;-create-(Landroid/content/Context;)Lcom/android/server/NsdService;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/WifiService;-clearBlacklist-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/NotificationMgr;-updateMwi-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/wm/WindowManagerService$DragInputEventReceiver;-onInputEvent-(Landroid/view/InputEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/SpeechRecognizer;-handleStartListening-(Landroid/content/Intent;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/exchange/ContactsSyncAdapterService;-access$000-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-getScanMode-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/RotateFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/StateManager;-restoreFromState-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/latin/LatinIME;-handleSeparator-(I I I I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-<init>-(Landroid/preference/VolumePreference; Landroid/content/Context; Landroid/widget/SeekBar; I Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/SetAlarm;-saveAlarm-(Lcom/android/deskclock/Alarm;)J' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/contacts/VoicemailContentProvider;-update-(Landroid/net/Uri; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/email/activity/UIControllerSearchTwoPane;-showAccountSpecificWarning-(J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/LocationManagerService;-handleLocationChangedLocked-(Landroid/location/Location; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getLastTetherError-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/activities/GroupDetailActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/settings/ApplicationSettings$1;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/AccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Z Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/media/AudioManager;-setWiredDeviceConnectionState-(I I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/StateManager;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getAllNetworkState-()[Landroid/net/NetworkState;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/MessageFileViewFragment;-addAttachment-(Lcom/android/emailcommon/provider/EmailContent$Attachment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$10;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/util/AccountFilterUtil;-handleAccountFilterResult-(Lcom/android/contacts/list/ContactListFilterController; I Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/setup/AccountCheckSettingsFragment$AccountCheckTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/detail/ContactLoaderFragment$1;-onLoadFinished-(Landroid/content/Loader; Lcom/android/contacts/ContactLoader$Result;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-registerForWatchdogToggle-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/ActivityManagerNative;-setProcessLimit-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/Settings$ApplicationSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/location/ILocationManager$Stub$Proxy;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/detail/ContactDetailUpdatesFragment$1;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/Settings$CryptKeeperSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendThisDeviceChangedBroadcast-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/LocalBluetoothPreferences;-shouldShowDialogInForeground-(Landroid/content/Context; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/media/AudioManager;-startBluetoothSco-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/provider/CalendarContract$CalendarEntity$EntityIteratorImpl;-next-()Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/UsimPhoneBookManager;-readPbrFileAndWait-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/GlobalActions$4;-onItemLongClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.VIBRATE'],
	'Landroid/view/IWindowSession$Stub$Proxy;-addWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-run-(Landroid/accounts/AccountManagerFuture;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/ActivityManagerService;-access$300-(Lcom/android/server/am/ActivityManagerService; Ljava/lang/String; I Z Z Z Z I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Landroid/net/http/RequestQueue$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/NetworkStateTracker;-teardown-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/app/KeyguardManager;-exitKeyguardSecurely-(Landroid/app/KeyguardManager$OnKeyguardExitResult;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/PhoneNotifier; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-prepareEmptyView-()V' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/transaction/TransactionService;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothHeadset;-stopVoiceRecognition-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/test/FragmentTestActivity;-onResume-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/app/IBackupAgent$Stub$Proxy;-doFullBackup-(Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/wm/WindowManagerService;-disableKeyguard-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/server/am/ActivityManagerService;-handleAppDiedLocked-(Lcom/android/server/am/ProcessRecord; Z Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageViewFragmentBase$LoadMessageTask;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/server/net/NetworkStatsService;-getNetworkStatsUidDetail-()Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/usb/UsbSettingsManager$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/ToRGBAFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/ITelephony;-isSimPinEnabled-()Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/CdmaSystemSelectListPreference;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaCall;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/screenshot/GlobalScreenshot$2;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/widget/WaveView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/list/ContactPickerFragment;-onItemClick-(I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$StartTetheringErrorState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/TetherSettings;-startTethering-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/AttachmentInfo;-<init>-(Landroid/content/Context; Lcom/android/email/AttachmentInfo;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/AudioManager;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-allowIncomingConnect-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState$SwitchActions;-hapticAndAudioFeedback-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/activities/PeopleActivity$ContactDetailLoaderFragmentListener$1;-run-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$StateTracker;-getTriState-(Landroid/content/Context;)I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/SyncManager$8;-onServiceChanged-(Landroid/content/SyncAdapterType; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/IMediaPlaybackService;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageCompose$SendOrSaveMessageTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/LockScreen$3;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/accounts/AccountManagerService;-invalidateAuthToken-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-loadDictionaryAsync-()V' : ['android.permission.READ_USER_DICTIONARY'],
	'Lcom/android/contacts/list/ShortcutIntentBuilder$LoadingAsyncTask;-loadPhoto-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/accounts/AccountManager$Future2Task;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-disconnectSinkInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/ConversationList;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/base/FrameSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService$ProximityListener;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/usb/UsbDeviceManager$UsbHandler;-updateAdbNotification-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/nfc/nxp/NativeNfcManager;-notifyTransactionListeners-([B)V' : ['android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-getSelectedGroupPosition-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/DataUsageSummary;-access$600-(Lcom/android/settings/DataUsageSummary; Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/wallpaper/RenderScriptScene;-start-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/SlidingTab;-cancelGrab-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/Settings$BluetoothSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/activities/ActionBarAdapter;-setCurrentTab-(I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth$Stub;-setRemoteOutOfBandData-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/SlideshowEditActivity$SlideListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/SipCallOptionHandler;-access$300-(Lcom/android/phone/SipCallOptionHandler; Landroid/net/sip/SipProfile;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.USE_SIP'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-access$1600-(Lcom/android/gallery3d/app/AlbumSetPage; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/EasAccountService;-sync-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-access$1000-(Lcom/android/gallery3d/app/AlbumSetPage; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/calllog/CallLogFragment;-startCallsQuery-()V' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/phone/CallNotifier$1;-onCallForwardingIndicatorChanged-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/OwnerInfoSettings;-saveToDb-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothPbap;-disconnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/UserDictionary;-addWordToUserDictionary-(Ljava/lang/String; I)V' : ['android.permission.READ_USER_DICTIONARY'],
	'Lcom/android/internal/policy/impl/AccountUnlockScreen;-findIntendedAccount-(Ljava/lang/String;)Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/alerts/AlertActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/input/InputManagerService;-registerPointerSpeedSettingObserver-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$6900-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine; Ljava/lang/String;)Z' : ['android.permission.GET_TASKS'],
	'Lcom/android/email/activity/setup/MailboxSettings$2;-onSuccess-(Ljava/lang/Void;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/month/SimpleWeeksAdapter;-updateParams-(Ljava/util/HashMap;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$2;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.USE_CREDENTIALS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/service/dreams/IDreamManager$Stub$Proxy;-setDreamComponent-(Landroid/content/ComponentName;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/BluetoothHandsfree;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/HeadsetBase;-handleInput-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/AlbumPage;-onCreate-(Landroid/os/Bundle; Landroid/os/Bundle;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener;-onTextInput-(Ljava/lang/CharSequence;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/sip/SipManager;-makeAudioCall-(Ljava/lang/String; Ljava/lang/String; Landroid/net/sip/SipAudioCall$Listener; I)Landroid/net/sip/SipAudioCall;' : ['android.permission.USE_SIP'],
	'Lcom/android/providers/downloads/StorageManager;-verifySpace-(I Ljava/lang/String; J)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-setMute-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$UuidChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-isSyncActive-()Z' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/alerts/SnoozeAlarmsService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/group/GroupBrowseListFragment;-requestSelectionToScreen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetooth;-getRemoteName-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/DayView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/sip/SipSharedPreferences;-setSipCallOption-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/downloads/DownloadThread;-processResponseHeaders-(Lcom/android/providers/downloads/DownloadThread$State; Lcom/android/providers/downloads/DownloadThread$InnerState; Lorg/apache/http/HttpResponse;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/WifiStateMachine$VerifyingLinkState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneFallbackEventHandler;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-connect-(I I)I' : ['android.permission.NFC'],
	'Landroid/support/v4/net/ConnectivityManagerCompatHoneycombMR2;-isActiveNetworkMetered-(Landroid/net/ConnectivityManager;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/tech/BasicTagTechnology;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Lcom/android/providers/contacts/ProfileProvider;-insertInTransaction-(Landroid/net/Uri; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.WRITE_PROFILE'],
	'Landroid/net/INetworkPolicyManager$Stub;-setNetworkPolicies-([Landroid/net/NetworkPolicy;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/videosrc/MediaSource;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-hangup-(Lcom/android/internal/telephony/CallManager;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Landroid/content/ISyncAdapter$Stub;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/wm/Session;-prepareDrag-(Landroid/view/IWindow; I I I Landroid/view/Surface;)Landroid/os/IBinder;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/AbstractSyncAdapter;-sendLocalChanges-(Lcom/android/exchange/adapter/Serializer;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/ConversationList;-confirmDeleteThread-(J Landroid/content/AsyncQueryHandler;)V' : ['android.permission.READ_SMS'],
	'Landroid/speech/SpeechRecognizer;-stopListening-()V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/providers/downloads/DownloadReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/Settings$KeyboardLayoutPickerActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/spellcheck/DictionaryPool;-take-()Lcom/android/inputmethod/latin/spellcheck/DictAndProximity;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/accessibility/AccessibilityEntityProvider;-performActionForKey-(Lcom/android/inputmethod/keyboard/Key; I Landroid/os/Bundle;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Landroid/nfc/INfcAdapterExtras$Stub$Proxy;-open-(Ljava/lang/String; Landroid/os/IBinder;)Landroid/os/Bundle;' : ['android.permission.NFC'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$5800-(Lcom/android/mms/ui/ComposeMessageActivity; Ljava/lang/String; Landroid/net/Uri; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/telephony/TelephonyManager;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/preference/YesNoPreference;-onDialogClosed-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/systemui/statusbar/BaseStatusBar$2;-onClickHandler-(Landroid/view/View; Landroid/app/PendingIntent; Landroid/content/Intent;)Z' : ['android.permission.VIBRATE'],
	'Landroid/server/BluetoothService;-setPairable-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/ex/variablespeed/MediaPlayerProxy;-prepare-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onResetDone-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/BlendFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/wm/WindowAnimator;-animate-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub$Proxy;-getProviders-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity$QueryEntitiesTask;-onPostExecute-(Lcom/android/contacts/model/EntityDeltaList;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/view/PieMenu$PieView;-layout-(I I Z F I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/calllog/CallLogFragment;-onResume-()V' : ['android.permission.WRITE_CALL_LOG', 'android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/Ringtone;-setUri-(Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/ContactsContract$SyncState;-set-(Landroid/content/ContentProviderClient; Landroid/accounts/Account; [B)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/Tab;-capture-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/Settings$ManageAccountsSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/SuggestionsAdapter;-onClick-(Landroid/view/View;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/SimUnlockScreen;-onClick-(Landroid/view/View;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsBinaryDictionary;-hasContentChanged-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-<init>-(Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-open-(Landroid/net/sip/SipProfile;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/email/Controller;-searchMore-(J)V' : ['android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/detail/ContactDetailUpdatesFragment$2;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-getDrmMimeMenuStringRsrc-(J)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-access$400-(Lcom/android/mms/transaction/SmsReceiverService;)V' : ['android.permission.SEND_SMS', 'android.permission.READ_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.VIBRATE'],
	'Landroid/server/BluetoothService;-changeApplicationBluetoothState-(Z Landroid/bluetooth/IBluetoothStateChangeCallback; Landroid/os/IBinder;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/LocationManagerService;-addTestProvider-(Ljava/lang/String; Z Z Z Z Z Z Z I I)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/contacts/list/JoinContactListAdapter;-bindQuickContact-(Lcom/android/contacts/list/ContactListItemView; I Landroid/database/Cursor; I I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/activity/ActionBarController;-access$800-(Lcom/android/email/activity/ActionBarController; I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/ConversationListItem;-updateFromView-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/InCallScreen;-toggleSpeaker-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/SupplicantStateTracker;-access$200-(Landroid/net/wifi/SupplicantStateTracker; Landroid/net/wifi/SupplicantState; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/PhotoView;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/sip/SipService$MyExecutor;-executeInternal-(Ljava/lang/Runnable;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/AccountSyncAdapter;-getSyncKey-()Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/am/ActivityStack;-checkReadyForSleepLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$P2pDisablingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-hasContentChanged-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/SubSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/UserHistoryDictionary;-loadDictionary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/webkit/WebIconDatabaseClassic;-open-(Ljava/lang/String;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updateExtensions-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/Invert;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/handover/HandoverManager;-createBluetoothOobDataRecord-()Landroid/nfc/NdefRecord;' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/base/RetargetFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/nsd/INsdManager$Stub;-getMessenger-()Landroid/os/Messenger;' : ['android.permission.INTERNET'],
	'Lcom/android/exchange/EasAccountService;-executePostWithTimeout-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; I Z)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-access$300-(Lcom/android/internal/widget/multiwaveview/GlowPadView; I F F)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.USE_CREDENTIALS', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/setup/DebugFragment;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/sip/SipEditor;-access$600-(Lcom/android/phone/sip/SipEditor; Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/providers/calendar/CalendarProvider2;-deleteReminders-(Landroid/net/Uri; Z Ljava/lang/String; [Ljava/lang/String; Z)I' : ['android.permission.READ_CALENDAR'],
	'Landroid/os/IHardwareService$Stub$Proxy;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/settings/Settings$BluetoothSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/media/AudioService$SettingsObserver;-<init>-(Landroid/media/AudioService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-validate-(Lcom/android/emailcommon/provider/HostAuth;)Landroid/os/Bundle;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-access$2900-(Lcom/android/systemui/statusbar/phone/PhoneStatusBar;)V' : ['android.permission.VIBRATE'],
	'Landroid/app/backup/BackupAgent$BackupServiceBinder;-doBackup-(Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/IConnectivityManager;-isTetheringSupported-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterfw/core/Filter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WpsDialog;-access$200-(Lcom/android/settings/wifi/WpsDialog; Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/IAccountManager;-hasFeatures-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendVCards-(Ljavax/obex/Operation; Ljava/lang/String; Z Ljava/lang/String; Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/gallery3d/ui/TileImageView;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$RunningServicesActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-isConnected-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$3;-keyguardDone-(Z)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/browser/GoogleAccountLogin;-getAccounts-(Landroid/content/Context;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/AccessibilitySettings;-handleLockScreenRotationPreferenceClick-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/quicksearchbox/google/SearchBaseUrlHelper$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/detail/ContactDetailFragment$AddToMyContactsQuickFix;-execute-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/os/PowerManager$WakeLock;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$5;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/settings/wifi/WifiSettings$3;-onClick-(Landroid/view/View;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/CdmaVoicePrivacyCheckBoxPreference;-onClick-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-manageServicesLocked-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/DTMFTwelveKeyDialer;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CommandsInterface;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/WifiService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-flashAndSetGenericTrue-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/inputmethod/KeyboardLayoutPickerFragment;-onPause-()V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/AppWidgetPickActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/google/common/io/Resources;-toString-(Ljava/net/URL; Ljava/nio/charset/Charset;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/providers/calendar/CalendarProvider2;-regenerateInstancesTable-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/PhoneUtils;-setAudioMode-(Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/location/GpsLocationProvider;-removeListener-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-getDataRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/tech/MifareUltralight;-getTimeout-()I' : ['android.permission.NFC'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-hasPendingChanges-()Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/videosrc/MediaSource;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/BluetoothHandsfree$8;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothHandsfree$5;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/ConnectivityManager;-isActiveNetworkMetered-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setRadioPower-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService$2;-disconnect-()V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/event/EditEventView;-setViewStates-(I)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/browser/BrowserActivity;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-setRadios-(Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/ConnectivityService;-access$900-(Lcom/android/server/ConnectivityService; Landroid/net/NetworkInfo;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/sip/SipService;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/deskclock/AlarmAlertFullScreen$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onEnableNewApn-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/UIControllerOnePane;-onRespondedToInvite-(I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/IRingtonePlayer$Stub;-play-(Landroid/os/IBinder; Landroid/net/Uri; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/LocationSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/VideoView$6;-surfaceChanged-(Landroid/view/SurfaceHolder; I I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaByDayAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/bluetooth/opp/BluetoothOppNotification;-updateIncomingFileConfirmNotification-()V' : ['android.permission.VIBRATE'],
	'Landroid/hardware/ISerialManager;-getSerialPorts-()[Ljava/lang/String;' : ['android.permission.SERIAL_PORT'],
	'Landroid/server/BluetoothService;-getInputDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/service/PolicyService$1;-policiesRequired-(J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/WifiService;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/RIL;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/input/InputManagerService;-interceptMotionBeforeQueueingWhenScreenOff-(I)I' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/policy/impl/GlobalActions;-access$300-(Lcom/android/internal/policy/impl/GlobalActions; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler;-setEnabled-(Z)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-processResponse-(Landroid/os/Parcel;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumPicker;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.CAMERA', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.RECORD_AUDIO', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.NFC'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/Conversation;-startDeleteAll-(Lcom/android/mms/data/Conversation$ConversationQueryHandler; I Z)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/view/ViewRootImpl;-deliverKeyEventPostIme-(Landroid/view/ViewRootImpl$QueuedInputEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-tryFailover-(I)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/server/BluetoothEventLoop;-isOtherSinkInNonDisconnectedState-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/AccountsTester$ButtonClickListener;-onClick-(Landroid/view/View;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/list/LegacyPhoneNumberListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/ContactPickerFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/RIL;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-onConnectedInOrOut-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/NavigationBarBase;-onAction-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/activities/JoinContactActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/contacts/detail/ContactDetailFragment$QuickFix;-isApplicable-()Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/DreamSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/search/SearchEngine;-getSuggestions-(Landroid/content/Context; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/BrowserHistoryPage$ClearHistoryTask;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-queryExternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/InCallScreen;-onHoldClick-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/webkit/HTML5VideoViewProxy;-enterFullScreenVideo-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/P2pLinkManager$3;-doGet-(I Landroid/nfc/NdefMessage;)Lcom/android/nfc/snep/SnepMessage;' : ['android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/WindowManagerService;-startFreezingDisplayLocked-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService$2;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/text/StringLogger;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/vcard/VCardEntry$PhoneData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-disableSingleLocationUpdate-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getRemoteUuids-(Ljava/lang/String;)[Landroid/os/ParcelUuid;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/EmergencyCallbackModeService;-showNotification-(J)V' : ['android.permission.VIBRATE'],
	'Landroid/bluetooth/BluetoothDevice;-getBondState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-topAppWindowChanged-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/google/common/io/Files;-toString-(Ljava/io/File; Ljava/nio/charset/Charset;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/CropRectFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/ExchangeService$1$2;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-refreshAccessPoints-(Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/WebStorageSizeManager;-scheduleOutOfSpaceNotification-()V' : ['android.permission.VIBRATE'],
	'Landroid/net/IConnectivityManager$Stub;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-createIntent-(Landroid/content/Context; J)Landroid/content/Intent;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getHealthDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory$2;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$ContactOperations;-delete-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/deskclock/SetAlarm$3;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/BackupManagerService$PerformRestoreTask;-restorePmMetadata-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/am/BroadcastQueue;-broadcastTimeoutLocked-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/exchange/ExchangeService$ServiceCallbackWrapper;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/speech/IRecognitionService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/contacts/dialpad/DialpadFragment;-fillDigitsIfNecessary-(Landroid/content/Intent;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeEnabler;-updateAutoSelectionCB-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/quicksearchbox/google/AbstractGoogleSource;-queryInternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/QuickContactBadge;-assignContactFromEmail-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/WifiService;-access$1300-(Lcom/android/server/WifiService;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/Settings$DateTimeSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/Controller;-start-(Landroid/content/Intent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/CommandsInterface;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/handover/HandoverManager;-doHandoverUri-([Landroid/net/Uri; Landroid/nfc/NdefMessage;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/PhoneNumberListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/emailcommon/service/IAccountService$Stub$Proxy;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/RIL;-queryCallForwardStatus-(I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthListView;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/tts/TtsEngineSettingsFragment$1$1;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/content/SyncManager$ActiveSyncContext;-<init>-(Landroid/content/SyncManager; Landroid/content/SyncOperation; J I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/GLRoot;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth;-setBluetoothTethering-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$P2pEnabledState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/BluetoothHeadsetService;-onStart-(Landroid/content/Intent; I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/VideoCamera;-access$1000-(Lcom/android/camera/VideoCamera;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/TabControl;-createNewTab-(Z)Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/location/ILocationManager$Stub;-addProximityAlert-(D D F J Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/editor/SelectAccountDialogFragment;-access$000-(Lcom/android/contacts/editor/SelectAccountDialogFragment; Lcom/android/contacts/model/AccountWithDataSet;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/list/ProviderStatusWatcher$LoaderTask;-onPostExecute-(Ljava/lang/Boolean;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/inputmethod/latin/ExpandableDictionary;-startDictionaryLoadingTaskLocked-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-access$500-(Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/webkit/WebIconDatabaseClassic;-bulkRequestIconForPageUrl-(Landroid/content/ContentResolver; Ljava/lang/String; Landroid/webkit/WebIconDatabase$IconListener;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/email/activity/setup/AccountSetupNames$2;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-addImage-(Landroid/net/Uri; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/browser/provider/BrowserProvider2;-updateBookmarksInTransaction-(Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String; Z)I' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/activities/ActionBarAdapter$Listener;-onAction-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/WifiService;-reassociate-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/contacts/group/GroupEditorFragment$4;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/Settings$WirelessSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallback;-onError-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/RetryScheduler;-setRetryAlarm-(Landroid/content/Context;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/phone/sip/SipSettings$3;-run-()V' : ['android.permission.USE_SIP'],
	'Lcom/android/server/pm/PackageManagerService;-<init>-(Landroid/content/Context; Z Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/phone/BluetoothHandsfree$25;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/CallLogAsync$GetLastOutgoingCallTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/net/sip/SipManager;-register-(Landroid/net/sip/SipProfile; I Landroid/net/sip/SipRegistrationListener;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ThrottleService;-getCliffLevel-(Ljava/lang/String; I)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/model/VideoModel;-loadThumbnailBitmap-(Lcom/android/mms/util/ItemLoadedCallback;)Lcom/android/mms/util/ItemLoadedFuture;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/net/wifi/WifiManager;-setFrequencyBand-(I Z)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onEnableApn-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-updateSearchPanel-()V' : ['android.permission.VIBRATE'],
	'Landroid/view/IWindowSession;-add-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/net/wifi/WifiManager;-getConfiguredNetworks-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/activities/ContactSelectionActivity;-onResume-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/calendar/agenda/AgendaFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-getNfcAdapterExtrasInterface-(Ljava/lang/String;)Landroid/nfc/INfcAdapterExtras;' : ['android.permission.NFC'],
	'Lcom/android/providers/telephony/SmsProvider;-insert-(Landroid/net/Uri; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/net/wifi/WifiStateTracker;-setRadio-(Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-access$300-(Lcom/android/internal/widget/multiwaveview/MultiWaveView; I F F)V' : ['android.permission.VIBRATE'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-renderChild-(Lcom/android/gallery3d/ui/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/data/WorkingMessage;-access$1300-(Lcom/google/android/mms/pdu/PduPersister; Lcom/google/android/mms/pdu/SendReq; Lcom/android/mms/model/SlideshowModel; Landroid/net/Uri;)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-queueNextSignalStrengthPoll-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/calendar/EventInfoFragment;-updateEvent-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/emailcommon/service/EmailServiceProxy;-<init>-(Landroid/content/Context; Landroid/content/Intent; Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/util/NameConverter;-structuredNameToDisplayName-(Landroid/content/Context; Ljava/util/Map;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/nfc/INfcTag$Stub;-rediscover-(I)Landroid/nfc/Tag;' : ['android.permission.NFC'],
	'Landroid/app/backup/IBackupManager$Stub$Proxy;-selectBackupTransport-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-putRecoveryAction-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-close-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onCancelEvent-(I I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/webkit/HTML5VideoView;-reprepareData-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-isAudioConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/SlideshowView;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/Settings$DateTimeSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-switchToState-(I F F)V' : ['android.permission.VIBRATE'],
	'Landroid/bluetooth/BluetoothHealth;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-handleRadioNotAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/deviceinfo/Memory;-hasAppsAccessingStorage-()Z' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/calendar/month/MonthWeekEventsView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/email/activity/MessageViewFragment;-performAttachmentSave-(Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;)Ljava/io/File;' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/emailcommon/service/IEmailService$Stub$Proxy;-stopSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/snep/SnepServer$ServerThread;-run-()V' : ['android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Lcom/google/common/io/OutputSupplier;)V' : ['android.permission.INTERNET'],
	'Lcom/android/browser/WallpaperHandler;-run-()V' : ['android.permission.SET_WALLPAPER', 'android.permission.INTERNET'],
	'Lcom/android/mms/transaction/SmsReceiver;-finishStartingService-(Landroid/app/Service; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/Device;-getDeviceId-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$10;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/preferences/WebsiteSettingsFragment$SiteAdapter$UpdateFromBookmarksDbTask;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/sip/SipService;-restartPortMappingLifetimeMeasurement-(Landroid/net/sip/SipProfile; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager;-addProximityAlert-(D D F J Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/bluetooth/DockService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/ExchangeService$1;-loadAttachmentStatus-(J J I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-asyncReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/am/ActivityManagerService;-finishInstrumentationLocked-(Lcom/android/server/am/ProcessRecord; I Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/browser/Preloader$PreloaderSession;-<init>-(Lcom/android/browser/Preloader; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/nfc/NfcService$TagService;-ndefRead-(I)Landroid/nfc/NdefMessage;' : ['android.permission.NFC'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-buildAppWidgetModel-(Landroid/content/Context; Landroid/database/Cursor; Ljava/lang/String;)Lcom/android/calendar/widget/CalendarAppWidgetModel;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/exchange/adapter/Search$SearchParser;-parse-()Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/Settings$PrivacySettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/downloads/DownloadNotification;-updateCompletedNotification-(Ljava/util/Collection;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/activities/ContactEditorAccountsChangedActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/webkit/WebViewClassic;-setBaseLayer-(I Z Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothAdapter;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/SmsStorageMonitor;-handleIccFull-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/quickcontact/QuickContactActivity$5;-onLoadFinished-(Landroid/content/Loader; Lcom/android/contacts/ContactLoader$Result;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/PhoneInterfaceManager;-answerRingingCallInternal-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/LocalAlbumSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMAPhone;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/UserHistoryDictionary;-blockingReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/AccessibilitySettings;-handleToggleSpeakPasswordPreferenceClick-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityStack;-moveTaskToBackLocked-(I Lcom/android/server/am/ActivityRecord;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DataUsageSummary;-setMobilePolicySplit-(Z)V' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-getDrmMimeSavedStringRsrc-(J Z)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-addCachedDevices-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$AccountAnalyzer;-next-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/inputmethod/latin/ExpandableDictionary$LoadDictionaryTask;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/music/MusicPicker;-setSelected-(Landroid/database/Cursor;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/SMSDispatcher$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NotificationManagerService$SettingsObserver;-observe-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/quicksearchbox/util/SingleThreadNamedTaskExecutor$Worker;-run-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/event/AttendeesView;-addAttendees-(Ljava/util/ArrayList;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/server/BluetoothA2dpService;-isA2dpPlaying-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifySignalStrength-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/DockService;-connectIfEnabled-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/DownloadUtils;-requestDownload-(Lcom/android/gallery3d/util/ThreadPool$JobContext; Ljava/net/URL; Ljava/io/File;)Z' : ['android.permission.INTERNET'],
	'Lcom/android/mms/util/Recycler;-deleteMessagesForThread-(Landroid/content/Context; J I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-saveRingtone-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/development/SyncAdapterDriver;-startSyncSelected-(Landroid/view/View;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/BroadcastQueue;-skipPendingBroadcastLocked-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/Settings$VpnSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$7000-(Lcom/android/mms/ui/ComposeMessageActivity; I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/accounts/AccountSyncSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/NavScreen;-onClick-(Landroid/view/View;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity$DisplayAdapter;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/systemui/usb/StorageNotification$1;-run-()V' : ['android.permission.VIBRATE'],
	'Landroid/app/IBackupAgent;-doBackup-(Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Ljava/net/URLConnection;-connect-()V' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/activities/TransactionSafeActivity;-onBackPressed-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/base/FrameFetch;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService;-prev-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/XLargeUi;-setUseQuickControls-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView$2;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-onRegistrationDone-(Landroid/net/sip/ISipSession; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/SMSDispatcher;-dispatchPdus-([[B)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree;-init-(Landroid/content/Context; Lcom/android/internal/telephony/CallManager;)Lcom/android/phone/BluetoothHandsfree;' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/adapter/Search;-searchMessages-(Landroid/content/Context; J Lcom/android/emailcommon/service/SearchParams; J)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/bluetooth/HeadsetProfile;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-savePhonebookPermissionChoice-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/DockService;-applyBtSettings-(Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/SubSettings;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/ThrottleService$MyHandler;-onResetAlarm-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/OtaUtils;-startNonInteractiveOtasp-(Landroid/content/Context;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/gallery3d/app/AlbumPicker;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/PrivacySettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub;-hasFeatures-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/DataUsageSummary$4;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/SlotView$Listener;-onSingleTapUp-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/gallery3d/app/AlbumPage$2;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/server/BluetoothService;-setPropertyInteger-(Ljava/lang/String; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-beginDraggingWidget-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/Settings$ApplicationSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/IThrottleManager$Stub;-getByteCount-(Ljava/lang/String; I I I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/os/IPowerManager$Stub;-acquireWakeLock-(I Landroid/os/IBinder; Ljava/lang/String; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ManageSimMessages;-access$000-(Lcom/android/mms/ui/ManageSimMessages;)V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/uiautomator/core/InteractionController;-unfreezeRotation-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/wifi/WifiApEnabler;-updateTetherState-([Ljava/lang/Object; [Ljava/lang/Object; [Ljava/lang/Object;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/MessagingController;-synchronizeMailboxSynchronous-(Lcom/android/emailcommon/provider/Account; Lcom/android/emailcommon/provider/Mailbox;)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/ConnectivityManager;-getNetworkPreference-()I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-buildEntries-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/LocationManagerService$2;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$IncomingHid;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/AllInOneActivity;-updateSecondaryTitleFields-(J)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/RIL;-setLocationUpdates-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService;-access$2300-(Landroid/media/AudioService; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/FrameFetch;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/InCallScreen$15;-onCancel-(Landroid/content/DialogInterface;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/server/BluetoothA2dpService;-onConnectSinkResult-(Ljava/lang/String; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/inputmethodservice/KeyboardView;-openPopupIfRequired-(Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onCleanUpConnection-(Z I Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-access$000-(Lcom/android/internal/telephony/gsm/GsmConnection;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/server/am/ActivityRecord$Token;-keyDispatchingTimedOut-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$StartingState;-enter-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState;-onPressShift-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Landroid/server/BluetoothService;-allowIncomingProfileConnect-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-process-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/nfc/tech/MifareClassic;-setTimeout-(I)V' : ['android.permission.NFC'],
	'Lcom/android/settings/SettingsPreferenceFragment;-onPrepareOptionsMenu-(Landroid/view/Menu;)V' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/google/android/mms/pdu/PduPersister;-updateHeaders-(Landroid/net/Uri; Lcom/google/android/mms/pdu/SendReq;)V' : ['android.permission.READ_SMS'],
	'Landroid/net/ThrottleManager;-getResetTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/calllog/CallLogQueryHandler;-fetchVoicemailStatus-()V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-onTypeSelectionChange-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/transaction/SmsReceiverService;-insertMessage-(Landroid/content/Context; [Landroid/telephony/SmsMessage; I Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/location/GpsLocationProvider;-requestSetID-(I)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/inputmethodservice/KeyboardView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/speech/SpeechRecognizer;-startListening-(Landroid/content/Intent;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/contacts/calllog/CallLogAdapter$CallFetcher;-fetchCalls-()V' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/music/MediaPlaybackService;-removeTrack-(J)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/Controller$LegacyListener;-loadAttachmentFinished-(J J J)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/activity/UIControllerSearchTwoPane;-onMessageNotExists-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-refresh-(Landroid/text/format/Time; J Ljava/lang/String; Z Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onCallEnded-(Lcom/android/internal/telephony/Connection$DisconnectCause;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-access$1800-(Lcom/android/server/ConnectivityService; I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/LockScreen$GlowPadViewMethods;-onGrabbedStateChange-(Landroid/view/View; I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/email/activity/UIControllerTwoPane;-showAccountSpecificWarning-(J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/AudioService$ScoClient;-requestScoState-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/UI;-setUseQuickControls-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/email/Controller;-getServiceForAccount-(J)Lcom/android/emailcommon/service/IEmailService;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/contacts/ContactsProvider2;-getType-(Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/utility/CalendarUtilities;-createMessageForEventId-(Landroid/content/Context; J I Ljava/lang/String; Lcom/android/emailcommon/provider/Account; Ljava/lang/String;)Lcom/android/emailcommon/provider/EmailContent$Message;' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterfw/core/Filter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub$Proxy;-sendExtraCommand-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_LOCATION_EXTRA_COMMANDS', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/io/File;)V' : ['android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/TintFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/location/ILocationManager;-requestLocationUpdatesPI-(Ljava/lang/String; Landroid/location/Criteria; J F Z Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/server/BluetoothEventLoop;-onAgentAuthorize-(Ljava/lang/String; Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/AddBookmarkPage;-getUriForFolder-(J)Landroid/net/Uri;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/wifi/WifiSettings;-forget-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/PatternUnlockScreen$UnlockPatternListener;-onPatternDetected-(Ljava/util/List;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/exchange/ExchangeService;-done-(Lcom/android/exchange/AbstractSyncService;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/ContentResolver;-getPeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/am/CoreSettingsObserver;-beginObserveCoreSettings-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/IAccountManager$Stub;-setUserData-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/server/BluetoothAdapterStateMachine$WarmUp;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/service/PopImapSyncAdapterService;-performSync-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageCompose$6;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getCallWaiting-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree;-connectHeadset-(Landroid/bluetooth/HeadsetBase; I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/soundrecorder/Recorder;-setState-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-startRunning-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/BrightnessPreference;-onRestoreInstanceState-(Landroid/os/Parcelable;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/p2p/WifiP2pManager;-initialize-(Landroid/content/Context; Landroid/os/Looper; Landroid/net/wifi/p2p/WifiP2pManager$ChannelListener;)Landroid/net/wifi/p2p/WifiP2pManager$Channel;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/content/IContentService;-getPeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/widget/TransportControlView;-onClick-(Landroid/view/View;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/ThrottleService;-getByteCount-(Ljava/lang/String; I I I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterfw/core/FilterFunction;-executeWithArgList-([Ljava/lang/Object;)Landroid/filterfw/core/Frame;' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/mms/transaction/SendTransaction;-sendPdu-([B)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-setFilter-(Lcom/android/contacts/list/ContactListFilter;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/DataUsageSummary$AppDetailsFragment;-onStop-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$BluetoothPhoneState;-<init>-(Lcom/android/phone/BluetoothHandsfree; Lcom/android/phone/BluetoothHandsfree$1;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onRecordsLoaded-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/ActivityChooserModel$DataModelPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/accessibility/IAccessibilityManager;-unregisterUiTestAutomationService-(Landroid/accessibilityservice/IAccessibilityServiceClient;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/NfcService$NfcAdapterExtrasService;-close-(Ljava/lang/String; Landroid/os/IBinder;)Landroid/os/Bundle;' : ['android.permission.NFC'],
	'Landroid/server/BluetoothService;-pairingAttempt-(Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/LocationManagerService;-_getProviderInfoLocked-(Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;-onProgressComplete-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getScanResults-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/media/AudioService;-setBluetoothA2dpDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice; I)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppObexClientSession;-start-(Landroid/os/Handler;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleMultipartyIncallSupplementaryService-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper;-startCamera-()V' : ['android.permission.CAMERA'],
	'Lcom/android/server/ConnectivityService;-enforceChangePermission-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-handlePollCalls-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventFragment$1;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-handleCdmaSubscriptionSource-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/calendar/AllInOneActivity$4;-onChange-(Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/IccCard;-supplyPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/ContactsDictionary;-getBigrams-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/latin/Dictionary$WordCallback;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-addVideo-(Landroid/net/Uri; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$UpdateContent;-call-()Ljava/lang/Object;' : ['android.permission.VIBRATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnableActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/CropFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$AccountAnalyzer;-start-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/SecuritySettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/effect/effects/SaturateEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/InLineSettingKnob;-changeIndex-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/IConnectivityManager;-untether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/LocationManagerService;-access$2100-(Lcom/android/server/LocationManagerService; Landroid/location/Location; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth;-setPairingConfirmation-(Ljava/lang/String; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/MessageItem$PduLoadedCallback;-onPduLoaded-(Lcom/android/mms/ui/MessageItem;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/MccTable;-setWifiCountryCodeFromMcc-(Landroid/content/Context; I)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/media/AudioService;-sendDeviceConnectionIntent-(I I Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/DayView;-onCreateContextMenu-(Landroid/view/ContextMenu; Landroid/view/View; Landroid/view/ContextMenu$ContextMenuInfo;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService$1;-onRestrictBackgroundChanged-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-isConnectedProfile-(Lcom/android/settings/bluetooth/LocalBluetoothProfile;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/AccountsChangedReceiver$DeleteRemovedAccounts;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/LocationManagerService;-_isProviderEnabledLocked-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/NavScreen;-access$000-(Lcom/android/browser/NavScreen; Lcom/android/browser/Tab;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/statusbar/IStatusBarService;-expand-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/filterpacks/base/FrameBranch;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ViewInterface;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/Invert;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/RIL;-sendTerminalResponse-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$DisconnectingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-ensureRouteToHost-(Ljava/lang/String; Lcom/android/mms/transaction/TransactionSettings;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/camera/PanoramaActivity;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/util/State;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/BlendFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/inputmethod/keyboard/KeyboardSwitcher;-startLongPressTimer-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Lcom/android/mms/transaction/SmsReceiverService;-storeMessage-(Landroid/content/Context; [Landroid/telephony/SmsMessage; I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/AsyncQueryService;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/activities/PeopleActivity;-access$300-(Lcom/android/contacts/activities/PeopleActivity;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-conference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothHealth;-getMainChannelFd-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-setSelectedContactUri-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/SIMFileHandler;-loadEFLinearFixed-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-setPropertyBoolean-(Ljava/lang/String; Z)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/Settings$DataUsageSummaryActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/os/IHardwareService$Stub;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/internal/telephony/PhoneBase;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/Filter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/LightsService$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/phone/PhoneUtils;-hangupHoldingCall-(Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService;-setSpeakerphoneOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.MOUNT_FORMAT_FILESYSTEMS'],
	'Landroid/bluetooth/BluetoothInputDevice;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-onCreate-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth;-getHealthDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/IccCard;-setIccLockEnabled-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/accessibility/IAccessibilityManager$Stub$Proxy;-unregisterUiTestAutomationService-(Landroid/accessibilityservice/IAccessibilityServiceClient;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-restoreSelectedUri-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/activities/PeopleActivity;-showEmptyStateForTab-(I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/MessageListFragment$MessageOpenTask;-callOnCancelledForTest-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/soundrecorder/Recorder;-clear-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/PhoneUi;-<init>-(Landroid/app/Activity; Lcom/android/browser/UiController;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/transaction/PushReceiver$ReceivePushTask;-doInBackground-([Landroid/content/Intent;)Ljava/lang/Void;' : ['android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/PhotoPage$2;-onLoadingFinished-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/BluetoothAdapter;-cancelDiscovery-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/PhotoView$MyGestureListener;-onUp-()V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Landroid/webkit/HTML5VideoView;-prepareDataCommon-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-saveDraft-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/Settings$AccountSyncSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiManager;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/gallery3d/util/JobLimiter$JobWrapper;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Lcom/android/browser/Tab;-deleteThumbnail-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/calendar/alerts/QuickResponseActivity;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/TelephonyRegistry;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/NfcService;-onSeEmvCardRemoval-()V' : ['android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-onBluetoothStateChanged-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/WifiStateMachine$TetheredState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/RequestPermissionActivity$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/RotarySelector;-vibrate-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/provider/Browser;-addSearchUrl-(Landroid/content/ContentResolver; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/camera/ActivityBase;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.CAMERA', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.RECORD_AUDIO', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.NFC'],
	'Landroid/server/BluetoothService;-getKnownDevices-()[Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onVoiceCallStarted-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-onCreatePairedDeviceResult-(Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/widget/SlidingTab$OnTriggerListener;-onTrigger-(Landroid/view/View; I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/nfc/handover/HandoverManager$HandoverTransfer;-cancel-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/PhoneBase;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ContactListFilterControllerImpl;-selectCustomFilter-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/StateManager;-startStateForResult-(Ljava/lang/Class; I Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/pm/PackageManagerService;-main-(Landroid/content/Context; Z Z)Landroid/content/pm/IPackageManager;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/nfc/tech/Ndef;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Lcom/android/phone/MobileNetworkSettings;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/tech/Ndef;-makeReadOnly-()Z' : ['android.permission.NFC'],
	'Lcom/android/phone/BluetoothHandsfree$ScoSocketConnectThread;-run-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/server/BluetoothService;-setPairingConfirmation-(Ljava/lang/String; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity$12;-run-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-postEventFromNative-(Ljava/lang/Object; I I I Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FlipFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-onDevicePreferenceClick-(Lcom/android/settings/bluetooth/BluetoothDevicePreference;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Landroid/webkit/HTML5VideoFullScreen;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-showEmptyState-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/app/ManageCachePage;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/view/IWindowManager$Stub;-disableKeyguard-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-initDevicePreference-(Lcom/android/settings/bluetooth/BluetoothDevicePreference;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-setWifiApEnabled-(Landroid/net/wifi/WifiConfiguration; Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/phone/PhoneUtils;-mergeCalls-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IConnectivityManager;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/TabControl;-createNewTab-()Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/transaction/TransactionService$ServiceHandler;-processTransaction-(Lcom/android/mms/transaction/Transaction;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_SMS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.RECEIVE_SMS'],
	'Landroid/widget/VideoView;-release-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/LatinIME;-handleCharacterWhileInBatchEdit-(I I I I Landroid/view/inputmethod/InputConnection;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/EasAccountService;-tryAutodiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcAdapterExtras$Stub;-getCardEmulationRoute-(Ljava/lang/String;)I' : ['android.permission.NFC'],
	'Lcom/android/browser/TabControl;-removeParentChildRelationShips-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/sip/SipService;-notifyProfileRemoved-(Landroid/net/sip/SipProfile;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/calllog/CallLogListItemHelper;-setPhoneCallDetails-(Lcom/android/contacts/calllog/CallLogListItemViews; Lcom/android/contacts/PhoneCallDetails; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendEnvelope-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/RequestPermissionHelperActivity;-parseIntent-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler;-handleModeChanged-(I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/telephony/gsm/SmsManager;-getAllMessagesFromSim-()Ljava/util/ArrayList;' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-handleNotificationError-(Landroid/os/IBinder; Lcom/android/internal/statusbar/StatusBarNotification; Ljava/lang/String;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/gallery3d/ui/EdgeView;-render-(Lcom/android/gallery3d/ui/GLCanvas;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/CommandsInterface;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityRecord$Token;-windowsVisible-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/providers/contacts/ContactsProvider2;-call-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Bundle;)Landroid/os/Bundle;' : ['android.permission.READ_SOCIAL_STREAM'],
	'Lcom/android/exchange/adapter/AttachmentLoader;-finishLoadAttachment-()V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/base/NullFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetooth;-getBondState-(Ljava/lang/String;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/calllog/CallLogAdapter;-access$100-(Lcom/android/contacts/calllog/CallLogAdapter;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-processNextPostDialChar-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$SecuritySettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/ByteStreams;-getChecksum-(Lcom/google/common/io/InputSupplier; Ljava/util/zip/Checksum;)J' : ['android.permission.INTERNET'],
	'Lcom/android/phone/BluetoothHandsfree;-getAudioState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/AccountFilterActivity$FilterListAdapter;-<init>-(Landroid/content/Context; Ljava/util/List; Lcom/android/contacts/list/ContactListFilter;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/AttachmentLoader;-loadAttachment-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onCleanUpAllConnections-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/wifi/WifiEnabler;-setSwitch-(Landroid/widget/Switch;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/activity/MessageFileView$LoadFilenameTask;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/accounts/IAccountManager;-addAccount-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/calendar/DayFragment;-handleEvent-(Lcom/android/calendar/CalendarController$EventInfo;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DataUsageSummary;-setRestrictBackground-(Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-operationComplete-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/MediaPlayer;-setWakeMode-(Landroid/content/Context; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/DeviceHost$DeviceHostListener;-onCardEmulationAidSelected-([B)V' : ['android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/gallery3d/ui/GestureRecognizer$MyGestureListener;-onFling-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; F F)Z' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Landroid/provider/CalendarContract$CalendarAlerts;-rescheduleMissedAlarms-(Landroid/content/ContentResolver; Landroid/content/Context; Landroid/app/AlarmManager;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/BluetoothInputDevice;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothHeadset;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/calendar/CalendarReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-disconnectInputDevice-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth;-getMainChannelFd-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/util/AccountSelectionUtil;-getSelectAccountDialog-(Landroid/content/Context; I)Landroid/app/Dialog;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth$Stub;-connectInputDevice-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/UsageStatsService$2;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/inputmethod/UserDictionaryAddWordContents;-getLocalesList-(Landroid/app/Activity;)Ljava/util/ArrayList;' : ['android.permission.READ_USER_DICTIONARY'],
	'Landroid/app/ActivityManagerNative;-setDebugApp-(Ljava/lang/String; Z Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/StatusBarManagerService;-expand-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/phone/BluetoothHeadsetService$6;-stopVoiceRecognition-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/SmsReceiverService;-replaceMessage-(Landroid/content/Context; [Landroid/telephony/SmsMessage; I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/BluetoothHeadsetService$6;-acceptIncomingConnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/WhitelistDictionary;-isValidWord-(Ljava/lang/CharSequence;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/transaction/TransactionService$ConnectivityBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_SMS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/providers/calendar/CalendarProviderIntentService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/webkit/WebViewClassic;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/VideoEditorActivity$23;-onStart-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-isTetheringOn-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/AccountUnlockScreen;-onClick-(Landroid/view/View;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/KeyboardSwitcher;-onPressKey-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Lcom/android/email/Controller$LegacyListener;-checkMailStarted-(Landroid/content/Context; J J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/editor/ContactEditorFragment$PhotoHandler$PhotoEditorListener;-onPhotoSelected-(Landroid/graphics/Bitmap;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/launcher2/DragController;-startDrag-(Landroid/view/View; Landroid/graphics/Bitmap; Lcom/android/launcher2/DragSource; Ljava/lang/Object; I Landroid/graphics/Rect; F)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/gallery3d/ui/PhotoView;-pause-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$InitialState;-enter-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ISms$Stub;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS'],
	'Landroid/accounts/AccountManagerService;-checkAuthenticateAccountsPermission-(Landroid/accounts/Account;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppService$UpdateThread;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasSyncService;-sendSettings-()Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IRestoreSession;-getAvailableRestoreSets-(Landroid/app/backup/IRestoreObserver;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-queueQuery-(Lcom/android/calendar/agenda/AgendaWindowAdapter$QuerySpec;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/InCallScreen;-updateScreen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/MoviePlayer;-access$1200-(Lcom/android/gallery3d/app/MoviePlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$2;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$PrivacySettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ClassZeroActivity$3;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/CommandsInterface;-dial-(Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/voicedialer/VoiceContact;-redialNumber-(Landroid/app/Activity;)Ljava/lang/String;' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/am/ActivityManagerService;-moveTaskBackwards-(I)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/phone/CallFeaturesSetting;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/providers/settings/SettingsHelper;-applyAudioSettings-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneBase;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/KeyguardScreenCallback;-pokeWakelock-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/vcard/VCardParserImpl_V30;-handleNest-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/accounts/AccountManager$GetAuthTokenByTypeAndFeaturesTask;-run-(Landroid/accounts/AccountManagerFuture;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/AutoCorrection;-allowsToBeAutoCorrected-(Ljava/util/concurrent/ConcurrentHashMap; Ljava/lang/CharSequence; Z)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-selectNetworkManually-(Lcom/android/internal/telephony/OperatorInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-explicitCallTransfer-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/calendar/CalendarProvider2;-modifyCalendarSubscription-(J Z)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/browser/UiController;-openIncognitoTab-()Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/calendar/Utils;-getDayOfWeekString-(I I J Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/sip/ISipService;-open-(Landroid/net/sip/SipProfile;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/phone/Use2GOnlyCheckBoxPreference;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/UIControllerTwoPane;-onRespondedToInvite-(I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/nfc/DeviceHost$DeviceHostListener;-onRemoteEndpointDiscovered-(Lcom/android/nfc/DeviceHost$TagEndpoint;)V' : ['android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar$23;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/systemui/statusbar/policy/BrightnessController;-setMode-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/BluetoothHandsfree$22;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onDataStallAlarm-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeUtil;-putSelectedInputMethodSubtype-(Landroid/content/ContentResolver; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/editor/ContactEditorFragment$PhotoHandler;-<init>-(Lcom/android/contacts/editor/ContactEditorFragment; Landroid/content/Context; Lcom/android/contacts/editor/BaseRawContactEditorView; I Lcom/android/contacts/model/EntityDeltaList;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/IThrottleManager$Stub$Proxy;-getHelpUri-()Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-acquireWakeLockAndExecute-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/vcard/NotificationImportExportListener;-onCancelRequest-(Lcom/android/contacts/vcard/CancelRequest; I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-addCachedDevices-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onDisconnectDone-(I Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/AlarmKlaxon;-startAlarm-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity$RecipientsMenuClickListener;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneBase;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener$Adapter;-onCustomRequest-(I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-next-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/EmailConnectivityManager;-isAutoSyncAllowed-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/WifiService;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/server/BluetoothService;-connectHeadset-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothDeviceFilter$TransferFilter;-matches-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView;-<init>-(Landroid/content/Context; Lcom/android/internal/policy/impl/KeyguardViewCallback; Lcom/android/internal/policy/impl/KeyguardUpdateMonitor; Lcom/android/internal/widget/LockPatternUtils; Lcom/android/internal/policy/impl/KeyguardWindowController;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/filterfw/core/FilterFunction;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/SipManager;-makeAudioCall-(Landroid/net/sip/SipProfile; Landroid/net/sip/SipProfile; Landroid/net/sip/SipAudioCall$Listener; I)Landroid/net/sip/SipAudioCall;' : ['android.permission.USE_SIP'],
	'Lcom/android/gallery3d/app/SlideshowPage;-showPendingBitmap-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker$1;-onChange-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothAdapter;-listenUsingInsecureRfcommWithServiceRecord-(Ljava/lang/String; Ljava/util/UUID;)Landroid/bluetooth/BluetoothServerSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/Tab;-<init>-(Lcom/android/browser/WebViewController; Landroid/os/Bundle;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/Phone$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-setSuppServiceNotifications-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-access$1800-(Lcom/android/bluetooth/opp/BluetoothOppService; Landroid/database/Cursor; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/UIControllerSearchTwoPane;-updateMessageOrderManager-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-onItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeEnabler;-onPause-()V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getActiveLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/WifiService;-getConfiguredNetworks-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/media/effect/SizeChangeEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/InCallScreen;-internalSilenceRinger-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/settings/Settings$DevelopmentSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/MessageViewFragment;-addAttachment-(Lcom/android/emailcommon/provider/EmailContent$Attachment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/SupplicantStateTracker$CompletedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/DownUpDetector;-setState-(Z Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/server/am/BroadcastQueue$AppNotResponding;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-isDuplicateMessage-(Landroid/content/Context; Lcom/google/android/mms/pdu/RetrieveConf;)Z' : ['android.permission.READ_SMS'],
	'Lcom/android/mms/transaction/PushReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/LatinKeyboardView$KeyTimerHandler;-startKeyRepeatTimer-(Lcom/android/inputmethod/keyboard/PointerTracker;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/provider/Settings$Secure;-putFloat-(Landroid/content/ContentResolver; Ljava/lang/String; F)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/inputmethod/InputMethodPreference$6;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/transaction/Transaction;-ensureRouteToHost-(Ljava/lang/String; Lcom/android/mms/transaction/TransactionSettings;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/calendar/EventLoader$LoadEventsRequest;-processRequest-(Lcom/android/calendar/EventLoader;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler;-setDiscoverableTimeout-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/AccessibilitySettings;-handleTogglePowerButtonEndsCallPreferenceClick-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/effect/effects/GrayscaleEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/IccLockSettings;-tryChangePin-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/ConnectivityManager;-getActiveLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/soundrecorder/SoundRecorder;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-startRfcommSocketListener-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/SnapshotTab;-postCapture-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/DataController$DataControllerHandler;-doLoadThumbnail-(Lcom/android/browser/Tab;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/FlipFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/camera/Camera;-initializeSecondTime-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/InCallScreen;-closeDialpadInternal-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth;-getTrustState-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothAdapter;-setDiscoverableTimeout-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/widget/WaveView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-allowIncomingConnect-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/server/BluetoothService;-getProperty-(Ljava/lang/String; Z)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService$MyExecutor;-execute-(Ljava/lang/Runnable;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/soundrecorder/SoundRecorder$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasAccountService;-sendHttpClientPost-(Ljava/lang/String; [B)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/PrivacySettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter;-executeAndWait-(Ljava/util/concurrent/Callable;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/RIL;-dial-(Ljava/lang/String; I Lcom/android/internal/telephony/UUSInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager;-access$900-(Landroid/content/SyncManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/keyboard/internal/PointerTrackerQueue;-releaseAllPointers-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/BluetoothHandsfree$28;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-onUuidChanged-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothAtPhonebook;-queryPhonebook-(Ljava/lang/String; Lcom/android/phone/BluetoothAtPhonebook$PhonebookResult;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/nfc/NfcService$TagService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.NFC'],
	'Lcom/android/contacts/activities/GroupEditorActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager;-requestRouteToHost-(I I)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/mms/ui/NoConfirmationSendService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/selectcalendars/SelectSyncedCalendarsMultiAccountAdapter;-getChildrenCursor-(Landroid/database/Cursor;)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/BluetoothDeviceFilter$PanuFilter;-matches-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/BluetoothHandsfree$14;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/BluetoothCallback;-onBluetoothStateChanged-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-animateCollapse-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/browser/NavScreen$2;-onLayout-(I I I I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/location/ILocationManager$Stub;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/ISms;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/browser/AddBookmarkPage$UpdateBookmarkTask;-doInBackground-([Landroid/content/ContentValues;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$ProvisionDiscoveryState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/util/IState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.INTERNET', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$StorageSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/providers/downloads/DownloadInfo;-isReadyToStart-(J)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/TrackBrowserActivity;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-processStartTimedOutLocked-(Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/cat/CatService;-sendTerminalResponse-(Lcom/android/internal/telephony/cat/CommandDetails; Lcom/android/internal/telephony/cat/ResultCode; Z I Lcom/android/internal/telephony/cat/ResponseData;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallTouchUi;-updateState-(Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/AccountsTester$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/filterpacks/imageproc/CropFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/BluetoothHandsfree$29;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$3100-(Lcom/android/mms/ui/ComposeMessageActivity; J)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/inputmethod/latin/LatinIME$UIHandler;-postUpdateSuggestions-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ui/PhotoView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/nfc/NfcService$TagService;-rediscover-(I)Landroid/nfc/Tag;' : ['android.permission.NFC'],
	'Lcom/android/server/wm/WindowManagerService;-reevaluateStatusBarVisibility-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-pingSupplicant-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/editor/AggregationSuggestionView;-handleItemClickEvent-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/base/GLTextureTarget;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioManager;-stopBluetoothSco-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/spellcheck/AndroidSpellCheckerService$AndroidSpellCheckerSession;-onGetSuggestions-(Landroid/view/textservice/TextInfo; I)Landroid/view/textservice/SuggestionsInfo;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/DreamComponentPreference$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/GlobalActions$2;-onLongPress-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.VIBRATE'],
	'Lcom/android/email/activity/UIControllerTwoPane;-installMessageViewFragment-(Lcom/android/email/activity/MessageViewFragment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/interactions/PhoneNumberInteraction$PhoneDisambiguationDialogFragment;-onCreateDialog-(Landroid/os/Bundle;)Landroid/app/Dialog;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiStateMachine$DriverLoadedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/Controller;-sendPendingMessages-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mms/ui/SlideViewInterface;-startAudio-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/UIControllerOnePane;-onActivityResume-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-access$700-(Lcom/android/gallery3d/ui/MenuExecutor; I Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/Phone;-dispose-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManagerService;-confirmCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Landroid/os/Bundle; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/net/sip/ISipService;-setRegistrationListener-(Ljava/lang/String; Landroid/net/sip/ISipSessionListener;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/settings/Settings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/DataUsageSummary$LimitEditorFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-createDevicePreference-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/TetherSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/deviceinfo/UsbSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/view/IWindowSession$Stub$Proxy;-add-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/email/activity/setup/MailboxSettings$2;-callOnCancelledForTest-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/HTML5VideoInline;-prepareDataAndDisplayMode-(Landroid/webkit/HTML5VideoViewProxy;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/CallbackFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/LatinIME;-access$700-(Lcom/android/inputmethod/latin/LatinIME;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/RecognitionManagerService;-systemReady-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/LockScreen;-<init>-(Landroid/content/Context; Landroid/content/res/Configuration; Lcom/android/internal/widget/LockPatternUtils; Lcom/android/internal/policy/impl/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/KeyguardScreenCallback;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/nfc/nxp/NativeNfcManager;-notifySeApduReceived-([B)V' : ['android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-setWakeMode-(Landroid/content/Context; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/GLView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-dispose-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMALTEPhone;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/data/LocationClustering;-run-(Lcom/android/gallery3d/data/MediaSet;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ContactListFilterControllerImpl;-setContactListFilter-(Lcom/android/contacts/list/ContactListFilter; Z Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-main-(Landroid/content/Context; Lcom/android/server/PowerManagerService; Z Z Z)Lcom/android/server/wm/WindowManagerService;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/IWifiManager;-startWifi-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-<init>-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/provider/Settings$Bookmarks;-add-(Landroid/content/ContentResolver; Landroid/content/Intent; Ljava/lang/String; Ljava/lang/String; C I)Landroid/net/Uri;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-revertToNitzTimeZone-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/app/AlbumPage$2;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/PhotoPage;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/TetherSettings;-updateBluetoothState-([Ljava/lang/String; [Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/DhcpStateMachine$DefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendRawPdu-([B [B Landroid/app/PendingIntent; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller;-openTab-(Ljava/lang/String; Lcom/android/browser/Tab; Z Z)Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifyServiceState-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/DeleteEventHelper;-delete-(J J J I Ljava/lang/Runnable;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/TetherSettings;-updateState-([Ljava/lang/String; [Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/DockService;-handleBluetoothStateOn-(I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CommandsInterface;-acknowledgeIncomingGsmSmsWithPdu-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videosrc/MediaSource;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/InLineSettingKnob$3;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/os/storage/IMountService;-formatVolume-(Ljava/lang/String;)I' : ['android.permission.MOUNT_FORMAT_FILESYSTEMS'],
	'Landroid/net/nsd/NsdManager;-init-()V' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/ContactSaveService;-removeMembersFromGroup-(Landroid/content/ContentResolver; [J J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/SupplicantStateTracker$UninitializedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/ApplicationPackageManager;-getPackageGids-(Ljava/lang/String;)[I' : ['android.permission.READ_EXTERNAL_STORAGE'],
	'Landroid/location/ILocationManager$Stub;-clearTestProviderStatus-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/net/sip/SipAudioCall;-setSpeakerMode-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/bluetooth/BluetoothHeadset;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/media/IAudioService$Stub$Proxy;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/location/LocationManager;-addNmeaListener-(Landroid/location/GpsStatus$NmeaListener;)Z' : ['android.permission.ACCESS_FINE_LOCATION'],
	'Lcom/android/calendar/selectcalendars/SelectVisibleCalendarsFragment;-onResume-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/ApplicationSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/PhoneUtils;-startGetCallerInfo-(Landroid/content/Context; Lcom/android/internal/telephony/Connection; Lcom/android/internal/telephony/CallerInfoAsyncQuery$OnQueryCompleteListener; Ljava/lang/Object;)Lcom/android/phone/PhoneUtils$CallerInfoToken;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/server/BluetoothService;-sendUuidIntent-(Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/KeyguardUpdateMonitor$SimStateCallback;-onSimStateChanged-(Lcom/android/internal/telephony/IccCard$State;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/speech/tts/PlaybackQueueItem;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-sendEnvelopeWithStatus-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/OtaUtils;-otaShowProgramFailureDialog-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-startLongPressTimer-(Lcom/android/inputmethod/keyboard/Key;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/TintFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/emailcommon/service/IAccountService$Stub;-reconcileAccounts-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/contacts/ContactsProvider2$PipeMonitor;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/CropView;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/Tab;-removeFromTree-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/CrossProcessFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/nfc/tech/NfcA;-getTimeout-()I' : ['android.permission.NFC'],
	'Lcom/android/voicedialer/RecognizerEngine;-recognize-(Lcom/android/voicedialer/RecognizerClient; Landroid/app/Activity; Ljava/io/File; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$4400-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine; Landroid/net/wifi/p2p/WifiP2pConfig; Z)V' : ['android.permission.GET_TASKS'],
	'Lcom/android/server/PowerManagerService;-releaseWakeLock-(Landroid/os/IBinder; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/LocationSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/IContentService;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/ui/CropView;-renderChild-(Lcom/android/gallery3d/ui/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/EventLoader$LoadEventDaysRequest;-processRequest-(Lcom/android/calendar/EventLoader;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/email/activity/setup/DebugFragment;-clearWebViewCache-()V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cat/IconLoader;-loadIcon-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/CropEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/WallpaperManager;-setStream-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/JoinContactListAdapter;-getFirstContactUri-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getConnectedHealthDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/nfc/tech/NfcF;-connect-()V' : ['android.permission.NFC'],
	'Landroid/filterpacks/imageproc/CrossProcessFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/SettingsPreferenceFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IConnectivityManager$Stub;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onDownEventInternal-(I I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/SearchPanelView$1;-run-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-onPause-()V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/WhitelistDictionary;-blockingReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/activity/MessageViewFragment;-onMarkAsUnread-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/GlobalActions$2;-onPress-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.VIBRATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SettingsObserver;-startObserving-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-isForwardable-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/DayView;-switchViews-(Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/app/IAlarmManager$Stub;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/ui/PhotoView;-access$3300-(Lcom/android/gallery3d/ui/PhotoView; I I)V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Landroid/webkit/WebViewClassic;-drawContent-(Landroid/graphics/Canvas;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$23;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/webkit/HTML5VideoView;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/UserHistoryDictionary;-getWords-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/latin/Dictionary$WordCallback; Lcom/android/inputmethod/keyboard/ProximityInfo;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/IConnectivityManager;-getNetworkInfo-(I)Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/voicedialer/VoiceDialerActivity;-access$600-(Lcom/android/voicedialer/VoiceDialerActivity; I)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-getMmsReportItems-()Ljava/util/List;' : ['android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/CryptKeeper;-access$600-(Lcom/android/settings/CryptKeeper;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BaseUi;-showWeb-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/server/BluetoothHealthProfileHandler;-unregisterAppConfiguration-(Landroid/bluetooth/BluetoothHealthAppConfiguration;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityStack;-updateTransitLocked-(I Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/RadioInfo$20;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppManager;-enableBluetooth-()V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/EffectsRecorder;-setPreviewSurfaceTexture-(Landroid/graphics/SurfaceTexture; I I)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider;-onUpdate-(Landroid/content/Context; Landroid/appwidget/AppWidgetManager; [I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/INetworkPolicyManager$Stub$Proxy;-setRestrictBackground-(Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$DebugThread;-run-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$StopTetheringErrorState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/DockObserver;-update-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/UIControllerTwoPane$RefreshTask;-onSuccess-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/providers/contacts/ContactsProvider2;-updateAccountsInBackground-([Landroid/accounts/Account;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-addAudio-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-handleTimeout-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/CommandsInterface;-iccIO-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar;-addNotificationViews-(Landroid/os/IBinder; Lcom/android/internal/statusbar/StatusBarNotification;)Lcom/android/systemui/statusbar/StatusBarIconView;' : ['android.permission.VIBRATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-updateFromProvider-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ISms;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/contacts/activities/PeopleActivity;-onAction-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/BrowserBackupAgent;-addBookmark-(Lcom/android/browser/BrowserBackupAgent$Bookmark;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/Tab;-<init>-(Lcom/android/browser/WebViewController; Landroid/webkit/WebView;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/ui/PhotoView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-onCancelled-(Ljava/lang/Void;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaByDayAdapter;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onSetPolicyDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/wifi/WifiEnabler;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/app/IActivityManager;-wakingUp-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BreadCrumbView;-pop-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendPdu-([B Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-play-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/tech/IsoDep;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Lcom/android/soundrecorder/SoundRecorder;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-access$000-(Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/app/IAlarmManager$Stub$Proxy;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/inputmethod/latin/Suggest;-getAllBigrams-(Ljava/lang/CharSequence; Lcom/android/inputmethod/latin/WordComposer;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/providers/calendar/CalendarAlarmManager;-releaseScheduleNextAlarmWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/vcard/VCardEntry$SipData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mms/data/Conversation;-startQueryHaveLockedMessages-(Landroid/content/AsyncQueryHandler; Ljava/util/Collection; I)V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/downloads/DownloadThread;-openResponseEntity-(Lcom/android/providers/downloads/DownloadThread$State; Lorg/apache/http/HttpResponse;)Ljava/io/InputStream;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothHealthProfileHandler;-disconnectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/InputMethodManagerService;-systemReady-(Lcom/android/server/StatusBarManagerService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/calllog/CallLogAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/DriverCall; Lcom/android/internal/telephony/gsm/GsmCallTracker; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasAccountService;-parsePingResult-(Ljava/io/InputStream; Landroid/content/ContentResolver; Ljava/util/HashMap;)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/inputmethod/UserDictionaryAddWordFragment;-updateSpinner-()V' : ['android.permission.READ_USER_DICTIONARY'],
	'Lcom/android/email/service/MailService$ControllerResults;-updateMailboxCallback-(Lcom/android/emailcommon/mail/MessagingException; J J I I Ljava/util/ArrayList;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/systemui/recent/RecentsHorizontalScrollView;-onChildDismissed-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/KeyguardViewManager$KeyguardViewHost;-dispatchDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/providers/contacts/ContactsProvider2;-openAssetFile-(Landroid/net/Uri; Ljava/lang/String;)Landroid/content/res/AssetFileDescriptor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/EasSyncService;-executePostWithTimeout-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; I Z)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-start-()V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/email/activity/MessagesAdapter$MessagesCursorLoader;-loadInBackground-()Ljava/lang/Object;' : ['android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/SlideshowPage;-onCreateActionBar-(Landroid/view/Menu;)Z' : ['android.permission.NFC'],
	'Lcom/android/gallery3d/ui/AlbumSetSlidingWindow;-getLoadingTexture-()Lcom/android/gallery3d/ui/BitmapTexture;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Lcom/android/contacts/list/ContactBrowseListFragment$ContactLookupTask;-onPostExecute-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/GalleryActionBar$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/LegacyPostalAddressListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/Tab$3;-onCloseWindow-(Landroid/webkit/WebView;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/nfc/tech/BasicTagTechnology;-connect-()V' : ['android.permission.NFC'],
	'Landroid/accounts/AccountManager$2;-startTask-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/InputMethodManagerService$InputMethodSettings;-putEnabledInputMethodsStr-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothA2dp;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityManagerService;-addAppLocked-(Landroid/content/pm/ApplicationInfo; Z)Lcom/android/server/am/ProcessRecord;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/bluetooth/BluetoothTetheringDataTracker;-teardown-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DisplaySettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$MainHanler$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/RedEyeFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/TrackBrowserActivity;-onListItemClick-(Landroid/widget/ListView; Landroid/view/View; I J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendSms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/IBatteryStats$Stub$Proxy;-noteBluetoothOn-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/RetryScheduler;-getResponseStatus-(J)I' : ['android.permission.READ_SMS'],
	'Lcom/android/vcard/VCardEntry$EntryElement;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/BluetoothAdapter;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/content/AbstractThreadedSyncAdapter$ISyncAdapterImpl;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-reloadDataAndSetSelectedUri-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/WiredAccessoryObserver;-init-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/NotificationPlayer$CreationAndCompletionThread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-onItemClick-(I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-hangup-(Lcom/android/internal/telephony/cdma/CdmaCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FlipFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processDisplayText-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/SupplicantStateTracker$ScanState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.INTERNET', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/FlipFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/mms/ui/ClassZeroActivity;-access$200-(Lcom/android/mms/ui/ClassZeroActivity;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/input/InputManagerService;-showMissingKeyboardLayoutNotification-()V' : ['android.permission.VIBRATE'],
	'Landroid/bluetooth/IBluetoothPbap$Stub$Proxy;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/RequestPermissionActivity;-proceedAndFinish-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/DataUsageSummary;-access$100-(Lcom/android/settings/DataUsageSummary;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/list/ContactPickerFragment;-onStart-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getInputDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/VideoCamera;-onError-(Landroid/media/MediaRecorder; I I)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/Settings$VpnSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/LegacyPostalAddressListAdapter;-getContactMethodUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/media/effect/effects/TintEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar$24;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/server/BluetoothService;-registerAppConfiguration-(Landroid/bluetooth/BluetoothHealthAppConfiguration; Landroid/bluetooth/IBluetoothHealthCallback;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/EdgeView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/nfc/INfcAdapterExtras;-close-(Ljava/lang/String; Landroid/os/IBinder;)Landroid/os/Bundle;' : ['android.permission.NFC'],
	'Lcom/android/systemui/SwipeHelper$2;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/detail/ContactDetailLayoutController;-setContactData-(Lcom/android/contacts/ContactLoader$Result;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub;-disableNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccFileHandler;-loadEFImgTransparent-(I I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/WorkingMessage;-loadFromUri-(Landroid/net/Uri;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/Settings$DockSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-setHdmiPlugged-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/MailboxSettings$2;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/WebStorageSizeManager;-onReachedMaxAppCacheSize-(J J Landroid/webkit/WebStorage$QuotaUpdater;)V' : ['android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/GrainFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-deleteSmsOnSim-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/vcard/NfcImportVCardActivity$ImportTask;-doInBackground-([Lcom/android/contacts/vcard/VCardService;)Lcom/android/contacts/vcard/ImportRequest;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-refreshStats-()V' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/location/ILocationManager$Stub$Proxy;-clearTestProviderLocation-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/bluetooth/BluetoothSocket;-initSocketNative-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/Controller;-switchToTab-(Lcom/android/browser/Tab;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/IccFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/hardware/input/InputManager;-setPointerSpeed-(Landroid/content/Context; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/IActivityManager;-killAllBackgroundProcesses-()V' : ['android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/settings/Settings$HeaderAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/WindowManagerService;-requestTraversalLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/ConnectivityManager;-setRadios-(Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/contacts/ContactsProvider2;-insertStatusUpdate-(Landroid/content/ContentValues;)J' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mms/transaction/TransactionService;-onDestroy-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_SMS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.RECEIVE_SMS'],
	'Landroid/server/BluetoothService;-runBluetooth-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/MediaPlaybackActivity;-access$1100-(Lcom/android/music/MediaPlaybackActivity;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PasswordUnlockScreen;-<init>-(Landroid/content/Context; Landroid/content/res/Configuration; Lcom/android/internal/widget/LockPatternUtils; Lcom/android/internal/policy/impl/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/KeyguardScreenCallback;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-toggleState-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/GroupEditorActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/editor/ContactEditorFragment$PhotoHandler$PhotoEditorListener;-onRemovePictureChosen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/gadget/WidgetService$PhotoRVFactory;-getViewAt-(I)Landroid/widget/RemoteViews;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Lcom/android/contacts/ContactSaveService$Listener;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/GroupMemberLoader;-constructLoaderForGroupEditorQuery-(Landroid/content/Context; J)Lcom/android/contacts/GroupMemberLoader;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/BluetoothDevice;-setRemoteOutOfBandData-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-onAllRecordsLoaded-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/providers/calendar/CalendarProvider2;-deleteMatchingCalendars-(Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/policy/impl/PatternUnlockScreen$UnlockPatternListener;-onPatternCellAdded-(Ljava/util/List;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/server/BluetoothA2dpService;-<init>-(Landroid/content/Context; Landroid/server/BluetoothService;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Landroid/nfc/tech/MifareClassic;-restore-(I)V' : ['android.permission.NFC'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-disconnect-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-handlePollStateResult-(I Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/LocationManagerService;-addProximityAlert-(D D F J Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActivityManagerService;-finishBooting-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/location/GpsNetInitiatedHandler;-handleNiNotification-(Lcom/android/internal/location/GpsNetInitiatedHandler$GpsNiNotification;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/am/ActivityStack;-moveHomeToFrontLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/provider/Contacts$People;-createPersonInMyContactsGroup-(Landroid/content/ContentResolver; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumSetPage$4;-onActionItemClicked-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/location/LocationManager;-setTestProviderStatus-(Ljava/lang/String; I Landroid/os/Bundle; J)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/contacts/list/EmailAddressListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/editor/RawContactReadOnlyEditorView;-setPhotoBitmap-(Landroid/graphics/Bitmap;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/MountService;-formatVolume-(Ljava/lang/String;)I' : ['android.permission.MOUNT_FORMAT_FILESYSTEMS'],
	'Landroid/media/effect/FilterGraphEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/Session;-performDrag-(Landroid/view/IWindow; Landroid/os/IBinder; F F F F Landroid/content/ClipData;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/LatinIME;-onCreate-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-doSaveAction-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/vcard/ProcessorBase;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/latin/LatinIME;-onRefreshKeyboard-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/sip/SipAudioCall;-endCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService$NfcAdapterExtrasService;-setCardEmulationRoute-(Ljava/lang/String; I)V' : ['android.permission.NFC'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-onKey-(I [I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/policy/impl/SimPukUnlockScreen;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/exchange/EasOutboxService;-hasConnectivity-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/Bookmarks$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/inputmethod/latin/WhitelistDictionary;-loadDictionary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/TintFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-setAndPersistDeviceName-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$4;-onUserChanged-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/editor/BaseRawContactEditorView;-setPhotoBitmap-(Landroid/graphics/Bitmap;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/DayView;-onLongClick-(Landroid/view/View;)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/data/FilterDeleteSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/VibratorService$2;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-connectHeadset-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/BrowserYesNoPreference;-onDialogClosed-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/app/AlbumPage;-access$1200-(Lcom/android/gallery3d/app/AlbumPage; I)V' : ['android.permission.VIBRATE'],
	'Landroid/webkit/WebViewClassic$8;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/webkit/GeolocationService;-start-()Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/AudioService;-dispatchMediaKeyEventForCalls-(Landroid/view/KeyEvent; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/UIControllerOnePane;-onInstallFragment-(Landroid/app/Fragment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth;-removeServiceRecord-(I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/server/BluetoothService;-autoConnect-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/PhoneUi;-showNavScreen-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/SystemAllowGeolocationOrigins;-start-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/WiredAccessoryObserver;-update-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-processMessagePart-([B Ljava/lang/String; I I I J I Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/email/activity/UIControllerTwoPane;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cat/CatService;-handleRilMsg-(Lcom/android/internal/telephony/cat/RilMessage;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setPassword-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/phone/BluetoothHandsfree$28;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/tts/TtsEngineSettingsFragment;-updateVoiceDetails-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/emailcommon/service/IEmailService$Stub$Proxy;-deleteAccountPIMData-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/ex/variablespeed/MediaPlayerProxy;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-removeBond-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/gadget/WidgetService$PhotoRVFactory;-onDataSetChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/MessageListFragment$MessageOpenTask;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/view/IWindowSession$Stub$Proxy;-performDrag-(Landroid/view/IWindow; Landroid/os/IBinder; F F F F Landroid/content/ClipData;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-loadDictionary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getSuggestionsExternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-interceptMotionBeforeQueueingWhenScreenOff-(I)I' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/Utils;-getTetheringLabel-(Landroid/net/ConnectivityManager;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/IccCard;-supplyPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/telephony/MmsSmsProvider;-update-(Landroid/net/Uri; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/list/PostalAddressPickerFragment;-setQueryString-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/Controller$Download;-saveDataUri-()V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupEditorFragment$2;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-setSafeMode-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/calendar/CalendarController;-sendEvent-(Ljava/lang/Object; J Landroid/text/format/Time; Landroid/text/format/Time; Landroid/text/format/Time; J I J Ljava/lang/String; Landroid/content/ComponentName;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/policy/impl/KeyguardUpdateMonitor;-reportSimUnlocked-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/browser/Tab$2;-shouldOverrideUrlLoading-(Landroid/webkit/WebView; Ljava/lang/String;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-onRefresh-(Z [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$DriverUnloadedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-startRepeatKey-(Lcom/android/inputmethod/keyboard/Key;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/nfc/tech/MifareUltralight;-transceive-([B Z)[B' : ['android.permission.NFC'],
	'Lcom/android/email/activity/MessageViewFragmentBase$1;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-keyguardDoneDrawing-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/AccountManagerService;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/providers/contacts/VoicemailCleanupService;-onHandleIntent-(Landroid/content/Intent;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-createConsentDialog-(Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/EmailActivity;-onResume-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/tech/Ndef;-getNdefMessage-()Landroid/nfc/NdefMessage;' : ['android.permission.NFC'],
	'Landroid/inputmethodservice/KeyboardView;-sendAccessibilityEventForUnicodeCharacter-(I I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/phone/EmergencyCallbackModeService;-access$200-(Lcom/android/phone/EmergencyCallbackModeService; J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/DevelopmentSettings$ConfirmEnforceFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_EXTERNAL_STORAGE'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/MailboxFinder$ControllerResults;-updateMailboxCallback-(Lcom/android/emailcommon/mail/MessagingException; J J I I Ljava/util/ArrayList;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-finish-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-onWakeMotionWhenKeyguardShowingTq-()Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/exchange/EasOutboxService;-tryProvision-(Lcom/android/exchange/EasSyncService;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/suggestions/SuggestionsView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Lcom/android/contacts/list/JoinContactListAdapter;-getContactUri-(I Landroid/database/Cursor;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/event/AttendeesView;-constructAttendeeView-(Lcom/android/calendar/event/EditEventHelper$AttendeeItem;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-writeSmsToSim-(I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine;-access$16800-(Landroid/net/wifi/WifiStateMachine;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/INotificationManager;-enqueueNotification-(Ljava/lang/String; I Landroid/app/Notification; [I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/inputmethod/keyboard/LatinKeyboardView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Lcom/android/emailcommon/service/IEmailService;-deleteAccountPIMData-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-setAndBroadcastNetworkSetTimeZone-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-cancelPairingUserInput-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/ContentService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/settings/DevelopmentSettings;-resetDangerousOptions-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_EXTERNAL_STORAGE', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/AccountFilterActivity;-loadAccountFilters-(Landroid/content/Context;)Ljava/util/List;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/provider/Telephony$Threads;-getOrCreateThreadId-(Landroid/content/Context; Ljava/util/Set;)J' : ['android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$2900-(Lcom/android/mms/ui/ComposeMessageActivity; J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-startPhotoQuery-(J Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/IConnectivityManager$Stub;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/ThrottleService;-systemReady-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/Controller$SaveSnapshotTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/base/FrameFetch;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IThrottleManager$Stub;-getResetTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/base/NullFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DisplaySettings;-writeFontSizePreference-(Ljava/lang/Object;)V' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onDeviceAdded-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/backup/IRestoreSession$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$AdvancedWifiSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/DhcpStateMachine$DefaultState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/ActivityManagerNative;-killBackgroundProcesses-(Ljava/lang/String;)V' : ['android.permission.RESTART_PACKAGES', 'android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/internal/telephony/ISms$Stub;-copyMessageToIccEf-(I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/policy/impl/LockScreen;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/server/BluetoothService;-setDiscoverableTimeout-(I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setDataRoamingEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/UIControllerOnePane;-switchAccount-(J Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/activity/MessageViewFragmentBase;-performAttachmentSave-(Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;)Ljava/io/File;' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/server/am/ActivityManagerService;-bindBackupAgent-(Landroid/content/pm/ApplicationInfo; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/inputmethod/latin/LatinIME$3;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/list/ContactEntryListFragment;-setQueryString-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth;-readOutOfBandData-()[B' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/BluetoothHandsfree$16;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/contacts/list/DefaultContactListAdapter;-getContactUri-(I Landroid/database/Cursor;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/p2p/WifiP2pService;-enforceAccessPermission-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity$QueryEntitiesTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/providers/media/MediaProvider;-getThumb-(Lcom/android/providers/media/MediaProvider$DatabaseHelper; Landroid/database/sqlite/SQLiteDatabase; Ljava/lang/String; J Landroid/net/Uri;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.READ_EXTERNAL_STORAGE', 'android.permission.WRITE_EXTERNAL_STORAGE'],
	'Landroid/server/BluetoothEventLoop;-onPropertyChanged-([Ljava/lang/String;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CallerInfo;-markAsVoiceMail-()Lcom/android/internal/telephony/CallerInfo;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/calendar/event/EditEventFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/browser/BrowserActivity;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/telephony/TelephonyManager;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/base/GLTextureTarget;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothServerSocket;-<init>-(I Z Z I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/Invert;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth;-setInputDevicePriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CallerInfoAsyncQuery$CallerInfoAsyncQueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/bluetooth/BluetoothEnabler;-<init>-(Landroid/content/Context; Landroid/widget/Switch;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/CallNotifier;-sendMwiChangedDelayed-(J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/accounts/AddAccountSettings;-addAccount-(Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/widget/SlidingTab;-dispatchTriggerEvent-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/base/NullFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/am/ActivityStack;-scheduleIdleLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onResume-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/interactions/ImportExportDialogFragment;-handleImportRequest-(I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/view/VolumePanel;-onShowVolumeChanged-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/sip/SipCommandInterface;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-makeWifiWatchdogStateMachine-(Landroid/content/Context;)Landroid/net/wifi/WifiWatchdogStateMachine;' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-setKeyboardMode-(I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-setVoiceMailNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/Files;-copy-(Lcom/google/common/io/InputSupplier; Ljava/io/File; Ljava/nio/charset/Charset;)V' : ['android.permission.INTERNET'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-generateBinaryDictionary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/launcher2/DragController;-startDrag-(Landroid/graphics/Bitmap; I I Lcom/android/launcher2/DragSource; Ljava/lang/Object; I Landroid/graphics/Point; Landroid/graphics/Rect; F)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/IccProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/StateManager;-switchState-(Lcom/android/gallery3d/app/ActivityState; Ljava/lang/Class; Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/agenda/AgendaListView;-goTo-(Landroid/text/format/Time; J Ljava/lang/String; Z Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-doQuery-(Lcom/android/calendar/agenda/AgendaWindowAdapter$QuerySpec;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/server/BluetoothService;-dumpKnownDevices-(Ljava/io/PrintWriter;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/contacts/ContactsProvider2;-queryLocal-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String; J Landroid/os/CancellationSignal;)Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$2;-userActivity-(Landroid/view/View;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/browser/Controller;-access$100-(Lcom/android/browser/Controller; Landroid/os/Bundle; Landroid/content/Intent; J Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/widget/RotarySelector;-dispatchTriggerEvent-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/NfcAdapter;-setNdefPushMessage-(Landroid/nfc/NdefMessage; Landroid/app/Activity; [Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setPin-(Ljava/lang/String; [B)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$StorageUseActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/transaction/MessagingNotification;-getDownloadFailedMessageCount-(Landroid/content/Context;)I' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-updateCurrentCarrierInProvider-(Ljava/lang/String;)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.SET_TIME_ZONE'],
	'Landroid/media/AudioService;-access$6200-(Landroid/media/AudioService; Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/wallpaper/RenderScriptWallpaper$RenderScriptEngine;-onSurfaceChanged-(Landroid/view/SurfaceHolder; I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-viewContact-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-setTimeout-(I I)I' : ['android.permission.NFC'],
	'Lcom/android/contacts/util/AccountPromptUtils;-launchAccountPrompt-(Landroid/app/Activity;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/providers/downloads/DownloadService;-access$800-(Lcom/android/providers/downloads/DownloadService; J)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/browser/homepages/RequestHandler;-writeTemplatedIndex-()V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DateTimeSettings;-onSharedPreferenceChanged-(Landroid/content/SharedPreferences; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$AndroidBeamSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/IWifiManager$Stub;-enableNetwork-(I Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/google/common/io/CharStreams$2;-getInput-()Ljava/io/InputStreamReader;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/RIL;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/widget/PinnedHeaderListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/server/BluetoothService;-getHealthDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/net/IConnectivityManager;-getTetheredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/ThrottleService$DataRecorder;-addData-(J J)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/ConnectivityManager;-getTetheredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/RingtoneManager;-setActualDefaultRingtoneUri-(Landroid/content/Context; I Landroid/net/Uri;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/nio/charset/Charset; Ljava/lang/Appendable;)V' : ['android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/VideoCamera;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/provider/Settings$Secure;-putLong-(Landroid/content/ContentResolver; Ljava/lang/String; J)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub;-setWifiApEnabled-(Landroid/net/wifi/WifiConfiguration; Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-onCreate-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/webkit/WebView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I Ljava/util/Map; Z)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/MasterClear;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/ConnectivityService;-getTetheredIfacePairs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothAdapter;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback$Stub$Proxy;-sendMessageStatus-(J Ljava/lang/String; I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/ConnectivityManager;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-initDevicePreference-(Lcom/android/settings/bluetooth/BluetoothDevicePreference;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/app/AlarmManager;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-access$800-(Lcom/android/mms/ui/ComposeMessageActivity; Lcom/android/mms/ui/MessageItem;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/development/Connectivity;-access$2100-(Lcom/android/development/Connectivity;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/server/BluetoothA2dpService;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$InputMethodAndLanguageSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/alerts/AlertService;-postNotification-(Lcom/android/calendar/alerts/AlertService$NotificationInfo; Ljava/lang/String; Landroid/content/Context; Z Lcom/android/calendar/alerts/AlertService$NotificationPrefs; Lcom/android/calendar/alerts/NotificationMgr; I)V' : ['android.permission.VIBRATE', 'android.permission.READ_CALENDAR'],
	'Landroid/app/DownloadManager;-addCompletedDownload-(Ljava/lang/String; Ljava/lang/String; Z Ljava/lang/String; Ljava/lang/String; J Z)J' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/server/ConnectivityService;-handleInetConditionHoldEnd-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/systemui/statusbar/policy/ToggleSlider$Listener;-onChanged-(Lcom/android/systemui/statusbar/policy/ToggleSlider; Z Z I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/ui/QuickContactDivot;-assignContactFromEmail-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/Controller$15$1;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-performHapticFeedbackLw-(Landroid/view/WindowManagerPolicy$WindowState; I Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-isValidWord-(Ljava/lang/CharSequence;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/wm/WindowManagerService;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.DISABLE_KEYGUARD', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/server/BluetoothService;-cancelPairingUserInput-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/ContactSaveService$2;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/activities/PeopleActivity;-onResume-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/app/ActivityManagerNative;-getRecentTasks-(I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/contacts/list/OnContactBrowserActionListener;-onFinishAction-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/adapter/Parser;-parse-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/transaction/RetryScheduler;-update-(Lcom/android/mms/transaction/Observable;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_SMS'],
	'Landroid/server/BluetoothService;-disconnectSink-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiManager;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/providers/contacts/VoicemailContentTable;-delete-(Lcom/android/providers/contacts/VoicemailContentProvider$UriData; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/net/wifi/p2p/WifiP2pService;-getMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-access$1800-(Lcom/android/internal/policy/impl/KeyguardViewMediator; I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/inputmethod/keyboard/LatinKeyboardView;-invokeCodeInput-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/AlarmAlertFullScreen;-access$000-(Lcom/android/deskclock/AlarmAlertFullScreen;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/IAccountManager;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/contacts/list/ContactPickerFragment;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/activities/NonPhoneActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/internal/policy/impl/PasswordUnlockScreen$4;-onClick-(Landroid/view/View;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/calendar/CalendarController$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/nfc/tech/NdefFormatable;-reconnect-()V' : ['android.permission.NFC'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-isBusy-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$27;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/mms/data/Conversation$2;-run-()V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/app/ResolverActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/TransactionSafeActivity;-onCreateDialog-(I Landroid/os/Bundle;)Landroid/app/Dialog;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/pm/ShutdownThread;-rebootSafeMode-(Landroid/content/Context; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-handleStatusReport-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/SlideshowView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/AlbumDataLoader;-executeAndWait-(Ljava/util/concurrent/Callable;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-drawTopPanel-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/RuimPhoneBookInterfaceManager;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/AsyncRunner$AsyncRunnerTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-getAuthTokenLabel-(Ljava/lang/String; Ljava/lang/String; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/EventInfoFragment;-access$1900-(Lcom/android/calendar/EventInfoFragment; Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/CommandsInterface;-iccIOForApp-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub$Proxy;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/camera/LocationManager;-recordLocation-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-onScreenTurnedOff-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/app/ActivityManagerNative;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-restoreMuteState-()Ljava/lang/Boolean;' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/nfc/tech/NdefFormatable;-close-()V' : ['android.permission.NFC'],
	'Lcom/android/contacts/group/GroupBrowseListFragment$3;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/preference/VolumePreference;-onSampleStarting-(Landroid/preference/VolumePreference$SeekBarVolumizer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-onMuteClick-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/wifi/WifiApEnabler;-<init>-(Landroid/content/Context; Landroid/preference/CheckBoxPreference;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler;-getPhotoPickSize-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/AccessibilitySettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_CONFIGURATION', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/NotificationMgr;-updateCfi-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-showPhonebookDialog-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/AlbumPage$4;-onLongTap-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/email/activity/setup/AccountSetupExchangeFragment;-saveSettingsAfterEdit-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/VibratorService;-onInputDeviceChanged-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/phone/BluetoothHeadsetService;-onDestroy-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onPollPdp-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/media/AudioManager;-setParameters-(Ljava/lang/String;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/email/activity/MessageFileViewFragment;-access$1900-(Lcom/android/email/activity/MessageViewFragmentBase; Lcom/android/emailcommon/provider/EmailContent$Attachment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/SearchActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/filterpacks/base/RetargetFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/SubSettings;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/sip/ISipService$Stub;-close-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserDictionary;-loadDictionaryAsync-()V' : ['android.permission.READ_USER_DICTIONARY'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/location/ILocationManager$Stub$Proxy;-setTestProviderEnabled-(Ljava/lang/String; Z)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/gallery3d/ui/SelectionManager$SelectionListener;-onSelectionModeChange-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onCreateActionBar-(Landroid/view/Menu;)Z' : ['android.permission.NFC'],
	'Lcom/android/contacts/editor/StructuredNameEditorView;-rebuildStructuredName-(Lcom/android/contacts/model/EntityDelta$ValuesDelta;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/WallpaperManagerService$MyPackageMonitor;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/ConnectivityService;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-dispose-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService$Receiver;-access$700-(Lcom/android/server/LocationManagerService$Receiver;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/PeopleActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/MediaPlaybackActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/ui/SelectionManager;-enterSelectionMode-()V' : ['android.permission.VIBRATE'],
	'Landroid/test/mock/MockContentResolver;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/bluetooth/IBluetooth;-getInputDevicePriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/TileImageView;-render-(Lcom/android/gallery3d/ui/GLCanvas;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/server/BluetoothHealthProfileHandler;-onHealthDevicePropertyChanged-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-requestRouteToHostAddress-(I [B)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/server/BluetoothEventLoop;-checkPairingRequestAndGetAddress-(Ljava/lang/String; I)Ljava/lang/String;' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-powerOffRadioSafely-(Lcom/android/internal/telephony/DataConnectionTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/SingleRunningTask;-run-(Ljava/lang/Object;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-setQueryString-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/AlbumSetDataLoader$ReloadTask;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/ContactBrowseListFragment$ContactLookupTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-onClose-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/FdnSetting;-updatePINChangeState-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-getAuthToken-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Z Landroid/os/Bundle;)V' : ['android.permission.USE_CREDENTIALS'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-setQueuePosition-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/RadioInfo;-access$4000-(Lcom/android/settings/RadioInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-sendUSSD-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/UsageStatsService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onDownEvent-(I I J Lcom/android/inputmethod/keyboard/PointerTracker$KeyEventHandler;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Lcom/android/contacts/group/GroupEditorFragment$3;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/emailcommon/utility/EmailAsyncTask$1;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/SIMRecords;-handleFileUpdate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-changeIccPin2ForApp-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService;-setUsbTethering-(Z)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/IThrottleManager$Stub$Proxy;-getResetTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/widget/VideoView;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/TransactionService;-update-(Lcom/android/mms/transaction/Observable;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_SMS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$1;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/server/BluetoothService;-getDeviceServiceChannelForUuid-(Ljava/lang/String; Landroid/os/ParcelUuid;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/net/ConnectivityManager;-setGlobalProxy-(Landroid/net/ProxyProperties;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/BackupManagerService$BackupRestoreTask;-execute-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mms/data/WorkingMessage;-createDraftMmsMessage-(Lcom/google/android/mms/pdu/PduPersister; Lcom/google/android/mms/pdu/SendReq; Lcom/android/mms/model/SlideshowModel; Landroid/net/Uri;)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/view/IWindowManager;-clearForcedDisplaySize-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/wifi/AdvancedWifiSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/location/ComprehensiveCountryDetector$2;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/MasterClear;-establishInitialState-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/PhoneUtils;-answerAndEndHolding-(Lcom/android/internal/telephony/CallManager; Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/pm/PackageManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CLEAR_APP_CACHE', 'android.permission.READ_EXTERNAL_STORAGE', 'android.permission.WRITE_SETTINGS', 'android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/settings/bluetooth/BluetoothPairingDialog;-createView-(Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;)Landroid/view/View;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/RotarySelector;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/server/BluetoothService;-attemptAutoPair-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/DragState;-endDragLw-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/RotateFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioManager;-isBluetoothA2dpOn-()Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/filterpacks/text/StringLogger;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView;-maybeEnableFallback-(Landroid/content/Context;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/Settings;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/videosrc/MediaSource;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/common/contacts/DataUsageStatUpdater;-updateWithRfc822Address-(Ljava/util/Collection;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/latin/spellcheck/AndroidSpellCheckerService;-startUsingContactsDictionaryLocked-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendP2pDiscoveryChangedBroadcast-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/NavigationBarPhone;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/vcard/VCardParserImpl_V21;-handleNest-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-getReportItems-()Ljava/util/List;' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/CdmaSystemSelectListPreference$MyHandler;-handleQueryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/WebViewController;-doUpdateVisitedHistory-(Lcom/android/browser/Tab; Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-setMute-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/camera/VideoCamera;-createCameraScreenNail-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-getCellLocation-()Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/ContactsListActivity;-getSelectedUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/event/EditEventView$DateListener;-onDateSet-(Landroid/widget/DatePicker; I I I)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onShowMoreKeysPanel-(I I Lcom/android/inputmethod/keyboard/PointerTracker$KeyEventHandler;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/PhoneBase;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/DhcpStateMachine$RunningState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/deskclock/Alarms;-addAlarm-(Landroid/content/Context; Lcom/android/deskclock/Alarm;)J' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-hangupConnectionByIndex-(Lcom/android/internal/telephony/cdma/CdmaCall; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/net/wifi/SupplicantStateTracker$InactiveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.INTERNET', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/tech/MifareClassic;-authenticate-(I [B Z)Z' : ['android.permission.NFC'],
	'Lcom/android/settings/WallpaperTypeSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardView;-openPopupIfRequired-(Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$PlaybackPositionListener;-onStartTrackingTouch-(Landroid/widget/SeekBar;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DataUsageSummary$ConfirmDataRoamingFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/activity/MessageCompose$QuickResponseChecker;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/CalendarViewAdapter;-<init>-(Landroid/content/Context; I Z)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/IBluetooth;-connectPanDevice-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/server/BluetoothService;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider;-buildUpdate-(Landroid/content/Context;)Landroid/widget/RemoteViews;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$InputMethodAndSubtypeEnablerActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/support/v4/net/ConnectivityManagerCompat$HoneycombMR2ConnectivityManagerCompatImpl;-isActiveNetworkMetered-(Landroid/net/ConnectivityManager;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/LocationManagerService$SettingsObserver;-update-(Ljava/util/Observable; Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-configureQuickFix-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$AccountAnalyzer;-<init>-(Lcom/android/internal/policy/impl/LockPatternKeyguardView; Landroid/accounts/AccountManager;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/ActivityManagerService;-setProcessLimit-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/MediaPlayer;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/SimContacts;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/accounts/SyncSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/EditPinPreference$OnPinEnteredListener;-onPinEntered-(Lcom/android/settings/EditPinPreference; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter$QueryHandler$1;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/Settings$AdvancedWifiSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-enableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/settings/Settings$CryptKeeperSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/vpn2/VpnSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/location/ILocationManager$Stub$Proxy;-getLastKnownLocation-(Ljava/lang/String; Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/usb/UsbSettingsManager$MyPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/os/storage/IMountService$Stub;-getStorageUsers-(Ljava/lang/String;)[I' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/exchange/ExchangeService$ConnectivityReceiver$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$StorageSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/BluetoothHandsfree;-onBluetoothDisabled-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-enqueue-([J I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneFactory;-makeDefaultPhones-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/phone/BluetoothHandsfree$18;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothAtPhonebook;-access$900-(Lcom/android/phone/BluetoothAtPhonebook;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/MmsMessageSender;-sendMessage-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/ui/PhotoView$FullPicture;-drawTileView-(Lcom/android/gallery3d/ui/GLCanvas; Landroid/graphics/Rect;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/BluetoothHandsfree$15;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/PhoneNumberListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$UpdateContent;-call-()Ljava/lang/Void;' : ['android.permission.VIBRATE'],
	'Lcom/android/nfc/handover/HandoverManager$HandoverPowerManager;-enableBluetooth-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/os/storage/IMountService;-unmountVolume-(Ljava/lang/String; Z Z)V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/server/input/InputManagerService;-registerShowTouchesSettingObserver-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/LocationSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/calllog/CallLogAdapter$1;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsBinaryDictionary;-loadDictionaryAsync-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/selectcalendars/SelectCalendarsSyncFragment;-onPause-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/group/GroupEditorFragment;-getAccountType-()Lcom/android/contacts/model/AccountType;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/RingerVolumePreference;-onBindDialogView-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/server/BluetoothBondState;-loadBondState-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setVoiceMailNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/AddBookmarkPage$SaveBookmarkRunnable;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/transaction/NotificationTransaction;-<init>-(Landroid/content/Context; I Lcom/android/mms/transaction/TransactionSettings; Lcom/google/android/mms/pdu/NotificationInd;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/contacts/model/EntityDeltaList;-beginKeepTogether-()Landroid/content/ContentProviderOperation$Builder;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/BatteryService;-<init>-(Landroid/content/Context; Lcom/android/server/LightsService;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$ScanningStateChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/AccountManager$6;-doWork-()V' : ['android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/bluetooth/BluetoothDevicePreference;-<init>-(Landroid/content/Context; Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/TrafficStats;-stopDataProfiling-(Landroid/content/Context;)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/emailcommon/service/IPolicyService$Stub;-setAccountPolicy-(J Lcom/android/emailcommon/provider/Policy; Ljava/lang/String;)V' : ['android.permission.VIBRATE'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-createSession-(Landroid/net/sip/SipProfile; Landroid/net/sip/ISipSessionListener;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/settings/tts/TtsEngineSettingsFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth;-getRemoteServiceChannel-(Ljava/lang/String; Landroid/os/ParcelUuid;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/util/AccountsListAdapter;-<init>-(Landroid/content/Context; Lcom/android/contacts/util/AccountsListAdapter$AccountListFilter; Lcom/android/contacts/model/AccountWithDataSet;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth$Stub;-getInputDevicePriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/SlideshowPage;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/PhoneProxy;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneInterfaceManager;-isSimPinEnabled-()Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/media/IAudioService;-setSpeakerphoneOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-switchToState-(I F F)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.USE_CREDENTIALS', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/detail/ContactDetailUpdatesFragment;-access$000-(Lcom/android/contacts/detail/ContactDetailUpdatesFragment; Lcom/android/contacts/util/StreamItemEntry;)Lcom/android/contacts/model/AccountType;' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/ui/CropView$FaceHighlightView;-renderChild-(Lcom/android/gallery3d/ui/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onVoiceCallStarted-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiStateMachine;-setWifiState-(I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AudioService;-readPersistedSettings-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/tablet/SettingsView;-onClick-(Landroid/view/View;)V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/phone/BluetoothHandsfree$25;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/vcard/VCardParser_V30;-parse-(Ljava/io/InputStream;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/latin/UserDictionary;-blockingReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/NotificationMgr$QueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/ContactsUtils;-areGroupWritableAccountsAvailable-(Landroid/content/Context;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppObexServerSession;-onPut-(Ljavax/obex/Operation;)I' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/SmsManager;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/LocationManagerService;-loadBlacklist-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-getVoiceRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/AlarmAlertFullScreen;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-enableKeyguard-(Z)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/net/wifi/IWifiManager$Stub;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/base/NullFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/screenshot/SaveImageInBackgroundTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/BluetoothHandsfree$5;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-handleCallWaitingInfo-(Lcom/android/internal/telephony/cdma/CdmaCallWaitingNotification;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothPanProfileHandler;-setBluetoothTethering-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/videosrc/CameraSource;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcAdapterExtras$Stub;-authenticate-(Ljava/lang/String; [B)V' : ['android.permission.NFC'],
	'Lcom/android/gallery3d/app/AlbumDataLoader$ReloadTask;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/Utils;-getWeekNumberFromTime-(J Landroid/content/Context;)I' : ['android.permission.READ_CALENDAR'],
	'Landroid/app/ContextImpl;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/StateManager;-itemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/commands/bmgr/Bmgr;-doList-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/vpn2/VpnSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-createContact-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/model/EntityDeltaList;-indexOfFirstWritableRawContact-(Landroid/content/Context;)I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/pm/PackageManagerService;-replacePackageLI-(Landroid/content/pm/PackageParser$Package; I I Ljava/lang/String; Lcom/android/server/pm/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mms/data/WorkingMessage;-load-(Lcom/android/mms/ui/ComposeMessageActivity; Landroid/net/Uri;)Lcom/android/mms/data/WorkingMessage;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityManagerService;-killPackageProcessesLocked-(Ljava/lang/String; I I Z Z Z Z Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/email/GroupMessagingListener;-synchronizeMailboxFailed-(J J Ljava/lang/Exception;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/location/LocationManager;-removeTestProvider-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/content/ContentService;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Ljava/net/HttpURLConnection;-connect-()V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-notifyServiceState-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/data/WorkingMessage$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/wifi/p2p/WifiP2pSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/exchange/EasOutboxService;-acknowledgeRemoteWipe-(Lcom/android/exchange/EasSyncService; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/text/ToUpperCase;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/list/ContactListFilterController;-selectCustomFilter-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/MailboxFinder$FindMailboxTask;-callOnCancelledForTest-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$SpellCheckersSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppNotification;-updateCompletedNotification-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/BackupManagerService;-clearBackupData-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/calllog/CallLogFragment;-updateOnTransition-(Z)V' : ['android.permission.WRITE_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/calendar/month/MonthByWeekAdapter;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/calendar/AllInOneActivity;-onUserLeaveHint-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/net/sip/ISipService$Stub;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/server/sip/SipService$IntervalMeasurementProcess;-onResponse-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/IPolicyService;-setAccountPolicy-(J Lcom/android/emailcommon/provider/Policy; Ljava/lang/String;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/DevicePolicyManagerService;-saveGlobalProxyLocked-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/Controller$10;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/launcher2/WallpaperChooserDialogFragment$1;-onClick-(Landroid/view/View;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/settings/CryptKeeper$ValidationTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/A2dpProfile;-getConnectionStatus-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/deviceinfo/Status;-setWifiStatus-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/wifi/AdvancedWifiSettings;-initPreferences-()V' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/activities/TransactionSafeActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/phone/BluetoothHandsfree;-access$6100-(Lcom/android/phone/BluetoothHandsfree;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-disableSingleLocationUpdate-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-getBondState-(Ljava/lang/String;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/BatteryService;-processValues-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothAdapter;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-handleModeChange-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/phone/BluetoothHandsfree$22;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/AttachPhotoActivity;-access$000-(Lcom/android/contacts/activities/AttachPhotoActivity; Lcom/android/contacts/ContactLoader$Result;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/location/LocationBasedCountryDetector;-getEnabledProviders-()Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/InCallScreen;-updateInCallTouchUi-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/DateTimeSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/performance/ThroughputFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/app/IBatteryStats$Stub$Proxy;-getStatistics-()[B' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Landroid/webkit/GeolocationService;-registerForLocationUpdates-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/providers/contacts/VoicemailContentProvider;-checkAndAddSourcePackageIntoValues-(Lcom/android/providers/contacts/VoicemailContentProvider$UriData; Landroid/content/ContentValues;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/phone/InCallScreen;-access$1100-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/AccountManager$2;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/location/ILocationManager$Stub$Proxy;-addTestProvider-(Ljava/lang/String; Z Z Z Z Z Z Z I I)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-checkSelection-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin2ForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/sip/SipSessionGroup;-processIOException-(Ljavax/sip/IOExceptionEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/ContactEditorFragment$EntityDeltaComparator;-compare-(Lcom/android/contacts/model/EntityDelta; Lcom/android/contacts/model/EntityDelta;)I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/server/BluetoothService;-onHealthDevicePropertyChanged-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/systemui/recent/RecentsPanelView;-handleOnClick-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine;-access$11300-(Landroid/net/wifi/WifiStateMachine; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-turnOffUpstreamMobileConnection-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-isSyncActive-()Z' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/IConnectivityManager$Stub;-setGlobalProxy-(Landroid/net/ProxyProperties;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setPropertiesByCarrier-()V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/contacts/list/ContactEntryListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/activities/NonPhoneActivity;-onStart-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/content/SyncManager;-cancelActiveSync-(Landroid/accounts/Account; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$4;-onChange-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$IncomingHid;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-enableNdefPush-()Z' : ['android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothA2dp;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/net/UidDetailProvider;-buildUidDetail-(I)Lcom/android/settings/net/UidDetail;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/provider/DBHelper;-upgradeFromVersion21ToVersion22-(Landroid/database/sqlite/SQLiteDatabase; Landroid/content/Context;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-setQueryString-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/ui/TileImageView;-renderChild-(Lcom/android/gallery3d/ui/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestionProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-checkSelection-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/server/BluetoothService;-removeBond-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-trySetupData-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/ActivityState;-onItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth$Stub;-setPasskey-(Ljava/lang/String; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackFragment;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/settings/accounts/ManageAccountsSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/IAlarmManager;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-isSimPinEnabled-()Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupExchangeFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$2;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$ScreenNailJob;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-getBigrams-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/latin/Dictionary$WordCallback;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/text/StringLogger;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/base/InputStreamSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/OutgoingCallBroadcaster$OutgoingCallReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneBase;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/InCallScreen;-onBackPressed-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/PhoneUtils;-turnOnSpeaker-(Landroid/content/Context; Z Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityManagerService;-ensureBootCompleted-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/phone/OtaUtils;-onClickOtaActivateNextButton-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/DeliveryReportActivity;-getMmsReportRequests-()Ljava/util/List;' : ['android.permission.READ_SMS'],
	'Landroid/content/IContentService$Stub$Proxy;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/exchange/ExchangeService$2;-stopSync-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/ExchangeService;-isMailboxSyncable-(Lcom/android/emailcommon/provider/Account; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/calllog/CallLogListItemHelper;-getCallActionDescription-(Lcom/android/contacts/PhoneCallDetails;)Ljava/lang/CharSequence;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/email/activity/MessageViewFragmentBase;-onResume-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter$DayAdapterInfo;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/providers/contacts/GlobalSearchSupport;-addSearchSuggestionsBasedOnFilter-(Landroid/database/MatrixCursor; Landroid/database/sqlite/SQLiteDatabase; [Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/OtaUtils;-otaShowActivateScreen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/MessagingNotification;-notifyFailed-(Landroid/content/Context; Z J Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_SMS'],
	'Lcom/android/settings/DataUsageSummary$ConfirmAutoSyncChangeFragment$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/mms/data/WorkingMessage;-access$300-(Lcom/android/mms/data/WorkingMessage; Landroid/net/Uri;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/ManageConferenceUtils;-separateConferenceConnection-(I Lcom/android/internal/telephony/Connection;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-getGroupUriFromId-(J)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/deviceinfo/Memory;-unmount-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-dispatchNormalMessage-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/ConnectivityService;-getTetheringErroredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/inputmethod/SpellCheckersSettings;-onPause-()V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/deskclock/Alarms;-disableAlert-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/GrainFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/vcard/NotificationImportExportListener;-onImportCanceled-(Lcom/android/contacts/vcard/ImportRequest; I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-handleCancel-(Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/Settings$DataUsageSummaryActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/util/NameConverter;-displayNameToStructuredName-(Landroid/content/Context; Ljava/lang/String;)Ljava/util/Map;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendP2pStateChangedBroadcast-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/EmergencyCallHelper;-onServiceStateChanged-(Landroid/os/Message;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/ui/EffectSettingPopup;-onClick-(Landroid/view/View;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/SyncManager;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/BrowserWebView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.INTERNET'],
	'Lcom/android/phone/InCallScreen;-endInCallScreenSession-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-getBigrams-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/latin/Dictionary$WordCallback;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/datepicker/DatePickerDialog$OnDateSetListener;-onDateSet-(Lcom/android/contacts/datepicker/DatePicker; I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-createPbapNotification-(Ljava/lang/String;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/RIL;-getLastPdpFailCause-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/FlipEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/calllog/DefaultVoicemailNotifier;-updateNotification-(Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/Phone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller;-onSaveInstanceState-(Landroid/os/Bundle;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/content/SyncManager;-scheduleLocalSync-(Landroid/accounts/Account; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-createIntent-(Landroid/content/Context; J)Landroid/content/Intent;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/ui/PhotoView;-renderChild-(Lcom/android/gallery3d/ui/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/Settings$SecuritySettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/Settings$PowerUsageSummaryActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/CountryDetectorService$2;-run-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/transaction/MessagingNotification;-access$300-(Landroid/content/Context; [J)I' : ['android.permission.READ_SMS'],
	'Lcom/android/gallery3d/app/SlideshowPage;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-getAllMessagesFromIccEf-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/quicksearchbox/util/HttpHelper;-post-(Ljava/lang/String; Ljava/util/Map; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/calendar/DayView;-access$5100-(Lcom/android/calendar/DayView; Landroid/view/MotionEvent;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/util/StateMachine$SmHandler;-invokeExitMethods-(Lcom/android/internal/util/StateMachine$SmHandler$StateInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/provider/Contacts$People;-addToGroup-(Landroid/content/ContentResolver; J Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/text/ToUpperCase;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$ManageAccountsSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/Utils$UsabilityStudyLogUtils$2;-run-()V' : ['android.permission.WRITE_EXTERNAL_STORAGE'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-<init>-(J)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/settings/inputmethod/InputMethodPreference;-setChecked-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/UserDictionary$Words;-addWord-(Landroid/content/Context; Ljava/lang/String; I Ljava/lang/String; Ljava/util/Locale;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/calendar/DayFragment;-goTo-(Landroid/text/format/Time; Z Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/mms/transaction/TransactionService;-renewMmsConnectivity-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_SMS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/phone/BluetoothHandsfree;-redial-()Landroid/bluetooth/AtCommandResult;' : ['com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/SlideshowPresenter$5;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-loadDictionaryAsync-()V' : ['android.permission.READ_USER_DICTIONARY'],
	'Landroid/net/wifi/WifiStateMachine$SupplicantStartingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/AlbumPicker;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.CAMERA', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.RECORD_AUDIO', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.NFC'],
	'Landroid/net/IConnectivityManager;-getTetherableWifiRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/list/ContactEntryListFragment;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$BluetoothStateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-selectDefaultContact-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState$SwitchActions;-startLongPressTimer-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Lcom/android/mms/ui/RecipientsAdapter;-runQueryOnBackgroundThread-(Ljava/lang/CharSequence;)Landroid/database/Cursor;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-setGrabbedState-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.USE_CREDENTIALS', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/data/WorkingMessage;-updateDraftSmsMessage-(Lcom/android/mms/data/Conversation; Ljava/lang/String;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetooth$Stub;-getConnectedPanDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/location/LocationBasedCountryDetector;-getLastKnownLocation-()Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/bluetooth/PanProfile;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/ActionBarController$3;-onLoaderReset-(Landroid/content/Loader;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/ISms;-updateMessageOnIccEf-(I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/browser/Tab$2;-onReceivedLoginRequest-(Landroid/webkit/WebView; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/media/effect/effects/BlackWhiteEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifySignalStrength-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-disableDataConnectivity-()Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/CrossProcessFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-initBluetoothAfterTurningOn-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartingState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothHeadset;-isAudioConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView;-dispatchHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/sip/SipEditor$2;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/DownloadThread;-executeDownload-(Lcom/android/providers/downloads/DownloadThread$State; Landroid/net/http/AndroidHttpClient; Lorg/apache/http/client/methods/HttpGet;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothPan;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/IMediaPlaybackService;-prev-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/alerts/AlertUtils;-formatTimeLocation-(Landroid/content/Context; J Z Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/LocationManagerService;-loadProviders-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/util/DownloadManager$4;-run-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/systemui/recent/RecentsVerticalScrollView;-onChildDismissed-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/CdmaSubscriptionListPreference$CdmaSubscriptionButtonHandler;-handleSetCdmaSubscriptionMode-(Landroid/os/Message;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/content/CursorEntityIterator;-getEntityAndIncrementCursor-(Landroid/database/Cursor;)Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$InitialState;-chooseUpstreamType-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendCallLogVcards-(I Ljavax/obex/Operation; I I Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/net/wifi/SupplicantStateTracker$DefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothA2dpService;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/deviceinfo/Status;-onResume-()V' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAccountsByType-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/dialpad/DialpadFragment;-setFormattedDigits-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/camera/Camera;-onThumbnailClicked-(Landroid/view/View;)V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Landroid/provider/BrowserContract$Bookmarks;-buildFolderUri-(J)Landroid/net/Uri;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/Settings$AccessibilitySettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/CellBroadcastSms;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-doJoinSuggestedContact-([J)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/ui/PhotoView$Picture;-draw-(Lcom/android/gallery3d/ui/GLCanvas; Landroid/graphics/Rect;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/accounts/ManageAccountsSettings;-onStart-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/AudioPreview;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneInterfaceManager$UnlockSim;-unlockSim-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-disconnectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/BluetoothHandsfree$24;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/mms/transaction/SimFullReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Landroid/app/ActivityManager;-getRecentTasks-(I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Landroid/content/ISyncContext$Stub$Proxy;-onFinished-(Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS'],
	'Landroid/net/sip/ISipService$Stub;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/settings/users/UserSettings;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth;-getInputDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/speech/IRecognitionService$Stub;-cancel-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsDictionary;-loadDictionaryAsync-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/list/ContactEntryListFragment;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/UIControllerTwoPane;-onInstallFragment-(Landroid/app/Fragment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/EmergencyCallHelper;-scheduleRetryOrBailOut-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothHandsfree$5;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-onUserSwitched-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/am/ActivityManagerService;-requestServiceBindingsLocked-(Lcom/android/server/am/ServiceRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/content/ContentService;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransfer;-startObexSession-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallback;-onResponse-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-<init>-(Landroid/content/Context; Lcom/android/server/PowerManagerService; Z Z Z Lcom/android/server/wm/WindowManagerService$1;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.WAKE_LOCK', 'android.permission.USE_CREDENTIALS', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$3;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Exception;' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videoproc/BackDropperFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/DefaultContactListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/providers/downloads/DownloadThread;-handleEndOfStream-(Lcom/android/providers/downloads/DownloadThread$State; Lcom/android/providers/downloads/DownloadThread$InnerState;)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/CalendarController;-sendEvent-(Ljava/lang/Object; J Landroid/text/format/Time; Landroid/text/format/Time; J I J Ljava/lang/String; Landroid/content/ComponentName;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/nfc/INfcAdapterExtras$Stub;-open-(Ljava/lang/String; Landroid/os/IBinder;)Landroid/os/Bundle;' : ['android.permission.NFC'],
	'Lcom/android/contacts/vcard/NotificationImportExportListener;-onImportProcessed-(Lcom/android/contacts/vcard/ImportRequest; I I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$2;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Exception;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CallNotifier;-access$000-(Lcom/android/phone/CallNotifier; Z)V' : ['android.permission.VIBRATE'],
	'Landroid/accounts/AccountManagerService;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/contacts/dialpad/DialpadFragment;-onKey-(Landroid/view/View; I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/exchange/adapter/EmailSyncAdapter;-getSyncKey-()Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/ExchangeService;-access$900-(Lcom/android/exchange/ExchangeService; J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/widget/PinnedHeaderListDemoActivity$TestPinnedHeaderListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/ExchangeService;-requestSync-(Lcom/android/emailcommon/provider/Mailbox; I Lcom/android/exchange/Request;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-drawTopPanel-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/videosrc/SurfaceTextureTarget;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/utility/EmailAsyncTask$InnerTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/LocationManagerService;-removeTestProvider-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/telephony/IccRecords;-setMsisdnNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IActivityManager;-goingToSleep-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter;-<init>-(Lcom/android/exchange/EasSyncService;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; Lcom/android/internal/telephony/UUSInfo;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifySignalStrength-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/MessageItem;-interpretFrom-(Lcom/google/android/mms/pdu/EncodedStringValue; Landroid/net/Uri;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/calendar/month/MonthByWeekAdapter$2;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/calendar/Utils;-formatMonthYear-(Landroid/content/Context; Landroid/text/format/Time;)Ljava/lang/String;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-setPin-(Ljava/lang/String; [B)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/WifiService;-enforceChangePermission-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/browser/TabControl;-restoreState-(Landroid/os/Bundle; J Z Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-loadDictionary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/providers/settings/SettingsBackupAgent;-restoreSettings-(Landroid/app/backup/BackupDataInput; Landroid/net/Uri;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/inputmethod/KeyboardLayoutPickerFragment;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-buildQueryUri-(I I Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Ljava/net/URLConnection;-getInputStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/contacts/CallDetailActivity;-getPhoneCallDetailsForUri-(Landroid/net/Uri;)Lcom/android/contacts/PhoneCallDetails;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/music/MediaPlaybackService;-open-([J I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/LocationSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/vcard/ImportVCardActivity;-onStart-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/activities/AttachPhotoActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/settings/quicklaunch/QuickLaunchSettings;-clearShortcut-(C)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$InactiveState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$AccountSyncSettingsInAddAccountActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/PhotoView;-switchToFirstImage-()V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/commands/monkey/Monkey;-runMonkeyCycles-()I' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/content/ContextWrapper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wm/WindowManagerService$1;-acquired-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/phone/BluetoothHandsfree$ScoSocketConnectThread;-connectSco-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/CalendarViewAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/IBluetooth;-setTrust-(Ljava/lang/String; Z)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/AsyncPlayer;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/IConnectivityManager$Stub;-getActiveLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/base/FrameFetch;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar$7;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/ContactSaveService;-updateGroup-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/WifiService;-getPersistedWifiState-()I' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/IBackupAgent$Stub;-doFullBackup-(Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mms/data/ContactList;-blockingGetByUris-([Landroid/os/Parcelable;)Lcom/android/mms/data/ContactList;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/DockObserver;-systemReady-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-reconnect-(I)I' : ['android.permission.NFC'],
	'Lcom/android/gallery3d/data/LocationClustering;-generateName-(Ljava/util/ArrayList; Lcom/android/gallery3d/util/ReverseGeocoder;)Ljava/lang/String;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/TetherSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/os/IVibratorService$Stub;-vibratePattern-([J I Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker$ApnChangeObserver;-onChange-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipSessionGroup$SipSessionImpl$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-addAccountExplicitly-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/location/ILocationManager;-getProviderInfo-(Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/VideoCamera$3;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/bluetooth/DeviceListPreferenceFragment;-addPreferencesForActivity-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/DataConnection$DcInactiveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/tech/NfcV;-reconnect-()V' : ['android.permission.NFC'],
	'Lcom/android/contacts/activities/ActionBarAdapter;-update-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onDataSetupComplete-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/XLargeUi;-onBackKey-()Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/util/DraftCache;-rebuildCache-()V' : ['android.permission.READ_SMS'],
	'Lcom/android/server/pm/ShutdownThread;-access$000-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK', 'android.permission.MOUNT_UNMOUNT_FILESYSTEMS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.VIBRATE'],
	'Lcom/android/gallery3d/app/PhotoPage;-setCurrentPhotoByIntent-(Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Landroid/bluetooth/AtCommandHandler;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/service/PolicyService$1;-setAccountPolicy-(J Lcom/android/emailcommon/provider/Policy; Ljava/lang/String;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/phone/PhoneUtils;-setMuteInternal-(Lcom/android/internal/telephony/Phone; Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onRadioAvailable-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/performance/ThroughputFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfile;-setPreferred-(Landroid/bluetooth/BluetoothDevice; Z)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/nfc/P2pLinkManager;-prepareMessageToSend-()V' : ['android.permission.GET_TASKS'],
	'Landroid/net/IConnectivityManager;-getActiveLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothHeadset;-getBatteryUsageHint-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-setQueryString-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/telephony/TelephonyManager;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/ITelephony$Stub$Proxy;-enableDataConnectivity-()Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/net/IThrottleManager;-getCliffThreshold-(Ljava/lang/String; I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/provider/Contacts$People;-addToMyContactsGroup-(Landroid/content/ContentResolver; J)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/DockObserver;-onUEvent-(Landroid/os/UEventObserver$UEvent;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/vpndialogs/ManageDialog;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/launcher2/Workspace;-setup-(Lcom/android/launcher2/DragController;)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-updateServiceLocation-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-getTrustState-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-isA2dpPlaying-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothHandsfree;-startVoiceRecognition-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/screenshot/SaveImageInBackgroundTask;-<init>-(Landroid/content/Context; Lcom/android/systemui/screenshot/SaveImageInBackgroundData; Landroid/app/NotificationManager; I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/pm/PackageManagerService;-killApplication-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-handleShow-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/email/activity/setup/AccountSetupExchange;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/view/IWindowSession$Stub;-addWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/server/TextServicesManagerService$TextServicesMonitor;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/PickerActivity;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.CAMERA', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.RECORD_AUDIO', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.NFC'],
	'Lcom/android/browser/BrowserActivity;-onSaveInstanceState-(Landroid/os/Bundle;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/phone/BluetoothHandsfree$SignalScoCloseThread;-run-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/PhoneInterfaceManager;-enforceCallPermission-()V' : ['android.permission.CALL_PHONE'],
	'Lcom/android/phone/CallNotifier;-showIncomingCall-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/EmergencyCallHelper;-onDisconnect-(Landroid/os/Message;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$InputMethodAndLanguageSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/AddBookmarkPage;-setupTopCrumb-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAuthTokenLabel-(Ljava/lang/String; Ljava/lang/String; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/ConnectivityService;-enforcePreference-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth;-getRemoteUuids-(Ljava/lang/String;)[Landroid/os/ParcelUuid;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/wifi/AdvancedWifiSettings;-refreshWifiInfo-()V' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/DockService;-access$200-(Lcom/android/settings/bluetooth/DockService; Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager;-setBluetoothStateOn-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/SupplicantStateTracker$HandshakeState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/editor/AggregationSuggestionEngine;-buildAggregationSuggestionUri-(Lcom/android/contacts/model/EntityDelta$ValuesDelta;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$OutgoingHandsfree;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/PeopleActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/Settings$KeyboardLayoutPickerActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/util/IState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/adapter/AbstractSyncAdapter;-parse-(Ljava/io/InputStream;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/ConnectivityService;-handleConnect-(Landroid/net/NetworkInfo;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/EmailSyncAdapter$EasEmailSyncParser;-parse-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/KeyguardViewManager;-onScreenTurnedOn-(Lcom/android/internal/policy/impl/KeyguardViewManager$ShowListener;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/input/InputManagerService;-notifyLidSwitchChanged-(J Z)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/filterpacks/videosrc/SurfaceTextureSource;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-access$100-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/settings/vpn2/VpnSettings;-getDefaultNetwork-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/HTML5VideoViewProxy$VideoPlayer;-pauseAndDispatch-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$SoundSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/media/effect/effects/GrainEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/IConnectivityManager;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-registerForSettingsChanges-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/provider/ContactsContract$ProfileSyncState;-get-(Landroid/content/ContentProviderClient; Landroid/accounts/Account;)[B' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/nfc/handover/HandoverManager$HandoverTransfer;-updateNotification-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView$2;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.USE_CREDENTIALS', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-setNetworkPreference-(I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/ActionBarController;-updateTitle-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-asyncReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/activity/UIControllerOnePane;-onRefresh-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/CertBlacklister;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/MediaPlayer;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableWifiRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/effect/effects/VignetteEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-notifyApnIdUpToCurrent-(Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/TabControl;-setCurrentTab-(Lcom/android/browser/Tab;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/wifi/WifiManager;-getWifiState-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/activity/MessageCompose$QuickResponseChecker;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$IncomingHandsfree;-enter-()V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/widget/VideoView;-stopPlayback-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/PhoneUi;-setUseQuickControls-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/view/IApplicationToken$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/content/ContentResolver;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/phone/PhoneUtils;-restoreNoiseSuppression-(Landroid/content/Context;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-setSelectedContactUri-(Landroid/net/Uri; Z Z Z Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/PhoneBase;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/tts/TextToSpeechSettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/data/MtpDeviceSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/AudioService$AudioHandler$2;-onError-(Landroid/media/MediaPlayer; I I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$3;-onPostExecute-(Ljava/lang/Exception;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AllInOneActivity;-eventsChanged-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/nfc/NfcAdapter;-disableForegroundDispatch-(Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-explicitCallTransfer-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-createBond-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/tech/IsoDep;-close-()V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/RIL;-writeSmsToSim-(I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$DefaultState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/deviceinfo/UsbSettings;-onPause-()V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/SMSDispatcher;-dispatchPortAddressedPdus-([[B I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth;-connectHeadset-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/ManageCachePage$1;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/common/widget/GroupingListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/BluetoothAdapter;-listenUsingRfcommWithServiceRecord-(Ljava/lang/String; Ljava/util/UUID;)Landroid/bluetooth/BluetoothServerSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;-<init>-(Landroid/content/Context; Lcom/android/emailcommon/provider/EmailContent$Attachment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-updateMonthHighlight-(Landroid/widget/AbsListView;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/emailcommon/service/IEmailService;-sendMeetingResponse-(J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/ui/GestureRecognizer$MyDownUpListener;-onDown-(Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnablingActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/IAudioService;-dispatchMediaKeyEvent-(Landroid/view/KeyEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-cancelPendingUssd-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/media/MediaScannerService;-access$100-(Lcom/android/providers/media/MediaScannerService; Ljava/lang/String; Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/ExchangeService;-acquireWakeLock-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-isValidWord-(Ljava/lang/CharSequence;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$1;-onSomePackagesChanged-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/KeyboardView;-dispatchHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Lcom/android/nfc/NfcService$TagService;-getTimeout-(I)I' : ['android.permission.NFC'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/SpecialCharSequenceMgr;-showIMEIPanel-(Landroid/content/Context; Z Landroid/telephony/TelephonyManager;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/activities/PeopleActivity;-setQueryTextToFragment-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-setPowerStateToDesired-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar$1;-run-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-addBluetoothUsage-(J)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/input/InputManagerService;-dispatchUnhandledKey-(Lcom/android/server/input/InputWindowHandle; Landroid/view/KeyEvent; I)Landroid/view/KeyEvent;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.CALL_PHONE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/sip/SipWakeLock;-release-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree$10;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/emailcommon/service/IEmailService$Stub$Proxy;-updateFolderList-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneBase;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/server/BluetoothEventLoop;-onDiscoverServicesResult-(Ljava/lang/String; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/AlarmInitReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FlipFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/OutputStreamTarget;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/SplitAggregateView;-<init>-(Landroid/content/Context; Landroid/net/Uri;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-updateProgressbar-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/HTML5VideoViewProxy$VideoPlayer;-setBaseLayer-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/content/PackageMonitor;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/InputMethodManagerService;-updateFromSettingsLocked-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/CommandsInterface;-setGsmBroadcastConfig-([Lcom/android/internal/telephony/gsm/SmsBroadcastConfigInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/UIControllerBase;-onRefresh-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onProgressComplete-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/DevelopmentSettings;-writeImmediatelyDestroyActivitiesOptions-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/SupplicantStateTracker$DisconnectedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.INTERNET', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/WindowManagerService;-removeWindowInnerLocked-(Lcom/android/server/wm/Session; Lcom/android/server/wm/WindowState;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/ContactEditorFragment$2;-onRequest-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/Phone;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/RequestPermissionHelperActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/bluetooth/A2dpProfile;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/DTMFTwelveKeyDialer;-onDialerClose-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/server/BluetoothA2dpService;-onBluetoothEnable-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/contacts/list/ContactEntryListAdapter;-bindQuickContact-(Lcom/android/contacts/list/ContactListItemView; I Landroid/database/Cursor; I I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/server/BluetoothService;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/ContactLoader;-loadDirectoryMetaData-(Lcom/android/contacts/ContactLoader$Result;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-acquireAggregationSuggestions-(Landroid/content/Context; Lcom/android/contacts/editor/RawContactEditorView;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneProxy;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/EventInfoFragment$11;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/browser/Preloader;-handlePreloadRequest-(Ljava/lang/String; Ljava/lang/String; Ljava/util/Map; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/email/service/EmailBroadcastProcessorService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleInCallMmiCommands-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/inputmethod/InputMethodAndSubtypeEnabler;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth$Stub;-getMainChannelFd-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-cancelDiscovery-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/VideoCamera;-onPreviewTextureCopied-()V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/CommandsInterface;-getSignalStrength-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/BluetoothHandsfree;-stopVoiceRecognition-()Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/speech/RecognitionService;-checkPermissions-(Landroid/speech/IRecognitionListener;)Z' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/server/input/InputManagerService;-notifyANR-(Lcom/android/server/input/InputApplicationHandle; Lcom/android/server/input/InputWindowHandle;)J' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/nfc/DeviceHost$DeviceHostListener;-onRemoteFieldActivated-()V' : ['android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/server/am/ActivityManagerService;-broadcastStickyIntent-(Landroid/content/Intent; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManager;-addAccountExplicitly-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/systemui/media/NotificationPlayer$CmdThread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/calllog/CallLogFragment;-startVoicemailStatusQuery-()V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/contacts/list/AccountFilterActivity$MyLoaderCallbacks;-onLoadFinished-(Landroid/content/Loader; Ljava/util/List;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$2900-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine; Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onSetUserDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/ManageCachePage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/data/Conversation;-startQueryHaveLockedMessages-(Landroid/content/AsyncQueryHandler; J I)V' : ['android.permission.READ_SMS'],
	'Lcom/android/nfc/NfcService$NfcServiceHandler;-dispatchTagEndpoint-(Lcom/android/nfc/DeviceHost$TagEndpoint;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothHandsfree$20;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/JoinContactListFragment;-onStart-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/AddBookmarkPage;-onRootFolderFound-(J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/content/SyncManager;-onUserRemoved-(Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService$2;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/net/sip/ISipService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/settings/Settings$TetherSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-acknowledgeIncomingGsmSmsWithPdu-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setAndBroadcastNetworkSetTime-(J)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/nsd/INsdManager$Stub;-setEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/WifiService;-addToBlacklist-(Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/email/ControllerResultUiThreadWrapper$4;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/ConnectivityService;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/contacts/editor/PhoneticNameEditorView;-onFieldChanged-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/model/EntityModifier;-parseStructuredNameExtra-(Landroid/content/Context; Lcom/android/contacts/model/AccountType; Lcom/android/contacts/model/EntityDelta; Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/event/EditEventHelper;-saveRemindersWithBackRef-(Ljava/util/ArrayList; I Ljava/util/ArrayList; Ljava/util/ArrayList; Z)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/app/AlbumPage;-doCluster-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/ContactBrowseListFragment;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-beginBackup-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/effect/effects/StraightenEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/deskclock/SetAlarm;-onTimeSet-(Landroid/widget/TimePicker; I I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/usb/UsbStorageActivity;-checkStorageUsersAsync-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Landroid/bluetooth/IBluetooth$Stub;-cancelDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/calendar/CalendarReceiver;-removeScheduledAlarms-(Landroid/content/ContentResolver;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/server/BluetoothService;-connectSink-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetooth;-disconnectHeadset-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/EasAccountService;-sendMeetingResponse-(Lcom/android/exchange/MeetingResponseRequest;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$SupplicantStoppingState;-enter-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/vcard/VCardParserImpl_V40;-parse-(Ljava/io/InputStream;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-onMenuClicked-(Landroid/view/MenuItem; Ljava/lang/String; Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;)V' : ['android.permission.VIBRATE'],
	'Landroid/media/effect/effects/NegativeEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/DataUsageSummary;-isMobilePolicySplit-()Z' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/tts/TextToSpeechSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/calllog/CallLogFragment;-callSelectedEntry-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/SubSettings;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager;-dispatchDeviceAdded-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/setup/AccountSetupOptions$1;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/bluetooth/IBluetooth;-createBond-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ITelephonyRegistry;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-onLoadComplete-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/music/MediaPlaybackActivity;-scanBackward-(I J)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset;-acceptIncomingConnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/nfc/P2pEventManager;-onP2pInRange-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendPdu-([B)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/group/GroupEditorFragment$3;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/Loader;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/CropImage$LoadBitmapDataTask;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Landroid/net/wifi/WifiStateMachine$DriverStoppedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiManager;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-getOperator-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/BrightnessEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothEventLoop;-onInputDevicePropertyChanged-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS'],
	'Landroid/net/wifi/WifiManager;-startScanActive-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/gallery3d/ui/ActionModeHandler;-computeSharingIntent-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Landroid/content/Intent;' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendRawPdu-([B [B Landroid/app/PendingIntent; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/UndoBarView;-renderChild-(Lcom/android/gallery3d/ui/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/PhoneProxy;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$WatchdogDisabledState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-switchWaitingOrHoldingAndActive-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/ClusterAlbumSet;-updateClusters-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/ConnectivityManager;-startUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/location/GpsLocationProvider;-requestRefLocation-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/nfc/INfcTag$Stub;-formatNdef-(I [B)I' : ['android.permission.NFC'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-onSurfaceChanged-(Landroid/view/SurfaceHolder; I I I)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/ui/GLRootView;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/ContactLoader;-deliverResult-(Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-access$1400-(Lcom/android/bluetooth/pbap/BluetoothPbapService; Ljava/lang/String;)V' : ['android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/vcard/VCardEntry$PostalData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/DreamSettings$Enabler;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/wallpaper/nexus/NexusRS;-start-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/PhoneProxy;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onChanged-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CallCard;-displaySecondaryCallStatus-(Lcom/android/internal/telephony/CallManager; Lcom/android/internal/telephony/Call;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/location/ILocationManager;-setTestProviderStatus-(Ljava/lang/String; I Landroid/os/Bundle; J)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/email/MessagingController;-synchronizeMailbox-(Lcom/android/emailcommon/provider/Account; Lcom/android/emailcommon/provider/Mailbox; Lcom/android/email/MessagingListener;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/BluetoothHandsfree$20;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/calendar/agenda/AgendaFragment;-goTo-(Lcom/android/calendar/CalendarController$EventInfo; Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/filterfw/core/SyncRunner;-step-()I' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/sip/SipManager;-createSipSession-(Landroid/net/sip/SipProfile; Landroid/net/sip/SipSession$Listener;)Landroid/net/sip/SipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/ManageCachePage$1;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/transaction/TransactionService;-endMmsConnectivity-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/list/PostalAddressPickerFragment;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/os/storage/IMountService;-finishMediaUpdate-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/email/activity/ActionBarController$3;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/input/InputManagerService;-access$400-(Lcom/android/server/input/InputManagerService; [Landroid/view/InputDevice;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/email/activity/MessageOrderManager;-onCursorOpenDone-(Landroid/database/Cursor;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPinForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-setRadio-(I Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/IConnectivityManager;-getTetherableBluetoothRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/vcard/VCardParserImpl_V40;-parseItem-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/RIL;-setRadioState-(Lcom/android/internal/telephony/CommandsInterface$RadioState;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/TrafficStats;-getDataLayerSnapshotForUid-(Landroid/content/Context;)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-syncReloadDictionaryInternal-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/media/AudioService;-queueMsgUnderWakeLock-(Landroid/os/Handler; I I I Ljava/lang/Object; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DeviceInfoSettings;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/phone/PhoneUtils;-cancelMmiCode-(Lcom/android/internal/telephony/Phone;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventView;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler;-<init>-(Lcom/android/contacts/activities/PhotoSelectionActivity; Landroid/content/Context; Landroid/view/View; I Lcom/android/contacts/model/EntityDeltaList; Lcom/android/contacts/activities/PhotoSelectionActivity$1;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/providers/contacts/VoicemailContentProvider;-insert-(Landroid/net/Uri; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/phone/sip/SipSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/providers/calendar/CalendarProvider2;-verifyAccounts-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-adjustUserActivityLocked-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/exchange/EasOutboxService;-tryAutodiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageViewFragmentBase$LoadBodyTask;-onSuccess-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.CAMERA', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.RECORD_AUDIO', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-sendEmergencyCallbackModeChange-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/wifi/WifiSettings;-handleEvent-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/Utils;-getWifiIpAddresses-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterfw/core/FilterGraph;-closeFilters-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/Phone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/ExpandableDictionary;-blockingReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-systemReady-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/email/MessagingController$12;-run-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/LockPatternView;-handleActionMove-(Landroid/view/MotionEvent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/email/activity/MailboxListFragment$FindParentMailboxTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/server/AlarmManagerService$ResultReceiver;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityRecord;-keyDispatchingTimedOut-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/accounts/IAccountManager;-invalidateAuthToken-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/phone/PhoneApp;-access$900-(Lcom/android/phone/PhoneApp; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms$Stub;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Landroid/inputmethodservice/KeyboardView;-access$400-(Landroid/inputmethodservice/KeyboardView; Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-removeAllDevices-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/vcard/VCardParser;-parse-(Ljava/io/InputStream;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/Settings$WifiP2pSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/BluetoothHandsfree$29;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-pokeWakelock-(I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/filterpacks/base/OutputStreamTarget;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/NfcService;-onCardEmulationAidSelected-([B)V' : ['android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/server/INativeDaemonConnectorCallbacks;-onDaemonConnected-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-connectChannelToSource-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/voicedialer/VoiceDialerActivity$4;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/voicemail/VoicemailPlaybackPresenter$2;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/browser/SnapshotTab;-removeFromTree-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/app/AlbumPage;-onItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/ui/AudioAttachmentView;-access$000-(Lcom/android/mms/ui/AudioAttachmentView;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/ComboAlbum;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/DevelopmentSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.READ_EXTERNAL_STORAGE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/common/widget/CompositeCursorAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/PhotoPage$1;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/net/NetworkPolicyEditor$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/server/BluetoothInputProfileHandler;-setInputDevicePriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccFileHandler;-updateEFTransparent-(I [B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager$ActiveSyncContext;-onFinished-(Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/widget/CalendarAppWidgetModel;-populateDayInfo-(I Landroid/text/format/Time;)Lcom/android/calendar/widget/CalendarAppWidgetModel$DayInfo;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/exchange/adapter/ItemOperationsParser;-parseResponse-()V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/location/ILocationManager;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/contacts/ContactSaveService;-renameGroup-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/view/IWindowSession$Stub$Proxy;-prepareDrag-(Landroid/view/IWindow; I I I Landroid/view/Surface;)Landroid/os/IBinder;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/model/AccountTypeManagerImpl;-access$400-(Lcom/android/contacts/model/AccountTypeManagerImpl; Landroid/content/Context;)Ljava/util/Map;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/nfc/TechListChooserActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/adapter/AbstractSyncParser;-commandsParser-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/ExchangeService$1$3;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/providers/calendar/CalendarProvider2;-updateEventRelatedTable-(Landroid/net/Uri; Ljava/lang/String; Z Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String; Z)I' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/widget/WaveView;-waveUpdateFrame-(F F Z)V' : ['android.permission.VIBRATE'],
	'Landroid/view/IWindowManager$Stub;-reenableKeyguard-(Landroid/os/IBinder;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CommandsInterface;-explicitCallTransfer-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/alerts/AlertService;-updateAlertNotification-(Landroid/content/Context;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/calendar/month/SimpleDayPickerFragment;-updateMonthHighlight-(Landroid/widget/AbsListView;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-listBonds-()[Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Landroid/webkit/HTML5VideoFullScreen$1;-surfaceDestroyed-(Landroid/view/SurfaceHolder;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AccessibilityEnableScriptInjectionPreference;-onDialogClosed-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/EmergencyCallHelper;-startEmergencyCallFromAirplaneModeSequence-(Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/DayView;-getEventAccessLevel-(Landroid/content/Context; Lcom/android/calendar/Event;)I' : ['android.permission.READ_CALENDAR'],
	'Landroid/media/AudioService$AudioHandler;-cleanupPlayer-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/DockService;-createDialog-(Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/Camera;-access$4300-(Lcom/android/camera/Camera;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/IAudioService;-setBluetoothA2dpDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice; I)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/ContactEditorFragment$PhotoHandler$PhotoEditorListener;-onRequest-(I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/ui/PhotoView;-switchToPrevImage-()V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-handleExitEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IActivityManager;-moveTaskToFront-(I I Landroid/os/Bundle;)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-registerForSuppServiceNotification-(Landroid/os/Handler; I Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasOutboxService;-sendCallback-(J Ljava/lang/String; I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/provider/Settings$Secure;-putString-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/InputStreamSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/data/WorkingMessage$1;-doInBackground-([Ljava/lang/Void;)Landroid/util/Pair;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-setMasterSyncAutomatically-(Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/DeviceStorageMonitorService;-sendNotification-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-connectChannelToSource-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/location/LocationManager;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/calllog/CallLogAdapter;-getBetterNumberFromContacts-(Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updateSettings-(Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransfer;-access$600-(Lcom/android/bluetooth/opp/BluetoothOppTransfer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/ResolverActivity$1;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/P2pEventListener;-onP2pInRange-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/providers/contacts/VoicemailContentTable;-update-(Lcom/android/providers/contacts/VoicemailContentProvider$UriData; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-connectHeadsetInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setUserData-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/os/storage/IMountService$Stub$Proxy;-setUsbMassStorageEnabled-(Z)V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Landroid/server/BluetoothService;-connectInputDevice-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/PhoneApp;-initForNewRadioTechnology-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/DayFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-onResponse-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onVoiceCallEnded-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/ConnectivityService;-access$2000-(Lcom/android/server/ConnectivityService;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/data/Conversation;-loadFromThreadId-(J Z)Z' : ['android.permission.READ_SMS'],
	'Landroid/net/wifi/IWifiManager;-acquireWifiLock-(Landroid/os/IBinder; I Ljava/lang/String; Landroid/os/WorkSource;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/server/LocationManagerService$Receiver;-callStatusChangedLocked-(Ljava/lang/String; I Landroid/os/Bundle;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-queryCallForwardStatus-(I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/Controller$3;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-access$5000-(Lcom/android/mms/ui/ComposeMessageActivity;)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/deviceinfo/Memory;-doUnmount-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/settings/widget/ChartSweepView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-bringUpServiceLocked-(Lcom/android/server/am/ServiceRecord; I Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/bluetooth/DockService;-msgTypeDocked-(Landroid/bluetooth/BluetoothDevice; I I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasAccountService;-acknowledgeProvisionImpl-(Lcom/android/exchange/EasSyncService; Ljava/lang/String; Ljava/lang/String; Z)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Contacts$ContactMethods;-addPostalLocation-(Landroid/content/Context; J D D)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/videosrc/SurfaceTextureSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/vcard/CancelActivity;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Landroid/net/wifi/WifiStateMachine$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-setNetworkTemplateEnabled-(Landroid/net/NetworkTemplate; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onDataSetupComplete-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/interactions/PhoneNumberInteraction;-onLoadComplete-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/provider/CallLog$Calls;-getLastOutgoingCall-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/gallery3d/ui/EdgeView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/CallDetailActivity$1UpdateContactDetailsTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/app/backup/BackupAgent$BackupServiceBinder;-doRestore-(Landroid/os/ParcelFileDescriptor; I Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/vcard/SelectAccountActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/SIMFileHandler;-loadEFImgLinearFixed-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IBackupAgent;-doRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/settings/Settings$WifiP2pSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/editor/ContactEditorFragment$EntityDeltaComparator;-compare-(Ljava/lang/Object; Ljava/lang/Object;)I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/suggestions/SuggestionsView;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/DataUsageSummary;-getActiveSubscriberId-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/os/storage/IMountService;-shutdown-(Landroid/os/storage/IMountShutdownObserver;)V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/phone/InCallScreen;-internalAnswerCall-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-updateNetworkRulesLocked-()V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-setRegistrationListener-(Ljava/lang/String; Landroid/net/sip/ISipSessionListener;)V' : ['android.permission.USE_SIP'],
	'Landroid/bluetooth/BluetoothHealth;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/service/MailService;-setupAccountManagerAccount-(Landroid/content/Context; Lcom/android/emailcommon/provider/Account; Z Z Z Landroid/accounts/AccountManagerCallback;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/calendar/CalendarController;-sendEventRelatedEvent-(Ljava/lang/Object; J J J J I I J)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/media/IAudioService$Stub$Proxy;-setBluetoothA2dpDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice; I)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$WifiP2pSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener;-onCodeInput-(I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$DefaultState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/statusbar/BaseStatusBar$NotificationClicker;-onClick-(Landroid/view/View;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.DISABLE_KEYGUARD', 'android.permission.USE_CREDENTIALS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-notifyDataConnectionFailed-(Lcom/android/internal/telephony/Phone; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/alerts/AlertActivity;-access$400-(Lcom/android/calendar/alerts/AlertActivity; J)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/ui/PhotoView;-checkHideUndoBar-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updatePeople-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-syncReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/sip/ISipService;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/settings/Settings$SecuritySettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/LocationSettings;-onToggleLocationAccess-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothA2dpService;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-pollState-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-addCallAndContactMenuItems-(Landroid/view/ContextMenu; Lcom/android/mms/ui/ComposeMessageActivity$MsgListMenuClickListener; Lcom/android/mms/ui/MessageItem;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DataUsageSummary;-buildLimitedNetworksList-()Ljava/util/List;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothCallback;-onDeviceAdded-(Lcom/android/settings/bluetooth/CachedBluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-disableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-run-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_SMS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/input/InputManagerService;-interceptKeyBeforeDispatching-(Lcom/android/server/input/InputWindowHandle; Landroid/view/KeyEvent; I)J' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.VIBRATE'],
	'Landroid/content/IContentService$Stub$Proxy;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/provider/Settings$System;-putLong-(Landroid/content/ContentResolver; Ljava/lang/String; J)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/InCallTouchUi;-onGrabbedStateChange-(Landroid/view/View; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/contacts/ContactsProvider2;-outputRawContactsAsVCard-(Landroid/net/Uri; Ljava/io/OutputStream; Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/content/SyncManager$SyncHandler;-maybeStartNextSyncLocked-()J' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/NfcAdapter;-setOnNdefPushCompleteCallback-(Landroid/nfc/NfcAdapter$OnNdefPushCompleteCallback; Landroid/app/Activity; [Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-rejectCall-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/accounts/AccountManager;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccRecords;-getSpnFsm-(Z Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumPicker;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.CAMERA', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.RECORD_AUDIO', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.NFC'],
	'Lcom/android/gallery3d/app/PhotoPage$2;-onPhotoChanged-(I Lcom/android/gallery3d/data/Path;)V' : ['android.permission.NFC'],
	'Landroid/filterpacks/imageproc/RedEyeFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasSyncService;-tryProvision-(Lcom/android/exchange/EasSyncService;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/GroupDetailActivity;-onStart-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-getActualState-(Landroid/content/Context;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/settings/Settings$TextToSpeechSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/emailcommon/utility/EmailAsyncTask$1;-callOnCancelledForTest-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-updateWallpaperLocked-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phone/BluetoothHandsfree$2;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$DeviceAdminSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/contacts/editor/LabeledEditorView;-notifyEditorListener-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-enableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/TextFieldsEditorView$1;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/sip/SipService$ConnectivityReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/WindowManagerPolicy;-exitKeyguardSecurely-(Landroid/view/WindowManagerPolicy$OnKeyguardExitResult;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(J F Landroid/location/Criteria; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/calllog/CallLogAdapter;-onContentChanged-()V' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/server/MountService;-getStorageUsers-(Ljava/lang/String;)[I' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/email/Controller;-loadMessageForView-(J)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/contacts/CallLogProvider;-update-(Landroid/net/Uri; Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/email/activity/UIControllerOnePane;-doAutoAdvance-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/BluetoothSettings;-onPreferenceTreeClick-(Landroid/preference/PreferenceScreen; Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/Tab$7;-onDownloadStart-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; J)V' : ['android.permission.VIBRATE', 'com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccRecords;-onRefresh-(Z [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageFileView$LoadFilenameTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/PasswordUnlockScreen;-onResume-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-setPhoto-(J Landroid/graphics/Bitmap; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-createServerSession-(Ljavax/obex/ObexTransport;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageSlicer;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CallNotifier$1;-onMessageWaitingIndicatorChanged-(Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/gallery3d/ui/SlotView$Listener;-onLongTap-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/inputmethod/latin/Suggest;-initWhitelistAndAutocorrectAndPool-(Landroid/content/Context; Ljava/util/Locale;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/Controller$ServiceCallbackWrapper;-call-(Lcom/android/emailcommon/service/IEmailServiceCallback;)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/server/BluetoothService;-disconnectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/inputmethod/InputMethodAndLanguageSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/ActivityBase;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.CAMERA', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.RECORD_AUDIO', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.NFC'],
	'Lcom/android/server/BackupManagerService$PerformFullBackupTask;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/filterpacks/videosrc/SurfaceTextureTarget;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-onScreenTurnedOn-(Lcom/android/internal/policy/impl/KeyguardViewManager$ShowListener;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/mms/widget/MmsWidgetService$MmsFactory;-onDataSetChanged-()V' : ['android.permission.READ_SMS'],
	'Lcom/android/phone/sip/SipSettings;-access$500-(Lcom/android/phone/sip/SipSettings; Landroid/net/sip/SipProfile;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/contacts/vcard/ImportVCardActivity$ImportRequestConnection;-sendImportRequest-(Ljava/util/List;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/calendar/AllInOneActivity;-initFragments-(J I Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/phone/InCallScreen;-addVoiceMailNumberPanel-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MusicUtils;-playAll-(Landroid/content/Context; [J I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/accounts/AddAccountSettings;-onActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/bluetooth/IBluetoothA2dp;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/InputMethodManagerService$InputMethodSettings;-enableAllIMEsIfThereIsNoEnabledIME-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.VIBRATE'],
	'Landroid/app/backup/IBackupManager$Stub$Proxy;-restoreAtInstall-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updatePhotoByDataId-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/camera/ui/InLineSettingItem;-changeIndex-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/contacts/list/LegacyPhoneNumberListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/server/BluetoothPanProfileHandler;-disconnectPanDevice-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/common/widget/GroupingListAdapter;-bindStandAloneView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WRITE_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetooth;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mms/transaction/SmsSingleRecipientSender;-sendMessage-(J)Z' : ['android.permission.SEND_SMS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/base/FrameFetch;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/PhoneNotifier; Landroid/net/sip/SipProfile;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/telephony/RIL;-setCurrentPreferredNetworkType-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-enable-(Z Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/AutofillHandler;-asyncLoadFromDb-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/PhoneApp;-onCreate-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_CONTACTS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-initialize-(Landroid/os/Bundle; J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SMS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/detail/PhotoSelectionHandler;-getWritableEntityIndex-()I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/SupplicantStateTracker$DefaultState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-access$900-(Lcom/android/contacts/activities/ConfirmAddDetailActivity; J Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/PhoneBase;-setPropertiesByCarrier-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/calendar/DayView$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/DhcpStateMachine$WaitBeforeRenewalState;-exit-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/AdnRecordCache;-updateAdnBySearch-(I Lcom/android/internal/telephony/AdnRecord; Lcom/android/internal/telephony/AdnRecord; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageFileViewFragment;-reloadUiFromMessage-(Lcom/android/emailcommon/provider/EmailContent$Message; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/net/NetworkStatsService;-getDataLayerSnapshotForUid-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$13;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/ActivityManagerService;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/email/MessagingListener;-synchronizeMailboxFinished-(J J I I Ljava/util/ArrayList;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/NavScreen$1;-onRemovePosition-(I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/data/Contact$ContactsCache;-getContactInfoForSelf-()Lcom/android/mms/data/Contact;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/service/AttachmentDownloadService;-watchdogAlarm-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/email/activity/MessageFileViewFragment;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.WRITE_EXTERNAL_STORAGE'],
	'Lcom/android/gallery3d/ui/ActionModeHandler;-onDestroyActionMode-(Landroid/view/ActionMode;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/ui/ConversationListItem;-access$000-(Lcom/android/mms/ui/ConversationListItem;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-isTetheringSupported-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/inputmethod/latin/suggestions/MoreSuggestionsView$1;-onTextInput-(Ljava/lang/CharSequence;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/media/IAudioService$Stub$Proxy;-reloadAudioSettings-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onActionIntentReconnectAlarm-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-processPendingRadioPowerOffAfterDataOff-()Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothAdapterStateMachine;-access$5300-(Landroid/server/BluetoothAdapterStateMachine;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/VideoCamera;-onInfo-(Landroid/media/MediaRecorder; I I)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/google/common/io/CharStreams;-readFirstLine-(Lcom/google/common/io/InputSupplier;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-trySetupData-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/InCallScreen;-requestCloseOtaFailureNotice-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/PhoneInterfaceManager;-supplyPuk-(Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccProvider;-delete-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/accounts/IAccountManager;-removeAccount-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/filterpacks/base/OutputStreamTarget;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$BondStateChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/activity/UIControllerTwoPane;-onAccountSelected-(J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/list/ContactEntryListFragment;-prepareEmptyView-()V' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/activity/UIControllerBase;-installMessageViewFragment-(Lcom/android/email/activity/MessageViewFragment;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/ApplicationPackageManager;-getPackageSizeInfo-(Ljava/lang/String; Landroid/content/pm/IPackageStatsObserver;)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Landroid/filterpacks/imageproc/AutoFixFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothPermissionActivity;-onNegative-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/base/InputStreamSource;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/os/RuntimeInit$UncaughtHandler;-uncaughtException-(Ljava/lang/Thread; Ljava/lang/Throwable;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/content/SyncManager;-readDataConnectionState-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/net/DataUsageMeteredSettings;-buildMobilePref-(Landroid/content/Context;)Landroid/preference/Preference;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/activities/ContactEditorActivity;-onBackPressed-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/content/IContentService$Stub;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/deskclock/AlarmKlaxon;-onCreate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MediaPlaybackService;-removeTracksInternal-(I I)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackActivity;-scanForward-(I J)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/AutoFixEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/BluetoothHeadset;-startScoUsingVirtualVoiceCall-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasSyncService;-setupService-()Z' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmMmiCode;-cancel-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/search/SearchManagerService$GlobalSearchProviderObserver;-<init>-(Landroid/server/search/SearchManagerService; Landroid/content/ContentResolver;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/emailcommon/service/IAccountService$Stub$Proxy;-notifyLoginFailed-(J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/systemui/statusbar/CommandQueue$Callbacks;-showSearchPanel-()V' : ['android.permission.VIBRATE'],
	'Landroid/net/IConnectivityManager$Stub;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/activities/JoinContactActivity;-onQueryTextChange-(Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/vcard/VCardParserImpl_V21;-parseItems-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/content/IContentService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/browser/DeviceAccountLogin;-handleLogin-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/calendar/event/AttendeesView;-access$100-(Lcom/android/calendar/event/AttendeesView; Lcom/android/calendar/event/EditEventHelper$AttendeeItem;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker$2;-onChange-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/am/BatteryStatsService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BATTERY_STATS', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardView$3;-forgotPattern-(Z)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/pm/PackageManagerService;-deletePackageLI-(Ljava/lang/String; Z I Lcom/android/server/pm/PackageManagerService$PackageRemovedInfo; Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/content/SyncManager;-sendCancelSyncsMessage-(Landroid/accounts/Account; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/browser/Controller$10;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker;-toggleState-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-render-(Lcom/android/gallery3d/ui/GLCanvas;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothEventManager$BondStateChangedHandler;-showUnbondMessage-(Landroid/content/Context; Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/OnContactBrowserActionListener;-onInvalidSelection-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/wm/WindowManagerService;-addWindow-(Lcom/android/server/wm/Session; Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/browser/NavScreen;-openNewTab-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/nfc/NfcService$TagService;-resetTimeouts-()V' : ['android.permission.NFC'],
	'Lcom/android/commands/bmgr/Bmgr;-doRestoreAll-(J Ljava/util/HashSet;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleEctIncallSupplementaryService-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneApp;-updateBluetoothIndication-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/util/ThumbnailManager$ThumbnailTask$1;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/DayView;-doSingleTapUp-(Landroid/view/MotionEvent;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter$EasContactsSyncParser;-parse-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/google/common/io/Files;-readLines-(Ljava/io/File; Ljava/nio/charset/Charset;)Ljava/util/List;' : ['android.permission.INTERNET'],
	'Landroid/bluetooth/IBluetooth$Stub;-listBonds-()[Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-<init>-(J Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/contacts/activities/ActionBarAdapter;-initialize-(Landroid/os/Bundle; Lcom/android/contacts/list/ContactsRequest;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/MessagingController;-checkMail-(J J Lcom/android/email/MessagingListener;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler$PhotoListener;-onUseAsPrimaryChosen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/deskclock/SetAlarm$1;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/location/LocationManager;-getLastKnownLocation-(Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-connectPanDevice-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/NfcActivityManager;-setNdefPushContentUri-(Landroid/app/Activity; [Landroid/net/Uri;)V' : ['android.permission.NFC'],
	'Landroid/accounts/AccountManager$AmsTask;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/phone/BluetoothHandsfree$24;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/EmailConnectivityManager;-waitForConnectivity-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/NsdService$NsdStateMachine$EnabledState;-enter-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/nfc/NfcAdapter;-enableNdefPush-()Z' : ['android.permission.VIBRATE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-updateSearchPanel-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/widget/LayoutSuppressingQuickContactBadge;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaListView$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/os/Vibrator;-vibrate-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-onConnectivityChanged-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsBinaryDictionary;-syncReloadDictionaryInternal-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/gadget/WidgetSource;-reload-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-setInstallLocation-(I)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mms/data/Conversation;-ensureThreadId-()J' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-onSignalStrengthResult-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/LocationManagerService;-_getLastKnownLocationLocked-(Ljava/lang/String; Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$2;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/base/NullFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView$1;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/gallery3d/ui/PhotoView;-switchToHitPicture-(I I)V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/server/am/ActivityManagerService;-crashApplication-(Lcom/android/server/am/ProcessRecord; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/WifiService;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity$1;-onClick-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageViewFragment;-onPostLoadBody-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/DevicePickerFragment;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/detail/PhotoSelectionHandler$PhotoActionListener;-onRemovePictureChosen-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/event/EditEventView$3;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/net/IConnectivityManager;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/GLView;-render-(Lcom/android/gallery3d/ui/GLCanvas;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/RIL;-hangupForegroundResumeBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-iccIOForApp-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DataUsageSummary;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/settings/SettingsBackupAgent;-onRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/net/sip/SipManager;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-getWords-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/latin/Dictionary$WordCallback; Lcom/android/inputmethod/keyboard/ProximityInfo;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-finalizeBackup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LightsService$1;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity$GroupDelta;-fromSettings-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Z)Lcom/android/contacts/list/CustomContactListFilterActivity$GroupDelta;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/accounts/AuthenticatorHelper;-onAccountsUpdated-(Landroid/content/Context; [Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/contacts/list/ContactListFilterController;-checkFilterValidity-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/MessagingController;-searchMailbox-(J Lcom/android/emailcommon/service/SearchParams; J)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/service/PopImapSyncAdapterService;-access$000-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageViewFragment$Callback;-onMessageSetUnread-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/PhoneProxy;-deleteAndCreatePhone-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.SET_TIME_ZONE'],
	'Landroid/webkit/HTML5VideoViewProxy;-pauseAndDispatch-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserSettings;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState;-onPressKey-(I Z I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Lcom/android/camera/ui/BasicSettingPopup;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/nfc/INfcTag$Stub;-getTimeout-(I)I' : ['android.permission.NFC'],
	'Lcom/android/commands/uiautomator/EventsCommand$1;-disconnect-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/AddBookmarkPage;-onTop-(Lcom/android/browser/BreadCrumbView; I Ljava/lang/Object;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/media/effect/effects/SharpenEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-setCursor-(Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/view/RotationPolicy$1;-run-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/bluetooth/HeadsetProfile;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/group/GroupDetailFragment$2;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/text/StringLogger;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-notifyDefaultData-(Lcom/android/internal/telephony/ApnContext;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mms/ui/ComposeMessageActivity;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-onVoiceCallEnded-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManager$3;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/OtaStartupReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/IActivityManager;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/AudioManager;-setParameter-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/pm/PackageManagerService;-getPackageSizeInfo-(Ljava/lang/String; Landroid/content/pm/IPackageStatsObserver;)V' : ['android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/phone/InCallScreen;-access$2300-(Lcom/android/phone/InCallScreen;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-hideSearchPanel-()V' : ['android.permission.VIBRATE'],
	'Landroid/nfc/tech/MifareClassic;-transfer-(I)V' : ['android.permission.NFC'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/BluetoothAdapter;-getConnectionState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/SimUnlockScreen;-onResume-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/providers/downloads/DownloadService;-access$500-(Lcom/android/providers/downloads/DownloadService; Lcom/android/providers/downloads/DownloadInfo$Reader; Lcom/android/providers/downloads/DownloadInfo; J)V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/calendar/CalendarProvider2;-doUpdateTimezoneDependentFields-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-initSstIcc-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/base/CallbackFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-dispatchNormalMessage-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/usb/UsbDeviceManager$UsbHandler;-updateAudioSourceFunction-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/app/ChooserActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$DeviceInfoSettingsActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-dispatchPortAddressedPdus-([[B I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/spellcheck/AndroidSpellCheckerService;-createDictAndProximity-(Ljava/util/Locale;)Lcom/android/inputmethod/latin/spellcheck/DictAndProximity;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/Settings$StorageUseActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/ITelephony$Stub;-call-(Ljava/lang/String;)V' : ['android.permission.CALL_PHONE'],
	'Landroid/app/DownloadManager;-getUriForDownloadedFile-(J)Landroid/net/Uri;' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/server/pm/PackageManagerService;-installNewPackageLI-(Landroid/content/pm/PackageParser$Package; I I Ljava/lang/String; Lcom/android/server/pm/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-dispatchUnhandledKey-(Landroid/view/WindowManagerPolicy$WindowState; Landroid/view/KeyEvent; I)Landroid/view/KeyEvent;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.CALL_PHONE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/BatteryStatsService;-setBatteryState-(I I I I I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/BrowserHistoryPage;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/BackupManagerService;-bindToAgentSynchronous-(Landroid/content/pm/ApplicationInfo; I)Landroid/app/IBackupAgent;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/WifiManager;-disconnect-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/mms/transaction/SendTransaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-initializeHdmiState-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getFrequencyBand-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/Settings$ManageApplicationsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsDictionary;-getWords-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/latin/Dictionary$WordCallback; Lcom/android/inputmethod/keyboard/ProximityInfo;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/accounts/IAccountManager;-editProperties-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/app/INotificationManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/mock/MockContentResolver;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/content/IContentService$Stub;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/phone/EmergencyDialer;-keyPressed-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/music/QueryBrowserActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/JoinContactListFragment;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/SearchActivity;-onQueryTextSubmit-(Ljava/lang/String;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/exchange/adapter/AbstractSyncAdapter;-<init>-(Lcom/android/exchange/EasSyncService;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/location/ILocationManager$Stub;-getProviders-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/AlarmManagerService;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/app/Gallery;-initializeByIntent-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/setup/AccountSettingsFragment;-onPause-()V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$VerifyingLinkState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/SettingsPreferenceFragment;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DevelopmentSettings;-writeDebuggerOptions-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/NfcService;-onSeMifareAccess-([B)V' : ['android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/server/MountService$2;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/SpecialCharSequenceMgr;-handleIMEIDisplay-(Landroid/content/Context; Ljava/lang/String; Z)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/camera/PanoramaActivity;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.CAMERA', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.RECORD_AUDIO', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.NFC'],
	'Landroid/nfc/INfcTag$Stub$Proxy;-ndefRead-(I)Landroid/nfc/NdefMessage;' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/CommandsInterface;-switchWaitingOrHoldingAndActive-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-goingToSleep-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/emailcommon/service/AccountServiceProxy$1;-run-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/inputmethod/latin/spellcheck/AndroidSpellCheckerService$AndroidSpellCheckerSession;-onGetSuggestions-(Landroid/view/textservice/TextInfo; Ljava/lang/String; I)Landroid/view/textservice/SuggestionsInfo;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/provider/Browser;-getVisitedLike-(Landroid/content/ContentResolver; Ljava/lang/String;)Landroid/database/Cursor;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/sip/SipWakeLock;-acquire-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/media/RingtonePlayer;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/camera/VideoCamera;-startVideoRecording-()V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/EasOutboxService;-sendPing-([B I)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/alerts/AlertService;-generateAlerts-(Landroid/content/Context; Lcom/android/calendar/alerts/NotificationMgr; Landroid/content/SharedPreferences; Landroid/database/Cursor; J I)Z' : ['android.permission.VIBRATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/nfc/NfcService;-onRemoteFieldActivated-()V' : ['android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Lcom/android/gallery3d/ui/SlideshowView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-setDataOnRoamingEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/NavTabScroller;-onLayout-(Z I I I I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/calendar/month/MonthByWeekFragment$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-setFilter-(Lcom/android/contacts/list/ContactListFilter;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/nfc/INfcTag;-close-(I)I' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getDataCallList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IActivityManager;-bindBackupAgent-(Landroid/content/pm/ApplicationInfo; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/vcard/NfcImportVCardActivity;-createImportRequest-()Lcom/android/contacts/vcard/ImportRequest;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/list/JoinContactListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/CallCard;-updateCallStateWidgets-(Lcom/android/internal/telephony/Call;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/ui/MessageListAdapter;-onContentChanged-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-isDrmRingtoneWithRights-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/view/IWindowManager$Stub;-freezeRotation-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-generateBinaryDictionary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/Settings$SpellCheckersSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserBinaryDictionary;-syncReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/ConnectivityService$VpnCallback;-restore-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/WindowManagerPolicy$WindowManagerFuncs;-reevaluateStatusBarVisibility-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/alerts/AlertReceiver;-getEventCursor-(Landroid/content/Context; J)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-dispatchAttributesChanged-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/WindowManagerService;-moveAppWindowsLocked-(Lcom/android/server/wm/AppWindowToken; I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/ManageConferenceUtils;-endConferenceConnection-(I Lcom/android/internal/telephony/Connection;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/SlideshowPage;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/activities/AttachPhotoActivity$Listener;-onContactLoaded-(Lcom/android/contacts/ContactLoader$Result;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/ConversationList;-createNewMessage-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$P2pEnabledState;-exit-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-setRadioPower-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/vcard/NfcImportVCardActivity;-onImportFinished-(Lcom/android/contacts/vcard/ImportRequest; I Landroid/net/Uri;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter;-moveTo-(I)V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/browser/PhoneUi;-hideNavScreen-(I Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-onUserInteraction-()V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/settings/wifi/WifiSettings;-constructAccessPoints-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/BaseUi;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/ChartDataUsageView$DataUsageChartListener;-onLimitChanged-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/statusbar/tablet/NotificationPanel;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/settings/wifi/WifiSettings;-refreshAccessPoints-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/detail/ContactDetailFragment;-bindData-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/IccCard;-getIccCardStatusDone-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/mms/model/ImageModel;-loadThumbnailBitmap-(Lcom/android/mms/util/ItemLoadedCallback;)Lcom/android/mms/util/ItemLoadedFuture;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/ThrottleService;-getCliffThreshold-(Ljava/lang/String; I)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/InCallScreenShowActivation;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothHealth;-connectChannelToSink-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/wifi/WifiApEnabler;-setSoftapEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView$1;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.USE_CREDENTIALS', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/VideoCamera;-updateRecordingTime-()V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/google/common/io/Files;-move-(Ljava/io/File; Ljava/io/File;)V' : ['android.permission.INTERNET'],
	'Landroid/net/wifi/WifiApConfigStore$InactiveState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DateTimeSettingsSetupWizard;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/view/WindowManagerPolicy;-systemReady-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/Settings$WirelessSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/text/StringSource;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper$WalkAroundEngine;-onVisibilityChanged-(Z)V' : ['android.permission.CAMERA'],
	'Lcom/android/email/Controller;-serviceLogging-(I)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/view/IWindowManager$Stub;-setForcedDisplaySize-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/nfc/handover/HandoverManager$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/email/activity/MessageList$1;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetooth;-connectChannelToSource-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/ResizeFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$TetheredState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/commands/svc/WifiCommand;-run-([Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/SearchActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setDataRoamingEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$SpellCheckersSettingsActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothAdapter;-disable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneBase;-restoreSavedNetworkSelection-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageFileViewFragment;-onPostLoadBody-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/GestureRecognizer$MyGestureListener;-onSingleTapUp-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Landroid/test/mock/MockContentResolver;-getCurrentSync-()Landroid/content/SyncInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$SyncStateTracker;-requestStateChange-(Landroid/content/Context; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/ExchangeService$2;-updateFolderList-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/NetworkTimeUpdateService$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothPbap$Stub;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/nfc/INfcAdapterExtras;-transceive-(Ljava/lang/String; [B)Landroid/os/Bundle;' : ['android.permission.NFC'],
	'Lcom/android/calendar/event/EditEventHelper$EditDoneRunnable;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/camera/VideoCamera;-access$600-(Lcom/android/camera/VideoCamera;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/Use2GOnlyCheckBoxPreference$MyHandler;-handleGetPreferredNetworkTypeResponse-(Landroid/os/Message;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterfw/core/AsyncRunner$AsyncRunnerTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/policy/impl/PasswordUnlockScreen$2;-onClick-(Landroid/view/View;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/settings/fuelgauge/PowerUsageSummary;-processMiscUsage-()V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$SoundSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/music/MediaPlaybackActivity;-cycleRepeat-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccCard;-access$100-(Lcom/android/internal/telephony/IccCard;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/calllog/ContactInfoHelper;-queryContactInfoForSipAddress-(Ljava/lang/String;)Lcom/android/contacts/calllog/ContactInfo;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/nfc/INfcAdapterExtras$Stub$Proxy;-transceive-(Ljava/lang/String; [B)Landroid/os/Bundle;' : ['android.permission.NFC'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback;-syncMailboxStatus-(J I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/OtaUtils;-onClickOtaActivateButton-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CommandsInterface;-setRadioPower-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-access$700-(Lcom/android/server/am/ActivityManagerService; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/IAudioService;-startBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/deskclock/AlarmAlert;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/media/IAudioService$Stub;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/net/INetworkPolicyManager$Stub;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/DataConnection$DcActivatingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$DeviceAdminSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/data/WorkingMessage$4;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/provider/CalendarContract$CalendarAlerts;-alarmExists-(Landroid/content/ContentResolver; J J J)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/settings/DataUsageSummary$12;-onLimitChanged-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-editProperties-(Ljava/lang/String; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/email/activity/ActionBarController;-refreshInernal-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-queryCallWaiting-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$DockSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-startScoUsingVirtualVoiceCall-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/service/PopImapSyncAdapterService$SyncAdapterImpl;-onPerformSync-(Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-powerOffRadioSafely-(Lcom/android/internal/telephony/DataConnectionTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NsdService$NsdStateMachine$DisabledState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManagerProxy;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/settings/Settings$SpellCheckersSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/UIControllerTwoPane$RefreshTask;-callOnCancelledForTest-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/AtParser;-process-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/ChooseLockGeneric$ChooseLockGenericFragment;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/ConnectivityService;-reportInetCondition-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IWallpaperManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SET_WALLPAPER_HINTS', 'android.permission.SET_WALLPAPER'],
	'Landroid/accounts/IAccountManager$Stub;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/mms/data/WorkingMessage;-preSendSmsWorker-(Lcom/android/mms/data/Conversation; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/net/NetworkStatsService;-performPollLocked-(I)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/INetworkPolicyManager;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-keyguardDone-(Z)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/gallery3d/ui/TileImageView;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/quicksearchbox/ui/ContactBadge;-assignContactFromPhone-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/data/WorkingMessage;-saveDraft-(Z)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/mms/data/WorkingMessage;-saveAsMms-(Z)Landroid/net/Uri;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/email/activity/MessageOrderManager$LoadMessageListTask;-onSuccess-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/systemui/usb/UsbAccessoryUriActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-goTo-(J Z Z Z)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-beginDraggingApplication-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDeviceManager;-onBtClassChanged-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/group/GroupDetailFragment;-bindGroupMetaData-(Landroid/database/Cursor;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-allowIncomingProfileConnect-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/nfc/NfcService$NfcAdapterService;-setForegroundDispatch-(Landroid/app/PendingIntent; [Landroid/content/IntentFilter; Landroid/nfc/TechListParcel;)V' : ['android.permission.NFC'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-changeApplicationBluetoothState-(Z Landroid/bluetooth/IBluetoothStateChangeCallback; Landroid/os/IBinder;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothPbap$Stub$Proxy;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/provider/Settings$System;-setShowGTalkServiceStatus-(Landroid/content/ContentResolver; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/adapter/CalendarSyncAdapter$EasCalendarSyncParser;-parse-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Landroid/content/ContextWrapper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/nfc/NfcService$TagService;-reconnect-(I)I' : ['android.permission.NFC'],
	'Lcom/android/contacts/editor/ContactEditorFragment$PhotoHandler;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/MobileNetworkSettings;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/dialog/ClearFrequentsDialog$1$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-query-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsBinaryDictionary;-syncReloadDictionaryIfRequired-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/MessageListItem;-updateAvatarView-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/CrossProcessFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccRecords;-setLocaleFromCsim-()V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/launcher2/AppsCustomizePagedView;-onLongClick-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/Phone;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/NfcHandler;-register-(Landroid/app/Activity; Lcom/android/contacts/detail/ContactDetailFragment;)V' : ['android.permission.NFC'],
	'Landroid/net/IThrottleManager;-getThrottle-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/adapter/ContactsSyncAdapter;-setSyncKey-(Ljava/lang/String; Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/music/MediaPlaybackService;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/GrainFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/calendar/DayView$CalendarGestureListener;-onDown-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/SipManager;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-updateFolderList-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/webkit/WebIconDatabaseClassic;-releaseIconForPageUrl-(Ljava/lang/String;)V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/contacts/activities/DialtactsActivity;-onStart-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/launcher2/Workspace;-onInterceptTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/MccTable;-setSystemLocale-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getNeighboringCids-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothDiscoverableEnabler$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/app/backup/BackupAgent$BackupServiceBinder;-doRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/Connection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivity$BackgroundQueryHandler;-onDeleteComplete-(I Ljava/lang/Object; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/IccRecords;-onReady-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$UserDictionarySettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiManager;-getWifiApState-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/Controller$LegacyListener;-loadAttachmentStarted-(J J J Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/systemui/ImageWallpaper$DrawableEngine;-onVisibilityChanged-(Z)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-operationComplete-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothHealth;-registerAppConfiguration-(Ljava/lang/String; I I I Landroid/bluetooth/BluetoothHealthCallback;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/homepages/RequestHandler;-doHandleRequest-()V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/AccountUnlockScreen$1;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/app/ActivityManagerNative;-updateConfiguration-(Landroid/content/res/Configuration;)V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/server/BatteryService$2;-onUEvent-(Landroid/os/UEventObserver$UEvent;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-handleVolumeKey-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/inputmethod/latin/LatinIME;-launchSettingsClass-(Ljava/lang/Class;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ui/TileImageView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothA2dp;-connectSinkInternal-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-powerOffRadioSafely-(Lcom/android/internal/telephony/DataConnectionTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setRadioPower-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/MessageViewFragmentBase$MessageViewAttachmentInfo;-<init>-(Landroid/content/Context; Lcom/android/emailcommon/provider/EmailContent$Attachment; Landroid/widget/ProgressBar; Lcom/android/email/activity/MessageViewFragmentBase$1;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/RIL;-hangupWaitingOrBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/EasTestAuthenticatorService$EasAuthenticator;-addAccount-(Landroid/accounts/AccountAuthenticatorResponse; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/os/Bundle;)Landroid/os/Bundle;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/net/IConnectivityManager;-getLinkProperties-(I)Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/data/Conversation$ConversationQueryHandler;-onDeleteComplete-(I Ljava/lang/Object; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/contacts/activities/PeopleActivity;-areGroupWritableAccountsAvailable-()Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/AudioService;-checkScoAudioState-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/nfc/INfcAdapterExtras;-authenticate-(Ljava/lang/String; [B)V' : ['android.permission.NFC'],
	'Landroid/view/IWindowManager$Stub$Proxy;-clearForcedDisplaySize-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/ITelephony$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_FINE_LOCATION', 'android.permission.CALL_PHONE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/vcard/VCardParserImpl_V40;-parseItems-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/telephony/PhoneNumberUtils;-isVoiceMailNumber-(Ljava/lang/String;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/CallDetailActivity$1UpdateContactDetailsTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/contacts/group/GroupBrowseListAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/EnableIccPinScreen;-access$300-(Lcom/android/phone/EnableIccPinScreen;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cat/RilMessageDecoder$StateStart;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/ConnectivityService;-handleInetConditionChange-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/contacts/list/CustomContactListFilterActivity$CustomFilterConfigurationLoader;-loadInBackground-()Lcom/android/contacts/list/CustomContactListFilterActivity$AccountSet;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setPropertiesByCarrier-()V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/CallCard;-updateForegroundCall-(Lcom/android/internal/telephony/CallManager;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/view/WindowManagerPolicy;-interceptMotionBeforeQueueingWhenScreenOff-(I)I' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/email/activity/UIControllerSearchTwoPane;-onAccountSelected-(J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/NfcActivityManager;-setOnNdefPushCompleteCallback-(Landroid/app/Activity; Landroid/nfc/NfcAdapter$OnNdefPushCompleteCallback;)V' : ['android.permission.NFC'],
	'Landroid/media/AsyncPlayer;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/PhoneUtils;-placeCall-(Landroid/content/Context; Lcom/android/internal/telephony/Phone; Ljava/lang/String; Landroid/net/Uri; Z Landroid/net/Uri;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/CryptKeeper;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/JoinContactListFragment;-onItemClick-(I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneBase;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/CalendarSyncAdapter$EasCalendarSyncParser;-addEvent-(Lcom/android/exchange/adapter/CalendarSyncAdapter$CalendarOperations; Ljava/lang/String; Z)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/email/activity/UIControllerTwoPane;-doAutoAdvance-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/WifiService;-getScanResults-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler;-getWritableEntityIndex-()I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-handleUp-(Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE'],
	'Landroid/os/storage/IMountService$Stub$Proxy;-unmountVolume-(Ljava/lang/String; Z Z)V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/mms/transaction/ReadRecTransaction;-sendPdu-(J [B)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/InCallScreen;-onResume-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/widget/LockPatternView;-handleActionDown-(Landroid/view/MotionEvent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/emailcommon/provider/Account;-isAutomaticSyncDisabledByRoaming-(Landroid/content/Context; J)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-access$400-(Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager; [Lcom/android/internal/telephony/gsm/SmsBroadcastConfigInfo;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/PhotoSelectionActivity$PhotoHandler;-getWritableEntityId-()J' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/camera/ui/IndicatorControlContainer;-onSettingChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/util/AddressUtils;-getFrom-(Landroid/content/Context; Landroid/net/Uri;)Ljava/lang/String;' : ['android.permission.READ_SMS'],
	'Lcom/android/phone/BluetoothHeadsetService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-<init>-(Lcom/android/internal/telephony/PhoneBase;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS'],
	'Landroid/view/IWindowSession;-prepareDrag-(Landroid/view/IWindow; I I I Landroid/view/Surface;)Landroid/os/IBinder;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ContactListFilterControllerImpl;-notifyContactListFilterChanged-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/IntRangeManager;-tryAddSingleRange-(I I Z)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/A2dpProfile;-isPreferred-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer$2;-onError-(Landroid/media/MediaPlayer; I I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/BluetoothDevice;-removeBond-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/launcher2/PagedViewWithDraggableItems;-onLongClick-(Landroid/view/View;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/camera/VideoCamera;-switchCamera-()V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/NfcAdapter$1;-onPaused-(Landroid/app/Activity;)V' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/SipCallOptionHandler;-access$100-(Lcom/android/phone/SipCallOptionHandler;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/speech/IRecognitionService;-cancel-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/systemui/recent/RecentTasksLoader$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.GET_TASKS'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$OutgoingA2dp;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/IAudioService$Stub$Proxy;-setWiredDeviceConnectionState-(I I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService$AutoRegistrationProcess;-onRegistrationFailed-(Landroid/net/sip/ISipSession; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ConnectivityService$FeatureUser;-expire-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DisplaySettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/inputmethod/UserDictionaryList;-getUserDictionaryLocalesSet-(Landroid/app/Activity;)Ljava/util/TreeSet;' : ['android.permission.READ_USER_DICTIONARY'],
	'Lcom/android/internal/telephony/RIL;-acceptCall-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/storage/IMountService;-getStorageUsers-(Ljava/lang/String;)[I' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/server/LocationManagerService;-getProviderInfo-(Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-setQueuePosition-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSettingsEditQuickResponsesFragment$QuickResponseFinder;-callOnPostExecuteForTest-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterfw/core/GraphRunner;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/inputmethod/latin/Suggest;-initAsynchronously-(Landroid/content/Context; Ljava/util/Locale;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/accounts/SyncSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$NotConnectedState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/LatinIME;-handleBackspaceWhileInBatchEdit-(I Landroid/view/inputmethod/InputConnection;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/MmsThumbnailPresenter$1;-onItemLoaded-(Lcom/android/mms/util/ThumbnailManager$ImageLoaded; Ljava/lang/Throwable;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/gallery3d/gadget/MediaSetSource;-reload-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/os/IVibratorService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/mms/ui/ClassZeroActivity;-saveMessage-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/RIL;-getLastDataCallFailCause-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-startVoiceRecognition-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-getDeviceIdentity-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/datepicker/DatePickerDialog;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-registerPackageChangeAndBootCompletedBroadcastReceiver-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/bluetooth/BluetoothDevice;-setPin-([B)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper$WalkAroundEngine;-onSurfaceCreated-(Landroid/view/SurfaceHolder;)V' : ['android.permission.CAMERA'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/vcard/ImportVCardActivity$VCardScanThread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-getCdmaSubscriptionSource-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/calllog/DefaultVoicemailNotifier$NewCallsQuery;-query-()[Lcom/android/contacts/calllog/DefaultVoicemailNotifier$NewCall;' : ['android.permission.READ_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Ljava/net/MulticastSocket;-<init>-(I)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/KeyguardUpdateMonitor;-access$300-(Lcom/android/internal/policy/impl/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/KeyguardUpdateMonitor$SimArgs;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/server/LocationManagerService;-updateProvidersLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/AttendeesView;-updateAttendeeView-(Lcom/android/calendar/event/EditEventHelper$AttendeeItem;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/telephony/SmsManager;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/browser/DataController$DataControllerHandler;-doSaveThumbnail-(Lcom/android/browser/Tab;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/ui/SlideViewInterface;-stopVideo-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/editor/EventFieldEditorView;-onTypeSelectionChange-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/Controller;-openIncognitoTab-()Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/deskclock/AlarmAlertWakeLock;-releaseCpuLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$StorageSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mms/ui/ConversationList$7;-onKey-(Landroid/view/View; I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-getAllMessagesFromIccEf-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/settings/wifi/WifiSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothHandsfree$4;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/location/ILocationManager;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/ContactPickerFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/BluetoothHandsfree;-setAudioState-(I Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/PhotoView$MyGestureListener;-onSingleTapUp-(F F)Z' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/contacts/activities/TransactionSafeActivity;-onResume-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/ContactLoader;-loadInBackground-()Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/WiredAccessoryObserver;-setDeviceState-(I I I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/Filter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DreamSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/RetrieveTransaction;-sendAcknowledgeInd-(Lcom/google/android/mms/pdu/RetrieveConf;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/providers/downloads/SystemFacade;-isNetworkRoaming-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/IWifiManager;-getConfiguredNetworks-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/RadioInfo$22;-onItemSelected-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/transaction/PushReceiver;-isDuplicateNotification-(Landroid/content/Context; Lcom/google/android/mms/pdu/NotificationInd;)Z' : ['android.permission.READ_SMS'],
	'Lcom/android/settings/bluetooth/LocalBluetoothProfileManager$StateChangedHandler;-onReceive-(Landroid/content/Context; Landroid/content/Intent; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/downloads/DownloadInfo;-getMyDownloadsUri-()Landroid/net/Uri;' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/mms/ui/AttachmentEditor;-update-(Lcom/android/mms/data/WorkingMessage;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/email/view/RigidWebView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I Ljava/util/Map; Z)V' : ['android.permission.INTERNET'],
	'Lcom/android/systemui/statusbar/tablet/NotificationPanel;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/calendar/agenda/AgendaListView;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/inputmethod/keyboard/LatinKeyboardView;-openMoreKeysKeyboardIfRequired-(Lcom/android/inputmethod/keyboard/Key; Lcom/android/inputmethod/keyboard/PointerTracker;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Lcom/android/settings/DataUsageSummary;-access$800-(Lcom/android/settings/DataUsageSummary; J)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/HeadsetBase;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserDictionary;-<init>-(Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/AlarmClock$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/PhoneApp;-handleQueryTTYModeResponse-(Landroid/os/Message;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/app/ActivityManagerNative;-bindBackupAgent-(Landroid/content/pm/ApplicationInfo; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/browser/GoogleAccountLogin;-startLogin-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/media/MediaRecorder;-setAudioSource-(I)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/email/NotificationController;-showSecurityNeededNotification-(Lcom/android/emailcommon/provider/Account;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/widget/LockScreenWidgetCallback;-userActivity-(Landroid/view/View;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/group/GroupEditorFragment$3;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/systemui/statusbar/CommandQueue$Callbacks;-setSystemUiVisibility-(I I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setFacilityLock-(Ljava/lang/String; Z Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/SlotView$MyGestureListener;-onLongPress-(Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/vcard/ImportVCardActivity$VCardCacheThread;-constructImportRequest-([B Landroid/net/Uri; Ljava/lang/String;)Lcom/android/contacts/vcard/ImportRequest;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/net/sip/SipAudioCall;-onError-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$LocalePickerActivity;-onAccountsUpdated-([Landroid/accounts/Account;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/email/service/AccountService;-onBind-(Landroid/content/Intent;)Landroid/os/IBinder;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/exchange/EmailSyncAlarmReceiver;-handleReceive-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/data/DownloadCache$DownloadTask;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Lcom/android/settings/BrightnessPreference;-onProgressChanged-(Landroid/widget/SeekBar; I Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/PreloadRequestReceiver;-handlePreload-(Landroid/content/Context; Landroid/content/Intent;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/inputmethod/latin/ExpandableDictionary;-isValidWord-(Ljava/lang/CharSequence;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/net/NetworkStatsService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$SignalScoCloseThread;-shutdown-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/providers/downloads/DownloadInfo;-checkCanUseNetwork-()I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/CertBlacklister;-registerObservers-(Landroid/content/ContentResolver;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/os/BatteryStatsImpl;-writeToParcelLocked-(Landroid/os/Parcel; Z I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-addAccount-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/settings/RadioInfo;-onPause-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-setRadioPower-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ITelephony$Stub;-enableDataConnectivity-()Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/contacts/list/PostalAddressListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/accounts/AccountManager$3;-doWork-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/BrowserActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/Controller$PruneThumbnails;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/SnapshotTab;-putInForeground-()V' : ['android.permission.INTERNET'],
	'Landroid/content/pm/IPackageManager$Stub;-freeStorage-(J Landroid/content/IntentSender;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendP2pConnectionChangedBroadcast-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/ApplicationPackageManager;-freeStorageAndNotify-(J Landroid/content/pm/IPackageDataObserver;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/gallery3d/app/MovieActivity$1;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$DefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.GET_TASKS'],
	'Lcom/android/camera/ShutterButton$OnShutterButtonListener;-onShutterButtonClick-()V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/sip/ISipService;-createSession-(Landroid/net/sip/SipProfile; Landroid/net/sip/ISipSessionListener;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/email/service/AttachmentDownloadService$AccountManagerStub;-getNumberOfAccounts-()I' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/BackupManagerService$RunInitializeReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-loadDictionaryAsync-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/CallNotifier;-onCdmaCallWaitingReject-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/PhotoPage$1;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/transaction/Transaction;-getPdu-(Ljava/lang/String;)[B' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/nfc/handover/BluetoothHeadsetHandover;-start-()V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/AudioService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/ExpandableDictionary;-getWords-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/latin/Dictionary$WordCallback; Lcom/android/inputmethod/keyboard/ProximityInfo;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/server/BluetoothService;-setRemoteOutOfBandData-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/MovieActivity$1;-access$1000-(Lcom/android/gallery3d/app/MoviePlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/DataUsageSummary;-hasEthernet-(Landroid/content/Context;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/nfc/INfcTag;-setTimeout-(I I)I' : ['android.permission.NFC'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub$Proxy;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/ConfirmAddDetailActivity;-access$1200-(Lcom/android/contacts/activities/ConfirmAddDetailActivity;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ui/GestureRecognizer$MyDownUpListener;-onUp-(Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE', 'android.permission.NFC'],
	'Lcom/android/contacts/model/EntityModifier;-migrateStructuredName-(Landroid/content/Context; Lcom/android/contacts/model/EntityDelta; Lcom/android/contacts/model/EntityDelta; Lcom/android/contacts/model/DataKind;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/CallerInfoCache;-startAsyncCache-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getVoiceMailAlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$30;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CdmaLteUiccRecords;-setVoiceMailNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-callListenerOnCodeInput-(Lcom/android/inputmethod/keyboard/Key; I I I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/server/BluetoothService;-finishDisable-()V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/base/FrameBranch;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-requestRouteToHost-(I I)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/GestureRecognizer$Listener;-onDown-(F F)V' : ['android.permission.VIBRATE'],
	'Landroid/filterpacks/imageproc/GrainFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/tech/MifareUltralight;-connect-()V' : ['android.permission.NFC'],
	'Lcom/android/settings/Settings$VpnSettingsActivity;-insertAccountsHeaders-(Ljava/util/List; I)I' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/base/RetargetFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/commands/bmgr/Bmgr;-doTransport-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-disconnectHeadset-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetooth$Stub;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiStateMachine;-setWifiApState-(I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phone/CallNotifier$EmergencyTonePlayerVibrator;-access$300-(Lcom/android/phone/CallNotifier$EmergencyTonePlayerVibrator;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/group/GroupEditorFragment$Member;-<init>-(J Ljava/lang/String; J Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/service/MailService$6;-run-(Ljava/lang/Object;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/Loader;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/server/BluetoothService;-initProfileState-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/Alarms;-saveSnoozeAlert-(Landroid/content/Context; I J)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/InCallTouchUi;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/SuggestionsAdapter$SuggestFilter;-performFiltering-(Ljava/lang/CharSequence;)Landroid/widget/Filter$FilterResults;' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/settings/wifi/WifiSettings;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MediaPlaybackActivity;-toggleShuffle-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/utility/Utility$ForEachAccount;-performAction-(J)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/nfc/NfcActivityManager;-requestNfcServiceCallback-(Z)V' : ['android.permission.NFC'],
	'Lcom/android/server/am/ActivityManagerService;-forceStopPackageLocked-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/systemui/statusbar/phone/PhoneStatusBar$22;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Landroid/test/mock/MockContentResolver;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/DialogPicker;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/ITelephony;-endCall-()Z' : ['android.permission.CALL_PHONE'],
	'Landroid/server/BluetoothA2dpService;-checkSinkSuspendState-(I)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-launchMultiplePhonePicker-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/Controller;-setActiveTab-(Lcom/android/browser/Tab;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/os/storage/StorageManager;-disableUsbMassStorage-()V' : ['android.permission.MOUNT_UNMOUNT_FILESYSTEMS'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifyDataConnectionFailed-(Lcom/android/internal/telephony/Phone; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/media/NotificationPlayer;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothA2dp;-shouldSendVolumeKeys-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/RuimRecords;-setMsisdnNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getPanDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/content/IContentService$Stub$Proxy;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/filterpacks/base/FrameStore;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/RadioInfo;-refreshSmsc-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/KeyguardUpdateMonitor;-registerSimStateCallback-(Lcom/android/internal/policy/impl/KeyguardUpdateMonitor$SimStateCallback;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/bluetooth/BluetoothDevice;-setPairingConfirmation-(Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/server/BluetoothBondState;-setBondState-(Ljava/lang/String; I I)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/text/StringLogger;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/WifiService;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/email/activity/MessageViewFragmentBase$ReloadMessageTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-screenTurningOn-(Landroid/view/WindowManagerPolicy$ScreenOnListener;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$P2pDisablingState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/transaction/SmsSingleRecipientSender;-<init>-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; J Z Landroid/net/Uri;)V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/PhoneUtils;-answerCall-(Lcom/android/internal/telephony/Call;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/ui/InLineSettingSwitch$1;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/TabBar$TabView;-closeTab-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$5300-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine; Landroid/net/wifi/p2p/WifiP2pDevice; Landroid/net/wifi/p2p/WifiP2pConfig;)Z' : ['android.permission.GET_TASKS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getIccSerialNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/camera/VideoCamera;-access$200-(Lcom/android/camera/VideoCamera;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/phone/BluetoothHandsfree$12;-handleTestCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/search/OpenSearchSearchEngine;-getSuggestions-(Landroid/content/Context; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-setWifiEnabled-(Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$UserAuthorizingInvitationState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.GET_TASKS'],
	'Lcom/android/server/WifiService;-testAndClearWifiSavedState-()Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/deskclock/AlarmKlaxon;-play-(Lcom/android/deskclock/Alarm;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/server/BackupManagerService;-prepareOperationTimeout-(I J Lcom/android/server/BackupManagerService$BackupRestoreTask;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/providers/contacts/DbModifierWithNotification;-insert-(Landroid/content/ContentValues;)J' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/settings/wifi/p2p/WifiP2pSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/provider/Contacts$People;-tryGetMyContactsGroupId-(Landroid/content/ContentResolver;)J' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onCallEstablished-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-showSearchPanel-()V' : ['android.permission.VIBRATE'],
	'Landroid/view/WindowManagerPolicy;-screenTurningOn-(Landroid/view/WindowManagerPolicy$ScreenOnListener;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/RIL;-getIMEISV-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/CropImage$SaveOutput;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/DataConnection;-tearDownData-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-getVoiceRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/ContactListAdapter;-getFirstContactUri-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtErrorActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH', 'android.permission.INTERNET', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/DetailsAddressResolver$AddressLookupJob;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Landroid/location/Address;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/transaction/PushReceiver$ReceivePushTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_SMS'],
	'Lcom/android/contacts/editor/ContactEditorFragment$4;-onLoadFinished-(Landroid/content/Loader; Ljava/lang/Object;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/ui/TileImageView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/content/SyncManager$SyncHandler;-closeActiveSyncContext-(Landroid/content/SyncManager$ActiveSyncContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/activities/GroupBrowserActivity;-onResume-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/inputmethod/keyboard/LatinKeyboardView$KeyTimerHandler;-startKeyRepeatTimer-(Lcom/android/inputmethod/keyboard/PointerTracker; J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-access$900-(Lcom/android/server/accessibility/AccessibilityManagerService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/provider/Settings$System;-putFloat-(Landroid/content/ContentResolver; Ljava/lang/String; F)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/accounts/ManageAccountsSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DataUsageSummary;-isMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-hangupWaitingOrBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/PhoneNumberPickerFragment;-prepareEmptyView-()V' : ['android.permission.READ_SYNC_STATS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$SettingsObserver;-observe-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/net/INetworkPolicyManager$Stub$Proxy;-getNetworkQuotaInfo-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-getUuids-()[Landroid/os/ParcelUuid;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-showGlobalActionsDialog-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/ExpandableDictionary;-loadDictionary-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-finalize-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/LocalBluetoothAdapter;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/app/KeyguardManager$KeyguardLock;-disableKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-handleNotificationError-(Landroid/os/IBinder; Lcom/android/internal/statusbar/StatusBarNotification; Ljava/lang/String;)V' : ['android.permission.VIBRATE'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/view/IWindowManager$Stub;-thawRotation-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/Phone;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/accessibility/AccessibilityEntityProvider;-simulateKeyPress-(Lcom/android/inputmethod/keyboard/Key;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Lcom/android/gallery3d/ui/EdgeView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mms/data/Contact$ContactsCache;-updateContact-(Lcom/android/mms/data/Contact;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/LockPatternKeyguardViewProperties;-createKeyguardView-(Landroid/content/Context; Lcom/android/internal/policy/impl/KeyguardViewCallback; Lcom/android/internal/policy/impl/KeyguardUpdateMonitor; Lcom/android/internal/policy/impl/KeyguardWindowController;)Lcom/android/internal/policy/impl/KeyguardViewBase;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-setKeyguardEnabled-(Z)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/providers/contacts/CallLogProvider;-delete-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/net/ThrottleManager;-getCliffLevel-(Ljava/lang/String; I)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/providers/downloads/DownloadInfo;-sendIntentIfRequested-()V' : ['android.permission.VIBRATE', 'android.permission.WRITE_EXTERNAL_STORAGE', 'android.permission.INTERNET'],
	'Lcom/android/browser/Preloader;-getSession-(Ljava/lang/String;)Lcom/android/browser/Preloader$PreloaderSession;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/ui/MessageListItem;-access$500-(Lcom/android/mms/ui/MessageListItem;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth;-setDiscoverableTimeout-(I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-<init>-(Landroid/content/Context; I Ljava/util/Locale;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/media/MediaScanner$MyMediaScannerClient;-scanFile-(Ljava/lang/String; J J Z Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/phone/BluetoothAtPhonebook$3;-handleSetCommand-([Ljava/lang/Object;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/BluetoothAtPhonebook;-checkAccessPermission-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/contacts/preference/ContactsPreferences;-setSortOrder-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/Controller;-onPreloginFinished-(Landroid/os/Bundle; Landroid/content/Intent; J Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/bluetooth/BluetoothDeviceProfileState;-sendConnectionAccessRemovalIntent-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ComposeMessageActivityNoLockScreen;-haveSomethingToCopyToSDCard-(J)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-access$000-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/UiController;-switchToTab-(Lcom/android/browser/Tab;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/gsm/GsmDataConnectionTracker;-notifyApnIdDisconnected-(Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/Settings$AndroidBeamSettingsActivity;-onBuildHeaders-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/widget/LockPatternView;-notifyCellAdded-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/vcard/ExportProcessor;-runInternal-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/activity/setup/MailboxSettings$LoadMailboxTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/performance/ThroughputFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/PackageSummary$1;-onClick-(Landroid/view/View;)V' : ['android.permission.RESTART_PACKAGES', 'android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/exchange/EasAccountService;-sendHttpClientPost-(Ljava/lang/String; Lorg/apache/http/HttpEntity;)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/nfc/DeviceHost$DeviceHostListener;-onCardEmulationDeselected-()V' : ['android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.VIBRATE'],
	'Landroid/telephony/SmsManager;-sendMultipartTextMessage-(Ljava/lang/String; Ljava/lang/String; Ljava/util/ArrayList; Ljava/util/ArrayList; Ljava/util/ArrayList;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/calendar/EventInfoFragment;-initAttendeesCursor-(Landroid/view/View;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/contacts/activities/ContactSelectionActivity;-onServiceCompleted-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/app/backup/IBackupManager$Stub$Proxy;-clearBackupData-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/ClearMissedCallsService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CALL_LOG', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/server/BluetoothA2dpService;-adjustOtherSinkPriorities-(Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/os/IVibratorService$Stub;-cancelVibrate-(Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/contacts/editor/TextFieldsEditorView;-notifyEditorListener-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/InputMethodManagerService;-<init>-(Landroid/content/Context; Lcom/android/server/wm/WindowManagerService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/fuelgauge/BatteryHistoryChart;-setStats-(Landroid/os/BatteryStats;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/ISms;-disableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/nfc/handover/BluetoothOppHandover;-start-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/INotificationManager$Stub$Proxy;-enqueueNotification-(Ljava/lang/String; I Landroid/app/Notification; [I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/systemui/screenshot/GlobalScreenshot;-takeScreenshot-(Ljava/lang/Runnable; Z Z)V' : ['android.permission.VIBRATE'],
	'Lcom/android/browser/UiController;-closeCurrentTab-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/phone/OtaUtils;-onClickOtaEndButton-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Boolean;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/IntentHandler;-onNewIntent-(Landroid/content/Intent;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/pm/PackageManagerService;-scanAvailableAsecs-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-rebindEditorsForNewContact-(Lcom/android/contacts/model/EntityDelta; Lcom/android/contacts/model/AccountWithDataSet; Lcom/android/contacts/model/AccountWithDataSet;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/BluetoothHandsfree;-access$1300-(Lcom/android/phone/BluetoothHandsfree;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/SlideshowDataAdapter$SlideshowSource;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPuk2-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaFragment$2;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-setUpAdapter-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/phone/PhoneApp;-requestWakeState-(Lcom/android/phone/PhoneApp$WakeState;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/detail/PhotoSelectionHandler$PhotoActionListener;-onPhotoSelected-(Landroid/graphics/Bitmap;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/phone/BluetoothHandsfree$9;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/WindowManagerService;-makeWindowFreezingScreenIfNeededLocked-(Lcom/android/server/wm/WindowState;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/gallery3d/app/MoviePlayer;-startVideo-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/FrameStore;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/wallpaper/grass/GrassRS;-start-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/settings/wifi/WifiAPITest$3;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/settings/inputmethod/UserDictionaryList;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.INTERNET', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-onPostExecute-(Ljava/lang/Void;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/Settings$TetherSettingsActivity;-updateHeaderList-(Ljava/util/List;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/app/IActivityManager;-registerReceiver-(Landroid/app/IApplicationThread; Ljava/lang/String; Landroid/content/IIntentReceiver; Landroid/content/IntentFilter; Ljava/lang/String;)Landroid/content/Intent;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/email/activity/UIControllerTwoPane;-switchAccount-(J Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/RefreshManager$SendPendingMessagesForAllAccountsImpl;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/server/BluetoothBondState;-setBondState-(Ljava/lang/String; I)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/Settings$DisplaySettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/IThrottleManager$Stub;-getThrottle-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/server/search/SearchManagerService$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/settings/Settings$InputMethodAndSubtypeEnablerActivity;-onResume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/RuimFileHandler;-loadEFImgTransparent-(I I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/AutoFixEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/Controller$LegacyListener;-loadAttachmentFailed-(J J J Lcom/android/emailcommon/mail/MessagingException; Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/view/VolumePanel;-onVibrate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/NotificationMgr;-updateNotificationAndLaunchIncomingCallUi-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-suspendSink-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/settings/DataUsageSummary;-hasWifiRadio-(Landroid/content/Context;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/service/AccountService$1;-reconcileAccounts-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/phone/CallNotifier;-onCdmaCallWaiting-(Landroid/os/AsyncResult;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/IBluetooth$Stub;-setPairingConfirmation-(Ljava/lang/String; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CommandsInterface;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/WindowManagerService;-updateResizingWindows-(Lcom/android/server/wm/WindowState;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/input/InputManagerService$Callbacks;-interceptKeyBeforeDispatching-(Lcom/android/server/input/InputWindowHandle; Landroid/view/KeyEvent; I)J' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS', 'android.permission.VIBRATE'],
	'Lcom/android/settings/inputmethod/KeyboardLayoutPickerFragment;-onResume-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.GET_ACCOUNTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/vcard/VCardParser_V40;-parse-(Ljava/io/InputStream; Lcom/android/vcard/VCardInterpreter;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-<init>-(Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_CONFIGURATION', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/inputmethod/latin/SubtypeSwitcher;-updateSubtype-(Landroid/view/inputmethod/InputMethodSubtype;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/am/ActivityManagerService;-appDiedLocked-(Lcom/android/server/am/ProcessRecord; I Landroid/app/IApplicationThread;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getBondState-(Ljava/lang/String;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/sip/SipService;-onConnectivityChanged-(Landroid/net/NetworkInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/phone/BluetoothHandsfree$11;-handleActionCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth$Stub;-getPanDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/wm/DragState;-unregister-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/CallerInfoCache$CacheAsyncTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/settings/DevelopmentSettings;-isPermissionEnforced-(Landroid/content/Context; Ljava/lang/String;)Z' : ['android.permission.READ_EXTERNAL_STORAGE'],
	'Lcom/android/inputmethod/keyboard/MoreKeysKeyboardView$1;-onPressKey-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Lcom/android/contacts/editor/LabeledEditorView;-onTypeSelectionChange-(I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/am/ActivityManagerService;-getRecentTasks-(I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Landroid/filterpacks/base/InputStreamSource;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/ConnectivityManager;-requestRouteToHostAddress-(I Ljava/net/InetAddress;)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/contacts/ProfileProvider;-deleteInTransaction-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WRITE_PROFILE'],
	'Lcom/android/browser/TabControl;-createNewWebView-(Z)Landroid/webkit/WebView;' : ['android.permission.INTERNET'],
	'Lcom/android/server/am/ActivityManagerService;-startProcessLocked-(Ljava/lang/String; Landroid/content/pm/ApplicationInfo; Z I Ljava/lang/String; Landroid/content/ComponentName; Z Z)Lcom/android/server/am/ProcessRecord;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/WifiManager;-getWifiApConfiguration-()Landroid/net/wifi/WifiConfiguration;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-disconnect-(Lcom/android/settings/bluetooth/LocalBluetoothProfile;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/server/BluetoothAdapterStateMachine;-finishSwitchingOff-()V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/service/MailService$2;-run-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-onResetDone-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/settings/bluetooth/DockEventReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/SmsStorageMonitor$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/statusbar/BaseStatusBar;-updateNotification-(Landroid/os/IBinder; Lcom/android/internal/statusbar/StatusBarNotification;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/location/LocationProviderInterface;-disable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$HideNavInputEventReceiver$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager$7;-doWork-()V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/mms/ui/SlideView;-startVideo-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-enforceReceiveAndSend-(Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-updateMessageOnIccEf-(I I [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/providers/contacts/GlobalSearchSupport$SearchSuggestion;-asList-([Ljava/lang/String;)Ljava/util/ArrayList;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/Preferences;-shouldShowRequireManualSync-(Landroid/content/Context; Lcom/android/emailcommon/provider/Account;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/util/Recycler$SmsRecycler;-anyThreadOverLimit-(Landroid/content/Context;)Z' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/phone/BluetoothHandsfree$11;-handleBasicCommand-(Ljava/lang/String;)Landroid/bluetooth/AtCommandResult;' : ['android.permission.VIBRATE', 'com.android.voicemail.permission.ADD_VOICEMAIL', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/Utils;-setTimeZone-(Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/email/activity/setup/AccountSetupNames$2;-doInBackground-([Ljava/lang/Void;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/Controller;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/content/IContentService$Stub$Proxy;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/latin/UserBinaryDictionary;-getWords-(Lcom/android/inputmethod/latin/WordComposer; Ljava/lang/CharSequence; Lcom/android/inputmethod/latin/Dictionary$WordCallback; Lcom/android/inputmethod/keyboard/ProximityInfo;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/EasSyncService;-acknowledgeProvision-(Lcom/android/exchange/EasSyncService; Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/INfcAdapter$Stub$Proxy;-dispatch-(Landroid/nfc/Tag;)V' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/DhcpStateMachine$DefaultState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothHeadset;-stopVoiceRecognition-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/keyboard/LatinKeyboardView;-invokeCustomRequest-(I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/SlideshowPage;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/SearchActivity;-initFragments-(J Ljava/lang/String;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/browser/Controller$9;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/policy/impl/KeyguardUpdateMonitor;-handleSimStateChange-(Lcom/android/internal/policy/impl/KeyguardUpdateMonitor$SimArgs;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/google/android/mms/pdu/PduPersister;-load-(Landroid/net/Uri;)Lcom/google/android/mms/pdu/GenericPdu;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-readOutOfBandData-()[B' : ['android.permission.BLUETOOTH'],
	'Landroid/nfc/INfcAdapterExtras$Stub$Proxy;-authenticate-(Ljava/lang/String; [B)V' : ['android.permission.NFC'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getSuggestions-(Ljava/lang/String; I Z)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-dial-(Ljava/lang/String; Lcom/android/internal/telephony/UUSInfo;)Lcom/android/internal/telephony/Connection;' : ['android.permission.USE_SIP'],
	'Landroid/net/nsd/INsdManager$Stub$Proxy;-setEnabled-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/contacts/list/EmailAddressPickerFragment;-setSearchMode-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/server/BluetoothService;-removeServiceRecord-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/GLView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/ActivityManagerNative;-setAlwaysFinish-(Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-handleBroadcastSms-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/MultiInputStream;-read-()I' : ['android.permission.INTERNET'],
	'Landroid/net/IThrottleManager;-getPeriodStartTime-(Ljava/lang/String;)J' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/RIL;-sendCdmaSms-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phone/EmergencyCallbackModeService;-access$000-(Lcom/android/phone/EmergencyCallbackModeService; Landroid/os/AsyncResult;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/gallery3d/ui/GLRootView;-onDrawFrameLocked-(Ljavax/microedition/khronos/opengles/GL10;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/mms/ui/SlideEditorActivity;-showCurrentSlide-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-hangupConnection-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/UIControllerSearchTwoPane;-onActivityStart-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/view/WindowManagerPolicy;-interceptKeyBeforeQueueing-(Landroid/view/KeyEvent; I Z)I' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.VIBRATE', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.CALL_PHONE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/inputmethod/UserDictionaryAddWordContents;-delete-(Landroid/content/Context;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/mms/transaction/MessagingNotification;-updateNotification-(Landroid/content/Context; Z I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getIccSerialNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/webkit/HTML5Audio;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnectionTracker;-notifyDefaultData-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-disableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/ApplicationSettings;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.BLUETOOTH', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/PickerActivity;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/settings/wifi/WifiAPITest;-onPreferenceClick-(Landroid/preference/Preference;)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/providers/contacts/DbModifierWithNotification;-notifyVoicemailChange-(Landroid/net/Uri; Ljava/util/Set; [Ljava/lang/String;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/gallery3d/app/AlbumSetDataLoader;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/PhoneBase;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/Phone;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/util/DownloadManager;-markState-(Landroid/net/Uri; I)V' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/server/LocationManagerService;-access$600-(Lcom/android/server/LocationManagerService;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$900-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine; Landroid/os/Messenger; Ljava/lang/String; Z)Z' : ['android.permission.GET_TASKS'],
	'Landroid/server/BluetoothService;-getRemoteDeviceProperties-(Ljava/lang/String;)[Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/Controller;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.NFC'],
	'Lcom/android/providers/contacts/VoicemailContentProvider;-checkPackagePermission-(Lcom/android/providers/contacts/VoicemailContentProvider$UriData;)V' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/content/ContentResolver;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-openFile-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$FullImageJob;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Landroid/graphics/BitmapRegionDecoder;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-openToReceiveCalls-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/list/DefaultContactBrowseListFragment;-refreshSelectedContactUri-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/AudioService$AudioServiceBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/ChartDataUsageView$3;-onSweep-(Lcom/android/settings/widget/ChartSweepView; Z)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/group/GroupEditorFragment$3;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/CursorLoader;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/BluetoothHandsfree$29;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/inputmethod/keyboard/LatinKeyboardView$KeyTimerHandler;-startLongPressTimer-(Lcom/android/inputmethod/keyboard/PointerTracker;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.VIBRATE'],
	'Lcom/android/exchange/ExchangeService;-startManualSync-(J I Lcom/android/exchange/Request;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/activity/MessageListFragment;-doFooterClick-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/ContactSaveService;-deleteGroup-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/phone/InCallScreen;-onMMIComplete-(Lcom/android/internal/telephony/MmiCode;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-access$800-(Lcom/android/server/net/NetworkPolicyManagerService; Landroid/net/NetworkTemplate; I)V' : ['android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/settings/Settings$AccountSyncSettingsActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/wifi/WifiStatusTest$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-changeIccPin-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/DataConnectionTracker;-onDisconnectDone-(I Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ConversationListItem;-bind-(Landroid/content/Context; Lcom/android/mms/data/Conversation;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/selectcalendars/SelectSyncedCalendarsMultiAccountActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-processPendingRadioPowerOffAfterDataOff-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-changeIccPinForApp-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedUserDictionary;-reloadDictionaryIfRequired-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/phone/PhoneInterfaceManager;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-isWalledGardenConnection-()Z' : ['android.permission.INTERNET'],
	'Lcom/android/browser/WebViewFactory;-createWebView-(Z)Landroid/webkit/WebView;' : ['android.permission.INTERNET'],
	'Landroid/media/MediaScanner$MyMediaScannerClient;-setSettingIfNotSet-(Ljava/lang/String; Landroid/net/Uri; J)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-updateServiceLocation-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/LocationManager;-addTestProvider-(Ljava/lang/String; Z Z Z Z Z Z Z I I)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/internal/telephony/RIL;-getDataRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/GroupMemberLoader;-constructLoaderForGroupDetailQuery-(Landroid/content/Context; J)Lcom/android/contacts/GroupMemberLoader;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/development/Connectivity;-access$2000-(Lcom/android/development/Connectivity;)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/server/PowerManagerService$4;-run-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.USE_CREDENTIALS', 'android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/IccRecords;-onRefresh-(Z [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/GroupMessagingListener;-checkMailFinished-(Landroid/content/Context; J J J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/media/AudioService;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/browser/UrlHandler;-startActivityForUrl-(Lcom/android/browser/Tab; Ljava/lang/String;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/content/SyncManager;-scheduleSyncOperation-(Landroid/content/SyncOperation;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/Controller;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/bluetooth/BluetoothPbap;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/settings/bluetooth/BluetoothNameDialogFragment;-updateDeviceName-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/Gallery;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.CAMERA', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.RECORD_AUDIO', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/CommandsInterface;-writeSmsToRuim-(I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/KeyguardViewBase;-onScreenTurnedOn-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/gallery3d/ui/ScreenNail;-draw-(Lcom/android/gallery3d/ui/GLCanvas; I I I I)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/nfc/tech/MifareUltralight;-writePage-(I [B)V' : ['android.permission.NFC'],
	'Lcom/android/mms/ui/ConversationListAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/app/ActivityManager;-getRunningTasks-(I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsDictionary;-<init>-(Landroid/content/Context; I)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/emailcommon/utility/Utility$ForEachAccount;-onPostExecute-([Ljava/lang/Long;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/systemui/statusbar/tablet/TabletStatusBar;-animateCollapse-()V' : ['android.permission.VIBRATE'],
	'Landroid/net/INetworkPolicyManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub;-setDiscoverableTimeout-(I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/common/contacts/DataUsageStatUpdater;-updateWithAddress-(Ljava/util/Collection;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/list/ProfileAndContactsLoader;-loadInBackground-()Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/location/LocationManager;-clearTestProviderLocation-(Ljava/lang/String;)V' : ['android.permission.ACCESS_MOCK_LOCATION'],
	'Landroid/bluetooth/BluetoothDevice;-createRfcommSocket-(I)Landroid/bluetooth/BluetoothSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/SuggestionsAdapter$CompletionListener;-onSelect-(Ljava/lang/String; I Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mms/ui/SlideshowAttachmentView;-setVideo-(Ljava/lang/String; Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/systemui/media/NotificationPlayer;-play-(Landroid/content/Context; Landroid/net/Uri; Z I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-createBondOutOfBand-(Ljava/lang/String; [B [B)Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/NsdService$NsdStateMachine$DefaultState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.VIBRATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/KeyguardViewCallback;-pokeWakelock-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-openCompleteTransfer-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/editor/ContactEditorFragment;-onSplitContactConfirmed-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/uiautomator/core/InteractionController;-freezeRotation-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/test/mock/MockContentResolver;-setSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String; Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub$Proxy;-expand-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/server/wm/WindowManagerService;-performLayoutAndPlaceSurfacesLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/VideoCamera;-restorePreferences-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/server/BluetoothService;-getRemoteServiceChannel-(Ljava/lang/String; Landroid/os/ParcelUuid;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/filterfw/core/Filter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/utility/EmailAsyncTask$InnerTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/contacts/ContactLoader;-loadGroupMetaData-(Lcom/android/contacts/ContactLoader$Result;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetooth;-getRemoteClass-(Ljava/lang/String;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/adapter/EmailSyncAdapter;-getAutomaticLookback-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/PhoneBase;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NetworkTimeUpdateService$SettingsObserver;-observe-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/google/android/mms/util/PduCache;-put-(Landroid/net/Uri; Lcom/google/android/mms/util/PduCacheEntry;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/test/mock/MockContentResolver;-getPeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiStateMachine$ObtainingIpState;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-switchHoldingAndActive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkStatsService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/wm/WindowManagerService;-handleAppTransitionReadyLocked-()I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/Gallery;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.CAMERA', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.RECORD_AUDIO', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/PhoneProxy;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/SecurityPolicy;-onAdminEnabled-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE'],
	'Landroid/nfc/tech/MifareClassic;-writeBlock-(I [B)V' : ['android.permission.NFC'],
	'Landroid/net/IConnectivityManager$Stub;-getTetheredIfacePairs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mms/ui/ClassZeroActivity;-replaceMessage-(Landroid/telephony/SmsMessage;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/media/effect/effects/CrossProcessEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService$ProximityListener;-onLocationChanged-(Landroid/location/Location;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-getVoiceRadioTechnology-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/wifi/WifiSettingsForSetupWizardXL;-onClick-(Landroid/view/View;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/widget/VideoView;-resume-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/model/AccountTypeManagerImpl$1;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/MoviePlayer$9;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/SimSmsInterfaceManager;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/provider/Browser;-getAllVisitedUrls-(Landroid/content/ContentResolver;)Landroid/database/Cursor;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/providers/contacts/LegacyApiSupport;-updateOrganizations-(J Landroid/content/ContentValues;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/detail/ContactDetailFragment$AddToMyContactsQuickFix;-isApplicable-()Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/settings/Settings$TextToSpeechSettingsActivity;-setListAdapter-(Landroid/widget/ListAdapter;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/phone/BluetoothHandsfree$15;-handleReadCommand-()Landroid/bluetooth/AtCommandResult;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALL_LOG', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Landroid/webkit/WebView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.INTERNET'],
	'Landroid/content/ISyncStatusObserver$Stub$Proxy;-onStatusChanged-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/base/FrameFetch;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/CommandsInterface;-getLastCallFailCause-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-getNetworkQuotaInfoUnchecked-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/music/MediaPlaybackService;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/SnapshotTab$LoadData;-onPostExecute-(Landroid/database/Cursor;)V' : ['android.permission.WAKE_LOCK', 'com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/Call;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$GpsStateTracker$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/Controller$2;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/support/v4/net/ConnectivityManagerCompat$BaseConnectivityManagerCompatImpl;-isActiveNetworkMetered-(Landroid/net/ConnectivityManager;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/LatinIME;-updateBigramPredictions-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/providers/downloads/DownloadProvider;-logVerboseOpenFileInfo-(Landroid/net/Uri; Ljava/lang/String;)V' : ['android.permission.INTERNET'],
	'Lcom/android/settings/widget/SettingsAppWidgetProvider$StateTracker;-setCurrentState-(Landroid/content/Context; I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/am/BroadcastQueue;-skipCurrentReceiverLocked-(Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/email/activity/MessageViewFragmentBase$LoadMessageTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$IncomingA2dp;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary$AsyncReloadDictionaryTask;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mms/ui/MessageUtils;-getMultimediaMessageDetails-(Landroid/content/Context; Landroid/database/Cursor; I)Ljava/lang/String;' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetooth$Stub;-getHealthDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-revertToNitzTime-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/util/ThreadPool$Job;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.SET_WALLPAPER', 'android.permission.INTERNET', 'android.permission.NFC'],
	'Lcom/android/internal/telephony/cdma/CdmaDataConnection;-access$1800-(Lcom/android/internal/telephony/DataConnection; Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/bluetooth/BluetoothDeviceFilter$ClassUuidFilter;-matches-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/activities/ContactEditorActivity;-onStart-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/deskclock/SetAlarm;-saveAndExit-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/GLRootView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.VIBRATE', 'android.permission.NFC', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/phone/NotificationMgr;-updateInCallNotification-(Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.VIBRATE', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-getIMEI-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/EventInfoFragment;-onResume-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-access$300-(Lcom/android/server/accessibility/AccessibilityManagerService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/accounts/AccountManagerService;-installNotification-(I Landroid/app/Notification;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mms/transaction/SmsSingleRecipientSender;-getOutgoingServiceCenter-(J)Ljava/lang/String;' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Landroid/app/IWallpaperManager;-setWallpaper-(Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/editor/ContactEditorFragment$5;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/CursorLoader;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/content/ContentService;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumPage$2;-render-(Lcom/android/gallery3d/ui/GLCanvas;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/ContextImpl;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/contacts/list/ProviderStatusWatcher;-notifyListeners-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/providers/contacts/VoicemailContentProvider;-openFile-(Landroid/net/Uri; Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/settings/Settings$HeaderAdapter;-resume-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/server/BluetoothService;-handlePanDeviceStateChange-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String; I I)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/webkit/WebViewClassic$8;-onPostExecute-(Landroid/webkit/WebViewCore$DrawData;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService$Stub$Proxy;-dispatchMediaKeyEvent-(Landroid/view/KeyEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mms/ui/ConversationList;-onStart-()V' : ['android.permission.READ_SMS'],
	'Landroid/media/IRingtonePlayer$Stub$Proxy;-play-(Landroid/os/IBinder; Landroid/net/Uri; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AllInOneActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/IWifiManager$Stub;-setFrequencyBand-(I Z)V' : ['android.permission.WRITE_SETTINGS', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/content/SyncManager$6;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.GET_ACCOUNTS', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-<init>-(Landroid/content/Context; Ljava/lang/String; Lcom/android/internal/telephony/gsm/GsmCallTracker; Lcom/android/internal/telephony/gsm/GsmCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/SyncManager$ActiveSyncContext;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/input/InputManagerService;-systemReady-(Landroid/server/BluetoothService;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/KeyguardViewMediator;-keyguardDone-(Z Z)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableBluetoothRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/soundrecorder/SoundRecorder;-access$000-(Lcom/android/soundrecorder/SoundRecorder;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/ConnectivityManager;-getTetheringErroredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/IWallpaperManager$Stub$Proxy;-setDimensionHints-(I I)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Lcom/android/settings/bluetooth/CachedBluetoothDevice;-startPairing-()Z' : ['android.permission.BLUETOOTH', 'android.permission.WRITE_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/DnsPinger;-getCurrentLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/IConnectivityManager$Stub;-getLastTetherError-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback$Stub;-syncMailboxListStatus-(J I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/PhoneProxy;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasOutboxService;-sendMessage-(Ljava/io/File; J)I' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/ActivityController;-onPause-()V' : ['android.permission.WAKE_LOCK', 'android.permission.NFC'],
	'Landroid/accounts/AccountManager$1;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/wm/WindowStateAnimator;-createSurfaceLocked-()Landroid/view/Surface;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/Controller$2;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/detail/ContactDetailLayoutController;-showEmptyState-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-cancelDiscovery-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mms/data/WorkingMessage;-updateDraftMmsMessage-(Landroid/net/Uri; Lcom/google/android/mms/pdu/PduPersister; Lcom/android/mms/model/SlideshowModel; Lcom/google/android/mms/pdu/SendReq;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/inputmethod/latin/LatinIME$UIHandler;-postUpdateBigramPredictions-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_USER_DICTIONARY', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS'],
	'Lcom/android/development/AccountsTester$3;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/browser/ActivityController;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'android.permission.INTERNET', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$2400-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothDeviceProfileState$IncomingHid;-exit-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/phone/InCallScreen;-connectBluetoothAudio-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/server/BluetoothBondState;-isAutoPairingBlacklisted-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/settings/AccessibilitySettings$ToggleAccessibilityServicePreferenceFragment;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/MccTable;-setLocaleFromMccIfNeeded-(Landroid/content/Context; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_CONFIGURATION'],
	'Lcom/android/contacts/list/DefaultContactListAdapter;-getContactUri-(I Landroid/database/Cursor; I I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/IccFileHandler;-updateEFTransparent-(I [B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccProvider;-updateIccRecordInEf-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/phone/PhoneApp;-handleServiceStateChanged-(Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-getDataCallList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothA2dpService;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-launchHomeFromHotKey-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.WAKE_LOCK', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/contacts/list/LegacyPostalAddressListAdapter;-getView-(I Landroid/database/Cursor; I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SOCIAL_STREAM', 'android.permission.READ_SOCIAL_STREAM', 'android.permission.READ_CONTACTS', 'android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/base/ObjectSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothService;-getConnectedPanDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService;-access$1200-(Lcom/android/m