/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import java.util.List;

public class BracketExpr
extends Expr {
    private BracketAccessor mAccessor;

    BracketExpr(Expr target, Expr arg) {
        super(target, arg);
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        ModelClass targetType = this.getTarget().resolveType(modelAnalyzer);
        if (targetType.isArray()) {
            this.mAccessor = BracketAccessor.ARRAY;
        } else if (targetType.isList()) {
            this.mAccessor = BracketAccessor.LIST;
        } else if (targetType.isMap()) {
            this.mAccessor = BracketAccessor.MAP;
        } else {
            throw new IllegalArgumentException("Cannot determine variable type used in [] expression. Cast the value to List, Map, or array. Type detected: " + targetType.toJavaCode());
        }
        return targetType.getComponentType();
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return this.constructDynamicChildrenDependencies();
    }

    @Override
    protected String computeUniqueKey() {
        return sUniqueKeyJoiner.join(this.getTarget().computeUniqueKey(), "$", this.getArg().computeUniqueKey(), "$");
    }

    public Expr getTarget() {
        return this.getChildren().get(0);
    }

    public Expr getArg() {
        return this.getChildren().get(1);
    }

    public BracketAccessor getAccessor() {
        return this.mAccessor;
    }

    public boolean argCastsInteger() {
        return Object.class.equals((Object)this.getArg().getResolvedType());
    }

    public static enum BracketAccessor {
        ARRAY,
        LIST,
        MAP;

    }
}

