//
// BAGEL - Parallel electron correlation program.
// Filename: wigner3j.h
// Copyright (C) 2014 Toru Shiozaki
//
// Author: Hai-Anh Le <anh@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef __SRC_INTEGRAL_ECP_WIGNER3J_GEN_WIGNER3J_H
#define __SRC_INTEGRAL_ECP_WIGNER3J_GEN_WIGNER3J_H

#include <algorithm>
#include <cassert>
#include <array>

namespace bagel {

struct Wigner3j {
  public:
    Wigner3j() {}

    double lookup_wigner3j(const int j1, const int m1, const int j2, const int m2, const int j3, const int m3) const {
      assert (j1 <= 6 && j2 <= 6 && j3 <= 6);
      const int m = m1 + m2 + m3;
      double out = 0.0;
      if (m == 0) {
        const int j = j1*8281 + j2*1183 + j3*169 + (m1+6)*13 + m2+6;
        out = w3j[j];
      }

      return out;

    }

  private:
    const std::array<double,57967> w3j = {{    0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,1.0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,5.773502691896257e-1,-5.773502691896257e-1,5.773502691896257e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,4.472135954999579e-1,-4.472135954999579e-1,4.472135954999579e-1,-4.472135954999579e-1,4.472135954999579e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,3.779644730092273e-1,-3.779644730092272e-1,3.779644730092271e-1,-3.779644730092272e-1,3.779644730092271e-1,
-3.779644730092272e-1,3.779644730092273e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,3.333333333333333e-1,-3.333333333333333e-1,3.333333333333334e-1,-3.333333333333333e-1,3.333333333333333e-1,
-3.333333333333333e-1,3.333333333333334e-1,-3.333333333333333e-1,3.333333333333333e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,3.015113445777636e-1,-3.015113445777637e-1,3.015113445777636e-1,-3.015113445777636e-1,3.015113445777636e-1,
-3.015113445777636e-1,3.015113445777636e-1,-3.015113445777636e-1,3.015113445777636e-1,-3.015113445777637e-1,3.015113445777636e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,2.773500981126146e-1,-2.773500981126146e-1,2.773500981126145e-1,-2.773500981126146e-1,2.773500981126145e-1,
-2.773500981126146e-1,2.773500981126146e-1,-2.773500981126146e-1,2.773500981126145e-1,-2.773500981126146e-1,2.773500981126145e-1,-2.773500981126146e-1,
2.773500981126146e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,5.773502691896257e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,-5.773502691896257e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,5.773502691896257e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,5.773502691896257e-1,0,0,
0,0,0,0,0,0,0,
0,0,-5.773502691896257e-1,0,0,0,0,
0,0,0,0,0,0,0,
5.773502691896257e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,4.082482904638630e-1,-4.082482904638630e-1,0,
0,0,0,0,0,0,0,
0,0,-4.082482904638630e-1,0,4.082482904638630e-1,0,0,
0,0,0,0,0,0,0,
0,4.082482904638630e-1,-4.082482904638630e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,4.472135954999579e-1,-3.162277660168379e-1,1.825741858350554e-1,
0,0,0,0,0,0,0,
0,0,0,-3.162277660168379e-1,3.651483716701107e-1,-3.162277660168379e-1,0,
0,0,0,0,0,0,0,
0,0,1.825741858350554e-1,-3.162277660168379e-1,4.472135954999579e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,1.825741858350554e-1,-3.162277660168379e-1,4.472135954999579e-1,
0,0,0,0,0,0,0,
0,0,-3.162277660168379e-1,3.651483716701107e-1,-3.162277660168379e-1,0,0,
0,0,0,0,0,0,0,
4.472135954999579e-1,-3.162277660168379e-1,1.825741858350554e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,2.581988897471611e-1,-3.162277660168379e-1,3.162277660168379e-1,
-2.581988897471611e-1,0,0,0,0,0,0,
0,0,-3.651483716701107e-1,0,0,0,3.651483716701107e-1,
0,0,0,0,0,0,0,
0,2.581988897471611e-1,-3.162277660168379e-1,3.162277660168379e-1,-2.581988897471611e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,3.779644730092272e-1,-3.086066999241838e-1,2.390457218668787e-1,
-1.690308509457033e-1,9.759000729485331e-2,0,0,0,0,0,
0,0,0,-2.182178902359924e-1,2.760262237369417e-1,-2.927700218845600e-1,2.760262237369417e-1,
-2.182178902359924e-1,0,0,0,0,0,0,
0,0,9.759000729485331e-2,-1.690308509457033e-1,2.390457218668787e-1,-3.086066999241838e-1,3.779644730092272e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,9.759000729485331e-2,-1.690308509457033e-1,2.390457218668787e-1,
-3.086066999241838e-1,3.779644730092272e-1,0,0,0,0,0,
0,0,-2.182178902359924e-1,2.760262237369417e-1,-2.927700218845600e-1,2.760262237369417e-1,-2.182178902359924e-1,
0,0,0,0,0,0,0,
3.779644730092272e-1,-3.086066999241838e-1,2.390457218668787e-1,-1.690308509457033e-1,9.759000729485331e-2,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,1.889822365046136e-1,-2.439750182371333e-1,2.672612419124243e-1,
-2.672612419124243e-1,2.439750182371333e-1,-1.889822365046136e-1,0,0,0,0,
0,0,-3.273268353539885e-1,0,0,0,0,
0,3.273268353539885e-1,0,0,0,0,0,
0,1.889822365046136e-1,-2.439750182371333e-1,2.672612419124243e-1,-2.672612419124243e-1,2.439750182371333e-1,-1.889822365046136e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,3.333333333333334e-1,-2.886751345948129e-1,2.439750182371333e-1,
-1.992047682223990e-1,1.543033499620919e-1,-1.091089451179962e-1,6.299407883487121e-2,0,0,0,
0,0,0,-1.666666666666667e-1,2.182178902359924e-1,-2.439750182371333e-1,2.519763153394848e-1,
-2.439750182371333e-1,2.182178902359924e-1,-1.666666666666667e-1,0,0,0,0,
0,0,6.299407883487121e-2,-1.091089451179962e-1,1.543033499620919e-1,-1.992047682223990e-1,2.439750182371333e-1,
-2.886751345948129e-1,3.333333333333334e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,6.299407883487121e-2,-1.091089451179962e-1,1.543033499620919e-1,
-1.992047682223990e-1,2.439750182371333e-1,-2.886751345948129e-1,3.333333333333334e-1,0,0,0,
0,0,-1.666666666666667e-1,2.182178902359924e-1,-2.439750182371333e-1,2.519763153394848e-1,-2.439750182371333e-1,
2.182178902359924e-1,-1.666666666666667e-1,0,0,0,0,0,
3.333333333333334e-1,-2.886751345948129e-1,2.439750182371333e-1,-1.992047682223990e-1,1.543033499620919e-1,-1.091089451179962e-1,6.299407883487121e-2,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,1.490711984999860e-1,-1.972026594366539e-1,2.236067977499790e-1,
-2.357022603955159e-1,2.357022603955159e-1,-2.236067977499790e-1,1.972026594366539e-1,-1.490711984999860e-1,0,0,
0,0,-2.981423969999720e-1,0,0,0,0,
0,0,0,2.981423969999720e-1,0,0,0,
0,1.490711984999860e-1,-1.972026594366539e-1,2.236067977499790e-1,-2.357022603955159e-1,2.357022603955159e-1,-2.236067977499790e-1,
1.972026594366539e-1,-1.490711984999860e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,3.015113445777636e-1,-2.696799449852968e-1,2.378353560042253e-1,
-2.059714602177749e-1,1.740776559556978e-1,-1.421338109037403e-1,1.100963765126361e-1,-7.784989441615231e-2,4.494665749754947e-2,0,
0,0,0,-1.348399724926484e-1,1.797866299901979e-1,-2.059714602177749e-1,2.201927530252721e-1,
-2.247332874877473e-1,2.201927530252721e-1,-2.059714602177749e-1,1.797866299901979e-1,-1.348399724926484e-1,0,0,
0,0,4.494665749754947e-2,-7.784989441615231e-2,1.100963765126361e-1,-1.421338109037403e-1,1.740776559556978e-1,
-2.059714602177749e-1,2.378353560042253e-1,-2.696799449852968e-1,3.015113445777636e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,4.494665749754947e-2,-7.784989441615231e-2,1.100963765126361e-1,
-1.421338109037403e-1,1.740776559556978e-1,-2.059714602177749e-1,2.378353560042253e-1,-2.696799449852968e-1,3.015113445777636e-1,0,
0,0,-1.348399724926484e-1,1.797866299901979e-1,-2.059714602177749e-1,2.201927530252721e-1,-2.247332874877473e-1,
2.201927530252721e-1,-2.059714602177749e-1,1.797866299901979e-1,-1.348399724926484e-1,0,0,0,
3.015113445777636e-1,-2.696799449852968e-1,2.378353560042253e-1,-2.059714602177749e-1,1.740776559556978e-1,-1.421338109037403e-1,1.100963765126361e-1,
-7.784989441615231e-2,4.494665749754947e-2,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,1.230914909793327e-1,-1.651445647689541e-1,1.906925178491184e-1,
-2.059714602177749e-1,2.132007163556104e-1,-2.132007163556104e-1,2.059714602177749e-1,-1.906925178491184e-1,1.651445647689541e-1,-1.230914909793327e-1,
0,0,-2.752409412815902e-1,0,0,0,0,
0,0,0,0,0,2.752409412815902e-1,0,
0,1.230914909793327e-1,-1.651445647689541e-1,1.906925178491184e-1,-2.059714602177749e-1,2.132007163556104e-1,-2.132007163556104e-1,
2.059714602177749e-1,-1.906925178491184e-1,1.651445647689541e-1,-1.230914909793327e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,2.773500981126145e-1,-2.531848417709167e-1,2.290143062071722e-1,
-2.048366225996756e-1,1.806489209323782e-1,-1.564465546936860e-1,1.322214713369863e-1,-1.079583792718826e-1,8.362420100070908e-2,-5.913123959890827e-2,
3.413943709994594e-2,0,0,-1.132277034144596e-1,1.526762041381148e-1,-1.773937187967248e-1,1.931218198341070e-1,
-2.019716336333912e-1,2.048366225996757e-1,-2.019716336333912e-1,1.931218198341070e-1,-1.773937187967248e-1,1.526762041381148e-1,-1.132277034144596e-1,
0,0,3.413943709994594e-2,-5.913123959890827e-2,8.362420100070908e-2,-1.079583792718826e-1,1.322214713369863e-1,
-1.564465546936860e-1,1.806489209323782e-1,-2.048366225996756e-1,2.290143062071722e-1,-2.531848417709167e-1,2.773500981126145e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,3.413943709994594e-2,-5.913123959890827e-2,8.362420100070908e-2,
-1.079583792718826e-1,1.322214713369863e-1,-1.564465546936860e-1,1.806489209323782e-1,-2.048366225996756e-1,2.290143062071722e-1,-2.531848417709167e-1,
2.773500981126145e-1,0,-1.132277034144596e-1,1.526762041381148e-1,-1.773937187967248e-1,1.931218198341070e-1,-2.019716336333912e-1,
2.048366225996757e-1,-2.019716336333912e-1,1.931218198341070e-1,-1.773937187967248e-1,1.526762041381148e-1,-1.132277034144596e-1,0,
2.773500981126145e-1,-2.531848417709167e-1,2.290143062071722e-1,-2.048366225996756e-1,1.806489209323782e-1,-1.564465546936860e-1,1.322214713369863e-1,
-1.079583792718826e-1,8.362420100070908e-2,-5.913123959890827e-2,3.413943709994594e-2,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,1.048284836721918e-1,-1.419384378754400e-1,1.657483860329489e-1,
-1.815682598006407e-1,1.913897505877382e-1,-1.961161351381841e-1,1.961161351381841e-1,-1.913897505877382e-1,1.815682598006407e-1,-1.657483860329489e-1,
1.419384378754400e-1,-1.048284836721918e-1,-2.567762955065477e-1,0,0,0,0,
0,0,0,0,0,0,0,
2.567762955065477e-1,1.048284836721918e-1,-1.419384378754400e-1,1.657483860329489e-1,-1.815682598006407e-1,1.913897505877382e-1,-1.961161351381841e-1,
1.961161351381841e-1,-1.913897505877382e-1,1.815682598006407e-1,-1.657483860329489e-1,1.419384378754400e-1,-1.048284836721918e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,4.472135954999579e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,-4.472135954999579e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,4.472135954999579e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,-4.472135954999579e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,4.472135954999579e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,4.472135954999579e-1,
0,0,0,0,0,0,0,
0,0,0,0,-3.162277660168379e-1,-3.162277660168379e-1,0,
0,0,0,0,0,0,0,
0,0,1.825741858350554e-1,3.651483716701107e-1,1.825741858350554e-1,0,0,
0,0,0,0,0,0,0,
0,-3.162277660168379e-1,-3.162277660168379e-1,0,0,0,0,
0,0,0,0,0,0,0,
4.472135954999579e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,3.651483716701107e-1,
-2.581988897471611e-1,0,0,0,0,0,0,
0,0,0,0,-2.581988897471611e-1,0,3.162277660168379e-1,
0,0,0,0,0,0,0,
0,0,0,3.162277660168379e-1,0,-3.162277660168379e-1,0,
0,0,0,0,0,0,0,
0,0,-3.162277660168379e-1,0,2.581988897471611e-1,0,0,
0,0,0,0,0,0,0,
0,2.581988897471611e-1,-3.651483716701107e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,3.779644730092272e-1,
-2.182178902359924e-1,9.759000729485331e-2,0,0,0,0,0,
0,0,0,0,0,-3.086066999241838e-1,2.760262237369417e-1,
-1.690308509457033e-1,0,0,0,0,0,0,
0,0,0,0,2.390457218668787e-1,-2.927700218845600e-1,2.390457218668787e-1,
0,0,0,0,0,0,0,
0,0,0,-1.690308509457033e-1,2.760262237369417e-1,-3.086066999241838e-1,0,
0,0,0,0,0,0,0,
0,0,9.759000729485331e-2,-2.182178902359924e-1,3.779644730092272e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,4.472135954999579e-1,
0,0,0,0,0,0,0,
0,0,0,0,-4.472135954999579e-1,0,0,
0,0,0,0,0,0,0,
0,0,4.472135954999579e-1,0,0,0,0,
0,0,0,0,0,0,0,
-4.472135954999579e-1,0,0,0,0,0,0,
0,0,0,0,0,4.472135954999579e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,2.581988897471611e-1,
-3.651483716701107e-1,0,0,0,0,0,0,
0,0,0,0,-3.162277660168379e-1,0,2.581988897471611e-1,
0,0,0,0,0,0,0,
0,0,3.162277660168379e-1,0,-3.162277660168379e-1,0,0,
0,0,0,0,0,0,0,
-2.581988897471611e-1,0,3.162277660168379e-1,0,0,0,0,
0,0,0,0,0,0,3.651483716701107e-1,
-2.581988897471611e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,2.390457218668787e-1,
-2.927700218845600e-1,2.390457218668787e-1,0,0,0,0,0,
0,0,0,0,-2.927700218845600e-1,0,0,
-2.927700218845600e-1,0,0,0,0,0,0,
0,0,2.390457218668787e-1,0,0,0,2.390457218668787e-1,
0,0,0,0,0,0,0,
0,-2.927700218845600e-1,0,0,-2.927700218845600e-1,0,0,
0,0,0,0,0,0,0,
2.390457218668787e-1,-2.927700218845600e-1,2.390457218668787e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,2.672612419124244e-1,
-2.672612419124244e-1,2.070196678027063e-1,-1.195228609334393e-1,0,0,0,0,
0,0,0,0,-2.672612419124244e-1,0,0,
0,2.070196678027063e-1,0,0,0,0,0,
0,0,0,2.672612419124244e-1,0,0,0,
-2.672612419124244e-1,0,0,0,0,0,0,
0,0,-2.070196678027063e-1,0,0,0,2.672612419124244e-1,
0,0,0,0,0,0,0,
0,1.195228609334393e-1,-2.070196678027063e-1,2.672612419124244e-1,-2.672612419124244e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,3.333333333333333e-1,
-2.357022603955159e-1,1.543033499620919e-1,-8.908708063747479e-2,3.984095364447979e-2,0,0,0,
0,0,0,0,0,-2.357022603955159e-1,2.519763153394848e-1,
-2.182178902359924e-1,1.593638145779191e-1,-8.908708063747479e-2,0,0,0,0,
0,0,0,0,1.543033499620919e-1,-2.182178902359924e-1,2.390457218668787e-1,
-2.182178902359924e-1,1.543033499620919e-1,0,0,0,0,0,
0,0,0,-8.908708063747479e-2,1.593638145779191e-1,-2.182178902359924e-1,2.519763153394848e-1,
-2.357022603955159e-1,0,0,0,0,0,0,
0,0,3.984095364447979e-2,-8.908708063747479e-2,1.543033499620919e-1,-2.357022603955159e-1,3.333333333333333e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,9.759000729485331e-2,
-2.182178902359924e-1,3.779644730092272e-1,0,0,0,0,0,
0,0,0,0,-1.690308509457033e-1,2.760262237369417e-1,-3.086066999241838e-1,
0,0,0,0,0,0,0,
0,0,2.390457218668787e-1,-2.927700218845600e-1,2.390457218668787e-1,0,0,
0,0,0,0,0,0,0,
-3.086066999241838e-1,2.760262237369417e-1,-1.690308509457033e-1,0,0,0,0,
0,0,0,0,0,3.779644730092272e-1,-2.182178902359924e-1,
9.759000729485331e-2,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,1.195228609334393e-1,
-2.070196678027063e-1,2.672612419124244e-1,-2.672612419124244e-1,0,0,0,0,
0,0,0,0,-2.070196678027063e-1,0,0,
0,2.672612419124244e-1,0,0,0,0,0,
0,0,2.672612419124244e-1,0,0,0,-2.672612419124244e-1,
0,0,0,0,0,0,0,
-2.672612419124244e-1,0,0,0,2.070196678027063e-1,0,0,
0,0,0,0,0,0,2.672612419124244e-1,
-2.672612419124244e-1,2.070196678027063e-1,-1.195228609334393e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,1.543033499620919e-1,
-2.182178902359924e-1,2.390457218668787e-1,-2.182178902359924e-1,1.543033499620919e-1,0,0,0,
0,0,0,0,-2.439750182371333e-1,0,0,
0,0,-2.439750182371333e-1,0,0,0,0,
0,0,2.439750182371333e-1,0,0,0,0,
0,2.439750182371333e-1,0,0,0,0,0,
0,-2.439750182371333e-1,0,0,0,0,-2.439750182371333e-1,
0,0,0,0,0,0,0,
1.543033499620919e-1,-2.182178902359924e-1,2.390457218668787e-1,-2.182178902359924e-1,1.543033499620919e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,2.108185106778919e-1,
-2.357022603955158e-1,2.182178902359924e-1,-1.781741612749496e-1,1.259881576697424e-1,-6.900655593423542e-2,0,0,
0,0,0,0,-2.581988897471611e-1,0,0,
0,0,0,1.463850109422800e-1,0,0,0,
0,0,0,2.236067977499790e-1,0,0,0,
0,0,-2.236067977499790e-1,0,0,0,0,
0,0,-1.463850109422800e-1,0,0,0,0,
0,2.581988897471611e-1,0,0,0,0,0,
0,6.900655593423542e-2,-1.259881576697424e-1,1.781741612749496e-1,-2.182178902359924e-1,2.357022603955158e-1,-2.108185106778919e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,3.015113445777636e-1,
-2.335496832484569e-1,1.740776559556978e-1,-1.230914909793327e-1,8.058229640253801e-2,-4.652421051992354e-2,2.080625946441197e-2,0,
0,0,0,0,0,-1.906925178491184e-1,2.201927530252721e-1,
-2.132007163556104e-1,1.860968420796942e-1,-1.471224715841249e-1,1.019294382875251e-1,-5.504818825631802e-2,0,0,
0,0,0,0,1.100963765126361e-1,-1.651445647689541e-1,1.973855084879307e-1,
-2.080625946441197e-1,1.973855084879307e-1,-1.651445647689541e-1,1.100963765126361e-1,0,0,0,
0,0,0,-5.504818825631802e-2,1.019294382875251e-1,-1.471224715841249e-1,1.860968420796942e-1,
-2.132007163556104e-1,2.201927530252721e-1,-1.906925178491184e-1,0,0,0,0,
0,0,2.080625946441197e-2,-4.652421051992354e-2,8.058229640253801e-2,-1.230914909793327e-1,1.740776559556978e-1,
-2.335496832484569e-1,3.015113445777636e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,3.984095364447979e-2,
-8.908708063747479e-2,1.543033499620919e-1,-2.357022603955159e-1,3.333333333333333e-1,0,0,0,
0,0,0,0,-8.908708063747479e-2,1.593638145779191e-1,-2.182178902359924e-1,
2.519763153394848e-1,-2.357022603955159e-1,0,0,0,0,0,
0,0,1.543033499620919e-1,-2.182178902359924e-1,2.390457218668787e-1,-2.182178902359924e-1,1.543033499620919e-1,
0,0,0,0,0,0,0,
-2.357022603955159e-1,2.519763153394848e-1,-2.182178902359924e-1,1.593638145779191e-1,-8.908708063747479e-2,0,0,
0,0,0,0,0,3.333333333333333e-1,-2.357022603955159e-1,
1.543033499620919e-1,-8.908708063747479e-2,3.984095364447979e-2,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,6.900655593423542e-2,
-1.259881576697424e-1,1.781741612749496e-1,-2.182178902359924e-1,2.357022603955158e-1,-2.108185106778919e-1,0,0,
0,0,0,0,-1.463850109422800e-1,0,0,
0,0,0,2.581988897471611e-1,0,0,0,
0,0,2.236067977499790e-1,0,0,0,0,
0,-2.236067977499790e-1,0,0,0,0,0,
-2.581988897471611e-1,0,0,0,0,0,1.463850109422800e-1,
0,0,0,0,0,0,2.108185106778919e-1,
-2.357022603955158e-1,2.182178902359924e-1,-1.781741612749496e-1,1.259881576697424e-1,-6.900655593423542e-2,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,1.100963765126361e-1,
-1.651445647689541e-1,1.973855084879307e-1,-2.080625946441197e-1,1.973855084879307e-1,-1.651445647689541e-1,1.100963765126361e-1,0,
0,0,0,0,-2.059714602177749e-1,0,0,
0,0,0,0,-2.059714602177749e-1,0,0,
0,0,2.378353560042253e-1,0,0,0,0,
0,0,0,2.378353560042253e-1,0,0,0,
0,-2.059714602177749e-1,0,0,0,0,0,
0,-2.059714602177749e-1,0,0,0,0,0,
1.100963765126361e-1,-1.651445647689541e-1,1.973855084879307e-1,-2.080625946441197e-1,1.973855084879307e-1,-1.651445647689541e-1,1.100963765126361e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,1.740776559556978e-1,
-2.059714602177749e-1,2.059714602177748e-1,-1.880253582725887e-1,1.589104315409320e-1,-1.230914909793327e-1,8.408749651825215e-2,-4.494665749754947e-2,
0,0,0,0,-2.461829819586654e-1,0,0,
0,0,0,0,0,1.100963765126361e-1,0,
0,0,0,1.906925178491184e-1,0,0,0,
0,0,0,0,-1.906925178491184e-1,0,0,
0,0,-1.100963765126361e-1,0,0,0,0,
0,0,0,2.461829819586654e-1,0,0,0,
0,4.494665749754947e-2,-8.408749651825215e-2,1.230914909793327e-1,-1.589104315409320e-1,1.880253582725887e-1,-2.059714602177748e-1,
2.059714602177749e-1,-1.740776559556978e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,2.773500981126146e-1,
-2.264554068289192e-1,1.806489209323782e-1,-1.399300524562882e-1,1.042977031291240e-1,-7.374961314478495e-2,4.828045495852676e-2,-2.787473366690302e-2,
1.246595986677943e-2,0,0,0,0,-1.601281538050871e-1,1.931218198341070e-1,
-1.978909779672615e-1,1.865734032750510e-1,-1.649091483060512e-1,1.365577483997838e-1,-1.042977031291240e-1,7.051811804639269e-2,-3.739787960033828e-2,
0,0,0,0,8.362420100070908e-2,-1.295500551262591e-1,1.615773069067130e-1,
-1.806489209323782e-1,1.869893980016915e-1,-1.806489209323782e-1,1.615773069067130e-1,-1.295500551262591e-1,8.362420100070908e-2,0,
0,0,0,-3.739787960033828e-2,7.051811804639269e-2,-1.042977031291240e-1,1.365577483997838e-1,
-1.649091483060512e-1,1.865734032750510e-1,-1.978909779672615e-1,1.931218198341070e-1,-1.601281538050871e-1,0,0,
0,0,1.246595986677943e-2,-2.787473366690302e-2,4.828045495852676e-2,-7.374961314478495e-2,1.042977031291240e-1,
-1.399300524562882e-1,1.806489209323782e-1,-2.264554068289192e-1,2.773500981126146e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,2.080625946441198e-2,
-4.652421051992354e-2,8.058229640253801e-2,-1.230914909793327e-1,1.740776559556978e-1,-2.335496832484569e-1,3.015113445777636e-1,0,
0,0,0,0,-5.504818825631802e-2,1.019294382875251e-1,-1.471224715841249e-1,
1.860968420796942e-1,-2.132007163556104e-1,2.201927530252721e-1,-1.906925178491184e-1,0,0,0,
0,0,1.100963765126361e-1,-1.651445647689541e-1,1.973855084879307e-1,-2.080625946441197e-1,1.973855084879307e-1,
-1.651445647689541e-1,1.100963765126361e-1,0,0,0,0,0,
-1.906925178491184e-1,2.201927530252721e-1,-2.132007163556104e-1,1.860968420796942e-1,-1.471224715841249e-1,1.019294382875251e-1,-5.504818825631802e-2,
0,0,0,0,0,3.015113445777636e-1,-2.335496832484569e-1,
1.740776559556978e-1,-1.230914909793327e-1,8.058229640253801e-2,-4.652421051992354e-2,2.080625946441197e-2,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,4.494665749754947e-2,
-8.408749651825216e-2,1.230914909793327e-1,-1.589104315409320e-1,1.880253582725887e-1,-2.059714602177748e-1,2.059714602177748e-1,-1.740776559556978e-1,
0,0,0,0,-1.100963765126361e-1,0,0,
0,0,0,0,0,2.461829819586654e-1,0,
0,0,1.906925178491184e-1,0,0,0,0,
0,0,0,-1.906925178491184e-1,0,0,0,
-2.461829819586654e-1,0,0,0,0,0,0,
0,1.100963765126361e-1,0,0,0,0,1.740776559556978e-1,
-2.059714602177749e-1,2.059714602177748e-1,-1.880253582725887e-1,1.589104315409320e-1,-1.230914909793327e-1,8.408749651825215e-2,-4.494665749754947e-2,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,8.362420100070908e-2,
-1.295500551262591e-1,1.615773069067130e-1,-1.806489209323782e-1,1.869893980016915e-1,-1.806489209323782e-1,1.615773069067130e-1,-1.295500551262591e-1,
8.362420100070908e-2,0,0,0,-1.773937187967248e-1,0,0,
0,0,0,0,0,0,-1.773937187967248e-1,
0,0,2.290143062071723e-1,0,0,0,0,
0,0,0,0,0,2.290143062071723e-1,0,
0,-1.773937187967248e-1,0,0,0,0,0,
0,0,0,-1.773937187967248e-1,0,0,0,
8.362420100070908e-2,-1.295500551262591e-1,1.615773069067130e-1,-1.806489209323782e-1,1.869893980016915e-1,-1.806489209323782e-1,1.615773069067130e-1,
-1.295500551262591e-1,8.362420100070908e-2,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,1.482498633322202e-1,
-1.815682598006407e-1,1.896418623723042e-1,-1.832114449657378e-1,1.672484020014181e-1,-1.448413648755802e-1,1.182624791978165e-1,-8.939803125353483e-2,
5.997002248126639e-2,-3.160697706205070e-2,0,0,-2.344036154692477e-1,0,0,
0,0,0,0,0,0,0,
8.655927155716765e-2,0,0,1.657483860329490e-1,0,0,0,
0,0,0,0,0,0,-1.657483860329490e-1,
0,0,-8.655927155716765e-2,0,0,0,0,
0,0,0,0,0,2.344036154692477e-1,0,
0,3.160697706205070e-2,-5.997002248126639e-2,8.939803125353483e-2,-1.182624791978165e-1,1.448413648755802e-1,-1.672484020014181e-1,
1.832114449657378e-1,-1.896418623723042e-1,1.815682598006407e-1,-1.482498633322202e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,1.246595986677943e-2,
-2.787473366690302e-2,4.828045495852677e-2,-7.374961314478495e-2,1.042977031291240e-1,-1.399300524562882e-1,1.806489209323782e-1,-2.264554068289192e-1,
2.773500981126146e-1,0,0,0,-3.739787960033828e-2,7.051811804639269e-2,-1.042977031291240e-1,
1.365577483997838e-1,-1.649091483060512e-1,1.865734032750510e-1,-1.978909779672615e-1,1.931218198341070e-1,-1.601281538050871e-1,0,
0,0,8.362420100070908e-2,-1.295500551262591e-1,1.615773069067130e-1,-1.806489209323782e-1,1.869893980016915e-1,
-1.806489209323782e-1,1.615773069067130e-1,-1.295500551262591e-1,8.362420100070908e-2,0,0,0,
-1.601281538050871e-1,1.931218198341070e-1,-1.978909779672615e-1,1.865734032750510e-1,-1.649091483060512e-1,1.365577483997838e-1,-1.042977031291240e-1,
7.051811804639269e-2,-3.739787960033828e-2,0,0,0,2.773500981126146e-1,-2.264554068289192e-1,
1.806489209323782e-1,-1.399300524562882e-1,1.042977031291240e-1,-7.374961314478495e-2,4.828045495852676e-2,-2.787473366690302e-2,1.246595986677943e-2,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,3.160697706205070e-2,
-5.997002248126639e-2,8.939803125353483e-2,-1.182624791978165e-1,1.448413648755802e-1,-1.672484020014181e-1,1.832114449657378e-1,-1.896418623723042e-1,
1.815682598006407e-1,-1.482498633322202e-1,0,0,-8.655927155716765e-2,0,0,
0,0,0,0,0,0,0,
2.344036154692477e-1,0,1.657483860329490e-1,0,0,0,0,
0,0,0,0,0,-1.657483860329490e-1,0,
-2.344036154692477e-1,0,0,0,0,0,0,
0,0,0,8.655927155716765e-2,0,0,1.482498633322202e-1,
-1.815682598006407e-1,1.896418623723042e-1,-1.832114449657378e-1,1.672484020014181e-1,-1.448413648755802e-1,1.182624791978165e-1,-8.939803125353483e-2,
5.997002248126639e-2,-3.160697706205070e-2,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,6.629935441317958e-2,
-1.048284836721918e-1,1.340970468803023e-1,-1.548419322277527e-1,1.672484020014182e-1,-1.713786140993951e-1,1.672484020014182e-1,-1.548419322277527e-1,
1.340970468803023e-1,-1.048284836721918e-1,6.629935441317958e-2,0,-1.554857684028483e-1,0,0,
0,0,0,0,0,0,0,
0,-1.554857684028483e-1,2.198900824313101e-1,0,0,0,0,
0,0,0,0,0,0,0,
2.198900824313101e-1,-1.554857684028483e-1,0,0,0,0,0,
0,0,0,0,0,-1.554857684028483e-1,0,
6.629935441317958e-2,-1.048284836721918e-1,1.340970468803023e-1,-1.548419322277527e-1,1.672484020014182e-1,-1.713786140993951e-1,1.672484020014182e-1,
-1.548419322277527e-1,1.340970468803023e-1,-1.048284836721918e-1,6.629935441317958e-2,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,3.779644730092273e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
-3.779644730092272e-1,0,0,0,0,0,0,
0,0,0,0,0,0,3.779644730092271e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,-3.779644730092272e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,3.779644730092271e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,-3.779644730092272e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,3.779644730092273e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,3.779644730092272e-1,0,0,0,0,0,
0,0,0,0,0,0,-2.182178902359924e-1,
-3.086066999241838e-1,0,0,0,0,0,0,
0,0,0,0,9.759000729485331e-2,2.760262237369417e-1,2.390457218668787e-1,
0,0,0,0,0,0,0,
0,0,0,-1.690308509457033e-1,-2.927700218845600e-1,-1.690308509457033e-1,0,
0,0,0,0,0,0,0,
0,0,2.390457218668787e-1,2.760262237369417e-1,9.759000729485331e-2,0,0,
0,0,0,0,0,0,0,
0,-3.086066999241838e-1,-2.182178902359924e-1,0,0,0,0,
0,0,0,0,0,0,0,
3.779644730092272e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,3.273268353539885e-1,-1.889822365046136e-1,0,0,0,0,
0,0,0,0,0,0,-1.889822365046136e-1,
0,2.439750182371333e-1,0,0,0,0,0,
0,0,0,0,0,2.439750182371333e-1,0,
-2.672612419124243e-1,0,0,0,0,0,0,
0,0,0,0,-2.672612419124243e-1,0,2.672612419124243e-1,
0,0,0,0,0,0,0,
0,0,0,2.672612419124243e-1,0,-2.439750182371333e-1,0,
0,0,0,0,0,0,0,
0,0,-2.439750182371333e-1,0,1.889822365046136e-1,0,0,
0,0,0,0,0,0,0,
0,1.889822365046136e-1,-3.273268353539885e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,3.333333333333334e-1,-1.666666666666667e-1,6.299407883487121e-2,0,0,0,
0,0,0,0,0,0,0,
-2.886751345948129e-1,2.182178902359924e-1,-1.091089451179962e-1,0,0,0,0,
0,0,0,0,0,0,2.439750182371333e-1,
-2.439750182371333e-1,1.543033499620919e-1,0,0,0,0,0,
0,0,0,0,0,-1.992047682223990e-1,2.519763153394848e-1,
-1.992047682223990e-1,0,0,0,0,0,0,
0,0,0,0,1.543033499620919e-1,-2.439750182371333e-1,2.439750182371333e-1,
0,0,0,0,0,0,0,
0,0,0,-1.091089451179962e-1,2.182178902359924e-1,-2.886751345948129e-1,0,
0,0,0,0,0,0,0,
0,0,6.299407883487121e-2,-1.666666666666667e-1,3.333333333333334e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,3.779644730092272e-1,0,0,0,0,0,
0,0,0,0,0,0,-3.086066999241838e-1,
-2.182178902359924e-1,0,0,0,0,0,0,
0,0,0,0,2.390457218668787e-1,2.760262237369417e-1,9.759000729485331e-2,
0,0,0,0,0,0,0,
0,0,-1.690308509457033e-1,-2.927700218845600e-1,-1.690308509457033e-1,0,0,
0,0,0,0,0,0,0,
9.759000729485331e-2,2.760262237369417e-1,2.390457218668787e-1,0,0,0,0,
0,0,0,0,0,0,-2.182178902359924e-1,
-3.086066999241838e-1,0,0,0,0,0,0,
0,0,0,0,0,3.779644730092272e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,2.672612419124244e-1,-2.672612419124244e-1,0,0,0,0,
0,0,0,0,0,0,-2.672612419124244e-1,
0,2.672612419124244e-1,0,0,0,0,0,
0,0,0,0,2.070196678027063e-1,0,0,
-2.070196678027063e-1,0,0,0,0,0,0,
0,0,-1.195228609334393e-1,0,0,0,1.195228609334393e-1,
0,0,0,0,0,0,0,
0,2.070196678027063e-1,0,0,-2.070196678027063e-1,0,0,
0,0,0,0,0,0,0,
-2.672612419124244e-1,0,2.672612419124244e-1,0,0,0,0,
0,0,0,0,0,0,2.672612419124244e-1,
-2.672612419124244e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,2.439750182371333e-1,-2.439750182371333e-1,1.543033499620919e-1,0,0,0,
0,0,0,0,0,0,-2.439750182371333e-1,
0,0,-2.182178902359924e-1,0,0,0,0,
0,0,0,0,1.543033499620919e-1,0,0,
0,2.390457218668787e-1,0,0,0,0,0,
0,0,0,-2.182178902359924e-1,0,0,0,
-2.182178902359924e-1,0,0,0,0,0,0,
0,0,2.390457218668787e-1,0,0,0,1.543033499620919e-1,
0,0,0,0,0,0,0,
0,-2.182178902359924e-1,0,0,-2.439750182371333e-1,0,0,
0,0,0,0,0,0,0,
1.543033499620919e-1,-2.439750182371333e-1,2.439750182371333e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,2.581988897471611e-1,-2.236067977499790e-1,1.463850109422800e-1,-6.900655593423542e-2,0,0,
0,0,0,0,0,0,-2.108185106778919e-1,
0,0,0,1.259881576697424e-1,0,0,0,
0,0,0,0,0,2.357022603955158e-1,0,
0,0,-1.781741612749496e-1,0,0,0,0,
0,0,0,0,-2.182178902359924e-1,0,0,
0,2.182178902359924e-1,0,0,0,0,0,
0,0,0,1.781741612749496e-1,0,0,0,
-2.357022603955158e-1,0,0,0,0,0,0,
0,0,-1.259881576697424e-1,0,0,0,2.108185106778919e-1,
0,0,0,0,0,0,0,
0,6.900655593423542e-2,-1.463850109422800e-1,2.236067977499790e-1,-2.581988897471611e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,3.015113445777636e-1,-1.906925178491184e-1,1.100963765126361e-1,-5.504818825631802e-2,2.080625946441198e-2,0,
0,0,0,0,0,0,0,
-2.335496832484569e-1,2.201927530252721e-1,-1.651445647689541e-1,1.019294382875251e-1,-4.652421051992355e-2,0,0,
0,0,0,0,0,0,1.740776559556978e-1,
-2.132007163556104e-1,1.973855084879307e-1,-1.471224715841249e-1,8.058229640253801e-2,0,0,0,
0,0,0,0,0,-1.230914909793327e-1,1.860968420796942e-1,
-2.080625946441197e-1,1.860968420796942e-1,-1.230914909793327e-1,0,0,0,0,
0,0,0,0,8.058229640253801e-2,-1.471224715841249e-1,1.973855084879307e-1,
-2.132007163556104e-1,1.740776559556978e-1,0,0,0,0,0,
0,0,0,-4.652421051992355e-2,1.019294382875251e-1,-1.651445647689541e-1,2.201927530252721e-1,
-2.335496832484569e-1,0,0,0,0,0,0,
0,0,2.080625946441198e-2,-5.504818825631802e-2,1.100963765126361e-1,-1.906925178491184e-1,3.015113445777636e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,3.779644730092273e-1,0,0,0,0,0,
0,0,0,0,0,0,-3.779644730092272e-1,
0,0,0,0,0,0,0,
0,0,0,0,3.779644730092271e-1,0,0,
0,0,0,0,0,0,0,
0,0,-3.779644730092272e-1,0,0,0,0,
0,0,0,0,0,0,0,
3.779644730092271e-1,0,0,0,0,0,0,
0,0,0,0,0,-3.779644730092272e-1,0,
0,0,0,0,0,0,0,
0,0,0,3.779644730092273e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,1.889822365046136e-1,-3.273268353539885e-1,0,0,0,0,
0,0,0,0,0,0,-2.439750182371333e-1,
0,1.889822365046136e-1,0,0,0,0,0,
0,0,0,0,2.672612419124243e-1,0,-2.439750182371333e-1,
0,0,0,0,0,0,0,
0,0,-2.672612419124243e-1,0,2.672612419124243e-1,0,0,
0,0,0,0,0,0,0,
2.439750182371333e-1,0,-2.672612419124243e-1,0,0,0,0,
0,0,0,0,0,-1.889822365046136e-1,0,
2.439750182371333e-1,0,0,0,0,0,0,
0,0,0,0,3.273268353539885e-1,-1.889822365046136e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,1.543033499620919e-1,-2.439750182371333e-1,2.439750182371333e-1,0,0,0,
0,0,0,0,0,0,-2.182178902359924e-1,
0,0,-2.439750182371333e-1,0,0,0,0,
0,0,0,0,2.390457218668787e-1,0,0,
0,1.543033499620919e-1,0,0,0,0,0,
0,0,-2.182178902359924e-1,0,0,0,-2.182178902359924e-1,
0,0,0,0,0,0,0,
1.543033499620919e-1,0,0,0,2.390457218668787e-1,0,0,
0,0,0,0,0,0,-2.439750182371333e-1,
0,0,-2.182178902359924e-1,0,0,0,0,
0,0,0,0,0,2.439750182371333e-1,-2.439750182371333e-1,
1.543033499620919e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,1.543033499620919e-1,-2.182178902359924e-1,2.182178902359924e-1,-1.543033499620919e-1,0,0,
0,0,0,0,0,0,-2.182178902359924e-1,
0,0,0,2.182178902359924e-1,0,0,0,
0,0,0,0,2.182178902359924e-1,0,0,
0,0,-2.182178902359924e-1,0,0,0,0,
0,0,-1.543033499620919e-1,0,0,0,0,
0,1.543033499620919e-1,0,0,0,0,0,
0,2.182178902359924e-1,0,0,0,0,-2.182178902359924e-1,
0,0,0,0,0,0,0,
-2.182178902359924e-1,0,0,0,2.182178902359924e-1,0,0,
0,0,0,0,0,0,1.543033499620919e-1,
-2.182178902359924e-1,2.182178902359924e-1,-1.543033499620919e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,1.740776559556978e-1,-2.132007163556104e-1,1.973855084879307e-1,-1.471224715841249e-1,8.058229640253803e-2,0,
0,0,0,0,0,0,-2.247332874877474e-1,
0,0,0,0,-1.471224715841249e-1,0,0,
0,0,0,0,1.740776559556978e-1,0,0,
0,0,0,1.973855084879307e-1,0,0,0,
0,0,0,-2.132007163556104e-1,0,0,0,
0,0,-2.132007163556104e-1,0,0,0,0,
0,0,1.973855084879307e-1,0,0,0,0,
0,1.740776559556978e-1,0,0,0,0,0,
0,-1.471224715841249e-1,0,0,0,0,-2.247332874877474e-1,
0,0,0,0,0,0,0,
8.058229640253803e-2,-1.471224715841249e-1,1.973855084879307e-1,-2.132007163556104e-1,1.740776559556978e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,2.132007163556104e-1,-2.132007163556104e-1,1.740776559556978e-1,-1.230914909793327e-1,7.356123579206246e-2,-3.289758474798845e-2,
0,0,0,0,0,0,-2.132007163556104e-1,
0,0,0,0,0,7.356123579206245e-2,0,
0,0,0,0,0,2.132007163556104e-1,0,
0,0,0,0,-1.230914909793327e-1,0,0,
0,0,0,0,-1.740776559556978e-1,0,0,
0,0,0,1.740776559556978e-1,0,0,0,
0,0,0,1.230914909793327e-1,0,0,0,
0,0,-2.132007163556104e-1,0,0,0,0,
0,0,-7.356123579206245e-2,0,0,0,0,
0,2.132007163556104e-1,0,0,0,0,0,
0,3.289758474798845e-2,-7.356123579206246e-2,1.230914909793327e-1,-1.740776559556978e-1,2.132007163556104e-1,-2.132007163556104e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,2.773500981126146e-1,-1.961161351381841e-1,1.322214713369863e-1,-8.362420100070907e-2,4.828045495852676e-2,-2.414022747926338e-2,
9.124148357522649e-3,0,0,0,0,0,0,
-1.961161351381841e-1,2.048366225996757e-1,-1.773937187967247e-1,1.365577483997838e-1,-9.349469900084573e-2,5.474489014513589e-2,-2.414022747926338e-2,
0,0,0,0,0,0,1.322214713369863e-1,
-1.773937187967247e-1,1.869893980016914e-1,-1.706971854997297e-1,1.368622253628397e-1,-9.349469900084571e-2,4.828045495852675e-2,0,
0,0,0,0,0,-8.362420100070905e-2,1.365577483997838e-1,
-1.706971854997297e-1,1.824829671504530e-1,-1.706971854997297e-1,1.365577483997838e-1,-8.362420100070905e-2,0,0,
0,0,0,0,4.828045495852675e-2,-9.349469900084571e-2,1.368622253628397e-1,
-1.706971854997297e-1,1.869893980016914e-1,-1.773937187967247e-1,1.322214713369863e-1,0,0,0,
0,0,0,-2.414022747926338e-2,5.474489014513589e-2,-9.349469900084573e-2,1.365577483997838e-1,
-1.773937187967247e-1,2.048366225996757e-1,-1.961161351381841e-1,0,0,0,0,
0,0,9.124148357522649e-3,-2.414022747926338e-2,4.828045495852676e-2,-8.362420100070907e-2,1.322214713369863e-1,
-1.961161351381841e-1,2.773500981126146e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,6.299407883487121e-2,-1.666666666666667e-1,3.333333333333334e-1,0,0,0,
0,0,0,0,0,0,-1.091089451179962e-1,
2.182178902359924e-1,-2.886751345948129e-1,0,0,0,0,0,
0,0,0,0,1.543033499620919e-1,-2.439750182371333e-1,2.439750182371333e-1,
0,0,0,0,0,0,0,
0,0,-1.992047682223990e-1,2.519763153394848e-1,-1.992047682223990e-1,0,0,
0,0,0,0,0,0,0,
2.439750182371333e-1,-2.439750182371333e-1,1.543033499620919e-1,0,0,0,0,
0,0,0,0,0,-2.886751345948129e-1,2.182178902359924e-1,
-1.091089451179962e-1,0,0,0,0,0,0,
0,0,0,3.333333333333334e-1,-1.666666666666667e-1,6.299407883487121e-2,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,6.900655593423542e-2,-1.463850109422800e-1,2.236067977499790e-1,-2.581988897471611e-1,0,0,
0,0,0,0,0,0,-1.259881576697424e-1,
0,0,0,2.108185106778920e-1,0,0,0,
0,0,0,0,1.781741612749496e-1,0,0,
0,-2.357022603955158e-1,0,0,0,0,0,
0,0,-2.182178902359924e-1,0,0,0,2.182178902359924e-1,
0,0,0,0,0,0,0,
2.357022603955158e-1,0,0,0,-1.781741612749496e-1,0,0,
0,0,0,0,0,-2.108185106778919e-1,0,
0,0,1.259881576697424e-1,0,0,0,0,
0,0,0,0,2.581988897471611e-1,-2.236067977499790e-1,1.463850109422800e-1,
-6.900655593423542e-2,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,8.058229640253803e-2,-1.471224715841249e-1,1.973855084879307e-1,-2.132007163556104e-1,1.740776559556978e-1,0,
0,0,0,0,0,0,-1.471224715841249e-1,
0,0,0,0,-2.247332874877474e-1,0,0,
0,0,0,0,1.973855084879307e-1,0,0,
0,0,0,1.740776559556978e-1,0,0,0,
0,0,-2.132007163556104e-1,0,0,0,0,
0,-2.132007163556104e-1,0,0,0,0,0,
1.740776559556978e-1,0,0,0,0,0,1.973855084879307e-1,
0,0,0,0,0,0,-2.247332874877474e-1,
0,0,0,0,-1.471224715841249e-1,0,0,
0,0,0,0,0,1.740776559556978e-1,-2.132007163556104e-1,
1.973855084879307e-1,-1.471224715841249e-1,8.058229640253803e-2,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,1.005037815259212e-1,-1.589104315409320e-1,1.899342940993966e-1,-1.899342940993966e-1,1.589104315409320e-1,-1.005037815259212e-1,
0,0,0,0,0,0,-1.740776559556979e-1,
0,0,0,0,0,1.740776559556979e-1,0,
0,0,0,0,2.059714602177749e-1,0,0,
0,0,0,0,-2.059714602177749e-1,0,0,
0,0,-1.681749930365043e-1,0,0,0,0,
0,0,0,1.681749930365043e-1,0,0,0,
0,2.059714602177749e-1,0,0,0,0,0,
0,-2.059714602177749e-1,0,0,0,0,0,
-1.740776559556979e-1,0,0,0,0,0,1.740776559556979e-1,
0,0,0,0,0,0,1.005037815259212e-1,
-1.589104315409320e-1,1.899342940993966e-1,-1.899342940993966e-1,1.589104315409320e-1,-1.005037815259212e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,1.322214713369863e-1,-1.773937187967247e-1,1.869893980016914e-1,-1.706971854997297e-1,1.368622253628397e-1,-9.349469900084570e-2,
4.828045495852676e-2,0,0,0,0,0,-2.019716336333912e-1,
0,0,0,0,0,0,-1.042977031291240e-1,
0,0,0,0,1.806489209323782e-1,0,0,
0,0,0,0,0,1.615773069067129e-1,0,
0,0,0,-1.978909779672615e-1,0,0,0,
0,0,0,0,-1.978909779672615e-1,0,0,
0,0,1.615773069067129e-1,0,0,0,0,
0,0,0,1.806489209323782e-1,0,0,0,
0,-1.042977031291240e-1,0,0,0,0,0,
0,-2.019716336333912e-1,0,0,0,0,0,
4.828045495852676e-2,-9.349469900084570e-2,1.368622253628397e-1,-1.706971854997297e-1,1.869893980016914e-1,-1.773937187967247e-1,1.322214713369863e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,1.815682598006407e-1,-1.961161351381841e-1,1.773937187967248e-1,-1.448413648755803e-1,1.079583792718826e-1,-7.242068243779015e-2,
4.181210050035454e-2,-1.824829671504530e-2,0,0,0,0,-2.096569673443837e-1,
0,0,0,0,0,0,0,
4.711689951601463e-2,0,0,0,0,1.913897505877382e-1,0,
0,0,0,0,0,0,-8.939803125353483e-2,
0,0,0,0,-1.413506985480439e-1,0,0,
0,0,0,0,0,1.413506985480439e-1,0,
0,0,0,8.939803125353483e-2,0,0,0,
0,0,0,0,-1.913897505877382e-1,0,0,
0,0,-4.711689951601463e-2,0,0,0,0,
0,0,0,2.096569673443837e-1,0,0,0,
0,1.824829671504530e-2,-4.181210050035454e-2,7.242068243779015e-2,-1.079583792718826e-1,1.448413648755803e-1,-1.773937187967248e-1,
1.961161351381841e-1,-1.815682598006407e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,2.080625946441198e-2,-5.504818825631802e-2,1.100963765126361e-1,-1.906925178491184e-1,3.015113445777636e-1,0,
0,0,0,0,0,0,-4.652421051992354e-2,
1.019294382875251e-1,-1.651445647689541e-1,2.201927530252721e-1,-2.335496832484569e-1,0,0,0,
0,0,0,0,8.058229640253801e-2,-1.471224715841249e-1,1.973855084879307e-1,
-2.132007163556104e-1,1.740776559556978e-1,0,0,0,0,0,
0,0,-1.230914909793327e-1,1.860968420796942e-1,-2.080625946441197e-1,1.860968420796942e-1,-1.230914909793327e-1,
0,0,0,0,0,0,0,
1.740776559556978e-1,-2.132007163556104e-1,1.973855084879307e-1,-1.471224715841249e-1,8.058229640253801e-2,0,0,
0,0,0,0,0,-2.335496832484569e-1,2.201927530252721e-1,
-1.651445647689541e-1,1.019294382875251e-1,-4.652421051992355e-2,0,0,0,0,
0,0,0,3.015113445777636e-1,-1.906925178491184e-1,1.100963765126361e-1,-5.504818825631802e-2,
2.080625946441198e-2,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,3.289758474798845e-2,-7.356123579206245e-2,1.230914909793327e-1,-1.740776559556978e-1,2.132007163556104e-1,-2.132007163556104e-1,
0,0,0,0,0,0,-7.356123579206245e-2,
0,0,0,0,0,2.132007163556104e-1,0,
0,0,0,0,1.230914909793327e-1,0,0,
0,0,0,-2.132007163556104e-1,0,0,0,
0,0,-1.740776559556978e-1,0,0,0,0,
0,1.740776559556978e-1,0,0,0,0,0,
2.132007163556104e-1,0,0,0,0,0,-1.230914909793327e-1,
0,0,0,0,0,-2.132007163556104e-1,0,
0,0,0,0,7.356123579206245e-2,0,0,
0,0,0,0,2.132007163556104e-1,-2.132007163556104e-1,1.740776559556978e-1,
-1.230914909793327e-1,7.356123579206246e-2,-3.289758474798845e-2,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,4.828045495852677e-2,-9.349469900084570e-2,1.368622253628397e-1,-1.706971854997297e-1,1.869893980016914e-1,-1.773937187967247e-1,
1.322214713369863e-1,0,0,0,0,0,-1.042977031291240e-1,
0,0,0,0,0,0,-2.019716336333912e-1,
0,0,0,0,1.615773069067129e-1,0,0,
0,0,0,0,0,1.806489209323782e-1,0,
0,0,-1.978909779672615e-1,0,0,0,0,
0,0,0,-1.978909779672614e-1,0,0,0,
1.806489209323782e-1,0,0,0,0,0,0,
0,1.615773069067129e-1,0,0,0,0,-2.019716336333912e-1,
0,0,0,0,0,0,-1.042977031291240e-1,
0,0,0,0,0,1.322214713369863e-1,-1.773937187967247e-1,
1.869893980016914e-1,-1.706971854997297e-1,1.368622253628397e-1,-9.349469900084570e-2,4.828045495852676e-2,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,7.067534927402194e-2,-1.182624791978165e-1,1.526762041381148e-1,-1.706971854997297e-1,1.706971854997297e-1,-1.526762041381148e-1,
1.182624791978165e-1,-7.067534927402194e-2,0,0,0,0,-1.413506985480439e-1,
0,0,0,0,0,0,0,
1.413506985480439e-1,0,0,0,1.896418623723042e-1,0,0,
0,0,0,0,0,0,-1.896418623723042e-1,
0,0,-1.731185431143353e-1,0,0,0,0,
0,0,0,0,0,1.731185431143352e-1,0,
0,1.896418623723042e-1,0,0,0,0,0,
0,0,0,-1.896418623723042e-1,0,0,0,
-1.413506985480439e-1,0,0,0,0,0,0,
0,1.413506985480439e-1,0,0,0,0,7.067534927402193e-2,
-1.182624791978165e-1,1.526762041381148e-1,-1.706971854997297e-1,1.706971854997297e-1,-1.526762041381148e-1,1.182624791978165e-1,-7.067534927402193e-2,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,1.048284836721918e-1,-1.482498633322202e-1,1.672484020014182e-1,-1.672484020014181e-1,1.526762041381148e-1,-1.277380770053171e-1,
9.656090991705352e-2,-6.321395412410140e-2,3.160697706205070e-2,0,0,0,-1.815682598006407e-1,
0,0,0,0,0,0,0,
0,-7.742096611387637e-2,0,0,1.815682598006407e-1,0,0,
0,0,0,0,0,0,0,
1.340970468803023e-1,0,0,-1.815682598006407e-1,0,0,0,
0,0,0,0,0,0,-1.815682598006407e-1,
0,0,1.340970468803023e-1,0,0,0,0,
0,0,0,0,0,1.815682598006407e-1,0,
0,-7.742096611387637e-2,0,0,0,0,0,
0,0,0,-1.815682598006407e-1,0,0,0,
3.160697706205070e-2,-6.321395412410140e-2,9.656090991705352e-2,-1.277380770053171e-1,1.526762041381148e-1,-1.672484020014181e-1,1.672484020014182e-1,
-1.482498633322202e-1,1.048284836721918e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,9.124148357522649e-3,-2.414022747926338e-2,4.828045495852676e-2,-8.362420100070907e-2,1.322214713369863e-1,-1.961161351381841e-1,
2.773500981126146e-1,0,0,0,0,0,-2.414022747926338e-2,
5.474489014513589e-2,-9.349469900084571e-2,1.365577483997838e-1,-1.773937187967248e-1,2.048366225996757e-1,-1.961161351381840e-1,0,
0,0,0,0,4.828045495852676e-2,-9.349469900084571e-2,1.368622253628397e-1,
-1.706971854997297e-1,1.869893980016914e-1,-1.773937187967247e-1,1.322214713369863e-1,0,0,0,
0,0,-8.362420100070907e-2,1.365577483997838e-1,-1.706971854997297e-1,1.824829671504530e-1,-1.706971854997297e-1,
1.365577483997838e-1,-8.362420100070907e-2,0,0,0,0,0,
1.322214713369863e-1,-1.773937187967247e-1,1.869893980016914e-1,-1.706971854997297e-1,1.368622253628397e-1,-9.349469900084571e-2,4.828045495852675e-2,
0,0,0,0,0,-1.961161351381841e-1,2.048366225996757e-1,
-1.773937187967247e-1,1.365577483997838e-1,-9.349469900084573e-2,5.474489014513589e-2,-2.414022747926338e-2,0,0,
0,0,0,2.773500981126146e-1,-1.961161351381841e-1,1.322214713369863e-1,-8.362420100070907e-2,
4.828045495852676e-2,-2.414022747926338e-2,9.124148357522649e-3,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,1.824829671504530e-2,-4.181210050035455e-2,7.242068243779015e-2,-1.079583792718826e-1,1.448413648755803e-1,-1.773937187967248e-1,
1.961161351381840e-1,-1.815682598006407e-1,0,0,0,0,-4.711689951601463e-2,
0,0,0,0,0,0,0,
2.096569673443837e-1,0,0,0,8.939803125353483e-2,0,0,
0,0,0,0,0,-1.913897505877382e-1,0,
0,0,-1.413506985480439e-1,0,0,0,0,
0,0,0,1.413506985480439e-1,0,0,0,
1.913897505877382e-1,0,0,0,0,0,0,
0,-8.939803125353483e-2,0,0,0,-2.096569673443837e-1,0,
0,0,0,0,0,0,4.711689951601463e-2,
0,0,0,0,1.815682598006407e-1,-1.961161351381841e-1,1.773937187967248e-1,
-1.448413648755803e-1,1.079583792718826e-1,-7.242068243779015e-2,4.181210050035454e-2,-1.824829671504530e-2,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,3.160697706205070e-2,-6.321395412410140e-2,9.656090991705353e-2,-1.277380770053171e-1,1.526762041381148e-1,-1.672484020014181e-1,
1.672484020014181e-1,-1.482498633322202e-1,1.048284836721918e-1,0,0,0,-7.742096611387637e-2,
0,0,0,0,0,0,0,
0,-1.815682598006407e-1,0,0,1.340970468803023e-1,0,0,
0,0,0,0,0,0,0,
1.815682598006407e-1,0,-1.815682598006407e-1,0,0,0,0,
0,0,0,0,0,-1.815682598006407e-1,0,
1.815682598006407e-1,0,0,0,0,0,0,
0,0,0,1.340970468803023e-1,0,0,-1.815682598006407e-1,
0,0,0,0,0,0,0,
0,-7.742096611387637e-2,0,0,0,1.048284836721918e-1,-1.482498633322202e-1,
1.672484020014182e-1,-1.672484020014181e-1,1.526762041381148e-1,-1.277380770053171e-1,9.656090991705352e-2,-6.321395412410140e-2,3.160697706205070e-2,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,5.241424183609591e-2,-9.078412990032034e-2,1.224132957852822e-1,-1.448413648755803e-1,1.564465546936860e-1,-1.564465546936859e-1,
1.448413648755803e-1,-1.224132957852822e-1,9.078412990032034e-2,-5.241424183609591e-2,0,0,-1.172018077346239e-1,
0,0,0,0,0,0,0,
0,0,1.172018077346239e-1,0,1.738383738412788e-1,0,0,
0,0,0,0,0,0,0,
0,-1.738383738412788e-1,-1.738383738412788e-1,0,0,0,0,
0,0,0,0,0,0,0,
1.738383738412788e-1,1.738383738412788e-1,0,0,0,0,0,
0,0,0,0,0,-1.738383738412788e-1,0,
-1.172018077346239e-1,0,0,0,0,0,0,
0,0,0,1.172018077346239e-1,0,0,5.241424183609590e-2,
-9.078412990032032e-2,1.224132957852822e-1,-1.448413648755802e-1,1.564465546936859e-1,-1.564465546936859e-1,1.448413648755802e-1,-1.224132957852822e-1,
9.078412990032032e-2,-5.241424183609590e-2,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,3.333333333333333e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,-3.333333333333333e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,3.333333333333334e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
-3.333333333333333e-1,0,0,0,0,0,0,
0,0,0,0,0,0,3.333333333333333e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,-3.333333333333333e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,3.333333333333334e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,-3.333333333333333e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,3.333333333333333e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,3.333333333333334e-1,0,0,0,
0,0,0,0,0,0,0,
0,-1.666666666666667e-1,-2.886751345948129e-1,0,0,0,0,
0,0,0,0,0,0,6.299407883487121e-2,
2.182178902359924e-1,2.439750182371333e-1,0,0,0,0,0,
0,0,0,0,0,-1.091089451179962e-1,-2.439750182371333e-1,
-1.992047682223990e-1,0,0,0,0,0,0,
0,0,0,0,1.543033499620919e-1,2.519763153394848e-1,1.543033499620919e-1,
0,0,0,0,0,0,0,
0,0,0,-1.992047682223990e-1,-2.439750182371333e-1,-1.091089451179962e-1,0,
0,0,0,0,0,0,0,
0,0,2.439750182371333e-1,2.182178902359924e-1,6.299407883487121e-2,0,0,
0,0,0,0,0,0,0,
0,-2.886751345948129e-1,-1.666666666666667e-1,0,0,0,0,
0,0,0,0,0,0,0,
3.333333333333334e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,2.981423969999720e-1,-1.490711984999860e-1,0,0,
0,0,0,0,0,0,0,
0,-1.490711984999860e-1,0,1.972026594366539e-1,0,0,0,
0,0,0,0,0,0,0,
1.972026594366539e-1,0,-2.236067977499790e-1,0,0,0,0,
0,0,0,0,0,0,-2.236067977499790e-1,
0,2.357022603955159e-1,0,0,0,0,0,
0,0,0,0,0,2.357022603955159e-1,0,
-2.357022603955159e-1,0,0,0,0,0,0,
0,0,0,0,-2.357022603955159e-1,0,2.236067977499790e-1,
0,0,0,0,0,0,0,
0,0,0,2.236067977499790e-1,0,-1.972026594366539e-1,0,
0,0,0,0,0,0,0,
0,0,-1.972026594366539e-1,0,1.490711984999860e-1,0,0,
0,0,0,0,0,0,0,
0,1.490711984999860e-1,-2.981423969999720e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,3.015113445777636e-1,-1.348399724926484e-1,4.494665749754947e-2,0,
0,0,0,0,0,0,0,
0,0,-2.696799449852968e-1,1.797866299901979e-1,-7.784989441615231e-2,0,0,
0,0,0,0,0,0,0,
0,2.378353560042253e-1,-2.059714602177749e-1,1.100963765126361e-1,0,0,0,
0,0,0,0,0,0,0,
-2.059714602177749e-1,2.201927530252721e-1,-1.421338109037403e-1,0,0,0,0,
0,0,0,0,0,0,1.740776559556978e-1,
-2.247332874877473e-1,1.740776559556978e-1,0,0,0,0,0,
0,0,0,0,0,-1.421338109037403e-1,2.201927530252721e-1,
-2.059714602177749e-1,0,0,0,0,0,0,
0,0,0,0,1.100963765126361e-1,-2.059714602177749e-1,2.378353560042253e-1,
0,0,0,0,0,0,0,
0,0,0,-7.784989441615231e-2,1.797866299901979e-1,-2.696799449852968e-1,0,
0,0,0,0,0,0,0,
0,0,4.494665749754947e-2,-1.348399724926484e-1,3.015113445777636e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,3.333333333333333e-1,0,0,0,
0,0,0,0,0,0,0,
0,-2.357022603955159e-1,-2.357022603955159e-1,0,0,0,0,
0,0,0,0,0,0,1.543033499620919e-1,
2.519763153394848e-1,1.543033499620919e-1,0,0,0,0,0,
0,0,0,0,-8.908708063747479e-2,-2.182178902359924e-1,-2.182178902359924e-1,
-8.908708063747479e-2,0,0,0,0,0,0,
0,0,3.984095364447979e-2,1.593638145779191e-1,2.390457218668787e-1,1.593638145779191e-1,3.984095364447979e-2,
0,0,0,0,0,0,0,
0,-8.908708063747479e-2,-2.182178902359924e-1,-2.182178902359924e-1,-8.908708063747479e-2,0,0,
0,0,0,0,0,0,0,
1.543033499620919e-1,2.519763153394848e-1,1.543033499620919e-1,0,0,0,0,
0,0,0,0,0,0,-2.357022603955159e-1,
-2.357022603955159e-1,0,0,0,0,0,0,
0,0,0,0,0,3.333333333333333e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,2.581988897471611e-1,-2.108185106778919e-1,0,0,
0,0,0,0,0,0,0,
0,-2.236067977499790e-1,0,2.357022603955158e-1,0,0,0,
0,0,0,0,0,0,1.463850109422800e-1,
0,0,-2.182178902359924e-1,0,0,0,0,
0,0,0,0,-6.900655593423542e-2,0,0,
0,1.781741612749496e-1,0,0,0,0,0,
0,0,0,1.259881576697424e-1,0,0,0,
-1.259881576697424e-1,0,0,0,0,0,0,
0,0,-1.781741612749496e-1,0,0,0,6.900655593423542e-2,
0,0,0,0,0,0,0,
0,2.182178902359924e-1,0,0,-1.463850109422800e-1,0,0,
0,0,0,0,0,0,0,
-2.357022603955158e-1,0,2.236067977499790e-1,0,0,0,0,
0,0,0,0,0,0,2.108185106778919e-1,
-2.581988897471611e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,2.378353560042253e-1,-2.059714602177749e-1,1.100963765126361e-1,0,
0,0,0,0,0,0,0,
0,-2.059714602177749e-1,0,0,-1.651445647689541e-1,0,0,
0,0,0,0,0,0,1.100963765126361e-1,
0,0,0,1.973855084879307e-1,0,0,0,
0,0,0,0,0,-1.651445647689541e-1,0,
0,0,-2.080625946441197e-1,0,0,0,0,
0,0,0,0,1.973855084879307e-1,0,0,
0,1.973855084879307e-1,0,0,0,0,0,
0,0,0,-2.080625946441197e-1,0,0,0,
-1.651445647689541e-1,0,0,0,0,0,0,
0,0,1.973855084879307e-1,0,0,0,1.100963765126361e-1,
0,0,0,0,0,0,0,
0,-1.651445647689541e-1,0,0,-2.059714602177749e-1,0,0,
0,0,0,0,0,0,0,
1.100963765126361e-1,-2.059714602177749e-1,2.378353560042253e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,2.461829819586654e-1,-1.906925178491184e-1,1.100963765126361e-1,-4.494665749754947e-2,
0,0,0,0,0,0,0,
0,-1.740776559556978e-1,0,0,0,8.408749651825216e-2,0,
0,0,0,0,0,0,0,
2.059714602177749e-1,0,0,0,-1.230914909793327e-1,0,0,
0,0,0,0,0,0,-2.059714602177748e-1,
0,0,0,1.589104315409320e-1,0,0,0,
0,0,0,0,0,1.880253582725887e-1,0,
0,0,-1.880253582725887e-1,0,0,0,0,
0,0,0,0,-1.589104315409320e-1,0,0,
0,2.059714602177748e-1,0,0,0,0,0,
0,0,0,1.230914909793327e-1,0,0,0,
-2.059714602177749e-1,0,0,0,0,0,0,
0,0,-8.408749651825216e-2,0,0,0,1.740776559556978e-1,
0,0,0,0,0,0,0,
0,4.494665749754947e-2,-1.100963765126361e-1,1.906925178491184e-1,-2.461829819586654e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,2.773500981126146e-1,-1.601281538050871e-1,8.362420100070908e-2,-3.739787960033829e-2,
1.246595986677943e-2,0,0,0,0,0,0,
0,0,-2.264554068289192e-1,1.931218198341070e-1,-1.295500551262591e-1,7.051811804639270e-2,-2.787473366690303e-2,
0,0,0,0,0,0,0,
0,1.806489209323782e-1,-1.978909779672615e-1,1.615773069067130e-1,-1.042977031291240e-1,4.828045495852677e-2,0,
0,0,0,0,0,0,0,
-1.399300524562882e-1,1.865734032750510e-1,-1.806489209323782e-1,1.365577483997838e-1,-7.374961314478497e-2,0,0,
0,0,0,0,0,0,1.042977031291240e-1,
-1.649091483060512e-1,1.869893980016915e-1,-1.649091483060512e-1,1.042977031291240e-1,0,0,0,
0,0,0,0,0,-7.374961314478497e-2,1.365577483997838e-1,
-1.806489209323782e-1,1.865734032750510e-1,-1.399300524562882e-1,0,0,0,0,
0,0,0,0,4.828045495852677e-2,-1.042977031291240e-1,1.615773069067130e-1,
-1.978909779672615e-1,1.806489209323782e-1,0,0,0,0,0,
0,0,0,-2.787473366690303e-2,7.051811804639270e-2,-1.295500551262591e-1,1.931218198341070e-1,
-2.264554068289192e-1,0,0,0,0,0,0,
0,0,1.246595986677943e-2,-3.739787960033829e-2,8.362420100070908e-2,-1.601281538050871e-1,2.773500981126146e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,3.333333333333334e-1,0,0,0,
0,0,0,0,0,0,0,
0,-2.886751345948129e-1,-1.666666666666667e-1,0,0,0,0,
0,0,0,0,0,0,2.439750182371333e-1,
2.182178902359924e-1,6.299407883487121e-2,0,0,0,0,0,
0,0,0,0,-1.992047682223990e-1,-2.439750182371333e-1,-1.091089451179962e-1,
0,0,0,0,0,0,0,
0,0,1.543033499620919e-1,2.519763153394848e-1,1.543033499620919e-1,0,0,
0,0,0,0,0,0,0,
-1.091089451179962e-1,-2.439750182371333e-1,-1.992047682223990e-1,0,0,0,0,
0,0,0,0,0,6.299407883487121e-2,2.182178902359924e-1,
2.439750182371333e-1,0,0,0,0,0,0,
0,0,0,0,-1.666666666666667e-1,-2.886751345948129e-1,0,
0,0,0,0,0,0,0,
0,0,0,3.333333333333334e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,2.108185106778920e-1,-2.581988897471611e-1,0,0,
0,0,0,0,0,0,0,
0,-2.357022603955158e-1,0,2.236067977499790e-1,0,0,0,
0,0,0,0,0,0,2.182178902359924e-1,
0,0,-1.463850109422800e-1,0,0,0,0,
0,0,0,0,-1.781741612749496e-1,0,0,
0,6.900655593423542e-2,0,0,0,0,0,
0,0,1.259881576697424e-1,0,0,0,-1.259881576697424e-1,
0,0,0,0,0,0,0,
-6.900655593423542e-2,0,0,0,1.781741612749496e-1,0,0,
0,0,0,0,0,0,1.463850109422800e-1,
0,0,-2.182178902359924e-1,0,0,0,0,
0,0,0,0,0,-2.236067977499790e-1,0,
2.357022603955158e-1,0,0,0,0,0,0,
0,0,0,0,2.581988897471611e-1,-2.108185106778919e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,1.740776559556978e-1,-2.247332874877474e-1,1.740776559556978e-1,0,
0,0,0,0,0,0,0,
0,-2.132007163556104e-1,0,0,-2.132007163556104e-1,0,0,
0,0,0,0,0,0,1.973855084879307e-1,
0,0,0,1.973855084879307e-1,0,0,0,
0,0,0,0,-1.471224715841249e-1,0,0,
0,0,-1.471224715841249e-1,0,0,0,0,
0,0,8.058229640253803e-2,0,0,0,0,
0,8.058229640253803e-2,0,0,0,0,0,
0,-1.471224715841249e-1,0,0,0,0,-1.471224715841249e-1,
0,0,0,0,0,0,0,
1.973855084879307e-1,0,0,0,1.973855084879307e-1,0,0,
0,0,0,0,0,0,-2.132007163556104e-1,
0,0,-2.132007163556104e-1,0,0,0,0,
0,0,0,0,0,1.740776559556978e-1,-2.247332874877474e-1,
1.740776559556978e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,1.681749930365043e-1,-2.059714602177749e-1,1.740776559556979e-1,-1.005037815259212e-1,
0,0,0,0,0,0,0,
0,-2.059714602177749e-1,0,0,0,1.589104315409320e-1,0,
0,0,0,0,0,0,1.740776559556979e-1,
0,0,0,0,-1.899342940993966e-1,0,0,
0,0,0,0,-1.005037815259212e-1,0,0,
0,0,0,1.899342940993966e-1,0,0,0,
0,0,0,1.589104315409320e-1,0,0,0,
0,0,-1.589104315409320e-1,0,0,0,0,
0,0,-1.899342940993966e-1,0,0,0,0,
0,1.005037815259212e-1,0,0,0,0,0,
0,1.899342940993966e-1,0,0,0,0,-1.740776559556979e-1,
0,0,0,0,0,0,0,
-1.589104315409320e-1,0,0,0,2.059714602177749e-1,0,0,
0,0,0,0,0,0,1.005037815259212e-1,
-1.740776559556979e-1,2.059714602177749e-1,-1.681749930365043e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,1.806489209323782e-1,-1.978909779672615e-1,1.615773069067129e-1,-1.042977031291240e-1,
4.828045495852677e-2,0,0,0,0,0,0,
0,-2.019716336333912e-1,0,0,0,0,-9.349469900084571e-2,
0,0,0,0,0,0,1.322214713369863e-1,
0,0,0,0,0,1.368622253628397e-1,0,
0,0,0,0,0,-1.773937187967247e-1,0,
0,0,0,0,-1.706971854997297e-1,0,0,
0,0,0,0,1.869893980016914e-1,0,0,
0,0,0,1.869893980016914e-1,0,0,0,
0,0,0,-1.706971854997297e-1,0,0,0,
0,0,-1.773937187967247e-1,0,0,0,0,
0,0,1.368622253628397e-1,0,0,0,0,
0,1.322214713369863e-1,0,0,0,0,0,
0,-9.349469900084571e-2,0,0,0,0,-2.019716336333912e-1,
0,0,0,0,0,0,0,
4.828045495852677e-2,-1.042977031291240e-1,1.615773069067129e-1,-1.978909779672615e-1,1.806489209323782e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,2.096569673443837e-1,-1.913897505877382e-1,1.413506985480439e-1,-8.939803125353485e-2,
4.711689951601464e-2,-1.824829671504530e-2,0,0,0,0,0,
0,-1.815682598006407e-1,0,0,0,0,0,
4.181210050035455e-2,0,0,0,0,0,0,
1.961161351381841e-1,0,0,0,0,0,-7.242068243779015e-2,
0,0,0,0,0,0,-1.773937187967248e-1,
0,0,0,0,0,1.079583792718826e-1,0,
0,0,0,0,0,1.448413648755803e-1,0,
0,0,0,0,-1.448413648755803e-1,0,0,
0,0,0,0,-1.079583792718826e-1,0,0,
0,0,0,1.773937187967248e-1,0,0,0,
0,0,0,7.242068243779015e-2,0,0,0,
0,0,-1.961161351381841e-1,0,0,0,0,
0,0,-4.181210050035455e-2,0,0,0,0,
0,1.815682598006407e-1,0,0,0,0,0,
0,1.824829671504530e-2,-4.711689951601464e-2,8.939803125353485e-2,-1.413506985480439e-1,1.913897505877382e-1,-2.096569673443837e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,3.333333333333333e-1,0,0,0,
0,0,0,0,0,0,0,
0,-3.333333333333333e-1,0,0,0,0,0,
0,0,0,0,0,0,3.333333333333334e-1,
0,0,0,0,0,0,0,
0,0,0,0,-3.333333333333334e-1,0,0,
0,0,0,0,0,0,0,
0,0,3.333333333333333e-1,0,0,0,0,
0,0,0,0,0,0,0,
-3.333333333333333e-1,0,0,0,0,0,0,
0,0,0,0,0,3.333333333333334e-1,0,
0,0,0,0,0,0,0,
0,0,0,-3.333333333333333e-1,0,0,0,
0,0,0,0,0,0,0,
0,3.333333333333333e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,1.490711984999860e-1,-2.981423969999720e-1,0,0,
0,0,0,0,0,0,0,
0,-1.972026594366539e-1,0,1.490711984999860e-1,0,0,0,
0,0,0,0,0,0,2.236067977499790e-1,
0,-1.972026594366539e-1,0,0,0,0,0,
0,0,0,0,-2.357022603955159e-1,0,2.236067977499790e-1,
0,0,0,0,0,0,0,
0,0,2.357022603955159e-1,0,-2.357022603955159e-1,0,0,
0,0,0,0,0,0,0,
-2.236067977499790e-1,0,2.357022603955159e-1,0,0,0,0,
0,0,0,0,0,1.972026594366539e-1,0,
-2.236067977499790e-1,0,0,0,0,0,0,
0,0,0,-1.490711984999860e-1,0,1.972026594366539e-1,0,
0,0,0,0,0,0,0,
0,0,2.981423969999720e-1,-1.490711984999860e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,1.100963765126361e-1,-2.059714602177749e-1,2.378353560042253e-1,0,
0,0,0,0,0,0,0,
0,-1.651445647689541e-1,0,0,-2.059714602177749e-1,0,0,
0,0,0,0,0,0,1.973855084879307e-1,
0,0,0,1.100963765126361e-1,0,0,0,
0,0,0,0,-2.080625946441197e-1,0,0,
0,-1.651445647689541e-1,0,0,0,0,0,
0,0,1.973855084879307e-1,0,0,0,1.973855084879307e-1,
0,0,0,0,0,0,0,
-1.651445647689541e-1,0,0,0,-2.080625946441197e-1,0,0,
0,0,0,0,0,1.100963765126361e-1,0,
0,0,1.973855084879307e-1,0,0,0,0,
0,0,0,0,-2.059714602177749e-1,0,0,
-1.651445647689541e-1,0,0,0,0,0,0,
0,0,0,2.378353560042253e-1,-2.059714602177749e-1,1.100963765126361e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,1.005037815259212e-1,-1.740776559556979e-1,2.059714602177749e-1,-1.681749930365043e-1,
0,0,0,0,0,0,0,
0,-1.589104315409320e-1,0,0,0,2.059714602177749e-1,0,
0,0,0,0,0,0,1.899342940993966e-1,
0,0,0,0,-1.740776559556979e-1,0,0,
0,0,0,0,-1.899342940993966e-1,0,0,
0,0,0,1.005037815259212e-1,0,0,0,
0,0,1.589104315409320e-1,0,0,0,0,
0,-1.589104315409320e-1,0,0,0,0,0,
-1.005037815259212e-1,0,0,0,0,0,1.899342940993966e-1,
0,0,0,0,0,0,1.740776559556979e-1,
0,0,0,0,-1.899342940993966e-1,0,0,
0,0,0,0,0,-2.059714602177749e-1,0,
0,0,1.589104315409320e-1,0,0,0,0,
0,0,0,0,1.681749930365043e-1,-2.059714602177749e-1,1.740776559556979e-1,
-1.005037815259212e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,1.042977031291240e-1,-1.649091483060512e-1,1.869893980016914e-1,-1.649091483060512e-1,
1.042977031291240e-1,0,0,0,0,0,0,
0,-1.649091483060512e-1,0,0,0,0,-1.649091483060512e-1,
0,0,0,0,0,0,1.869893980016914e-1,
0,0,0,0,0,1.869893980016914e-1,0,
0,0,0,0,-1.649091483060512e-1,0,0,
0,0,0,0,-1.649091483060512e-1,0,0,
0,0,1.042977031291240e-1,0,0,0,0,
0,0,0,1.042977031291240e-1,0,0,0,
0,-1.649091483060512e-1,0,0,0,0,0,
0,-1.649091483060512e-1,0,0,0,0,0,
1.869893980016914e-1,0,0,0,0,0,1.869893980016914e-1,
0,0,0,0,0,0,-1.649091483060512e-1,
0,0,0,0,-1.649091483060512e-1,0,0,
0,0,0,0,0,1.042977031291240e-1,-1.649091483060512e-1,
1.869893980016914e-1,-1.649091483060512e-1,1.042977031291240e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,1.182624791978165e-1,-1.672484020014182e-1,1.762952951159817e-1,-1.526762041381148e-1,
1.079583792718826e-1,-5.574946733380606e-2,0,0,0,0,0,
0,-1.773937187967248e-1,0,0,0,0,0,
1.079583792718826e-1,0,0,0,0,0,1.773937187967248e-1,
0,0,0,0,0,0,-1.526762041381148e-1,
0,0,0,0,-1.182624791978165e-1,0,0,
0,0,0,0,0,1.762952951159817e-1,0,
0,0,0,1.672484020014182e-1,0,0,0,
0,0,0,0,-1.672484020014182e-1,0,0,
0,0,-1.762952951159817e-1,0,0,0,0,
0,0,0,1.182624791978165e-1,0,0,0,
0,1.526762041381148e-1,0,0,0,0,0,
0,-1.773937187967248e-1,0,0,0,0,0,
-1.079583792718826e-1,0,0,0,0,0,1.773937187967248e-1,
0,0,0,0,0,0,5.574946733380606e-2,
-1.079583792718826e-1,1.526762041381149e-1,-1.762952951159817e-1,1.672484020014182e-1,-1.182624791978165e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,1.432229748078866e-1,-1.754116038614059e-1,1.672484020014182e-1,-1.365577483997838e-1,
9.656090991705352e-2,-5.712620469979836e-2,2.493191973355886e-2,0,0,0,0,
0,-1.894661866862684e-1,0,0,0,0,0,
0,-5.712620469979835e-2,0,0,0,0,1.432229748078866e-1,
0,0,0,0,0,0,0,
9.656090991705350e-2,0,0,0,0,-1.754116038614059e-1,0,
0,0,0,0,0,0,-1.365577483997837e-1,
0,0,0,0,1.672484020014182e-1,0,0,
0,0,0,0,0,1.672484020014182e-1,0,
0,0,0,-1.365577483997837e-1,0,0,0,
0,0,0,0,-1.754116038614059e-1,0,0,
0,0,9.656090991705350e-2,0,0,0,0,
0,0,0,1.432229748078866e-1,0,0,0,
0,-5.712620469979835e-2,0,0,0,0,0,
0,-1.894661866862684e-1,0,0,0,0,0,
2.493191973355886e-2,-5.712620469979836e-2,9.656090991705352e-2,-1.365577483997838e-1,1.672484020014182e-1,-1.754116038614059e-1,1.432229748078866e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,4.494665749754947e-2,-1.348399724926484e-1,3.015113445777636e-1,0,
0,0,0,0,0,0,0,
0,-7.784989441615231e-2,1.797866299901979e-1,-2.696799449852968e-1,0,0,0,
0,0,0,0,0,0,1.100963765126361e-1,
-2.059714602177749e-1,2.378353560042253e-1,0,0,0,0,0,
0,0,0,0,-1.421338109037403e-1,2.201927530252721e-1,-2.059714602177749e-1,
0,0,0,0,0,0,0,
0,0,1.740776559556978e-1,-2.247332874877473e-1,1.740776559556978e-1,0,0,
0,0,0,0,0,0,0,
-2.059714602177749e-1,2.201927530252721e-1,-1.421338109037403e-1,0,0,0,0,
0,0,0,0,0,2.378353560042253e-1,-2.059714602177749e-1,
1.100963765126361e-1,0,0,0,0,0,0,
0,0,0,-2.696799449852968e-1,1.797866299901979e-1,-7.784989441615231e-2,0,
0,0,0,0,0,0,0,
0,3.015113445777636e-1,-1.348399724926484e-1,4.494665749754947e-2,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,4.494665749754947e-2,-1.100963765126361e-1,1.906925178491184e-1,-2.461829819586654e-1,
0,0,0,0,0,0,0,
0,-8.408749651825216e-2,0,0,0,1.740776559556978e-1,0,
0,0,0,0,0,0,1.230914909793327e-1,
0,0,0,-2.059714602177749e-1,0,0,0,
0,0,0,0,-1.589104315409320e-1,0,0,
0,2.059714602177749e-1,0,0,0,0,0,
0,0,1.880253582725887e-1,0,0,0,-1.880253582725887e-1,
0,0,0,0,0,0,0,
-2.059714602177748e-1,0,0,0,1.589104315409320e-1,0,0,
0,0,0,0,0,2.059714602177749e-1,0,
0,0,-1.230914909793327e-1,0,0,0,0,
0,0,0,-1.740776559556978e-1,0,0,0,
8.408749651825216e-2,0,0,0,0,0,0,
0,0,2.461829819586654e-1,-1.906925178491184e-1,1.100963765126361e-1,-4.494665749754947e-2,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,4.828045495852677e-2,-1.042977031291240e-1,1.615773069067129e-1,-1.978909779672615e-1,
1.806489209323782e-1,0,0,0,0,0,0,
0,-9.349469900084570e-2,0,0,0,0,-2.019716336333912e-1,
0,0,0,0,0,0,1.368622253628397e-1,
0,0,0,0,0,1.322214713369863e-1,0,
0,0,0,0,-1.706971854997297e-1,0,0,
0,0,0,-1.773937187967248e-1,0,0,0,
0,0,1.869893980016914e-1,0,0,0,0,
0,1.869893980016914e-1,0,0,0,0,0,
-1.773937187967247e-1,0,0,0,0,0,-1.706971854997297e-1,
0,0,0,0,0,1.322214713369863e-1,0,
0,0,0,0,1.368622253628397e-1,0,0,
0,0,0,0,-2.019716336333912e-1,0,0,
0,0,-9.349469900084571e-2,0,0,0,0,
0,0,0,1.806489209323782e-1,-1.978909779672615e-1,1.615773069067129e-1,-1.042977031291240e-1,
4.828045495852677e-2,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,5.574946733380607e-2,-1.079583792718826e-1,1.526762041381149e-1,-1.762952951159817e-1,
1.672484020014182e-1,-1.182624791978166e-1,0,0,0,0,0,
0,-1.079583792718826e-1,0,0,0,0,0,
1.773937187967248e-1,0,0,0,0,0,1.526762041381148e-1,
0,0,0,0,0,0,-1.773937187967248e-1,
0,0,0,0,-1.762952951159817e-1,0,0,
0,0,0,0,0,1.182624791978165e-1,0,
0,0,1.672484020014182e-1,0,0,0,0,
0,0,0,-1.672484020014182e-1,0,0,0,
-1.182624791978166e-1,0,0,0,0,0,0,
0,1.762952951159817e-1,0,0,0,0,1.773937187967248e-1,
0,0,0,0,0,0,-1.526762041381148e-1,
0,0,0,0,0,-1.773937187967248e-1,0,
0,0,0,0,1.079583792718826e-1,0,0,
0,0,0,0,1.182624791978165e-1,-1.672484020014182e-1,1.762952951159817e-1,
-1.526762041381149e-1,1.079583792718826e-1,-5.574946733380606e-2,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,6.827887419989188e-2,-1.182624791978165e-1,1.526762041381148e-1,-1.649091483060512e-1,
1.526762041381148e-1,-1.182624791978165e-1,6.827887419989188e-2,0,0,0,0,
0,-1.277380770053171e-1,0,0,0,0,0,
0,-1.277380770053171e-1,0,0,0,0,1.672484020014182e-1,
0,0,0,0,0,0,0,
1.672484020014181e-1,0,0,0,-1.672484020014181e-1,0,0,
0,0,0,0,0,0,-1.672484020014181e-1,
0,0,1.182624791978165e-1,0,0,0,0,
0,0,0,0,0,1.182624791978165e-1,0,
0,-1.672484020014181e-1,0,0,0,0,0,
0,0,0,-1.672484020014181e-1,0,0,0,
1.672484020014182e-1,0,0,0,0,0,0,
0,1.672484020014182e-1,0,0,0,0,-1.277380770053171e-1,
0,0,0,0,0,0,-1.277380770053171e-1,
0,0,0,0,0,6.827887419989187e-2,-1.182624791978165e-1,
1.526762041381148e-1,-1.649091483060512e-1,1.526762041381148e-1,-1.182624791978165e-1,6.827887419989187e-2,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,8.770580193070292e-2,-1.339728254114167e-1,1.564465546936859e-1,-1.564465546936859e-1,
1.379728923974526e-1,-1.068733428966804e-1,6.996502622814411e-2,-3.413943709994594e-2,0,0,0,
0,-1.519109050625500e-1,0,0,0,0,0,
0,0,7.633810206905740e-2,0,0,0,1.722507755289644e-1,
0,0,0,0,0,0,0,
0,-1.224132957852822e-1,0,0,-1.283881477532739e-1,0,0,
0,0,0,0,0,0,0,
1.580348853102534e-1,0,0,1.657483860329489e-1,0,0,0,
0,0,0,0,0,0,-1.657483860329489e-1,
0,0,-1.580348853102535e-1,0,0,0,0,
0,0,0,0,0,1.283881477532739e-1,0,
0,1.224132957852822e-1,0,0,0,0,0,
0,0,0,-1.722507755289644e-1,0,0,0,
-7.633810206905739e-2,0,0,0,0,0,0,
0,1.519109050625500e-1,0,0,0,0,3.413943709994594e-2,
-6.996502622814411e-2,1.068733428966804e-1,-1.379728923974526e-1,1.564465546936860e-1,-1.564465546936859e-1,1.339728254114167e-1,-8.770580193070292e-2,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,1.246595986677943e-2,-3.739787960033828e-2,8.362420100070908e-2,-1.601281538050872e-1,
2.773500981126146e-1,0,0,0,0,0,0,
0,-2.787473366690302e-2,7.051811804639269e-2,-1.295500551262591e-1,1.931218198341071e-1,-2.264554068289192e-1,0,
0,0,0,0,0,0,4.828045495852677e-2,
-1.042977031291240e-1,1.615773069067130e-1,-1.978909779672615e-1,1.806489209323782e-1,0,0,0,
0,0,0,0,-7.374961314478497e-2,1.365577483997838e-1,-1.806489209323782e-1,
1.865734032750510e-1,-1.399300524562883e-1,0,0,0,0,0,
0,0,1.042977031291240e-1,-1.649091483060512e-1,1.869893980016915e-1,-1.649091483060512e-1,1.042977031291240e-1,
0,0,0,0,0,0,0,
-1.399300524562882e-1,1.865734032750510e-1,-1.806489209323782e-1,1.365577483997838e-1,-7.374961314478495e-2,0,0,
0,0,0,0,0,1.806489209323782e-1,-1.978909779672615e-1,
1.615773069067130e-1,-1.042977031291240e-1,4.828045495852677e-2,0,0,0,0,
0,0,0,-2.264554068289192e-1,1.931218198341070e-1,-1.295500551262591e-1,7.051811804639270e-2,
-2.787473366690303e-2,0,0,0,0,0,0,
0,2.773500981126146e-1,-1.601281538050871e-1,8.362420100070908e-2,-3.739787960033829e-2,1.246595986677943e-2,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,1.824829671504530e-2,-4.711689951601463e-2,8.939803125353483e-2,-1.413506985480439e-1,
1.913897505877382e-1,-2.096569673443837e-1,0,0,0,0,0,
0,-4.181210050035455e-2,0,0,0,0,0,
1.815682598006407e-1,0,0,0,0,0,7.242068243779015e-2,
0,0,0,0,0,-1.961161351381841e-1,0,
0,0,0,0,-1.079583792718826e-1,0,0,
0,0,0,1.773937187967248e-1,0,0,0,
0,0,1.448413648755803e-1,0,0,0,0,
0,-1.448413648755803e-1,0,0,0,0,0,
-1.773937187967248e-1,0,0,0,0,0,1.079583792718826e-1,
0,0,0,0,0,1.961161351381841e-1,0,
0,0,0,0,-7.242068243779015e-2,0,0,
0,0,0,-1.815682598006407e-1,0,0,0,
0,0,4.181210050035455e-2,0,0,0,0,
0,0,2.096569673443837e-1,-1.913897505877382e-1,1.413506985480439e-1,-8.939803125353485e-2,4.711689951601464e-2,
-1.824829671504530e-2,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,2.493191973355886e-2,-5.712620469979836e-2,9.656090991705352e-2,-1.365577483997838e-1,
1.672484020014182e-1,-1.754116038614059e-1,1.432229748078866e-1,0,0,0,0,
0,-5.712620469979836e-2,0,0,0,0,0,
0,-1.894661866862684e-1,0,0,0,0,9.656090991705352e-2,
0,0,0,0,0,0,0,
1.432229748078866e-1,0,0,0,-1.365577483997838e-1,0,0,
0,0,0,0,0,-1.754116038614058e-1,0,
0,0,1.672484020014182e-1,0,0,0,0,
0,0,0,1.672484020014181e-1,0,0,0,
-1.754116038614059e-1,0,0,0,0,0,0,
0,-1.365577483997838e-1,0,0,0,1.432229748078866e-1,0,
0,0,0,0,0,0,9.656090991705350e-2,
0,0,0,0,-1.894661866862684e-1,0,0,
0,0,0,0,-5.712620469979835e-2,0,0,
0,0,0,1.432229748078866e-1,-1.754116038614059e-1,1.672484020014182e-1,-1.365577483997838e-1,
9.656090991705352e-2,-5.712620469979836e-2,2.493191973355886e-2,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,3.413943709994595e-2,-6.996502622814413e-2,1.068733428966804e-1,-1.379728923974526e-1,
1.564465546936860e-1,-1.564465546936860e-1,1.339728254114167e-1,-8.770580193070293e-2,0,0,0,
0,-7.633810206905740e-2,0,0,0,0,0,
0,0,1.519109050625500e-1,0,0,0,1.224132957852822e-1,
0,0,0,0,0,0,0,
0,-1.722507755289644e-1,0,0,-1.580348853102535e-1,0,0,
0,0,0,0,0,0,0,
1.283881477532739e-1,0,1.657483860329489e-1,0,0,0,0,
0,0,0,0,0,-1.657483860329489e-1,0,
-1.283881477532739e-1,0,0,0,0,0,0,
0,0,0,1.580348853102534e-1,0,0,1.722507755289644e-1,
0,0,0,0,0,0,0,
0,-1.224132957852822e-1,0,0,0,-1.519109050625500e-1,0,
0,0,0,0,0,0,7.633810206905739e-2,
0,0,0,0,8.770580193070292e-2,-1.339728254114167e-1,1.564465546936859e-1,
-1.564465546936860e-1,1.379728923974526e-1,-1.068733428966804e-1,6.996502622814411e-2,-3.413943709994594e-2,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,4.756514941544940e-2,-8.684168428648434e-2,1.199890300758524e-1,-1.419729350050964e-1,
1.496526135717179e-1,-1.419729350050964e-1,1.199890300758524e-1,-8.684168428648434e-2,4.756514941544940e-2,0,0,
0,-1.009009190994469e-1,0,0,0,0,0,
0,0,0,-1.009009190994469e-1,0,0,1.477038214645864e-1,
0,0,0,0,0,0,0,
0,0,1.477038214645864e-1,0,-1.632927186332250e-1,0,0,
0,0,0,0,0,0,0,
0,-1.632927186332250e-1,1.264859959646828e-1,0,0,0,0,
0,0,0,0,0,0,0,
1.264859959646828e-1,-1.632927186332250e-1,0,0,0,0,0,
0,0,0,0,0,-1.632927186332250e-1,0,
1.477038214645864e-1,0,0,0,0,0,0,
0,0,0,1.477038214645864e-1,0,0,-1.009009190994468e-1,
0,0,0,0,0,0,0,
0,-1.009009190994468e-1,0,0,0,4.756514941544939e-2,-8.684168428648432e-2,
1.199890300758523e-1,-1.419729350050964e-1,1.496526135717179e-1,-1.419729350050964e-1,1.199890300758523e-1,-8.684168428648432e-2,4.756514941544939e-2,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,3.015113445777636e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,-3.015113445777637e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,3.015113445777636e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,-3.015113445777636e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,3.015113445777636e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
-3.015113445777636e-1,0,0,0,0,0,0,
0,0,0,0,0,0,3.015113445777636e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,-3.015113445777636e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,3.015113445777636e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,-3.015113445777637e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,3.015113445777636e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,3.015113445777636e-1,0,
0,0,0,0,0,0,0,
0,0,0,-1.348399724926484e-1,-2.696799449852968e-1,0,0,
0,0,0,0,0,0,0,
0,4.494665749754947e-2,1.797866299901979e-1,2.378353560042253e-1,0,0,0,
0,0,0,0,0,0,0,
-7.784989441615231e-2,-2.059714602177749e-1,-2.059714602177749e-1,0,0,0,0,
0,0,0,0,0,0,1.100963765126361e-1,
2.201927530252721e-1,1.740776559556978e-1,0,0,0,0,0,
0,0,0,0,0,-1.421338109037403e-1,-2.247332874877473e-1,
-1.421338109037403e-1,0,0,0,0,0,0,
0,0,0,0,1.740776559556978e-1,2.201927530252721e-1,1.100963765126361e-1,
0,0,0,0,0,0,0,
0,0,0,-2.059714602177749e-1,-2.059714602177749e-1,-7.784989441615231e-2,0,
0,0,0,0,0,0,0,
0,0,2.378353560042253e-1,1.797866299901979e-1,4.494665749754947e-2,0,0,
0,0,0,0,0,0,0,
0,-2.696799449852968e-1,-1.348399724926484e-1,0,0,0,0,
0,0,0,0,0,0,0,
3.015113445777636e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,2.752409412815902e-1,-1.230914909793327e-1,
0,0,0,0,0,0,0,
0,0,0,-1.230914909793327e-1,0,1.651445647689541e-1,0,
0,0,0,0,0,0,0,
0,0,1.651445647689541e-1,0,-1.906925178491184e-1,0,0,
0,0,0,0,0,0,0,
0,-1.906925178491184e-1,0,2.059714602177749e-1,0,0,0,
0,0,0,0,0,0,0,
2.059714602177749e-1,0,-2.132007163556104e-1,0,0,0,0,
0,0,0,0,0,0,-2.132007163556104e-1,
0,2.132007163556104e-1,0,0,0,0,0,
0,0,0,0,0,2.132007163556104e-1,0,
-2.059714602177749e-1,0,0,0,0,0,0,
0,0,0,0,-2.059714602177749e-1,0,1.906925178491184e-1,
0,0,0,0,0,0,0,
0,0,0,1.906925178491184e-1,0,-1.651445647689541e-1,0,
0,0,0,0,0,0,0,
0,0,-1.651445647689541e-1,0,1.230914909793327e-1,0,0,
0,0,0,0,0,0,0,
0,1.230914909793327e-1,-2.752409412815902e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,2.773500981126145e-1,-1.132277034144596e-1,
3.413943709994594e-2,0,0,0,0,0,0,
0,0,0,0,-2.531848417709167e-1,1.526762041381148e-1,-5.913123959890827e-2,
0,0,0,0,0,0,0,
0,0,0,2.290143062071722e-1,-1.773937187967248e-1,8.362420100070908e-2,0,
0,0,0,0,0,0,0,
0,0,-2.048366225996756e-1,1.931218198341070e-1,-1.079583792718826e-1,0,0,
0,0,0,0,0,0,0,
0,1.806489209323782e-1,-2.019716336333912e-1,1.322214713369863e-1,0,0,0,
0,0,0,0,0,0,0,
-1.564465546936860e-1,2.048366225996757e-1,-1.564465546936860e-1,0,0,0,0,
0,0,0,0,0,0,1.322214713369863e-1,
-2.019716336333912e-1,1.806489209323782e-1,0,0,0,0,0,
0,0,0,0,0,-1.079583792718826e-1,1.931218198341070e-1,
-2.048366225996756e-1,0,0,0,0,0,0,
0,0,0,0,8.362420100070908e-2,-1.773937187967248e-1,2.290143062071722e-1,
0,0,0,0,0,0,0,
0,0,0,-5.913123959890827e-2,1.526762041381148e-1,-2.531848417709167e-1,0,
0,0,0,0,0,0,0,
0,0,3.413943709994594e-2,-1.132277034144596e-1,2.773500981126145e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,3.015113445777636e-1,0,
0,0,0,0,0,0,0,
0,0,0,-1.906925178491184e-1,-2.335496832484569e-1,0,0,
0,0,0,0,0,0,0,
0,1.100963765126361e-1,2.201927530252721e-1,1.740776559556978e-1,0,0,0,
0,0,0,0,0,0,-5.504818825631802e-2,
-1.651445647689541e-1,-2.132007163556104e-1,-1.230914909793327e-1,0,0,0,0,
0,0,0,0,2.080625946441197e-2,1.019294382875251e-1,1.973855084879307e-1,
1.860968420796942e-1,8.058229640253801e-2,0,0,0,0,0,
0,0,0,-4.652421051992354e-2,-1.471224715841249e-1,-2.080625946441197e-1,-1.471224715841249e-1,
-4.652421051992354e-2,0,0,0,0,0,0,
0,0,8.058229640253801e-2,1.860968420796942e-1,1.973855084879307e-1,1.019294382875251e-1,2.080625946441198e-2,
0,0,0,0,0,0,0,
0,-1.230914909793327e-1,-2.132007163556104e-1,-1.651445647689541e-1,-5.504818825631802e-2,0,0,
0,0,0,0,0,0,0,
1.740776559556978e-1,2.201927530252721e-1,1.100963765126361e-1,0,0,0,0,
0,0,0,0,0,0,-2.335496832484569e-1,
-1.906925178491184e-1,0,0,0,0,0,0,
0,0,0,0,0,3.015113445777636e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,2.461829819586654e-1,-1.740776559556978e-1,
0,0,0,0,0,0,0,
0,0,0,-1.906925178491184e-1,0,2.059714602177748e-1,0,
0,0,0,0,0,0,0,
0,1.100963765126361e-1,0,0,-2.059714602177748e-1,0,0,
0,0,0,0,0,0,-4.494665749754947e-2,
0,0,0,1.880253582725887e-1,0,0,0,
0,0,0,0,0,8.408749651825215e-2,0,
0,0,-1.589104315409320e-1,0,0,0,0,
0,0,0,0,-1.230914909793327e-1,0,0,
0,1.230914909793327e-1,0,0,0,0,0,
0,0,0,1.589104315409320e-1,0,0,0,
-8.408749651825216e-2,0,0,0,0,0,0,
0,0,-1.880253582725887e-1,0,0,0,4.494665749754947e-2,
0,0,0,0,0,0,0,
0,2.059714602177748e-1,0,0,-1.100963765126361e-1,0,0,
0,0,0,0,0,0,0,
-2.059714602177749e-1,0,1.906925178491184e-1,0,0,0,0,
0,0,0,0,0,0,1.740776559556978e-1,
-2.461829819586654e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,2.290143062071723e-1,-1.773937187967248e-1,
8.362420100070908e-2,0,0,0,0,0,0,
0,0,0,-1.773937187967248e-1,0,0,-1.295500551262591e-1,
0,0,0,0,0,0,0,
0,8.362420100070908e-2,0,0,0,1.615773069067130e-1,0,
0,0,0,0,0,0,0,
-1.295500551262591e-1,0,0,0,-1.806489209323782e-1,0,0,
0,0,0,0,0,0,1.615773069067130e-1,
0,0,0,1.869893980016915e-1,0,0,0,
0,0,0,0,0,-1.806489209323782e-1,0,
0,0,-1.806489209323782e-1,0,0,0,0,
0,0,0,0,1.869893980016915e-1,0,0,
0,1.615773069067130e-1,0,0,0,0,0,
0,0,0,-1.806489209323782e-1,0,0,0,
-1.295500551262591e-1,0,0,0,0,0,0,
0,0,1.615773069067130e-1,0,0,0,8.362420100070908e-2,
0,0,0,0,0,0,0,
0,-1.295500551262591e-1,0,0,-1.773937187967248e-1,0,0,
0,0,0,0,0,0,0,
8.362420100070908e-2,-1.773937187967248e-1,2.290143062071723e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,2.344036154692477e-1,-1.657483860329490e-1,
8.655927155716765e-2,-3.160697706205070e-2,0,0,0,0,0,
0,0,0,-1.482498633322202e-1,0,0,0,
5.997002248126640e-2,0,0,0,0,0,0,
0,0,1.815682598006407e-1,0,0,0,-8.939803125353485e-2,
0,0,0,0,0,0,0,
0,-1.896418623723042e-1,0,0,0,1.182624791978165e-1,0,
0,0,0,0,0,0,0,
1.832114449657378e-1,0,0,0,-1.448413648755803e-1,0,0,
0,0,0,0,0,0,-1.672484020014181e-1,
0,0,0,1.672484020014181e-1,0,0,0,
0,0,0,0,0,1.448413648755803e-1,0,
0,0,-1.832114449657378e-1,0,0,0,0,
0,0,0,0,-1.182624791978165e-1,0,0,
0,1.896418623723042e-1,0,0,0,0,0,
0,0,0,8.939803125353485e-2,0,0,0,
-1.815682598006407e-1,0,0,0,0,0,0,
0,0,-5.997002248126640e-2,0,0,0,1.482498633322202e-1,
0,0,0,0,0,0,0,
0,3.160697706205070e-2,-8.655927155716765e-2,1.657483860329490e-1,-2.344036154692477e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,3.015113445777636e-1,0,
0,0,0,0,0,0,0,
0,0,0,-2.335496832484569e-1,-1.906925178491184e-1,0,0,
0,0,0,0,0,0,0,
0,1.740776559556978e-1,2.201927530252721e-1,1.100963765126361e-1,0,0,0,
0,0,0,0,0,0,-1.230914909793327e-1,
-2.132007163556104e-1,-1.651445647689541e-1,-5.504818825631802e-2,0,0,0,0,
0,0,0,0,8.058229640253801e-2,1.860968420796942e-1,1.973855084879307e-1,
1.019294382875251e-1,2.080625946441198e-2,0,0,0,0,0,
0,0,-4.652421051992355e-2,-1.471224715841249e-1,-2.080625946441197e-1,-1.471224715841249e-1,-4.652421051992354e-2,
0,0,0,0,0,0,0,
2.080625946441198e-2,1.019294382875251e-1,1.973855084879307e-1,1.860968420796942e-1,8.058229640253801e-2,0,0,
0,0,0,0,0,0,-5.504818825631802e-2,
-1.651445647689541e-1,-2.132007163556104e-1,-1.230914909793327e-1,0,0,0,0,
0,0,0,0,0,1.100963765126361e-1,2.201927530252721e-1,
1.740776559556978e-1,0,0,0,0,0,0,
0,0,0,0,-1.906925178491184e-1,-2.335496832484569e-1,0,
0,0,0,0,0,0,0,
0,0,0,3.015113445777636e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,2.132007163556104e-1,-2.132007163556104e-1,
0,0,0,0,0,0,0,
0,0,0,-2.132007163556104e-1,0,2.132007163556104e-1,0,
0,0,0,0,0,0,0,
0,1.740776559556978e-1,0,0,-1.740776559556978e-1,0,0,
0,0,0,0,0,0,-1.230914909793327e-1,
0,0,0,1.230914909793327e-1,0,0,0,
0,0,0,0,7.356123579206245e-2,0,0,
0,0,-7.356123579206245e-2,0,0,0,0,
0,0,-3.289758474798845e-2,0,0,0,0,
0,3.289758474798845e-2,0,0,0,0,0,
0,7.356123579206246e-2,0,0,0,0,-7.356123579206245e-2,
0,0,0,0,0,0,0,
-1.230914909793327e-1,0,0,0,1.230914909793327e-1,0,0,
0,0,0,0,0,0,1.740776559556978e-1,
0,0,-1.740776559556978e-1,0,0,0,0,
0,0,0,0,0,-2.132007163556104e-1,0,
2.132007163556104e-1,0,0,0,0,0,0,
0,0,0,0,2.132007163556104e-1,-2.132007163556104e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,1.806489209323782e-1,-2.019716336333912e-1,
1.322214713369863e-1,0,0,0,0,0,0,
0,0,0,-1.978909779672614e-1,0,0,-1.773937187967247e-1,
0,0,0,0,0,0,0,
0,1.615773069067129e-1,0,0,0,1.869893980016914e-1,0,
0,0,0,0,0,0,-1.042977031291240e-1,
0,0,0,0,-1.706971854997297e-1,0,0,
0,0,0,0,4.828045495852676e-2,0,0,
0,0,0,1.368622253628397e-1,0,0,0,
0,0,0,-9.349469900084570e-2,0,0,0,
0,0,-9.349469900084570e-2,0,0,0,0,
0,0,1.368622253628397e-1,0,0,0,0,
0,4.828045495852677e-2,0,0,0,0,0,
0,-1.706971854997297e-1,0,0,0,0,-1.042977031291240e-1,
0,0,0,0,0,0,0,
1.869893980016914e-1,0,0,0,1.615773069067129e-1,0,0,
0,0,0,0,0,0,-1.773937187967247e-1,
0,0,-1.978909779672615e-1,0,0,0,0,
0,0,0,0,0,1.322214713369863e-1,-2.019716336333912e-1,
1.806489209323782e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,1.731185431143352e-1,-1.896418623723042e-1,
1.413506985480439e-1,-7.067534927402194e-2,0,0,0,0,0,
0,0,0,-1.896418623723042e-1,0,0,0,
1.182624791978165e-1,0,0,0,0,0,0,
0,1.413506985480439e-1,0,0,0,0,-1.526762041381148e-1,
0,0,0,0,0,0,-7.067534927402193e-2,
0,0,0,0,0,1.706971854997297e-1,0,
0,0,0,0,0,1.182624791978165e-1,0,
0,0,0,0,-1.706971854997297e-1,0,0,
0,0,0,0,-1.526762041381148e-1,0,0,
0,0,0,1.526762041381148e-1,0,0,0,
0,0,0,1.706971854997297e-1,0,0,0,
0,0,-1.182624791978165e-1,0,0,0,0,
0,0,-1.706971854997297e-1,0,0,0,0,
0,7.067534927402194e-2,0,0,0,0,0,
0,1.526762041381148e-1,0,0,0,0,-1.413506985480439e-1,
0,0,0,0,0,0,0,
-1.182624791978165e-1,0,0,0,1.896418623723042e-1,0,0,
0,0,0,0,0,0,7.067534927402194e-2,
-1.413506985480439e-1,1.896418623723042e-1,-1.731185431143353e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,1.815682598006407e-1,-1.815682598006407e-1,
1.340970468803023e-1,-7.742096611387639e-2,3.160697706205071e-2,0,0,0,0,
0,0,0,-1.815682598006407e-1,0,0,0,
0,-6.321395412410141e-2,0,0,0,0,0,
0,1.048284836721918e-1,0,0,0,0,0,
9.656090991705353e-2,0,0,0,0,0,0,
-1.482498633322202e-1,0,0,0,0,0,-1.277380770053171e-1,
0,0,0,0,0,0,1.672484020014182e-1,
0,0,0,0,0,1.526762041381148e-1,0,
0,0,0,0,0,-1.672484020014181e-1,0,
0,0,0,0,-1.672484020014181e-1,0,0,
0,0,0,0,1.526762041381148e-1,0,0,
0,0,0,1.672484020014182e-1,0,0,0,
0,0,0,-1.277380770053171e-1,0,0,0,
0,0,-1.482498633322202e-1,0,0,0,0,
0,0,9.656090991705353e-2,0,0,0,0,
0,1.048284836721918e-1,0,0,0,0,0,
0,-6.321395412410141e-2,0,0,0,0,-1.815682598006407e-1,
0,0,0,0,0,0,0,
3.160697706205071e-2,-7.742096611387639e-2,1.340970468803023e-1,-1.815682598006407e-1,1.815682598006407e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,3.015113445777636e-1,0,
0,0,0,0,0,0,0,
0,0,0,-2.696799449852968e-1,-1.348399724926484e-1,0,0,
0,0,0,0,0,0,0,
0,2.378353560042253e-1,1.797866299901979e-1,4.494665749754947e-2,0,0,0,
0,0,0,0,0,0,-2.059714602177749e-1,
-2.059714602177749e-1,-7.784989441615231e-2,0,0,0,0,0,
0,0,0,0,1.740776559556978e-1,2.201927530252721e-1,1.100963765126361e-1,
0,0,0,0,0,0,0,
0,0,-1.421338109037403e-1,-2.247332874877473e-1,-1.421338109037403e-1,0,0,
0,0,0,0,0,0,0,
1.100963765126361e-1,2.201927530252721e-1,1.740776559556978e-1,0,0,0,0,
0,0,0,0,0,-7.784989441615231e-2,-2.059714602177749e-1,
-2.059714602177749e-1,0,0,0,0,0,0,
0,0,0,4.494665749754947e-2,1.797866299901979e-1,2.378353560042253e-1,0,
0,0,0,0,0,0,0,
0,0,-1.348399724926484e-1,-2.696799449852968e-1,0,0,0,
0,0,0,0,0,0,0,
0,3.015113445777636e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,1.740776559556978e-1,-2.461829819586654e-1,
0,0,0,0,0,0,0,
0,0,0,-2.059714602177749e-1,0,1.906925178491184e-1,0,
0,0,0,0,0,0,0,
0,2.059714602177749e-1,0,0,-1.100963765126361e-1,0,0,
0,0,0,0,0,0,-1.880253582725887e-1,
0,0,0,4.494665749754947e-2,0,0,0,
0,0,0,0,1.589104315409320e-1,0,0,
0,-8.408749651825216e-2,0,0,0,0,0,
0,0,-1.230914909793327e-1,0,0,0,1.230914909793327e-1,
0,0,0,0,0,0,0,
8.408749651825216e-2,0,0,0,-1.589104315409320e-1,0,0,
0,0,0,0,0,-4.494665749754947e-2,0,
0,0,1.880253582725887e-1,0,0,0,0,
0,0,0,0,1.100963765126361e-1,0,0,
-2.059714602177748e-1,0,0,0,0,0,0,
0,0,0,-1.906925178491184e-1,0,2.059714602177749e-1,0,
0,0,0,0,0,0,0,
0,0,2.461829819586654e-1,-1.740776559556978e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,1.322214713369863e-1,-2.019716336333912e-1,
1.806489209323782e-1,0,0,0,0,0,0,
0,0,0,-1.773937187967248e-1,0,0,-1.978909779672615e-1,
0,0,0,0,0,0,0,
0,1.869893980016914e-1,0,0,0,1.615773069067129e-1,0,
0,0,0,0,0,0,-1.706971854997297e-1,
0,0,0,0,-1.042977031291240e-1,0,0,
0,0,0,0,1.368622253628397e-1,0,0,
0,0,0,4.828045495852677e-2,0,0,0,
0,0,-9.349469900084571e-2,0,0,0,0,
0,-9.349469900084570e-2,0,0,0,0,0,
4.828045495852677e-2,0,0,0,0,0,1.368622253628397e-1,
0,0,0,0,0,0,-1.042977031291240e-1,
0,0,0,0,-1.706971854997297e-1,0,0,
0,0,0,0,0,1.615773069067129e-1,0,
0,0,1.869893980016914e-1,0,0,0,0,
0,0,0,0,-1.978909779672615e-1,0,0,
-1.773937187967247e-1,0,0,0,0,0,0,
0,0,0,1.806489209323782e-1,-2.019716336333912e-1,1.322214713369863e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,1.182624791978165e-1,-1.773937187967248e-1,
1.773937187967248e-1,-1.182624791978165e-1,0,0,0,0,0,
0,0,0,-1.672484020014182e-1,0,0,0,
1.672484020014182e-1,0,0,0,0,0,0,
0,1.762952951159817e-1,0,0,0,0,-1.762952951159817e-1,
0,0,0,0,0,0,-1.526762041381148e-1,
0,0,0,0,0,1.526762041381149e-1,0,
0,0,0,0,1.079583792718826e-1,0,0,
0,0,0,0,-1.079583792718826e-1,0,0,
0,0,-5.574946733380606e-2,0,0,0,0,
0,0,0,5.574946733380607e-2,0,0,0,
0,1.079583792718826e-1,0,0,0,0,0,
0,-1.079583792718826e-1,0,0,0,0,0,
-1.526762041381149e-1,0,0,0,0,0,1.526762041381148e-1,
0,0,0,0,0,0,1.762952951159817e-1,
0,0,0,0,-1.762952951159817e-1,0,0,
0,0,0,0,0,-1.672484020014182e-1,0,
0,0,1.672484020014182e-1,0,0,0,0,
0,0,0,0,1.182624791978166e-1,-1.773937187967248e-1,1.773937187967248e-1,
-1.182624791978166e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,1.182624791978165e-1,-1.672484020014181e-1,
1.672484020014181e-1,-1.277380770053171e-1,6.827887419989188e-2,0,0,0,0,
0,0,0,-1.672484020014181e-1,0,0,0,
0,-1.182624791978165e-1,0,0,0,0,0,
0,1.672484020014182e-1,0,0,0,0,0,
1.526762041381148e-1,0,0,0,0,0,-1.277380770053171e-1,
0,0,0,0,0,0,-1.649091483060512e-1,
0,0,0,0,6.827887419989187e-2,0,0,
0,0,0,0,0,1.526762041381148e-1,0,
0,0,0,-1.182624791978165e-1,0,0,0,
0,0,0,0,-1.182624791978165e-1,0,0,
0,0,1.526762041381148e-1,0,0,0,0,
0,0,0,6.827887419989188e-2,0,0,0,
0,-1.649091483060512e-1,0,0,0,0,0,
0,-1.277380770053171e-1,0,0,0,0,0,
1.526762041381148e-1,0,0,0,0,0,1.672484020014182e-1,
0,0,0,0,0,0,-1.182624791978165e-1,
0,0,0,0,-1.672484020014181e-1,0,0,
0,0,0,0,0,6.827887419989188e-2,-1.277380770053171e-1,
1.672484020014182e-1,-1.672484020014181e-1,1.182624791978165e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,1.283881477532739e-1,-1.657483860329489e-1,
1.580348853102534e-1,-1.224132957852822e-1,7.633810206905740e-2,-3.413943709994594e-2,0,0,0,
0,0,0,-1.722507755289644e-1,0,0,0,
0,0,6.996502622814413e-2,0,0,0,0,
0,1.519109050625500e-1,0,0,0,0,0,
0,-1.068733428966804e-1,0,0,0,0,-8.770580193070292e-2,
0,0,0,0,0,0,0,
1.379728923974526e-1,0,0,0,0,1.339728254114167e-1,0,
0,0,0,0,0,0,-1.564465546936859e-1,
0,0,0,0,-1.564465546936859e-1,0,0,
0,0,0,0,0,1.564465546936859e-1,0,
0,0,0,1.564465546936859e-1,0,0,0,
0,0,0,0,-1.339728254114167e-1,0,0,
0,0,-1.379728923974526e-1,0,0,0,0,
0,0,0,8.770580193070292e-2,0,0,0,
0,1.068733428966804e-1,0,0,0,0,0,
0,-1.519109050625500e-1,0,0,0,0,0,
-6.996502622814413e-2,0,0,0,0,0,1.722507755289644e-1,
0,0,0,0,0,0,3.413943709994594e-2,
-7.633810206905742e-2,1.224132957852822e-1,-1.580348853102535e-1,1.657483860329489e-1,-1.283881477532739e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,3.015113445777636e-1,0,
0,0,0,0,0,0,0,
0,0,0,-3.015113445777637e-1,0,0,0,
0,0,0,0,0,0,0,
0,3.015113445777636e-1,0,0,0,0,0,
0,0,0,0,0,0,-3.015113445777636e-1,
0,0,0,0,0,0,0,
0,0,0,0,3.015113445777636e-1,0,0,
0,0,0,0,0,0,0,
0,0,-3.015113445777636e-1,0,0,0,0,
0,0,0,0,0,0,0,
3.015113445777636e-1,0,0,0,0,0,0,
0,0,0,0,0,-3.015113445777636e-1,0,
0,0,0,0,0,0,0,
0,0,0,3.015113445777636e-1,0,0,0,
0,0,0,0,0,0,0,
0,-3.015113445777637e-1,0,0,0,0,0,
0,0,0,0,0,0,3.015113445777636e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,1.230914909793327e-1,-2.752409412815902e-1,
0,0,0,0,0,0,0,
0,0,0,-1.651445647689541e-1,0,1.230914909793327e-1,0,
0,0,0,0,0,0,0,
0,1.906925178491184e-1,0,-1.651445647689541e-1,0,0,0,
0,0,0,0,0,0,-2.059714602177749e-1,
0,1.906925178491184e-1,0,0,0,0,0,
0,0,0,0,2.132007163556104e-1,0,-2.059714602177749e-1,
0,0,0,0,0,0,0,
0,0,-2.132007163556104e-1,0,2.132007163556104e-1,0,0,
0,0,0,0,0,0,0,
2.059714602177748e-1,0,-2.132007163556104e-1,0,0,0,0,
0,0,0,0,0,-1.906925178491184e-1,0,
2.059714602177748e-1,0,0,0,0,0,0,
0,0,0,1.651445647689541e-1,0,-1.906925178491184e-1,0,
0,0,0,0,0,0,0,
0,-1.230914909793327e-1,0,1.651445647689541e-1,0,0,0,
0,0,0,0,0,0,0,
2.752409412815902e-1,-1.230914909793327e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,8.362420100070908e-2,-1.773937187967248e-1,
2.290143062071723e-1,0,0,0,0,0,0,
0,0,0,-1.295500551262591e-1,0,0,-1.773937187967248e-1,
0,0,0,0,0,0,0,
0,1.615773069067130e-1,0,0,0,8.362420100070908e-2,0,
0,0,0,0,0,0,-1.806489209323782e-1,
0,0,0,-1.295500551262591e-1,0,0,0,
0,0,0,0,1.869893980016915e-1,0,0,
0,1.615773069067130e-1,0,0,0,0,0,
0,0,-1.806489209323782e-1,0,0,0,-1.806489209323782e-1,
0,0,0,0,0,0,0,
1.615773069067130e-1,0,0,0,1.869893980016915e-1,0,0,
0,0,0,0,0,-1.295500551262591e-1,0,
0,0,-1.806489209323782e-1,0,0,0,0,
0,0,0,8.362420100070908e-2,0,0,0,
1.615773069067130e-1,0,0,0,0,0,0,
0,0,-1.773937187967248e-1,0,0,-1.295500551262591e-1,0,
0,0,0,0,0,0,0,
0,2.290143062071723e-1,-1.773937187967248e-1,8.362420100070908e-2,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,7.067534927402194e-2,-1.413506985480439e-1,
1.896418623723042e-1,-1.731185431143353e-1,0,0,0,0,0,
0,0,0,-1.182624791978165e-1,0,0,0,
1.896418623723042e-1,0,0,0,0,0,0,
0,1.526762041381148e-1,0,0,0,0,-1.413506985480439e-1,
0,0,0,0,0,0,-1.706971854997297e-1,
0,0,0,0,0,7.067534927402194e-2,0,
0,0,0,0,1.706971854997297e-1,0,0,
0,0,0,-1.182624791978165e-1,0,0,0,
0,0,-1.526762041381148e-1,0,0,0,0,
0,1.526762041381148e-1,0,0,0,0,0,
1.182624791978165e-1,0,0,0,0,0,-1.706971854997297e-1,
0,0,0,0,0,-7.067534927402194e-2,0,
0,0,0,0,1.706971854997297e-1,0,0,
0,0,0,0,1.413506985480439e-1,0,0,
0,0,-1.526762041381148e-1,0,0,0,0,
0,0,0,-1.896418623723042e-1,0,0,0,
1.182624791978165e-1,0,0,0,0,0,0,
0,0,1.731185431143353e-1,-1.896418623723042e-1,1.413506985480439e-1,-7.067534927402194e-2,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,6.827887419989188e-2,-1.277380770053171e-1,
1.672484020014182e-1,-1.672484020014181e-1,1.182624791978165e-1,0,0,0,0,
0,0,0,-1.182624791978165e-1,0,0,0,
0,-1.672484020014181e-1,0,0,0,0,0,
0,1.526762041381148e-1,0,0,0,0,0,
1.672484020014182e-1,0,0,0,0,0,-1.649091483060512e-1,
0,0,0,0,0,0,-1.277380770053171e-1,
0,0,0,0,1.526762041381148e-1,0,0,
0,0,0,0,0,6.827887419989188e-2,0,
0,0,-1.182624791978165e-1,0,0,0,0,
0,0,0,-1.182624791978165e-1,0,0,0,
6.827887419989188e-2,0,0,0,0,0,0,
0,1.526762041381148e-1,0,0,0,0,-1.277380770053171e-1,
0,0,0,0,0,0,-1.649091483060512e-1,
0,0,0,0,0,1.672484020014182e-1,0,
0,0,0,0,1.526762041381148e-1,0,0,
0,0,0,0,-1.672484020014181e-1,0,0,
0,0,-1.182624791978165e-1,0,0,0,0,
0,0,0,1.182624791978165e-1,-1.672484020014181e-1,1.672484020014182e-1,-1.277380770053171e-1,
6.827887419989188e-2,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,7.242068243779014e-2,-1.254363015010636e-1,
1.564465546936860e-1,-1.564465546936860e-1,1.254363015010636e-1,-7.242068243779014e-2,0,0,0,
0,0,0,-1.254363015010636e-1,0,0,0,
0,0,1.254363015010636e-1,0,0,0,0,
0,1.564465546936860e-1,0,0,0,0,0,
0,-1.564465546936860e-1,0,0,0,0,-1.564465546936860e-1,
0,0,0,0,0,0,0,
1.564465546936860e-1,0,0,0,1.254363015010636e-1,0,0,
0,0,0,0,0,0,-1.254363015010636e-1,
0,0,-7.242068243779014e-2,0,0,0,0,
0,0,0,0,0,7.242068243779014e-2,0,
0,1.254363015010636e-1,0,0,0,0,0,
0,0,0,-1.254363015010636e-1,0,0,0,
-1.564465546936860e-1,0,0,0,0,0,0,
0,1.564465546936860e-1,0,0,0,0,1.564465546936860e-1,
0,0,0,0,0,0,-1.564465546936860e-1,
0,0,0,0,0,-1.254363015010636e-1,0,
0,0,0,0,1.254363015010636e-1,0,0,
0,0,0,0,7.242068243779014e-2,-1.254363015010636e-1,1.564465546936860e-1,
-1.564465546936860e-1,1.254363015010636e-1,-7.242068243779014e-2,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,8.238525545716344e-2,-1.302625264297265e-1,
1.521138589340318e-1,-1.469559492086513e-1,1.199890300758524e-1,-8.049108834116180e-2,3.927562949192331e-2,0,0,
0,0,0,-1.378569000336139e-1,0,0,0,
0,0,0,-8.049108834116178e-2,0,0,0,
0,1.591834366881087e-1,0,0,0,0,0,
0,0,1.199890300758524e-1,0,0,0,-1.378569000336139e-1,
0,0,0,0,0,0,0,
0,-1.469559492086513e-1,0,0,8.238525545716344e-2,0,0,
0,0,0,0,0,0,0,
1.521138589340318e-1,0,0,-1.302625264297265e-1,0,0,0,
0,0,0,0,0,0,-1.302625264297265e-1,
0,0,1.521138589340319e-1,0,0,0,0,
0,0,0,0,0,8.238525545716344e-2,0,
0,-1.469559492086513e-1,0,0,0,0,0,
0,0,0,-1.378569000336139e-1,0,0,0,
1.199890300758523e-1,0,0,0,0,0,0,
0,1.591834366881087e-1,0,0,0,0,-8.049108834116178e-2,
0,0,0,0,0,0,-1.378569000336139e-1,
0,0,0,0,0,3.927562949192331e-2,-8.049108834116180e-2,
1.199890300758524e-1,-1.469559492086513e-1,1.521138589340319e-1,-1.302625264297265e-1,8.238525545716344e-2,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,3.413943709994594e-2,-1.132277034144596e-1,
2.773500981126145e-1,0,0,0,0,0,0,
0,0,0,-5.913123959890827e-2,1.526762041381148e-1,-2.531848417709167e-1,0,
0,0,0,0,0,0,0,
0,8.362420100070908e-2,-1.773937187967248e-1,2.290143062071722e-1,0,0,0,
0,0,0,0,0,0,-1.079583792718826e-1,
1.931218198341071e-1,-2.048366225996757e-1,0,0,0,0,0,
0,0,0,0,1.322214713369863e-1,-2.019716336333912e-1,1.806489209323782e-1,
0,0,0,0,0,0,0,
0,0,-1.564465546936860e-1,2.048366225996757e-1,-1.564465546936860e-1,0,0,
0,0,0,0,0,0,0,
1.806489209323782e-1,-2.019716336333912e-1,1.322214713369863e-1,0,0,0,0,
0,0,0,0,0,-2.048366225996756e-1,1.931218198341070e-1,
-1.079583792718826e-1,0,0,0,0,0,0,
0,0,0,2.290143062071722e-1,-1.773937187967248e-1,8.362420100070908e-2,0,
0,0,0,0,0,0,0,
0,-2.531848417709167e-1,1.526762041381148e-1,-5.913123959890827e-2,0,0,0,
0,0,0,0,0,0,2.773500981126145e-1,
-1.132277034144596e-1,3.413943709994594e-2,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,3.160697706205070e-2,-8.655927155716765e-2,
1.657483860329490e-1,-2.344036154692477e-1,0,0,0,0,0,
0,0,0,-5.997002248126639e-2,0,0,0,
1.482498633322202e-1,0,0,0,0,0,0,
0,8.939803125353483e-2,0,0,0,-1.815682598006408e-1,0,
0,0,0,0,0,0,-1.182624791978165e-1,
0,0,0,1.896418623723042e-1,0,0,0,
0,0,0,0,1.448413648755803e-1,0,0,
0,-1.832114449657378e-1,0,0,0,0,0,
0,0,-1.672484020014181e-1,0,0,0,1.672484020014182e-1,
0,0,0,0,0,0,0,
1.832114449657378e-1,0,0,0,-1.448413648755802e-1,0,0,
0,0,0,0,0,-1.896418623723042e-1,0,
0,0,1.182624791978165e-1,0,0,0,0,
0,0,0,1.815682598006407e-1,0,0,0,
-8.939803125353485e-2,0,0,0,0,0,0,
0,-1.482498633322202e-1,0,0,0,5.997002248126640e-2,0,
0,0,0,0,0,0,0,
2.344036154692477e-1,-1.657483860329490e-1,8.655927155716765e-2,-3.160697706205070e-2,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,3.160697706205070e-2,-7.742096611387637e-2,
1.340970468803023e-1,-1.815682598006408e-1,1.815682598006408e-1,0,0,0,0,
0,0,0,-6.321395412410140e-2,0,0,0,
0,-1.815682598006408e-1,0,0,0,0,0,
0,9.656090991705353e-2,0,0,0,0,0,
1.048284836721918e-1,0,0,0,0,0,-1.277380770053171e-1,
0,0,0,0,0,-1.482498633322203e-1,0,
0,0,0,0,1.526762041381148e-1,0,0,
0,0,0,1.672484020014182e-1,0,0,0,
0,0,-1.672484020014181e-1,0,0,0,0,
0,-1.672484020014182e-1,0,0,0,0,0,
1.672484020014182e-1,0,0,0,0,0,1.526762041381148e-1,
0,0,0,0,0,-1.482498633322202e-1,0,
0,0,0,0,-1.277380770053171e-1,0,0,
0,0,0,1.048284836721918e-1,0,0,0,
0,0,9.656090991705353e-2,0,0,0,0,
0,0,-1.815682598006407e-1,0,0,0,0,
-6.321395412410141e-2,0,0,0,0,0,0,
0,1.815682598006407e-1,-1.815682598006407e-1,1.340970468803023e-1,-7.742096611387639e-2,3.160697706205071e-2,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,3.413943709994595e-2,-7.633810206905742e-2,
1.224132957852822e-1,-1.580348853102535e-1,1.657483860329489e-1,-1.283881477532739e-1,0,0,0,
0,0,0,-6.996502622814413e-2,0,0,0,
0,0,1.722507755289644e-1,0,0,0,0,
0,1.068733428966804e-1,0,0,0,0,0,
0,-1.519109050625500e-1,0,0,0,0,-1.379728923974526e-1,
0,0,0,0,0,0,0,
8.770580193070292e-2,0,0,0,1.564465546936860e-1,0,0,
0,0,0,0,0,-1.339728254114167e-1,0,
0,0,-1.564465546936860e-1,0,0,0,0,
0,0,0,1.564465546936860e-1,0,0,0,
1.339728254114167e-1,0,0,0,0,0,0,
0,-1.564465546936859e-1,0,0,0,-8.770580193070293e-2,0,
0,0,0,0,0,0,1.379728923974526e-1,
0,0,0,0,1.519109050625500e-1,0,0,
0,0,0,0,-1.068733428966804e-1,0,0,
0,0,0,-1.722507755289644e-1,0,0,0,
0,0,6.996502622814413e-2,0,0,0,0,
0,0,1.283881477532739e-1,-1.657483860329489e-1,1.580348853102535e-1,-1.224132957852822e-1,7.633810206905742e-2,
-3.413943709994594e-2,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,3.927562949192332e-2,-8.049108834116180e-2,
1.199890300758524e-1,-1.469559492086513e-1,1.521138589340319e-1,-1.302625264297265e-1,8.238525545716345e-2,0,0,
0,0,0,-8.049108834116180e-2,0,0,0,
0,0,0,-1.378569000336139e-1,0,0,0,
0,1.199890300758524e-1,0,0,0,0,0,
0,0,1.591834366881087e-1,0,0,0,-1.469559492086513e-1,
0,0,0,0,0,0,0,
0,-1.378569000336139e-1,0,0,1.521138589340319e-1,0,0,
0,0,0,0,0,0,0,
8.238525545716344e-2,0,-1.302625264297265e-1,0,0,0,0,
0,0,0,0,0,-1.302625264297265e-1,0,
8.238525545716345e-2,0,0,0,0,0,0,
0,0,0,1.521138589340318e-1,0,0,-1.378569000336139e-1,
0,0,0,0,0,0,0,
0,-1.469559492086513e-1,0,0,0,1.591834366881087e-1,0,
0,0,0,0,0,0,1.199890300758523e-1,
0,0,0,0,-1.378569000336139e-1,0,0,
0,0,0,0,-8.049108834116178e-2,0,0,
0,0,0,8.238525545716344e-2,-1.302625264297265e-1,1.521138589340319e-1,-1.469559492086513e-1,
1.199890300758524e-1,-8.049108834116180e-2,3.927562949192331e-2,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,4.756514941544941e-2,-8.898624633166125e-2,
1.229521683642505e-1,-1.419729350050964e-1,1.419729350050964e-1,-1.229521683642505e-1,8.898624633166125e-2,-4.756514941544941e-2,0,
0,0,0,-9.513029883089880e-2,0,0,0,
0,0,0,0,9.513029883089881e-2,0,0,
0,1.345345587992625e-1,0,0,0,0,0,
0,0,0,-1.345345587992625e-1,0,0,-1.504142093990467e-1,
0,0,0,0,0,0,0,
0,0,1.504142093990467e-1,0,1.333279464544214e-1,0,0,
0,0,0,0,0,0,0,
0,-1.333279464544214e-1,-8.432399730978855e-2,0,0,0,0,
0,0,0,0,0,0,0,
8.432399730978855e-2,1.333279464544214e-1,0,0,0,0,0,
0,0,0,0,0,-1.333279464544214e-1,0,
-1.504142093990467e-1,0,0,0,0,0,0,
0,0,0,1.504142093990467e-1,0,0,1.345345587992625e-1,
0,0,0,0,0,0,0,
0,-1.345345587992625e-1,0,0,0,-9.513029883089880e-2,0,
0,0,0,0,0,0,9.513029883089880e-2,
0,0,0,0,4.756514941544941e-2,-8.898624633166125e-2,1.229521683642505e-1,
-1.419729350050964e-1,1.419729350050964e-1,-1.229521683642505e-1,8.898624633166125e-2,-4.756514941544941e-2,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
2.773500981126146e-1,0,0,0,0,0,0,
0,0,0,0,0,0,-2.773500981126146e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,2.773500981126145e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,-2.773500981126146e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,2.773500981126145e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,-2.773500981126146e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,2.773500981126146e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
-2.773500981126146e-1,0,0,0,0,0,0,
0,0,0,0,0,0,2.773500981126145e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,-2.773500981126146e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,2.773500981126145e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,-2.773500981126146e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,2.773500981126146e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
2.773500981126145e-1,0,0,0,0,0,0,
0,0,0,0,0,-1.132277034144596e-1,-2.531848417709167e-1,
0,0,0,0,0,0,0,
0,0,0,3.413943709994594e-2,1.526762041381148e-1,2.290143062071722e-1,0,
0,0,0,0,0,0,0,
0,0,-5.913123959890827e-2,-1.773937187967248e-1,-2.048366225996756e-1,0,0,
0,0,0,0,0,0,0,
0,8.362420100070908e-2,1.931218198341070e-1,1.806489209323782e-1,0,0,0,
0,0,0,0,0,0,0,
-1.079583792718826e-1,-2.019716336333912e-1,-1.564465546936860e-1,0,0,0,0,
0,0,0,0,0,0,1.322214713369863e-1,
2.048366225996757e-1,1.322214713369863e-1,0,0,0,0,0,
0,0,0,0,0,-1.564465546936860e-1,-2.019716336333912e-1,
-1.079583792718826e-1,0,0,0,0,0,0,
0,0,0,0,1.806489209323782e-1,1.931218198341070e-1,8.362420100070908e-2,
0,0,0,0,0,0,0,
0,0,0,-2.048366225996756e-1,-1.773937187967248e-1,-5.913123959890827e-2,0,
0,0,0,0,0,0,0,
0,0,2.290143062071722e-1,1.526762041381148e-1,3.413943709994594e-2,0,0,
0,0,0,0,0,0,0,
0,-2.531848417709167e-1,-1.132277034144596e-1,0,0,0,0,
0,0,0,0,0,0,0,
2.773500981126145e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
2.567762955065477e-1,-1.048284836721918e-1,0,0,0,0,0,
0,0,0,0,0,-1.048284836721918e-1,0,
1.419384378754400e-1,0,0,0,0,0,0,
0,0,0,0,1.419384378754400e-1,0,-1.657483860329489e-1,
0,0,0,0,0,0,0,
0,0,0,-1.657483860329489e-1,0,1.815682598006407e-1,0,
0,0,0,0,0,0,0,
0,0,1.815682598006407e-1,0,-1.913897505877382e-1,0,0,
0,0,0,0,0,0,0,
0,-1.913897505877382e-1,0,1.961161351381841e-1,0,0,0,
0,0,0,0,0,0,0,
1.961161351381841e-1,0,-1.961161351381841e-1,0,0,0,0,
0,0,0,0,0,0,-1.961161351381841e-1,
0,1.913897505877382e-1,0,0,0,0,0,
0,0,0,0,0,1.913897505877382e-1,0,
-1.815682598006407e-1,0,0,0,0,0,0,
0,0,0,0,-1.815682598006407e-1,0,1.657483860329489e-1,
0,0,0,0,0,0,0,
0,0,0,1.657483860329489e-1,0,-1.419384378754400e-1,0,
0,0,0,0,0,0,0,
0,0,-1.419384378754400e-1,0,1.048284836721918e-1,0,0,
0,0,0,0,0,0,0,
0,1.048284836721918e-1,-2.567762955065477e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
2.773500981126146e-1,0,0,0,0,0,0,
0,0,0,0,0,-1.601281538050871e-1,-2.264554068289192e-1,
0,0,0,0,0,0,0,
0,0,0,8.362420100070908e-2,1.931218198341070e-1,1.806489209323782e-1,0,
0,0,0,0,0,0,0,
0,-3.739787960033828e-2,-1.295500551262591e-1,-1.978909779672615e-1,-1.399300524562882e-1,0,0,
0,0,0,0,0,0,1.246595986677943e-2,
7.051811804639269e-2,1.615773069067130e-1,1.865734032750510e-1,1.042977031291240e-1,0,0,0,
0,0,0,0,0,-2.787473366690302e-2,-1.042977031291240e-1,
-1.806489209323782e-1,-1.649091483060512e-1,-7.374961314478495e-2,0,0,0,0,
0,0,0,0,4.828045495852676e-2,1.365577483997838e-1,1.869893980016915e-1,
1.365577483997838e-1,4.828045495852677e-2,0,0,0,0,0,
0,0,0,-7.374961314478495e-2,-1.649091483060512e-1,-1.806489209323782e-1,-1.042977031291240e-1,
-2.787473366690302e-2,0,0,0,0,0,0,
0,0,1.042977031291240e-1,1.865734032750510e-1,1.615773069067130e-1,7.051811804639269e-2,1.246595986677943e-2,
0,0,0,0,0,0,0,
0,-1.399300524562882e-1,-1.978909779672615e-1,-1.295500551262591e-1,-3.739787960033828e-2,0,0,
0,0,0,0,0,0,0,
1.806489209323782e-1,1.931218198341070e-1,8.362420100070908e-2,0,0,0,0,
0,0,0,0,0,0,-2.264554068289192e-1,
-1.601281538050871e-1,0,0,0,0,0,0,
0,0,0,0,0,2.773500981126146e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
2.344036154692477e-1,-1.482498633322202e-1,0,0,0,0,0,
0,0,0,0,0,-1.657483860329490e-1,0,
1.815682598006407e-1,0,0,0,0,0,0,
0,0,0,8.655927155716765e-2,0,0,-1.896418623723042e-1,
0,0,0,0,0,0,0,
0,-3.160697706205070e-2,0,0,0,1.832114449657378e-1,0,
0,0,0,0,0,0,0,
5.997002248126639e-2,0,0,0,-1.672484020014181e-1,0,0,
0,0,0,0,0,0,-8.939803125353483e-2,
0,0,0,1.448413648755802e-1,0,0,0,
0,0,0,0,0,1.182624791978165e-1,0,
0,0,-1.182624791978165e-1,0,0,0,0,
0,0,0,0,-1.448413648755802e-1,0,0,
0,8.939803125353483e-2,0,0,0,0,0,
0,0,0,1.672484020014181e-1,0,0,0,
-5.997002248126639e-2,0,0,0,0,0,0,
0,0,-1.832114449657378e-1,0,0,0,3.160697706205070e-2,
0,0,0,0,0,0,0,
0,1.896418623723042e-1,0,0,-8.655927155716765e-2,0,0,
0,0,0,0,0,0,0,
-1.815682598006407e-1,0,1.657483860329490e-1,0,0,0,0,
0,0,0,0,0,0,1.482498633322202e-1,
-2.344036154692477e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
2.198900824313101e-1,-1.554857684028483e-1,6.629935441317958e-2,0,0,0,0,
0,0,0,0,0,-1.554857684028483e-1,0,
0,-1.048284836721918e-1,0,0,0,0,0,
0,0,0,6.629935441317958e-2,0,0,0,
1.340970468803023e-1,0,0,0,0,0,0,
0,0,-1.048284836721918e-1,0,0,0,-1.548419322277527e-1,
0,0,0,0,0,0,0,
0,1.340970468803023e-1,0,0,0,1.672484020014182e-1,0,
0,0,0,0,0,0,0,
-1.548419322277527e-1,0,0,0,-1.713786140993951e-1,0,0,
0,0,0,0,0,0,1.672484020014182e-1,
0,0,0,1.672484020014182e-1,0,0,0,
0,0,0,0,0,-1.713786140993951e-1,0,
0,0,-1.548419322277527e-1,0,0,0,0,
0,0,0,0,1.672484020014182e-1,0,0,
0,1.340970468803023e-1,0,0,0,0,0,
0,0,0,-1.548419322277527e-1,0,0,0,
-1.048284836721918e-1,0,0,0,0,0,0,
0,0,1.340970468803023e-1,0,0,0,6.629935441317958e-2,
0,0,0,0,0,0,0,
0,-1.048284836721918e-1,0,0,-1.554857684028483e-1,0,0,
0,0,0,0,0,0,0,
6.629935441317958e-2,-1.554857684028483e-1,2.198900824313101e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
2.773500981126146e-1,0,0,0,0,0,0,
0,0,0,0,0,-1.961161351381840e-1,-1.961161351381841e-1,
0,0,0,0,0,0,0,
0,0,0,1.322214713369863e-1,2.048366225996757e-1,1.322214713369863e-1,0,
0,0,0,0,0,0,0,
0,-8.362420100070907e-2,-1.773937187967247e-1,-1.773937187967248e-1,-8.362420100070907e-2,0,0,
0,0,0,0,0,0,4.828045495852675e-2,
1.365577483997838e-1,1.869893980016914e-1,1.365577483997838e-1,4.828045495852676e-2,0,0,0,
0,0,0,0,-2.414022747926338e-2,-9.349469900084571e-2,-1.706971854997297e-1,
-1.706971854997297e-1,-9.349469900084571e-2,-2.414022747926338e-2,0,0,0,0,
0,0,9.124148357522649e-3,5.474489014513589e-2,1.368622253628397e-1,1.824829671504530e-1,1.368622253628397e-1,
5.474489014513589e-2,9.124148357522649e-3,0,0,0,0,0,
0,-2.414022747926338e-2,-9.349469900084573e-2,-1.706971854997297e-1,-1.706971854997297e-1,-9.349469900084571e-2,-2.414022747926338e-2,
0,0,0,0,0,0,0,
4.828045495852676e-2,1.365577483997838e-1,1.869893980016914e-1,1.365577483997838e-1,4.828045495852676e-2,0,0,
0,0,0,0,0,0,-8.362420100070907e-2,
-1.773937187967247e-1,-1.773937187967247e-1,-8.362420100070907e-2,0,0,0,0,
0,0,0,0,0,1.322214713369863e-1,2.048366225996757e-1,
1.322214713369863e-1,0,0,0,0,0,0,
0,0,0,0,-1.961161351381841e-1,-1.961161351381841e-1,0,
0,0,0,0,0,0,0,
0,0,0,2.773500981126146e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
2.096569673443837e-1,-1.815682598006407e-1,0,0,0,0,0,
0,0,0,0,0,-1.913897505877382e-1,0,
1.961161351381840e-1,0,0,0,0,0,0,
0,0,0,1.413506985480439e-1,0,0,-1.773937187967248e-1,
0,0,0,0,0,0,0,
0,-8.939803125353483e-2,0,0,0,1.448413648755803e-1,0,
0,0,0,0,0,0,4.711689951601463e-2,
0,0,0,0,-1.079583792718826e-1,0,0,
0,0,0,0,-1.824829671504530e-2,0,0,
0,0,0,7.242068243779015e-2,0,0,0,
0,0,0,4.181210050035454e-2,0,0,0,
0,0,-4.181210050035455e-2,0,0,0,0,
0,0,-7.242068243779015e-2,0,0,0,0,
0,1.824829671504530e-2,0,0,0,0,0,
0,1.079583792718826e-1,0,0,0,0,-4.711689951601463e-2,
0,0,0,0,0,0,0,
-1.448413648755803e-1,0,0,0,8.939803125353483e-2,0,0,
0,0,0,0,0,0,1.773937187967248e-1,
0,0,-1.413506985480439e-1,0,0,0,0,
0,0,0,0,0,-1.961161351381841e-1,0,
1.913897505877382e-1,0,0,0,0,0,0,
0,0,0,0,1.815682598006407e-1,-2.096569673443837e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
1.815682598006407e-1,-1.815682598006407e-1,1.048284836721918e-1,0,0,0,0,
0,0,0,0,0,-1.815682598006407e-1,0,
0,-1.482498633322202e-1,0,0,0,0,0,
0,0,0,1.340970468803023e-1,0,0,0,
1.672484020014181e-1,0,0,0,0,0,0,
0,-7.742096611387637e-2,0,0,0,0,-1.672484020014181e-1,
0,0,0,0,0,0,3.160697706205070e-2,
0,0,0,0,0,1.526762041381148e-1,0,
0,0,0,0,0,-6.321395412410140e-2,0,
0,0,0,0,-1.277380770053171e-1,0,0,
0,0,0,0,9.656090991705352e-2,0,0,
0,0,0,9.656090991705353e-2,0,0,0,
0,0,0,-1.277380770053171e-1,0,0,0,
0,0,-6.321395412410140e-2,0,0,0,0,
0,0,1.526762041381148e-1,0,0,0,0,
0,3.160697706205070e-2,0,0,0,0,0,
0,-1.672484020014181e-1,0,0,0,0,-7.742096611387637e-2,
0,0,0,0,0,0,0,
1.672484020014182e-1,0,0,0,1.340970468803023e-1,0,0,
0,0,0,0,0,0,-1.482498633322202e-1,
0,0,-1.815682598006407e-1,0,0,0,0,
0,0,0,0,0,1.048284836721918e-1,-1.815682598006407e-1,
1.815682598006407e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
1.738383738412788e-1,-1.738383738412788e-1,1.172018077346239e-1,-5.241424183609591e-2,0,0,0,
0,0,0,0,0,-1.738383738412788e-1,0,
0,0,9.078412990032034e-2,0,0,0,0,
0,0,0,1.172018077346239e-1,0,0,0,
0,-1.224132957852822e-1,0,0,0,0,0,
0,-5.241424183609590e-2,0,0,0,0,0,
1.448413648755803e-1,0,0,0,0,0,0,
9.078412990032032e-2,0,0,0,0,0,-1.564465546936859e-1,
0,0,0,0,0,0,-1.224132957852822e-1,
0,0,0,0,0,1.564465546936860e-1,0,
0,0,0,0,0,1.448413648755802e-1,0,
0,0,0,0,-1.448413648755803e-1,0,0,
0,0,0,0,-1.564465546936859e-1,0,0,
0,0,0,1.224132957852822e-1,0,0,0,
0,0,0,1.564465546936860e-1,0,0,0,
0,0,-9.078412990032034e-2,0,0,0,0,
0,0,-1.448413648755803e-1,0,0,0,0,
0,5.241424183609591e-2,0,0,0,0,0,
0,1.224132957852822e-1,0,0,0,0,-1.172018077346239e-1,
0,0,0,0,0,0,0,
-9.078412990032035e-2,0,0,0,1.738383738412788e-1,0,0,
0,0,0,0,0,0,5.241424183609591e-2,
-1.172018077346239e-1,1.738383738412788e-1,-1.738383738412788e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
2.773500981126146e-1,0,0,0,0,0,0,
0,0,0,0,0,-2.264554068289192e-1,-1.601281538050872e-1,
0,0,0,0,0,0,0,
0,0,0,1.806489209323782e-1,1.931218198341071e-1,8.362420100070908e-2,0,
0,0,0,0,0,0,0,
0,-1.399300524562883e-1,-1.978909779672615e-1,-1.295500551262591e-1,-3.739787960033828e-2,0,0,
0,0,0,0,0,0,1.042977031291240e-1,
1.865734032750510e-1,1.615773069067130e-1,7.051811804639269e-2,1.246595986677943e-2,0,0,0,
0,0,0,0,-7.374961314478495e-2,-1.649091483060512e-1,-1.806489209323782e-1,
-1.042977031291240e-1,-2.787473366690302e-2,0,0,0,0,0,
0,0,4.828045495852677e-2,1.365577483997838e-1,1.869893980016915e-1,1.365577483997838e-1,4.828045495852677e-2,
0,0,0,0,0,0,0,
-2.787473366690303e-2,-1.042977031291240e-1,-1.806489209323782e-1,-1.649091483060512e-1,-7.374961314478497e-2,0,0,
0,0,0,0,0,1.246595986677943e-2,7.051811804639270e-2,
1.615773069067130e-1,1.865734032750510e-1,1.042977031291240e-1,0,0,0,0,
0,0,0,0,-3.739787960033829e-2,-1.295500551262591e-1,-1.978909779672615e-1,
-1.399300524562882e-1,0,0,0,0,0,0,
0,0,0,8.362420100070908e-2,1.931218198341070e-1,1.806489209323782e-1,0,
0,0,0,0,0,0,0,
0,0,-1.601281538050871e-1,-2.264554068289192e-1,0,0,0,
0,0,0,0,0,0,0,
0,2.773500981126146e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
1.815682598006407e-1,-2.096569673443837e-1,0,0,0,0,0,
0,0,0,0,0,-1.961161351381841e-1,0,
1.913897505877382e-1,0,0,0,0,0,0,
0,0,0,1.773937187967248e-1,0,0,-1.413506985480439e-1,
0,0,0,0,0,0,0,
0,-1.448413648755803e-1,0,0,0,8.939803125353483e-2,0,
0,0,0,0,0,0,1.079583792718826e-1,
0,0,0,0,-4.711689951601463e-2,0,0,
0,0,0,0,-7.242068243779015e-2,0,0,
0,0,0,1.824829671504530e-2,0,0,0,
0,0,4.181210050035455e-2,0,0,0,0,
0,-4.181210050035455e-2,0,0,0,0,0,
-1.824829671504530e-2,0,0,0,0,0,7.242068243779015e-2,
0,0,0,0,0,0,4.711689951601464e-2,
0,0,0,0,-1.079583792718826e-1,0,0,
0,0,0,0,0,-8.939803125353485e-2,0,
0,0,1.448413648755803e-1,0,0,0,0,
0,0,0,0,1.413506985480439e-1,0,0,
-1.773937187967248e-1,0,0,0,0,0,0,
0,0,0,-1.913897505877382e-1,0,1.961161351381841e-1,0,
0,0,0,0,0,0,0,
0,0,2.096569673443837e-1,-1.815682598006407e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
1.432229748078866e-1,-1.894661866862684e-1,1.432229748078866e-1,0,0,0,0,
0,0,0,0,0,-1.754116038614058e-1,0,
0,-1.754116038614059e-1,0,0,0,0,0,
0,0,0,1.672484020014181e-1,0,0,0,
1.672484020014182e-1,0,0,0,0,0,0,
0,-1.365577483997838e-1,0,0,0,0,-1.365577483997838e-1,
0,0,0,0,0,0,9.656090991705350e-2,
0,0,0,0,0,9.656090991705352e-2,0,
0,0,0,0,-5.712620469979835e-2,0,0,
0,0,0,0,-5.712620469979836e-2,0,0,
0,0,2.493191973355886e-2,0,0,0,0,
0,0,0,2.493191973355886e-2,0,0,0,
0,-5.712620469979836e-2,0,0,0,0,0,
0,-5.712620469979836e-2,0,0,0,0,0,
9.656090991705352e-2,0,0,0,0,0,9.656090991705352e-2,
0,0,0,0,0,0,-1.365577483997838e-1,
0,0,0,0,-1.365577483997838e-1,0,0,
0,0,0,0,0,1.672484020014182e-1,0,
0,0,1.672484020014182e-1,0,0,0,0,
0,0,0,0,-1.754116038614059e-1,0,0,
-1.754116038614059e-1,0,0,0,0,0,0,
0,0,0,1.432229748078866e-1,-1.894661866862684e-1,1.432229748078866e-1,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
1.283881477532739e-1,-1.722507755289644e-1,1.519109050625500e-1,-8.770580193070293e-2,0,0,0,
0,0,0,0,0,-1.657483860329489e-1,0,
0,0,1.339728254114167e-1,0,0,0,0,
0,0,0,1.580348853102534e-1,0,0,0,
0,-1.564465546936860e-1,0,0,0,0,0,
0,-1.224132957852822e-1,0,0,0,0,0,
1.564465546936860e-1,0,0,0,0,0,7.633810206905739e-2,
0,0,0,0,0,0,-1.379728923974526e-1,
0,0,0,0,-3.413943709994594e-2,0,0,
0,0,0,0,0,1.068733428966804e-1,0,
0,0,0,6.996502622814411e-2,0,0,0,
0,0,0,0,-6.996502622814413e-2,0,0,
0,0,-1.068733428966804e-1,0,0,0,0,
0,0,0,3.413943709994595e-2,0,0,0,
0,1.379728923974526e-1,0,0,0,0,0,
0,-7.633810206905740e-2,0,0,0,0,0,
-1.564465546936860e-1,0,0,0,0,0,1.224132957852822e-1,
0,0,0,0,0,0,1.564465546936860e-1,
0,0,0,0,-1.580348853102535e-1,0,0,
0,0,0,0,0,-1.339728254114167e-1,0,
0,0,1.657483860329489e-1,0,0,0,0,
0,0,0,0,8.770580193070293e-2,-1.519109050625500e-1,1.722507755289644e-1,
-1.283881477532739e-1,0,0,0,0,0,0,
0,0,0,0,0,0,0,
1.264859959646828e-1,-1.632927186332250e-1,1.477038214645864e-1,-1.009009190994469e-1,4.756514941544940e-2,0,0,
0,0,0,0,0,-1.632927186332250e-1,0,
0,0,0,-8.684168428648434e-2,0,0,0,
0,0,0,1.477038214645864e-1,0,0,0,
0,0,1.199890300758524e-1,0,0,0,0,
0,-1.009009190994468e-1,0,0,0,0,0,
0,-1.419729350050964e-1,0,0,0,0,4.756514941544939e-2,
0,0,0,0,0,0,0,
1.496526135717179e-1,0,0,0,0,-8.684168428648432e-2,0,
0,0,0,0,0,0,-1.419729350050964e-1,
0,0,0,0,1.199890300758523e-1,0,0,
0,0,0,0,0,1.199890300758524e-1,0,
0,0,0,-1.419729350050964e-1,0,0,0,
0,0,0,0,-8.684168428648434e-2,0,0,
0,0,1.496526135717179e-1,0,0,0,0,
0,0,0,4.756514941544940e-2,0,0,0,
0,-1.419729350050964e-1,0,0,0,0,0,
0,-1.009009190994469e-1,0,0,0,0,0,
1.199890300758524e-1,0,0,0,0,0,1.477038214645864e-1,
0,0,0,0,0,0,-8.684168428648435e-2,
0,0,0,0,-1.632927186332250e-1,0,0,
0,0,0,0,0,4.756514941544941e-2,-1.009009190994469e-1,
1.477038214645864e-1,-1.632927186332250e-1,1.264859959646828e-1,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
2.773500981126145e-1,0,0,0,0,0,0,
0,0,0,0,0,-2.531848417709167e-1,-1.132277034144596e-1,
0,0,0,0,0,0,0,
0,0,0,2.290143062071722e-1,1.526762041381148e-1,3.413943709994594e-2,0,
0,0,0,0,0,0,0,
0,-2.048366225996757e-1,-1.773937187967248e-1,-5.913123959890827e-2,0,0,0,
0,0,0,0,0,0,1.806489209323782e-1,
1.931218198341071e-1,8.362420100070908e-2,0,0,0,0,0,
0,0,0,0,-1.564465546936860e-1,-2.019716336333912e-1,-1.079583792718826e-1,
0,0,0,0,0,0,0,
0,0,1.322214713369863e-1,2.048366225996757e-1,1.322214713369863e-1,0,0,
0,0,0,0,0,0,0,
-1.079583792718826e-1,-2.019716336333912e-1,-1.564465546936860e-1,0,0,0,0,
0,0,0,0,0,8.362420100070908e-2,1.931218198341070e-1,
1.806489209323782e-1,0,0,0,0,0,0,
0,0,0,-5.913123959890827e-2,-1.773937187967248e-1,-2.048366225996756e-1,0,
0,0,0,0,0,0,0,
0,3.413943709994594e-2,1.526762041381148e-1,2.290143062071722e-1,0,0,0,
0,0,0,0,0,0,0,
-1.132277034144596e-1,-2.531848417709167e-1,0,0,0,0,0,
0,0,0,0,0,0,2.773500981126145e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
1.482498633322202e-1,-2.344036154692477e-1,0,0,0,0,0,
0,0,0,0,0,-1.815682598006408e-1,0,
1.657483860329490e-1,0,0,0,0,0,0,
0,0,0,1.896418623723042e-1,0,0,-8.655927155716765e-2,
0,0,0,0,0,0,0,
0,-1.832114449657378e-1,0,0,0,3.160697706205070e-2,0,
0,0,0,0,0,0,1.672484020014182e-1,
0,0,0,-5.997002248126639e-2,0,0,0,
0,0,0,0,-1.448413648755802e-1,0,0,
0,8.939803125353483e-2,0,0,0,0,0,
0,0,1.182624791978165e-1,0,0,0,-1.182624791978165e-1,
0,0,0,0,0,0,0,
-8.939803125353485e-2,0,0,0,1.448413648755803e-1,0,0,
0,0,0,0,0,5.997002248126640e-2,0,
0,0,-1.672484020014181e-1,0,0,0,0,
0,0,0,-3.160697706205070e-2,0,0,0,
1.832114449657378e-1,0,0,0,0,0,0,
0,0,8.655927155716765e-2,0,0,-1.896418623723042e-1,0,
0,0,0,0,0,0,0,
0,-1.657483860329490e-1,0,1.815682598006407e-1,0,0,0,
0,0,0,0,0,0,0,
2.344036154692477e-1,-1.482498633322202e-1,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
1.048284836721918e-1,-1.815682598006408e-1,1.815682598006408e-1,0,0,0,0,
0,0,0,0,0,-1.482498633322203e-1,0,
0,-1.815682598006408e-1,0,0,0,0,0,
0,0,0,1.672484020014182e-1,0,0,0,
1.340970468803023e-1,0,0,0,0,0,0,
0,-1.672484020014182e-1,0,0,0,0,-7.742096611387637e-2,
0,0,0,0,0,0,1.526762041381148e-1,
0,0,0,0,0,3.160697706205070e-2,0,
0,0,0,0,-1.277380770053171e-1,0,0,
0,0,0,-6.321395412410140e-2,0,0,0,
0,0,9.656090991705353e-2,0,0,0,0,
0,9.656090991705353e-2,0,0,0,0,0,
-6.321395412410141e-2,0,0,0,0,0,-1.277380770053171e-1,
0,0,0,0,0,3.160697706205071e-2,0,
0,0,0,0,1.526762041381148e-1,0,0,
0,0,0,0,-7.742096611387639e-2,0,0,
0,0,-1.672484020014181e-1,0,0,0,0,
0,0,0,1.340970468803023e-1,0,0,0,
1.672484020014182e-1,0,0,0,0,0,0,
0,0,-1.815682598006407e-1,0,0,-1.482498633322202e-1,0,
0,0,0,0,0,0,0,
0,1.815682598006407e-1,-1.815682598006407e-1,1.048284836721918e-1,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
8.770580193070292e-2,-1.519109050625500e-1,1.722507755289644e-1,-1.283881477532739e-1,0,0,0,
0,0,0,0,0,-1.339728254114167e-1,0,
0,0,1.657483860329489e-1,0,0,0,0,
0,0,0,1.564465546936860e-1,0,0,0,
0,-1.580348853102535e-1,0,0,0,0,0,
0,-1.564465546936859e-1,0,0,0,0,0,
1.224132957852822e-1,0,0,0,0,0,1.379728923974526e-1,
0,0,0,0,0,0,-7.633810206905742e-2,
0,0,0,0,-1.068733428966804e-1,0,0,
0,0,0,0,0,3.413943709994595e-2,0,
0,0,6.996502622814413e-2,0,0,0,0,
0,0,0,-6.996502622814413e-2,0,0,0,
-3.413943709994594e-2,0,0,0,0,0,0,
0,1.068733428966804e-1,0,0,0,0,7.633810206905742e-2,
0,0,0,0,0,0,-1.379728923974526e-1,
0,0,0,0,0,-1.224132957852822e-1,0,
0,0,0,0,1.564465546936860e-1,0,0,
0,0,0,0,1.580348853102535e-1,0,0,
0,0,-1.564465546936860e-1,0,0,0,0,
0,0,0,-1.657483860329489e-1,0,0,0,
1.339728254114167e-1,0,0,0,0,0,0,
0,0,1.283881477532739e-1,-1.722507755289644e-1,1.519109050625500e-1,-8.770580193070293e-2,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
8.238525545716344e-2,-1.378569000336139e-1,1.591834366881087e-1,-1.378569000336139e-1,8.238525545716345e-2,0,0,
0,0,0,0,0,-1.302625264297265e-1,0,
0,0,0,-1.302625264297265e-1,0,0,0,
0,0,0,1.521138589340318e-1,0,0,0,
0,0,1.521138589340319e-1,0,0,0,0,
0,-1.469559492086513e-1,0,0,0,0,0,
0,-1.469559492086513e-1,0,0,0,0,1.199890300758523e-1,
0,0,0,0,0,0,0,
1.199890300758524e-1,0,0,0,-8.049108834116178e-2,0,0,
0,0,0,0,0,0,-8.049108834116180e-2,
0,0,3.927562949192331e-2,0,0,0,0,
0,0,0,0,0,3.927562949192332e-2,0,
0,-8.049108834116180e-2,0,0,0,0,0,
0,0,0,-8.049108834116180e-2,0,0,0,
1.199890300758524e-1,0,0,0,0,0,0,
0,1.199890300758524e-1,0,0,0,0,-1.469559492086513e-1,
0,0,0,0,0,0,-1.469559492086513e-1,
0,0,0,0,0,1.521138589340319e-1,0,
0,0,0,0,1.521138589340319e-1,0,0,
0,0,0,0,-1.302625264297265e-1,0,0,
0,0,-1.302625264297265e-1,0,0,0,0,
0,0,0,8.238525545716345e-2,-1.378569000336139e-1,1.591834366881087e-1,-1.378569000336139e-1,
8.238525545716345e-2,0,0,0,0,0,0,
0,0,0,0,0,0,0,
8.432399730978855e-2,-1.333279464544214e-1,1.504142093990467e-1,-1.345345587992625e-1,9.513029883089881e-2,-4.756514941544941e-2,0,
0,0,0,0,0,-1.333279464544214e-1,0,
0,0,0,0,8.898624633166125e-2,0,0,
0,0,0,1.504142093990467e-1,0,0,0,
0,0,0,-1.229521683642505e-1,0,0,0,
0,-1.345345587992625e-1,0,0,0,0,0,
0,0,1.419729350050964e-1,0,0,0,9.513029883089880e-2,
0,0,0,0,0,0,0,
0,-1.419729350050964e-1,0,0,-4.756514941544941e-2,0,0,
0,0,0,0,0,0,0,
1.229521683642505e-1,0,0,8.898624633166125e-2,0,0,0,
0,0,0,0,0,0,-8.898624633166125e-2,
0,0,-1.229521683642505e-1,0,0,0,0,
0,0,0,0,0,4.756514941544941e-2,0,
0,1.419729350050964e-1,0,0,0,0,0,
0,0,0,-9.513029883089880e-2,0,0,0,
-1.419729350050964e-1,0,0,0,0,0,0,
0,1.345345587992625e-1,0,0,0,0,1.229521683642505e-1,
0,0,0,0,0,0,-1.504142093990467e-1,
0,0,0,0,0,-8.898624633166125e-2,0,
0,0,0,0,1.333279464544214e-1,0,0,
0,0,0,0,4.756514941544941e-2,-9.513029883089881e-2,1.345345587992625e-1,
-1.504142093990467e-1,1.333279464544214e-1,-8.432399730978855e-2,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
2.773500981126146e-1,0,0,0,0,0,0,
0,0,0,0,0,-2.773500981126146e-1,0,
0,0,0,0,0,0,0,
0,0,0,2.773500981126145e-1,0,0,0,
0,0,0,0,0,0,0,
0,-2.773500981126146e-1,0,0,0,0,0,
0,0,0,0,0,0,2.773500981126146e-1,
0,0,0,0,0,0,0,
0,0,0,0,-2.773500981126146e-1,0,0,
0,0,0,0,0,0,0,
0,0,2.773500981126146e-1,0,0,0,0,
0,0,0,0,0,0,0,
-2.773500981126146e-1,0,0,0,0,0,0,
0,0,0,0,0,2.773500981126145e-1,0,
0,0,0,0,0,0,0,
0,0,0,-2.773500981126146e-1,0,0,0,
0,0,0,0,0,0,0,
0,2.773500981126145e-1,0,0,0,0,0,
0,0,0,0,0,0,-2.773500981126146e-1,
0,0,0,0,0,0,0,
0,0,0,0,2.773500981126146e-1,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
1.048284836721918e-1,-2.567762955065477e-1,0,0,0,0,0,
0,0,0,0,0,-1.419384378754400e-1,0,
1.048284836721918e-1,0,0,0,0,0,0,
0,0,0,1.657483860329489e-1,0,-1.419384378754400e-1,0,
0,0,0,0,0,0,0,
0,-1.815682598006407e-1,0,1.657483860329489e-1,0,0,0,
0,0,0,0,0,0,1.913897505877382e-1,
0,-1.815682598006407e-1,0,0,0,0,0,
0,0,0,0,-1.961161351381841e-1,0,1.913897505877382e-1,
0,0,0,0,0,0,0,
0,0,1.961161351381840e-1,0,-1.961161351381841e-1,0,0,
0,0,0,0,0,0,0,
-1.913897505877382e-1,0,1.961161351381840e-1,0,0,0,0,
0,0,0,0,0,1.815682598006407e-1,0,
-1.913897505877382e-1,0,0,0,0,0,0,
0,0,0,-1.657483860329489e-1,0,1.815682598006407e-1,0,
0,0,0,0,0,0,0,
0,1.419384378754400e-1,0,-1.657483860329489e-1,0,0,0,
0,0,0,0,0,0,-1.048284836721918e-1,
0,1.419384378754400e-1,0,0,0,0,0,
0,0,0,0,0,2.567762955065477e-1,-1.048284836721918e-1,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
6.629935441317958e-2,-1.554857684028483e-1,2.198900824313101e-1,0,0,0,0,
0,0,0,0,0,-1.048284836721918e-1,0,
0,-1.554857684028483e-1,0,0,0,0,0,
0,0,0,1.340970468803023e-1,0,0,0,
6.629935441317958e-2,0,0,0,0,0,0,
0,-1.548419322277527e-1,0,0,0,-1.048284836721918e-1,0,
0,0,0,0,0,0,1.672484020014182e-1,
0,0,0,1.340970468803023e-1,0,0,0,
0,0,0,0,-1.713786140993951e-1,0,0,
0,-1.548419322277527e-1,0,0,0,0,0,
0,0,1.672484020014181e-1,0,0,0,1.672484020014182e-1,
0,0,0,0,0,0,0,
-1.548419322277527e-1,0,0,0,-1.713786140993951e-1,0,0,
0,0,0,0,0,1.340970468803023e-1,0,
0,0,1.672484020014181e-1,0,0,0,0,
0,0,0,-1.048284836721918e-1,0,0,0,
-1.548419322277527e-1,0,0,0,0,0,0,
0,6.629935441317958e-2,0,0,0,1.340970468803023e-1,0,
0,0,0,0,0,0,0,
-1.554857684028483e-1,0,0,-1.048284836721918e-1,0,0,0,
0,0,0,0,0,0,2.198900824313101e-1,
-1.554857684028483e-1,6.629935441317958e-2,0,0,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
5.241424183609591e-2,-1.172018077346239e-1,1.738383738412788e-1,-1.738383738412788e-1,0,0,0,
0,0,0,0,0,-9.078412990032035e-2,0,
0,0,1.738383738412788e-1,0,0,0,0,
0,0,0,1.224132957852822e-1,0,0,0,
0,-1.172018077346239e-1,0,0,0,0,0,
0,-1.448413648755803e-1,0,0,0,0,0,
5.241424183609591e-2,0,0,0,0,0,1.564465546936860e-1,
0,0,0,0,0,-9.078412990032035e-2,0,
0,0,0,0,-1.564465546936859e-1,0,0,
0,0,0,1.224132957852822e-1,0,0,0,
0,0,1.448413648755803e-1,0,0,0,0,
0,-1.448413648755803e-1,0,0,0,0,0,
-1.224132957852822e-1,0,0,0,0,0,1.564465546936860e-1,
0,0,0,0,0,9.078412990032035e-2,0,
0,0,0,0,-1.564465546936859e-1,0,0,
0,0,0,-5.241424183609591e-2,0,0,0,
0,0,1.448413648755803e-1,0,0,0,0,
0,0,1.172018077346239e-1,0,0,0,0,
-1.224132957852822e-1,0,0,0,0,0,0,
0,-1.738383738412788e-1,0,0,0,9.078412990032035e-2,0,
0,0,0,0,0,0,0,
1.738383738412788e-1,-1.738383738412788e-1,1.172018077346239e-1,-5.241424183609591e-2,0,0,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
4.756514941544941e-2,-1.009009190994469e-1,1.477038214645864e-1,-1.632927186332251e-1,1.264859959646828e-1,0,0,
0,0,0,0,0,-8.684168428648435e-2,0,
0,0,0,-1.632927186332251e-1,0,0,0,
0,0,0,1.199890300758524e-1,0,0,0,
0,0,1.477038214645864e-1,0,0,0,0,
0,-1.419729350050964e-1,0,0,0,0,0,
0,-1.009009190994469e-1,0,0,0,0,1.496526135717179e-1,
0,0,0,0,0,0,0,
4.756514941544941e-2,0,0,0,-1.419729350050964e-1,0,0,
0,0,0,0,0,-8.684168428648435e-2,0,
0,0,1.199890300758524e-1,0,0,0,0,
0,0,0,1.199890300758524e-1,0,0,0,
-8.684168428648435e-2,0,0,0,0,0,0,
0,-1.419729350050964e-1,0,0,0,4.756514941544941e-2,0,
0,0,0,0,0,0,1.496526135717179e-1,
0,0,0,0,-1.009009190994469e-1,0,0,
0,0,0,0,-1.419729350050964e-1,0,0,
0,0,0,1.477038214645864e-1,0,0,0,
0,0,1.199890300758524e-1,0,0,0,0,
0,0,-1.632927186332250e-1,0,0,0,0,
-8.684168428648435e-2,0,0,0,0,0,0,
0,1.264859959646828e-1,-1.632927186332250e-1,1.477038214645864e-1,-1.009009190994469e-1,4.756514941544941e-2,0,
0,0,0,0,0,0,0,
0,0,0,0,0,0,0,
4.756514941544941e-2,-9.513029883089880e-2,1.345345587992625e-1,-1.504142093990467e-1,1.333279464544214e-1,-8.432399730978855e-2,0,
0,0,0,0,0,-8.898624633166125e-2,0,
0,0,0,0,1.333279464544214e-1,0,0,
0,0,0,1.229521683642505e-1,0,0,0,
0,0,0,-1.504142093990467e-1,0,0,0,
0,-1.419729350050964e-1,0,0,0,0,0,
0,0,1.345345587992625e-1,0,0,0,1.419729350050964e-1,
0,0,0,0,0,0,0,
0,-9.513029883089880e-2,0,0,-1.229521683642505e-1,0,0,
0,0,0,0,0,0,0,
4.756514941544941e-2,0,8.898624633166125e-2,0,0,0,0,
0,0,0,0,0,-8.898624633166125e-2,0,
-4.756514941544941e-2,0,0,0,0,0,0,
0,0,0,1.229521683642505e-1,0,0,9.513029883089881e-2,
0,0,0,0,0,0,0,
0,-1.419729350050964e-1,0,0,0,-1.345345587992625e-1,0,
0,0,0,0,0,0,1.419729350050964e-1,
0,0,0,0,1.504142093990467e-1,0,0,
0,0,0,0,-1.229521683642505e-1,0,0,
0,0,0,-1.333279464544214e-1,0,0,0,
0,0,8.898624633166125e-2,0,0,0,0,
0,0,8.432399730978855e-2,-1.333279464544214e-1,1.504142093990467e-1,-1.345345587992625e-1,9.513029883089881e-2,
-4.756514941544941e-2,0,0,0,0,0,0,
0,0,0,0,0,0,0,
5.118272511620992e-2,-9.575411075314348e-2,1.291148166001188e-1,-1.414381951200550e-1,1.291148166001188e-1,-9.575411075314348e-2,5.118272511620992e-2,
0,0,0,0,0,-9.575411075314348e-2,0,
0,0,0,0,0,-9.575411075314348e-2,0,
0,0,0,1.291148166001188e-1,0,0,0,
0,0,0,0,1.291148166001188e-1,0,0,
0,-1.414381951200550e-1,0,0,0,0,0,
0,0,0,-1.414381951200550e-1,0,0,1.291148166001188e-1,
0,0,0,0,0,0,0,
0,0,1.291148166001188e-1,0,-9.575411075314348e-2,0,0,
0,0,0,0,0,0,0,
0,-9.575411075314348e-2,5.118272511620992e-2,0,0,0,0,
0,0,0,0,0,0,0,
5.118272511620992e-2,-9.575411075314348e-2,0,0,0,0,0,
0,0,0,0,0,-9.575411075314348e-2,0,
1.291148166001188e-1,0,0,0,0,0,0,
0,0,0,1.291148166001188e-1,0,0,-1.414381951200550e-1,
0,0,0,0,0,0,0,
0,-1.414381951200550e-1,0,0,0,1.291148166001188e-1,0,
0,0,0,0,0,0,1.291148166001188e-1,
0,0,0,0,-9.575411075314348e-2,0,0,
0,0,0,0,-9.575411075314348e-2,0,0,
0,0,0,5.118272511620992e-2,-9.575411075314348e-2,1.291148166001188e-1,-1.414381951200551e-1,
1.291148166001188e-1,-9.575411075314348e-2,5.118272511620992e-2,0,0,0,0,
0,0}};
};

}

#endif

