/*****************************************************************************
 *
 *  Copyright (C) 2003 Cdric Brgardis <cedric.bregardis@free.fr>
 *
 *  This file is part of BRIQUOLO
 *
 *  BRIQUOLO is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  BRIQUOLO is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with BRIQUOLO; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *****************************************************************************/
#include "Sauvegarder.h"
#include "I18n.h"

Sauvegarder::Sauvegarder(MOGL_Panneau * p_Panneau): MOGL_Panneau(p_Panneau, _("Save"), 300, 220)
{
  MOGL_Struct_Couleur coulSel;
  coulSel.r=.32f;
  coulSel.g=.74f;
  coulSel.b=1.0f;
  coulSel.a=.6f;

  MOGL_Struct_Couleur coulTitre;
  coulTitre.r=0.84f;
  coulTitre.g=0.88f;
  coulTitre.b=1.0f;
  coulTitre.a=1;

  SetCouleurLabel(coulTitre);

  _NomGroupe=new MOGL_SaisieChaine(this, _("Group directory"));
  _NomGroupe->SetCouleurFondFocus(coulSel);

  _NomTableau=new MOGL_SaisieChaine(this, _("Name"));
  _NomTableau->SetCouleurFondFocus(coulSel);

  _Sep=new MOGL_Separateur(this);

  _Ok=new MOGL_Bouton(this, _("Ok"));
  _Ok->SetCouleurFondFocus(coulSel);
  _Ok->Activation.Connecter(this, &Sauvegarder::_OnOk);

  _Annuler=new MOGL_Bouton(this, _("Cancel"));
  _Annuler->SetCouleurFondFocus(coulSel);
  _Annuler->Activation.Connecter(this, &Sauvegarder::_OnAnnuler);
}

Sauvegarder::~Sauvegarder()
{
  delete _Annuler;
  delete _Ok;
  delete _Sep;
  delete _NomTableau;
  delete _NomGroupe;
}

void Sauvegarder::_OnOk()
{
  DemanderEnregistrement.Emettre(_NomGroupe->GetChaine(), _NomTableau->GetChaine());
  SetActivation(false);
}

void Sauvegarder::_OnAnnuler()
{
  SetActivation(false);
}
