/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package eric.GUI.window;

import eric.FileTools;
import eric.GUI.pipe_tools;
import eric.GUI.themes;
import eric.Media;
import java.awt.Image;
import java.awt.Point;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;

/**
 *
 * @author erichake
 */
public class MainApplet extends JApplet implements MainContainer {

    private ContentPane CONTENT;

    public MainApplet() {
    }

    @Override
    public void init() {
        try {
            pipe_tools.init(this);
            SwingUtilities.invokeAndWait(new Runnable() {

                public void run() {
                    createGUI();
                    openFILES();
                }
            });
        } catch (Exception ex) {
        }



    }

    @Override
    public void start() {
    }

    public void createGUI() {
        tab_main_panel.removeAllBtns(CONTENT);
        Media.clearMedias();
        setLayout(null);
        themes.init();
        CONTENT=new ContentPane();
        setContentPane(CONTENT);
    }

    public void openFILES() {
        try {
            final String filename=getParameter("file");
            URL url=new URL(getCodeBase(), filename);
            if (url.getFile().toLowerCase().endsWith(".zirs")) {
                FileTools.openWorkBook(new URL(getCodeBase(), filename));
            }
        } catch (Exception ex) {
        }
    }

    public void setComponents() {
        CONTENT.setComponents();
    }

    public ContentPane getContent() {
        return CONTENT;
    }

    public Point getMouseLoc() {
        return CONTENT.getMousePosition();
    }

    public Image getImage(String s) {
        Image myimage;
        myimage=getImage(themes.class.getResource(themes.getCommonThemePath()+s));
        if (myimage==null) {
            myimage=getImage(themes.class.getResource(themes.getCurrentThemePath()+s));
        }
        if (myimage==null) {
            myimage=getImage(themes.class.getResource(themes.getCommonThemePath()+"null.gif"));
        }
        return myimage;
    }

    public Image getPaletteImage(String s) {
        Image myimage;
        try {
            myimage=getImage(themes.class.getResource(themes.getPalettePath()+s+".png"));
        } catch (final Exception e) {
            try {
                myimage=getImage(themes.class.getResource(themes.getPalettePath()+s+".gif"));
            } catch (final Exception ex) {
                try {
                    myimage=getImage(themes.class.getResource(themes.getBarPath()+s+".png"));
                } catch (final Exception ex2) {
                    try {
                        myimage=getImage(themes.class.getResource(themes.getBarPath()+s+".gif"));
                    } catch (final Exception ex3) {
                        myimage=getImage(themes.class.getResource(themes.getCommonThemePath()+"null.gif"));
                    }
                }
            }
        }
        return myimage;
    }

    public boolean isApplet() {
        return true;
    }

    @Override
    public void setLocation(int x, int y) {
    }

    @Override
    public Point getLocation() {
        return new Point(0, 0);
    }

    @Override
    public void setSize(int w, int h) {
    }
}
