{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdReplaceNames: TMFString;
    { Internal wrapper for property @link(ReplaceNames). This wrapper API may change, we advise to access simpler @link(ReplaceNames) instead. }
    public property FdReplaceNames: TMFString read FFdReplaceNames;
    {  }
    procedure SetReplaceNames(const Value: array of string); overload;
    {  }
    procedure SetReplaceNames(const Value: TCastleStringList); overload;

    strict private FFdReplaceNodes: TMFNode;
    { Internal wrapper for property @link(ReplaceNodes). This wrapper API may change, we advise to access simpler @link(ReplaceNodes) instead. }
    public property FdReplaceNodes: TMFNode read FFdReplaceNodes;
    {  }
    procedure SetReplaceNodes(const Value: array of TAbstractNode);

{$endif read_interface}

{$ifdef read_implementation}

{ TKambiInlineNode ----------------------------------------------- }

procedure TKambiInlineNode.SetReplaceNames(const Value: array of string);
begin
  FdReplaceNames.Send(Value);
end;

procedure TKambiInlineNode.SetReplaceNames(const Value: TCastleStringList);
begin
  FdReplaceNames.Send(Value);
end;

procedure TKambiInlineNode.SetReplaceNodes(const Value: array of TAbstractNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractNode));
  FdReplaceNodes.Send(A);
end;

class function TKambiInlineNode.ClassX3DType: String;
begin
  Result := 'KambiInline';
end;

procedure TKambiInlineNode.CreateNode;
begin
  inherited;

  FFdReplaceNames := TMFString.Create(Self, True, 'replaceNames', []);
   FdReplaceNames.ChangeAlways := chEverything;
  AddField(FFdReplaceNames);

  FFdReplaceNodes := TMFNode.Create(Self, True, 'replaceNodes', [TAbstractNode]);
   FdReplaceNodes.ChangeAlways := chEverything;
  AddField(FFdReplaceNodes);
end;

{$endif read_implementation}
