/* Generated from scheduler.scm by the CHICKEN compiler
   http://www.call-cc.org
   2017-02-19 13:17
   Version 4.12.0 (rev 6ea24b6)
   linux-unix-gnu-x86-64 [ 64bit manyargs ptables ]
   compiled 2017-02-19 on yves.more-magic.net (Linux)
   command line: scheduler.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -types ./types.db -explicit-use -no-trace -output-file scheduler.c
   unit: scheduler
*/

#include "chicken.h"

#ifdef HAVE_ERRNO_H
# include <errno.h>
# define C_signal_interrupted_p     C_mk_bool(errno == EINTR)
#else
# define C_signal_interrupted_p     C_SCHEME_FALSE
#endif

#ifdef _WIN32
/* TODO: Winsock select() only works for sockets */
# include <winsock2.h>
/* Beware: winsock2.h must come BEFORE windows.h */
# define C_msleep(n)     (Sleep(C_unfix(n)), C_SCHEME_TRUE)
#else
# include <sys/time.h>
static C_word C_msleep(C_word ms);
C_word C_msleep(C_word ms) {
#ifdef __CYGWIN__
  if(usleep(C_unfix(ms) * 1000) == -1) return C_SCHEME_FALSE;
#else
  struct timespec ts;
  unsigned long mss = C_unfix(ms);
  ts.tv_sec = mss / 1000;
  ts.tv_nsec = (mss % 1000) * 1000000;
  
  if(nanosleep(&ts, NULL) == -1) return C_SCHEME_FALSE;
#endif
  return C_SCHEME_TRUE;
}
#endif

#ifdef NO_POSIX_POLL

/* Shouldn't we include <sys/select.h> here? */
static fd_set C_fdset_input, C_fdset_output;

#define C_fd_input_ready(fd,pos)  C_mk_bool(FD_ISSET(C_unfix(fd), &C_fdset_input))
#define C_fd_output_ready(fd,pos)  C_mk_bool(FD_ISSET(C_unfix(fd), &C_fdset_output))

C_inline int C_ready_fds_timeout(int to, double tm) {
  struct timeval timeout;
  timeout.tv_sec = tm / 1000;
  timeout.tv_usec = fmod(tm, 1000) * 1000;
  /* we use FD_SETSIZE, but really should use max fd */
  return select(FD_SETSIZE, &C_fdset_input, &C_fdset_output, NULL, to ? &timeout : NULL);
}

C_inline void C_prepare_fdset(int length) {
  FD_ZERO(&C_fdset_input);
  FD_ZERO(&C_fdset_output);
}

C_inline void C_fdset_add(int fd, int input, int output) {
  if (input) FD_SET(fd, &C_fdset_input);
  if (output) FD_SET(fd, &C_fdset_output);
}

#else
#  include <poll.h>
#  include <assert.h>

static int C_fdset_nfds;
static struct pollfd *C_fdset_set = NULL;

C_inline int C_fd_ready(int fd, int pos, int what) {
  assert(fd == C_fdset_set[pos].fd); /* Must match position in ##sys#fd-list! */
  return(C_fdset_set[pos].revents & what);
}

#define C_fd_input_ready(fd,pos)  C_mk_bool(C_fd_ready(C_unfix(fd), C_unfix(pos),POLLIN|POLLERR|POLLHUP|POLLNVAL))
#define C_fd_output_ready(fd,pos)  C_mk_bool(C_fd_ready(C_unfix(fd), C_unfix(pos),POLLOUT|POLLERR|POLLHUP|POLLNVAL))

C_inline int C_ready_fds_timeout(int to, double tm) {
  return poll(C_fdset_set, C_fdset_nfds, to ? (int)tm : -1);
}

C_inline void C_prepare_fdset(int length) {
  /* TODO: Only realloc when needed? */
  C_fdset_set = realloc(C_fdset_set, sizeof(struct pollfd) * length);
  if (C_fdset_set == NULL)
    C_halt(C_SCHEME_FALSE); /* Ugly: no message */
  C_fdset_nfds = 0;
}

/* This *must* be called in order, so position will match ##sys#fd-list */
C_inline void C_fdset_add(int fd, int input, int output) {
  C_fdset_set[C_fdset_nfds].events = ((input ? POLLIN : 0) | (output ? POLLOUT : 0));
  C_fdset_set[C_fdset_nfds++].fd = fd;
}
#endif

static C_PTABLE_ENTRY *create_ptable(void);

static C_TLS C_word lf[65];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,7),40,108,111,111,112,50,41,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,26),40,108,111,111,112,50,32,116,104,114,101,97,100,115,53,48,56,32,107,101,101,112,53,48,57,41,0,0,0,0,0,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,25),40,108,111,111,112,32,110,52,57,52,32,112,111,115,52,57,53,32,108,115,116,52,57,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,11),40,103,51,54,53,32,116,51,55,52,41,0,0,0,0,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,51,54,52,32,103,51,55,49,52,48,54,41,0,0,0,0,0,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,108,115,116,51,53,56,41,0,0,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,108,115,116,49,51,56,41,0,0,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,7),40,108,111,111,112,49,41,0};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,115,99,104,101,100,117,108,101,41};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,102,111,114,99,101,45,112,114,105,109,111,114,100,105,97,108,41};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,114,101,97,100,121,45,113,117,101,117,101,41,0,0,0,0,0};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,97,100,100,45,116,111,45,114,101,97,100,121,45,113,117,101,117,101,32,116,104,114,101,97,100,49,55,50,41,0,0,0,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,7),40,97,49,50,57,52,41,0};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,105,110,116,101,114,114,117,112,116,45,104,111,111,107,32,114,101,97,115,111,110,50,48,51,32,115,116,97,116,101,50,48,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,14),40,108,111,111,112,32,112,114,101,118,50,49,51,41,0,0};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,114,101,109,111,118,101,45,102,114,111,109,45,116,105,109,101,111,117,116,45,108,105,115,116,32,116,50,49,48,41,0,0,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,20),40,108,111,111,112,32,116,108,50,51,51,32,112,114,101,118,50,51,52,41,0,0,0,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,44),40,35,35,115,121,115,35,116,104,114,101,97,100,45,98,108,111,99,107,45,102,111,114,45,116,105,109,101,111,117,116,33,32,116,50,49,56,32,116,109,50,49,57,41,0,0,0,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,48),40,35,35,115,121,115,35,116,104,114,101,97,100,45,98,108,111,99,107,45,102,111,114,45,116,101,114,109,105,110,97,116,105,111,110,33,32,116,50,52,52,32,116,50,50,52,53,41};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,12),40,103,51,48,55,32,116,50,51,49,54,41,0,0,0,0};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,51,48,54,32,103,51,49,51,51,49,56,41,0,0,0,0,0,0};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,50,55,50,32,103,50,55,57,50,56,52,41,0,0,0,0,0,0};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,50,53,56,32,103,50,54,53,50,57,50,41,0,0,0,0,0,0};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,116,104,114,101,97,100,45,107,105,108,108,33,32,116,50,57,54,32,115,50,57,55,41,0,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,116,104,114,101,97,100,45,98,97,115,105,99,45,117,110,98,108,111,99,107,33,32,116,51,51,49,41,0,0,0,0,0,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,7),40,97,49,55,49,51,41,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,40),40,35,35,115,121,115,35,100,101,102,97,117,108,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,97,114,103,51,51,53,41};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,108,115,116,52,54,52,41,0,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,47),40,35,35,115,121,115,35,116,104,114,101,97,100,45,98,108,111,99,107,45,102,111,114,45,105,47,111,33,32,116,52,54,48,32,102,100,52,54,49,32,105,47,111,52,54,50,41,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,108,115,116,53,52,50,41,0,0,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,40),40,35,35,115,121,115,35,99,108,101,97,114,45,105,47,111,45,115,116,97,116,101,45,102,111,114,45,116,104,114,101,97,100,33,32,116,53,51,57,41};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,39),40,102,95,50,52,57,49,32,113,117,101,117,101,53,54,54,32,97,114,103,53,54,55,32,118,97,108,53,54,56,32,105,110,105,116,53,54,57,41,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,53,56,48,41,0,0,0,0,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,108,53,56,51,32,105,53,56,52,41};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,108,53,55,54,32,105,53,55,55,41};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,108,53,55,51,32,105,53,55,52,41};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,97,108,108,45,116,104,114,101,97,100,115,32,46,32,116,109,112,53,53,54,53,53,55,41,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,102,101,116,99,104,45,97,110,100,45,99,108,101,97,114,45,116,104,114,101,97,100,115,41,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,114,101,115,116,111,114,101,45,116,104,114,101,97,100,115,32,118,101,99,53,57,53,41,0,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,116,104,114,101,97,100,45,117,110,98,108,111,99,107,33,32,116,54,48,48,41,0,0,0,0};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,14),40,115,117,115,112,101,110,100,32,116,54,49,48,41,0,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,11),40,103,54,49,54,32,97,54,50,53,41,0,0,0,0,0};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,52,53,32,103,54,53,50,54,53,54,41,0,0,0,0,0,0};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,11),40,103,54,51,51,32,97,54,52,50,41,0,0,0,0,0};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,51,50,32,103,54,51,57,54,54,48,41,0,0,0,0,0,0};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,49,53,32,103,54,50,50,54,50,55,41,0,0,0,0,0,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,107,105,108,108,45,111,116,104,101,114,45,116,104,114,101,97,100,115,32,116,104,117,110,107,54,48,55,41,0,0,0,0,0};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from g478 */
C_regparm static C_word C_fcall stub482(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_truep(C_a0);
double t1=(double )C_c_double(C_a1);
C_r=C_fix((C_word)C_ready_fds_timeout(t0,t1));
return C_r;}

/* from g409 */
C_regparm static C_word C_fcall stub414(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_truep(C_a1);
int t2=(int )C_truep(C_a2);
C_fdset_add(t0,t1,t2);
return C_r;}

/* from g351 */
C_regparm static C_word C_fcall stub354(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_prepare_fdset(t0);
return C_r;}

C_noret_decl(f_1749)
static void C_fcall f_1749(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1499)
static void C_ccall f_1499(C_word c,C_word *av) C_noret;
C_noret_decl(f_2491)
static void C_ccall f_2491(C_word c,C_word *av) C_noret;
C_noret_decl(f_1834)
static void C_ccall f_1834(C_word c,C_word *av) C_noret;
C_noret_decl(f_1694)
static void C_ccall f_1694(C_word c,C_word *av) C_noret;
C_noret_decl(f_1738)
static void C_fcall f_1738(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1846)
static void C_fcall f_1846(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2191)
static void C_ccall f_2191(C_word c,C_word *av) C_noret;
C_noret_decl(f_2197)
static void C_ccall f_2197(C_word c,C_word *av) C_noret;
C_noret_decl(f_1690)
static void C_ccall f_1690(C_word c,C_word *av) C_noret;
C_noret_decl(f_2194)
static void C_ccall f_2194(C_word c,C_word *av) C_noret;
C_noret_decl(f_2182)
static void C_ccall f_2182(C_word c,C_word *av) C_noret;
C_noret_decl(f_2374)
static void C_fcall f_2374(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2188)
static void C_ccall f_2188(C_word c,C_word *av) C_noret;
C_noret_decl(f_1295)
static void C_ccall f_1295(C_word c,C_word *av) C_noret;
C_noret_decl(f_1598)
static void C_ccall f_1598(C_word c,C_word *av) C_noret;
C_noret_decl(f_1580)
static void C_ccall f_1580(C_word c,C_word *av) C_noret;
C_noret_decl(f_2545)
static void C_ccall f_2545(C_word c,C_word *av) C_noret;
C_noret_decl(f_2542)
static void C_ccall f_2542(C_word c,C_word *av) C_noret;
C_noret_decl(f_2203)
static void C_ccall f_2203(C_word c,C_word *av) C_noret;
C_noret_decl(f_2200)
static void C_ccall f_2200(C_word c,C_word *av) C_noret;
C_noret_decl(f_1281)
static void C_ccall f_1281(C_word c,C_word *av) C_noret;
C_noret_decl(f_2539)
static void C_fcall f_2539(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1302)
static void C_ccall f_1302(C_word c,C_word *av) C_noret;
C_noret_decl(f_1308)
static C_word C_fcall f_1308(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_2529)
static void C_ccall f_2529(C_word c,C_word *av) C_noret;
C_noret_decl(f_1655)
static void C_ccall f_1655(C_word c,C_word *av) C_noret;
C_noret_decl(f_2446)
static void C_fcall f_2446(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2668)
static void C_fcall f_2668(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2439)
static void C_ccall f_2439(C_word c,C_word *av) C_noret;
C_noret_decl(f_1634)
static void C_ccall f_1634(C_word c,C_word *av) C_noret;
C_noret_decl(f_2421)
static void C_fcall f_2421(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1277)
static void C_ccall f_1277(C_word c,C_word *av) C_noret;
C_noret_decl(f_1624)
static void C_fcall f_1624(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2390)
static void C_ccall f_2390(C_word c,C_word *av) C_noret;
C_noret_decl(f_2397)
static void C_fcall f_2397(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2416)
static void C_ccall f_2416(C_word c,C_word *av) C_noret;
C_noret_decl(f_1377)
static void C_fcall f_1377(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2217)
static void C_ccall f_2217(C_word c,C_word *av) C_noret;
C_noret_decl(f_2678)
static void C_ccall f_2678(C_word c,C_word *av) C_noret;
C_noret_decl(f_2211)
static void C_ccall f_2211(C_word c,C_word *av) C_noret;
C_noret_decl(f_2214)
static void C_ccall f_2214(C_word c,C_word *av) C_noret;
C_noret_decl(f_1367)
static void C_fcall f_1367(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1605)
static void C_fcall f_1605(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2287)
static void C_fcall f_2287(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1911)
static void C_ccall f_1911(C_word c,C_word *av) C_noret;
C_noret_decl(f_1917)
static void C_ccall f_1917(C_word c,C_word *av) C_noret;
C_noret_decl(f_1914)
static void C_ccall f_1914(C_word c,C_word *av) C_noret;
C_noret_decl(f_2601)
static void C_ccall f_2601(C_word c,C_word *av) C_noret;
C_noret_decl(f_1551)
static void C_ccall f_1551(C_word c,C_word *av) C_noret;
C_noret_decl(f_2602)
static void C_fcall f_2602(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1905)
static void C_ccall f_1905(C_word c,C_word *av) C_noret;
C_noret_decl(f_1178)
static void C_ccall f_1178(C_word c,C_word *av) C_noret;
C_noret_decl(f_1004)
static void C_fcall f_1004(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1175)
static void C_ccall f_1175(C_word c,C_word *av) C_noret;
C_noret_decl(f_1420)
static void C_ccall f_1420(C_word c,C_word *av) C_noret;
C_noret_decl(f_1541)
static void C_fcall f_1541(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2258)
static void C_ccall f_2258(C_word c,C_word *av) C_noret;
C_noret_decl(f_2050)
static void C_ccall f_2050(C_word c,C_word *av) C_noret;
C_noret_decl(f_2052)
static void C_fcall f_2052(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_1164)
static void C_ccall f_1164(C_word c,C_word *av) C_noret;
C_noret_decl(f_1434)
static void C_ccall f_1434(C_word c,C_word *av) C_noret;
C_noret_decl(f_1432)
static void C_ccall f_1432(C_word c,C_word *av) C_noret;
C_noret_decl(f_1923)
static void C_ccall f_1923(C_word c,C_word *av) C_noret;
C_noret_decl(f_1920)
static void C_ccall f_1920(C_word c,C_word *av) C_noret;
C_noret_decl(f_1926)
static void C_ccall f_1926(C_word c,C_word *av) C_noret;
C_noret_decl(f_1929)
static void C_ccall f_1929(C_word c,C_word *av) C_noret;
C_noret_decl(f_1429)
static void C_ccall f_1429(C_word c,C_word *av) C_noret;
C_noret_decl(f_1426)
static void C_ccall f_1426(C_word c,C_word *av) C_noret;
C_noret_decl(f_1110)
static void C_fcall f_1110(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2611)
static void C_fcall f_2611(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_988)
static void C_fcall f_988(C_word t0,C_word t1) C_noret;
C_noret_decl(f_983)
static void C_ccall f_983(C_word c,C_word *av) C_noret;
C_noret_decl(f_1515)
static void C_fcall f_1515(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2026)
static void C_fcall f_2026(C_word t0,C_word t1) C_noret;
C_noret_decl(f_953)
static void C_ccall f_953(C_word c,C_word *av) C_noret;
C_noret_decl(f_2017)
static void C_ccall f_2017(C_word c,C_word *av) C_noret;
C_noret_decl(f_2081)
static void C_fcall f_2081(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1810)
static void C_ccall f_1810(C_word c,C_word *av) C_noret;
C_noret_decl(f_1813)
static void C_ccall f_1813(C_word c,C_word *av) C_noret;
C_noret_decl(f_1000)
static void C_fcall f_1000(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1678)
static void C_ccall f_1678(C_word c,C_word *av) C_noret;
C_noret_decl(f_1525)
static void C_ccall f_1525(C_word c,C_word *av) C_noret;
C_noret_decl(f_2462)
static void C_ccall f_2462(C_word c,C_word *av) C_noret;
C_noret_decl(f_1700)
static void C_ccall f_1700(C_word c,C_word *av) C_noret;
C_noret_decl(f_1672)
static void C_ccall f_1672(C_word c,C_word *av) C_noret;
C_noret_decl(C_scheduler_toplevel)
C_externexport void C_ccall C_scheduler_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(f_1801)
static void C_ccall f_1801(C_word c,C_word *av) C_noret;
C_noret_decl(f_1807)
static void C_ccall f_1807(C_word c,C_word *av) C_noret;
C_noret_decl(f_1804)
static void C_ccall f_1804(C_word c,C_word *av) C_noret;
C_noret_decl(f_995)
static void C_ccall f_995(C_word c,C_word *av) C_noret;
C_noret_decl(f_992)
static void C_ccall f_992(C_word c,C_word *av) C_noret;
C_noret_decl(f_2356)
static void C_ccall f_2356(C_word c,C_word *av) C_noret;
C_noret_decl(f_1871)
static void C_ccall f_1871(C_word c,C_word *av) C_noret;
C_noret_decl(f_1061)
static void C_fcall f_1061(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2590)
static void C_fcall f_2590(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2344)
static void C_ccall f_2344(C_word c,C_word *av) C_noret;
C_noret_decl(f_1932)
static void C_ccall f_1932(C_word c,C_word *av) C_noret;
C_noret_decl(f_1792)
static void C_ccall f_1792(C_word c,C_word *av) C_noret;
C_noret_decl(f_2589)
static void C_ccall f_2589(C_word c,C_word *av) C_noret;
C_noret_decl(f_1798)
static void C_ccall f_1798(C_word c,C_word *av) C_noret;
C_noret_decl(f_1356)
static void C_ccall f_1356(C_word c,C_word *av) C_noret;
C_noret_decl(f_2325)
static void C_ccall f_2325(C_word c,C_word *av) C_noret;
C_noret_decl(f_1954)
static void C_ccall f_1954(C_word c,C_word *av) C_noret;
C_noret_decl(f_1950)
static void C_ccall f_1950(C_word c,C_word *av) C_noret;
C_noret_decl(f_1856)
static void C_ccall f_1856(C_word c,C_word *av) C_noret;
C_noret_decl(f_1347)
static void C_fcall f_1347(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2561)
static void C_ccall f_2561(C_word c,C_word *av) C_noret;
C_noret_decl(f_1343)
static void C_ccall f_1343(C_word c,C_word *av) C_noret;
C_noret_decl(f_2564)
static void C_ccall f_2564(C_word c,C_word *av) C_noret;
C_noret_decl(f_2645)
static void C_fcall f_2645(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2120)
static void C_ccall f_2120(C_word c,C_word *av) C_noret;
C_noret_decl(f_2640)
static void C_ccall f_2640(C_word c,C_word *av) C_noret;
C_noret_decl(f_2301)
static void C_ccall f_2301(C_word c,C_word *av) C_noret;
C_noret_decl(f_2303)
static void C_fcall f_2303(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2621)
static void C_ccall f_2621(C_word c,C_word *av) C_noret;
C_noret_decl(f_1969)
static void C_fcall f_1969(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2655)
static void C_ccall f_2655(C_word c,C_word *av) C_noret;
C_noret_decl(f_1095)
static void C_ccall f_1095(C_word c,C_word *av) C_noret;
C_noret_decl(f_1098)
static void C_ccall f_1098(C_word c,C_word *av) C_noret;
C_noret_decl(f_2161)
static void C_ccall f_2161(C_word c,C_word *av) C_noret;
C_noret_decl(f_2510)
static void C_ccall f_2510(C_word c,C_word *av) C_noret;
C_noret_decl(f_2635)
static void C_ccall f_2635(C_word c,C_word *av) C_noret;
C_noret_decl(f_2158)
static void C_ccall f_2158(C_word c,C_word *av) C_noret;
C_noret_decl(f_1574)
static void C_fcall f_1574(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1577)
static void C_ccall f_1577(C_word c,C_word *av) C_noret;
C_noret_decl(f_2500)
static void C_ccall f_2500(C_word c,C_word *av) C_noret;
C_noret_decl(f_1714)
static void C_ccall f_1714(C_word c,C_word *av) C_noret;
C_noret_decl(f_1718)
static void C_ccall f_1718(C_word c,C_word *av) C_noret;
C_noret_decl(f_1564)
static void C_ccall f_1564(C_word c,C_word *av) C_noret;
C_noret_decl(f_1568)
static void C_ccall f_1568(C_word c,C_word *av) C_noret;

C_noret_decl(trf_1749)
static void C_ccall trf_1749(C_word c,C_word *av) C_noret;
static void C_ccall trf_1749(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1749(t0,t1,t2);}

C_noret_decl(trf_1738)
static void C_ccall trf_1738(C_word c,C_word *av) C_noret;
static void C_ccall trf_1738(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1738(t0,t1,t2);}

C_noret_decl(trf_1846)
static void C_ccall trf_1846(C_word c,C_word *av) C_noret;
static void C_ccall trf_1846(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1846(t0,t1,t2);}

C_noret_decl(trf_2374)
static void C_ccall trf_2374(C_word c,C_word *av) C_noret;
static void C_ccall trf_2374(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_2374(t0,t1,t2,t3);}

C_noret_decl(trf_2539)
static void C_ccall trf_2539(C_word c,C_word *av) C_noret;
static void C_ccall trf_2539(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2539(t0,t1);}

C_noret_decl(trf_2446)
static void C_ccall trf_2446(C_word c,C_word *av) C_noret;
static void C_ccall trf_2446(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_2446(t0,t1,t2,t3);}

C_noret_decl(trf_2668)
static void C_ccall trf_2668(C_word c,C_word *av) C_noret;
static void C_ccall trf_2668(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_2668(t0,t1,t2);}

C_noret_decl(trf_2421)
static void C_ccall trf_2421(C_word c,C_word *av) C_noret;
static void C_ccall trf_2421(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_2421(t0,t1,t2);}

C_noret_decl(trf_1624)
static void C_ccall trf_1624(C_word c,C_word *av) C_noret;
static void C_ccall trf_1624(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1624(t0,t1,t2);}

C_noret_decl(trf_2397)
static void C_ccall trf_2397(C_word c,C_word *av) C_noret;
static void C_ccall trf_2397(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_2397(t0,t1,t2,t3);}

C_noret_decl(trf_1377)
static void C_ccall trf_1377(C_word c,C_word *av) C_noret;
static void C_ccall trf_1377(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1377(t0,t1);}

C_noret_decl(trf_1367)
static void C_ccall trf_1367(C_word c,C_word *av) C_noret;
static void C_ccall trf_1367(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_1367(t0,t1,t2,t3);}

C_noret_decl(trf_1605)
static void C_ccall trf_1605(C_word c,C_word *av) C_noret;
static void C_ccall trf_1605(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1605(t0,t1,t2);}

C_noret_decl(trf_2287)
static void C_ccall trf_2287(C_word c,C_word *av) C_noret;
static void C_ccall trf_2287(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2287(t0,t1);}

C_noret_decl(trf_2602)
static void C_ccall trf_2602(C_word c,C_word *av) C_noret;
static void C_ccall trf_2602(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_2602(t0,t1,t2);}

C_noret_decl(trf_1004)
static void C_ccall trf_1004(C_word c,C_word *av) C_noret;
static void C_ccall trf_1004(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1004(t0,t1);}

C_noret_decl(trf_1541)
static void C_ccall trf_1541(C_word c,C_word *av) C_noret;
static void C_ccall trf_1541(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1541(t0,t1,t2);}

C_noret_decl(trf_2052)
static void C_ccall trf_2052(C_word c,C_word *av) C_noret;
static void C_ccall trf_2052(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_2052(t0,t1,t2,t3,t4);}

C_noret_decl(trf_1110)
static void C_ccall trf_1110(C_word c,C_word *av) C_noret;
static void C_ccall trf_1110(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1110(t0,t1);}

C_noret_decl(trf_2611)
static void C_ccall trf_2611(C_word c,C_word *av) C_noret;
static void C_ccall trf_2611(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_2611(t0,t1,t2);}

C_noret_decl(trf_988)
static void C_ccall trf_988(C_word c,C_word *av) C_noret;
static void C_ccall trf_988(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_988(t0,t1);}

C_noret_decl(trf_1515)
static void C_ccall trf_1515(C_word c,C_word *av) C_noret;
static void C_ccall trf_1515(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1515(t0,t1,t2);}

C_noret_decl(trf_2026)
static void C_ccall trf_2026(C_word c,C_word *av) C_noret;
static void C_ccall trf_2026(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2026(t0,t1);}

C_noret_decl(trf_2081)
static void C_ccall trf_2081(C_word c,C_word *av) C_noret;
static void C_ccall trf_2081(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_2081(t0,t1,t2,t3);}

C_noret_decl(trf_1000)
static void C_ccall trf_1000(C_word c,C_word *av) C_noret;
static void C_ccall trf_1000(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1000(t0,t1);}

C_noret_decl(trf_1061)
static void C_ccall trf_1061(C_word c,C_word *av) C_noret;
static void C_ccall trf_1061(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1061(t0,t1,t2);}

C_noret_decl(trf_2590)
static void C_ccall trf_2590(C_word c,C_word *av) C_noret;
static void C_ccall trf_2590(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_2590(t0,t1,t2);}

C_noret_decl(trf_1347)
static void C_ccall trf_1347(C_word c,C_word *av) C_noret;
static void C_ccall trf_1347(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1347(t0,t1);}

C_noret_decl(trf_2645)
static void C_ccall trf_2645(C_word c,C_word *av) C_noret;
static void C_ccall trf_2645(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_2645(t0,t1,t2);}

C_noret_decl(trf_2303)
static void C_ccall trf_2303(C_word c,C_word *av) C_noret;
static void C_ccall trf_2303(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_2303(t0,t1,t2);}

C_noret_decl(trf_1969)
static void C_ccall trf_1969(C_word c,C_word *av) C_noret;
static void C_ccall trf_1969(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1969(t0,t1,t2);}

C_noret_decl(trf_1574)
static void C_ccall trf_1574(C_word c,C_word *av) C_noret;
static void C_ccall trf_1574(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1574(t0,t1);}

/* g365 in loop in k1869 in k990 in loop1 in k981 in schedule */
static void C_fcall f_1749(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_1749,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_slot(t2,C_fix(11));
if(C_truep(C_i_pairp(t3))){
t4=C_u_i_cdr(t3);
t5=C_eqp(t4,C_SCHEME_TRUE);
t6=(C_truep(t5)?t5:C_eqp(t4,lf[18]));
if(C_truep(t6)){
t7=C_set_block_item(((C_word*)t0)[2],0,C_SCHEME_TRUE);
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t7=C_eqp(t4,C_SCHEME_FALSE);
t8=(C_truep(t7)?t7:C_eqp(t4,lf[19]));
if(C_truep(t8)){
t9=C_set_block_item(((C_word*)t0)[3],0,C_SCHEME_TRUE);
t10=t1;{
C_word av2[2];
av2[0]=t10;
av2[1]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}
else{
t9=C_eqp(t4,lf[20]);
if(C_truep(t9)){
t10=C_set_block_item(((C_word*)t0)[2],0,C_SCHEME_TRUE);
t11=C_set_block_item(((C_word*)t0)[3],0,C_SCHEME_TRUE);
t12=t1;{
C_word av2[2];
av2[0]=t12;
av2[1]=t11;
((C_proc)(void*)(*((C_word*)t12+1)))(2,av2);}}
else{
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1792,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* scheduler.scm:412: open-output-string */
t11=*((C_word*)lf[28]+1);{
C_word av2[2];
av2[0]=t11;
av2[1]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}}}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k1497 in for-each-loop258 in thread-kill! */
static void C_ccall f_1499(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1499,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_i_set_i_slot(((C_word*)t0)[3],C_fix(3),C_SCHEME_END_OF_LIST);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_2491 in all-threads */
static void C_ccall f_2491(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_2491,6,av);}
a=C_alloc(3);
t6=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t6;
av2[1]=C_a_i_cons(&a,2,t4,t5);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* k1832 in loop in k1869 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1834(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_1834,2,av);}
t2=((C_word*)((C_word*)t0)[2])[1];
t3=((C_word*)((C_word*)t0)[3])[1];
t4=stub414(C_SCHEME_UNDEFINED,((C_word*)t0)[4],t2,t3);
t5=((C_word*)t0)[5];
t6=C_u_i_cdr(t5);
/* scheduler.scm:417: loop */
t7=((C_word*)((C_word*)t0)[6])[1];
f_1738(t7,((C_word*)t0)[7],t6);}

/* k1692 in default-exception-handler */
static void C_ccall f_1694(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_1694,2,av);}
a=C_alloc(3);
t2=C_i_setslot(((C_word*)t0)[2],C_fix(7),((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1700,a[2]=((C_word*)t0)[4],tmp=(C_word)a,a+=3,tmp);
/* scheduler.scm:380: ##sys#thread-kill! */
t4=*((C_word*)lf[47]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
av2[3]=lf[46];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* loop in k1869 in k990 in loop1 in k981 in schedule */
static void C_fcall f_1738(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(25,0,3)))){
C_save_and_reclaim_args((void *)trf_1738,3,t0,t1,t2);}
a=C_alloc(25);
if(C_truep(C_i_nullp(t2))){
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_u_i_caar(t2);
t4=t3;
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_SCHEME_FALSE;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1749,a[2]=t6,a[3]=t8,a[4]=t4,a[5]=((C_word)li3),tmp=(C_word)a,a+=6,tmp);
t10=t2;
t11=C_u_i_car(t10);
t12=C_u_i_cdr(t11);
t13=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1834,a[2]=t6,a[3]=t8,a[4]=t4,a[5]=t2,a[6]=((C_word*)t0)[2],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
t14=C_SCHEME_UNDEFINED;
t15=(*a=C_VECTOR_TYPE|1,a[1]=t14,tmp=(C_word)a,a+=2,tmp);
t16=C_set_block_item(t15,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1846,a[2]=t15,a[3]=t9,a[4]=((C_word)li4),tmp=(C_word)a,a+=5,tmp));
t17=((C_word*)t15)[1];
f_1846(t17,t13,t12);}}

/* for-each-loop364 in loop in k1869 in k990 in loop1 in k981 in schedule */
static void C_fcall f_1846(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_1846,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1856,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* scheduler.scm:392: g365 */
t5=((C_word*)t0)[3];
f_1749(t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k2189 in k2186 in k2180 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_2191(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_2191,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2194,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:493: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[29];
av2[3]=C_SCHEME_FALSE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k2195 in k2192 in k2189 in k2186 in k2180 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_2197(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_2197,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2200,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:493: ##sys#write-char-0 */
t3=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_make_character(41);
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* ##sys#default-exception-handler */
static void C_ccall f_1690(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_1690,3,av);}
a=C_alloc(10);
t3=*((C_word*)lf[1]+1);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1694,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_mk_bool(C_abort_on_thread_exceptions))){
t5=*((C_word*)lf[37]+1);
t6=C_slot(*((C_word*)lf[37]+1),C_fix(1));
t7=t6;
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1714,a[2]=t7,a[3]=t2,a[4]=((C_word)li25),tmp=(C_word)a,a+=5,tmp);
t9=C_i_setslot(*((C_word*)lf[37]+1),C_fix(1),t8);
/* scheduler.scm:376: ##sys#thread-unblock! */
t10=*((C_word*)lf[38]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t10;
av2[1]=t4;
av2[2]=*((C_word*)lf[37]+1);
((C_proc)(void*)(*((C_word*)t10+1)))(3,av2);}}
else{
/* scheduler.scm:378: ##sys#show-exception-warning */
t5=*((C_word*)lf[53]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[54];
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(5,av2);}}}

/* k2192 in k2189 in k2186 in k2180 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_2194(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_2194,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2197,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* scheduler.scm:493: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
av2[3]=C_SCHEME_TRUE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k2180 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_2182(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_2182,2,av);}
a=C_alloc(7);
t2=t1;
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[21]);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2188,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* scheduler.scm:493: ##sys#print */
t6=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=lf[30];
av2[3]=C_SCHEME_FALSE;
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* loop in all-threads */
static void C_fcall f_2374(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,5)))){
C_save_and_reclaim_args((void *)trf_2374,4,t0,t1,t2,t3);}
a=C_alloc(7);
if(C_truep(C_i_pairp(t2))){
t4=t2;
t5=C_u_i_cdr(t4);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2390,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t7=t2;
t8=C_u_i_car(t7);
/* scheduler.scm:533: cns */
t9=((C_word*)t0)[3];{
C_word av2[6];
av2[0]=t9;
av2[1]=t6;
av2[2]=lf[8];
av2[3]=C_SCHEME_FALSE;
av2[4]=t8;
av2[5]=t3;
((C_proc)(void*)(*((C_word*)t9+1)))(6,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2397,a[2]=t5,a[3]=((C_word*)t0)[3],a[4]=((C_word)li34),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_2397(t7,t1,*((C_word*)lf[11]+1),t3);}}

/* k2186 in k2180 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_2188(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_2188,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2191,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=C_u_i_car(((C_word*)t0)[6]);
/* scheduler.scm:493: ##sys#print */
t4=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=t3;
av2[3]=C_SCHEME_TRUE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* a1294 in interrupt-hook */
static void C_ccall f_1295(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_1295,2,av);}
/* scheduler.scm:271: oldhook */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k1596 in k1578 in k1575 in k1572 in k1566 in thread-kill! */
static void C_ccall f_1598(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1598,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_i_set_i_slot(((C_word*)t0)[3],C_fix(12),C_SCHEME_END_OF_LIST);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k1578 in k1575 in k1572 in k1566 in thread-kill! */
static void C_ccall f_1580(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,3)))){
C_save_and_reclaim((void *)f_1580,2,av);}
a=C_alloc(15);
t2=C_i_setslot(((C_word*)t0)[2],C_fix(3),((C_word*)t0)[3]);
t3=C_i_set_i_slot(((C_word*)t0)[2],C_fix(4),C_SCHEME_FALSE);
t4=C_i_set_i_slot(((C_word*)t0)[2],C_fix(11),C_SCHEME_FALSE);
t5=C_i_set_i_slot(((C_word*)t0)[2],C_fix(8),C_SCHEME_END_OF_LIST);
t6=C_slot(((C_word*)t0)[2],C_fix(12));
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1598,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t6))){
t8=((C_word*)t0)[4];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=C_i_set_i_slot(((C_word*)t0)[2],C_fix(12),C_SCHEME_END_OF_LIST);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1605,a[2]=((C_word*)t0)[2],a[3]=((C_word)li19),tmp=(C_word)a,a+=4,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_set_block_item(t10,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1624,a[2]=t10,a[3]=t8,a[4]=((C_word)li20),tmp=(C_word)a,a+=5,tmp));
t12=((C_word*)t10)[1];
f_1624(t12,t7,t6);}}

/* k2543 in k2540 in k2537 in thread-unblock! */
static void C_ccall f_2545(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_2545,2,av);}
/* scheduler.scm:574: ##sys#thread-basic-unblock! */
t2=*((C_word*)lf[16]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k2540 in k2537 in thread-unblock! */
static void C_ccall f_2542(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_2542,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2545,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:573: ##sys#clear-i/o-state-for-thread! */
f_2287(t2,((C_word*)t0)[3]);}

/* k2201 in k2198 in k2195 in k2192 in k2189 in k2186 in k2180 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_2203(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2203,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_halt(t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2198 in k2195 in k2192 in k2189 in k2186 in k2180 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_2200(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_2200,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2203,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* scheduler.scm:493: get-output-string */
t3=*((C_word*)lf[22]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k1279 in interrupt-hook */
static void C_ccall f_1281(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_1281,2,av);}
/* scheduler.scm:273: oldhook */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2537 in thread-unblock! */
static void C_fcall f_2539(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_2539,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2542,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:572: ##sys#remove-from-timeout-list */
t3=*((C_word*)lf[17]+1);{
C_word av2[3];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* ##sys#remove-from-timeout-list */
static void C_ccall f_1302(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_1302,3,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1308,a[2]=t2,a[3]=((C_word)li14),tmp=(C_word)a,a+=4,tmp);
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=(
  f_1308(t3,lf[10],C_SCHEME_FALSE)
);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* loop in remove-from-timeout-list */
static C_word C_fcall f_1308(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
loop:{}
if(C_truep(C_i_nullp(t1))){
t3=t1;
return(t3);}
else{
t3=C_slot(t1,C_fix(0));
t4=C_slot(t1,C_fix(1));
t5=C_slot(t3,C_fix(1));
t6=C_eqp(t5,((C_word*)t0)[2]);
if(C_truep(t6)){
if(C_truep(t2)){
return(C_i_setslot(t2,C_fix(1),t4));}
else{
t7=C_mutate2(&lf[10] /* (set! ##sys#timeout-list ...) */,t4);
return(t7);}}
else{
t9=t4;
t10=t1;
t1=t9;
t2=t10;
goto loop;}}}

/* ##sys#thread-unblock! */
static void C_ccall f_2529(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_2529,3,av);}
a=C_alloc(4);
t3=C_slot(t2,C_fix(3));
t4=C_eqp(lf[42],t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2539,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t4)){
t6=t5;
f_2539(t6,t4);}
else{
t6=C_slot(t2,C_fix(3));
t7=t5;
f_2539(t7,C_eqp(lf[61],t6));}}

/* k1653 in k1566 in thread-kill! */
static void C_ccall f_1655(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1655,2,av);}
t2=((C_word*)t0)[2];
f_1574(t2,C_i_setslot(((C_word*)t0)[3],C_fix(2),t1));}

/* loop in loop in loop in all-threads */
static void C_fcall f_2446(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,5)))){
C_save_and_reclaim_args((void *)trf_2446,4,t0,t1,t2,t3);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t4=t2;
t5=C_u_i_cdr(t4);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2462,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t7=C_u_i_caar(t2);
t8=t2;
t9=C_u_i_car(t8);
t10=C_u_i_cdr(t9);
/* scheduler.scm:543: cns */
t11=((C_word*)t0)[3];{
C_word av2[6];
av2[0]=t11;
av2[1]=t6;
av2[2]=lf[58];
av2[3]=t7;
av2[4]=t10;
av2[5]=t3;
((C_proc)(void*)(*((C_word*)t11+1)))(6,av2);}}
else{
t4=t3;
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* for-each-loop615 in k2587 in kill-other-threads */
static void C_fcall f_2668(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_2668,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2678,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* scheduler.scm:593: g616 */
t5=((C_word*)t0)[3];
f_2590(t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k2437 in loop in loop in loop in all-threads */
static void C_ccall f_2439(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_2439,2,av);}
/* scheduler.scm:540: cns */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[57];
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)t0)[5];
av2[5]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k1632 in for-each-loop306 in k1578 in k1575 in k1572 in k1566 in thread-kill! */
static void C_ccall f_1634(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_1634,2,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_1624(t3,((C_word*)t0)[4],t2);}

/* loop in loop in loop in all-threads */
static void C_fcall f_2421(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_2421,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
t3=((C_word*)t0)[2];
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_u_i_car(t2);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2439,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=t2;
t7=C_u_i_cdr(t6);
/* scheduler.scm:540: loop */
t9=t5;
t10=t7;
t1=t9;
t2=t10;
goto loop;}}

/* ##sys#interrupt-hook */
static void C_ccall f_1277(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,3)))){
C_save_and_reclaim((void *)f_1277,4,av);}
a=C_alloc(12);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1281,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=C_eqp(t2,C_fix(255));
if(C_truep(t5)){
t6=*((C_word*)lf[1]+1);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1295,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=((C_word)li12),tmp=(C_word)a,a+=6,tmp);
t8=C_i_setslot(*((C_word*)lf[1]+1),C_fix(1),t7);
/* scheduler.scm:272: ##sys#schedule */
t9=*((C_word*)lf[0]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t9;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}
else{
/* scheduler.scm:273: oldhook */
t6=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t6;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}}

/* for-each-loop306 in k1578 in k1575 in k1572 in k1566 in thread-kill! */
static void C_fcall f_1624(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_1624,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1634,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* scheduler.scm:350: g307 */
t5=((C_word*)t0)[3];
f_1605(t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k2388 in loop in all-threads */
static void C_ccall f_2390(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2390,2,av);}
/* scheduler.scm:533: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_2374(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* loop in loop in all-threads */
static void C_fcall f_2397(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,0,4)))){
C_save_and_reclaim_args((void *)trf_2397,4,t0,t1,t2,t3);}
a=C_alloc(14);
if(C_truep(C_i_pairp(t2))){
t4=t2;
t5=C_u_i_cdr(t4);
t6=C_u_i_caar(t2);
t7=t6;
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2416,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t9=t2;
t10=C_u_i_car(t9);
t11=C_u_i_cdr(t10);
t12=C_SCHEME_UNDEFINED;
t13=(*a=C_VECTOR_TYPE|1,a[1]=t12,tmp=(C_word)a,a+=2,tmp);
t14=C_set_block_item(t13,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2421,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t7,a[5]=t13,a[6]=((C_word)li32),tmp=(C_word)a,a+=7,tmp));
t15=((C_word*)t13)[1];
f_2421(t15,t8,t11);}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2446,a[2]=t5,a[3]=((C_word*)t0)[3],a[4]=((C_word)li33),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_2446(t7,t1,lf[10],t3);}}

/* k2414 in loop in loop in all-threads */
static void C_ccall f_2416(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2416,2,av);}
/* scheduler.scm:536: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_2397(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k1375 in loop in k1345 in thread-block-for-timeout! */
static void C_fcall f_1377(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_1377,2,t0,t1);}
a=C_alloc(6);
if(C_truep(t1)){
if(C_truep(((C_word*)t0)[2])){
t2=C_a_i_cons(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
t3=C_a_i_cons(&a,2,t2,((C_word*)t0)[5]);
t4=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t4;
av2[1]=C_i_setslot(((C_word*)t0)[2],C_fix(1),t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t2=C_a_i_cons(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
t3=C_a_i_cons(&a,2,t2,((C_word*)t0)[5]);
t4=C_mutate2(&lf[10] /* (set! ##sys#timeout-list ...) */,t3);
t5=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
t2=C_slot(((C_word*)t0)[5],C_fix(1));
/* scheduler.scm:301: loop */
t3=((C_word*)((C_word*)t0)[7])[1];
f_1367(t3,((C_word*)t0)[6],t2,((C_word*)t0)[5]);}}

/* k2215 in k2212 in k2209 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_2217(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2217,2,av);}
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
/* scheduler.scm:498: loop2 */
t4=((C_word*)((C_word*)t0)[3])[1];
f_2081(t4,((C_word*)t0)[4],t3,((C_word*)t0)[5]);}

/* k2676 in for-each-loop615 in k2587 in kill-other-threads */
static void C_ccall f_2678(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_2678,2,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_2668(t3,((C_word*)t0)[4],t2);}

/* k2209 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_2211(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_2211,2,av);}
a=C_alloc(7);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2214,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
if(C_truep(C_slot(((C_word*)t0)[6],C_fix(4)))){
/* scheduler.scm:496: ##sys#remove-from-timeout-list */
t3=*((C_word*)lf[17]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=t2;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_2214(2,av2);}}}
else{
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=C_a_i_cons(&a,2,((C_word*)t0)[6],((C_word*)t0)[5]);
/* scheduler.scm:499: loop2 */
t5=((C_word*)((C_word*)t0)[3])[1];
f_2081(t5,((C_word*)t0)[4],t3,t4);}}

/* k2212 in k2209 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_2214(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_2214,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2217,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:497: ##sys#thread-basic-unblock! */
t3=*((C_word*)lf[16]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* loop in k1345 in thread-block-for-timeout! */
static void C_fcall f_1367(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_1367,4,t0,t1,t2,t3);}
a=C_alloc(8);
t4=C_i_nullp(t2);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1377,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,a[6]=t1,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t4)){
t6=t5;
f_1377(t6,t4);}
else{
t6=C_u_i_caar(t2);
t7=t5;
f_1377(t7,C_flonum_lessp(((C_word*)t0)[2],t6));}}

/* g307 in k1578 in k1575 in k1572 in k1566 in thread-kill! */
static void C_fcall f_1605(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,2)))){
C_save_and_reclaim_args((void *)trf_1605,3,t0,t1,t2);}
t3=C_slot(t2,C_fix(11));
t4=C_eqp(t3,((C_word*)t0)[2]);
if(C_truep(t4)){
/* scheduler.scm:354: ##sys#thread-basic-unblock! */
t5=*((C_word*)lf[16]+1);{
C_word av2[3];
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* ##sys#clear-i/o-state-for-thread! */
static void C_fcall f_2287(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,0,3)))){
C_save_and_reclaim_args((void *)trf_2287,2,t1,t2);}
a=C_alloc(11);
t3=C_slot(t2,C_fix(11));
if(C_truep(C_i_pairp(t3))){
t4=C_slot(t2,C_fix(11));
t5=C_u_i_car(t4);
t6=t5;
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2301,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2303,a[2]=t6,a[3]=t2,a[4]=t9,a[5]=((C_word)li29),tmp=(C_word)a,a+=6,tmp));
t11=((C_word*)t9)[1];
f_2303(t11,t7,*((C_word*)lf[11]+1));}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k1909 in k1903 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1911(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_1911,2,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1914,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
/* scheduler.scm:425: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[7];
av2[3]=C_SCHEME_TRUE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k1915 in k1912 in k1909 in k1903 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1917(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_1917,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1920,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:425: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=C_SCHEME_TRUE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k1912 in k1909 in k1903 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1914(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_1914,2,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1917,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
/* scheduler.scm:425: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[26];
av2[3]=C_SCHEME_FALSE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k2599 in k2587 in kill-other-threads */
static void C_ccall f_2601(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(16,c,3)))){
C_save_and_reclaim((void *)f_2601,2,av);}
a=C_alloc(16);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2602,a[2]=((C_word*)t0)[2],a[3]=((C_word)li43),tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[11]+1);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2635,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2645,a[2]=t6,a[3]=t2,a[4]=((C_word)li44),tmp=(C_word)a,a+=5,tmp));
t8=((C_word*)t6)[1];
f_2645(t8,t4,*((C_word*)lf[11]+1));}

/* k1549 in for-each-loop258 in thread-kill! */
static void C_ccall f_1551(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_1551,2,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_1541(t3,((C_word*)t0)[4],t2);}

/* g633 in k2599 in k2587 in kill-other-threads */
static void C_fcall f_2602(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_2602,3,t0,t1,t2);}
a=C_alloc(7);
t3=((C_word*)t0)[2];
t4=C_slot(t2,C_fix(1));
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2611,a[2]=t6,a[3]=t3,a[4]=((C_word)li42),tmp=(C_word)a,a+=5,tmp));
t8=((C_word*)t6)[1];
f_2611(t8,t1,t4);}

/* k1903 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1905(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_1905,2,av);}
a=C_alloc(8);
t2=t1;
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[21]);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1911,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
/* scheduler.scm:425: ##sys#print */
t6=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=lf[27];
av2[3]=C_SCHEME_FALSE;
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* ##sys#add-to-ready-queue */
static void C_ccall f_1178(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_1178,3,av);}
a=C_alloc(3);
t3=C_i_setslot(t2,C_fix(3),lf[8]);
t4=C_a_i_cons(&a,2,t2,C_SCHEME_END_OF_LIST);
t5=C_eqp(C_SCHEME_END_OF_LIST,lf[13]);
if(C_truep(t5)){
t6=C_mutate2(&lf[13] /* (set! ready-queue-head ...) */,t4);
t7=C_mutate2(&lf[14] /* (set! ready-queue-tail ...) */,t4);
t8=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t6=C_i_setslot(lf[14],C_fix(1),t4);
t7=C_mutate2(&lf[14] /* (set! ready-queue-tail ...) */,t4);
t8=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* k1002 in loop2 in k993 in k990 in loop1 in k981 in schedule */
static void C_fcall f_1004(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,1)))){
C_save_and_reclaim_args((void *)trf_1004,2,t0,t1);}
if(C_truep(t1)){
t2=C_slot(t1,C_fix(3));
t3=C_eqp(t2,lf[8]);
if(C_truep(t3)){
t4=((C_word*)t0)[2];
t5=t1;
t6=C_mutate2((C_word*)lf[1]+1 /* (set! ##sys#current-thread ...) */,t5);
t7=C_i_setslot(t5,C_fix(3),lf[9]);
t8=C_slot(t5,C_fix(5));
t9=C_slot(t8,C_fix(0));
t10=C_mutate2((C_word*)lf[2]+1 /* (set! ##sys#dynamic-winds ...) */,t9);
t11=C_slot(t8,C_fix(1));
t12=C_mutate2((C_word*)lf[3]+1 /* (set! ##sys#standard-input ...) */,t11);
t13=C_slot(t8,C_fix(2));
t14=C_mutate2((C_word*)lf[4]+1 /* (set! ##sys#standard-output ...) */,t13);
t15=C_slot(t8,C_fix(3));
t16=C_mutate2((C_word*)lf[5]+1 /* (set! ##sys#standard-error ...) */,t15);
t17=C_slot(t8,C_fix(4));
t18=C_mutate2((C_word*)lf[6]+1 /* (set! ##sys#current-exception-handler ...) */,t17);
t19=C_slot(t8,C_fix(5));
t20=C_mutate2((C_word*)lf[7]+1 /* (set! ##sys#current-parameter-vector ...) */,t19);
t21=C_slot(t5,C_fix(9));
t22=C_set_initial_timer_interrupt_period(t21);
t23=C_slot(t5,C_fix(1));
/* scheduler.scm:153: g122 */
t24=t23;{
C_word av2[2];
av2[0]=t24;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t24+1)))(2,av2);}}
else{
/* scheduler.scm:220: loop2 */
t4=((C_word*)((C_word*)t0)[3])[1];
f_1000(t4,((C_word*)t0)[2]);}}
else{
if(C_truep(C_i_nullp(lf[10]))){
if(C_truep(C_i_nullp(*((C_word*)lf[11]+1)))){
t2=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_halt(lf[12]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* scheduler.scm:218: loop1 */
t2=((C_word*)((C_word*)t0)[4])[1];
f_988(t2,((C_word*)t0)[2]);}}
else{
/* scheduler.scm:218: loop1 */
t2=((C_word*)((C_word*)t0)[4])[1];
f_988(t2,((C_word*)t0)[2]);}}}

/* ##sys#ready-queue */
static void C_ccall f_1175(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1175,2,av);}
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=lf[13];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k1418 in thread-block-for-timeout! */
static void C_ccall f_1420(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_1420,2,av);}
a=C_alloc(6);
t2=t1;
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[21]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1426,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:293: ##sys#print */
t6=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=lf[43];
av2[3]=C_SCHEME_FALSE;
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* for-each-loop258 in thread-kill! */
static void C_fcall f_1541(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,0,3)))){
C_save_and_reclaim_args((void *)trf_1541,3,t0,t1,t2);}
a=C_alloc(15);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1551,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
t5=t3;
t6=t4;
t7=C_i_set_i_slot(t6,C_fix(2),C_SCHEME_FALSE);
t8=C_i_set_i_slot(t6,C_fix(4),C_SCHEME_TRUE);
t9=C_i_set_i_slot(t6,C_fix(5),C_SCHEME_FALSE);
t10=C_slot(t6,C_fix(3));
t11=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1499,a[2]=t5,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t10))){
t12=t5;{
C_word av2[2];
av2[0]=t12;
av2[1]=C_i_set_i_slot(t6,C_fix(3),C_SCHEME_END_OF_LIST);
((C_proc)(void*)(*((C_word*)t12+1)))(2,av2);}}
else{
t12=C_SCHEME_UNDEFINED;
t13=(*a=C_VECTOR_TYPE|1,a[1]=t12,tmp=(C_word)a,a+=2,tmp);
t14=C_set_block_item(t13,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1515,a[2]=t13,a[3]=((C_word)li21),tmp=(C_word)a,a+=4,tmp));
t15=((C_word*)t13)[1];
f_1515(t15,t11,t10);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k2256 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_2258(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_2258,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2048 in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_2050(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2050,2,av);}
t2=C_mutate2((C_word*)lf[11]+1 /* (set! ##sys#fd-list ...) */,t1);
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_fcall f_2052(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(13,0,4)))){
C_save_and_reclaim_args((void *)trf_2052,5,t0,t1,t2,t3,t4);}
a=C_alloc(13);
t5=C_i_zerop(t2);
t6=(C_truep(t5)?t5:C_i_nullp(t4));
if(C_truep(t6)){
t7=t4;
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t7=C_u_i_car(t4);
t8=t7;
t9=C_u_i_car(t8);
t10=t9;
t11=C_fd_input_ready(t10,t3);
t12=C_fd_output_ready(t10,t3);
t13=(C_truep(t11)?t11:t12);
if(C_truep(t13)){
t14=C_u_i_cdr(t8);
t15=C_SCHEME_UNDEFINED;
t16=(*a=C_VECTOR_TYPE|1,a[1]=t15,tmp=(C_word)a,a+=2,tmp);
t17=C_set_block_item(t16,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2081,a[2]=t2,a[3]=t3,a[4]=t4,a[5]=((C_word*)t0)[2],a[6]=t10,a[7]=t16,a[8]=t11,a[9]=t12,a[10]=((C_word)li1),tmp=(C_word)a,a+=11,tmp));
t18=((C_word*)t16)[1];
f_2081(t18,t1,t14,C_SCHEME_END_OF_LIST);}
else{
t14=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2258,a[2]=t1,a[3]=t8,tmp=(C_word)a,a+=4,tmp);
t15=C_a_i_plus(&a,2,t3,C_fix(1));
t16=t4;
t17=C_u_i_cdr(t16);
/* scheduler.scm:500: loop */
t19=t14;
t20=t2;
t21=t15;
t22=t17;
t1=t19;
t2=t20;
t3=t21;
t4=t22;
goto loop;}}}

/* ##sys#force-primordial */
static void C_ccall f_1164(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_1164,2,av);}
t2=C_i_set_i_slot(*((C_word*)lf[37]+1),C_fix(13),C_SCHEME_FALSE);
/* scheduler.scm:225: ##sys#thread-unblock! */
t3=*((C_word*)lf[38]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=*((C_word*)lf[37]+1);
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* ##sys#thread-block-for-termination! */
static void C_ccall f_1434(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_1434,4,av);}
a=C_alloc(3);
t4=C_slot(t3,C_fix(3));
t5=C_eqp(t4,lf[45]);
t6=(C_truep(t5)?t5:C_eqp(t4,lf[46]));
if(C_truep(t6)){
t7=C_SCHEME_UNDEFINED;
t8=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t7=C_slot(t3,C_fix(12));
t8=C_a_i_cons(&a,2,t2,t7);
t9=C_i_setslot(t3,C_fix(12),t8);
t10=C_i_setslot(t2,C_fix(3),lf[42]);
t11=C_i_set_i_slot(t2,C_fix(13),C_SCHEME_FALSE);
t12=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t12;
av2[1]=C_i_setslot(t2,C_fix(11),t3);
((C_proc)(void*)(*((C_word*)t12+1)))(2,av2);}}}

/* k1430 in k1427 in k1424 in k1418 in thread-block-for-timeout! */
static void C_ccall f_1432(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1432,2,av);}
t2=((C_word*)t0)[2];
f_1347(t2,C_halt(t1));}

/* k1921 in k1918 in k1915 in k1912 in k1909 in k1903 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1923(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_1923,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1926,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* scheduler.scm:425: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
av2[3]=C_SCHEME_TRUE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k1918 in k1915 in k1912 in k1909 in k1903 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1920(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_1920,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1923,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:425: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[25];
av2[3]=C_SCHEME_FALSE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k1924 in k1921 in k1918 in k1915 in k1912 in k1909 in k1903 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1926(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_1926,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1929,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:425: ##sys#write-char-0 */
t3=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_make_character(41);
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k1927 in k1924 in k1921 in k1918 in k1915 in k1912 in k1909 in k1903 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1929(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_1929,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1932,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* scheduler.scm:425: get-output-string */
t3=*((C_word*)lf[22]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k1427 in k1424 in k1418 in thread-block-for-timeout! */
static void C_ccall f_1429(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_1429,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1432,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* scheduler.scm:293: get-output-string */
t3=*((C_word*)lf[22]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k1424 in k1418 in thread-block-for-timeout! */
static void C_ccall f_1426(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,4)))){
C_save_and_reclaim((void *)f_1426,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1429,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:293: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_TRUE;
av2[4]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k1108 in loop in loop1 in k981 in schedule */
static void C_fcall f_1110(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,1)))){
C_save_and_reclaim_args((void *)trf_1110,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_u_i_caar(lf[10]);
t3=C_a_i_flonum_difference(&a,2,t2,((C_word*)t0)[2]);
t4=C_quickflonumtruncate(t3);
t5=C_i_fixnum_max(C_fix(0),t4);
if(C_truep(C_msleep(t5))){
t6=C_set_block_item(((C_word*)t0)[3],0,C_SCHEME_FALSE);
t7=((C_word*)t0)[4];{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=C_mk_bool(C_signal_interrupted_p);
t7=C_mutate2(((C_word *)((C_word*)t0)[3])+1,t6);
t8=((C_word*)t0)[4];{
C_word av2[2];
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[4];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* for-each-loop645 in g633 in k2599 in k2587 in kill-other-threads */
static void C_fcall f_2611(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_2611,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2621,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* scheduler.scm:594: g646 */
t5=((C_word*)t0)[3];{
C_word av2[3];
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* loop1 in k981 in schedule */
static void C_fcall f_988(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(17,0,3)))){
C_save_and_reclaim_args((void *)trf_988,2,t0,t1);}
a=C_alloc(17);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_992,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_nullp(lf[10]))){
t3=t2;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_992(2,av2);}}
else{
t3=C_a_i_current_milliseconds(&a,1,C_SCHEME_FALSE);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1061,a[2]=t3,a[3]=t5,a[4]=((C_word*)t0)[3],a[5]=((C_word)li6),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_1061(t7,t2,lf[10]);}}

/* k981 in schedule */
static void C_ccall f_983(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_983,2,av);}
a=C_alloc(7);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_988,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word)li7),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_988(t5,((C_word*)t0)[3]);}

/* for-each-loop272 in for-each-loop258 in thread-kill! */
static void C_fcall f_1515(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_1515,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1525,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* scheduler.scm:328: ##sys#thread-unblock! */
t5=*((C_word*)lf[38]+1);{
C_word av2[3];
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_fcall f_2026(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,5)))){
C_save_and_reclaim_args((void *)trf_2026,2,t0,t1);}
a=C_alloc(9);
t2=(C_truep(((C_word*)t0)[2])?stub482(C_SCHEME_UNDEFINED,((C_word*)t0)[2],t1):stub482(C_SCHEME_UNDEFINED,((C_word*)t0)[3],t1));
t3=C_eqp(C_fix(-1),t2);
if(C_truep(t3)){
/* scheduler.scm:459: ##sys#force-primordial */
t4=*((C_word*)lf[15]+1);{
C_word av2[2];
av2[0]=t4;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
if(C_truep(C_fixnum_greaterp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2050,a[2]=((C_word*)t0)[4],tmp=(C_word)a,a+=3,tmp);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2052,a[2]=t6,a[3]=((C_word)li2),tmp=(C_word)a,a+=4,tmp));
t8=((C_word*)t6)[1];
f_2052(t8,t4,t2,C_fix(0),*((C_word*)lf[11]+1));}
else{
t4=((C_word*)t0)[4];{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}

/* ##sys#schedule */
static void C_ccall f_953(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_953,2,av);}
a=C_alloc(6);
t2=*((C_word*)lf[1]+1);
t3=C_SCHEME_FALSE;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_slot(*((C_word*)lf[1]+1),C_fix(3));
t6=C_slot(*((C_word*)lf[1]+1),C_fix(5));
t7=C_i_setslot(t6,C_fix(0),*((C_word*)lf[2]+1));
t8=C_i_setslot(t6,C_fix(1),*((C_word*)lf[3]+1));
t9=C_i_setslot(t6,C_fix(2),*((C_word*)lf[4]+1));
t10=C_i_setslot(t6,C_fix(3),*((C_word*)lf[5]+1));
t11=C_i_setslot(t6,C_fix(4),*((C_word*)lf[6]+1));
t12=C_i_setslot(t6,C_fix(5),*((C_word*)lf[7]+1));
t13=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_983,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t14=C_eqp(t5,lf[9]);
t15=(C_truep(t14)?t14:C_eqp(t5,lf[8]));
if(C_truep(t15)){
t16=C_i_set_i_slot(*((C_word*)lf[1]+1),C_fix(13),C_SCHEME_FALSE);
/* scheduler.scm:170: ##sys#add-to-ready-queue */
t17=*((C_word*)lf[36]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t17;
av2[1]=t13;
av2[2]=*((C_word*)lf[1]+1);
((C_proc)(void*)(*((C_word*)t17+1)))(3,av2);}}
else{
t16=t13;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t16;
av2[1]=C_SCHEME_UNDEFINED;
f_983(2,av2);}}}

/* k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_2017(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,2)))){
C_save_and_reclaim((void *)f_2017,2,av);}
a=C_alloc(13);
t2=C_i_pairp(lf[10]);
t3=t2;
t4=C_i_pairp(lf[13]);
t5=t4;
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2026,a[2]=t5,a[3]=t3,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t7=(C_truep(t3)?C_i_not(t5):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=C_u_i_caar(lf[10]);
t9=C_a_i_current_milliseconds(&a,1,C_SCHEME_FALSE);
t10=C_a_i_flonum_difference(&a,2,t8,t9);
t11=t6;
f_2026(t11,C_i_flonum_max(lf[31],t10));}
else{
t8=t6;
f_2026(t8,lf[31]);}}

/* loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_fcall f_2081(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(15,0,4)))){
C_save_and_reclaim_args((void *)trf_2081,4,t0,t1,t2,t3);}
a=C_alloc(15);
if(C_truep(C_i_nullp(t2))){
if(C_truep(C_i_nullp(t3))){
t4=C_a_i_minus(&a,2,((C_word*)t0)[2],C_fix(1));
t5=C_a_i_plus(&a,2,((C_word*)t0)[3],C_fix(1));
t6=C_slot(((C_word*)t0)[4],C_fix(1));
/* scheduler.scm:476: loop */
t7=((C_word*)((C_word*)t0)[5])[1];
f_2052(t7,t1,t4,t5,t6);}
else{
t4=C_a_i_cons(&a,2,((C_word*)t0)[6],t3);
t5=t4;
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2120,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=C_a_i_minus(&a,2,((C_word*)t0)[2],C_fix(1));
t8=C_a_i_plus(&a,2,((C_word*)t0)[3],C_fix(1));
t9=C_slot(((C_word*)t0)[4],C_fix(1));
/* scheduler.scm:478: loop */
t10=((C_word*)((C_word*)t0)[5])[1];
f_2052(t10,t6,t7,t8,t9);}}
else{
t4=C_u_i_car(t2);
t5=t4;
t6=C_slot(t5,C_fix(11));
t7=t6;
if(C_truep(C_slot(t5,C_fix(13)))){
t8=t2;
t9=C_u_i_cdr(t8);
/* scheduler.scm:484: loop2 */
t23=t1;
t24=t9;
t25=t3;
t1=t23;
t2=t24;
t3=t25;
goto loop;}
else{
if(C_truep(C_i_pairp(t7))){
t8=C_u_i_car(t7);
t9=C_eqp(((C_word*)t0)[6],t8);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2211,a[2]=t2,a[3]=((C_word*)t0)[7],a[4]=t1,a[5]=t3,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
t11=C_u_i_cdr(t7);
t12=t10;
t13=((C_word*)t0)[8];
t14=((C_word*)t0)[9];
t15=t11;
t16=C_eqp(t15,C_SCHEME_TRUE);
t17=(C_truep(t16)?t16:C_eqp(t15,lf[18]));
if(C_truep(t17)){
t18=t12;{
C_word av2[2];
av2[0]=t18;
av2[1]=t13;
((C_proc)(void*)(*((C_word*)t18+1)))(2,av2);}}
else{
t18=C_eqp(t15,C_SCHEME_FALSE);
t19=(C_truep(t18)?t18:C_eqp(t15,lf[19]));
if(C_truep(t19)){
t20=t12;{
C_word av2[2];
av2[0]=t20;
av2[1]=t14;
((C_proc)(void*)(*((C_word*)t20+1)))(2,av2);}}
else{
t20=C_eqp(t15,lf[20]);
if(C_truep(t20)){
t21=t12;{
C_word av2[2];
av2[0]=t21;
av2[1]=(C_truep(t13)?t13:t14);
((C_proc)(void*)(*((C_word*)t21+1)))(2,av2);}}
else{
t21=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1905,a[2]=t12,a[3]=t14,a[4]=t13,a[5]=t15,tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:425: open-output-string */
t22=*((C_word*)lf[28]+1);{
C_word av2[2];
av2[0]=t22;
av2[1]=t21;
((C_proc)(void*)(*((C_word*)t22+1)))(2,av2);}}}}}
else{
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2182,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=t7,tmp=(C_word)a,a+=5,tmp);
/* scheduler.scm:493: open-output-string */
t11=*((C_word*)lf[28]+1);{
C_word av2[2];
av2[0]=t11;
av2[1]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}}
else{
t8=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2158,a[2]=t2,a[3]=((C_word*)t0)[7],a[4]=t1,a[5]=t3,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
if(C_truep(C_slot(t5,C_fix(4)))){
/* scheduler.scm:489: ##sys#remove-from-timeout-list */
t9=*((C_word*)lf[17]+1);{
C_word av2[3];
av2[0]=t9;
av2[1]=t8;
av2[2]=t5;
((C_proc)(void*)(*((C_word*)t9+1)))(3,av2);}}
else{
t9=t8;{
C_word av2[2];
av2[0]=t9;
av2[1]=C_SCHEME_UNDEFINED;
f_2158(2,av2);}}}}}}

/* k1808 in k1805 in k1802 in k1799 in k1796 in k1790 in g365 in loop in k1869 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1810(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_1810,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1813,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* scheduler.scm:412: get-output-string */
t3=*((C_word*)lf[22]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k1811 in k1808 in k1805 in k1802 in k1799 in k1796 in k1790 in g365 in loop in k1869 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1813(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1813,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_halt(t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* loop2 in k993 in k990 in loop1 in k981 in schedule */
static void C_fcall f_1000(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_1000,2,t0,t1);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1004,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=lf[13];
if(C_truep(C_i_nullp(lf[13]))){
t4=t2;
f_1004(t4,C_SCHEME_FALSE);}
else{
t4=C_slot(t3,C_fix(1));
t5=C_mutate2(&lf[13] /* (set! ready-queue-head ...) */,t4);
t6=C_eqp(C_SCHEME_END_OF_LIST,t4);
if(C_truep(t6)){
t7=lf[14] /* ready-queue-tail */ =C_SCHEME_END_OF_LIST;;
t8=C_u_i_car(t3);
t9=t2;
f_1004(t9,t8);}
else{
t7=C_u_i_car(t3);
t8=t2;
f_1004(t8,t7);}}}

/* ##sys#thread-basic-unblock! */
static void C_ccall f_1678(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_1678,3,av);}
t3=C_i_set_i_slot(t2,C_fix(11),C_SCHEME_FALSE);
t4=C_i_set_i_slot(t2,C_fix(4),C_SCHEME_FALSE);
/* scheduler.scm:362: ##sys#add-to-ready-queue */
t5=*((C_word*)lf[36]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k1523 in for-each-loop272 in for-each-loop258 in thread-kill! */
static void C_ccall f_1525(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_1525,2,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_1515(t3,((C_word*)t0)[4],t2);}

/* k2460 in loop in loop in loop in all-threads */
static void C_ccall f_2462(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2462,2,av);}
/* scheduler.scm:543: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_2446(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k1698 in k1692 in default-exception-handler */
static void C_ccall f_1700(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1700,2,av);}
/* scheduler.scm:381: ##sys#schedule */
t2=*((C_word*)lf[0]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k1670 in k1566 in thread-kill! */
static void C_ccall f_1672(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1672,2,av);}
t2=((C_word*)t0)[2];
f_1574(t2,C_i_setslot(((C_word*)t0)[3],C_fix(12),t1));}

/* toplevel */
static C_TLS int toplevel_initialized=0;

void C_ccall C_scheduler_toplevel(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word *a;
if(toplevel_initialized) {C_kontinue(t1,C_SCHEME_UNDEFINED);}
else C_toplevel_entry(C_text("scheduler_toplevel"));
C_check_nursery_minimum(C_calculate_demand(56,c,5));
if(C_unlikely(!C_demand(C_calculate_demand(56,c,5)))){
C_save_and_reclaim((void*)C_scheduler_toplevel,c,av);}
toplevel_initialized=1;
if(C_unlikely(!C_demand_2(354))){
C_save(t1);
C_rereclaim2(354*sizeof(C_word),1);
t1=C_restore;}
a=C_alloc(56);
C_initialize_lf(lf,65);
lf[0]=C_h_intern(&lf[0],12,"\003sysschedule");
lf[1]=C_h_intern(&lf[1],18,"\003syscurrent-thread");
lf[2]=C_h_intern(&lf[2],17,"\003sysdynamic-winds");
lf[3]=C_h_intern(&lf[3],18,"\003sysstandard-input");
lf[4]=C_h_intern(&lf[4],19,"\003sysstandard-output");
lf[5]=C_h_intern(&lf[5],18,"\003sysstandard-error");
lf[6]=C_h_intern(&lf[6],29,"\003syscurrent-exception-handler");
lf[7]=C_h_intern(&lf[7],28,"\003syscurrent-parameter-vector");
lf[8]=C_h_intern(&lf[8],5,"ready");
lf[9]=C_h_intern(&lf[9],7,"running");
lf[11]=C_h_intern(&lf[11],11,"\003sysfd-list");
lf[12]=C_decode_literal(C_heaptop,"\376B\000\000\010deadlock");
lf[15]=C_h_intern(&lf[15],20,"\003sysforce-primordial");
lf[16]=C_h_intern(&lf[16],25,"\003systhread-basic-unblock!");
lf[17]=C_h_intern(&lf[17],28,"\003sysremove-from-timeout-list");
lf[18]=C_h_intern(&lf[18],6,"\000input");
lf[19]=C_h_intern(&lf[19],7,"\000output");
lf[20]=C_h_intern(&lf[20],4,"\000all");
lf[21]=C_h_intern(&lf[21],7,"sprintf");
lf[22]=C_h_intern(&lf[22],17,"get-output-string");
lf[23]=C_h_intern(&lf[23],16,"\003syswrite-char-0");
lf[24]=C_h_intern(&lf[24],9,"\003sysprint");
lf[25]=C_decode_literal(C_heaptop,"\376B\000\000\006, o = ");
lf[26]=C_decode_literal(C_heaptop,"\376B\000\000\006 (i = ");
lf[27]=C_decode_literal(C_heaptop,"\376B\000\000#fdset-test: invalid i/o direction: ");
lf[28]=C_h_intern(&lf[28],18,"open-output-string");
lf[29]=C_decode_literal(C_heaptop,"\376B\000\000\013 (expected ");
lf[30]=C_decode_literal(C_heaptop,"\376B\000\0009thread is registered for I/O on unknown file-descriptor: ");
lf[31]=C_decode_literal(C_heaptop,"\376U0.0\000");
lf[32]=C_decode_literal(C_heaptop,"\376B\000\000\007 (fd = ");
lf[33]=C_decode_literal(C_heaptop,"\376B\000\000%create-fdset: invalid i/o direction: ");
lf[34]=C_h_intern(&lf[34],10,"\003syslength");
lf[36]=C_h_intern(&lf[36],22,"\003sysadd-to-ready-queue");
lf[37]=C_h_intern(&lf[37],21,"\003sysprimordial-thread");
lf[38]=C_h_intern(&lf[38],19,"\003systhread-unblock!");
lf[39]=C_h_intern(&lf[39],15,"\003sysready-queue");
lf[40]=C_h_intern(&lf[40],18,"\003sysinterrupt-hook");
lf[41]=C_h_intern(&lf[41],29,"\003systhread-block-for-timeout!");
lf[42]=C_h_intern(&lf[42],7,"blocked");
lf[43]=C_decode_literal(C_heaptop,"\376B\000\0002##sys#thread-block-for-timeout!: invalid timeout: ");
lf[44]=C_h_intern(&lf[44],33,"\003systhread-block-for-termination!");
lf[45]=C_h_intern(&lf[45],4,"dead");
lf[46]=C_h_intern(&lf[46],10,"terminated");
lf[47]=C_h_intern(&lf[47],16,"\003systhread-kill!");
lf[48]=C_h_intern(&lf[48],18,"condition-variable");
lf[49]=C_h_intern(&lf[49],8,"\003sysdelq");
lf[50]=C_h_intern(&lf[50],6,"thread");
lf[51]=C_h_intern(&lf[51],29,"\003sysdefault-exception-handler");
lf[52]=C_h_intern(&lf[52],10,"\003syssignal");
lf[53]=C_h_intern(&lf[53],26,"\003sysshow-exception-warning");
lf[54]=C_decode_literal(C_heaptop,"\376B\000\000\011in thread");
lf[55]=C_h_intern(&lf[55],25,"\003systhread-block-for-i/o!");
lf[56]=C_h_intern(&lf[56],15,"\003sysall-threads");
lf[57]=C_h_intern(&lf[57],3,"i/o");
lf[58]=C_h_intern(&lf[58],7,"timeout");
lf[59]=C_h_intern(&lf[59],27,"\003sysfetch-and-clear-threads");
lf[60]=C_h_intern(&lf[60],19,"\003sysrestore-threads");
lf[61]=C_h_intern(&lf[61],8,"sleeping");
lf[62]=C_h_intern(&lf[62],4,"exit");
lf[63]=C_h_intern(&lf[63],22,"\003syskill-other-threads");
lf[64]=C_h_intern(&lf[64],9,"suspended");
C_register_lf2(lf,65,create_ptable());{}
t2=C_mutate2((C_word*)lf[0]+1 /* (set! ##sys#schedule ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_953,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t3=C_mutate2((C_word*)lf[15]+1 /* (set! ##sys#force-primordial ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1164,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp));
t4=lf[13] /* ready-queue-head */ =C_SCHEME_END_OF_LIST;;
t5=lf[14] /* ready-queue-tail */ =C_SCHEME_END_OF_LIST;;
t6=C_mutate2((C_word*)lf[39]+1 /* (set! ##sys#ready-queue ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1175,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate2((C_word*)lf[36]+1 /* (set! ##sys#add-to-ready-queue ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1178,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t8=*((C_word*)lf[40]+1);
t9=C_mutate2((C_word*)lf[40]+1 /* (set! ##sys#interrupt-hook ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1277,a[2]=t8,a[3]=((C_word)li13),tmp=(C_word)a,a+=4,tmp));
t10=lf[10] /* ##sys#timeout-list */ =C_SCHEME_END_OF_LIST;;
t11=C_mutate2((C_word*)lf[17]+1 /* (set! ##sys#remove-from-timeout-list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1302,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[41]+1 /* (set! ##sys#thread-block-for-timeout! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1343,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate2((C_word*)lf[44]+1 /* (set! ##sys#thread-block-for-termination! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1434,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate2((C_word*)lf[47]+1 /* (set! ##sys#thread-kill! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1564,a[2]=((C_word)li23),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate2((C_word*)lf[16]+1 /* (set! ##sys#thread-basic-unblock! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1678,a[2]=((C_word)li24),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate2((C_word*)lf[51]+1 /* (set! ##sys#default-exception-handler ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1690,a[2]=((C_word)li26),tmp=(C_word)a,a+=3,tmp));
t17=C_set_block_item(lf[11] /* ##sys#fd-list */,0,C_SCHEME_END_OF_LIST);
t18=C_mutate2((C_word*)lf[55]+1 /* (set! ##sys#thread-block-for-i/o! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1950,a[2]=((C_word)li28),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate2(&lf[35] /* (set! ##sys#clear-i/o-state-for-thread! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2287,a[2]=((C_word)li30),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate2((C_word*)lf[56]+1 /* (set! ##sys#all-threads ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2356,a[2]=((C_word)li36),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate2((C_word*)lf[59]+1 /* (set! ##sys#fetch-and-clear-threads ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2500,a[2]=((C_word)li37),tmp=(C_word)a,a+=3,tmp));
t22=C_mutate2((C_word*)lf[60]+1 /* (set! ##sys#restore-threads ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2510,a[2]=((C_word)li38),tmp=(C_word)a,a+=3,tmp));
t23=C_mutate2((C_word*)lf[38]+1 /* (set! ##sys#thread-unblock! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2529,a[2]=((C_word)li39),tmp=(C_word)a,a+=3,tmp));
t24=*((C_word*)lf[62]+1);
t25=C_mutate2((C_word*)lf[63]+1 /* (set! ##sys#kill-other-threads ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2561,a[2]=t24,a[3]=((C_word)li46),tmp=(C_word)a,a+=4,tmp));
t26=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t26;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t26+1)))(2,av2);}}

/* k1799 in k1796 in k1790 in g365 in loop in k1869 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1801(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_1801,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1804,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:412: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[32];
av2[3]=C_SCHEME_FALSE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k1805 in k1802 in k1799 in k1796 in k1790 in g365 in loop in k1869 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1807(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_1807,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1810,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:412: ##sys#write-char-0 */
t3=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_make_character(41);
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k1802 in k1799 in k1796 in k1790 in g365 in loop in k1869 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1804(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_1804,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1807,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* scheduler.scm:412: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
av2[3]=C_SCHEME_TRUE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k993 in k990 in loop1 in k981 in schedule */
static void C_ccall f_995(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_995,2,av);}
a=C_alloc(7);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1000,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word)li0),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_1000(t5,((C_word*)t0)[3]);}

/* k990 in loop1 in k981 in schedule */
static void C_ccall f_992(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_992,2,av);}
a=C_alloc(10);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_995,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)((C_word*)t0)[4])[1])){
/* scheduler.scm:209: ##sys#force-primordial */
t3=*((C_word*)lf[15]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_nullp(*((C_word*)lf[11]+1)))){
t3=C_SCHEME_UNDEFINED;
t4=t2;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
f_995(2,av2);}}
else{
t3=t2;
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2017,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=t4;
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1871,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* scheduler.scm:389: ##sys#length */
t7=*((C_word*)lf[34]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=*((C_word*)lf[11]+1);
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}}}

/* ##sys#all-threads */
static void C_ccall f_2356(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +10,c,6)))){
C_save_and_reclaim((void*)f_2356,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+10);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2491,a[2]=((C_word)li31),tmp=(C_word)a,a+=3,tmp):C_u_i_car(t2));
t5=t4;
t6=C_i_nullp(t2);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_slot(t2,C_fix(1)));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_u_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_slot(t7,C_fix(1)));
t12=C_SCHEME_UNDEFINED;
t13=(*a=C_VECTOR_TYPE|1,a[1]=t12,tmp=(C_word)a,a+=2,tmp);
t14=C_set_block_item(t13,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2374,a[2]=t13,a[3]=t5,a[4]=((C_word)li35),tmp=(C_word)a,a+=5,tmp));
t15=((C_word*)t13)[1];
f_2374(t15,t1,lf[13],t9);}

/* k1869 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1871(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_1871,2,av);}
a=C_alloc(6);
t2=stub354(C_SCHEME_UNDEFINED,t1);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1738,a[2]=t4,a[3]=((C_word)li5),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_1738(t6,((C_word*)t0)[2],*((C_word*)lf[11]+1));}

/* loop in loop1 in k981 in schedule */
static void C_fcall f_1061(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_1061,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
t3=lf[10] /* ##sys#timeout-list */ =C_SCHEME_END_OF_LIST;;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_u_i_caar(t2);
t4=t2;
t5=C_u_i_car(t4);
t6=C_u_i_cdr(t5);
t7=C_slot(t6,C_fix(4));
if(C_truep(C_i_equalp(t3,t7))){
if(C_truep(C_flonum_greater_or_equal_p(((C_word*)t0)[2],t3))){
t8=C_i_set_i_slot(t6,C_fix(13),C_SCHEME_TRUE);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1095,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t6,tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:186: ##sys#clear-i/o-state-for-thread! */
f_2287(t9,t6);}
else{
t8=C_mutate2(&lf[10] /* (set! ##sys#timeout-list ...) */,t2);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1110,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_nullp(lf[13]))){
t10=C_i_nullp(*((C_word*)lf[11]+1));
t11=t9;
f_1110(t11,(C_truep(t10)?C_i_pairp(lf[10]):C_SCHEME_FALSE));}
else{
t10=t9;
f_1110(t10,C_SCHEME_FALSE);}}}
else{
t8=t2;
t9=C_u_i_cdr(t8);
/* scheduler.scm:206: loop */
t12=t1;
t13=t9;
t1=t12;
t2=t13;
goto loop;}}}

/* g616 in k2587 in kill-other-threads */
static void C_fcall f_2590(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,2)))){
C_save_and_reclaim_args((void *)trf_2590,3,t0,t1,t2);}
t3=C_slot(t2,C_fix(1));
/* scheduler.scm:593: suspend */
t4=((C_word*)t0)[2];{
C_word av2[3];
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
f_2564(3,av2);}}

/* k2342 in loop in clear-i/o-state-for-thread! */
static void C_ccall f_2344(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_2344,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k1930 in k1927 in k1924 in k1921 in k1918 in k1915 in k1912 in k1909 in k1903 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1932(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1932,2,av);}
t2=C_halt(t1);
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k1790 in g365 in loop in k1869 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1792(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_1792,2,av);}
a=C_alloc(7);
t2=t1;
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[21]);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1798,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* scheduler.scm:412: ##sys#print */
t6=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=lf[33];
av2[3]=C_SCHEME_FALSE;
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* k2587 in kill-other-threads */
static void C_ccall f_2589(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(17,c,3)))){
C_save_and_reclaim((void *)f_2589,2,av);}
a=C_alloc(17);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2590,a[2]=((C_word*)t0)[2],a[3]=((C_word)li41),tmp=(C_word)a,a+=4,tmp);
t3=lf[10];
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2601,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2668,a[2]=t6,a[3]=t2,a[4]=((C_word)li45),tmp=(C_word)a,a+=5,tmp));
t8=((C_word*)t6)[1];
f_2668(t8,t4,lf[10]);}

/* k1796 in k1790 in g365 in loop in k1869 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1798(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_1798,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1801,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:412: ##sys#print */
t3=*((C_word*)lf[24]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=C_SCHEME_TRUE;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k1354 in k1345 in thread-block-for-timeout! */
static void C_ccall f_1356(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1356,2,av);}
t2=C_i_setslot(((C_word*)t0)[2],C_fix(3),lf[42]);
t3=C_i_set_i_slot(((C_word*)t0)[2],C_fix(13),C_SCHEME_FALSE);
t4=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_i_setslot(((C_word*)t0)[2],C_fix(4),((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k2323 in loop in clear-i/o-state-for-thread! */
static void C_ccall f_2325(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2325,2,av);}
if(C_truep(C_i_nullp(t1))){
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t2=C_i_setslot(((C_word*)t0)[4],C_fix(1),t1);
t3=((C_word*)t0)[2];
t4=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k1952 in thread-block-for-i/o! */
static void C_ccall f_1954(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_1954,2,av);}
a=C_alloc(3);
t2=C_i_setslot(((C_word*)t0)[2],C_fix(3),lf[42]);
t3=C_i_set_i_slot(((C_word*)t0)[2],C_fix(13),C_SCHEME_FALSE);
t4=C_a_i_cons(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
t5=((C_word*)t0)[5];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=C_i_setslot(((C_word*)t0)[2],C_fix(11),t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#thread-block-for-i/o! */
static void C_ccall f_1950(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,c,3)))){
C_save_and_reclaim((void *)f_1950,5,av);}
a=C_alloc(14);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1954,a[2]=t2,a[3]=t3,a[4]=t4,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1969,a[2]=t3,a[3]=t2,a[4]=t7,a[5]=((C_word)li27),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_1969(t9,t5,*((C_word*)lf[11]+1));}

/* k1854 in for-each-loop364 in loop in k1869 in k990 in loop1 in k981 in schedule */
static void C_ccall f_1856(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_1856,2,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_1846(t3,((C_word*)t0)[4],t2);}

/* k1345 in thread-block-for-timeout! */
static void C_fcall f_1347(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,0,4)))){
C_save_and_reclaim_args((void *)trf_1347,2,t0,t1);}
a=C_alloc(13);
if(C_truep(C_flonum_greaterp(((C_word*)t0)[2],lf[31]))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1356,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1367,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word)li16),tmp=(C_word)a,a+=6,tmp));
t6=((C_word*)t4)[1];
f_1367(t6,t2,lf[10],C_SCHEME_FALSE);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[4];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* ##sys#kill-other-threads */
static void C_ccall f_2561(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,3)))){
C_save_and_reclaim((void *)f_2561,3,av);}
a=C_alloc(13);
t3=*((C_word*)lf[1]+1);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2564,a[2]=t3,a[3]=((C_word)li40),tmp=(C_word)a,a+=4,tmp);
t5=C_mutate2((C_word*)lf[37]+1 /* (set! ##sys#primordial-thread ...) */,*((C_word*)lf[1]+1));
t6=C_a_i_list1(&a,1,*((C_word*)lf[1]+1));
t7=C_mutate2(&lf[13] /* (set! ready-queue-head ...) */,t6);
t8=C_mutate2(&lf[14] /* (set! ready-queue-tail ...) */,lf[13]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2589,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:592: suspend */
t10=t4;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t10;
av2[1]=t9;
av2[2]=*((C_word*)lf[1]+1);
f_2564(3,av2);}}

/* ##sys#thread-block-for-timeout! */
static void C_ccall f_1343(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,2)))){
C_save_and_reclaim((void *)f_1343,4,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1347,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_flonump(t3))){
t5=t4;
f_1347(t5,C_SCHEME_UNDEFINED);}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1420,a[2]=t4,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:293: open-output-string */
t6=*((C_word*)lf[28]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* suspend in kill-other-threads */
static void C_ccall f_2564(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2564,3,av);}
t3=C_eqp(t2,((C_word*)t0)[2]);
t4=(C_truep(t3)?C_SCHEME_UNDEFINED:C_i_setslot(t2,C_fix(3),lf[64]));
t5=C_i_set_i_slot(t2,C_fix(11),C_SCHEME_FALSE);
t6=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t6;
av2[1]=C_i_set_i_slot(t2,C_fix(12),C_SCHEME_END_OF_LIST);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* for-each-loop632 in k2599 in k2587 in kill-other-threads */
static void C_fcall f_2645(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_2645,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2655,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* scheduler.scm:594: g633 */
t5=((C_word*)t0)[3];
f_2602(t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k2118 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_2120(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_2120,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2638 in k2633 in k2599 in k2587 in kill-other-threads */
static void C_ccall f_2640(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2640,2,av);}
/* scheduler.scm:598: exit */
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2299 in clear-i/o-state-for-thread! */
static void C_ccall f_2301(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2301,2,av);}
t2=C_mutate2((C_word*)lf[11]+1 /* (set! ##sys#fd-list ...) */,t1);
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* loop in clear-i/o-state-for-thread! */
static void C_fcall f_2303(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_2303,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_u_i_car(t2);
t4=t3;
t5=C_u_i_car(t4);
t6=C_eqp(((C_word*)t0)[2],t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2325,a[2]=t2,a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
t8=C_u_i_cdr(t4);
/* scheduler.scm:515: ##sys#delq */
t9=*((C_word*)lf[49]+1);{
C_word av2[4];
av2[0]=t9;
av2[1]=t7;
av2[2]=((C_word*)t0)[3];
av2[3]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(4,av2);}}
else{
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2344,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t8=t2;
t9=C_u_i_cdr(t8);
/* scheduler.scm:520: loop */
t11=t7;
t12=t9;
t1=t11;
t2=t12;
goto loop;}}}

/* k2619 in for-each-loop645 in g633 in k2599 in k2587 in kill-other-threads */
static void C_ccall f_2621(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_2621,2,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_2611(t3,((C_word*)t0)[4],t2);}

/* loop in thread-block-for-i/o! */
static void C_fcall f_1969(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(9,0,2)))){
C_save_and_reclaim_args((void *)trf_1969,3,t0,t1,t2);}
a=C_alloc(9);
if(C_truep(C_i_nullp(t2))){
t3=C_a_i_list2(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=C_a_i_cons(&a,2,t3,*((C_word*)lf[11]+1));
t5=C_mutate2((C_word*)lf[11]+1 /* (set! ##sys#fd-list ...) */,t4);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t3=C_u_i_car(t2);
t4=C_u_i_car(t3);
t5=C_eqp(((C_word*)t0)[2],t4);
if(C_truep(t5)){
t6=C_u_i_cdr(t3);
t7=C_a_i_cons(&a,2,((C_word*)t0)[3],t6);
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_i_setslot(t3,C_fix(1),t7);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t6=t2;
t7=C_u_i_cdr(t6);
/* scheduler.scm:438: loop */
t9=t1;
t10=t7;
t1=t9;
t2=t10;
goto loop;}}}

/* k2653 in for-each-loop632 in k2599 in k2587 in kill-other-threads */
static void C_ccall f_2655(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_2655,2,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_2645(t3,((C_word*)t0)[4],t2);}

/* k1093 in loop in loop1 in k981 in schedule */
static void C_ccall f_1095(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_1095,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1098,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* scheduler.scm:187: ##sys#thread-basic-unblock! */
t3=*((C_word*)lf[16]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k1096 in k1093 in loop in loop1 in k981 in schedule */
static void C_ccall f_1098(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_1098,2,av);}
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
/* scheduler.scm:188: loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_1061(t4,((C_word*)t0)[4],t3);}

/* k2159 in k2156 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_2161(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2161,2,av);}
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
/* scheduler.scm:491: loop2 */
t4=((C_word*)((C_word*)t0)[3])[1];
f_2081(t4,((C_word*)t0)[4],t3,((C_word*)t0)[5]);}

/* ##sys#restore-threads */
static void C_ccall f_2510(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2510,3,av);}
t3=C_slot(t2,C_fix(0));
t4=C_mutate2(&lf[13] /* (set! ready-queue-head ...) */,t3);
t5=C_slot(t2,C_fix(1));
t6=C_mutate2(&lf[14] /* (set! ready-queue-tail ...) */,t5);
t7=C_slot(t2,C_fix(2));
t8=C_mutate2((C_word*)lf[11]+1 /* (set! ##sys#fd-list ...) */,t7);
t9=C_slot(t2,C_fix(3));
t10=C_mutate2(&lf[10] /* (set! ##sys#timeout-list ...) */,t9);
t11=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t11;
av2[1]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}

/* k2633 in k2599 in k2587 in kill-other-threads */
static void C_ccall f_2635(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_2635,2,av);}
a=C_alloc(4);
t2=lf[10] /* ##sys#timeout-list */ =C_SCHEME_END_OF_LIST;;
t3=C_set_block_item(lf[11] /* ##sys#fd-list */,0,C_SCHEME_END_OF_LIST);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2640,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:597: thunk */
t5=((C_word*)t0)[4];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* k2156 in loop2 in loop in k2024 in k2015 in k990 in loop1 in k981 in schedule */
static void C_ccall f_2158(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_2158,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2161,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* scheduler.scm:490: ##sys#thread-basic-unblock! */
t3=*((C_word*)lf[16]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k1572 in k1566 in thread-kill! */
static void C_fcall f_1574(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_1574,2,t0,t1);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1577,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* scheduler.scm:342: ##sys#remove-from-timeout-list */
t3=*((C_word*)lf[17]+1);{
C_word av2[3];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k1575 in k1572 in k1566 in thread-kill! */
static void C_ccall f_1577(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_1577,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1580,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* scheduler.scm:343: ##sys#clear-i/o-state-for-thread! */
f_2287(t2,((C_word*)t0)[2]);}

/* ##sys#fetch-and-clear-threads */
static void C_ccall f_2500(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_2500,2,av);}
a=C_alloc(5);
t2=C_a_i_vector4(&a,4,lf[13],lf[14],*((C_word*)lf[11]+1),lf[10]);
t3=lf[13] /* ready-queue-head */ =C_SCHEME_END_OF_LIST;;
t4=lf[14] /* ready-queue-tail */ =C_SCHEME_END_OF_LIST;;
t5=C_set_block_item(lf[11] /* ##sys#fd-list */,0,C_SCHEME_END_OF_LIST);
t6=lf[10] /* ##sys#timeout-list */ =C_SCHEME_END_OF_LIST;;
t7=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t7;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* a1713 in default-exception-handler */
static void C_ccall f_1714(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_1714,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1718,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* scheduler.scm:374: ##sys#signal */
t3=*((C_word*)lf[52]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k1716 in a1713 in default-exception-handler */
static void C_ccall f_1718(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1718,2,av);}
/* scheduler.scm:375: ptx */
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#thread-kill! */
static void C_ccall f_1564(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_1564,4,av);}
a=C_alloc(11);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1568,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=t2;
t6=C_slot(t5,C_fix(8));
if(C_truep(C_i_nullp(t6))){
t7=C_SCHEME_UNDEFINED;
t8=t4;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=t7;
f_1568(2,av2);}}
else{
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1541,a[2]=t8,a[3]=((C_word)li22),tmp=(C_word)a,a+=4,tmp));
t10=((C_word*)t8)[1];
f_1541(t10,t4,t6);}}

/* k1566 in thread-kill! */
static void C_ccall f_1568(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_1568,2,av);}
a=C_alloc(9);
t2=C_slot(((C_word*)t0)[2],C_fix(11));
t3=t2;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1574,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_structurep(t3,lf[48]))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1655,a[2]=t4,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t6=C_slot(t3,C_fix(2));
/* scheduler.scm:339: ##sys#delq */
t7=*((C_word*)lf[49]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
av2[3]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}
else{
if(C_truep(C_i_structurep(t3,lf[50]))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1672,a[2]=t4,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t6=C_slot(t3,C_fix(12));
/* scheduler.scm:341: ##sys#delq */
t7=*((C_word*)lf[49]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
av2[3]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}
else{
t5=C_SCHEME_UNDEFINED;
t6=t4;
f_1574(t6,t5);}}}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[132] = {
{"f_1749:scheduler_2escm",(void*)f_1749},
{"f_1499:scheduler_2escm",(void*)f_1499},
{"f_2491:scheduler_2escm",(void*)f_2491},
{"f_1834:scheduler_2escm",(void*)f_1834},
{"f_1694:scheduler_2escm",(void*)f_1694},
{"f_1738:scheduler_2escm",(void*)f_1738},
{"f_1846:scheduler_2escm",(void*)f_1846},
{"f_2191:scheduler_2escm",(void*)f_2191},
{"f_2197:scheduler_2escm",(void*)f_2197},
{"f_1690:scheduler_2escm",(void*)f_1690},
{"f_2194:scheduler_2escm",(void*)f_2194},
{"f_2182:scheduler_2escm",(void*)f_2182},
{"f_2374:scheduler_2escm",(void*)f_2374},
{"f_2188:scheduler_2escm",(void*)f_2188},
{"f_1295:scheduler_2escm",(void*)f_1295},
{"f_1598:scheduler_2escm",(void*)f_1598},
{"f_1580:scheduler_2escm",(void*)f_1580},
{"f_2545:scheduler_2escm",(void*)f_2545},
{"f_2542:scheduler_2escm",(void*)f_2542},
{"f_2203:scheduler_2escm",(void*)f_2203},
{"f_2200:scheduler_2escm",(void*)f_2200},
{"f_1281:scheduler_2escm",(void*)f_1281},
{"f_2539:scheduler_2escm",(void*)f_2539},
{"f_1302:scheduler_2escm",(void*)f_1302},
{"f_1308:scheduler_2escm",(void*)f_1308},
{"f_2529:scheduler_2escm",(void*)f_2529},
{"f_1655:scheduler_2escm",(void*)f_1655},
{"f_2446:scheduler_2escm",(void*)f_2446},
{"f_2668:scheduler_2escm",(void*)f_2668},
{"f_2439:scheduler_2escm",(void*)f_2439},
{"f_1634:scheduler_2escm",(void*)f_1634},
{"f_2421:scheduler_2escm",(void*)f_2421},
{"f_1277:scheduler_2escm",(void*)f_1277},
{"f_1624:scheduler_2escm",(void*)f_1624},
{"f_2390:scheduler_2escm",(void*)f_2390},
{"f_2397:scheduler_2escm",(void*)f_2397},
{"f_2416:scheduler_2escm",(void*)f_2416},
{"f_1377:scheduler_2escm",(void*)f_1377},
{"f_2217:scheduler_2escm",(void*)f_2217},
{"f_2678:scheduler_2escm",(void*)f_2678},
{"f_2211:scheduler_2escm",(void*)f_2211},
{"f_2214:scheduler_2escm",(void*)f_2214},
{"f_1367:scheduler_2escm",(void*)f_1367},
{"f_1605:scheduler_2escm",(void*)f_1605},
{"f_2287:scheduler_2escm",(void*)f_2287},
{"f_1911:scheduler_2escm",(void*)f_1911},
{"f_1917:scheduler_2escm",(void*)f_1917},
{"f_1914:scheduler_2escm",(void*)f_1914},
{"f_2601:scheduler_2escm",(void*)f_2601},
{"f_1551:scheduler_2escm",(void*)f_1551},
{"f_2602:scheduler_2escm",(void*)f_2602},
{"f_1905:scheduler_2escm",(void*)f_1905},
{"f_1178:scheduler_2escm",(void*)f_1178},
{"f_1004:scheduler_2escm",(void*)f_1004},
{"f_1175:scheduler_2escm",(void*)f_1175},
{"f_1420:scheduler_2escm",(void*)f_1420},
{"f_1541:scheduler_2escm",(void*)f_1541},
{"f_2258:scheduler_2escm",(void*)f_2258},
{"f_2050:scheduler_2escm",(void*)f_2050},
{"f_2052:scheduler_2escm",(void*)f_2052},
{"f_1164:scheduler_2escm",(void*)f_1164},
{"f_1434:scheduler_2escm",(void*)f_1434},
{"f_1432:scheduler_2escm",(void*)f_1432},
{"f_1923:scheduler_2escm",(void*)f_1923},
{"f_1920:scheduler_2escm",(void*)f_1920},
{"f_1926:scheduler_2escm",(void*)f_1926},
{"f_1929:scheduler_2escm",(void*)f_1929},
{"f_1429:scheduler_2escm",(void*)f_1429},
{"f_1426:scheduler_2escm",(void*)f_1426},
{"f_1110:scheduler_2escm",(void*)f_1110},
{"f_2611:scheduler_2escm",(void*)f_2611},
{"f_988:scheduler_2escm",(void*)f_988},
{"f_983:scheduler_2escm",(void*)f_983},
{"f_1515:scheduler_2escm",(void*)f_1515},
{"f_2026:scheduler_2escm",(void*)f_2026},
{"f_953:scheduler_2escm",(void*)f_953},
{"f_2017:scheduler_2escm",(void*)f_2017},
{"f_2081:scheduler_2escm",(void*)f_2081},
{"f_1810:scheduler_2escm",(void*)f_1810},
{"f_1813:scheduler_2escm",(void*)f_1813},
{"f_1000:scheduler_2escm",(void*)f_1000},
{"f_1678:scheduler_2escm",(void*)f_1678},
{"f_1525:scheduler_2escm",(void*)f_1525},
{"f_2462:scheduler_2escm",(void*)f_2462},
{"f_1700:scheduler_2escm",(void*)f_1700},
{"f_1672:scheduler_2escm",(void*)f_1672},
{"toplevel:scheduler_2escm",(void*)C_scheduler_toplevel},
{"f_1801:scheduler_2escm",(void*)f_1801},
{"f_1807:scheduler_2escm",(void*)f_1807},
{"f_1804:scheduler_2escm",(void*)f_1804},
{"f_995:scheduler_2escm",(void*)f_995},
{"f_992:scheduler_2escm",(void*)f_992},
{"f_2356:scheduler_2escm",(void*)f_2356},
{"f_1871:scheduler_2escm",(void*)f_1871},
{"f_1061:scheduler_2escm",(void*)f_1061},
{"f_2590:scheduler_2escm",(void*)f_2590},
{"f_2344:scheduler_2escm",(void*)f_2344},
{"f_1932:scheduler_2escm",(void*)f_1932},
{"f_1792:scheduler_2escm",(void*)f_1792},
{"f_2589:scheduler_2escm",(void*)f_2589},
{"f_1798:scheduler_2escm",(void*)f_1798},
{"f_1356:scheduler_2escm",(void*)f_1356},
{"f_2325:scheduler_2escm",(void*)f_2325},
{"f_1954:scheduler_2escm",(void*)f_1954},
{"f_1950:scheduler_2escm",(void*)f_1950},
{"f_1856:scheduler_2escm",(void*)f_1856},
{"f_1347:scheduler_2escm",(void*)f_1347},
{"f_2561:scheduler_2escm",(void*)f_2561},
{"f_1343:scheduler_2escm",(void*)f_1343},
{"f_2564:scheduler_2escm",(void*)f_2564},
{"f_2645:scheduler_2escm",(void*)f_2645},
{"f_2120:scheduler_2escm",(void*)f_2120},
{"f_2640:scheduler_2escm",(void*)f_2640},
{"f_2301:scheduler_2escm",(void*)f_2301},
{"f_2303:scheduler_2escm",(void*)f_2303},
{"f_2621:scheduler_2escm",(void*)f_2621},
{"f_1969:scheduler_2escm",(void*)f_1969},
{"f_2655:scheduler_2escm",(void*)f_2655},
{"f_1095:scheduler_2escm",(void*)f_1095},
{"f_1098:scheduler_2escm",(void*)f_1098},
{"f_2161:scheduler_2escm",(void*)f_2161},
{"f_2510:scheduler_2escm",(void*)f_2510},
{"f_2635:scheduler_2escm",(void*)f_2635},
{"f_2158:scheduler_2escm",(void*)f_2158},
{"f_1574:scheduler_2escm",(void*)f_1574},
{"f_1577:scheduler_2escm",(void*)f_1577},
{"f_2500:scheduler_2escm",(void*)f_2500},
{"f_1714:scheduler_2escm",(void*)f_1714},
{"f_1718:scheduler_2escm",(void*)f_1718},
{"f_1564:scheduler_2escm",(void*)f_1564},
{"f_1568:scheduler_2escm",(void*)f_1568},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}

/*
S|applied compiler syntax:
S|  for-each		6
S|  ##sys#for-each		1
S|  sprintf		4
o|eliminated procedure checks: 126 
o|specializations:
o|  1 (fpmax float float)
o|  10 (eqv? * (not float))
o|  4 (##sys#check-output-port * * *)
o|  3 (car pair)
o|  20 (cdr pair)
o|  4 (cdar (pair pair *))
(o e)|safe calls: 186 
(o e)|assignments to immediate values: 12 
o|Removed `not' forms: 5 
o|contracted procedure: k1008 
o|inlining procedure: k1005 
o|contracted procedure: "(scheduler.scm:219) switch120" 
o|contracted procedure: "(scheduler.scm:158) restore-thread-state-buffer" 
o|inlining procedure: k1005 
o|contracted procedure: "(scheduler.scm:214) remove-from-ready-queue" 
o|contracted procedure: k1203 
o|inlining procedure: k1200 
o|inlining procedure: k1200 
o|propagated global variable: first-pair181 ready-queue-head 
o|inlining procedure: k1045 
o|inlining procedure: k1045 
o|contracted procedure: "(scheduler.scm:211) unblock-threads-for-i/o" 
o|inlining procedure: k2032 
o|inlining procedure: k2032 
o|inlining procedure: k2054 
o|inlining procedure: k2054 
o|inlining procedure: k2083 
o|inlining procedure: k2083 
o|contracted procedure: k2153 
o|inlining procedure: k2150 
o|contracted procedure: k2176 
o|inlining procedure: k2206 
o|inlining procedure: k2206 
o|contracted procedure: "(scheduler.scm:494) fdset-test" 
o|inlining procedure: k1875 
o|inlining procedure: k1875 
o|inlining procedure: k1893 
o|substituted constant variable: a1907 
o|substituted constant variable: a1908 
o|inlining procedure: k1893 
o|substituted constant variable: a1934 
o|substituted constant variable: a1939 
o|substituted constant variable: a1941 
o|substituted constant variable: a1946 
o|substituted constant variable: a1948 
o|substituted constant variable: a2184 
o|substituted constant variable: a2185 
o|inlining procedure: k2150 
o|contracted procedure: "(scheduler.scm:454) g478479" 
o|substituted constant variable: a2278 
o|contracted procedure: "(scheduler.scm:445) create-fdset" 
o|inlining procedure: k1740 
o|inlining procedure: k1754 
o|inlining procedure: k1771 
o|inlining procedure: k1771 
o|substituted constant variable: a1794 
o|substituted constant variable: a1795 
o|substituted constant variable: a1815 
o|substituted constant variable: a1820 
o|substituted constant variable: a1822 
o|substituted constant variable: a1827 
o|substituted constant variable: a1829 
o|inlining procedure: k1754 
o|inlining procedure: k1740 
o|contracted procedure: "(scheduler.scm:392) g409410" 
o|inlining procedure: k1848 
o|inlining procedure: k1848 
o|contracted procedure: "(scheduler.scm:388) g351352" 
o|inlining procedure: k1063 
o|inlining procedure: k1063 
o|inlining procedure: k1084 
o|inlining procedure: k1084 
o|contracted procedure: k1118 
o|inlining procedure: k1115 
o|inlining procedure: k1115 
o|inlining procedure: k1134 
o|inlining procedure: k1134 
o|contracted procedure: "(scheduler.scm:166) update-thread-state-buffer" 
o|propagated global variable: ct128 ##sys#current-thread 
o|inlining procedure: k1186 
o|inlining procedure: k1186 
o|inlining procedure: k1279 
o|propagated global variable: ct205 ##sys#current-thread 
o|inlining procedure: k1279 
o|inlining procedure: k1310 
o|inlining procedure: k1310 
o|inlining procedure: k1328 
o|inlining procedure: k1328 
o|inlining procedure: k1348 
o|inlining procedure: k1369 
o|inlining procedure: k1369 
o|inlining procedure: k1348 
o|substituted constant variable: a1422 
o|substituted constant variable: a1423 
o|inlining procedure: k1439 
o|inlining procedure: k1439 
o|inlining procedure: k1596 
o|inlining procedure: k1607 
o|inlining procedure: k1607 
o|inlining procedure: k1596 
o|inlining procedure: k1626 
o|inlining procedure: k1626 
o|inlining procedure: k1660 
o|inlining procedure: k1660 
o|contracted procedure: "(scheduler.scm:335) abandon-mutexes" 
o|inlining procedure: k1477 
o|inlining procedure: k1477 
o|inlining procedure: k1543 
o|contracted procedure: "(scheduler.scm:318) g259266" 
o|inlining procedure: k1497 
o|inlining procedure: k1497 
o|inlining procedure: k1517 
o|contracted procedure: "(scheduler.scm:325) g273280" 
o|inlining procedure: k1517 
o|inlining procedure: k1543 
o|propagated global variable: pt342 ##sys#primordial-thread 
o|inlining procedure: k1971 
o|inlining procedure: k1971 
o|inlining procedure: k2289 
o|inlining procedure: k2305 
o|inlining procedure: k2305 
o|inlining procedure: k2326 
o|inlining procedure: k2326 
o|inlining procedure: k2289 
o|inlining procedure: k2376 
o|inlining procedure: k2376 
o|inlining procedure: k2399 
o|inlining procedure: k2423 
o|inlining procedure: k2423 
o|inlining procedure: k2399 
o|inlining procedure: k2448 
o|inlining procedure: k2448 
o|inlining procedure: k2531 
o|inlining procedure: k2531 
o|propagated global variable: primordial608 ##sys#current-thread 
o|inlining procedure: k2613 
o|inlining procedure: k2613 
o|inlining procedure: k2647 
o|inlining procedure: k2647 
o|propagated global variable: g639641 ##sys#fd-list 
o|inlining procedure: k2670 
o|inlining procedure: k2670 
o|propagated global variable: g622624 ##sys#timeout-list 
o|propagated global variable: primordial608 ##sys#current-thread 
o|replaced variables: 261 
o|removed binding forms: 179 
o|substituted constant variable: r12012692 
o|inlining procedure: k1210 
o|inlining procedure: k1210 
o|inlining procedure: k2269 
o|inlining procedure: k2269 
o|substituted constant variable: r11162722 
o|substituted constant variable: r11352727 
o|substituted constant variable: r23062789 
o|converted assignments to bindings: (suspend609) 
o|simplifications: ((let . 1)) 
o|replaced variables: 20 
o|removed binding forms: 288 
o|inlining procedure: k1014 
o|inlining procedure: k1837 
o|replaced variables: 14 
o|removed binding forms: 33 
o|substituted constant variable: r10152901 
o|contracted procedure: k1731 
o|simplifications: ((let . 1)) 
o|replaced variables: 2 
o|removed binding forms: 16 
o|removed conditional forms: 1 
o|removed binding forms: 2 
o|simplifications: ((if . 17) (##core#call . 234)) 
o|  call simplifications:
o|    vector
o|    list	2
o|    ##sys#structure?	2
o|    flonum?
o|    fp>
o|    fp<
o|    fx=	2
o|    set-cdr!	3
o|    equal?
o|    fp>=
o|    fxmax
o|    ##sys#setislot	18
o|    not
o|    caar	7
o|    fp-	2
o|    fx>
o|    zero?
o|    pair?	16
o|    car	12
o|    cons	15
o|    sub1	2
o|    add1	3
o|    cdr	8
o|    null?	25
o|    eq?	25
o|    ##sys#setslot	29
o|    ##sys#slot	53
o|contracted procedure: k975 
o|contracted procedure: k1039 
o|contracted procedure: k1029 
o|contracted procedure: k959 
o|contracted procedure: k966 
o|contracted procedure: k969 
o|contracted procedure: k1249 
o|contracted procedure: k1253 
o|contracted procedure: k1257 
o|contracted procedure: k1261 
o|contracted procedure: k1265 
o|contracted procedure: k1269 
o|contracted procedure: k1273 
o|contracted procedure: k1020 
o|contracted procedure: k1014 
o|contracted procedure: k1219 
o|contracted procedure: k1206 
o|contracted procedure: k1214 
o|contracted procedure: k1048 
o|contracted procedure: k2018 
o|contracted procedure: k2021 
o|contracted procedure: k2029 
o|contracted procedure: k2035 
o|contracted procedure: k2044 
o|contracted procedure: k2057 
o|contracted procedure: k2060 
o|contracted procedure: k2063 
o|contracted procedure: k2066 
o|contracted procedure: k2072 
o|contracted procedure: k2086 
o|contracted procedure: k2092 
o|contracted procedure: k2099 
o|contracted procedure: k2103 
o|contracted procedure: k2107 
o|contracted procedure: k2114 
o|contracted procedure: k2122 
o|contracted procedure: k2126 
o|contracted procedure: k2130 
o|contracted procedure: k2133 
o|contracted procedure: k2136 
o|contracted procedure: k2142 
o|contracted procedure: k2249 
o|contracted procedure: k2245 
o|contracted procedure: k2241 
o|contracted procedure: k2223 
o|contracted procedure: k2235 
o|contracted procedure: k1878 
o|contracted procedure: k1881 
o|contracted procedure: k1887 
o|contracted procedure: k1890 
o|contracted procedure: k1896 
o|contracted procedure: k2167 
o|contracted procedure: k2260 
o|contracted procedure: k2272 
o|contracted procedure: k2275 
o|contracted procedure: k2280 
o|contracted procedure: k1743 
o|contracted procedure: k1746 
o|contracted procedure: k1751 
o|contracted procedure: k1757 
o|contracted procedure: k1764 
o|contracted procedure: k1767 
o|contracted procedure: k1774 
o|contracted procedure: k1777 
o|contracted procedure: k1784 
o|contracted procedure: k1851 
o|contracted procedure: k1861 
o|contracted procedure: k1865 
o|contracted procedure: k1054 
o|contracted procedure: k1066 
o|contracted procedure: k1070 
o|contracted procedure: k1075 
o|contracted procedure: k1081 
o|contracted procedure: k1087 
o|contracted procedure: k1090 
o|contracted procedure: k1111 
o|contracted procedure: k1128 
o|contracted procedure: k1123 
o|contracted procedure: k1131 
o|contracted procedure: k1137 
o|contracted procedure: k1148 
o|contracted procedure: k1151 
o|contracted procedure: k1154 
o|contracted procedure: k1225 
o|propagated global variable: ct128 ##sys#current-thread 
o|contracted procedure: k1228 
o|contracted procedure: k1231 
o|contracted procedure: k1234 
o|contracted procedure: k1237 
o|contracted procedure: k1240 
o|contracted procedure: k1166 
o|contracted procedure: k1180 
o|contracted procedure: k1183 
o|contracted procedure: k1190 
o|contracted procedure: k1186 
o|contracted procedure: k1285 
o|contracted procedure: k1288 
o|contracted procedure: k1313 
o|contracted procedure: k1316 
o|contracted procedure: k1319 
o|contracted procedure: k1339 
o|contracted procedure: k1325 
o|contracted procedure: k1351 
o|contracted procedure: k1357 
o|contracted procedure: k1360 
o|contracted procedure: k1372 
o|contracted procedure: k1389 
o|contracted procedure: k1385 
o|contracted procedure: k1397 
o|contracted procedure: k1393 
o|contracted procedure: k1404 
o|contracted procedure: k1411 
o|contracted procedure: k1414 
o|contracted procedure: k1436 
o|contracted procedure: k1442 
o|contracted procedure: k1445 
o|contracted procedure: k1465 
o|contracted procedure: k1461 
o|contracted procedure: k1448 
o|contracted procedure: k1451 
o|contracted procedure: k1454 
o|contracted procedure: k1569 
o|contracted procedure: k1581 
o|contracted procedure: k1584 
o|contracted procedure: k1587 
o|contracted procedure: k1590 
o|contracted procedure: k1593 
o|contracted procedure: k1602 
o|contracted procedure: k1617 
o|contracted procedure: k1610 
o|contracted procedure: k1629 
o|contracted procedure: k1639 
o|contracted procedure: k1643 
o|contracted procedure: k1646 
o|contracted procedure: k1657 
o|contracted procedure: k1663 
o|contracted procedure: k1674 
o|contracted procedure: k1474 
o|contracted procedure: k1480 
o|contracted procedure: k1546 
o|contracted procedure: k1556 
o|contracted procedure: k1560 
o|contracted procedure: k1485 
o|contracted procedure: k1488 
o|contracted procedure: k1491 
o|contracted procedure: k1494 
o|contracted procedure: k1503 
o|contracted procedure: k1520 
o|contracted procedure: k1530 
o|contracted procedure: k1534 
o|contracted procedure: k1680 
o|contracted procedure: k1683 
o|contracted procedure: k1695 
o|contracted procedure: k1704 
o|contracted procedure: k1707 
o|propagated global variable: pt342 ##sys#primordial-thread 
o|propagated global variable: pt342 ##sys#primordial-thread 
o|contracted procedure: k1955 
o|contracted procedure: k1958 
o|contracted procedure: k1965 
o|contracted procedure: k1974 
o|contracted procedure: k1982 
o|contracted procedure: k1978 
o|contracted procedure: k1985 
o|contracted procedure: k2009 
o|contracted procedure: k1991 
o|contracted procedure: k1998 
o|contracted procedure: k2352 
o|contracted procedure: k2292 
o|contracted procedure: k2348 
o|contracted procedure: k2295 
o|contracted procedure: k2308 
o|contracted procedure: k2311 
o|contracted procedure: k2314 
o|contracted procedure: k2320 
o|contracted procedure: k2329 
o|contracted procedure: k2333 
o|contracted procedure: k2488 
o|contracted procedure: k2358 
o|contracted procedure: k2482 
o|contracted procedure: k2361 
o|contracted procedure: k2476 
o|contracted procedure: k2364 
o|contracted procedure: k2470 
o|contracted procedure: k2367 
o|contracted procedure: k2379 
o|contracted procedure: k2402 
o|contracted procedure: k2411 
o|contracted procedure: k2426 
o|contracted procedure: k2433 
o|contracted procedure: k2451 
o|contracted procedure: k2464 
o|contracted procedure: k2502 
o|contracted procedure: k2513 
o|contracted procedure: k2517 
o|contracted procedure: k2521 
o|contracted procedure: k2525 
o|contracted procedure: k2557 
o|contracted procedure: k2534 
o|contracted procedure: k2553 
o|contracted procedure: k2575 
o|contracted procedure: k2566 
o|contracted procedure: k2569 
o|contracted procedure: k2583 
o|contracted procedure: k2596 
o|contracted procedure: k2604 
o|contracted procedure: k2616 
o|contracted procedure: k2626 
o|contracted procedure: k2630 
o|contracted procedure: k2650 
o|contracted procedure: k2660 
o|contracted procedure: k2664 
o|contracted procedure: k2673 
o|contracted procedure: k2683 
o|contracted procedure: k2687 
o|propagated global variable: primordial608 ##sys#current-thread 
o|simplifications: ((let . 41)) 
o|removed binding forms: 212 
o|replaced variables: 73 
o|inlining procedure: k962 
o|removed binding forms: 28 
o|contracted procedure: k978 
o|propagated global variable: ct128 ##sys#current-thread 
o|propagated global variable: ct128 ##sys#current-thread 
o|removed binding forms: 3 
o|replaced variables: 2 
o|removed binding forms: 1 
o|direct leaf routine/allocation: loop211 0 
o|converted assignments to bindings: (loop211) 
o|simplifications: ((let . 1)) 
o|customizable procedures: (g616623 for-each-loop615626 g633640 for-each-loop632659 for-each-loop645655 k2537 loop582 loop579 loop575 loop572 loop541 loop463 for-each-loop272283 for-each-loop258291 k1572 g307314 for-each-loop306317 k1345 k1375 loop232 k1108 ##sys#clear-i/o-state-for-thread! loop137 g365372 for-each-loop364405 loop357 k2024 loop2507 loop493 k1002 loop1135 loop2152) 
o|calls to known targets: 78 
o|identified direct recursive calls: f_2081 1 
o|identified direct recursive calls: f_2052 1 
o|identified direct recursive calls: f_1061 1 
o|identified direct recursive calls: f_1308 1 
o|identified direct recursive calls: f_1969 1 
o|identified direct recursive calls: f_2303 1 
o|identified direct recursive calls: f_2421 1 
o|fast box initializations: 20 
o|fast global references: 27 
o|fast global assignments: 22 
o|dropping unused closure argument: f_2287 
*/
/* end of file */
