// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * Returns the device board name.
 * @return {string}
 */
export function getBoard() {
  return window.loadTimeData.getString('board_name');
}

/**
 * Returns the I18N message generated by given |name| and |substitutions|.
 * @param {string} name
 * @param {...(string|number)} substitutions
 * @return {string}
 */
export function getI18nMessage(name, ...substitutions) {
  return window.loadTimeData.getStringF(name, ...substitutions);
}

/**
 * @return {string} Returns 'ltr'/'rtl' for left-to-right/right-to-left system
 *     UI language.
 */
export function getTextDirection() {
  return window.loadTimeData.getString('textdirection');
}
