/*
 * Copyright (C) 2003  Robert Collins  <robertc@squid-cache.org>
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * DO NOT ALTER THE NEXT LINE
 * arch-tag: c54c952b-9065-404d-b1ed-e46b9dee5be3
 * 
 */

#ifndef   _CM_CONFIGENTRY_H_
#define   _CM_CONFIGENTRY_H_

#include <string>
class ConfigSource;
class ConfigEntry
{

public:
    ConfigEntry(std::string const &path, ConfigSource *source);
    ConfigEntry(ConfigEntry const &);
    ConfigEntry& operator=(ConfigEntry const &);
    std::string const &path() const;
    ConfigSource const *source();
    void path(std::string const &);

private:
    std::string thePath;
    ConfigSource *theSource;
};

#endif /* _CM_CONFIGENTRY_H_ */
