#!/bin/sh
#set -x
LC_ALL=C
# let's make these ones overwritable:
CONVMV=${CONVMV:=../convmv}
SORT=${SORT:=sort}
TAR=${TAR:=tar}
SED=${SED:=sed}
FIND=${FIND:=find}
DIFF=${DIFF:=diff}
PERL=${PERL:=perl}
GREP=${GREP:=grep}

mycpdir() {
	# copy one directory to another new one. This is needed because cp
	# has no portable way of saying "don't follow symlinks". It is rather
	# a bug that GNU coreutils' cp does preserves symlinks with -r
	srcdir="$1"
	tgtdir="$2"
	(cd "$srcdir"
	$TAR cf - .
	) | (
	mkdir "$tgtdir"
	cd "$tgtdir"
	$TAR xf -
	)
}

myfind() {
	dirname="$1"
	cd $dirname
	# there is no standard tool to show symlink targets except for "ls" but
	# ls has no standard switch to only display symlink target but no time
	# stamps. And as cp can not preserve symlink timestamps we need to
	# clean up ls -l output with sed :-|
	echo links ...
	$FIND . -type l -print | LC_ALL=C $SORT | while read file
	do
		ls -l "$file" | $SED 's/.* \.\///'
	done
	echo files ...
	$FIND . -type f -print | LC_ALL=C $SORT | while read file
	do
		ls "$file"
	done
	echo directories ...
	$FIND . -type d -print | $GREP -v "^\.$" | LC_ALL=C $SORT | while read file
	do
		ls -d "$file"
	done
	cd ..
}

mystat_mtime() {
	$PERL -e '$file=$ARGV[0]; $mtime=(stat($file))[9]; print "$file $mtime\n"' "$*"
}

skipmatch() {
	echo "$SKIP" | $GREP "$1" > /dev/null
	return $?
}

# first of all create file listings of how it should be if conversion was correct:
for dir in `ls -d test*`
do
	myfind $dir/ > out-$dir
done

#
TEST="smartness_test"
skipmatch "$TEST" || {
	echo "$TEST"
	rm -rf test.tmp
	mycpdir test test.tmp
	$CONVMV -f iso8859-15 -t utf8 --notest -r test.tmp
	myfind test.tmp > out.tmp
	$DIFF out-test out.tmp > diff.tmp|| { echo "$TEST failed." ; exit 1; }
}
#
TEST="double-utf8-test"
skipmatch "$TEST" || {
	echo "$TEST"
	rm -rf test.tmp
	mycpdir test test.tmp
	$CONVMV -f iso8859-15 -t utf8 --notest -r --nosmart test.tmp
	myfind test.tmp > out.tmp
	$DIFF out-test-utf8 out.tmp > diff.tmp|| { echo "$TEST failed." ; exit 1; }
}
TEST="double-utf8-test-undo-with-double-utf8-results-test"
# (this test depend on the previous one to be run)
skipmatch "$TEST" || {
	echo "$TEST"
	$CONVMV -f utf8 -t iso8859-15 --notest test.tmp/sch* test.tmp/euro*
	$CONVMV -f utf8 -t iso8859-15 --notest test.tmp/euro*
	$CONVMV -f utf8 -t iso8859-15 --notest --fixdouble -r test.tmp
	myfind test.tmp > out.tmp
	$DIFF out-test-utf8-partitial out.tmp > diff.tmp|| { echo "$TEST failed." ; exit 1; }
}
#
TEST="utf8-to-iso8859-15-test"
skipmatch "$TEST" || {
	echo "$TEST"
	rm -r test.tmp
	mycpdir test test.tmp
	$CONVMV -f utf8 -t iso8859-15 --notest -r test.tmp
	myfind test.tmp > out.tmp
	$DIFF out-test-iso8859-15 out.tmp > diff.tmp|| { echo "$TEST failed." ; exit 1; }
}
#
TEST="iso8859-15-to-utf8-test"
skipmatch "$TEST" || {
	echo "$TEST"
	rm -rf test.tmp
	mycpdir test-iso8859-15 test.tmp
	$CONVMV -f iso8859-15 -t utf8 --notest -r test.tmp
	myfind test.tmp > out.tmp
	$DIFF out-test out.tmp > diff.tmp|| { echo "$TEST failed." ; exit 1; }
}
#
TEST="nfd-test"
skipmatch "$TEST" || {
	echo "$TEST"
	rm -rf test.tmp
	mycpdir test test.tmp
	$CONVMV -f utf-8 -t utf-8 --nfd --notest -r test.tmp
	myfind test.tmp > out.tmp
	$DIFF out-test-nfd out.tmp > diff.tmp|| { echo "$TEST failed." ; exit 1; }
}
TEST="nfd-test-with-nfc-results-test"
# (this test depend on the previous one to be run)
skipmatch "$TEST" || {
	echo "$TEST"
	$CONVMV -f utf8 -t utf8 --nfc --notest -r test.tmp
	myfind test.tmp > out.tmp
	$DIFF out-test out.tmp > diff.tmp|| { echo "$TEST failed." ; exit 1; }
}
#
TEST="escaped-test"
skipmatch "$TEST" || {
	echo "$TEST"
	rm -rf test.tmp
	mycpdir test-escaped test.tmp
	$CONVMV --unescape --notest -r test.tmp
	myfind test.tmp > out.tmp
	$DIFF out-test out.tmp > diff.tmp|| { echo "$TEST failed." ; exit 1; }
}
#
TEST="parsable-test"
skipmatch "$TEST" || {
	echo "$TEST"
	rm -rf test.tmp
	mycpdir test-escaped test.tmp
	$CONVMV --unescape --parsable -r test.tmp | ./parsable_tester.pl
	myfind test.tmp > out.tmp
	$DIFF out-test out.tmp > diff.tmp|| { echo "$TEST failed." ; exit 1; }
}
#
TEST="upper-test"
skipmatch "$TEST" || {
	echo "$TEST"
	rm -rf test.tmp
	mycpdir test test.tmp
	$CONVMV --upper -f utf8 --notest -r test.tmp
	myfind TEST.TMP > out.tmp
	$DIFF out-test-upper out.tmp > diff.tmp|| { echo "$TEST failed." ; exit 1; }
}
#
TEST="preserve-mtimes-test"
skipmatch "$TEST" || {
	echo "$TEST"
	rm -rf TEST.TMP
	mycpdir test test.tmp
	$CONVMV -f utf8 -t iso8859-15 --notest -r --preserve-mtimes test.tmp
	$CONVMV -f iso8859-15 -t utf8 --notest -r --preserve-mtimes test.tmp
#find test.tmp | xargs -I '{}' $CONVMV -f iso8859-15 -t utf8 --notest --preserve-mtimes "{}"
	(cd test; myfind . |while read line ; do mystat_mtime $line ; done ) > out-test-mtimes
	(cd test.tmp ; myfind . |while read line ; do mystat_mtime $line ; done ) > out.tmp
	$DIFF out-test-mtimes out.tmp || { echo "$TEST failed." ; exit 1; }
}

echo All tests successful, cleaning up now ...
rm -rf TEST.TMP *.tmp out*

