/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import net.sf.saxon.Configuration;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQExpression;
import net.sf.saxon.javax.xml.xquery.XQResultSequence;
import net.sf.saxon.javax.xml.xquery.XQWarning;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQDataFactory;
import net.sf.saxon.xqj.SaxonXQDynamicContext;
import net.sf.saxon.xqj.SaxonXQPreparedExpression;

public class SaxonXQExpression
extends SaxonXQDynamicContext
implements XQExpression {
    SaxonXQConnection connection;
    DynamicQueryContext context;
    Configuration config;
    boolean closed;

    SaxonXQExpression(SaxonXQConnection saxonXQConnection) {
        this.connection = saxonXQConnection;
        this.config = saxonXQConnection.getConfiguration();
        this.context = new DynamicQueryContext(this.config);
    }

    protected DynamicQueryContext getDynamicContext() {
        return this.context;
    }

    protected SaxonXQDataFactory getDataFactory() throws XQException {
        return this.connection;
    }

    protected void checkNotClosed() throws XQException {
        if (this.connection.isClosed()) {
            this.close();
        }
        if (this.isClosed()) {
            throw new XQException("Expression has been closed");
        }
    }

    public void cancel() throws XQException {
        this.checkNotClosed();
    }

    public void clearWarnings() throws XQException {
        this.checkNotClosed();
    }

    public void close() {
        this.closed = true;
    }

    public void executeCommand(Reader reader) throws XQException {
        this.checkNotClosed();
        throw new XQException("Saxon does not recognize any non-XQuery commands");
    }

    public void executeCommand(String string) throws XQException {
        this.checkNotClosed();
        throw new XQException("Saxon does not recognize any non-XQuery commands");
    }

    public XQResultSequence executeQuery(InputStream inputStream) throws XQException {
        this.checkNotClosed();
        try {
            StaticQueryContext staticQueryContext = new StaticQueryContext(this.config);
            XQueryExpression xQueryExpression = staticQueryContext.compileQuery(inputStream, null);
            SaxonXQPreparedExpression saxonXQPreparedExpression = new SaxonXQPreparedExpression(this.connection, xQueryExpression, this.context);
            return saxonXQPreparedExpression.executeQuery();
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
        catch (IOException iOException) {
            throw new XQException(iOException.getMessage(), (Throwable)iOException, null, null);
        }
    }

    public XQResultSequence executeQuery(Reader reader) throws XQException {
        this.checkNotClosed();
        try {
            StaticQueryContext staticQueryContext = new StaticQueryContext(this.config);
            XQueryExpression xQueryExpression = staticQueryContext.compileQuery(reader);
            SaxonXQPreparedExpression saxonXQPreparedExpression = new SaxonXQPreparedExpression(this.connection, xQueryExpression, this.context);
            return saxonXQPreparedExpression.executeQuery();
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
        catch (IOException iOException) {
            throw new XQException(iOException.getMessage(), (Throwable)iOException, null, null);
        }
    }

    public XQResultSequence executeQuery(String string) throws XQException {
        this.checkNotClosed();
        try {
            StaticQueryContext staticQueryContext = new StaticQueryContext(this.config);
            XQueryExpression xQueryExpression = staticQueryContext.compileQuery(string);
            SaxonXQPreparedExpression saxonXQPreparedExpression = new SaxonXQPreparedExpression(this.connection, xQueryExpression, this.context);
            return saxonXQPreparedExpression.executeQuery();
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public int getQueryLanguageTypeAndVersion() throws XQException {
        return 1;
    }

    public int getQueryTimeout() throws XQException {
        this.checkNotClosed();
        return 0;
    }

    public XQWarning getWarnings() throws XQException {
        this.checkNotClosed();
        return null;
    }

    public boolean isClosed() {
        if (this.connection.isClosed()) {
            this.closed = true;
        }
        return this.closed;
    }

    public void setQueryTimeout(int n) throws XQException {
        this.checkNotClosed();
    }
}

