struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 335,
		.content = "Processor\t: ARMv7 Processor rev 4 (v7l)\n"
			   "processor\t: 0\n"
			   "BogoMIPS\t: 13.53\n"
			   "\n"
			   "processor\t: 1\n"
			   "BogoMIPS\t: 13.53\n"
			   "\n"
			   "Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 \n"
			   "CPU implementer\t: 0x51\n"
			   "CPU architecture: 7\n"
			   "CPU variant\t: 0x1\n"
			   "CPU part\t: 0x04d\n"
			   "CPU revision\t: 4\n"
			   "\n"
			   "Hardware\t: SAMSUNG M2_ATT\n"
			   "Revision\t: 0010\n"
			   "Serial\t\t: 0000eb0d0000f3a2\n",
	},
	{
		.path = "/system/build.prop",
		.size = 5377,
		.content = "# begin build properties\n"
			   "# autogenerated by buildinfo.sh\n"
			   "ro.build.id=JRO03L\n"
			   "ro.build.display.id=JRO03L.I747UCDLK3\n"
			   "ro.build.version.incremental=I747UCDLK3\n"
			   "ro.build.version.sdk=16\n"
			   "ro.build.version.codename=REL\n"
			   "ro.build.version.release=4.1.1\n"
			   "ro.build.date=Thu Nov 15 15:56:47 KST 2012\n"
			   "ro.build.date.utc=1352962607\n"
			   "ro.build.type=user\n"
			   "ro.build.user=se.infra\n"
			   "ro.build.host=SEP-103\n"
			   "ro.build.tags=release-keys\n"
			   "ro.product.model=SAMSUNG-SGH-I747\n"
			   "ro.product.brand=samsung\n"
			   "ro.product.name=d2uc\n"
			   "ro.product.device=d2att\n"
			   "ro.product.board=MSM8960\n"
			   "ro.chipname=MSM8960\n"
			   "ro.product.cpu.abi=armeabi-v7a\n"
			   "ro.product.cpu.abi2=armeabi\n"
			   "ro.product_ship=true\n"
			   "ro.product.manufacturer=samsung\n"
			   "ro.product.locale.language=en\n"
			   "ro.product.locale.region=GB\n"
			   "ro.wifi.channels=\n"
			   "ro.board.platform=msm8960\n"
			   "# ro.build.product is obsolete; use ro.product.device\n"
			   "ro.build.product=d2att\n"
			   "# Do not try to parse ro.build.description or .fingerprint\n"
			   "ro.build.description=d2uc-user 4.1.1 JRO03L I747UCDLK3 release-keys\n"
			   "ro.build.fingerprint=samsung/d2uc/d2att:4.1.1/JRO03L/I747UCDLK3:user/release-keys\n"
			   "ro.build.characteristics=att\n"
			   "# Samsung Specific Properties\n"
			   "ro.build.PDA=I747UCDLK3\n"
			   "ro.build.hidden_ver=I747UCDLK3\n"
			   "ro.build.changelist=274808\n"
			   "# end build properties\n"
			   "#\n"
			   "# system.prop for surf\n"
			   "#\n"
			   "\n"
			   "rild.libpath=/system/lib/libril-qc-qmi-1.so\n"
			   "rild.libargs=-d /dev/smd0\n"
			   "persist.rild.nitz_plmn=\n"
			   "persist.rild.nitz_long_ons_0=\n"
			   "persist.rild.nitz_long_ons_1=\n"
			   "persist.rild.nitz_long_ons_2=\n"
			   "persist.rild.nitz_long_ons_3=\n"
			   "persist.rild.nitz_short_ons_0=\n"
			   "persist.rild.nitz_short_ons_1=\n"
			   "persist.rild.nitz_short_ons_2=\n"
			   "persist.rild.nitz_short_ons_3=\n"
			   "ril.subscription.types=NV,RUIM\n"
			   "DEVICE_PROVISIONED=1\n"
			   "debug.sf.hw=1\n"
			   "debug.egl.hw=1\n"
			   "debug.composition.type=dyn\n"
			   "debug.compbypass.enable=1\n"
			   "debug.hwui.render_dirty_regions=true\n"
			   "dalvik.vm.heapsize=36m\n"
			   "debug.enable.wl_log=1\n"
			   "debug.mdpcomp.maxlayer=3\n"
			   "\n"
			   "#\n"
			   "# system props for the cne module\n"
			   "#\n"
			   "persist.cne.bat.range.low.med=30\n"
			   "persist.cne.bat.range.med.high=60\n"
			   "persist.cne.loc.policy.op=/system/etc/OperatorPolicy.xml\n"
			   "persist.cne.loc.policy.user=/system/etc/UserPolicy.xml\n"
			   "persist.cne.bwbased.rat.sel=false\n"
			   "persist.cne.snsr.based.rat.mgt=false\n"
			   "persist.cne.bat.based.rat.mgt=false\n"
			   "persist.cne.rat.acq.time.out=30000\n"
			   "persist.cne.rat.acq.retry.tout=0\n"
			   "persist.cne.feature=0\n"
			   "\n"
			   "ro.hdmi.enable=true\n"
			   "lpa.decode=true\n"
			   "lpa.use-stagefright=true\n"
			   "\n"
			   "#system props for the MM modules\n"
			   "\n"
			   "media.stagefright.enable-player=true\n"
			   "media.stagefright.enable-http=true\n"
			   "media.stagefright.enable-aac=true\n"
			   "media.stagefright.enable-qcp=true\n"
			   "media.stagefright.enable-fma2dp=true\n"
			   "media.stagefright.enable-scan=true\n"
			   "mmp.enable.3g2=true\n"
			   "\n"
			   "#\n"
			   "# system props for the data modules\n"
			   "#\n"
			   "ro.use_data_netmgrd=true\n"
			   "\n"
			   "#system props for time-services\n"
			   "persist.timed.enable=true\n"
			   "\n"
			   "# System props for audio\n"
			   "persist.audio.fluence.mode=endfire\n"
			   "persist.audio.vr.enable=false\n"
			   "persist.audio.handset.mic=digital\n"
			   "\n"
			   "# System prop to select audio resampler quality\n"
			   "af.resampler.quality=255\n"
			   "# System prop to select MPQAudioPlayer by default on mpq8064\n"
			   "mpq.audio.decode=true\n"
			   "\n"
			   "#\n"
			   "# system prop for opengles version\n"
			   "#\n"
			   "# 131072 is decimal for 0x20000 to report version 2\n"
			   "ro.opengles.version=131072\n"
			   "\n"
			   "#\n"
			   "# system property for Bluetooth Handsfree Profile version\n"
			   "#\n"
			   "ro.bluetooth.hfp.ver=1.6\n"
			   "#\n"
			   "#system prop for Bluetooth hci transport\n"
			   "ro.qualcomm.bt.hci_transport=smd\n"
			   "#\n"
			   "# system prop for requesting Master role in incoming Bluetooth connection.\n"
			   "#\n"
			   "ro.bluetooth.request.master=true\n"
			   "#\n"
			   "# system prop for Bluetooth Auto connect for remote initated connections\n"
			   "#\n"
			   "ro.bluetooth.remote.autoconnect=true\n"
			   "# system property for Bluetooth discoverability time out in seconds\n"
			   "# 0: Always discoverable\n"
			   "#debug.bt.discoverable_time=0\n"
			   "\n"
			   "#system prop for switching gps driver to qmi\n"
			   "persist.gps.qmienabled=true\n"
			   "\n"
			   "# System property for cabl\n"
			   "ro.qualcomm.cabl=1\n"
			   "\n"
			   "#\n"
			   "# System prop for sending transmit power request to RIL during WiFi hotspot on/off\n"
			   "#\n"
			   "ro.ril.transmitpower=true\n"
			   "\n"
			   "#\n"
			   "#Simulate sdcard on /data/media\n"
			   "#\n"
			   "persist.fuse_sdcard=true\n"
			   "ro.hwui.text_cache_width=2048\n"
			   "\n"
			   "#\n"
			   "# Supports warmboot capabilities\n"
			   "#\n"
			   "ro.warmboot.capability=1\n"
			   "\n"
			   "ro.sf.lcd_density=320\n"
			   "\n"
			   "# Keep SIM state on LPM mode\n"
			   "persist.radio.apm_sim_not_pwdn=1\n"
			   "\n"
			   "# System property for Default touch key light duration\n"
			   "ro.button_key_light=6000\n"
			   "\n"
			   "# System proverty for sys info indication\n"
			   "persist.radio.add_power_save=1\n"
			   "\n"
			   "# System property for HDMI/WFD\n"
			   "persist.sys.camera.connect=0\n"
			   "persist.sys.camera.transform=0\n"
			   "persist.sys.videomode=0\n"
			   "#\n"
			   "# ADDITIONAL_BUILD_PROPERTIES\n"
			   "#\n"
			   "ro.vendor.extension_library=/system/lib/libqc-opt.so\n"
			   "ro.error.receiver.default=com.samsung.receiver.error\n"
			   "dalvik.vm.heapstartsize=8m\n"
			   "dalvik.vm.heapgrowthlimit=64m\n"
			   "dalvik.vm.heapsize=256m\n"
			   "dalvik.vm.heaputilization=0.25\n"
			   "dalvik.vm.heapidealfree=8388608\n"
			   "dalvik.vm.heapconcurrentstart=2097152\n"
			   "ro.hdcp2.rx=tz\n"
			   "ro.sec.fle.encryption=true\n"
			   "ro.config.alarm_alert=Walk_in_the_forest.ogg\n"
			   "ro.config.ringtone=ATT_Firefly_Default.ogg\n"
			   "ro.config.notification_sound=S_Whistle.ogg\n"
			   "ro.monkey=0\n"
			   "keyguard.no_require_sim=true\n"
			   "ro.com.android.dateformat=MM-dd-yyyy\n"
			   "ro.carrier=unknown\n"
			   "ro.ril.hsxpa=1\n"
			   "ro.ril.gprsclass=10\n"
			   "ro.adb.qemud=1\n"
			   "ro.setupwizard.mode=OPTIONAL\n"
			   "ro.com.google.apphider=off\n"
			   "ro.com.google.clientidbase=android-samsung\n"
			   "ro.com.google.clientidbase.ms=android-att-us\n"
			   "ro.com.google.clientidbase.am=android-att-us\n"
			   "ro.com.google.clientidbase.yt=android-samsung\n"
			   "ro.com.google.clientidbase.gmm=android-samsung\n"
			   "ro.com.google.gmsversion=4.1_r3\n"
			   "net.bt.name=Android\n"
			   "dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			   "\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1512000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 91,
		.content =
			"384000 486000 594000 702000 810000 918000 1026000 1134000 1242000 1350000 1458000 1512000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 51,
		.content = "msm-dcvs ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1512000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "performance\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 116,
		.content = "384000 0\n"
			   "486000 0\n"
			   "594000 0\n"
			   "702000 0\n"
			   "810000 0\n"
			   "918000 0\n"
			   "1026000 0\n"
			   "1134000 0\n"
			   "1242000 0\n"
			   "1350000 0\n"
			   "1458000 0\n"
			   "1512000 818\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 3,
		.content = "-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1512000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 91,
		.content =
			"384000 486000 594000 702000 810000 918000 1026000 1134000 1242000 1350000 1458000 1512000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 51,
		.content = "msm-dcvs ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1512000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "performance\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1512000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "384000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 117,
		.content = "384000 0\n"
			   "486000 0\n"
			   "594000 0\n"
			   "702000 0\n"
			   "810000 0\n"
			   "918000 0\n"
			   "1026000 0\n"
			   "1134000 0\n"
			   "1242000 0\n"
			   "1350000 0\n"
			   "1458000 0\n"
			   "1512000 1064\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 3,
		.content = "-1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 2,
		.content = "2\n",
	},
	{NULL},
};

#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "DEVICE_PROVISIONED",
		.value = "1",
	},
	{
		.key = "af.resampler.quality",
		.value = "255",
	},
	{
		.key = "dalvik.vm.heapconcurrentstart",
		.value = "2097152",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.heapidealfree",
		.value = "8388608",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "256m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heaputilization",
		.value = "0.25",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.compbypass.enable",
		.value = "1",
	},
	{
		.key = "debug.composition.type",
		.value = "dyn",
	},
	{
		.key = "debug.egl.hw",
		.value = "1",
	},
	{
		.key = "debug.enable.wl_log",
		.value = "1",
	},
	{
		.key = "debug.hwui.render_dirty_regions",
		.value = "true",
	},
	{
		.key = "debug.mdpcomp.maxlayer",
		.value = "3",
	},
	{
		.key = "debug.sf.hw",
		.value = "1",
	},
	{
		.key = "dev.kiessupport",
		.value = "TRUE",
	},
	{
		.key = "hw.cabl.version",
		.value = "1.0.20120512\n",
	},
	{
		.key = "init.svc.BCS-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.DR-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.DTT-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.KIES-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.SMD-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.TvoutService_C",
		.value = "running",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.at_distributor",
		.value = "running",
	},
	{
		.key = "init.svc.atfwd",
		.value = "running",
	},
	{
		.key = "init.svc.cnd",
		.value = "running",
	},
	{
		.key = "init.svc.dbus",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.diag_uart_log",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.gsiff_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.icd",
		.value = "stopped",
	},
	{
		.key = "init.svc.immvibed",
		.value = "stopped",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.macloader",
		.value = "running",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mobex-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netmgrd",
		.value = "running",
	},
	{
		.key = "init.svc.poke_helper",
		.value = "running",
	},
	{
		.key = "init.svc.powersnd",
		.value = "running",
	},
	{
		.key = "init.svc.ppd",
		.value = "running",
	},
	{
		.key = "init.svc.qcamerasvr",
		.value = "running",
	},
	{
		.key = "init.svc.qcom-c_core-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-c_main-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-post-fs",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-usb-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qmiproxy",
		.value = "running",
	},
	{
		.key = "init.svc.qmuxd",
		.value = "running",
	},
	{
		.key = "init.svc.qrngd",
		.value = "running",
	},
	{
		.key = "init.svc.qseecomd",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.rmt_storage",
		.value = "running",
	},
	{
		.key = "init.svc.samsungani",
		.value = "running",
	},
	{
		.key = "init.svc.sdcard",
		.value = "running",
	},
	{
		.key = "init.svc.secril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.secstarter",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.thermald",
		.value = "running",
	},
	{
		.key = "init.svc.time_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "lpa.decode",
		.value = "true",
	},
	{
		.key = "lpa.use-stagefright",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-aac",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-fma2dp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-http",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-player",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-qcp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-scan",
		.value = "true",
	},
	{
		.key = "mmp.enable.3g2",
		.value = "true",
	},
	{
		.key = "mpq.audio.decode",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.tcp.buffersize.evdo_b",
	},
	{
		.key = "net.rmnet0.dns1",
		.value = "",
	},
	{
		.key = "net.rmnet0.dns2",
		.value = "",
	},
	{
		.key = "net.rmnet0.gw",
		.value = "",
	},
	{
		.key = "net.rmnet1.dns1",
		.value = "",
	},
	{
		.key = "net.rmnet1.dns2",
		.value = "",
	},
	{
		.key = "net.rmnet1.gw",
		.value = "",
	},
	{
		.key = "net.rmnet2.dns1",
		.value = "",
	},
	{
		.key = "net.rmnet2.dns2",
		.value = "",
	},
	{
		.key = "net.rmnet2.gw",
		.value = "",
	},
	{
		.key = "net.tcp.buffersize.default",
		.value = "4096,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.edge",
		.value = "4093,26280,35040,4096,16384,35040",
	},
	{
		.key = "net.tcp.buffersize.evdo_b",
		.value = "4094,87380,262144,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.gprs",
		.value = "4092,8760,11680,4096,8760,11680",
	},
	{
		.key = "net.tcp.buffersize.hsdpa",
		.value = "4092,87380,704512,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.hspa",
		.value = "4092,87380,704512,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.hspap",
		.value = "4092,87380,704512,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.hsupa",
		.value = "4092,87380,704512,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.lte",
		.value = "524288,1048576,2560000,262144,524288,1220608",
	},
	{
		.key = "net.tcp.buffersize.umts",
		.value = "4094,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.wifi",
		.value = "524288,1048576,2097152,262144,524288,1048576",
	},
	{
		.key = "persist.audio.allsoundmute",
		.value = "0",
	},
	{
		.key = "persist.audio.fluence.mode",
		.value = "endfire",
	},
	{
		.key = "persist.audio.handset.mic",
		.value = "digital",
	},
	{
		.key = "persist.audio.headsetsysvolume",
		.value = "4",
	},
	{
		.key = "persist.audio.hphonesysvolume",
		.value = "4",
	},
	{
		.key = "persist.audio.ringermode",
		.value = "0",
	},
	{
		.key = "persist.audio.sysvolume",
		.value = "4",
	},
	{
		.key = "persist.audio.vr.enable",
		.value = "false",
	},
	{
		.key = "persist.cne.bat.based.rat.mgt",
		.value = "false",
	},
	{
		.key = "persist.cne.bat.range.low.med",
		.value = "30",
	},
	{
		.key = "persist.cne.bat.range.med.high",
		.value = "60",
	},
	{
		.key = "persist.cne.bwbased.rat.sel",
		.value = "false",
	},
	{
		.key = "persist.cne.feature",
		.value = "0",
	},
	{
		.key = "persist.cne.loc.policy.op",
		.value = "/system/etc/OperatorPolicy.xml",
	},
	{
		.key = "persist.cne.loc.policy.user",
		.value = "/system/etc/UserPolicy.xml",
	},
	{
		.key = "persist.cne.rat.acq.retry.tout",
		.value = "0",
	},
	{
		.key = "persist.cne.rat.acq.time.out",
		.value = "30000",
	},
	{
		.key = "persist.cne.snsr.based.rat.mgt",
		.value = "false",
	},
	{
		.key = "persist.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "persist.gps.qmienabled",
		.value = "true",
	},
	{
		.key = "persist.radio.adb_log_on",
		.value = "1",
	},
	{
		.key = "persist.radio.add_power_save",
		.value = "1",
	},
	{
		.key = "persist.radio.apm_sim_not_pwdn",
		.value = "1",
	},
	{
		.key = "persist.radio.mem_leak_debug",
		.value = "0",
	},
	{
		.key = "persist.radio.sglte.mode_pref",
		.value = "9",
	},
	{
		.key = "persist.radio.voip_enabled",
		.value = "0",
	},
	{
		.key = "persist.rild.nitz_long_ons_0",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_1",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_2",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_3",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_plmn",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_0",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_1",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_2",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_3",
		.value = "",
	},
	{
		.key = "persist.sys.camera.connect",
		.value = "0",
	},
	{
		.key = "persist.sys.camera.transform",
		.value = "0",
	},
	{
		.key = "persist.sys.country",
		.value = "",
	},
	{
		.key = "persist.sys.flipfontpath",
		.value = "default",
	},
	{
		.key = "persist.sys.language",
		.value = "",
	},
	{
		.key = "persist.sys.localevar",
		.value = "",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.storage_preload",
		.value = "2",
	},
	{
		.key = "persist.sys.timezone",
		.value = "America/Los_Angeles",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.sys.videomode",
		.value = "0",
	},
	{
		.key = "persist.timed.enable",
		.value = "true",
	},
	{
		.key = "ril.atd_status",
		.value = "1_0",
	},
	{
		.key = "ril.serialnumber",
		.value = "R21CC66XTZN",
	},
	{
		.key = "ril.subscription.types",
		.value = "NV,RUIM",
	},
	{
		.key = "rild.libargs",
		.value = "-d /dev/smd0",
	},
	{
		.key = "rild.libpath",
		.value = "/system/lib/libril-qc-qmi-1.so",
	},
	{
		.key = "ro.adb.qemud",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.baseband",
		.value = "msm",
	},
	{
		.key = "ro.bluetooth.hfp.ver",
		.value = "1.6",
	},
	{
		.key = "ro.bluetooth.remote.autoconnect",
		.value = "true",
	},
	{
		.key = "ro.bluetooth.request.master",
		.value = "true",
	},
	{
		.key = "ro.board.platform",
		.value = "msm8960",
	},
	{
		.key = "ro.boot.baseband",
		.value = "msm",
	},
	{
		.key = "ro.boot.batt_check_recovery",
		.value = "0",
	},
	{
		.key = "ro.boot.boot_recovery",
		.value = "0",
	},
	{
		.key = "ro.boot.bootloader",
		.value = "I747UCDLK3",
	},
	{
		.key = "ro.boot.cp_debug_level",
		.value = "0x55FF",
	},
	{
		.key = "ro.boot.debug_level",
		.value = "0x4f4c",
	},
	{
		.key = "ro.boot.emmc",
		.value = "true",
	},
	{
		.key = "ro.boot.emmc_checksum",
		.value = "3",
	},
	{
		.key = "ro.boot.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.boot.nvdata_backup",
		.value = "1",
	},
	{
		.key = "ro.boot.serialno",
		.value = "eb0df3a2",
	},
	{
		.key = "ro.boot_recovery",
		.value = "0",
	},
	{
		.key = "ro.bootchg",
		.value = "unknown",
	},
	{
		.key = "ro.bootloader",
		.value = "I747UCDLK3",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.bt.bdaddr_path",
		.value = "/efs/bluetooth/bt_addr",
	},
	{
		.key = "ro.build.PDA",
		.value = "I747UCDLK3",
	},
	{
		.key = "ro.build.changelist",
		.value = "274808",
	},
	{
		.key = "ro.build.characteristics",
		.value = "att",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1352962607",
	},
	{
		.key = "ro.build.date",
		.value = "Thu Nov 15 15:56:47 KST 2012",
	},
	{
		.key = "ro.build.description",
		.value = "d2uc-user 4.1.1 JRO03L I747UCDLK3 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "JRO03L.I747UCDLK3",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "samsung/d2uc/d2att:4.1.1/JRO03L/I747UCDLK3:user/release-keys",
	},
	{
		.key = "ro.build.hidden_ver",
		.value = "I747UCDLK3",
	},
	{
		.key = "ro.build.host",
		.value = "SEP-103",
	},
	{
		.key = "ro.build.id",
		.value = "JRO03L",
	},
	{
		.key = "ro.build.product",
		.value = "d2att",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "se.infra",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "I747UCDLK3",
	},
	{
		.key = "ro.build.version.release",
		.value = "4.1.1",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "16",
	},
	{
		.key = "ro.button_key_light",
		.value = "6000",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.chipname",
		.value = "MSM8960",
	},
	{
		.key = "ro.com.android.dateformat",
		.value = "MM-dd-yyyy",
	},
	{
		.key = "ro.com.google.apphider",
		.value = "off",
	},
	{
		.key = "ro.com.google.clientidbase.am",
		.value = "android-att-us",
	},
	{
		.key = "ro.com.google.clientidbase.gmm",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.clientidbase.ms",
		.value = "android-att-us",
	},
	{
		.key = "ro.com.google.clientidbase.yt",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "4.1_r3",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Walk_in_the_forest.ogg",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "S_Whistle.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "ATT_Firefly_Default.ogg",
	},
	{
		.key = "ro.cp_debug_level",
		.value = "0x55FF",
	},
	{
		.key = "ro.crypto.state",
		.value = "unencrypted",
	},
	{
		.key = "ro.csc.country_code",
		.value = "USA",
	},
	{
		.key = "ro.csc.countryiso_code",
		.value = "US",
	},
	{
		.key = "ro.csc.sales_code",
		.value = "ATT",
	},
	{
		.key = "ro.debug_level",
		.value = "0x4f4c",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.emmc",
		.value = "true",
	},
	{
		.key = "ro.emmc_checksum",
		.value = "3",
	},
	{
		.key = "ro.error.receiver.default",
		.value = "com.samsung.receiver.error",
	},
	{
		.key = "ro.factorytest",
		.value = "0",
	},
	{
		.key = "ro.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "ro.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.hdcp2.rx",
		.value = "tz",
	},
	{
		.key = "ro.hdmi.enable",
		.value = "true",
	},
	{
		.key = "ro.hwui.text_cache_width",
		.value = "2048",
	},
	{
		.key = "ro.kernel.qemu",
		.value = "0",
	},
	{
		.key = "ro.monkey",
		.value = "0",
	},
	{
		.key = "ro.nfc.port",
		.value = "I2C",
	},
	{
		.key = "ro.nvdata_backup",
		.value = "1",
	},
	{
		.key = "ro.opengles.version",
		.value = "131072",
	},
	{
		.key = "ro.product.board",
		.value = "MSM8960",
	},
	{
		.key = "ro.product.brand",
		.value = "samsung",
	},
	{
		.key = "ro.product.cpu.abi2",
		.value = "armeabi",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "armeabi-v7a",
	},
	{
		.key = "ro.product.device",
		.value = "d2att",
	},
	{
		.key = "ro.product.locale.language",
		.value = "en",
	},
	{
		.key = "ro.product.locale.region",
		.value = "GB",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "samsung",
	},
	{
		.key = "ro.product.model",
		.value = "SAMSUNG-SGH-I747",
	},
	{
		.key = "ro.product.name",
		.value = "d2uc",
	},
	{
		.key = "ro.product_ship",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.dun",
		.value = "false",
	},
	{
		.key = "ro.qualcomm.bluetooth.ftp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hfp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hsp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.map",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.nap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.opp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.pbap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.sap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bt.hci_transport",
		.value = "smd",
	},
	{
		.key = "ro.qualcomm.cabl",
		.value = "1",
	},
	{
		.key = "ro.revision",
		.value = "16",
	},
	{
		.key = "ro.ril.gprsclass",
		.value = "10",
	},
	{
		.key = "ro.ril.hsxpa",
		.value = "1",
	},
	{
		.key = "ro.ril.transmitpower",
		.value = "true",
	},
	{
		.key = "ro.sec.fle.encryption",
		.value = "true",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "eb0df3a2",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "OPTIONAL",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "320",
	},
	{
		.key = "ro.telephony.call_ring.multiple",
		.value = "false",
	},
	{
		.key = "ro.use_data_netmgrd",
		.value = "true",
	},
	{
		.key = "ro.vendor.extension_library",
		.value = "/system/lib/libqc-opt.so",
	},
	{
		.key = "ro.warmboot.capability",
		.value = "1",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "service.bootanim.exit",
		.value = "0",
	},
	{
		.key = "service.media.powersnd",
		.value = "1",
	},
	{
		.key = "sys.media.vdec.sw",
		.value = "0",
	},
	{
		.key = "sys.qseecomd.enable",
		.value = "true",
	},
	{
		.key = "sys.service_manager_ready",
		.value = "1",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "system_init.startsurfaceflinger",
		.value = "0",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.ath",
		.value = "0",
	},
	{
		.key = "wlan.driver.config",
		.value = "/data/misc/wifi/WCNSS_qcom_cfg.ini",
	},
	{
		.key = "wlan.poke_helper.pid",
		.value = "224",
	},
	{
		.key = "wlan.wfd.tcp",
		.value = "0",
	},
	{NULL},
};
#endif /* __ANDROID__ */
