﻿// <auto-generated />

using System;
using System.Collections.Generic;
using Microsoft.AspNetCore.Razor.Language.Legacy;

namespace Microsoft.AspNetCore.Razor.Language.Syntax;

internal abstract partial class RazorBlockSyntax : RazorSyntaxNode
{
    internal RazorBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public abstract SyntaxList<RazorSyntaxNode> Children { get; }
    public RazorBlockSyntax WithChildren(SyntaxList<RazorSyntaxNode> children) => WithChildrenCore(children);
    internal abstract RazorBlockSyntax WithChildrenCore(SyntaxList<RazorSyntaxNode> children);

    public RazorBlockSyntax AddChildren(params RazorSyntaxNode[] items) => AddChildrenCore(items);
    internal abstract RazorBlockSyntax AddChildrenCore(params RazorSyntaxNode[] items);
}

internal sealed partial class RazorDocumentSyntax : RazorSyntaxNode
{
    private RazorBlockSyntax _document;

    internal RazorDocumentSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public RazorBlockSyntax Document  => GetRedAtZero(ref _document);
    public SyntaxToken EndOfFile => new SyntaxToken(this, ((InternalSyntax.RazorDocumentSyntax)Green)._endOfFile, GetChildPosition(1), GetChildIndex(1));

    internal override SyntaxNode GetNodeSlot(int index) => index == 0 ? GetRedAtZero(ref this._document) : null;

    internal override SyntaxNode GetCachedSlot(int index) => index == 0 ? this._document : null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitRazorDocument(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitRazorDocument(this);

    public RazorDocumentSyntax Update(RazorBlockSyntax document, SyntaxToken endOfFile)
    {
        if (document != Document || endOfFile != EndOfFile)
        {
            var newNode = SyntaxFactory.RazorDocument(document, endOfFile);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public RazorDocumentSyntax WithDocument(RazorBlockSyntax document) => Update(document, EndOfFile);
    public RazorDocumentSyntax WithEndOfFile(SyntaxToken endOfFile) => Update(Document, endOfFile);
}

internal sealed partial class RazorCommentBlockSyntax : RazorSyntaxNode
{
    internal RazorCommentBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken StartCommentTransition => new SyntaxToken(this, ((InternalSyntax.RazorCommentBlockSyntax)Green)._startCommentTransition, Position, 0);
    public SyntaxToken StartCommentStar => new SyntaxToken(this, ((InternalSyntax.RazorCommentBlockSyntax)Green)._startCommentStar, GetChildPosition(1), GetChildIndex(1));
    public SyntaxToken Comment => new SyntaxToken(this, ((InternalSyntax.RazorCommentBlockSyntax)Green)._comment, GetChildPosition(2), GetChildIndex(2));
    public SyntaxToken EndCommentStar => new SyntaxToken(this, ((InternalSyntax.RazorCommentBlockSyntax)Green)._endCommentStar, GetChildPosition(3), GetChildIndex(3));
    public SyntaxToken EndCommentTransition => new SyntaxToken(this, ((InternalSyntax.RazorCommentBlockSyntax)Green)._endCommentTransition, GetChildPosition(4), GetChildIndex(4));

    internal override SyntaxNode GetNodeSlot(int index) => null;

    internal override SyntaxNode GetCachedSlot(int index) => null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitRazorCommentBlock(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitRazorCommentBlock(this);

    public RazorCommentBlockSyntax Update(SyntaxToken startCommentTransition, SyntaxToken startCommentStar, SyntaxToken comment, SyntaxToken endCommentStar, SyntaxToken endCommentTransition)
    {
        if (startCommentTransition != StartCommentTransition || startCommentStar != StartCommentStar || comment != Comment || endCommentStar != EndCommentStar || endCommentTransition != EndCommentTransition)
        {
            var newNode = SyntaxFactory.RazorCommentBlock(startCommentTransition, startCommentStar, comment, endCommentStar, endCommentTransition);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public RazorCommentBlockSyntax WithStartCommentTransition(SyntaxToken startCommentTransition) => Update(startCommentTransition, StartCommentStar, Comment, EndCommentStar, EndCommentTransition);
    public RazorCommentBlockSyntax WithStartCommentStar(SyntaxToken startCommentStar) => Update(StartCommentTransition, startCommentStar, Comment, EndCommentStar, EndCommentTransition);
    public RazorCommentBlockSyntax WithComment(SyntaxToken comment) => Update(StartCommentTransition, StartCommentStar, comment, EndCommentStar, EndCommentTransition);
    public RazorCommentBlockSyntax WithEndCommentStar(SyntaxToken endCommentStar) => Update(StartCommentTransition, StartCommentStar, Comment, endCommentStar, EndCommentTransition);
    public RazorCommentBlockSyntax WithEndCommentTransition(SyntaxToken endCommentTransition) => Update(StartCommentTransition, StartCommentStar, Comment, EndCommentStar, endCommentTransition);
}

internal sealed partial class RazorMetaCodeSyntax : RazorSyntaxNode
{
    internal RazorMetaCodeSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxTokenList MetaCode
    {
         get
        {
            var slot = Green.GetSlot(0);
            return slot != null ? new SyntaxTokenList(this, slot, Position, 0) : default;
        }
    }
    public ISpanChunkGenerator ChunkGenerator => ((InternalSyntax.RazorMetaCodeSyntax)Green).ChunkGenerator;

    internal override SyntaxNode GetNodeSlot(int index) => null;

    internal override SyntaxNode GetCachedSlot(int index) => null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitRazorMetaCode(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitRazorMetaCode(this);

    public RazorMetaCodeSyntax Update(SyntaxTokenList metaCode, ISpanChunkGenerator chunkGenerator)
    {
        if (metaCode != MetaCode || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.RazorMetaCode(metaCode, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public RazorMetaCodeSyntax WithMetaCode(SyntaxTokenList metaCode) => Update(metaCode, ChunkGenerator);
    public RazorMetaCodeSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator) => Update(MetaCode, chunkGenerator);

    public RazorMetaCodeSyntax AddMetaCode(params SyntaxToken[] items) => WithMetaCode(this.MetaCode.AddRange(items));
}

internal sealed partial class GenericBlockSyntax : RazorBlockSyntax
{
    private SyntaxNode _children;

    internal GenericBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<RazorSyntaxNode> Children  => new SyntaxList<RazorSyntaxNode>(GetRed(ref _children, 0));

    internal override SyntaxNode GetNodeSlot(int index) => index == 0 ? GetRedAtZero(ref this._children) : null;

    internal override SyntaxNode GetCachedSlot(int index) => index == 0 ? this._children : null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitGenericBlock(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitGenericBlock(this);

    public GenericBlockSyntax Update(SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.GenericBlock(children);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    internal override RazorBlockSyntax WithChildrenCore(SyntaxList<RazorSyntaxNode> children) => WithChildren(children);
    public new GenericBlockSyntax WithChildren(SyntaxList<RazorSyntaxNode> children) => Update(children);
    internal override RazorBlockSyntax AddChildrenCore(params RazorSyntaxNode[] items) => AddChildren(items);

    public new GenericBlockSyntax AddChildren(params RazorSyntaxNode[] items) => WithChildren(this.Children.AddRange(items));
}

internal sealed partial class UnclassifiedTextLiteralSyntax : RazorSyntaxNode
{
    internal UnclassifiedTextLiteralSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxTokenList LiteralTokens
    {
         get
        {
            var slot = Green.GetSlot(0);
            return slot != null ? new SyntaxTokenList(this, slot, Position, 0) : default;
        }
    }
    public ISpanChunkGenerator ChunkGenerator => ((InternalSyntax.UnclassifiedTextLiteralSyntax)Green).ChunkGenerator;

    internal override SyntaxNode GetNodeSlot(int index) => null;

    internal override SyntaxNode GetCachedSlot(int index) => null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitUnclassifiedTextLiteral(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitUnclassifiedTextLiteral(this);

    public UnclassifiedTextLiteralSyntax Update(SyntaxTokenList literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.UnclassifiedTextLiteral(literalTokens, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public UnclassifiedTextLiteralSyntax WithLiteralTokens(SyntaxTokenList literalTokens) => Update(literalTokens, ChunkGenerator);
    public UnclassifiedTextLiteralSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator) => Update(LiteralTokens, chunkGenerator);

    public UnclassifiedTextLiteralSyntax AddLiteralTokens(params SyntaxToken[] items) => WithLiteralTokens(this.LiteralTokens.AddRange(items));
}

internal abstract partial class MarkupSyntaxNode : RazorSyntaxNode
{
    internal MarkupSyntaxNode(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }
}

internal sealed partial class MarkupBlockSyntax : RazorBlockSyntax
{
    private SyntaxNode _children;

    internal MarkupBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<RazorSyntaxNode> Children  => new SyntaxList<RazorSyntaxNode>(GetRed(ref _children, 0));

    internal override SyntaxNode GetNodeSlot(int index) => index == 0 ? GetRedAtZero(ref this._children) : null;

    internal override SyntaxNode GetCachedSlot(int index) => index == 0 ? this._children : null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupBlock(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupBlock(this);

    public MarkupBlockSyntax Update(SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.MarkupBlock(children);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    internal override RazorBlockSyntax WithChildrenCore(SyntaxList<RazorSyntaxNode> children) => WithChildren(children);
    public new MarkupBlockSyntax WithChildren(SyntaxList<RazorSyntaxNode> children) => Update(children);
    internal override RazorBlockSyntax AddChildrenCore(params RazorSyntaxNode[] items) => AddChildren(items);

    public new MarkupBlockSyntax AddChildren(params RazorSyntaxNode[] items) => WithChildren(this.Children.AddRange(items));
}

internal sealed partial class MarkupTransitionSyntax : MarkupSyntaxNode
{
    internal MarkupTransitionSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxTokenList TransitionTokens
    {
         get
        {
            var slot = Green.GetSlot(0);
            return slot != null ? new SyntaxTokenList(this, slot, Position, 0) : default;
        }
    }
    public ISpanChunkGenerator ChunkGenerator => ((InternalSyntax.MarkupTransitionSyntax)Green).ChunkGenerator;

    internal override SyntaxNode GetNodeSlot(int index) => null;

    internal override SyntaxNode GetCachedSlot(int index) => null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupTransition(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupTransition(this);

    public MarkupTransitionSyntax Update(SyntaxTokenList transitionTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (transitionTokens != TransitionTokens || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.MarkupTransition(transitionTokens, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public MarkupTransitionSyntax WithTransitionTokens(SyntaxTokenList transitionTokens) => Update(transitionTokens, ChunkGenerator);
    public MarkupTransitionSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator) => Update(TransitionTokens, chunkGenerator);

    public MarkupTransitionSyntax AddTransitionTokens(params SyntaxToken[] items) => WithTransitionTokens(this.TransitionTokens.AddRange(items));
}

internal sealed partial class MarkupTextLiteralSyntax : MarkupSyntaxNode
{
    internal MarkupTextLiteralSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxTokenList LiteralTokens
    {
         get
        {
            var slot = Green.GetSlot(0);
            return slot != null ? new SyntaxTokenList(this, slot, Position, 0) : default;
        }
    }
    public ISpanChunkGenerator ChunkGenerator => ((InternalSyntax.MarkupTextLiteralSyntax)Green).ChunkGenerator;

    internal override SyntaxNode GetNodeSlot(int index) => null;

    internal override SyntaxNode GetCachedSlot(int index) => null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupTextLiteral(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupTextLiteral(this);

    public MarkupTextLiteralSyntax Update(SyntaxTokenList literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.MarkupTextLiteral(literalTokens, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public MarkupTextLiteralSyntax WithLiteralTokens(SyntaxTokenList literalTokens) => Update(literalTokens, ChunkGenerator);
    public MarkupTextLiteralSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator) => Update(LiteralTokens, chunkGenerator);

    public MarkupTextLiteralSyntax AddLiteralTokens(params SyntaxToken[] items) => WithLiteralTokens(this.LiteralTokens.AddRange(items));
}

internal sealed partial class MarkupEphemeralTextLiteralSyntax : MarkupSyntaxNode
{
    internal MarkupEphemeralTextLiteralSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxTokenList LiteralTokens
    {
         get
        {
            var slot = Green.GetSlot(0);
            return slot != null ? new SyntaxTokenList(this, slot, Position, 0) : default;
        }
    }
    public ISpanChunkGenerator ChunkGenerator => ((InternalSyntax.MarkupEphemeralTextLiteralSyntax)Green).ChunkGenerator;

    internal override SyntaxNode GetNodeSlot(int index) => null;

    internal override SyntaxNode GetCachedSlot(int index) => null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupEphemeralTextLiteral(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupEphemeralTextLiteral(this);

    public MarkupEphemeralTextLiteralSyntax Update(SyntaxTokenList literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.MarkupEphemeralTextLiteral(literalTokens, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public MarkupEphemeralTextLiteralSyntax WithLiteralTokens(SyntaxTokenList literalTokens) => Update(literalTokens, ChunkGenerator);
    public MarkupEphemeralTextLiteralSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator) => Update(LiteralTokens, chunkGenerator);

    public MarkupEphemeralTextLiteralSyntax AddLiteralTokens(params SyntaxToken[] items) => WithLiteralTokens(this.LiteralTokens.AddRange(items));
}

internal sealed partial class MarkupCommentBlockSyntax : RazorBlockSyntax
{
    private SyntaxNode _children;

    internal MarkupCommentBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<RazorSyntaxNode> Children  => new SyntaxList<RazorSyntaxNode>(GetRed(ref _children, 0));

    internal override SyntaxNode GetNodeSlot(int index) => index == 0 ? GetRedAtZero(ref this._children) : null;

    internal override SyntaxNode GetCachedSlot(int index) => index == 0 ? this._children : null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupCommentBlock(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupCommentBlock(this);

    public MarkupCommentBlockSyntax Update(SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.MarkupCommentBlock(children);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    internal override RazorBlockSyntax WithChildrenCore(SyntaxList<RazorSyntaxNode> children) => WithChildren(children);
    public new MarkupCommentBlockSyntax WithChildren(SyntaxList<RazorSyntaxNode> children) => Update(children);
    internal override RazorBlockSyntax AddChildrenCore(params RazorSyntaxNode[] items) => AddChildren(items);

    public new MarkupCommentBlockSyntax AddChildren(params RazorSyntaxNode[] items) => WithChildren(this.Children.AddRange(items));
}

internal sealed partial class MarkupMinimizedAttributeBlockSyntax : MarkupSyntaxNode
{
    private MarkupTextLiteralSyntax _namePrefix;
    private MarkupTextLiteralSyntax _name;

    internal MarkupMinimizedAttributeBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTextLiteralSyntax NamePrefix  => GetRedAtZero(ref _namePrefix);
    public MarkupTextLiteralSyntax Name  => GetRed(ref _name, 1);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _namePrefix),
            1 => GetRed(ref _name, 1),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._namePrefix,
            1 => this._name,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupMinimizedAttributeBlock(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupMinimizedAttributeBlock(this);

    public MarkupMinimizedAttributeBlockSyntax Update(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
    {
        if (namePrefix != NamePrefix || name != Name)
        {
            var newNode = SyntaxFactory.MarkupMinimizedAttributeBlock(namePrefix, name);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public MarkupMinimizedAttributeBlockSyntax WithNamePrefix(MarkupTextLiteralSyntax namePrefix) => Update(namePrefix, Name);
    public MarkupMinimizedAttributeBlockSyntax WithName(MarkupTextLiteralSyntax name) => Update(NamePrefix, name);

    public MarkupMinimizedAttributeBlockSyntax AddNameLiteralTokens(params SyntaxToken[] items) => WithName(this.Name.WithLiteralTokens(this.Name.LiteralTokens.AddRange(items)));
}

internal sealed partial class MarkupAttributeBlockSyntax : MarkupSyntaxNode
{
    private MarkupTextLiteralSyntax _namePrefix;
    private MarkupTextLiteralSyntax _name;
    private MarkupTextLiteralSyntax _nameSuffix;
    private MarkupTextLiteralSyntax _valuePrefix;
    private RazorBlockSyntax _value;
    private MarkupTextLiteralSyntax _valueSuffix;

    internal MarkupAttributeBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTextLiteralSyntax NamePrefix  => GetRedAtZero(ref _namePrefix);
    public MarkupTextLiteralSyntax Name  => GetRed(ref _name, 1);
    public MarkupTextLiteralSyntax NameSuffix  => GetRed(ref _nameSuffix, 2);
    public SyntaxToken EqualsToken => new SyntaxToken(this, ((InternalSyntax.MarkupAttributeBlockSyntax)Green)._equalsToken, GetChildPosition(3), GetChildIndex(3));
    public MarkupTextLiteralSyntax ValuePrefix  => GetRed(ref _valuePrefix, 4);
    public RazorBlockSyntax Value  => GetRed(ref _value, 5);
    public MarkupTextLiteralSyntax ValueSuffix  => GetRed(ref _valueSuffix, 6);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _namePrefix),
            1 => GetRed(ref _name, 1),
            2 => GetRed(ref _nameSuffix, 2),
            4 => GetRed(ref _valuePrefix, 4),
            5 => GetRed(ref _value, 5),
            6 => GetRed(ref _valueSuffix, 6),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._namePrefix,
            1 => this._name,
            2 => this._nameSuffix,
            4 => this._valuePrefix,
            5 => this._value,
            6 => this._valueSuffix,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupAttributeBlock(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupAttributeBlock(this);

    public MarkupAttributeBlockSyntax Update(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, RazorBlockSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        if (namePrefix != NamePrefix || name != Name || nameSuffix != NameSuffix || equalsToken != EqualsToken || valuePrefix != ValuePrefix || value != Value || valueSuffix != ValueSuffix)
        {
            var newNode = SyntaxFactory.MarkupAttributeBlock(namePrefix, name, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public MarkupAttributeBlockSyntax WithNamePrefix(MarkupTextLiteralSyntax namePrefix) => Update(namePrefix, Name, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    public MarkupAttributeBlockSyntax WithName(MarkupTextLiteralSyntax name) => Update(NamePrefix, name, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    public MarkupAttributeBlockSyntax WithNameSuffix(MarkupTextLiteralSyntax nameSuffix) => Update(NamePrefix, Name, nameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    public MarkupAttributeBlockSyntax WithEqualsToken(SyntaxToken equalsToken) => Update(NamePrefix, Name, NameSuffix, equalsToken, ValuePrefix, Value, ValueSuffix);
    public MarkupAttributeBlockSyntax WithValuePrefix(MarkupTextLiteralSyntax valuePrefix) => Update(NamePrefix, Name, NameSuffix, EqualsToken, valuePrefix, Value, ValueSuffix);
    public MarkupAttributeBlockSyntax WithValue(RazorBlockSyntax value) => Update(NamePrefix, Name, NameSuffix, EqualsToken, ValuePrefix, value, ValueSuffix);
    public MarkupAttributeBlockSyntax WithValueSuffix(MarkupTextLiteralSyntax valueSuffix) => Update(NamePrefix, Name, NameSuffix, EqualsToken, ValuePrefix, Value, valueSuffix);

    public MarkupAttributeBlockSyntax AddNameLiteralTokens(params SyntaxToken[] items) => WithName(this.Name.WithLiteralTokens(this.Name.LiteralTokens.AddRange(items)));
}

internal sealed partial class MarkupMiscAttributeContentSyntax : MarkupSyntaxNode
{
    private SyntaxNode _children;

    internal MarkupMiscAttributeContentSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxList<RazorSyntaxNode> Children  => new SyntaxList<RazorSyntaxNode>(GetRed(ref _children, 0));

    internal override SyntaxNode GetNodeSlot(int index) => index == 0 ? GetRedAtZero(ref this._children) : null;

    internal override SyntaxNode GetCachedSlot(int index) => index == 0 ? this._children : null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupMiscAttributeContent(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupMiscAttributeContent(this);

    public MarkupMiscAttributeContentSyntax Update(SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.MarkupMiscAttributeContent(children);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public MarkupMiscAttributeContentSyntax WithChildren(SyntaxList<RazorSyntaxNode> children) => Update(children);

    public MarkupMiscAttributeContentSyntax AddChildren(params RazorSyntaxNode[] items) => WithChildren(this.Children.AddRange(items));
}

internal sealed partial class MarkupLiteralAttributeValueSyntax : MarkupSyntaxNode
{
    private MarkupTextLiteralSyntax _prefix;
    private MarkupTextLiteralSyntax _value;

    internal MarkupLiteralAttributeValueSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTextLiteralSyntax Prefix  => GetRedAtZero(ref _prefix);
    public MarkupTextLiteralSyntax Value  => GetRed(ref _value, 1);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _prefix),
            1 => GetRed(ref _value, 1),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._prefix,
            1 => this._value,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupLiteralAttributeValue(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupLiteralAttributeValue(this);

    public MarkupLiteralAttributeValueSyntax Update(MarkupTextLiteralSyntax prefix, MarkupTextLiteralSyntax value)
    {
        if (prefix != Prefix || value != Value)
        {
            var newNode = SyntaxFactory.MarkupLiteralAttributeValue(prefix, value);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public MarkupLiteralAttributeValueSyntax WithPrefix(MarkupTextLiteralSyntax prefix) => Update(prefix, Value);
    public MarkupLiteralAttributeValueSyntax WithValue(MarkupTextLiteralSyntax value) => Update(Prefix, value);
}

internal sealed partial class MarkupDynamicAttributeValueSyntax : MarkupSyntaxNode
{
    private MarkupTextLiteralSyntax _prefix;
    private RazorBlockSyntax _value;

    internal MarkupDynamicAttributeValueSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTextLiteralSyntax Prefix  => GetRedAtZero(ref _prefix);
    public RazorBlockSyntax Value  => GetRed(ref _value, 1);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _prefix),
            1 => GetRed(ref _value, 1),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._prefix,
            1 => this._value,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupDynamicAttributeValue(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupDynamicAttributeValue(this);

    public MarkupDynamicAttributeValueSyntax Update(MarkupTextLiteralSyntax prefix, RazorBlockSyntax value)
    {
        if (prefix != Prefix || value != Value)
        {
            var newNode = SyntaxFactory.MarkupDynamicAttributeValue(prefix, value);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public MarkupDynamicAttributeValueSyntax WithPrefix(MarkupTextLiteralSyntax prefix) => Update(prefix, Value);
    public MarkupDynamicAttributeValueSyntax WithValue(RazorBlockSyntax value) => Update(Prefix, value);
}

internal abstract partial class BaseMarkupStartTagSyntax : MarkupSyntaxNode
{
    internal BaseMarkupStartTagSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public abstract SyntaxToken OpenAngle { get; }
    public BaseMarkupStartTagSyntax WithOpenAngle(SyntaxToken openAngle) => WithOpenAngleCore(openAngle);
    internal abstract BaseMarkupStartTagSyntax WithOpenAngleCore(SyntaxToken openAngle);

    public abstract SyntaxToken Bang { get; }
    public BaseMarkupStartTagSyntax WithBang(SyntaxToken bang) => WithBangCore(bang);
    internal abstract BaseMarkupStartTagSyntax WithBangCore(SyntaxToken bang);

    public abstract SyntaxToken Name { get; }
    public BaseMarkupStartTagSyntax WithName(SyntaxToken name) => WithNameCore(name);
    internal abstract BaseMarkupStartTagSyntax WithNameCore(SyntaxToken name);

    public abstract SyntaxList<RazorSyntaxNode> Attributes { get; }
    public BaseMarkupStartTagSyntax WithAttributes(SyntaxList<RazorSyntaxNode> attributes) => WithAttributesCore(attributes);
    internal abstract BaseMarkupStartTagSyntax WithAttributesCore(SyntaxList<RazorSyntaxNode> attributes);

    public BaseMarkupStartTagSyntax AddAttributes(params RazorSyntaxNode[] items) => AddAttributesCore(items);
    internal abstract BaseMarkupStartTagSyntax AddAttributesCore(params RazorSyntaxNode[] items);

    public abstract SyntaxToken ForwardSlash { get; }
    public BaseMarkupStartTagSyntax WithForwardSlash(SyntaxToken forwardSlash) => WithForwardSlashCore(forwardSlash);
    internal abstract BaseMarkupStartTagSyntax WithForwardSlashCore(SyntaxToken forwardSlash);

    public abstract SyntaxToken CloseAngle { get; }
    public BaseMarkupStartTagSyntax WithCloseAngle(SyntaxToken closeAngle) => WithCloseAngleCore(closeAngle);
    internal abstract BaseMarkupStartTagSyntax WithCloseAngleCore(SyntaxToken closeAngle);

    public abstract ISpanChunkGenerator ChunkGenerator { get; }
}

internal abstract partial class BaseMarkupEndTagSyntax : MarkupSyntaxNode
{
    internal BaseMarkupEndTagSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public abstract SyntaxToken OpenAngle { get; }
    public BaseMarkupEndTagSyntax WithOpenAngle(SyntaxToken openAngle) => WithOpenAngleCore(openAngle);
    internal abstract BaseMarkupEndTagSyntax WithOpenAngleCore(SyntaxToken openAngle);

    public abstract SyntaxToken ForwardSlash { get; }
    public BaseMarkupEndTagSyntax WithForwardSlash(SyntaxToken forwardSlash) => WithForwardSlashCore(forwardSlash);
    internal abstract BaseMarkupEndTagSyntax WithForwardSlashCore(SyntaxToken forwardSlash);

    public abstract SyntaxToken Bang { get; }
    public BaseMarkupEndTagSyntax WithBang(SyntaxToken bang) => WithBangCore(bang);
    internal abstract BaseMarkupEndTagSyntax WithBangCore(SyntaxToken bang);

    public abstract SyntaxToken Name { get; }
    public BaseMarkupEndTagSyntax WithName(SyntaxToken name) => WithNameCore(name);
    internal abstract BaseMarkupEndTagSyntax WithNameCore(SyntaxToken name);

    public abstract MarkupMiscAttributeContentSyntax MiscAttributeContent { get; }
    public BaseMarkupEndTagSyntax WithMiscAttributeContent(MarkupMiscAttributeContentSyntax miscAttributeContent) => WithMiscAttributeContentCore(miscAttributeContent);
    internal abstract BaseMarkupEndTagSyntax WithMiscAttributeContentCore(MarkupMiscAttributeContentSyntax miscAttributeContent);

    public BaseMarkupEndTagSyntax AddMiscAttributeContentChildren(params RazorSyntaxNode[] items) => AddMiscAttributeContentChildrenCore(items);
    internal abstract BaseMarkupEndTagSyntax AddMiscAttributeContentChildrenCore(params RazorSyntaxNode[] items);

    public abstract SyntaxToken CloseAngle { get; }
    public BaseMarkupEndTagSyntax WithCloseAngle(SyntaxToken closeAngle) => WithCloseAngleCore(closeAngle);
    internal abstract BaseMarkupEndTagSyntax WithCloseAngleCore(SyntaxToken closeAngle);

    public abstract ISpanChunkGenerator ChunkGenerator { get; }
}

internal sealed partial class MarkupElementSyntax : MarkupSyntaxNode
{
    private MarkupStartTagSyntax _startTag;
    private SyntaxNode _body;
    private MarkupEndTagSyntax _endTag;

    internal MarkupElementSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupStartTagSyntax StartTag  => GetRedAtZero(ref _startTag);
    public SyntaxList<RazorSyntaxNode> Body  => new SyntaxList<RazorSyntaxNode>(GetRed(ref _body, 1));
    public MarkupEndTagSyntax EndTag  => GetRed(ref _endTag, 2);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _startTag),
            1 => GetRed(ref _body, 1),
            2 => GetRed(ref _endTag, 2),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._startTag,
            1 => this._body,
            2 => this._endTag,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupElement(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupElement(this);

    public MarkupElementSyntax Update(MarkupStartTagSyntax startTag, SyntaxList<RazorSyntaxNode> body, MarkupEndTagSyntax endTag)
    {
        if (startTag != StartTag || body != Body || endTag != EndTag)
        {
            var newNode = SyntaxFactory.MarkupElement(startTag, body, endTag);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public MarkupElementSyntax WithStartTag(MarkupStartTagSyntax startTag) => Update(startTag, Body, EndTag);
    public MarkupElementSyntax WithBody(SyntaxList<RazorSyntaxNode> body) => Update(StartTag, body, EndTag);
    public MarkupElementSyntax WithEndTag(MarkupEndTagSyntax endTag) => Update(StartTag, Body, endTag);

    public MarkupElementSyntax AddBody(params RazorSyntaxNode[] items) => WithBody(this.Body.AddRange(items));
}

internal sealed partial class MarkupStartTagSyntax : BaseMarkupStartTagSyntax
{
    private SyntaxNode _attributes;

    internal MarkupStartTagSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken OpenAngle => new SyntaxToken(this, ((InternalSyntax.MarkupStartTagSyntax)Green)._openAngle, Position, 0);
    public override SyntaxToken Bang
    {
        get
        {
            var slot = ((InternalSyntax.MarkupStartTagSyntax)Green).Bang;
            return slot != null ? new SyntaxToken(this, slot, GetChildPosition(1), GetChildIndex(1)) : default;
        }
    }
    public override SyntaxToken Name => new SyntaxToken(this, ((InternalSyntax.MarkupStartTagSyntax)Green)._name, GetChildPosition(2), GetChildIndex(2));
    public override SyntaxList<RazorSyntaxNode> Attributes  => new SyntaxList<RazorSyntaxNode>(GetRed(ref _attributes, 3));
    public override SyntaxToken ForwardSlash
    {
        get
        {
            var slot = ((InternalSyntax.MarkupStartTagSyntax)Green).ForwardSlash;
            return slot != null ? new SyntaxToken(this, slot, GetChildPosition(4), GetChildIndex(4)) : default;
        }
    }
    public override SyntaxToken CloseAngle => new SyntaxToken(this, ((InternalSyntax.MarkupStartTagSyntax)Green)._closeAngle, GetChildPosition(5), GetChildIndex(5));
    public override ISpanChunkGenerator ChunkGenerator => ((InternalSyntax.MarkupStartTagSyntax)Green).ChunkGenerator;

    internal override SyntaxNode GetNodeSlot(int index) => index == 3 ? GetRed(ref this._attributes, 3) : null;

    internal override SyntaxNode GetCachedSlot(int index) => index == 3 ? this._attributes : null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupStartTag(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupStartTag(this);

    public MarkupStartTagSyntax Update(SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, SyntaxList<RazorSyntaxNode> attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle != OpenAngle || bang != Bang || name != Name || attributes != Attributes || forwardSlash != ForwardSlash || closeAngle != CloseAngle || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.MarkupStartTag(openAngle, bang, name, attributes, forwardSlash, closeAngle, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    internal override BaseMarkupStartTagSyntax WithOpenAngleCore(SyntaxToken openAngle) => WithOpenAngle(openAngle);
    public new MarkupStartTagSyntax WithOpenAngle(SyntaxToken openAngle) => Update(openAngle, Bang, Name, Attributes, ForwardSlash, CloseAngle, ChunkGenerator);
    internal override BaseMarkupStartTagSyntax WithBangCore(SyntaxToken bang) => WithBang(bang);
    public new MarkupStartTagSyntax WithBang(SyntaxToken bang) => Update(OpenAngle, bang, Name, Attributes, ForwardSlash, CloseAngle, ChunkGenerator);
    internal override BaseMarkupStartTagSyntax WithNameCore(SyntaxToken name) => WithName(name);
    public new MarkupStartTagSyntax WithName(SyntaxToken name) => Update(OpenAngle, Bang, name, Attributes, ForwardSlash, CloseAngle, ChunkGenerator);
    internal override BaseMarkupStartTagSyntax WithAttributesCore(SyntaxList<RazorSyntaxNode> attributes) => WithAttributes(attributes);
    public new MarkupStartTagSyntax WithAttributes(SyntaxList<RazorSyntaxNode> attributes) => Update(OpenAngle, Bang, Name, attributes, ForwardSlash, CloseAngle, ChunkGenerator);
    internal override BaseMarkupStartTagSyntax WithForwardSlashCore(SyntaxToken forwardSlash) => WithForwardSlash(forwardSlash);
    public new MarkupStartTagSyntax WithForwardSlash(SyntaxToken forwardSlash) => Update(OpenAngle, Bang, Name, Attributes, forwardSlash, CloseAngle, ChunkGenerator);
    internal override BaseMarkupStartTagSyntax WithCloseAngleCore(SyntaxToken closeAngle) => WithCloseAngle(closeAngle);
    public new MarkupStartTagSyntax WithCloseAngle(SyntaxToken closeAngle) => Update(OpenAngle, Bang, Name, Attributes, ForwardSlash, closeAngle, ChunkGenerator);
    public MarkupStartTagSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator) => Update(OpenAngle, Bang, Name, Attributes, ForwardSlash, CloseAngle, chunkGenerator);
    internal override BaseMarkupStartTagSyntax AddAttributesCore(params RazorSyntaxNode[] items) => AddAttributes(items);

    public new MarkupStartTagSyntax AddAttributes(params RazorSyntaxNode[] items) => WithAttributes(this.Attributes.AddRange(items));
}

internal sealed partial class MarkupEndTagSyntax : BaseMarkupEndTagSyntax
{
    private MarkupMiscAttributeContentSyntax _miscAttributeContent;

    internal MarkupEndTagSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken OpenAngle => new SyntaxToken(this, ((InternalSyntax.MarkupEndTagSyntax)Green)._openAngle, Position, 0);
    public override SyntaxToken ForwardSlash => new SyntaxToken(this, ((InternalSyntax.MarkupEndTagSyntax)Green)._forwardSlash, GetChildPosition(1), GetChildIndex(1));
    public override SyntaxToken Bang
    {
        get
        {
            var slot = ((InternalSyntax.MarkupEndTagSyntax)Green).Bang;
            return slot != null ? new SyntaxToken(this, slot, GetChildPosition(2), GetChildIndex(2)) : default;
        }
    }
    public override SyntaxToken Name => new SyntaxToken(this, ((InternalSyntax.MarkupEndTagSyntax)Green)._name, GetChildPosition(3), GetChildIndex(3));
    public override MarkupMiscAttributeContentSyntax MiscAttributeContent  => GetRed(ref _miscAttributeContent, 4);
    public override SyntaxToken CloseAngle => new SyntaxToken(this, ((InternalSyntax.MarkupEndTagSyntax)Green)._closeAngle, GetChildPosition(5), GetChildIndex(5));
    public override ISpanChunkGenerator ChunkGenerator => ((InternalSyntax.MarkupEndTagSyntax)Green).ChunkGenerator;

    internal override SyntaxNode GetNodeSlot(int index) => index == 4 ? GetRed(ref this._miscAttributeContent, 4) : null;

    internal override SyntaxNode GetCachedSlot(int index) => index == 4 ? this._miscAttributeContent : null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupEndTag(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupEndTag(this);

    public MarkupEndTagSyntax Update(SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle != OpenAngle || forwardSlash != ForwardSlash || bang != Bang || name != Name || miscAttributeContent != MiscAttributeContent || closeAngle != CloseAngle || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.MarkupEndTag(openAngle, forwardSlash, bang, name, miscAttributeContent, closeAngle, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    internal override BaseMarkupEndTagSyntax WithOpenAngleCore(SyntaxToken openAngle) => WithOpenAngle(openAngle);
    public new MarkupEndTagSyntax WithOpenAngle(SyntaxToken openAngle) => Update(openAngle, ForwardSlash, Bang, Name, MiscAttributeContent, CloseAngle, ChunkGenerator);
    internal override BaseMarkupEndTagSyntax WithForwardSlashCore(SyntaxToken forwardSlash) => WithForwardSlash(forwardSlash);
    public new MarkupEndTagSyntax WithForwardSlash(SyntaxToken forwardSlash) => Update(OpenAngle, forwardSlash, Bang, Name, MiscAttributeContent, CloseAngle, ChunkGenerator);
    internal override BaseMarkupEndTagSyntax WithBangCore(SyntaxToken bang) => WithBang(bang);
    public new MarkupEndTagSyntax WithBang(SyntaxToken bang) => Update(OpenAngle, ForwardSlash, bang, Name, MiscAttributeContent, CloseAngle, ChunkGenerator);
    internal override BaseMarkupEndTagSyntax WithNameCore(SyntaxToken name) => WithName(name);
    public new MarkupEndTagSyntax WithName(SyntaxToken name) => Update(OpenAngle, ForwardSlash, Bang, name, MiscAttributeContent, CloseAngle, ChunkGenerator);
    internal override BaseMarkupEndTagSyntax WithMiscAttributeContentCore(MarkupMiscAttributeContentSyntax miscAttributeContent) => WithMiscAttributeContent(miscAttributeContent);
    public new MarkupEndTagSyntax WithMiscAttributeContent(MarkupMiscAttributeContentSyntax miscAttributeContent) => Update(OpenAngle, ForwardSlash, Bang, Name, miscAttributeContent, CloseAngle, ChunkGenerator);
    internal override BaseMarkupEndTagSyntax WithCloseAngleCore(SyntaxToken closeAngle) => WithCloseAngle(closeAngle);
    public new MarkupEndTagSyntax WithCloseAngle(SyntaxToken closeAngle) => Update(OpenAngle, ForwardSlash, Bang, Name, MiscAttributeContent, closeAngle, ChunkGenerator);
    public MarkupEndTagSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator) => Update(OpenAngle, ForwardSlash, Bang, Name, MiscAttributeContent, CloseAngle, chunkGenerator);
    internal override BaseMarkupEndTagSyntax AddMiscAttributeContentChildrenCore(params RazorSyntaxNode[] items) => AddMiscAttributeContentChildren(items);

    public new MarkupEndTagSyntax AddMiscAttributeContentChildren(params RazorSyntaxNode[] items)
    {
        var _miscAttributeContent = this.MiscAttributeContent ?? SyntaxFactory.MarkupMiscAttributeContent();
        return this.WithMiscAttributeContent(_miscAttributeContent.WithChildren(_miscAttributeContent.Children.AddRange(items)));
    }
}

internal sealed partial class MarkupTagHelperElementSyntax : MarkupSyntaxNode
{
    private MarkupTagHelperStartTagSyntax _startTag;
    private SyntaxNode _body;
    private MarkupTagHelperEndTagSyntax _endTag;

    internal MarkupTagHelperElementSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTagHelperStartTagSyntax StartTag  => GetRedAtZero(ref _startTag);
    public SyntaxList<RazorSyntaxNode> Body  => new SyntaxList<RazorSyntaxNode>(GetRed(ref _body, 1));
    public MarkupTagHelperEndTagSyntax EndTag  => GetRed(ref _endTag, 2);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _startTag),
            1 => GetRed(ref _body, 1),
            2 => GetRed(ref _endTag, 2),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._startTag,
            1 => this._body,
            2 => this._endTag,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupTagHelperElement(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupTagHelperElement(this);

    public MarkupTagHelperElementSyntax Update(MarkupTagHelperStartTagSyntax startTag, SyntaxList<RazorSyntaxNode> body, MarkupTagHelperEndTagSyntax endTag)
    {
        if (startTag != StartTag || body != Body || endTag != EndTag)
        {
            var newNode = SyntaxFactory.MarkupTagHelperElement(startTag, body, endTag);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public MarkupTagHelperElementSyntax WithStartTag(MarkupTagHelperStartTagSyntax startTag) => Update(startTag, Body, EndTag);
    public MarkupTagHelperElementSyntax WithBody(SyntaxList<RazorSyntaxNode> body) => Update(StartTag, body, EndTag);
    public MarkupTagHelperElementSyntax WithEndTag(MarkupTagHelperEndTagSyntax endTag) => Update(StartTag, Body, endTag);

    public MarkupTagHelperElementSyntax AddStartTagAttributes(params RazorSyntaxNode[] items) => WithStartTag(this.StartTag.WithAttributes(this.StartTag.Attributes.AddRange(items)));

    public MarkupTagHelperElementSyntax AddBody(params RazorSyntaxNode[] items) => WithBody(this.Body.AddRange(items));
}

internal sealed partial class MarkupTagHelperStartTagSyntax : BaseMarkupStartTagSyntax
{
    private SyntaxNode _attributes;

    internal MarkupTagHelperStartTagSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken OpenAngle => new SyntaxToken(this, ((InternalSyntax.MarkupTagHelperStartTagSyntax)Green)._openAngle, Position, 0);
    public override SyntaxToken Bang
    {
        get
        {
            var slot = ((InternalSyntax.MarkupTagHelperStartTagSyntax)Green).Bang;
            return slot != null ? new SyntaxToken(this, slot, GetChildPosition(1), GetChildIndex(1)) : default;
        }
    }
    public override SyntaxToken Name => new SyntaxToken(this, ((InternalSyntax.MarkupTagHelperStartTagSyntax)Green)._name, GetChildPosition(2), GetChildIndex(2));
    public override SyntaxList<RazorSyntaxNode> Attributes  => new SyntaxList<RazorSyntaxNode>(GetRed(ref _attributes, 3));
    public override SyntaxToken ForwardSlash
    {
        get
        {
            var slot = ((InternalSyntax.MarkupTagHelperStartTagSyntax)Green).ForwardSlash;
            return slot != null ? new SyntaxToken(this, slot, GetChildPosition(4), GetChildIndex(4)) : default;
        }
    }
    public override SyntaxToken CloseAngle => new SyntaxToken(this, ((InternalSyntax.MarkupTagHelperStartTagSyntax)Green)._closeAngle, GetChildPosition(5), GetChildIndex(5));
    public override ISpanChunkGenerator ChunkGenerator => ((InternalSyntax.MarkupTagHelperStartTagSyntax)Green).ChunkGenerator;

    internal override SyntaxNode GetNodeSlot(int index) => index == 3 ? GetRed(ref this._attributes, 3) : null;

    internal override SyntaxNode GetCachedSlot(int index) => index == 3 ? this._attributes : null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupTagHelperStartTag(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupTagHelperStartTag(this);

    public MarkupTagHelperStartTagSyntax Update(SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, SyntaxList<RazorSyntaxNode> attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle != OpenAngle || bang != Bang || name != Name || attributes != Attributes || forwardSlash != ForwardSlash || closeAngle != CloseAngle || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.MarkupTagHelperStartTag(openAngle, bang, name, attributes, forwardSlash, closeAngle, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    internal override BaseMarkupStartTagSyntax WithOpenAngleCore(SyntaxToken openAngle) => WithOpenAngle(openAngle);
    public new MarkupTagHelperStartTagSyntax WithOpenAngle(SyntaxToken openAngle) => Update(openAngle, Bang, Name, Attributes, ForwardSlash, CloseAngle, ChunkGenerator);
    internal override BaseMarkupStartTagSyntax WithBangCore(SyntaxToken bang) => WithBang(bang);
    public new MarkupTagHelperStartTagSyntax WithBang(SyntaxToken bang) => Update(OpenAngle, bang, Name, Attributes, ForwardSlash, CloseAngle, ChunkGenerator);
    internal override BaseMarkupStartTagSyntax WithNameCore(SyntaxToken name) => WithName(name);
    public new MarkupTagHelperStartTagSyntax WithName(SyntaxToken name) => Update(OpenAngle, Bang, name, Attributes, ForwardSlash, CloseAngle, ChunkGenerator);
    internal override BaseMarkupStartTagSyntax WithAttributesCore(SyntaxList<RazorSyntaxNode> attributes) => WithAttributes(attributes);
    public new MarkupTagHelperStartTagSyntax WithAttributes(SyntaxList<RazorSyntaxNode> attributes) => Update(OpenAngle, Bang, Name, attributes, ForwardSlash, CloseAngle, ChunkGenerator);
    internal override BaseMarkupStartTagSyntax WithForwardSlashCore(SyntaxToken forwardSlash) => WithForwardSlash(forwardSlash);
    public new MarkupTagHelperStartTagSyntax WithForwardSlash(SyntaxToken forwardSlash) => Update(OpenAngle, Bang, Name, Attributes, forwardSlash, CloseAngle, ChunkGenerator);
    internal override BaseMarkupStartTagSyntax WithCloseAngleCore(SyntaxToken closeAngle) => WithCloseAngle(closeAngle);
    public new MarkupTagHelperStartTagSyntax WithCloseAngle(SyntaxToken closeAngle) => Update(OpenAngle, Bang, Name, Attributes, ForwardSlash, closeAngle, ChunkGenerator);
    public MarkupTagHelperStartTagSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator) => Update(OpenAngle, Bang, Name, Attributes, ForwardSlash, CloseAngle, chunkGenerator);
    internal override BaseMarkupStartTagSyntax AddAttributesCore(params RazorSyntaxNode[] items) => AddAttributes(items);

    public new MarkupTagHelperStartTagSyntax AddAttributes(params RazorSyntaxNode[] items) => WithAttributes(this.Attributes.AddRange(items));
}

internal sealed partial class MarkupTagHelperEndTagSyntax : BaseMarkupEndTagSyntax
{
    private MarkupMiscAttributeContentSyntax _miscAttributeContent;

    internal MarkupTagHelperEndTagSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxToken OpenAngle => new SyntaxToken(this, ((InternalSyntax.MarkupTagHelperEndTagSyntax)Green)._openAngle, Position, 0);
    public override SyntaxToken ForwardSlash => new SyntaxToken(this, ((InternalSyntax.MarkupTagHelperEndTagSyntax)Green)._forwardSlash, GetChildPosition(1), GetChildIndex(1));
    public override SyntaxToken Bang
    {
        get
        {
            var slot = ((InternalSyntax.MarkupTagHelperEndTagSyntax)Green).Bang;
            return slot != null ? new SyntaxToken(this, slot, GetChildPosition(2), GetChildIndex(2)) : default;
        }
    }
    public override SyntaxToken Name => new SyntaxToken(this, ((InternalSyntax.MarkupTagHelperEndTagSyntax)Green)._name, GetChildPosition(3), GetChildIndex(3));
    public override MarkupMiscAttributeContentSyntax MiscAttributeContent  => GetRed(ref _miscAttributeContent, 4);
    public override SyntaxToken CloseAngle => new SyntaxToken(this, ((InternalSyntax.MarkupTagHelperEndTagSyntax)Green)._closeAngle, GetChildPosition(5), GetChildIndex(5));
    public override ISpanChunkGenerator ChunkGenerator => ((InternalSyntax.MarkupTagHelperEndTagSyntax)Green).ChunkGenerator;

    internal override SyntaxNode GetNodeSlot(int index) => index == 4 ? GetRed(ref this._miscAttributeContent, 4) : null;

    internal override SyntaxNode GetCachedSlot(int index) => index == 4 ? this._miscAttributeContent : null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupTagHelperEndTag(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupTagHelperEndTag(this);

    public MarkupTagHelperEndTagSyntax Update(SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle != OpenAngle || forwardSlash != ForwardSlash || bang != Bang || name != Name || miscAttributeContent != MiscAttributeContent || closeAngle != CloseAngle || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.MarkupTagHelperEndTag(openAngle, forwardSlash, bang, name, miscAttributeContent, closeAngle, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    internal override BaseMarkupEndTagSyntax WithOpenAngleCore(SyntaxToken openAngle) => WithOpenAngle(openAngle);
    public new MarkupTagHelperEndTagSyntax WithOpenAngle(SyntaxToken openAngle) => Update(openAngle, ForwardSlash, Bang, Name, MiscAttributeContent, CloseAngle, ChunkGenerator);
    internal override BaseMarkupEndTagSyntax WithForwardSlashCore(SyntaxToken forwardSlash) => WithForwardSlash(forwardSlash);
    public new MarkupTagHelperEndTagSyntax WithForwardSlash(SyntaxToken forwardSlash) => Update(OpenAngle, forwardSlash, Bang, Name, MiscAttributeContent, CloseAngle, ChunkGenerator);
    internal override BaseMarkupEndTagSyntax WithBangCore(SyntaxToken bang) => WithBang(bang);
    public new MarkupTagHelperEndTagSyntax WithBang(SyntaxToken bang) => Update(OpenAngle, ForwardSlash, bang, Name, MiscAttributeContent, CloseAngle, ChunkGenerator);
    internal override BaseMarkupEndTagSyntax WithNameCore(SyntaxToken name) => WithName(name);
    public new MarkupTagHelperEndTagSyntax WithName(SyntaxToken name) => Update(OpenAngle, ForwardSlash, Bang, name, MiscAttributeContent, CloseAngle, ChunkGenerator);
    internal override BaseMarkupEndTagSyntax WithMiscAttributeContentCore(MarkupMiscAttributeContentSyntax miscAttributeContent) => WithMiscAttributeContent(miscAttributeContent);
    public new MarkupTagHelperEndTagSyntax WithMiscAttributeContent(MarkupMiscAttributeContentSyntax miscAttributeContent) => Update(OpenAngle, ForwardSlash, Bang, Name, miscAttributeContent, CloseAngle, ChunkGenerator);
    internal override BaseMarkupEndTagSyntax WithCloseAngleCore(SyntaxToken closeAngle) => WithCloseAngle(closeAngle);
    public new MarkupTagHelperEndTagSyntax WithCloseAngle(SyntaxToken closeAngle) => Update(OpenAngle, ForwardSlash, Bang, Name, MiscAttributeContent, closeAngle, ChunkGenerator);
    public MarkupTagHelperEndTagSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator) => Update(OpenAngle, ForwardSlash, Bang, Name, MiscAttributeContent, CloseAngle, chunkGenerator);
    internal override BaseMarkupEndTagSyntax AddMiscAttributeContentChildrenCore(params RazorSyntaxNode[] items) => AddMiscAttributeContentChildren(items);

    public new MarkupTagHelperEndTagSyntax AddMiscAttributeContentChildren(params RazorSyntaxNode[] items)
    {
        var _miscAttributeContent = this.MiscAttributeContent ?? SyntaxFactory.MarkupMiscAttributeContent();
        return this.WithMiscAttributeContent(_miscAttributeContent.WithChildren(_miscAttributeContent.Children.AddRange(items)));
    }
}

internal sealed partial class MarkupTagHelperAttributeSyntax : MarkupSyntaxNode
{
    private MarkupTextLiteralSyntax _namePrefix;
    private MarkupTextLiteralSyntax _name;
    private MarkupTextLiteralSyntax _nameSuffix;
    private MarkupTextLiteralSyntax _valuePrefix;
    private MarkupTagHelperAttributeValueSyntax _value;
    private MarkupTextLiteralSyntax _valueSuffix;

    internal MarkupTagHelperAttributeSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTextLiteralSyntax NamePrefix  => GetRedAtZero(ref _namePrefix);
    public MarkupTextLiteralSyntax Name  => GetRed(ref _name, 1);
    public MarkupTextLiteralSyntax NameSuffix  => GetRed(ref _nameSuffix, 2);
    public SyntaxToken EqualsToken => new SyntaxToken(this, ((InternalSyntax.MarkupTagHelperAttributeSyntax)Green)._equalsToken, GetChildPosition(3), GetChildIndex(3));
    public MarkupTextLiteralSyntax ValuePrefix  => GetRed(ref _valuePrefix, 4);
    public MarkupTagHelperAttributeValueSyntax Value  => GetRed(ref _value, 5);
    public MarkupTextLiteralSyntax ValueSuffix  => GetRed(ref _valueSuffix, 6);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _namePrefix),
            1 => GetRed(ref _name, 1),
            2 => GetRed(ref _nameSuffix, 2),
            4 => GetRed(ref _valuePrefix, 4),
            5 => GetRed(ref _value, 5),
            6 => GetRed(ref _valueSuffix, 6),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._namePrefix,
            1 => this._name,
            2 => this._nameSuffix,
            4 => this._valuePrefix,
            5 => this._value,
            6 => this._valueSuffix,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupTagHelperAttribute(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupTagHelperAttribute(this);

    public MarkupTagHelperAttributeSyntax Update(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        if (namePrefix != NamePrefix || name != Name || nameSuffix != NameSuffix || equalsToken != EqualsToken || valuePrefix != ValuePrefix || value != Value || valueSuffix != ValueSuffix)
        {
            var newNode = SyntaxFactory.MarkupTagHelperAttribute(namePrefix, name, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public MarkupTagHelperAttributeSyntax WithNamePrefix(MarkupTextLiteralSyntax namePrefix) => Update(namePrefix, Name, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    public MarkupTagHelperAttributeSyntax WithName(MarkupTextLiteralSyntax name) => Update(NamePrefix, name, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    public MarkupTagHelperAttributeSyntax WithNameSuffix(MarkupTextLiteralSyntax nameSuffix) => Update(NamePrefix, Name, nameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    public MarkupTagHelperAttributeSyntax WithEqualsToken(SyntaxToken equalsToken) => Update(NamePrefix, Name, NameSuffix, equalsToken, ValuePrefix, Value, ValueSuffix);
    public MarkupTagHelperAttributeSyntax WithValuePrefix(MarkupTextLiteralSyntax valuePrefix) => Update(NamePrefix, Name, NameSuffix, EqualsToken, valuePrefix, Value, ValueSuffix);
    public MarkupTagHelperAttributeSyntax WithValue(MarkupTagHelperAttributeValueSyntax value) => Update(NamePrefix, Name, NameSuffix, EqualsToken, ValuePrefix, value, ValueSuffix);
    public MarkupTagHelperAttributeSyntax WithValueSuffix(MarkupTextLiteralSyntax valueSuffix) => Update(NamePrefix, Name, NameSuffix, EqualsToken, ValuePrefix, Value, valueSuffix);

    public MarkupTagHelperAttributeSyntax AddNameLiteralTokens(params SyntaxToken[] items) => WithName(this.Name.WithLiteralTokens(this.Name.LiteralTokens.AddRange(items)));

    public MarkupTagHelperAttributeSyntax AddValueChildren(params RazorSyntaxNode[] items) => WithValue(this.Value.WithChildren(this.Value.Children.AddRange(items)));
}

internal sealed partial class MarkupMinimizedTagHelperAttributeSyntax : MarkupSyntaxNode
{
    private MarkupTextLiteralSyntax _namePrefix;
    private MarkupTextLiteralSyntax _name;

    internal MarkupMinimizedTagHelperAttributeSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTextLiteralSyntax NamePrefix  => GetRedAtZero(ref _namePrefix);
    public MarkupTextLiteralSyntax Name  => GetRed(ref _name, 1);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _namePrefix),
            1 => GetRed(ref _name, 1),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._namePrefix,
            1 => this._name,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupMinimizedTagHelperAttribute(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupMinimizedTagHelperAttribute(this);

    public MarkupMinimizedTagHelperAttributeSyntax Update(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
    {
        if (namePrefix != NamePrefix || name != Name)
        {
            var newNode = SyntaxFactory.MarkupMinimizedTagHelperAttribute(namePrefix, name);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public MarkupMinimizedTagHelperAttributeSyntax WithNamePrefix(MarkupTextLiteralSyntax namePrefix) => Update(namePrefix, Name);
    public MarkupMinimizedTagHelperAttributeSyntax WithName(MarkupTextLiteralSyntax name) => Update(NamePrefix, name);

    public MarkupMinimizedTagHelperAttributeSyntax AddNameLiteralTokens(params SyntaxToken[] items) => WithName(this.Name.WithLiteralTokens(this.Name.LiteralTokens.AddRange(items)));
}

internal sealed partial class MarkupTagHelperAttributeValueSyntax : RazorBlockSyntax
{
    private SyntaxNode _children;

    internal MarkupTagHelperAttributeValueSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<RazorSyntaxNode> Children  => new SyntaxList<RazorSyntaxNode>(GetRed(ref _children, 0));

    internal override SyntaxNode GetNodeSlot(int index) => index == 0 ? GetRedAtZero(ref this._children) : null;

    internal override SyntaxNode GetCachedSlot(int index) => index == 0 ? this._children : null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupTagHelperAttributeValue(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupTagHelperAttributeValue(this);

    public MarkupTagHelperAttributeValueSyntax Update(SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.MarkupTagHelperAttributeValue(children);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    internal override RazorBlockSyntax WithChildrenCore(SyntaxList<RazorSyntaxNode> children) => WithChildren(children);
    public new MarkupTagHelperAttributeValueSyntax WithChildren(SyntaxList<RazorSyntaxNode> children) => Update(children);
    internal override RazorBlockSyntax AddChildrenCore(params RazorSyntaxNode[] items) => AddChildren(items);

    public new MarkupTagHelperAttributeValueSyntax AddChildren(params RazorSyntaxNode[] items) => WithChildren(this.Children.AddRange(items));
}

internal sealed partial class MarkupTagHelperDirectiveAttributeSyntax : MarkupSyntaxNode
{
    private MarkupTextLiteralSyntax _namePrefix;
    private RazorMetaCodeSyntax _transition;
    private MarkupTextLiteralSyntax _name;
    private RazorMetaCodeSyntax _colon;
    private MarkupTextLiteralSyntax _parameterName;
    private MarkupTextLiteralSyntax _nameSuffix;
    private MarkupTextLiteralSyntax _valuePrefix;
    private MarkupTagHelperAttributeValueSyntax _value;
    private MarkupTextLiteralSyntax _valueSuffix;

    internal MarkupTagHelperDirectiveAttributeSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTextLiteralSyntax NamePrefix  => GetRedAtZero(ref _namePrefix);
    public RazorMetaCodeSyntax Transition  => GetRed(ref _transition, 1);
    public MarkupTextLiteralSyntax Name  => GetRed(ref _name, 2);
    public RazorMetaCodeSyntax Colon  => GetRed(ref _colon, 3);
    public MarkupTextLiteralSyntax ParameterName  => GetRed(ref _parameterName, 4);
    public MarkupTextLiteralSyntax NameSuffix  => GetRed(ref _nameSuffix, 5);
    public SyntaxToken EqualsToken => new SyntaxToken(this, ((InternalSyntax.MarkupTagHelperDirectiveAttributeSyntax)Green)._equalsToken, GetChildPosition(6), GetChildIndex(6));
    public MarkupTextLiteralSyntax ValuePrefix  => GetRed(ref _valuePrefix, 7);
    public MarkupTagHelperAttributeValueSyntax Value  => GetRed(ref _value, 8);
    public MarkupTextLiteralSyntax ValueSuffix  => GetRed(ref _valueSuffix, 9);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _namePrefix),
            1 => GetRed(ref _transition, 1),
            2 => GetRed(ref _name, 2),
            3 => GetRed(ref _colon, 3),
            4 => GetRed(ref _parameterName, 4),
            5 => GetRed(ref _nameSuffix, 5),
            7 => GetRed(ref _valuePrefix, 7),
            8 => GetRed(ref _value, 8),
            9 => GetRed(ref _valueSuffix, 9),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._namePrefix,
            1 => this._transition,
            2 => this._name,
            3 => this._colon,
            4 => this._parameterName,
            5 => this._nameSuffix,
            7 => this._valuePrefix,
            8 => this._value,
            9 => this._valueSuffix,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupTagHelperDirectiveAttribute(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupTagHelperDirectiveAttribute(this);

    public MarkupTagHelperDirectiveAttributeSyntax Update(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        if (namePrefix != NamePrefix || transition != Transition || name != Name || colon != Colon || parameterName != ParameterName || nameSuffix != NameSuffix || equalsToken != EqualsToken || valuePrefix != ValuePrefix || value != Value || valueSuffix != ValueSuffix)
        {
            var newNode = SyntaxFactory.MarkupTagHelperDirectiveAttribute(namePrefix, transition, name, colon, parameterName, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public MarkupTagHelperDirectiveAttributeSyntax WithNamePrefix(MarkupTextLiteralSyntax namePrefix) => Update(namePrefix, Transition, Name, Colon, ParameterName, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    public MarkupTagHelperDirectiveAttributeSyntax WithTransition(RazorMetaCodeSyntax transition) => Update(NamePrefix, transition, Name, Colon, ParameterName, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    public MarkupTagHelperDirectiveAttributeSyntax WithName(MarkupTextLiteralSyntax name) => Update(NamePrefix, Transition, name, Colon, ParameterName, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    public MarkupTagHelperDirectiveAttributeSyntax WithColon(RazorMetaCodeSyntax colon) => Update(NamePrefix, Transition, Name, colon, ParameterName, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    public MarkupTagHelperDirectiveAttributeSyntax WithParameterName(MarkupTextLiteralSyntax parameterName) => Update(NamePrefix, Transition, Name, Colon, parameterName, NameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    public MarkupTagHelperDirectiveAttributeSyntax WithNameSuffix(MarkupTextLiteralSyntax nameSuffix) => Update(NamePrefix, Transition, Name, Colon, ParameterName, nameSuffix, EqualsToken, ValuePrefix, Value, ValueSuffix);
    public MarkupTagHelperDirectiveAttributeSyntax WithEqualsToken(SyntaxToken equalsToken) => Update(NamePrefix, Transition, Name, Colon, ParameterName, NameSuffix, equalsToken, ValuePrefix, Value, ValueSuffix);
    public MarkupTagHelperDirectiveAttributeSyntax WithValuePrefix(MarkupTextLiteralSyntax valuePrefix) => Update(NamePrefix, Transition, Name, Colon, ParameterName, NameSuffix, EqualsToken, valuePrefix, Value, ValueSuffix);
    public MarkupTagHelperDirectiveAttributeSyntax WithValue(MarkupTagHelperAttributeValueSyntax value) => Update(NamePrefix, Transition, Name, Colon, ParameterName, NameSuffix, EqualsToken, ValuePrefix, value, ValueSuffix);
    public MarkupTagHelperDirectiveAttributeSyntax WithValueSuffix(MarkupTextLiteralSyntax valueSuffix) => Update(NamePrefix, Transition, Name, Colon, ParameterName, NameSuffix, EqualsToken, ValuePrefix, Value, valueSuffix);

    public MarkupTagHelperDirectiveAttributeSyntax AddTransitionMetaCode(params SyntaxToken[] items) => WithTransition(this.Transition.WithMetaCode(this.Transition.MetaCode.AddRange(items)));

    public MarkupTagHelperDirectiveAttributeSyntax AddNameLiteralTokens(params SyntaxToken[] items) => WithName(this.Name.WithLiteralTokens(this.Name.LiteralTokens.AddRange(items)));

    public MarkupTagHelperDirectiveAttributeSyntax AddValueChildren(params RazorSyntaxNode[] items) => WithValue(this.Value.WithChildren(this.Value.Children.AddRange(items)));
}

internal sealed partial class MarkupMinimizedTagHelperDirectiveAttributeSyntax : MarkupSyntaxNode
{
    private MarkupTextLiteralSyntax _namePrefix;
    private RazorMetaCodeSyntax _transition;
    private MarkupTextLiteralSyntax _name;
    private RazorMetaCodeSyntax _colon;
    private MarkupTextLiteralSyntax _parameterName;

    internal MarkupMinimizedTagHelperDirectiveAttributeSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public MarkupTextLiteralSyntax NamePrefix  => GetRedAtZero(ref _namePrefix);
    public RazorMetaCodeSyntax Transition  => GetRed(ref _transition, 1);
    public MarkupTextLiteralSyntax Name  => GetRed(ref _name, 2);
    public RazorMetaCodeSyntax Colon  => GetRed(ref _colon, 3);
    public MarkupTextLiteralSyntax ParameterName  => GetRed(ref _parameterName, 4);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _namePrefix),
            1 => GetRed(ref _transition, 1),
            2 => GetRed(ref _name, 2),
            3 => GetRed(ref _colon, 3),
            4 => GetRed(ref _parameterName, 4),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._namePrefix,
            1 => this._transition,
            2 => this._name,
            3 => this._colon,
            4 => this._parameterName,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitMarkupMinimizedTagHelperDirectiveAttribute(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitMarkupMinimizedTagHelperDirectiveAttribute(this);

    public MarkupMinimizedTagHelperDirectiveAttributeSyntax Update(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName)
    {
        if (namePrefix != NamePrefix || transition != Transition || name != Name || colon != Colon || parameterName != ParameterName)
        {
            var newNode = SyntaxFactory.MarkupMinimizedTagHelperDirectiveAttribute(namePrefix, transition, name, colon, parameterName);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public MarkupMinimizedTagHelperDirectiveAttributeSyntax WithNamePrefix(MarkupTextLiteralSyntax namePrefix) => Update(namePrefix, Transition, Name, Colon, ParameterName);
    public MarkupMinimizedTagHelperDirectiveAttributeSyntax WithTransition(RazorMetaCodeSyntax transition) => Update(NamePrefix, transition, Name, Colon, ParameterName);
    public MarkupMinimizedTagHelperDirectiveAttributeSyntax WithName(MarkupTextLiteralSyntax name) => Update(NamePrefix, Transition, name, Colon, ParameterName);
    public MarkupMinimizedTagHelperDirectiveAttributeSyntax WithColon(RazorMetaCodeSyntax colon) => Update(NamePrefix, Transition, Name, colon, ParameterName);
    public MarkupMinimizedTagHelperDirectiveAttributeSyntax WithParameterName(MarkupTextLiteralSyntax parameterName) => Update(NamePrefix, Transition, Name, Colon, parameterName);

    public MarkupMinimizedTagHelperDirectiveAttributeSyntax AddTransitionMetaCode(params SyntaxToken[] items) => WithTransition(this.Transition.WithMetaCode(this.Transition.MetaCode.AddRange(items)));

    public MarkupMinimizedTagHelperDirectiveAttributeSyntax AddNameLiteralTokens(params SyntaxToken[] items) => WithName(this.Name.WithLiteralTokens(this.Name.LiteralTokens.AddRange(items)));
}

internal abstract partial class CSharpSyntaxNode : RazorSyntaxNode
{
    internal CSharpSyntaxNode(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }
}

internal sealed partial class CSharpCodeBlockSyntax : RazorBlockSyntax
{
    private SyntaxNode _children;

    internal CSharpCodeBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<RazorSyntaxNode> Children  => new SyntaxList<RazorSyntaxNode>(GetRed(ref _children, 0));

    internal override SyntaxNode GetNodeSlot(int index) => index == 0 ? GetRedAtZero(ref this._children) : null;

    internal override SyntaxNode GetCachedSlot(int index) => index == 0 ? this._children : null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpCodeBlock(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpCodeBlock(this);

    public CSharpCodeBlockSyntax Update(SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.CSharpCodeBlock(children);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    internal override RazorBlockSyntax WithChildrenCore(SyntaxList<RazorSyntaxNode> children) => WithChildren(children);
    public new CSharpCodeBlockSyntax WithChildren(SyntaxList<RazorSyntaxNode> children) => Update(children);
    internal override RazorBlockSyntax AddChildrenCore(params RazorSyntaxNode[] items) => AddChildren(items);

    public new CSharpCodeBlockSyntax AddChildren(params RazorSyntaxNode[] items) => WithChildren(this.Children.AddRange(items));
}

internal sealed partial class CSharpTransitionSyntax : CSharpSyntaxNode
{
    internal CSharpTransitionSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxToken Transition => new SyntaxToken(this, ((InternalSyntax.CSharpTransitionSyntax)Green)._transition, Position, 0);
    public ISpanChunkGenerator ChunkGenerator => ((InternalSyntax.CSharpTransitionSyntax)Green).ChunkGenerator;

    internal override SyntaxNode GetNodeSlot(int index) => null;

    internal override SyntaxNode GetCachedSlot(int index) => null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpTransition(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpTransition(this);

    public CSharpTransitionSyntax Update(SyntaxToken transition, ISpanChunkGenerator chunkGenerator)
    {
        if (transition != Transition || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.CSharpTransition(transition, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public CSharpTransitionSyntax WithTransition(SyntaxToken transition) => Update(transition, ChunkGenerator);
    public CSharpTransitionSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator) => Update(Transition, chunkGenerator);
}

internal sealed partial class CSharpStatementLiteralSyntax : CSharpSyntaxNode
{
    internal CSharpStatementLiteralSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxTokenList LiteralTokens
    {
         get
        {
            var slot = Green.GetSlot(0);
            return slot != null ? new SyntaxTokenList(this, slot, Position, 0) : default;
        }
    }
    public ISpanChunkGenerator ChunkGenerator => ((InternalSyntax.CSharpStatementLiteralSyntax)Green).ChunkGenerator;

    internal override SyntaxNode GetNodeSlot(int index) => null;

    internal override SyntaxNode GetCachedSlot(int index) => null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpStatementLiteral(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpStatementLiteral(this);

    public CSharpStatementLiteralSyntax Update(SyntaxTokenList literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.CSharpStatementLiteral(literalTokens, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public CSharpStatementLiteralSyntax WithLiteralTokens(SyntaxTokenList literalTokens) => Update(literalTokens, ChunkGenerator);
    public CSharpStatementLiteralSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator) => Update(LiteralTokens, chunkGenerator);

    public CSharpStatementLiteralSyntax AddLiteralTokens(params SyntaxToken[] items) => WithLiteralTokens(this.LiteralTokens.AddRange(items));
}

internal sealed partial class CSharpExpressionLiteralSyntax : CSharpSyntaxNode
{
    internal CSharpExpressionLiteralSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxTokenList LiteralTokens
    {
         get
        {
            var slot = Green.GetSlot(0);
            return slot != null ? new SyntaxTokenList(this, slot, Position, 0) : default;
        }
    }
    public ISpanChunkGenerator ChunkGenerator => ((InternalSyntax.CSharpExpressionLiteralSyntax)Green).ChunkGenerator;

    internal override SyntaxNode GetNodeSlot(int index) => null;

    internal override SyntaxNode GetCachedSlot(int index) => null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpExpressionLiteral(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpExpressionLiteral(this);

    public CSharpExpressionLiteralSyntax Update(SyntaxTokenList literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.CSharpExpressionLiteral(literalTokens, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public CSharpExpressionLiteralSyntax WithLiteralTokens(SyntaxTokenList literalTokens) => Update(literalTokens, ChunkGenerator);
    public CSharpExpressionLiteralSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator) => Update(LiteralTokens, chunkGenerator);

    public CSharpExpressionLiteralSyntax AddLiteralTokens(params SyntaxToken[] items) => WithLiteralTokens(this.LiteralTokens.AddRange(items));
}

internal sealed partial class CSharpEphemeralTextLiteralSyntax : CSharpSyntaxNode
{
    internal CSharpEphemeralTextLiteralSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public SyntaxTokenList LiteralTokens
    {
         get
        {
            var slot = Green.GetSlot(0);
            return slot != null ? new SyntaxTokenList(this, slot, Position, 0) : default;
        }
    }
    public ISpanChunkGenerator ChunkGenerator => ((InternalSyntax.CSharpEphemeralTextLiteralSyntax)Green).ChunkGenerator;

    internal override SyntaxNode GetNodeSlot(int index) => null;

    internal override SyntaxNode GetCachedSlot(int index) => null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpEphemeralTextLiteral(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpEphemeralTextLiteral(this);

    public CSharpEphemeralTextLiteralSyntax Update(SyntaxTokenList literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens || chunkGenerator != ChunkGenerator)
        {
            var newNode = SyntaxFactory.CSharpEphemeralTextLiteral(literalTokens, chunkGenerator);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public CSharpEphemeralTextLiteralSyntax WithLiteralTokens(SyntaxTokenList literalTokens) => Update(literalTokens, ChunkGenerator);
    public CSharpEphemeralTextLiteralSyntax WithChunkGenerator(ISpanChunkGenerator chunkGenerator) => Update(LiteralTokens, chunkGenerator);

    public CSharpEphemeralTextLiteralSyntax AddLiteralTokens(params SyntaxToken[] items) => WithLiteralTokens(this.LiteralTokens.AddRange(items));
}

internal sealed partial class CSharpTemplateBlockSyntax : RazorBlockSyntax
{
    private SyntaxNode _children;

    internal CSharpTemplateBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override SyntaxList<RazorSyntaxNode> Children  => new SyntaxList<RazorSyntaxNode>(GetRed(ref _children, 0));

    internal override SyntaxNode GetNodeSlot(int index) => index == 0 ? GetRedAtZero(ref this._children) : null;

    internal override SyntaxNode GetCachedSlot(int index) => index == 0 ? this._children : null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpTemplateBlock(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpTemplateBlock(this);

    public CSharpTemplateBlockSyntax Update(SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.CSharpTemplateBlock(children);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    internal override RazorBlockSyntax WithChildrenCore(SyntaxList<RazorSyntaxNode> children) => WithChildren(children);
    public new CSharpTemplateBlockSyntax WithChildren(SyntaxList<RazorSyntaxNode> children) => Update(children);
    internal override RazorBlockSyntax AddChildrenCore(params RazorSyntaxNode[] items) => AddChildren(items);

    public new CSharpTemplateBlockSyntax AddChildren(params RazorSyntaxNode[] items) => WithChildren(this.Children.AddRange(items));
}

internal abstract partial class CSharpRazorBlockSyntax : CSharpSyntaxNode
{
    internal CSharpRazorBlockSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public abstract CSharpTransitionSyntax Transition { get; }
    public CSharpRazorBlockSyntax WithTransition(CSharpTransitionSyntax transition) => WithTransitionCore(transition);
    internal abstract CSharpRazorBlockSyntax WithTransitionCore(CSharpTransitionSyntax transition);

    public abstract CSharpSyntaxNode Body { get; }
    public CSharpRazorBlockSyntax WithBody(CSharpSyntaxNode body) => WithBodyCore(body);
    internal abstract CSharpRazorBlockSyntax WithBodyCore(CSharpSyntaxNode body);
}

internal sealed partial class CSharpStatementSyntax : CSharpRazorBlockSyntax
{
    private CSharpTransitionSyntax _transition;
    private CSharpSyntaxNode _body;

    internal CSharpStatementSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override CSharpTransitionSyntax Transition  => GetRedAtZero(ref _transition);
    public override CSharpSyntaxNode Body  => GetRed(ref _body, 1);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _transition),
            1 => GetRed(ref _body, 1),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._transition,
            1 => this._body,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpStatement(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpStatement(this);

    public CSharpStatementSyntax Update(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        if (transition != Transition || body != Body)
        {
            var newNode = SyntaxFactory.CSharpStatement(transition, body);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    internal override CSharpRazorBlockSyntax WithTransitionCore(CSharpTransitionSyntax transition) => WithTransition(transition);
    public new CSharpStatementSyntax WithTransition(CSharpTransitionSyntax transition) => Update(transition, Body);
    internal override CSharpRazorBlockSyntax WithBodyCore(CSharpSyntaxNode body) => WithBody(body);
    public new CSharpStatementSyntax WithBody(CSharpSyntaxNode body) => Update(Transition, body);
}

internal sealed partial class CSharpStatementBodySyntax : CSharpSyntaxNode
{
    private RazorMetaCodeSyntax _openBrace;
    private CSharpCodeBlockSyntax _csharpCode;
    private RazorMetaCodeSyntax _closeBrace;

    internal CSharpStatementBodySyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public RazorMetaCodeSyntax OpenBrace  => GetRedAtZero(ref _openBrace);
    public CSharpCodeBlockSyntax CSharpCode  => GetRed(ref _csharpCode, 1);
    public RazorMetaCodeSyntax CloseBrace  => GetRed(ref _closeBrace, 2);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _openBrace),
            1 => GetRed(ref _csharpCode, 1),
            2 => GetRed(ref _closeBrace, 2),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._openBrace,
            1 => this._csharpCode,
            2 => this._closeBrace,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpStatementBody(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpStatementBody(this);

    public CSharpStatementBodySyntax Update(RazorMetaCodeSyntax openBrace, CSharpCodeBlockSyntax csharpCode, RazorMetaCodeSyntax closeBrace)
    {
        if (openBrace != OpenBrace || csharpCode != CSharpCode || closeBrace != CloseBrace)
        {
            var newNode = SyntaxFactory.CSharpStatementBody(openBrace, csharpCode, closeBrace);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public CSharpStatementBodySyntax WithOpenBrace(RazorMetaCodeSyntax openBrace) => Update(openBrace, CSharpCode, CloseBrace);
    public CSharpStatementBodySyntax WithCSharpCode(CSharpCodeBlockSyntax csharpCode) => Update(OpenBrace, csharpCode, CloseBrace);
    public CSharpStatementBodySyntax WithCloseBrace(RazorMetaCodeSyntax closeBrace) => Update(OpenBrace, CSharpCode, closeBrace);

    public CSharpStatementBodySyntax AddOpenBraceMetaCode(params SyntaxToken[] items) => WithOpenBrace(this.OpenBrace.WithMetaCode(this.OpenBrace.MetaCode.AddRange(items)));

    public CSharpStatementBodySyntax AddCSharpCodeChildren(params RazorSyntaxNode[] items) => WithCSharpCode(this.CSharpCode.WithChildren(this.CSharpCode.Children.AddRange(items)));

    public CSharpStatementBodySyntax AddCloseBraceMetaCode(params SyntaxToken[] items) => WithCloseBrace(this.CloseBrace.WithMetaCode(this.CloseBrace.MetaCode.AddRange(items)));
}

internal sealed partial class CSharpExplicitExpressionSyntax : CSharpRazorBlockSyntax
{
    private CSharpTransitionSyntax _transition;
    private CSharpSyntaxNode _body;

    internal CSharpExplicitExpressionSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override CSharpTransitionSyntax Transition  => GetRedAtZero(ref _transition);
    public override CSharpSyntaxNode Body  => GetRed(ref _body, 1);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _transition),
            1 => GetRed(ref _body, 1),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._transition,
            1 => this._body,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpExplicitExpression(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpExplicitExpression(this);

    public CSharpExplicitExpressionSyntax Update(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        if (transition != Transition || body != Body)
        {
            var newNode = SyntaxFactory.CSharpExplicitExpression(transition, body);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    internal override CSharpRazorBlockSyntax WithTransitionCore(CSharpTransitionSyntax transition) => WithTransition(transition);
    public new CSharpExplicitExpressionSyntax WithTransition(CSharpTransitionSyntax transition) => Update(transition, Body);
    internal override CSharpRazorBlockSyntax WithBodyCore(CSharpSyntaxNode body) => WithBody(body);
    public new CSharpExplicitExpressionSyntax WithBody(CSharpSyntaxNode body) => Update(Transition, body);
}

internal sealed partial class CSharpExplicitExpressionBodySyntax : CSharpSyntaxNode
{
    private RazorMetaCodeSyntax _openParen;
    private CSharpCodeBlockSyntax _csharpCode;
    private RazorMetaCodeSyntax _closeParen;

    internal CSharpExplicitExpressionBodySyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public RazorMetaCodeSyntax OpenParen  => GetRedAtZero(ref _openParen);
    public CSharpCodeBlockSyntax CSharpCode  => GetRed(ref _csharpCode, 1);
    public RazorMetaCodeSyntax CloseParen  => GetRed(ref _closeParen, 2);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _openParen),
            1 => GetRed(ref _csharpCode, 1),
            2 => GetRed(ref _closeParen, 2),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._openParen,
            1 => this._csharpCode,
            2 => this._closeParen,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpExplicitExpressionBody(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpExplicitExpressionBody(this);

    public CSharpExplicitExpressionBodySyntax Update(RazorMetaCodeSyntax openParen, CSharpCodeBlockSyntax csharpCode, RazorMetaCodeSyntax closeParen)
    {
        if (openParen != OpenParen || csharpCode != CSharpCode || closeParen != CloseParen)
        {
            var newNode = SyntaxFactory.CSharpExplicitExpressionBody(openParen, csharpCode, closeParen);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public CSharpExplicitExpressionBodySyntax WithOpenParen(RazorMetaCodeSyntax openParen) => Update(openParen, CSharpCode, CloseParen);
    public CSharpExplicitExpressionBodySyntax WithCSharpCode(CSharpCodeBlockSyntax csharpCode) => Update(OpenParen, csharpCode, CloseParen);
    public CSharpExplicitExpressionBodySyntax WithCloseParen(RazorMetaCodeSyntax closeParen) => Update(OpenParen, CSharpCode, closeParen);

    public CSharpExplicitExpressionBodySyntax AddOpenParenMetaCode(params SyntaxToken[] items) => WithOpenParen(this.OpenParen.WithMetaCode(this.OpenParen.MetaCode.AddRange(items)));

    public CSharpExplicitExpressionBodySyntax AddCSharpCodeChildren(params RazorSyntaxNode[] items) => WithCSharpCode(this.CSharpCode.WithChildren(this.CSharpCode.Children.AddRange(items)));

    public CSharpExplicitExpressionBodySyntax AddCloseParenMetaCode(params SyntaxToken[] items) => WithCloseParen(this.CloseParen.WithMetaCode(this.CloseParen.MetaCode.AddRange(items)));
}

internal sealed partial class CSharpImplicitExpressionSyntax : CSharpRazorBlockSyntax
{
    private CSharpTransitionSyntax _transition;
    private CSharpSyntaxNode _body;

    internal CSharpImplicitExpressionSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override CSharpTransitionSyntax Transition  => GetRedAtZero(ref _transition);
    public override CSharpSyntaxNode Body  => GetRed(ref _body, 1);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _transition),
            1 => GetRed(ref _body, 1),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._transition,
            1 => this._body,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpImplicitExpression(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpImplicitExpression(this);

    public CSharpImplicitExpressionSyntax Update(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        if (transition != Transition || body != Body)
        {
            var newNode = SyntaxFactory.CSharpImplicitExpression(transition, body);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    internal override CSharpRazorBlockSyntax WithTransitionCore(CSharpTransitionSyntax transition) => WithTransition(transition);
    public new CSharpImplicitExpressionSyntax WithTransition(CSharpTransitionSyntax transition) => Update(transition, Body);
    internal override CSharpRazorBlockSyntax WithBodyCore(CSharpSyntaxNode body) => WithBody(body);
    public new CSharpImplicitExpressionSyntax WithBody(CSharpSyntaxNode body) => Update(Transition, body);
}

internal sealed partial class CSharpImplicitExpressionBodySyntax : CSharpSyntaxNode
{
    private CSharpCodeBlockSyntax _csharpCode;

    internal CSharpImplicitExpressionBodySyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public CSharpCodeBlockSyntax CSharpCode  => GetRedAtZero(ref _csharpCode);

    internal override SyntaxNode GetNodeSlot(int index) => index == 0 ? GetRedAtZero(ref this._csharpCode) : null;

    internal override SyntaxNode GetCachedSlot(int index) => index == 0 ? this._csharpCode : null;

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitCSharpImplicitExpressionBody(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitCSharpImplicitExpressionBody(this);

    public CSharpImplicitExpressionBodySyntax Update(CSharpCodeBlockSyntax csharpCode)
    {
        if (csharpCode != CSharpCode)
        {
            var newNode = SyntaxFactory.CSharpImplicitExpressionBody(csharpCode);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public CSharpImplicitExpressionBodySyntax WithCSharpCode(CSharpCodeBlockSyntax csharpCode) => Update(csharpCode);

    public CSharpImplicitExpressionBodySyntax AddCSharpCodeChildren(params RazorSyntaxNode[] items) => WithCSharpCode(this.CSharpCode.WithChildren(this.CSharpCode.Children.AddRange(items)));
}

internal sealed partial class RazorDirectiveSyntax : CSharpRazorBlockSyntax
{
    private CSharpTransitionSyntax _transition;
    private CSharpSyntaxNode _body;

    internal RazorDirectiveSyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public override CSharpTransitionSyntax Transition  => GetRedAtZero(ref _transition);
    public override CSharpSyntaxNode Body  => GetRed(ref _body, 1);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _transition),
            1 => GetRed(ref _body, 1),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._transition,
            1 => this._body,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitRazorDirective(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitRazorDirective(this);

    public RazorDirectiveSyntax Update(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        if (transition != Transition || body != Body)
        {
            var newNode = SyntaxFactory.RazorDirective(transition, body);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    internal override CSharpRazorBlockSyntax WithTransitionCore(CSharpTransitionSyntax transition) => WithTransition(transition);
    public new RazorDirectiveSyntax WithTransition(CSharpTransitionSyntax transition) => Update(transition, Body);
    internal override CSharpRazorBlockSyntax WithBodyCore(CSharpSyntaxNode body) => WithBody(body);
    public new RazorDirectiveSyntax WithBody(CSharpSyntaxNode body) => Update(Transition, body);
}

internal sealed partial class RazorDirectiveBodySyntax : CSharpSyntaxNode
{
    private RazorSyntaxNode _keyword;
    private CSharpCodeBlockSyntax _csharpCode;

    internal RazorDirectiveBodySyntax(GreenNode green, SyntaxNode parent, int position)
        : base(green, parent, position)
    {
    }

    public RazorSyntaxNode Keyword  => GetRedAtZero(ref _keyword);
    public CSharpCodeBlockSyntax CSharpCode  => GetRed(ref _csharpCode, 1);

    internal override SyntaxNode GetNodeSlot(int index)
        => index switch
        {
            0 => GetRedAtZero(ref _keyword),
            1 => GetRed(ref _csharpCode, 1),
            _ => null
        };

    internal override SyntaxNode GetCachedSlot(int index)
        => index switch
        {
            0 => this._keyword,
            1 => this._csharpCode,
            _ => null
        };

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor) => visitor.VisitRazorDirectiveBody(this);
    public override void Accept(SyntaxVisitor visitor) => visitor.VisitRazorDirectiveBody(this);

    public RazorDirectiveBodySyntax Update(RazorSyntaxNode keyword, CSharpCodeBlockSyntax csharpCode)
    {
        if (keyword != Keyword || csharpCode != CSharpCode)
        {
            var newNode = SyntaxFactory.RazorDirectiveBody(keyword, csharpCode);
            var diagnostics = GetDiagnostics();
            if (diagnostics != null && diagnostics.Length > 0)
                newNode = newNode.WithDiagnostics(diagnostics);
            var annotations = GetAnnotations();
            return annotations?.Length > 0 ? newNode.WithAnnotations(annotations) : newNode;
        }

        return this;
    }

    public RazorDirectiveBodySyntax WithKeyword(RazorSyntaxNode keyword) => Update(keyword, CSharpCode);
    public RazorDirectiveBodySyntax WithCSharpCode(CSharpCodeBlockSyntax csharpCode) => Update(Keyword, csharpCode);

    public RazorDirectiveBodySyntax AddCSharpCodeChildren(params RazorSyntaxNode[] items)
    {
        var _csharpCode = this.CSharpCode ?? SyntaxFactory.CSharpCodeBlock();
        return this.WithCSharpCode(_csharpCode.WithChildren(_csharpCode.Children.AddRange(items)));
    }
}
