# Accessibility

This directory contains source files used to build Accessibility.dll, the managed wrapper for COM accessibility interface.

See https://docs.microsoft.com/en-us/dotnet/api/accessibility

Source in this directory is generated by a tool and **should not be modified directly**.

To produce the IL source the following process is used:
1. Use https://aka.ms/tlbimp to generate an assembly for oleacc.dll

```cmd
tlbimp c:\windows\system32\oleacc.dll /out:Accessibility.dll
```

2. Use ildasm to disassemble that assembly.

```cmd
ildasm Accessibility.dll /out=Accessibility.il
```

3. Replace the desktop assembly references with their corresponding .NETCore assemblies (since .NETCore doesn't provide a version of tlbimp.exe yet)
    - replace `[mscorlib]System.Runtime.InteropServices` with `[INTEROP_ASSEMBLY]System.Runtime.InteropServices`
    - replace `[mscorlib]` with `[CORE_ASSEMBLY]`
    - review the diff

4. Add assembly level attributes to the IL
   
