/*
 * Copyright 2010-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.parsing;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/tests-spec/testData/psi")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class ParsingTestSpecGenerated extends AbstractParsingTestSpec {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInPsi() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true, "helpers", "templates");
    }

    @TestMetadata("compiler/tests-spec/testData/psi/linked")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Linked extends AbstractParsingTestSpec {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInLinked() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Constant_literals extends AbstractParsingTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInConstant_literals() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Boolean_literals extends AbstractParsingTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInBoolean_literals() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_1 extends AbstractParsingTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_1() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractParsingTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.1.kt");
                        }

                        @TestMetadata("2.10.kt")
                        public void test2_10() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.10.kt");
                        }

                        @TestMetadata("2.11.kt")
                        public void test2_11() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.11.kt");
                        }

                        @TestMetadata("2.12.kt")
                        public void test2_12() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.12.kt");
                        }

                        @TestMetadata("2.13.kt")
                        public void test2_13() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.13.kt");
                        }

                        @TestMetadata("2.14.kt")
                        public void test2_14() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.14.kt");
                        }

                        @TestMetadata("2.15.kt")
                        public void test2_15() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.15.kt");
                        }

                        @TestMetadata("2.16.kt")
                        public void test2_16() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.16.kt");
                        }

                        @TestMetadata("2.17.kt")
                        public void test2_17() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.17.kt");
                        }

                        @TestMetadata("2.18.kt")
                        public void test2_18() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.18.kt");
                        }

                        @TestMetadata("2.19.kt")
                        public void test2_19() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.19.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.2.kt");
                        }

                        @TestMetadata("2.20.kt")
                        public void test2_20() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.20.kt");
                        }

                        @TestMetadata("2.21.kt")
                        public void test2_21() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.21.kt");
                        }

                        @TestMetadata("2.22.kt")
                        public void test2_22() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.22.kt");
                        }

                        @TestMetadata("2.23.kt")
                        public void test2_23() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.23.kt");
                        }

                        @TestMetadata("2.24.kt")
                        public void test2_24() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.24.kt");
                        }

                        @TestMetadata("2.25.kt")
                        public void test2_25() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.25.kt");
                        }

                        @TestMetadata("2.26.kt")
                        public void test2_26() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.26.kt");
                        }

                        @TestMetadata("2.3.kt")
                        public void test2_3() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.3.kt");
                        }

                        @TestMetadata("2.4.kt")
                        public void test2_4() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.4.kt");
                        }

                        @TestMetadata("2.5.kt")
                        public void test2_5() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.5.kt");
                        }

                        @TestMetadata("2.6.kt")
                        public void test2_6() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.6.kt");
                        }

                        @TestMetadata("2.7.kt")
                        public void test2_7() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.7.kt");
                        }

                        @TestMetadata("2.8.kt")
                        public void test2_8() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.8.kt");
                        }

                        @TestMetadata("2.9.kt")
                        public void test2_9() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg/2.9.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractParsingTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.1.kt");
                        }

                        @TestMetadata("2.10.kt")
                        public void test2_10() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.10.kt");
                        }

                        @TestMetadata("2.11.kt")
                        public void test2_11() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.11.kt");
                        }

                        @TestMetadata("2.12.kt")
                        public void test2_12() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.12.kt");
                        }

                        @TestMetadata("2.13.kt")
                        public void test2_13() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.13.kt");
                        }

                        @TestMetadata("2.14.kt")
                        public void test2_14() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.14.kt");
                        }

                        @TestMetadata("2.15.kt")
                        public void test2_15() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.15.kt");
                        }

                        @TestMetadata("2.16.kt")
                        public void test2_16() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.16.kt");
                        }

                        @TestMetadata("2.17.kt")
                        public void test2_17() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.17.kt");
                        }

                        @TestMetadata("2.18.kt")
                        public void test2_18() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.18.kt");
                        }

                        @TestMetadata("2.19.kt")
                        public void test2_19() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.19.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.2.kt");
                        }

                        @TestMetadata("2.20.kt")
                        public void test2_20() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.20.kt");
                        }

                        @TestMetadata("2.21.kt")
                        public void test2_21() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.21.kt");
                        }

                        @TestMetadata("2.22.kt")
                        public void test2_22() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.22.kt");
                        }

                        @TestMetadata("2.23.kt")
                        public void test2_23() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.23.kt");
                        }

                        @TestMetadata("2.24.kt")
                        public void test2_24() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.24.kt");
                        }

                        @TestMetadata("2.25.kt")
                        public void test2_25() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.25.kt");
                        }

                        @TestMetadata("2.26.kt")
                        public void test2_26() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.26.kt");
                        }

                        @TestMetadata("2.3.kt")
                        public void test2_3() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.3.kt");
                        }

                        @TestMetadata("2.4.kt")
                        public void test2_4() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.4.kt");
                        }

                        @TestMetadata("2.5.kt")
                        public void test2_5() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.5.kt");
                        }

                        @TestMetadata("2.6.kt")
                        public void test2_6() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.6.kt");
                        }

                        @TestMetadata("2.7.kt")
                        public void test2_7() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.7.kt");
                        }

                        @TestMetadata("2.8.kt")
                        public void test2_8() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.8.kt");
                        }

                        @TestMetadata("2.9.kt")
                        public void test2_9() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos/2.9.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/boolean-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Integer_literals extends AbstractParsingTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInteger_literals() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Binary_integer_literals extends AbstractParsingTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInBinary_integer_literals() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractParsingTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractParsingTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals/p-1/neg/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals/p-1/neg/1.2.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals/p-1/neg/2.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractParsingTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals/p-1/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals/p-1/pos/1.3.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals/p-1/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals/p-1/pos/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals/p-1/pos/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals/p-1/pos/2.4.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/binary-integer-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Decimal_integer_literals extends AbstractParsingTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInDecimal_integer_literals() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractParsingTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractParsingTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/neg/1.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractParsingTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/pos/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/pos/2.3.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-2")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_2 extends AbstractParsingTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_2() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-2"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-2/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractParsingTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-2/neg/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-2/neg/1.2.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/decimal-integer-literals/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Hexadecimal_integer_literals extends AbstractParsingTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInHexadecimal_integer_literals() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractParsingTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractParsingTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/1.2.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/2.1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractParsingTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/pos/1.2.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/pos/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/pos/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/pos/2.4.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Long_integer_literals extends AbstractParsingTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInLong_integer_literals() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractParsingTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractParsingTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/neg/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/neg/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/neg/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/neg/1.4.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractParsingTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("1.10.kt")
                            public void test1_10() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/1.10.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/1.4.kt");
                            }

                            @TestMetadata("1.5.kt")
                            public void test1_5() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/1.5.kt");
                            }

                            @TestMetadata("1.6.kt")
                            public void test1_6() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/1.6.kt");
                            }

                            @TestMetadata("1.7.kt")
                            public void test1_7() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/1.7.kt");
                            }

                            @TestMetadata("1.8.kt")
                            public void test1_8() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/1.8.kt");
                            }

                            @TestMetadata("1.9.kt")
                            public void test1_9() throws Exception {
                                runTest("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/1.9.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Real_literals extends AbstractParsingTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInReal_literals() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_1 extends AbstractParsingTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_1() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractParsingTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/neg/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/neg/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/neg/1.3.kt");
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/neg/2.1.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/neg/2.2.kt");
                        }

                        @TestMetadata("2.3.kt")
                        public void test2_3() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/neg/2.3.kt");
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/neg/3.1.kt");
                        }

                        @TestMetadata("3.2.kt")
                        public void test3_2() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/neg/3.2.kt");
                        }

                        @TestMetadata("3.3.kt")
                        public void test3_3() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/neg/3.3.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractParsingTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/pos/1.2.kt");
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/pos/3.1.kt");
                        }

                        @TestMetadata("3.2.kt")
                        public void test3_2() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/pos/3.2.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractParsingTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-2"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-2/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractParsingTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-2/neg/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-2/neg/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-2/neg/1.3.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-2/neg/1.4.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractParsingTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-2/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-2/pos/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-2/pos/1.3.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-2/pos/1.4.kt");
                        }

                        @TestMetadata("1.5.kt")
                        public void test1_5() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-2/pos/1.5.kt");
                        }

                        @TestMetadata("1.6.kt")
                        public void test1_6() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-2/pos/1.6.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_3 extends AbstractParsingTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_3() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractParsingTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/neg/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/neg/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/neg/1.3.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/neg/1.4.kt");
                        }

                        @TestMetadata("1.5.kt")
                        public void test1_5() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/neg/1.5.kt");
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/neg/2.1.kt");
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/neg/3.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractParsingTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/pos/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/pos/1.3.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/pos/1.4.kt");
                        }

                        @TestMetadata("1.5.kt")
                        public void test1_5() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/pos/1.5.kt");
                        }

                        @TestMetadata("1.6.kt")
                        public void test1_6() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/pos/1.6.kt");
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/pos/2.1.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/pos/2.2.kt");
                        }

                        @TestMetadata("2.3.kt")
                        public void test2_3() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/pos/2.3.kt");
                        }

                        @TestMetadata("2.4.kt")
                        public void test2_4() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/pos/2.4.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_4 extends AbstractParsingTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_4() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractParsingTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/neg/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/neg/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/neg/1.3.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/neg/1.4.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractParsingTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/pos/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/pos/1.3.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/pos/1.4.kt");
                        }

                        @TestMetadata("1.5.kt")
                        public void test1_5() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/pos/1.5.kt");
                        }

                        @TestMetadata("1.6.kt")
                        public void test1_6() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/pos/1.6.kt");
                        }

                        @TestMetadata("1.7.kt")
                        public void test1_7() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/pos/1.7.kt");
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/pos/2.1.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/pos/2.2.kt");
                        }

                        @TestMetadata("2.3.kt")
                        public void test2_3() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/pos/2.3.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-6")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_6 extends AbstractParsingTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_6() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-6"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-6/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractParsingTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-6/neg/1.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/constant-literals/real-literals/p-6/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/psi/linked/when-expression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class When_expression extends AbstractParsingTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInWhen_expression() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/when-expression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/tests-spec/testData/psi/linked/when-expression/p-2")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class P_2 extends AbstractParsingTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInP_2() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/when-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/psi/linked/when-expression/p-2/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractParsingTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("3.1.kt")
                    public void test3_1() throws Exception {
                        runTest("compiler/tests-spec/testData/psi/linked/when-expression/p-2/neg/3.1.kt");
                    }

                    @TestMetadata("3.2.kt")
                    public void test3_2() throws Exception {
                        runTest("compiler/tests-spec/testData/psi/linked/when-expression/p-2/neg/3.2.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/when-expression/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/psi/linked/when-expression/p-2/pos")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Pos extends AbstractParsingTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("3.1.kt")
                    public void test3_1() throws Exception {
                        runTest("compiler/tests-spec/testData/psi/linked/when-expression/p-2/pos/3.1.kt");
                    }

                    @TestMetadata("3.2.kt")
                    public void test3_2() throws Exception {
                        runTest("compiler/tests-spec/testData/psi/linked/when-expression/p-2/pos/3.2.kt");
                    }

                    public void testAllFilesPresentInPos() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/when-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/psi/linked/when-expression/p-3")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class P_3 extends AbstractParsingTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInP_3() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/when-expression/p-3"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/psi/linked/when-expression/p-3/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractParsingTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.1.kt")
                    public void test1_1() throws Exception {
                        runTest("compiler/tests-spec/testData/psi/linked/when-expression/p-3/neg/1.1.kt");
                    }

                    @TestMetadata("1.2.kt")
                    public void test1_2() throws Exception {
                        runTest("compiler/tests-spec/testData/psi/linked/when-expression/p-3/neg/1.2.kt");
                    }

                    @TestMetadata("2.1.kt")
                    public void test2_1() throws Exception {
                        runTest("compiler/tests-spec/testData/psi/linked/when-expression/p-3/neg/2.1.kt");
                    }

                    @TestMetadata("2.2.kt")
                    public void test2_2() throws Exception {
                        runTest("compiler/tests-spec/testData/psi/linked/when-expression/p-3/neg/2.2.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/when-expression/p-3/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/psi/linked/when-expression/p-6")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class P_6 extends AbstractParsingTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInP_6() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/when-expression/p-6"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/psi/linked/when-expression/p-6/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractParsingTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.1.kt")
                    public void test1_1() throws Exception {
                        runTest("compiler/tests-spec/testData/psi/linked/when-expression/p-6/neg/1.1.kt");
                    }

                    @TestMetadata("1.2.kt")
                    public void test1_2() throws Exception {
                        runTest("compiler/tests-spec/testData/psi/linked/when-expression/p-6/neg/1.2.kt");
                    }

                    @TestMetadata("1.3.kt")
                    public void test1_3() throws Exception {
                        runTest("compiler/tests-spec/testData/psi/linked/when-expression/p-6/neg/1.3.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/when-expression/p-6/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/psi/linked/when-expression/p-7")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class P_7 extends AbstractParsingTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInP_7() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/when-expression/p-7"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/psi/linked/when-expression/p-7/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractParsingTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doParsingTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.1.kt")
                    public void test1_1() throws Exception {
                        runTest("compiler/tests-spec/testData/psi/linked/when-expression/p-7/neg/1.1.kt");
                    }

                    @TestMetadata("1.2.kt")
                    public void test1_2() throws Exception {
                        runTest("compiler/tests-spec/testData/psi/linked/when-expression/p-7/neg/1.2.kt");
                    }

                    @TestMetadata("3.1.kt")
                    public void test3_1() throws Exception {
                        runTest("compiler/tests-spec/testData/psi/linked/when-expression/p-7/neg/3.1.kt");
                    }

                    @TestMetadata("5.1.kt")
                    public void test5_1() throws Exception {
                        runTest("compiler/tests-spec/testData/psi/linked/when-expression/p-7/neg/5.1.kt");
                    }

                    @TestMetadata("7.1.kt")
                    public void test7_1() throws Exception {
                        runTest("compiler/tests-spec/testData/psi/linked/when-expression/p-7/neg/7.1.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/psi/linked/when-expression/p-7/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }
        }
    }
}
