/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.android.intention;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/android/intention")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class AndroidIntentionTestGenerated extends AbstractAndroidIntentionTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInIntention() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/android/intention"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("idea/testData/android/intention/addActivityToManifest")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddActivityToManifest extends AbstractAndroidIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstract.kt")
        public void testAbstract() throws Exception {
            runTest("idea/testData/android/intention/addActivityToManifest/abstract.kt");
        }

        public void testAllFilesPresentInAddActivityToManifest() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/android/intention/addActivityToManifest"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("alreadyExists.kt")
        public void testAlreadyExists() throws Exception {
            runTest("idea/testData/android/intention/addActivityToManifest/alreadyExists.kt");
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            runTest("idea/testData/android/intention/addActivityToManifest/inner.kt");
        }

        @TestMetadata("insideBody.kt")
        public void testInsideBody() throws Exception {
            runTest("idea/testData/android/intention/addActivityToManifest/insideBody.kt");
        }

        @TestMetadata("local.kt")
        public void testLocal() throws Exception {
            runTest("idea/testData/android/intention/addActivityToManifest/local.kt");
        }

        @TestMetadata("nested.kt")
        public void testNested() throws Exception {
            runTest("idea/testData/android/intention/addActivityToManifest/nested.kt");
        }

        @TestMetadata("notActivity.kt")
        public void testNotActivity() throws Exception {
            runTest("idea/testData/android/intention/addActivityToManifest/notActivity.kt");
        }

        @TestMetadata("private.kt")
        public void testPrivate() throws Exception {
            runTest("idea/testData/android/intention/addActivityToManifest/private.kt");
        }

        @TestMetadata("protected.kt")
        public void testProtected() throws Exception {
            runTest("idea/testData/android/intention/addActivityToManifest/protected.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/android/intention/addActivityToManifest/simple.kt");
        }
    }

    @TestMetadata("idea/testData/android/intention/addBroadcastReceiverToManifest")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddBroadcastReceiverToManifest extends AbstractAndroidIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstract.kt")
        public void testAbstract() throws Exception {
            runTest("idea/testData/android/intention/addBroadcastReceiverToManifest/abstract.kt");
        }

        public void testAllFilesPresentInAddBroadcastReceiverToManifest() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/android/intention/addBroadcastReceiverToManifest"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("alreadyExists.kt")
        public void testAlreadyExists() throws Exception {
            runTest("idea/testData/android/intention/addBroadcastReceiverToManifest/alreadyExists.kt");
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            runTest("idea/testData/android/intention/addBroadcastReceiverToManifest/inner.kt");
        }

        @TestMetadata("insideBody.kt")
        public void testInsideBody() throws Exception {
            runTest("idea/testData/android/intention/addBroadcastReceiverToManifest/insideBody.kt");
        }

        @TestMetadata("local.kt")
        public void testLocal() throws Exception {
            runTest("idea/testData/android/intention/addBroadcastReceiverToManifest/local.kt");
        }

        @TestMetadata("nested.kt")
        public void testNested() throws Exception {
            runTest("idea/testData/android/intention/addBroadcastReceiverToManifest/nested.kt");
        }

        @TestMetadata("notReceiver.kt")
        public void testNotReceiver() throws Exception {
            runTest("idea/testData/android/intention/addBroadcastReceiverToManifest/notReceiver.kt");
        }

        @TestMetadata("private.kt")
        public void testPrivate() throws Exception {
            runTest("idea/testData/android/intention/addBroadcastReceiverToManifest/private.kt");
        }

        @TestMetadata("protected.kt")
        public void testProtected() throws Exception {
            runTest("idea/testData/android/intention/addBroadcastReceiverToManifest/protected.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/android/intention/addBroadcastReceiverToManifest/simple.kt");
        }
    }

    @TestMetadata("idea/testData/android/intention/addServiceToManifest")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddServiceToManifest extends AbstractAndroidIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstract.kt")
        public void testAbstract() throws Exception {
            runTest("idea/testData/android/intention/addServiceToManifest/abstract.kt");
        }

        public void testAllFilesPresentInAddServiceToManifest() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/android/intention/addServiceToManifest"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("alreadyExists.kt")
        public void testAlreadyExists() throws Exception {
            runTest("idea/testData/android/intention/addServiceToManifest/alreadyExists.kt");
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            runTest("idea/testData/android/intention/addServiceToManifest/inner.kt");
        }

        @TestMetadata("insideBody.kt")
        public void testInsideBody() throws Exception {
            runTest("idea/testData/android/intention/addServiceToManifest/insideBody.kt");
        }

        @TestMetadata("local.kt")
        public void testLocal() throws Exception {
            runTest("idea/testData/android/intention/addServiceToManifest/local.kt");
        }

        @TestMetadata("nested.kt")
        public void testNested() throws Exception {
            runTest("idea/testData/android/intention/addServiceToManifest/nested.kt");
        }

        @TestMetadata("notService.kt")
        public void testNotService() throws Exception {
            runTest("idea/testData/android/intention/addServiceToManifest/notService.kt");
        }

        @TestMetadata("private.kt")
        public void testPrivate() throws Exception {
            runTest("idea/testData/android/intention/addServiceToManifest/private.kt");
        }

        @TestMetadata("protected.kt")
        public void testProtected() throws Exception {
            runTest("idea/testData/android/intention/addServiceToManifest/protected.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/android/intention/addServiceToManifest/simple.kt");
        }
    }

    @TestMetadata("idea/testData/android/intention/implementParcelable")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ImplementParcelable extends AbstractAndroidIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInImplementParcelable() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/android/intention/implementParcelable"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("allNullableTypes.kt")
        public void testAllNullableTypes() throws Exception {
            runTest("idea/testData/android/intention/implementParcelable/allNullableTypes.kt");
        }

        @TestMetadata("allTypes.kt")
        public void testAllTypes() throws Exception {
            runTest("idea/testData/android/intention/implementParcelable/allTypes.kt");
        }

        @TestMetadata("alreadyImplemented.kt")
        public void testAlreadyImplemented() throws Exception {
            runTest("idea/testData/android/intention/implementParcelable/alreadyImplemented.kt");
        }

        @TestMetadata("constructorProperties.kt")
        public void testConstructorProperties() throws Exception {
            runTest("idea/testData/android/intention/implementParcelable/constructorProperties.kt");
        }

        @TestMetadata("constructorPropertiesWithParameters.kt")
        public void testConstructorPropertiesWithParameters() throws Exception {
            runTest("idea/testData/android/intention/implementParcelable/constructorPropertiesWithParameters.kt");
        }

        @TestMetadata("missingConstructor.kt")
        public void testMissingConstructor() throws Exception {
            runTest("idea/testData/android/intention/implementParcelable/missingConstructor.kt");
        }

        @TestMetadata("missingDescribeContents.kt")
        public void testMissingDescribeContents() throws Exception {
            runTest("idea/testData/android/intention/implementParcelable/missingDescribeContents.kt");
        }

        @TestMetadata("missingWriteToParcel.kt")
        public void testMissingWriteToParcel() throws Exception {
            runTest("idea/testData/android/intention/implementParcelable/missingWriteToParcel.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/android/intention/implementParcelable/simple.kt");
        }

        @TestMetadata("withTransient.kt")
        public void testWithTransient() throws Exception {
            runTest("idea/testData/android/intention/implementParcelable/withTransient.kt");
        }
    }

    @TestMetadata("idea/testData/android/intention/redoParcelable")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RedoParcelable extends AbstractAndroidIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRedoParcelable() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/android/intention/redoParcelable"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("indirectParcelable.kt")
        public void testIndirectParcelable() throws Exception {
            runTest("idea/testData/android/intention/redoParcelable/indirectParcelable.kt");
        }

        @TestMetadata("init.kt")
        public void testInit() throws Exception {
            runTest("idea/testData/android/intention/redoParcelable/init.kt");
        }

        @TestMetadata("initWithExtraStatements.kt")
        public void testInitWithExtraStatements() throws Exception {
            runTest("idea/testData/android/intention/redoParcelable/initWithExtraStatements.kt");
        }

        @TestMetadata("noParcelable.kt")
        public void testNoParcelable() throws Exception {
            runTest("idea/testData/android/intention/redoParcelable/noParcelable.kt");
        }

        @TestMetadata("oldField.kt")
        public void testOldField() throws Exception {
            runTest("idea/testData/android/intention/redoParcelable/oldField.kt");
        }

        @TestMetadata("oldFieldSecondary.kt")
        public void testOldFieldSecondary() throws Exception {
            runTest("idea/testData/android/intention/redoParcelable/oldFieldSecondary.kt");
        }

        @TestMetadata("parcelize.kt")
        public void testParcelize() throws Exception {
            runTest("idea/testData/android/intention/redoParcelable/parcelize.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/android/intention/redoParcelable/simple.kt");
        }
    }

    @TestMetadata("idea/testData/android/intention/removeParcelable")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveParcelable extends AbstractAndroidIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveParcelable() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/android/intention/removeParcelable"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inderectParcelable.kt")
        public void testInderectParcelable() throws Exception {
            runTest("idea/testData/android/intention/removeParcelable/inderectParcelable.kt");
        }

        @TestMetadata("init.kt")
        public void testInit() throws Exception {
            runTest("idea/testData/android/intention/removeParcelable/init.kt");
        }

        @TestMetadata("initWithExtraStatements.kt")
        public void testInitWithExtraStatements() throws Exception {
            runTest("idea/testData/android/intention/removeParcelable/initWithExtraStatements.kt");
        }

        @TestMetadata("noParcelable.kt")
        public void testNoParcelable() throws Exception {
            runTest("idea/testData/android/intention/removeParcelable/noParcelable.kt");
        }

        @TestMetadata("parcelize.kt")
        public void testParcelize() throws Exception {
            runTest("idea/testData/android/intention/removeParcelable/parcelize.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/android/intention/removeParcelable/simple.kt");
        }
    }
}
