/* Hey EMACS -*- linux-c -*- */
/* $Id$ */

/*  libtifiles - file format library, a part of the TiLP project
 *  Copyright (C) 1999-2005  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/*
  Variable type ID and file extensions
*/

#ifndef DISABLE_TI8X

#include <string.h>
#include "gettext.h"
#include "logging.h"
#include "internal.h"

/* is missing:
   { "VECT",  "73v", "Vector" },
    { "CONST", "73c", "Constant" },
*/

const TIXX_DATA TI73_CONST[TI73_MAXTYPES + 1] =
{
	{"REAL", "73n", "Real", N_("Real")},
	{"LIST", "73l", "List", N_("List")},
	{"MAT", "73m", "Matrix", N_("Matrix")},
	{"EQU", "73e", "Equation", N_("Equation")},
	{"STR", "73s", "String", N_("String")},
	{"PRGM", "73p", "Program", N_("Program")},
	{"ASM", "73p", "Asm Program", N_("Asm Program")},
	{"PIC", "73i", "Picture", N_("Picture")},
	{"GDB", "73d", "GDB", N_("GDB")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"WDW", "73w", "Window Setup", N_("Window Setup")},
	{"CPLX", "73c", "Complex", N_("Complex")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"WINDW", "73w", "Window", N_("Window Setup")},
	{"ZSTO", "73z", "Zoom", N_("Zoom")},
	{"TABLE", "73t", "Table Setup", N_("Table Setup")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"BKUP", "73b", "Backup", N_("Backup")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"DIR", "73?", "Unknown", N_("Unknown")},
	{"AVAR", "73v", "App Var", N_("App Var")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"AMS", "73u", "OS upgrade", N_("OS upgrade")},
	{"APPL", "73k", "Application", N_("Application")},
	{"CERT", "73q", "Certificate", N_("Certificate")},
	{"IDLIST", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{"", "73?", "Unknown", N_("Unknown")},
	{NULL, NULL, NULL, NULL}
};

const TIXX_DATA TI82_CONST[TI82_MAXTYPES + 1] =
{
	{"REAL", "82n", "Real", N_("Real")},
	{"LIST", "82l", "List", N_("List")},
	{"MAT", "82m", "Matrix", N_("Matrix")},
	{"YVAR", "82y", "Y-Var", N_("Y-Var")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"PRGM", "82p", "Program", N_("Program")},
	{"PPGM", "82p", "Protected Program", N_("Protected Program")},
	{"PIC", "82i", "Picture", N_("Picture")},
	{"GDB", "82d", "GDB", N_("GDB")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"WINDW", "82w", "Window Setup", N_("Window Setup")},
	{"ZSTO", "82z", "Zoom", N_("Zoom")},
	{"TABLE", "82t", "Table Setup", N_("Table Setup")},
	{"LCD", "82?", "LCD", N_("LCD")},
	{"BKUP", "82b", "Backup", N_("Backup")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{"", "82?", "Unknown", N_("Unknown")},
	{NULL, NULL, NULL, NULL}
};

const TIXX_DATA TI83_CONST[TI83_MAXTYPES + 1] =
{
	{"REAL", "83n", "Real", N_("Real")},
	{"LIST", "83l", "List", N_("List")},
	{"MAT", "83m", "Matrix", N_("Matrix")},
	{"YVAR", "83y", "Y-Var", N_("Y-Var")},
	{"STR", "83s", "String", N_("String")},
	{"PRGM", "83p", "Program", N_("Program")},
	{"ASM", "83p", "Asm Program", N_("Asm Program")},
	{"PIC", "83i", "Picture", N_("Picture")},
	{"GDB", "83d", "GDB", N_("GDB")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"CPLX", "83c", "Complex", N_("Complex")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"WINDW", "83w", "Window", N_("Window Setup")},
	{"ZSTO", "83z", "Zoom", N_("Zoom")},
	{"TABLE", "83t", "Table Setup", N_("Table Setup")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"BKUP", "83b", "Backup", N_("Backup")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"DIR", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{"", "83?", "Unknown", N_("Unknown")},
	{NULL, NULL, NULL, NULL}
};

const TIXX_DATA TI85_CONST[TI85_MAXTYPES + 1] =
{
	{"REAL", "85n", "Real", N_("Real")},
	{"CPLX", "85c", "Complex", N_("Complex")},
	{"VECT", "85v", "Vector", N_("Vector")},
	{"CVECT", "85v", "Complex Vector", N_("Complex Vector")},
	{"LIST", "85l", "List", N_("List")},
	{"CLIST", "85l", "Complex List", N_("Complex List")},
	{"MAT", "85m", "Matrix", N_("Matrix")},
	{"CMAT", "85m", "Complex Matrix", N_("Complex Matrix")},
	{"CONS", "85k", "Constant", N_("Constant")},
	{"CCONS", "85c", "Complex Constant", N_("Complex Constant")},
	{"EQU", "85y", "Equation", N_("Equation")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"STR", "85s", "String", N_("String")},
	{"GDB", "85d", "GDB", N_("GDB")},
	{"GDB", "85d", "GDB", N_("GDB")},
	{"GDB", "85d", "GDB", N_("GDB")},
	{"GDB", "85d", "GDB", N_("GDB")},
	{"PIC", "85i", "Picture", N_("Picture")},
	{"PRGM", "85p", "Program", N_("Program")},
	{"RANGE", "85r", "Range", N_("Range")},
	{"SCRN", "85?", "Screen", N_("Screen")},
	{"DIR", "85?", "Directory", N_("Directory")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"WND", "85w", "Window Setup", N_("Window Setup")},
	{"POLAR", "85?", "Polar", N_("Polar")},
	{"PARAM", "85?", "Parametric", N_("Parametric")},
	{"DIFEQ", "85?", "Diff Equ", N_("Diff Equ")},
	{"ZRCL", "85z", "Zoom", N_("Zoom")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"BKUP", "85b", "Backup", N_("Backup")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"YVAR", "85y", "Y-Var", N_("Y-Var")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"", "85?", "Unknown", N_("Unknown")},
	{"", "85?", "Unknown", N_("Unknown")},
	{NULL, NULL, NULL, NULL},
};

const TIXX_DATA TI86_CONST[TI86_MAXTYPES + 1] =
{
	{"REAL", "86n", "Real", N_("Real")},
	{"CPLX", "86c", "Complex", N_("Complex")},
	{"VECT", "86v", "Vector", N_("Vector")},
	{"CVECT", "86v", "Complex Vector", N_("Complex Vector")},
	{"LIST", "86l", "List", N_("List")},
	{"CLIST", "86l", "Complex List", N_("Complex List")},
	{"MAT", "86m", "Matrix", N_("Matrix")},
	{"CMAT", "86m", "Complex Matrix", N_("Complex Matrix")},
	{"CONS", "86k", "Constant", N_("Constant")},
	{"CCONS", "86k", "Complex Constant", N_("Complex Constant")},
	{"EQU", "86y", "Equation", N_("Equation")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"STR", "86s", "String", N_("String")},
	{"GDB", "86d", "GDB", N_("GDB")},
	{"GDB", "86d", "GDB", N_("GDB")},
	{"GDB", "86d", "GDB", N_("GDB")},
	{"GDB", "86d", "GDB", N_("GDB")},
	{"PIC", "86i", "Picture", N_("Picture")},
	{"PRGM", "86p", "Program", N_("Program")},
	{"RANGE", "86r", "Range", N_("Range")},
	{"SCRN", "86?", "Screen", N_("Screen")},
	{"DIR", "86?", "Directory", N_("Directory")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"WIND", "86w", "Func", N_("Window Setup")},
	{"WIND", "86w", "Pol", N_("Window Setup")},
	{"WIND", "86w", "Param", N_("Window Setup")},
	{"WIND", "86w", "DifEq", N_("Window Setup")},
	{"WIND", "86w", "ZRCL", N_("Window Setup")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"BKUP", "86b", "Backup", N_("Backup")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{"", "86?", "Unknown", N_("Unknown")},
	{NULL, NULL, NULL, NULL},
};

#endif
