/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                           avtPLOT3DOptions.C                              //
// ************************************************************************* //

#include <avtPLOT3DOptions.h>

#include <DBOptionsAttributes.h>

#include <string>
#include <vector>
using std::vector;
using std::string;


// ****************************************************************************
//  Function: GetPLOT3DReadOptions
//
//  Purpose:
//      Creates the options for PLOT3D readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: biagas2 -- generated by xml2avt
//  Creation:   Tue Aug 19 20:12:37 PST 2014
//
//  Modifications:
//    Kathleen Biagas, Thu Aug 27 12:50:44 PDT 2015
//    Changed order.  Added 'Fortran binary stream' File Format option (which
//    indicates non-record based fortran binary files).  Added options for
//    Gas constants R and Gamma, used in function calculations.
//
// ****************************************************************************

DBOptionsAttributes *
GetPLOT3DReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;

    rv->SetEnum("File Format", 1);
    vector<string> ff;
    ff.push_back("ASCII");
    ff.push_back("C Binary");
    ff.push_back("Fortran binary");
    ff.push_back("Fortran binary stream");
    rv->SetEnumStrings("File Format", ff);

    rv->SetString("Solution (Q) File Name", "");
    rv->SetBool("Solution Time field accurate", true);

    rv->SetBool("3D", true);
    rv->SetBool("Multi Grid", false);
    rv->SetBool("Big Endian", true);
    rv->SetBool("Double Precision", false);
    rv->SetBool("IBlanking", false);

    rv->SetDouble("Gas constant R", 1.0);
    rv->SetDouble("Gas constant Gamma", 1.4);
    return rv;
}


// ****************************************************************************
//  Function: GetPLOT3DWriteOptions
//
//  Purpose:
//      Creates the options for PLOT3D writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: biagas2 -- generated by xml2avt
//  Creation:   Tue Aug 19 20:12:37 PST 2014
//
// ****************************************************************************

DBOptionsAttributes *
GetPLOT3DWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
