<?php
/**
*
* help_bbcode [Bulgarian]
*
* @package language
* @version $Id: help_bbcode.php 9461 2009-04-17 15:23:17Z nacholibre $
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$help = array(
	array(
		0 => '--',
		1 => 'Въведение'
	),
	array(
		0 => 'Какво е BBCode?',
		1 => 'BBCode е специална имплементация на HTML. Дали можете да ползвате BBCode във вашите съобщения или не се определя от администраторите. Освен това, можете да изключите BBCode за дадено съобщение от формата за писане на съобщения. BBCode прилича много на HTML, използват се тагове, които са затворени в квадратни скоби (ето така: [таг]), а не в &lt; и &gt;. Освен това BBCode предлага по-голям контрол над стила на това какво и как с е показва. В зависимост от Темата на форума, е възможно да има прост интерфейс за добавяне на BBCode в вашите съобщения (като например в subSilver). Въпреки това, ако се имате проблем с BBCode, това упътване ще ви бъде полезно.'
	),
	array(
		0 => '--',
		1 => 'Форматиране на текст'
	),
	array(
		0 => 'Как да направя удебелен, наклонен и подчертан текст?',

        1 => 'BBCode включва тагове, които позволяват бързо и лесно да промените стила на текста.
        Това става по следните начини: <ul><li>За да направите текста удебелен го сложете м/у <strong>[b][/b]</strong>, например <br /><br /><strong>[b]</strong>Здрасти<strong>[/b]</strong><br /><br />ще стане <strong>Здрасти</strong></li>
        <li>За подчертаване използвайте <strong>[u][/u]</strong>, например:<br /><br /><strong>[u]</strong>Добро утро<strong>[/u]</strong><br /><br />става <span style="text-decoration: underline">Добро утро</span></li>
        <li>За да наклоните използвайте <strong>[i][/i]</strong>, например:<br /><br />Това е <strong>[i]</strong>Прекрасно!<strong>[/i]</strong><br /><br />ще стане Това е <i>Прекрасно!</i></li></ul>'
	),
	array(
		0 => 'Как да променя цвета или размера на текста?',
		1 => 'За да промените цвета или размера на текста, ползвайте един от описаните по-долу тагове. Имайте предвид, че цвета и размера на текста зависят от браузъра и системата на потребителя.<ul><li>За да смените цвета на текст, ползвайте <strong>[color=][/color]</strong>. Можете да или да напишете името на цвета (например червено, синьо, жълто, т.н.), или да въведете цвета като шестнадесетична стойност (напр. #FFFFFF, #000000). Пример: за да направите червен текст, можете да ползвате:<br /><br /><strong>[color=red]</strong>Здрасти!<strong>[/color]</strong><br /><br />или<br /><br /><strong>[color=#FF0000]</strong>Здрасти!<strong>[/color]</strong><br /><br />И двете ще покажат <span style="color:red">Hello!</span></li><li>Промяната на размера на текста става по подобен начин, с помощта на <strong>[size=][/size]</strong>. Този таг зависи от Темата, която ползва форума, но е препоръчително да използвате цифри, представящи размера на текста в пиксели, започващи от 1 (толкова малък текст, че няма да се вижда) до 29 (огромен текст). Пример: <br /><br /><strong>[size=9]</strong>МАЛЪК<strong>[/size]</strong><br /><br /> ще се показва като <span style="font-size:30%;">МАЛЪК</span><br /><br />докато <br /><br /><strong>[size=24]</strong>ОГРОМЕН!<strong>[/size]</strong><br /><br />ще е <span style="font-size:200%;">ОГРОМЕН!</span></li></ul>'
	),
	array(
		0 => 'Мога ли да комбинирам форматиращи тагове?',
		1 => 'Да, разбира се, че можете. Например, за да привлечете вниманието на някой, можете да напишете:<br /><br /><strong>[size=18][color=red][b]</strong>ВИЖ МЕ МЕ!<strong>[/b][/color][/size]</strong><br /><br />което би се показало като <span style="color:red;font-size:200%;"><strong>ПОГЛЕДНИ МЕ!</strong></span><br /><br />Въпреки това, не препоръчваме прекомерната употреба на форматиращите тагове. Запомнете, вие трябва да се уверите дали таговете са затворени правилно, не форума. Например, следния ред е неправилен:<br /><br /><strong>[b][u]</strong>Това е грешно!<strong>[/b][/u]</strong>'
	),
	array(
		0 => '--',
		1 => 'Цитати и Код'
	),
	array(
		0 => 'Как да цитирам в отговор на съобщение',
		1 => 'Има два начина за създаване на цитати - със и без автор.<ul><li>Когато използвате Отговор с цитат на форума, ще забележите, че текста на съобщението, на което отговаряте се добавя към вашето съобщение и е заграден в таговете <strong>[quote=\"\"][/quote]</strong>. Този метод позволява да цитирате, като посочвате автора на цитата. Например, ако искате да цитирате Иван, би трябвало да напишете:<br /><br /><strong>[quote=\"Иван\"]</strong>Тук поставете текста, който Иван е написал<strong>[/quote]</strong><br /><br />В резултат над цитирания блок ще се показва <strong>Иван написа:</strong>. Не забравяйте да поставите името на автора в кавички (ето така: \"Иван\")!</li><li>Втория метод позволява да правите цитати без да посочвате автора. За да цитирате по този начин, просто затворете текста в таговете <strong>[quote][/quote]</strong>. В резултат над цитирания блок ще се показва само <strong>Цитат:</strong>.</li></ul>'
	),
	array(
		0 => 'Как да поставя код или друг текст с фиксирана ширина в съобщението си?',
		1 => 'Ако искате да прибавите програмен код или друг текст, изискващ фиксирана ширина в съобщението си, трябва да затворите текста в таговете <strong>[code][/code]</strong>, например <br /><br /><strong>[code]</strong>echo \"Това е код\";<strong>[/code]</strong><br /><br />Форматирането, използвано в таговете <strong>[code][/code]</strong> се запазва.'
	),
	array(
		0 => '--',
		1 => 'Списъци'
	),
	array(
		0 => 'Как да направя неподреден списък?',
		1 => 'BBCode поддържа два вида списъци: неподреден и подреден. На практика, те се същите като в HTML. Неподреденият списък показва един под друг редовете на списъка, поставяйки в началото им голяма точка. За да създадете неподреден списък, ползвайте <strong>[list][/list]</strong> и дефинирайте всеки ред от списъка с <strong>[*]</strong>. Например, за да направите списък с любимите си цветове, можете да ползвате следния синтаксис:<br /><br /><strong>[list]</strong><br /><strong>[*]</strong>Червено<br /><strong>[*]</strong>Синьо<br /><strong>[*]</strong>Жълто<br /><strong>[/list]</strong><br /><br />Така ще получите следния списък:<ul><li>Червено</li><li>Синьо</li><li>Жълто</li></ul>'
	),
	array(
		0 => '--',
		1 => '--'
	),
	array(
		0 => 'Как да направя подреден списък?',
        1 => 'Втория вид списък, подредения, ви дава избор какво да бъде поставено в началото на всеки ред.
        За да създадете подреден списък използвайте <strong>[list=1][/list]</strong>, за да създадете номериран списък или азбучен, използвайте <strong>[list=a][/list]</strong> за азбучен.
        При неподреден списък се използва <strong>[*]</strong>. Например:<br /><br /><strong>[list=1]</strong><br /><strong>[*]</strong>Едно<br /><strong>[*]</strong>Две<br /><strong>[*]</strong>Три<br /><strong>[/list]</strong><br /><br />ще генерира:<ol><li>Едно</li><li>Две</li><li>Три</li></ol>
        За азбучен списък използвайте:<br /><br /><strong>[list=a]</strong><br /><strong>[*]</strong>
        Едно<br /><strong>[*]</strong>Две<br /><strong>[*]</strong>Три<br /><strong>[/list]</strong><br /><br />ще се покаже като

        <ol><li>Едно</li><li>Две</li><li>Три</li></ol>'
	),
	array(
		0 => '--',
		1 => 'Връзки'
	),
	array(
		0 => 'Създаване на връзка към друг сайт',
		1 => 'BBCode поддържа няколко различни начина за прилагане на връзки (URL) към съобщенията.<ul><li>Първият от тях използва таговете <strong>[url=]текст[/url]</strong>, като поставяйки връзка след знака = ще превърне текста, затворен в таговете във връзка. Например, за да направите връзка към phpBB.com, можете да напишете: <br /><br /><strong>[url=http://www.phpbb.com/]</strong>Посетете phpBB!<strong>[/url]</strong><br /><br />Това ще генерира следната връзка: <a href=\"http://www.phpbb.com/\" target=\"_blank\">Visit phpBB!</a>. Забележете, че връзката се отваря в нов прозорец, така че потребителят да може необезпокоявано да продължи да разглежда форумите.</li><li>Ако искате да покажете самата връзка, това става просто така:<br /><br /><strong>[url]</strong>http://www.phpbb.com/<strong>[/url]</strong><br /><br />Това ще генерира следната връзка: <a href=\"http://www.phpbb.com/\" target=\"_blank\">http://www.phpbb.com/</a></li><li>Освен това, phpBB съдържа функция, наречена <em>Магически връзки</em>, която автоматично намира правилно въведените URL-та в съобщението ви и ги обръща във действащи връзки. Няма нужда да въвеждате тагове или дори http://. Например, ако напишете www.phpbb.com във вашето съобщение, автоматично ще се генерира връзката <a href=\"http://www.phpbb.com/\" target=\"_blank\">www.phpbb.com</a></li><li>Същото важи и за мейл адресите. Можете да ползвате тагове:<br /><br /><strong>[email]</strong>no.one@domain.adr<strong>[/email]</strong><br /><br />което ще резултира в <a href=\"emailto:no.one@domain.adr\">no.one@domain.adr</a> или можете просто да напишете no.one@domain.adr в съобщението си и адреса автоматично ще бъде конвертиран в мейл-връзка.</li></ul>Както при всички BBCode тагове, можете да наслагвате по няколко едновременно, например <strong>[url][img][/img][/url]</strong> (виж по-долу), <strong>[url][b][/b][/url]</strong>, и т.н.. Запомнете, вие трябва да се уверите дали таговете са затворени правилно, не форума. Например:<br /><br /><strong>[url=http://www.phpbb.com/][img]</strong>http://www.phpbb.com/images/phplogo.gif<strong>[/url][/img]</strong><br /><br />е <u>неправилен</u> синтаксис, който може да доведе до изтриването на съобщението ви от модераторите, така че бъдете внимателни!'
	),
	array(
		0 => '--',
		1 => 'Показване на изображения в съобщенията'
	),
	array(
		0 => 'Как да добавя картинка към съобщението си?',
		1 => 'BBCode включва таг за прибавяне на изображения към съобщения ви. Помнете две много важни неща, свързани с този таг: много потребители не одобряват много или големи картинки в съобщенията, и второ, картинката, която искате да покажете, трябва да се намира в Интернет (не може просто да я имате на компютъра се, трябва да я качите на някой уеб сървър). В текущата версия няма начин да записвате картинките на сървъра на форума (вероятно тази функция ще намери място в следващата версия на phpBB). За да покажете изображение в съобщението си, трябва да затворите URL-то към картинката с тага <strong>[img][/img]</strong>. Пример: <br /><br /><strong>[img]</strong>http://www.google.com/intl/en_ALL/images/logo.gif<strong>[/img]</strong><br /><br />Както казахме в предната секция, можете да затворите тага за картинка с таг за връзка: <strong>[url][/url]</strong> ако желаете. Това изписване<br /><br /><strong>[url=http://www.google.com/][img]</strong>http://www.google.com/intl/en_ALL/images/logo.gif<strong>[/img][/url]</strong><br /><br />ще покаже:<br /><br /><a href="http://www.google.com/"><img src="http://www.google.com/intl/en_ALL/images/logo.gif" alt="" /></a><br />'
	),
	array(
		0 => 'Добавяне на прикачени файлове към мнение',
		1 => 'Прикачените файлове могат да бъдат сложени на различни места в мнението ви като се използва <strong>[attachment=][/attachment]</strong>.'
	),
	array(
		0 => '--',
		1 => 'Други въпроси'
	),
	array(
		0 => 'Мога ли да добавям мои тагове?',
		1 => 'Ако сте администратор на този форум можете да добавяте собствени тагове.'
	)
);
