package Criteria;
our $VERSION = '2003-12-25';
our @ISA = 'BaseObject';

use Classes::BaseObject;

sub new {
	my $proto = shift;
	my @Constructor_Parameters=@_;

	my $class = ref( $proto ) || $proto;

	my $self = bless $proto->SUPER::new( @Constructor_Parameters ), $class;

	#

	$self->{'Table'}			= '';
	$self->{'Field'}			= '';
	$self->{'Operator'}			= '';
	$self->{'Value'}			= '';
	$self->{'IsTemporary'}		= 0;
	$self->{'UsePlaceHolder'}	= 0;

	#

	my %Hashage = @Constructor_Parameters;
	foreach my $Key ( keys %Hashage )
	{
		$self->set( $Key, $Hashage{$Key} );
	}

	return $self;
}

sub get_SQL($)
{
	my $self = shift;

	if ( $self->Table() and $self->Field() )
	{
		my ( $TableType, $Temp ) = split( /\./, $::db_table_type{$self->Table()} );

		if ( $TableType > 1 )
		{
			  # Table name as in the DB :
			my $Table = 'Prelude_'.( $self->Table() );
			  # WHERE, first part (table JOIN) :
			my $Join = $Table.'.';
			if ( $TableType eq 2 ) {$Join .= 'Alert_';};
			if ( $TableType eq 3 ) {$Join .= 'parent_';};
			$Join .= 'ident=Prelude_Alert.ident ';

			if ( $TableType eq 3 ) {$Join .= ' AND '.$Table.'.parent_type=\'A\' ';};

			my $Field = $self->Field();
			$Field =~ s/[^a-z_]//g;

			my $Where = "$Table.$Field";
			my $Op = $self->Operator();
			if ( $Op =~ m/^[!><]?=?$/ ) {$Where .= $Op;};
			if ( $Op =~ m/^(!?)[SCEM]$/ )
			{
				if ( $1 ) {$Where .= ' NOT';};
				$Where .= ' LIKE ';
			}
			if ( ! ( $self->UsePlaceHolder() ) )
			{
				my $Val = $self->Value();
				if ($Op =~ m/^\!?S$/) {$Val.='%';};
				if ($Op =~ m/^\!?C$/) {$Val='%'.$Val.'%';};
				if ($Op =~ m/^\!?E$/) {$Val='%'.$Val;};

				$Where .= $::dbh->quote( $Val );
			}
			else
			{
				$Where .= '?';
			}
			$Where = '('.$Where.')';

			return ( $Table, $Join, $Where )
		}
		else
		{
			print "Not a known table (".($self->Table()).") or TableType<2 ($TableType)\n";
		}
	}
	else
	{
		print STDERR "Table or Field empty\n";
	}
}

1;
