/*
 * Decompiled with CFR 0.152.
 */
package proguard.retrace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import proguard.classfile.util.ClassUtil;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MappingReader;

public class ReTrace
implements MappingProcessor {
    private static final String REGEX_OPTION = "-regex";
    private static final String VERBOSE_OPTION = "-verbose";
    public static final String STACK_TRACE_EXPRESSION = "(?:.*?\\bat\\s+%c.%m\\s*\\(.*?(?::%l)?\\)\\s*)|(?:(?:.*?[:\"]\\s+)?%c(?::.*)?)";
    private static final String REGEX_CLASS = "\\b(?:[A-Za-z0-9_$]+\\.)*[A-Za-z0-9_$]+\\b";
    private static final String REGEX_CLASS_SLASH = "\\b(?:[A-Za-z0-9_$]+/)*[A-Za-z0-9_$]+\\b";
    private static final String REGEX_LINE_NUMBER = "\\b[0-9]+\\b";
    private static final String REGEX_TYPE = "\\b(?:[A-Za-z0-9_$]+\\.)*[A-Za-z0-9_$]+\\b(?:\\[\\])*";
    private static final String REGEX_MEMBER = "<?\\b[A-Za-z0-9_$]+\\b>?";
    private static final String REGEX_ARGUMENTS = "(?:\\b(?:[A-Za-z0-9_$]+\\.)*[A-Za-z0-9_$]+\\b(?:\\[\\])*(?:\\s*,\\s*\\b(?:[A-Za-z0-9_$]+\\.)*[A-Za-z0-9_$]+\\b(?:\\[\\])*)*)?";
    private final String regularExpression;
    private final boolean verbose;
    private final File mappingFile;
    private final File stackTraceFile;
    private Map classMap = new HashMap();
    private Map classFieldMap = new HashMap();
    private Map classMethodMap = new HashMap();

    public ReTrace(String string, boolean bl, File file) {
        this(string, bl, file, null);
    }

    public ReTrace(String string, boolean bl, File file, File file2) {
        this.regularExpression = string;
        this.verbose = bl;
        this.mappingFile = file;
        this.stackTraceFile = file2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws IOException {
        int n;
        MappingReader mappingReader = new MappingReader(this.mappingFile);
        mappingReader.pump(this);
        StringBuffer stringBuffer = new StringBuffer(this.regularExpression.length() + 32);
        char[] cArray = new char[32];
        int n2 = 0;
        int n3 = 0;
        while ((n = this.regularExpression.indexOf(37, n3)) >= 0 && n != this.regularExpression.length() - 1 && n2 != cArray.length) {
            stringBuffer.append(this.regularExpression.substring(n3, n));
            stringBuffer.append('(');
            char c = this.regularExpression.charAt(n + 1);
            switch (c) {
                case 'c': {
                    stringBuffer.append(REGEX_CLASS);
                    break;
                }
                case 'C': {
                    stringBuffer.append(REGEX_CLASS_SLASH);
                    break;
                }
                case 'l': {
                    stringBuffer.append(REGEX_LINE_NUMBER);
                    break;
                }
                case 't': {
                    stringBuffer.append(REGEX_TYPE);
                    break;
                }
                case 'f': {
                    stringBuffer.append(REGEX_MEMBER);
                    break;
                }
                case 'm': {
                    stringBuffer.append(REGEX_MEMBER);
                    break;
                }
                case 'a': {
                    stringBuffer.append(REGEX_ARGUMENTS);
                    break;
                }
            }
            stringBuffer.append(')');
            cArray[n2++] = c;
            n3 = n + 2;
        }
        stringBuffer.append(this.regularExpression.substring(n3));
        Pattern pattern = Pattern.compile(stringBuffer.toString());
        LineNumberReader lineNumberReader = new LineNumberReader(this.stackTraceFile == null ? new InputStreamReader(System.in) : new BufferedReader(new FileReader(this.stackTraceFile)));
        try {
            try {
                StringBuffer stringBuffer2 = new StringBuffer(256);
                ArrayList arrayList = new ArrayList();
                String string2 = null;
                block33: while (true) {
                    String string;
                    if ((string = lineNumberReader.readLine()) == null) {
                        Object var23_26 = null;
                        if (this.stackTraceFile == null) return;
                        break;
                    }
                    Matcher matcher = pattern.matcher(string);
                    if (matcher.matches()) {
                        int n4;
                        int n5;
                        int n6;
                        int n7 = 0;
                        String string3 = null;
                        String string4 = null;
                        block34: for (n6 = 0; n6 < n2; ++n6) {
                            n5 = matcher.start(n6 + 1);
                            if (n5 < 0) continue;
                            String string5 = matcher.group(n6 + 1);
                            n4 = cArray[n6];
                            switch (n4) {
                                case 99: {
                                    string2 = this.originalClassName(string5);
                                    continue block34;
                                }
                                case 67: {
                                    string2 = this.originalClassName(ClassUtil.externalClassName(string5));
                                    continue block34;
                                }
                                case 108: {
                                    n7 = Integer.parseInt(string5);
                                    continue block34;
                                }
                                case 116: {
                                    string3 = this.originalType(string5);
                                    continue block34;
                                }
                                case 97: {
                                    string4 = this.originalArguments(string5);
                                    continue block34;
                                }
                            }
                        }
                        n6 = 0;
                        stringBuffer2.setLength(0);
                        arrayList.clear();
                        for (n5 = 0; n5 < n2; ++n5) {
                            int n8 = matcher.start(n5 + 1);
                            if (n8 < 0) continue;
                            n4 = matcher.end(n5 + 1);
                            String string6 = matcher.group(n5 + 1);
                            stringBuffer2.append(string.substring(n6, n8));
                            char c = cArray[n5];
                            switch (c) {
                                case 'c': {
                                    string2 = this.originalClassName(string6);
                                    stringBuffer2.append(string2);
                                    break;
                                }
                                case 'C': {
                                    string2 = this.originalClassName(ClassUtil.externalClassName(string6));
                                    stringBuffer2.append(ClassUtil.internalClassName(string2));
                                    break;
                                }
                                case 'l': {
                                    n7 = Integer.parseInt(string6);
                                    stringBuffer2.append(string6);
                                    break;
                                }
                                case 't': {
                                    string3 = this.originalType(string6);
                                    stringBuffer2.append(string3);
                                    break;
                                }
                                case 'f': {
                                    this.originalFieldName(string2, string6, string3, stringBuffer2, arrayList);
                                    break;
                                }
                                case 'm': {
                                    this.originalMethodName(string2, string6, n7, string3, string4, stringBuffer2, arrayList);
                                    break;
                                }
                                case 'a': {
                                    string4 = this.originalArguments(string6);
                                    stringBuffer2.append(string4);
                                    break;
                                }
                            }
                            n6 = n4;
                        }
                        stringBuffer2.append(string.substring(n6));
                        System.out.println(stringBuffer2);
                        n5 = 0;
                        while (true) {
                            if (n5 >= arrayList.size()) continue block33;
                            System.out.println(arrayList.get(n5));
                            ++n5;
                        }
                    }
                    System.out.println(string);
                }
            }
            catch (IOException iOException) {
                throw new IOException("Can't read stack trace (" + iOException.getMessage() + ")");
            }
        }
        catch (Throwable throwable) {
            Object var23_27 = null;
            if (this.stackTraceFile == null) throw throwable;
            try {
                lineNumberReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        lineNumberReader.close();
        return;
    }

    private void originalFieldName(String string, String string2, String string3, StringBuffer stringBuffer, List list) {
        Set set;
        int n = -1;
        Map map = (Map)this.classFieldMap.get(string);
        if (map != null && (set = (Set)map.get(string2)) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FieldInfo fieldInfo = (FieldInfo)iterator.next();
                if (!fieldInfo.matches(string3)) continue;
                if (n < 0) {
                    n = stringBuffer.length();
                    if (this.verbose) {
                        stringBuffer.append(fieldInfo.type).append(' ');
                    }
                    stringBuffer.append(fieldInfo.originalName);
                    continue;
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    stringBuffer2.append(' ');
                }
                if (this.verbose) {
                    stringBuffer2.append(fieldInfo.type).append(' ');
                }
                stringBuffer2.append(fieldInfo.originalName);
                list.add(stringBuffer2);
            }
        }
        if (n < 0) {
            stringBuffer.append(string2);
        }
    }

    private void originalMethodName(String string, String string2, int n, String string3, String string4, StringBuffer stringBuffer, List list) {
        Set set;
        int n2 = -1;
        Map map = (Map)this.classMethodMap.get(string);
        if (map != null && (set = (Set)map.get(string2)) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                MethodInfo methodInfo = (MethodInfo)iterator.next();
                if (!methodInfo.matches(n, string3, string4)) continue;
                if (n2 < 0) {
                    n2 = stringBuffer.length();
                    if (this.verbose) {
                        stringBuffer.append(methodInfo.type).append(' ');
                    }
                    stringBuffer.append(methodInfo.originalName);
                    if (!this.verbose) continue;
                    stringBuffer.append('(').append(methodInfo.arguments).append(')');
                    continue;
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                for (int i = 0; i < n2; ++i) {
                    stringBuffer2.append(' ');
                }
                if (this.verbose) {
                    stringBuffer2.append(methodInfo.type).append(' ');
                }
                stringBuffer2.append(methodInfo.originalName);
                if (this.verbose) {
                    stringBuffer2.append('(').append(methodInfo.arguments).append(')');
                }
                list.add(stringBuffer2);
            }
        }
        if (n2 < 0) {
            stringBuffer.append(string2);
        }
    }

    private String originalArguments(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while ((n = string.indexOf(44, n2)) >= 0) {
            stringBuffer.append(this.originalType(string.substring(n2, n).trim())).append(',');
            n2 = n + 1;
        }
        stringBuffer.append(this.originalType(string.substring(n2).trim()));
        return stringBuffer.toString();
    }

    private String originalType(String string) {
        int n = string.indexOf(91);
        return n >= 0 ? this.originalClassName(string.substring(0, n)) + string.substring(n) : this.originalClassName(string);
    }

    private String originalClassName(String string) {
        String string2 = (String)this.classMap.get(string);
        return string2 != null ? string2 : string;
    }

    public boolean processClassMapping(String string, String string2) {
        this.classMap.put(string2, string);
        return true;
    }

    public void processFieldMapping(String string, String string2, String string3, String string4) {
        LinkedHashSet<FieldInfo> linkedHashSet;
        HashMap<String, LinkedHashSet<FieldInfo>> hashMap = (HashMap<String, LinkedHashSet<FieldInfo>>)this.classFieldMap.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, LinkedHashSet<FieldInfo>>();
            this.classFieldMap.put(string, hashMap);
        }
        if ((linkedHashSet = (LinkedHashSet<FieldInfo>)hashMap.get(string4)) == null) {
            linkedHashSet = new LinkedHashSet<FieldInfo>();
            hashMap.put(string4, linkedHashSet);
        }
        linkedHashSet.add(new FieldInfo(string2, string3));
    }

    public void processMethodMapping(String string, int n, int n2, String string2, String string3, String string4, String string5) {
        LinkedHashSet<MethodInfo> linkedHashSet;
        HashMap<String, LinkedHashSet<MethodInfo>> hashMap = (HashMap<String, LinkedHashSet<MethodInfo>>)this.classMethodMap.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, LinkedHashSet<MethodInfo>>();
            this.classMethodMap.put(string, hashMap);
        }
        if ((linkedHashSet = (LinkedHashSet<MethodInfo>)hashMap.get(string5)) == null) {
            linkedHashSet = new LinkedHashSet<MethodInfo>();
            hashMap.put(string5, linkedHashSet);
        }
        linkedHashSet.add(new MethodInfo(n, n2, string2, string4, string3));
    }

    public static void main(String[] stringArray) {
        Object object;
        int n;
        if (stringArray.length < 1) {
            System.err.println("Usage: java proguard.ReTrace [-verbose] <mapping_file> [<stacktrace_file>]");
            System.exit(-1);
        }
        String string = STACK_TRACE_EXPRESSION;
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            object = stringArray[n];
            if (((String)object).equals(REGEX_OPTION)) {
                string = stringArray[++n];
                continue;
            }
            if (!((String)object).equals(VERBOSE_OPTION)) break;
            bl = true;
        }
        if (n >= stringArray.length) {
            System.err.println("Usage: java proguard.ReTrace [-regex <regex>] [-verbose] <mapping_file> [<stacktrace_file>]");
            System.exit(-1);
        }
        object = new File(stringArray[n++]);
        File file = n < stringArray.length ? new File(stringArray[n]) : null;
        ReTrace reTrace = new ReTrace(string, bl, (File)object, file);
        try {
            reTrace.execute();
        }
        catch (IOException iOException) {
            if (bl) {
                iOException.printStackTrace();
            } else {
                System.err.println("Error: " + iOException.getMessage());
            }
            System.exit(1);
        }
        System.exit(0);
    }

    private static class MethodInfo {
        private int firstLineNumber;
        private int lastLineNumber;
        private String type;
        private String arguments;
        private String originalName;

        private MethodInfo(int n, int n2, String string, String string2, String string3) {
            this.firstLineNumber = n;
            this.lastLineNumber = n2;
            this.type = string;
            this.arguments = string2;
            this.originalName = string3;
        }

        private boolean matches(int n, String string, String string2) {
            return !(n != 0 && (this.firstLineNumber > n || n > this.lastLineNumber) && this.lastLineNumber != 0 || string != null && !string.equals(this.type) || string2 != null && !string2.equals(this.arguments));
        }
    }

    private static class FieldInfo {
        private String type;
        private String originalName;

        private FieldInfo(String string, String string2) {
            this.type = string;
            this.originalName = string2;
        }

        private boolean matches(String string) {
            return string == null || string.equals(this.type);
        }
    }
}

