/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import org.w3c.dom.Element;
import weka.core.Attribute;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldRef
extends Expression {
    private static final long serialVersionUID = -8009605897876168409L;
    protected String m_fieldName = null;

    public FieldRef(Element fieldRef, FieldMetaInfo.Optype opType, ArrayList<Attribute> fieldDefs) throws Exception {
        super(opType, fieldDefs);
        this.m_fieldName = fieldRef.getAttribute("field");
        this.validateField();
    }

    @Override
    public void setFieldDefs(ArrayList<Attribute> fieldDefs) throws Exception {
        super.setFieldDefs(fieldDefs);
        this.validateField();
    }

    protected void validateField() throws Exception {
        if (this.m_fieldDefs != null) {
            Attribute a = this.getFieldDef(this.m_fieldName);
            if (a == null) {
                throw new Exception("[FieldRef] Can't find field " + this.m_fieldName + " in the supplied field definitions");
            }
            if ((this.m_opType == FieldMetaInfo.Optype.CATEGORICAL || this.m_opType == FieldMetaInfo.Optype.ORDINAL) && a.isNumeric()) {
                throw new IllegalArgumentException("[FieldRef] Optype is categorical/ordinal but matching parameter in the field definitions is not!");
            }
            if (this.m_opType == FieldMetaInfo.Optype.CONTINUOUS && a.isNominal()) {
                throw new IllegalArgumentException("[FieldRef] Optype is continuous but matching parameter in the field definitions is not!");
            }
        }
    }

    @Override
    public double getResult(double[] incoming) throws Exception {
        double result = Double.NaN;
        boolean found = false;
        for (int i = 0; i < this.m_fieldDefs.size(); ++i) {
            Attribute a = (Attribute)this.m_fieldDefs.get(i);
            if (!a.name().equals(this.m_fieldName)) continue;
            if (a.isNumeric()) {
                if (this.m_opType == FieldMetaInfo.Optype.CATEGORICAL || this.m_opType == FieldMetaInfo.Optype.ORDINAL) {
                    throw new IllegalArgumentException("[FieldRef] Optype is categorical/ordinal but matching parameter is not!");
                }
            } else if (a.isNominal()) {
                if (this.m_opType == FieldMetaInfo.Optype.CONTINUOUS) {
                    throw new IllegalArgumentException("[FieldRef] Optype is continuous but matching parameter is not!");
                }
            } else {
                throw new IllegalArgumentException("[FieldRef] Unhandled attribute type");
            }
            result = incoming[i];
            found = true;
            break;
        }
        if (!found) {
            throw new Exception("[FieldRef] this field: " + this.m_fieldName + " is not in the supplied " + "list of parameters!");
        }
        return result;
    }

    @Override
    public String getResultCategorical(double[] incoming) throws Exception {
        if (this.m_opType == FieldMetaInfo.Optype.CONTINUOUS) {
            throw new IllegalArgumentException("[FieldRef] Can't return result as categorical/ordinal because optype is continuous!");
        }
        boolean found = false;
        String result = null;
        for (int i = 0; i < this.m_fieldDefs.size(); ++i) {
            Attribute a = (Attribute)this.m_fieldDefs.get(i);
            if (!a.name().equals(this.m_fieldName)) continue;
            found = true;
            result = a.value((int)incoming[i]);
            break;
        }
        if (!found) {
            throw new Exception("[FieldRef] this field: " + this.m_fieldName + " is not in the supplied " + "list of parameters!");
        }
        return result;
    }

    @Override
    public Attribute getOutputDef() {
        Attribute a = this.getFieldDef(this.m_fieldName);
        if (a != null) {
            return a;
        }
        return null;
    }

    @Override
    public String toString(String pad) {
        return pad + "FieldRef: " + this.m_fieldName;
    }
}

