# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appcontainers import ContainerAppsAPIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerAppsAPILogicAppsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerAppsAPIClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_logic_apps_get(self, resource_group):
        response = self.client.logic_apps.get(
            resource_group_name=resource_group.name,
            container_app_name="str",
            logic_app_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_logic_apps_create_or_update(self, resource_group):
        response = self.client.logic_apps.create_or_update(
            resource_group_name=resource_group.name,
            container_app_name="str",
            logic_app_name="str",
            resource={
                "id": "str",
                "name": "str",
                "properties": {},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_logic_apps_delete(self, resource_group):
        response = self.client.logic_apps.delete(
            resource_group_name=resource_group.name,
            container_app_name="str",
            logic_app_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_logic_apps_list_workflows(self, resource_group):
        response = self.client.logic_apps.list_workflows(
            resource_group_name=resource_group.name,
            container_app_name="str",
            logic_app_name="str",
            api_version="2025-02-02-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_logic_apps_get_workflow(self, resource_group):
        response = self.client.logic_apps.get_workflow(
            resource_group_name=resource_group.name,
            container_app_name="str",
            logic_app_name="str",
            workflow_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_logic_apps_deploy_workflow_artifacts(self, resource_group):
        response = self.client.logic_apps.deploy_workflow_artifacts(
            resource_group_name=resource_group.name,
            container_app_name="str",
            logic_app_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_logic_apps_list_workflows_connections(self, resource_group):
        response = self.client.logic_apps.list_workflows_connections(
            resource_group_name=resource_group.name,
            container_app_name="str",
            logic_app_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_logic_apps_invoke(self, resource_group):
        response = self.client.logic_apps.invoke(
            resource_group_name=resource_group.name,
            container_app_name="str",
            logic_app_name="str",
            x_ms_logic_apps_proxy_path="str",
            x_ms_logic_apps_proxy_method="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...
