# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.settings import settings
from azure.mgmt.core import ARMPipelineClient
from azure.mgmt.core.policies import ARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from . import models as _models
from ._configuration import DnsResolverManagementClientConfiguration
from ._utils.serialization import Deserializer, Serializer
from .operations import (
    DnsForwardingRulesetsOperations,
    DnsResolverDomainListsOperations,
    DnsResolverPoliciesOperations,
    DnsResolverPolicyVirtualNetworkLinksOperations,
    DnsResolversOperations,
    DnsSecurityRulesOperations,
    ForwardingRulesOperations,
    InboundEndpointsOperations,
    OutboundEndpointsOperations,
    VirtualNetworkLinksOperations,
)

if TYPE_CHECKING:
    from azure.core.credentials import TokenCredential


class DnsResolverManagementClient:  # pylint: disable=too-many-instance-attributes
    """DNS Resolver Client.

    :ivar dns_resolvers: DnsResolversOperations operations
    :vartype dns_resolvers: azure.mgmt.dnsresolver.operations.DnsResolversOperations
    :ivar inbound_endpoints: InboundEndpointsOperations operations
    :vartype inbound_endpoints: azure.mgmt.dnsresolver.operations.InboundEndpointsOperations
    :ivar outbound_endpoints: OutboundEndpointsOperations operations
    :vartype outbound_endpoints: azure.mgmt.dnsresolver.operations.OutboundEndpointsOperations
    :ivar dns_forwarding_rulesets: DnsForwardingRulesetsOperations operations
    :vartype dns_forwarding_rulesets:
     azure.mgmt.dnsresolver.operations.DnsForwardingRulesetsOperations
    :ivar forwarding_rules: ForwardingRulesOperations operations
    :vartype forwarding_rules: azure.mgmt.dnsresolver.operations.ForwardingRulesOperations
    :ivar virtual_network_links: VirtualNetworkLinksOperations operations
    :vartype virtual_network_links: azure.mgmt.dnsresolver.operations.VirtualNetworkLinksOperations
    :ivar dns_resolver_policies: DnsResolverPoliciesOperations operations
    :vartype dns_resolver_policies: azure.mgmt.dnsresolver.operations.DnsResolverPoliciesOperations
    :ivar dns_security_rules: DnsSecurityRulesOperations operations
    :vartype dns_security_rules: azure.mgmt.dnsresolver.operations.DnsSecurityRulesOperations
    :ivar dns_resolver_policy_virtual_network_links: DnsResolverPolicyVirtualNetworkLinksOperations
     operations
    :vartype dns_resolver_policy_virtual_network_links:
     azure.mgmt.dnsresolver.operations.DnsResolverPolicyVirtualNetworkLinksOperations
    :ivar dns_resolver_domain_lists: DnsResolverDomainListsOperations operations
    :vartype dns_resolver_domain_lists:
     azure.mgmt.dnsresolver.operations.DnsResolverDomainListsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. The value must be an UUID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is None.
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2025-05-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self, credential: "TokenCredential", subscription_id: str, base_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        _cloud = kwargs.pop("cloud_setting", None) or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = DnsResolverManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, credential_scopes=credential_scopes, **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                ARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=cast(str, base_url), policies=_policies, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.dns_resolvers = DnsResolversOperations(self._client, self._config, self._serialize, self._deserialize)
        self.inbound_endpoints = InboundEndpointsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.outbound_endpoints = OutboundEndpointsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.dns_forwarding_rulesets = DnsForwardingRulesetsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.forwarding_rules = ForwardingRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_network_links = VirtualNetworkLinksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.dns_resolver_policies = DnsResolverPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.dns_security_rules = DnsSecurityRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.dns_resolver_policy_virtual_network_links = DnsResolverPolicyVirtualNetworkLinksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.dns_resolver_domain_lists = DnsResolverDomainListsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, *, stream: bool = False, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> Self:
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
