# --------------------------------------------------------------------------
#
# Copyright (c) Microsoft Corporation. All rights reserved.
#
# The MIT License (MIT)
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the ""Software""), to
# deal in the Software without restriction, including without limitation the
# rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
# sell copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED *AS IS*, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
# IN THE SOFTWARE.
#
# --------------------------------------------------------------------------

from ._index import (
    ComplexField,
    SearchField,
    SearchableField,
    SimpleField,
    SearchIndex,
)
from . import _edm
from ..._generated.models import SuggestOptions
from .._generated.models import (
    SearchAlias,
    AIServicesAccountIdentity,
    AIServicesAccountKey,
    AIServicesVisionParameters,
    AIServicesVisionVectorizer,
    AIFoundryModelCatalogName,
    AzureMachineLearningParameters,
    AzureMachineLearningSkill,
    AzureMachineLearningVectorizer,
    AnalyzeResult,
    AnalyzedTokenInfo,
    AsciiFoldingTokenFilter,
    AzureBlobKnowledgeSource,
    AzureBlobKnowledgeSourceParameters,
    AzureOpenAIEmbeddingSkill,
    AzureOpenAITokenizerParameters,
    AzureOpenAIModelName,
    AzureOpenAIVectorizerParameters,
    AzureOpenAIVectorizer,
    BinaryQuantizationCompression,
    BlobIndexerDataToExtract,
    BlobIndexerImageAction,
    BlobIndexerParsingMode,
    BlobIndexerPDFTextRotationAlgorithm,
    BM25SimilarityAlgorithm,
    CharFilter,
    CharFilterName,
    ChatCompletionExtraParametersBehavior,
    ChatCompletionResponseFormat,
    ChatCompletionResponseFormatJsonSchemaProperties,
    ChatCompletionResponseFormatType,
    ChatCompletionSchema,
    ChatCompletionSkill,
    CjkBigramTokenFilter,
    CjkBigramTokenFilterScripts,
    ClassicSimilarityAlgorithm,
    ClassicTokenizer,
    CognitiveServicesAccount,
    CognitiveServicesAccountKey,
    CommonGramTokenFilter,
    CommonModelParameters,
    ConditionalSkill,
    CorsOptions,
    CustomEntity,
    CustomEntityAlias,
    CustomEntityLookupSkill,
    CustomEntityLookupSkillLanguage,
    CustomNormalizer,
    DataChangeDetectionPolicy,
    DataDeletionDetectionPolicy,
    DataSourceCredentials,
    DefaultCognitiveServicesAccount,
    DictionaryDecompounderTokenFilter,
    DistanceScoringFunction,
    DistanceScoringParameters,
    DocumentExtractionSkill,
    DocumentIntelligenceLayoutSkill,
    DocumentIntelligenceLayoutSkillChunkingProperties,
    DocumentIntelligenceLayoutSkillChunkingUnit,
    DocumentIntelligenceLayoutSkillExtractionOptions,
    DocumentIntelligenceLayoutSkillMarkdownHeaderDepth,
    DocumentIntelligenceLayoutSkillOutputFormat,
    DocumentIntelligenceLayoutSkillOutputMode,
    DocumentKeysOrIds,
    EdgeNGramTokenFilter,
    EdgeNGramTokenizer,
    EdgeNGramTokenFilterSide,
    ElisionTokenFilter,
    EntityCategory,
    EntityLinkingSkill,
    EntityRecognitionSkillLanguage,
    ExhaustiveKnnAlgorithmConfiguration,
    ExhaustiveKnnParameters,
    FieldMapping,
    FieldMappingFunction,
    FreshnessScoringFunction,
    FreshnessScoringParameters,
    GetIndexStatisticsResult,
    HighWaterMarkChangeDetectionPolicy,
    HnswParameters,
    HnswAlgorithmConfiguration,
    ImageAnalysisSkill,
    ImageAnalysisSkillLanguage,
    ImageDetail,
    IndexerCurrentState,
    IndexerExecutionEnvironment,
    IndexerExecutionResult,
    IndexerResyncBody,
    IndexerExecutionStatus,
    IndexerPermissionOption,
    IndexerResyncOption,
    IndexerStatus,
    IndexingMode,
    IndexingParameters,
    IndexingParametersConfiguration,
    IndexingSchedule,
    IndexProjectionMode,
    IndexStatisticsSummary,
    InputFieldMappingEntry,
    KeepTokenFilter,
    KeyPhraseExtractionSkill,
    KeyPhraseExtractionSkillLanguage,
    KeywordMarkerTokenFilter,
    KeywordTokenizerV2,
    KnowledgeAgent,
    KnowledgeAgentAzureOpenAIModel,
    KnowledgeAgentModel,
    KnowledgeAgentOutputConfiguration,
    KnowledgeAgentModelKind,
    KnowledgeAgentOutputConfigurationModality,
    KnowledgeAgentRequestLimits,
    KnowledgeSource,
    KnowledgeSourceKind,
    KnowledgeSourceReference,
    LanguageDetectionSkill,
    LengthTokenFilter,
    LexicalAnalyzer,
    LexicalNormalizer,
    LexicalNormalizerName,
    LexicalAnalyzerName,
    LexicalTokenizer,
    LexicalTokenizerName,
    LimitTokenFilter,
    LuceneStandardAnalyzer,
    LuceneStandardTokenizer,
    MagnitudeScoringFunction,
    MagnitudeScoringParameters,
    MarkdownHeaderDepth,
    MarkdownParsingSubmode,
    MappingCharFilter,
    MergeSkill,
    MicrosoftLanguageStemmingTokenizer,
    MicrosoftLanguageTokenizer,
    MicrosoftStemmingTokenizerLanguage,
    MicrosoftTokenizerLanguage,
    NativeBlobSoftDeleteDeletionDetectionPolicy,
    NGramTokenFilter,
    NGramTokenizer,
    OcrLineEnding,
    OcrSkill,
    OcrSkillLanguage,
    OutputFieldMappingEntry,
    PathHierarchyTokenizerV2,
    PatternCaptureTokenFilter,
    PatternReplaceCharFilter,
    PatternReplaceTokenFilter,
    PhoneticEncoder,
    PhoneticTokenFilter,
    PIIDetectionSkill,
    PIIDetectionSkillMaskingMode,
    PermissionFilter,
    RankingOrder,
    RegexFlags,
    RescoringOptions,
    ResourceCounter,
    ScalarQuantizationCompression,
    ScalarQuantizationParameters,
    ScoringFunction,
    ScoringFunctionAggregation,
    ScoringFunctionInterpolation,
    ScoringProfile,
    SearchIndexKnowledgeSource,
    SearchIndexKnowledgeSourceParameters,
    SearchIndexerCache,
    SearchIndexerDataContainer,
    SearchIndexerDataIdentity,
    SearchIndexerDataNoneIdentity,
    SearchIndexerDataUserAssignedIdentity,
    SearchIndexerDataSourceType,
    SearchIndexerError,
    SearchIndexerIndexProjection,
    SearchIndexerIndexProjectionSelector,
    SearchIndexerIndexProjectionsParameters,
    SearchIndexerKnowledgeStore,
    SearchIndexerKnowledgeStoreBlobProjectionSelector,
    SearchIndexerKnowledgeStoreFileProjectionSelector,
    SearchIndexerKnowledgeStoreObjectProjectionSelector,
    SearchIndexerKnowledgeStoreProjection,
    SearchIndexerKnowledgeStoreProjectionSelector,
    SearchIndexerKnowledgeStoreTableProjectionSelector,
    SearchIndexerLimits,
    SearchIndexerSkill,
    SearchIndexerStatus,
    SearchIndexerWarning,
    SearchIndexPermissionFilterOption,
    SearchServiceCounters,
    SearchServiceLimits,
    SearchServiceStatistics,
    SearchSuggester,
    SemanticConfiguration,
    SemanticField,
    SemanticPrioritizedFields,
    SemanticSearch,
    SentimentSkillLanguage,
    ShaperSkill,
    ShingleTokenFilter,
    SimilarityAlgorithm,
    SkillNames,
    SnowballTokenFilter,
    SnowballTokenFilterLanguage,
    SoftDeleteColumnDeletionDetectionPolicy,
    SplitSkillEncoderModelName,
    SplitSkill,
    SplitSkillLanguage,
    SplitSkillUnit,
    SqlIntegratedChangeTrackingPolicy,
    StemmerOverrideTokenFilter,
    StemmerTokenFilter,
    StemmerTokenFilterLanguage,
    StopAnalyzer,
    StopwordsList,
    StopwordsTokenFilter,
    SynonymTokenFilter,
    TagScoringFunction,
    TagScoringParameters,
    TextSplitMode,
    TextTranslationSkill,
    TextTranslationSkillLanguage,
    TextWeights,
    TokenCharacterKind,
    TokenFilter,
    TokenFilterName,
    TruncateTokenFilter,
    UaxUrlEmailTokenizer,
    UniqueTokenFilter,
    VectorEncodingFormat,
    VectorSearch,
    VectorSearchAlgorithmConfiguration,
    VectorSearchAlgorithmKind,
    VectorSearchAlgorithmMetric,
    VectorSearchCompression,
    VectorSearchCompressionKind,
    VectorSearchCompressionRescoreStorageMethod,
    VectorSearchCompressionTarget,
    VectorSearchProfile,
    VectorSearchVectorizer,
    VectorSearchVectorizerKind,
    VisualFeature,
    VisionVectorizeSkill,
    WebApiSkill,
    WebApiVectorizer,
    WebApiVectorizerParameters,
    WordDelimiterTokenFilter,
)
from ._models import (
    AnalyzeTextOptions,
    CustomAnalyzer,
    EntityRecognitionSkill,
    EntityRecognitionSkillVersion,
    PatternAnalyzer,
    PatternTokenizer,
    SearchIndexer,
    SearchIndexerDataSourceConnection,
    SearchIndexerSkillset,
    SearchResourceEncryptionKey,
    SentimentSkill,
    SentimentSkillVersion,
    SynonymMap,
)

SearchFieldDataType = _edm


class KeywordTokenizer(KeywordTokenizerV2):
    pass


class PathHierarchyTokenizer(PathHierarchyTokenizerV2):
    pass


__all__ = (
    "AIServicesAccountIdentity",
    "AIServicesAccountKey",
    "AIServicesVisionParameters",
    "AIServicesVisionVectorizer",
    "AIFoundryModelCatalogName",
    "AnalyzeTextOptions",
    "AnalyzeResult",
    "AnalyzedTokenInfo",
    "AsciiFoldingTokenFilter",
    "AzureOpenAIEmbeddingSkill",
    "AzureOpenAITokenizerParameters",
    "AzureOpenAIModelName",
    "AzureOpenAIVectorizerParameters",
    "AzureOpenAIVectorizer",
    "AzureBlobKnowledgeSource",
    "AzureBlobKnowledgeSourceParameters",
    "AzureMachineLearningParameters",
    "AzureMachineLearningSkill",
    "AzureMachineLearningVectorizer",
    "BinaryQuantizationCompression",
    "BlobIndexerDataToExtract",
    "BlobIndexerImageAction",
    "BlobIndexerParsingMode",
    "BlobIndexerPDFTextRotationAlgorithm",
    "BM25SimilarityAlgorithm",
    "CharFilter",
    "CharFilterName",
    "ChatCompletionExtraParametersBehavior",
    "ChatCompletionResponseFormat",
    "ChatCompletionResponseFormatType",
    "ChatCompletionResponseFormatJsonSchemaProperties",
    "ChatCompletionSchema",
    "ChatCompletionSkill",
    "CjkBigramTokenFilter",
    "CjkBigramTokenFilterScripts",
    "ClassicSimilarityAlgorithm",
    "ClassicTokenizer",
    "CognitiveServicesAccount",
    "CognitiveServicesAccountKey",
    "CommonGramTokenFilter",
    "CommonModelParameters",
    "ComplexField",
    "ConditionalSkill",
    "CorsOptions",
    "CustomAnalyzer",
    "CustomEntity",
    "CustomEntityAlias",
    "CustomEntityLookupSkill",
    "WebApiVectorizer",
    "WebApiVectorizerParameters",
    "CustomEntityLookupSkillLanguage",
    "CustomNormalizer",
    "DataChangeDetectionPolicy",
    "DataDeletionDetectionPolicy",
    "DataSourceCredentials",
    "DefaultCognitiveServicesAccount",
    "DictionaryDecompounderTokenFilter",
    "DistanceScoringFunction",
    "DistanceScoringParameters",
    "DocumentExtractionSkill",
    "DocumentIntelligenceLayoutSkill",
    "DocumentIntelligenceLayoutSkillChunkingProperties",
    "DocumentIntelligenceLayoutSkillChunkingUnit",
    "DocumentIntelligenceLayoutSkillExtractionOptions",
    "DocumentIntelligenceLayoutSkillMarkdownHeaderDepth",
    "DocumentIntelligenceLayoutSkillOutputFormat",
    "DocumentIntelligenceLayoutSkillOutputMode",
    "DocumentKeysOrIds",
    "EdgeNGramTokenFilter",
    "EdgeNGramTokenizer",
    "ElisionTokenFilter",
    "EdgeNGramTokenFilterSide",
    "EntityCategory",
    "EntityLinkingSkill",
    "EntityRecognitionSkill",
    "EntityRecognitionSkillLanguage",
    "EntityRecognitionSkillVersion",
    "ExhaustiveKnnAlgorithmConfiguration",
    "ExhaustiveKnnParameters",
    "FieldMapping",
    "FieldMappingFunction",
    "FreshnessScoringFunction",
    "FreshnessScoringParameters",
    "GetIndexStatisticsResult",
    "HighWaterMarkChangeDetectionPolicy",
    "HnswParameters",
    "HnswAlgorithmConfiguration",
    "ImageAnalysisSkill",
    "ImageAnalysisSkillLanguage",
    "ImageDetail",
    "IndexerCurrentState",
    "IndexerExecutionEnvironment",
    "IndexerExecutionResult",
    "IndexerResyncBody",
    "IndexerExecutionStatus",
    "IndexerPermissionOption",
    "IndexerResyncOption",
    "IndexerStatus",
    "IndexingMode",
    "IndexingParameters",
    "IndexingParametersConfiguration",
    "IndexingSchedule",
    "IndexProjectionMode",
    "InputFieldMappingEntry",
    "KeepTokenFilter",
    "KeyPhraseExtractionSkill",
    "KeyPhraseExtractionSkillLanguage",
    "KeywordMarkerTokenFilter",
    "KeywordTokenizer",
    "LanguageDetectionSkill",
    "KnowledgeAgent",
    "KnowledgeAgentAzureOpenAIModel",
    "KnowledgeAgentModel",
    "KnowledgeAgentModelKind",
    "KnowledgeAgentOutputConfiguration",
    "KnowledgeAgentOutputConfigurationModality",
    "KnowledgeAgentRequestLimits",
    "KnowledgeSource",
    "KnowledgeSourceKind",
    "KnowledgeSourceReference",
    "LengthTokenFilter",
    "LexicalAnalyzer",
    "LexicalAnalyzerName",
    "LexicalNormalizer",
    "LexicalNormalizerName",
    "LexicalTokenizer",
    "LexicalTokenizerName",
    "LimitTokenFilter",
    "IndexStatisticsSummary",
    "LuceneStandardAnalyzer",
    "LuceneStandardTokenizer",
    "MagnitudeScoringFunction",
    "MagnitudeScoringParameters",
    "MarkdownHeaderDepth",
    "MarkdownParsingSubmode",
    "MappingCharFilter",
    "MergeSkill",
    "MicrosoftLanguageStemmingTokenizer",
    "MicrosoftLanguageTokenizer",
    "MicrosoftStemmingTokenizerLanguage",
    "MicrosoftTokenizerLanguage",
    "NativeBlobSoftDeleteDeletionDetectionPolicy",
    "NGramTokenFilter",
    "NGramTokenizer",
    "OcrLineEnding",
    "OcrSkill",
    "OcrSkillLanguage",
    "OutputFieldMappingEntry",
    "PathHierarchyTokenizer",
    "PatternAnalyzer",
    "PatternCaptureTokenFilter",
    "PatternReplaceCharFilter",
    "PatternReplaceTokenFilter",
    "PatternTokenizer",
    "PermissionFilter",
    "PIIDetectionSkill",
    "PIIDetectionSkillMaskingMode",
    "PhoneticEncoder",
    "PhoneticTokenFilter",
    "RankingOrder",
    "RegexFlags",
    "RescoringOptions",
    "ResourceCounter",
    "ScalarQuantizationCompression",
    "ScalarQuantizationParameters",
    "ScoringFunction",
    "ScoringFunctionAggregation",
    "ScoringFunctionInterpolation",
    "ScoringProfile",
    "SearchAlias",
    "SearchableField",
    "SearchField",
    "SearchIndex",
    "SearchIndexKnowledgeSource",
    "SearchIndexKnowledgeSourceParameters",
    "SearchIndexer",
    "SearchIndexerCache",
    "SearchIndexerDataContainer",
    "SearchIndexerDataIdentity",
    "SearchIndexerDataNoneIdentity",
    "SearchIndexerDataUserAssignedIdentity",
    "SearchIndexerDataSourceConnection",
    "SearchIndexerDataSourceType",
    "SearchIndexerError",
    "SearchIndexerIndexProjection",
    "SearchIndexerIndexProjectionSelector",
    "SearchIndexerIndexProjectionsParameters",
    "SearchIndexerKnowledgeStore",
    "SearchIndexerKnowledgeStoreBlobProjectionSelector",
    "SearchIndexerKnowledgeStoreFileProjectionSelector",
    "SearchIndexerKnowledgeStoreObjectProjectionSelector",
    "SearchIndexerKnowledgeStoreProjection",
    "SearchIndexerKnowledgeStoreProjectionSelector",
    "SearchIndexerKnowledgeStoreTableProjectionSelector",
    "SearchIndexerLimits",
    "SearchIndexerSkill",
    "SearchIndexerSkillset",
    "SearchIndexerStatus",
    "SearchIndexerWarning",
    "SearchIndexPermissionFilterOption",
    "SearchResourceEncryptionKey",
    "SearchServiceCounters",
    "SearchServiceLimits",
    "SearchServiceStatistics",
    "SearchSuggester",
    "SemanticConfiguration",
    "SemanticField",
    "SemanticPrioritizedFields",
    "SemanticSearch",
    "SentimentSkill",
    "SentimentSkillLanguage",
    "SentimentSkillVersion",
    "ShaperSkill",
    "ShingleTokenFilter",
    "SimpleField",
    "SimilarityAlgorithm",
    "SkillNames",
    "SnowballTokenFilter",
    "SnowballTokenFilterLanguage",
    "SplitSkillEncoderModelName",
    "SoftDeleteColumnDeletionDetectionPolicy",
    "SplitSkill",
    "SplitSkillLanguage",
    "SplitSkillUnit",
    "SqlIntegratedChangeTrackingPolicy",
    "StemmerOverrideTokenFilter",
    "StemmerTokenFilter",
    "StemmerTokenFilterLanguage",
    "StopAnalyzer",
    "StopwordsList",
    "StopwordsTokenFilter",
    "SuggestOptions",
    "SynonymMap",
    "SynonymTokenFilter",
    "TagScoringFunction",
    "TagScoringParameters",
    "TextSplitMode",
    "TextTranslationSkill",
    "TextTranslationSkillLanguage",
    "TextWeights",
    "TokenCharacterKind",
    "TokenFilter",
    "TokenFilterName",
    "TruncateTokenFilter",
    "UaxUrlEmailTokenizer",
    "UniqueTokenFilter",
    "VectorEncodingFormat",
    "VectorSearch",
    "VectorSearchAlgorithmConfiguration",
    "VectorSearchAlgorithmKind",
    "VectorSearchAlgorithmMetric",
    "VectorSearchCompression",
    "VectorSearchCompressionKind",
    "VectorSearchCompressionRescoreStorageMethod",
    "VectorSearchCompressionTarget",
    "VectorSearchProfile",
    "VectorSearchVectorizer",
    "VectorSearchVectorizerKind",
    "VisualFeature",
    "VisionVectorizeSkill",
    "WebApiSkill",
    "WordDelimiterTokenFilter",
    "SearchFieldDataType",
)
