//
// Copyright 2025 Ettus Research, A National Instruments Brand
//
// SPDX-License-Identifier: LGPL-3.0-or-later
//
// Module: obx_cpld_regs_utils.vh
//

//===============================================================================
// A numerically ordered list of registers and their HDL source files
//===============================================================================

  // TX_CONTROL : 0x0 (obx_cpld_reg.v)
  // RX_CONTROL : 0x4 (obx_cpld_reg.v)
  // REVISION_REGISTER : 0x8 (registers.sv)
  // SCRATCH_REGISTER  : 0xC (registers.sv)

//===============================================================================
// RegTypes
//===============================================================================

//===============================================================================
// Register Group OBX_CPLD_REGISTERS
//===============================================================================

  // Enumerated type REVISION_VALUES
  localparam REVISION_VALUES_SIZE = 2;
  localparam REVISION_MINOR_VAL  = 'h0;  // REVISION_VALUES:REVISION_MINOR_VAL
  localparam REVISION_MAJOR_VAL  = 'h1;  // REVISION_VALUES:REVISION_MAJOR_VAL

  // Enumerated type SPI_PASSTHROUGH
  localparam SPI_PASSTHROUGH_SIZE = 5;
  localparam TX_LO1_PASSTHROUGH  = 'h0;  // SPI_PASSTHROUGH:TX_LO1_PASSTHROUGH
  localparam TX_LO2_PASSTHROUGH  = 'h1;  // SPI_PASSTHROUGH:TX_LO2_PASSTHROUGH
  localparam RX_LO1_PASSTHROUGH  = 'h2;  // SPI_PASSTHROUGH:RX_LO1_PASSTHROUGH
  localparam RX_LO2_PASSTHROUGH  = 'h3;  // SPI_PASSTHROUGH:RX_LO2_PASSTHROUGH
  localparam CPLD_INTERNAL_SPI   = 'h4;  // SPI_PASSTHROUGH:CPLD_INTERNAL_SPI

  // TX_CONTROL Register
  localparam TX_CONTROL = 'h0; // Register Offset
  localparam TX_CONTROL_SIZE = 32;  // register width in bits
  localparam TX_CONTROL_MASK = 32'h41F1FF;
  localparam TX_CTRL_TXHB_SEL2_SIZE = 1;  //TX_CONTROL:TX_CTRL_TXHB_SEL2
  localparam TX_CTRL_TXHB_SEL2_MSB  = 0;  //TX_CONTROL:TX_CTRL_TXHB_SEL2
  localparam TX_CTRL_TXHB_SEL2      = 0;  //TX_CONTROL:TX_CTRL_TXHB_SEL2
  localparam TX_CTRL_TXHB_SEL_SIZE = 1;  //TX_CONTROL:TX_CTRL_TXHB_SEL
  localparam TX_CTRL_TXHB_SEL_MSB  = 1;  //TX_CONTROL:TX_CTRL_TXHB_SEL
  localparam TX_CTRL_TXHB_SEL      = 1;  //TX_CONTROL:TX_CTRL_TXHB_SEL
  localparam TX_CTRL_TXLB_SEL2_SIZE = 1;  //TX_CONTROL:TX_CTRL_TXLB_SEL2
  localparam TX_CTRL_TXLB_SEL2_MSB  = 2;  //TX_CONTROL:TX_CTRL_TXLB_SEL2
  localparam TX_CTRL_TXLB_SEL2      = 2;  //TX_CONTROL:TX_CTRL_TXLB_SEL2
  localparam TX_CTRL_TXLB_SEL_SIZE = 1;  //TX_CONTROL:TX_CTRL_TXLB_SEL
  localparam TX_CTRL_TXLB_SEL_MSB  = 3;  //TX_CONTROL:TX_CTRL_TXLB_SEL
  localparam TX_CTRL_TXLB_SEL      = 3;  //TX_CONTROL:TX_CTRL_TXLB_SEL
  localparam TX_CTRL_TXLO1_FSEL1_SIZE = 1;  //TX_CONTROL:TX_CTRL_TXLO1_FSEL1
  localparam TX_CTRL_TXLO1_FSEL1_MSB  = 4;  //TX_CONTROL:TX_CTRL_TXLO1_FSEL1
  localparam TX_CTRL_TXLO1_FSEL1      = 4;  //TX_CONTROL:TX_CTRL_TXLO1_FSEL1
  localparam TX_CTRL_TXLO1_FSEL2_SIZE = 1;  //TX_CONTROL:TX_CTRL_TXLO1_FSEL2
  localparam TX_CTRL_TXLO1_FSEL2_MSB  = 5;  //TX_CONTROL:TX_CTRL_TXLO1_FSEL2
  localparam TX_CTRL_TXLO1_FSEL2      = 5;  //TX_CONTROL:TX_CTRL_TXLO1_FSEL2
  localparam TX_CTRL_TXLO1_FSEL3_SIZE = 1;  //TX_CONTROL:TX_CTRL_TXLO1_FSEL3
  localparam TX_CTRL_TXLO1_FSEL3_MSB  = 6;  //TX_CONTROL:TX_CTRL_TXLO1_FSEL3
  localparam TX_CTRL_TXLO1_FSEL3      = 6;  //TX_CONTROL:TX_CTRL_TXLO1_FSEL3
  localparam TX_CTRL_TXLO1_FSEL4_SIZE = 1;  //TX_CONTROL:TX_CTRL_TXLO1_FSEL4
  localparam TX_CTRL_TXLO1_FSEL4_MSB  = 7;  //TX_CONTROL:TX_CTRL_TXLO1_FSEL4
  localparam TX_CTRL_TXLO1_FSEL4      = 7;  //TX_CONTROL:TX_CTRL_TXLO1_FSEL4
  localparam TX_CTRL_FE_SEL_CAL_TX2_SIZE = 1;  //TX_CONTROL:TX_CTRL_FE_SEL_CAL_TX2
  localparam TX_CTRL_FE_SEL_CAL_TX2_MSB  = 8;  //TX_CONTROL:TX_CTRL_FE_SEL_CAL_TX2
  localparam TX_CTRL_FE_SEL_CAL_TX2      = 8;  //TX_CONTROL:TX_CTRL_FE_SEL_CAL_TX2
  localparam TX_CTRL_TXLO1_FORCEON_SIZE =  1;  //TX_CONTROL:TX_CTRL_TXLO1_FORCEON
  localparam TX_CTRL_TXLO1_FORCEON_MSB  = 12;  //TX_CONTROL:TX_CTRL_TXLO1_FORCEON
  localparam TX_CTRL_TXLO1_FORCEON      = 12;  //TX_CONTROL:TX_CTRL_TXLO1_FORCEON
  localparam TX_CTRL_TXLO2_FORCEON_SIZE =  1;  //TX_CONTROL:TX_CTRL_TXLO2_FORCEON
  localparam TX_CTRL_TXLO2_FORCEON_MSB  = 13;  //TX_CONTROL:TX_CTRL_TXLO2_FORCEON
  localparam TX_CTRL_TXLO2_FORCEON      = 13;  //TX_CONTROL:TX_CTRL_TXLO2_FORCEON
  localparam TX_CTRL_TXMOD_FORCEON_SIZE =  1;  //TX_CONTROL:TX_CTRL_TXMOD_FORCEON
  localparam TX_CTRL_TXMOD_FORCEON_MSB  = 14;  //TX_CONTROL:TX_CTRL_TXMOD_FORCEON
  localparam TX_CTRL_TXMOD_FORCEON      = 14;  //TX_CONTROL:TX_CTRL_TXMOD_FORCEON
  localparam TX_CTRL_TXMIXER_FORCEON_SIZE =  1;  //TX_CONTROL:TX_CTRL_TXMIXER_FORCEON
  localparam TX_CTRL_TXMIXER_FORCEON_MSB  = 15;  //TX_CONTROL:TX_CTRL_TXMIXER_FORCEON
  localparam TX_CTRL_TXMIXER_FORCEON      = 15;  //TX_CONTROL:TX_CTRL_TXMIXER_FORCEON
  localparam TX_CTRL_TXDRV_FORCEON_SIZE =  1;  //TX_CONTROL:TX_CTRL_TXDRV_FORCEON
  localparam TX_CTRL_TXDRV_FORCEON_MSB  = 16;  //TX_CONTROL:TX_CTRL_TXDRV_FORCEON
  localparam TX_CTRL_TXDRV_FORCEON      = 16;  //TX_CONTROL:TX_CTRL_TXDRV_FORCEON
  localparam TX_CTRL_TXDOUBLER_FORCEON_SIZE =  1;  //TX_CONTROL:TX_CTRL_TXDOUBLER_FORCEON
  localparam TX_CTRL_TXDOUBLER_FORCEON_MSB  = 22;  //TX_CONTROL:TX_CTRL_TXDOUBLER_FORCEON
  localparam TX_CTRL_TXDOUBLER_FORCEON      = 22;  //TX_CONTROL:TX_CTRL_TXDOUBLER_FORCEON

  // RX_CONTROL Register
  localparam RX_CONTROL = 'h4; // Register Offset
  localparam RX_CONTROL_SIZE = 32;  // register width in bits
  localparam RX_CONTROL_MASK = 32'h73F7FF;
  localparam RX_CTRL_RXHB_SEL2_SIZE = 1;  //RX_CONTROL:RX_CTRL_RXHB_SEL2
  localparam RX_CTRL_RXHB_SEL2_MSB  = 0;  //RX_CONTROL:RX_CTRL_RXHB_SEL2
  localparam RX_CTRL_RXHB_SEL2      = 0;  //RX_CONTROL:RX_CTRL_RXHB_SEL2
  localparam RX_CTRL_RXHB_SEL_SIZE = 1;  //RX_CONTROL:RX_CTRL_RXHB_SEL
  localparam RX_CTRL_RXHB_SEL_MSB  = 1;  //RX_CONTROL:RX_CTRL_RXHB_SEL
  localparam RX_CTRL_RXHB_SEL      = 1;  //RX_CONTROL:RX_CTRL_RXHB_SEL
  localparam RX_CTRL_RXLB_SEL2_SIZE = 1;  //RX_CONTROL:RX_CTRL_RXLB_SEL2
  localparam RX_CTRL_RXLB_SEL2_MSB  = 2;  //RX_CONTROL:RX_CTRL_RXLB_SEL2
  localparam RX_CTRL_RXLB_SEL2      = 2;  //RX_CONTROL:RX_CTRL_RXLB_SEL2
  localparam RX_CTRL_RXLB_SEL_SIZE = 1;  //RX_CONTROL:RX_CTRL_RXLB_SEL
  localparam RX_CTRL_RXLB_SEL_MSB  = 3;  //RX_CONTROL:RX_CTRL_RXLB_SEL
  localparam RX_CTRL_RXLB_SEL      = 3;  //RX_CONTROL:RX_CTRL_RXLB_SEL
  localparam RX_CTRL_RXLO1_FSEL1_SIZE = 1;  //RX_CONTROL:RX_CTRL_RXLO1_FSEL1
  localparam RX_CTRL_RXLO1_FSEL1_MSB  = 4;  //RX_CONTROL:RX_CTRL_RXLO1_FSEL1
  localparam RX_CTRL_RXLO1_FSEL1      = 4;  //RX_CONTROL:RX_CTRL_RXLO1_FSEL1
  localparam RX_CTRL_RXLO1_FSEL2_SIZE = 1;  //RX_CONTROL:RX_CTRL_RXLO1_FSEL2
  localparam RX_CTRL_RXLO1_FSEL2_MSB  = 5;  //RX_CONTROL:RX_CTRL_RXLO1_FSEL2
  localparam RX_CTRL_RXLO1_FSEL2      = 5;  //RX_CONTROL:RX_CTRL_RXLO1_FSEL2
  localparam RX_CTRL_RXLO1_FSEL3_SIZE = 1;  //RX_CONTROL:RX_CTRL_RXLO1_FSEL3
  localparam RX_CTRL_RXLO1_FSEL3_MSB  = 6;  //RX_CONTROL:RX_CTRL_RXLO1_FSEL3
  localparam RX_CTRL_RXLO1_FSEL3      = 6;  //RX_CONTROL:RX_CTRL_RXLO1_FSEL3
  localparam RX_CTRL_RXLO1_FSEL4_SIZE = 1;  //RX_CONTROL:RX_CTRL_RXLO1_FSEL4
  localparam RX_CTRL_RXLO1_FSEL4_MSB  = 7;  //RX_CONTROL:RX_CTRL_RXLO1_FSEL4
  localparam RX_CTRL_RXLO1_FSEL4      = 7;  //RX_CONTROL:RX_CTRL_RXLO1_FSEL4
  localparam RX_CTRL_FE_SEL_CAL_RX2_SIZE = 1;  //RX_CONTROL:RX_CTRL_FE_SEL_CAL_RX2
  localparam RX_CTRL_FE_SEL_CAL_RX2_MSB  = 8;  //RX_CONTROL:RX_CTRL_FE_SEL_CAL_RX2
  localparam RX_CTRL_FE_SEL_CAL_RX2      = 8;  //RX_CONTROL:RX_CTRL_FE_SEL_CAL_RX2
  localparam RX_CTRL_SEL_LNA1_SIZE = 1;  //RX_CONTROL:RX_CTRL_SEL_LNA1
  localparam RX_CTRL_SEL_LNA1_MSB  = 9;  //RX_CONTROL:RX_CTRL_SEL_LNA1
  localparam RX_CTRL_SEL_LNA1      = 9;  //RX_CONTROL:RX_CTRL_SEL_LNA1
  localparam RX_CTRL_SEL_LNA2_SIZE =  1;  //RX_CONTROL:RX_CTRL_SEL_LNA2
  localparam RX_CTRL_SEL_LNA2_MSB  = 10;  //RX_CONTROL:RX_CTRL_SEL_LNA2
  localparam RX_CTRL_SEL_LNA2      = 10;  //RX_CONTROL:RX_CTRL_SEL_LNA2
  localparam RX_CTRL_RXLO1_FORCEON_SIZE =  1;  //RX_CONTROL:RX_CTRL_RXLO1_FORCEON
  localparam RX_CTRL_RXLO1_FORCEON_MSB  = 12;  //RX_CONTROL:RX_CTRL_RXLO1_FORCEON
  localparam RX_CTRL_RXLO1_FORCEON      = 12;  //RX_CONTROL:RX_CTRL_RXLO1_FORCEON
  localparam RX_CTRL_RXLO2_FORCEON_SIZE =  1;  //RX_CONTROL:RX_CTRL_RXLO2_FORCEON
  localparam RX_CTRL_RXLO2_FORCEON_MSB  = 13;  //RX_CONTROL:RX_CTRL_RXLO2_FORCEON
  localparam RX_CTRL_RXLO2_FORCEON      = 13;  //RX_CONTROL:RX_CTRL_RXLO2_FORCEON
  localparam RX_CTRL_RXDEMOD_FORCEON_SIZE =  1;  //RX_CONTROL:RX_CTRL_RXDEMOD_FORCEON
  localparam RX_CTRL_RXDEMOD_FORCEON_MSB  = 14;  //RX_CONTROL:RX_CTRL_RXDEMOD_FORCEON
  localparam RX_CTRL_RXDEMOD_FORCEON      = 14;  //RX_CONTROL:RX_CTRL_RXDEMOD_FORCEON
  localparam RX_CTRL_RXMIXER_FORCEON_SIZE =  1;  //RX_CONTROL:RX_CTRL_RXMIXER_FORCEON
  localparam RX_CTRL_RXMIXER_FORCEON_MSB  = 15;  //RX_CONTROL:RX_CTRL_RXMIXER_FORCEON
  localparam RX_CTRL_RXMIXER_FORCEON      = 15;  //RX_CONTROL:RX_CTRL_RXMIXER_FORCEON
  localparam RX_CTRL_RXDRV_FORCEON_SIZE =  1;  //RX_CONTROL:RX_CTRL_RXDRV_FORCEON
  localparam RX_CTRL_RXDRV_FORCEON_MSB  = 16;  //RX_CONTROL:RX_CTRL_RXDRV_FORCEON
  localparam RX_CTRL_RXDRV_FORCEON      = 16;  //RX_CONTROL:RX_CTRL_RXDRV_FORCEON
  localparam RX_CTRL_RXAMP_FORCEON_SIZE =  1;  //RX_CONTROL:RX_CTRL_RXAMP_FORCEON
  localparam RX_CTRL_RXAMP_FORCEON_MSB  = 17;  //RX_CONTROL:RX_CTRL_RXAMP_FORCEON
  localparam RX_CTRL_RXAMP_FORCEON      = 17;  //RX_CONTROL:RX_CTRL_RXAMP_FORCEON
  localparam RX_CTRL_RXLNA1_FORCEON_SIZE =  1;  //RX_CONTROL:RX_CTRL_RXLNA1_FORCEON
  localparam RX_CTRL_RXLNA1_FORCEON_MSB  = 20;  //RX_CONTROL:RX_CTRL_RXLNA1_FORCEON
  localparam RX_CTRL_RXLNA1_FORCEON      = 20;  //RX_CONTROL:RX_CTRL_RXLNA1_FORCEON
  localparam RX_CTRL_RXLNA2_FORCEON_SIZE =  1;  //RX_CONTROL:RX_CTRL_RXLNA2_FORCEON
  localparam RX_CTRL_RXLNA2_FORCEON_MSB  = 21;  //RX_CONTROL:RX_CTRL_RXLNA2_FORCEON
  localparam RX_CTRL_RXLNA2_FORCEON      = 21;  //RX_CONTROL:RX_CTRL_RXLNA2_FORCEON
  localparam RX_CTRL_RXDOUBLER_FORCEON_SIZE =  1;  //RX_CONTROL:RX_CTRL_RXDOUBLER_FORCEON
  localparam RX_CTRL_RXDOUBLER_FORCEON_MSB  = 22;  //RX_CONTROL:RX_CTRL_RXDOUBLER_FORCEON
  localparam RX_CTRL_RXDOUBLER_FORCEON      = 22;  //RX_CONTROL:RX_CTRL_RXDOUBLER_FORCEON

  // REVISION_REGISTER Register
  localparam REVISION_REGISTER = 'h8; // Register Offset
  localparam REVISION_REGISTER_SIZE = 32;  // register width in bits
  localparam REVISION_REGISTER_MASK = 32'hFFFF;
  localparam REVISION_MINOR_SIZE = 8;  //REVISION_REGISTER:REVISION_MINOR
  localparam REVISION_MINOR_MSB  = 7;  //REVISION_REGISTER:REVISION_MINOR
  localparam REVISION_MINOR      = 0;  //REVISION_REGISTER:REVISION_MINOR
  localparam REVISION_MAJOR_SIZE =  8;  //REVISION_REGISTER:REVISION_MAJOR
  localparam REVISION_MAJOR_MSB  = 15;  //REVISION_REGISTER:REVISION_MAJOR
  localparam REVISION_MAJOR      =  8;  //REVISION_REGISTER:REVISION_MAJOR

  // SCRATCH_REGISTER Register
  localparam SCRATCH_REGISTER = 'hC; // Register Offset
  localparam SCRATCH_REGISTER_SIZE = 32;  // register width in bits
  localparam SCRATCH_REGISTER_MASK = 32'hFFFF;
  localparam SCRATCH_DATA_SIZE = 16;  //SCRATCH_REGISTER:SCRATCH_DATA
  localparam SCRATCH_DATA_MSB  = 15;  //SCRATCH_REGISTER:SCRATCH_DATA
  localparam SCRATCH_DATA      =  0;  //SCRATCH_REGISTER:SCRATCH_DATA
